/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.ganttchart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ganttchart.GanttChartModel;
import com.sas.graphics.util.ZxAxisExt;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.CompoundTimeAxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.ganttchart.GanttBarTableModel;
import com.sas.graphics.util.cell.ganttchart.GanttChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericMissingValueReplacement;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.ComplexGanttBox;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.measures.BaseLength;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableModel;

public class GanttChartCell
extends Cell
implements Scrollable {
    public static final String MISSING_VALUE_DISPLAY_TEXT = RB.getStringResource("missingValue.txt");
    public static final int CONTAINED_STYLE_SAS = 0;
    public static final int CONTAINED_STYLE_NONE = 0;
    public static final int CONTAINED_STYLE_ALL = 1;
    public static final int BOX_CONNECTION_STYLE_SAS = 0;
    public static final int BOX_CONNECTION_STYLE_BOX = 0;
    public static final int BOX_CONNECTION_STYLE_INDENT = 1;
    public static final int BOX_CONNECTION_STYLE_LINE = 2;
    public static final int BOX_STYLE_SAS = 4;
    public static final int BOX_STYLE_HALF_BOX = 0;
    public static final int BOX_STYLE_FULL_BOX = 4;
    public static final int BOX_STYLE_SUMMARY = 2;
    public static final int BOX_STYLE_SUMMARY_ALL = 3;
    protected static final int BOX_STYLE_MILESTONE = 1;
    protected static final int BOX_STYLE_FULL_MILESTONE = 5;
    private static final String SELECTION_VAR = "selectionVariable";
    public transient Variable taskVariable = null;
    public transient Variable[] successorVariableArray = null;
    public transient NumericVariable earlyStartVariable = null;
    public transient NumericVariable earlyFinishVariable = null;
    public transient NumericVariable lateStartVariable = null;
    public transient NumericVariable lateFinishVariable = null;
    public transient NumericVariable resourceStartVariable = null;
    public transient NumericVariable resourceFinishVariable = null;
    public transient NumericVariable actualStartVariable = null;
    public transient NumericVariable actualFinishVariable = null;
    public transient NumericVariable custom1StartVariable = null;
    public transient NumericVariable custom1FinishVariable = null;
    public transient NumericVariable custom2StartVariable = null;
    public transient NumericVariable custom2FinishVariable = null;
    public transient NumericVariable baselineStartVariable = null;
    public transient NumericVariable baselineFinishVariable = null;
    public transient NumericVariable durationVariable = null;
    public transient NumericVariable targetVariable = null;
    public transient NumericVariable drawBarVariable = null;
    public transient Variable colorVariable = null;
    public transient Variable styleByVariable = null;
    public transient Variable parentVariable = null;
    public transient Variable descriptionVariable = null;
    public transient Variable[] dataTipVariables = null;
    public transient Variable[] auxiliaryVariables = null;
    public transient Variable selectionVariable = null;
    public transient Variable markerTaskVariable = null;
    public transient Variable markerLocationVariable = null;
    public transient Variable markerPositionVariable = null;
    public transient Variable markerSymbolVariable = null;
    public transient Variable markerTextVariable = null;
    public transient Variable markerSymbolColorVariable = null;
    public transient Variable markerTextColorVariable = null;
    public transient Variable markerTextJustificationVariable = null;
    public transient Variable annoTaskVariable = null;
    public transient Variable annoLocationVariable = null;
    public transient Variable annoPositionVariable = null;
    public transient Variable annoSymbolVariable = null;
    public transient Variable annoTextVariable = null;
    public transient Variable annoSymbolColorVariable = null;
    public transient Variable annoTextColorVariable = null;
    public transient Variable annoTextJustificationVariable = null;
    public transient Variable breaktimeStartVariable = null;
    public transient Variable breaktimeFinishVariable = null;
    public transient Variable breaktimeCalendarVariable = null;
    public transient NumericVariable breaktimeDurationVariable = null;
    public transient Variable calendarVariable = null;
    private transient Object taskRole;
    private transient double daySize = 0.0;
    private boolean sizeChange = false;
    private ComplexGanttBox ganttElement;
    private double originalYPosition;
    private NumericProperty labelYPosition = new NumericProperty();
    private Grid dateGridLines;
    private Grid taskGridLines;
    public int successorVariableCount = 0;
    protected int boxConnectionStyle;
    protected int containedStyle;
    ReferenceLineModel timeNowRefLineModel;
    FillStyle weekendFillStyle;
    public TableAxisModel tableAxisModel = null;
    public Object componentSuccessorVariables = null;
    Dimension margin;
    Rectangle bounds;
    double indepAxisLen;
    AxisModel localTaskAxisModel;
    TableModel tableModel;
    CompoundTimeAxisModel localDateAxisModel;
    double taskAxisLength;
    double dateAxisLength;
    double strideValue;
    double boxSizeAdjustment = 0.25;
    String fmt;
    SASDateTimeFormat fmtInst;
    Grid frame = null;
    int chartVisibleHeight;
    int chartScrollableHeight;
    int chartScrollableWidth;
    int drawX;
    int drawY;
    boolean renderingOptimized;
    transient AxisCellModel localTaskAxisCellModel;
    transient CompoundTimeAxisCellModel localDateAxisCellModel;
    boolean taskAxisVisible;
    boolean dateAxisVisible;
    private transient DataSource scheduleDataSource;
    private transient DataSource annoDataSource;
    private transient DataSource breaktimeDataSource;
    private transient GanttBarTableModel barModel;
    private final transient GanttChartModel ganttChartModel;
    private final transient GanttChartCellModel cellModel;
    private transient StringToNumericMapper IdMapper;
    private final transient ContinuousRangeToNumericMapper dMapper;
    StringPipe taskValue;
    StringPipe calendarValue;
    GTKFormat taskFormat;
    int taskUniqueValueCount;
    double stride;
    boolean scheduleDataSourceChanged = false;
    String newTaskColumnName = null;
    Dimension cachedPreferredSize = null;
    private int maxUnitIncrement = 1;

    public GanttChartCell(GanttChartCellModel newCellModel, DataSource[] dataSource, Channel channel) {
        super(newCellModel, channel);
        TableModel tm;
        this.setDoubleBufferPolicy(10202);
        this.cellModel = newCellModel;
        this.ganttChartModel = newCellModel.getGanttChartModel();
        this.scheduleDataSource = dataSource[0];
        this.annoDataSource = dataSource[1];
        this.breaktimeDataSource = dataSource[2];
        if (this.scheduleDataSource.getVariable(this.cellModel.getReplaceWithChildrenRole(), 0) != null && this.scheduleDataSource.getVariable(this.cellModel.getReplaceWithChildrenRole(), 0).getColumnName() != null && this.scheduleDataSource.getVariable(this.cellModel.getTaskRole(), 0) != null && this.scheduleDataSource.getVariable(this.cellModel.getTaskRole(), 0).getColumnName() != null && this.scheduleDataSource.getVariable(this.cellModel.getParentRole(), 0) != null && this.scheduleDataSource.getVariable(this.cellModel.getParentRole(), 0).getColumnName() != null && (tm = (TableModel)this.scheduleDataSource.getRootDataSource().getModel()) instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)tm;
            String taskVarName = this.scheduleDataSource.getVariable(this.cellModel.getTaskRole(), 0).getColumnName();
            String parentVarName = this.scheduleDataSource.getVariable(this.cellModel.getParentRole(), 0).getColumnName();
            String multiVarName = this.scheduleDataSource.getVariable(this.cellModel.getReplaceWithChildrenRole(), 0).getColumnName();
            int taskColIdx = -1;
            int parentColIdx = -1;
            int multiColIdx = -1;
            for (int i = 0; i < ttm.getColumnCount() && (taskColIdx == -1 || parentColIdx == -1 || multiColIdx == -1); ++i) {
                if (taskColIdx == -1 && ttm.getColumnName(i).equals(taskVarName)) {
                    taskColIdx = i;
                }
                if (parentColIdx == -1 && ttm.getColumnName(i).equals(parentVarName)) {
                    parentColIdx = i;
                }
                if (multiColIdx != -1 || !ttm.getColumnName(i).equals(multiVarName)) continue;
                multiColIdx = i;
            }
            if (taskColIdx > -1 && parentColIdx > -1 && multiColIdx > -1) {
                DefaultListSelectionModel scheduleDataSourceSelectionModel = new DefaultListSelectionModel();
                this.newTaskColumnName = taskVarName + "_2";
                this.barModel = new GanttBarTableModel(ttm, parentColIdx, taskColIdx, multiColIdx, this.newTaskColumnName, ((TreeTable)this.cellModel.getTable()).getSelectionModel(), scheduleDataSourceSelectionModel);
                TableModelVariableFactory f = new TableModelVariableFactory(this.barModel);
                this.scheduleDataSource = new DataSource(this.scheduleDataSource, f);
                this.scheduleDataSourceChanged = true;
                this.scheduleDataSource.setSelectionModel(scheduleDataSourceSelectionModel, false);
                SelectionVariableDefinition selectionVariableDefinition = new SelectionVariableDefinition(scheduleDataSourceSelectionModel, null, 0);
                Util.setVariableDefinition(this.scheduleDataSource, SELECTION_VAR, null, null, selectionVariableDefinition, !this.ganttChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED));
            }
        }
        this.setAntiAliasingEnabled(this.cellModel.getGanttChartModel().isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(this.cellModel.getGanttChartModel().isAntialiasedText());
        this.componentSuccessorVariables = this.cellModel.getSuccesorVariables();
        this.tableAxisModel = this.cellModel.getTableAxisModel();
        this.setConnectionStyle(0);
        this.setContainedStyle(0);
        this.taskRole = this.cellModel.getTaskRole();
        this.taskVariable = this.scheduleDataSource.getVariable(this.taskRole, 0);
        this.taskUniqueValueCount = this.taskVariable.getUniqueValueCount();
        if (this.taskVariable instanceof StringVariable) {
            this.taskValue = ((StringVariable)this.taskVariable).value;
        } else {
            StringVariable tv = new StringVariable();
            tv.connectFrom((NumericVariable)this.taskVariable);
            this.taskValue = tv.value;
        }
        this.taskFormat = this.taskVariable instanceof StringVariable ? ((StringVariable)this.taskVariable).getFormat() : (this.taskVariable instanceof NumericVariable ? ((NumericVariable)this.taskVariable).getFormat() : null);
        this.earlyStartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getEarlyStartRole(), 0));
        this.earlyFinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getEarlyFinishRole(), 0));
        this.lateStartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getLateStartRole(), 0));
        this.lateFinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getLateFinishRole(), 0));
        this.resourceStartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getResourceStartRole(), 0));
        this.resourceFinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getResourceFinishRole(), 0));
        this.actualStartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getActualStartRole(), 0));
        this.actualFinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getActualFinishRole(), 0));
        this.custom1StartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getCustom1StartRole(), 0));
        this.custom1FinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getCustom1FinishRole(), 0));
        this.custom2StartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getCustom2StartRole(), 0));
        this.custom2FinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getCustom2FinishRole(), 0));
        this.baselineStartVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getBaselineStartRole(), 0));
        this.baselineFinishVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getBaselineFinishRole(), 0));
        this.durationVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getDurationRole(), 0));
        this.targetVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getTargetRole(), 0));
        this.drawBarVariable = this._makeNumericVariable(this.scheduleDataSource.getVariable(this.cellModel.getDrawBarRole(), 0));
        this.descriptionVariable = this.scheduleDataSource.getVariable(this.cellModel.getDescriptionRole(), 0);
        this.parentVariable = this.scheduleDataSource.getVariable(this.cellModel.getParentRole(), 0);
        this.selectionVariable = this.scheduleDataSource.getVariable(this.cellModel.getSelectionRole(), 0);
        this.colorVariable = this.scheduleDataSource.getVariable(this.cellModel.getColorRole(), 0);
        this.styleByVariable = this.scheduleDataSource.getVariable(this.cellModel.getStyleByRole(), 0);
        this.markerTaskVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerTaskRole(), 0);
        this.markerLocationVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerLocationRole(), 0);
        this.markerPositionVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerPositionRole(), 0);
        this.markerSymbolVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerSymbolRole(), 0);
        this.markerTextVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerTextRole(), 0);
        this.markerSymbolColorVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerSymbolColorRole(), 0);
        this.markerTextColorVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerTextColorRole(), 0);
        this.markerTextJustificationVariable = this.scheduleDataSource.getVariable(this.cellModel.getMarkerTextJustificationRole(), 0);
        if (this.annoDataSource != null) {
            this.annoTaskVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoTaskRole(), 0);
            this.annoLocationVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoLocationRole(), 0);
            this.annoPositionVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoPositionRole(), 0);
            this.annoSymbolVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoSymbolRole(), 0);
            this.annoTextVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoTextRole(), 0);
            this.annoSymbolColorVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoSymbolColorRole(), 0);
            this.annoTextColorVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoTextColorRole(), 0);
            this.annoTextJustificationVariable = this.annoDataSource.getVariable(this.cellModel.getAnnoTextJustificationRole(), 0);
        }
        if (this.breaktimeDataSource != null) {
            this.breaktimeStartVariable = this.breaktimeDataSource.getVariable(this.cellModel.getBreaktimeStartRole(), 0);
            this.breaktimeFinishVariable = this.breaktimeDataSource.getVariable(this.cellModel.getBreaktimeFinishRole(), 0);
            this.breaktimeCalendarVariable = this.breaktimeDataSource.getVariable(this.cellModel.getBreaktimeCalendarRole(), 0);
            this.breaktimeDurationVariable = this._makeNumericVariable(this.breaktimeDataSource.getVariable(this.cellModel.getBreaktimeDurationRole(), 0));
            this.calendarVariable = this.scheduleDataSource.getVariable(this.cellModel.getCalendarRole(), 0);
            if (this.calendarVariable != null && this.calendarVariable.isConnected()) {
                if (this.calendarVariable instanceof StringVariable) {
                    this.calendarValue = ((StringVariable)this.calendarVariable).value;
                } else {
                    StringVariable cv = new StringVariable();
                    cv.connectFrom((NumericVariable)this.calendarVariable);
                    this.calendarValue = cv.value;
                }
            }
        }
        this._findDateVariableFormat();
        String dataTipRole = (String)this.cellModel.getDataTipRole();
        int dataTipLen = 0;
        while (this.scheduleDataSource.getVariable(dataTipRole + dataTipLen++) != null) {
        }
        if (--dataTipLen > 0) {
            this.dataTipVariables = new Variable[dataTipLen];
            for (int ii = 0; ii < this.dataTipVariables.length; ++ii) {
                this.dataTipVariables[ii] = this.scheduleDataSource.getVariable(dataTipRole + ii, 0);
            }
        }
        String auxiliaryRole = (String)this.cellModel.getAuxiliaryRole();
        int auxLen = 0;
        while (this.scheduleDataSource.getVariable(auxiliaryRole + auxLen++) != null) {
        }
        if (--auxLen > 0) {
            this.auxiliaryVariables = new Variable[auxLen];
            for (int ii = 0; ii < this.auxiliaryVariables.length; ++ii) {
                this.auxiliaryVariables[ii] = this.scheduleDataSource.getVariable(auxiliaryRole + ii, 0);
            }
        }
        this.successorVariableArray = this.scheduleDataSource.getVariable(this.cellModel.getSuccessorRole());
        this.successorVariableCount = this.successorVariableArray == null ? 0 : this.successorVariableArray.length;
        AxisModel indepAxisModel = this.cellModel.getIndependentAxisCellModel().getAxisModel();
        CompoundTimeAxisModel depAxisModel = this.cellModel.getDependentAxisCellModel().getTimeAxisModel();
        this.taskAxisVisible = this.cellModel.getIndepAxisVisible() != false && indepAxisModel.isVisible();
        this.dateAxisVisible = this.cellModel.getDepAxisVisible() != false && depAxisModel.isVisible();
        this.setSelectionModel(this.scheduleDataSource.getDataSourceSelectionModel());
        this.IdMapper = new StringToNumericMapper();
        this.IdMapper.input.connectFrom(this.taskValue);
        this.IdMapper.setLabelMissingValues(true);
        this.IdMapper.setMissingValueLabel(MISSING_VALUE_DISPLAY_TEXT);
        AxisCellModel ancestor = this.cellModel.getIndependentAxisCellModel();
        this.localTaskAxisCellModel = new AxisCellModel(null, ancestor);
        this.localTaskAxisCellModel.setMapper((NumericMapper)this.IdMapper);
        this.localTaskAxisCellModel.setMaximizeSpace(Boolean.FALSE);
        this.localTaskAxisCellModel.setExtendToMargin(Boolean.TRUE);
        if (ancestor.getAxisVisible().booleanValue()) {
            this.localTaskAxisCellModel.computeParameters(this.getChannel());
        } else {
            StringToNumericMapper snm = (StringToNumericMapper)ancestor.getMapper();
            this.IdMapper.setStartValue(snm.getStartValue());
            this.IdMapper.setStrideValue(snm.getStrideValue());
            this.localTaskAxisCellModel.setMargin(ancestor.getMargin());
            this.localTaskAxisCellModel.setLength(ancestor.getLength());
            this.localTaskAxisCellModel.setPreferredLength(ancestor.getPreferredLength());
            this.localTaskAxisCellModel.setIdealPreferredLength(ancestor.getIdealPreferredLength());
        }
        Insets outerMargin = this.cellModel.getOuterMargin();
        int resAxisAdj = this.localTaskAxisCellModel.getResAxisAdj().intValue();
        if (resAxisAdj > outerMargin.left) {
            outerMargin.left = resAxisAdj;
            ancestor.setResAxisAdj(new Double(outerMargin.left));
        }
        this.localTaskAxisCellModel.setResAxisAdj(null);
        this.localTaskAxisCellModel.setMapper((NumericMapper)this.IdMapper);
        this.localTaskAxisCellModel.setValueCount(new Integer(this.taskUniqueValueCount));
        this.localTaskAxisModel = this.localTaskAxisCellModel.getAxisModel();
        ancestor.setMapper((NumericMapper)this.IdMapper);
        ancestor = this.cellModel.getDependentAxisCellModel();
        this.localDateAxisCellModel = this.cellModel.getLocalDateAxisCellModel();
        this.dMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper dependentAxisMapper = (ContinuousRangeToNumericMapper)this.localDateAxisCellModel.getMapper();
        this.dMapper.setFormat(dependentAxisMapper.getFormat());
        this.dMapper.setInputMin(dependentAxisMapper.getInputMin());
        this.dMapper.setInputMax(dependentAxisMapper.getInputMax());
        this.dMapper.shareMap(dependentAxisMapper);
        int catAxisAdj = this.localDateAxisCellModel.getCatAxisAdj().intValue();
        if (catAxisAdj > outerMargin.top) {
            outerMargin.top = catAxisAdj;
            ancestor.setCatAxisAdj(new Double(outerMargin.top));
        }
        this.localDateAxisCellModel.setCatAxisAdj(null);
        this.localDateAxisCellModel.setMapper((NumericMapper)this.dMapper);
        this.localDateAxisCellModel.computeParameters(this.getChannel());
        this.localDateAxisModel = this.localDateAxisCellModel.getTimeAxisModel();
        ancestor.setMapper((NumericMapper)this.dMapper);
        this.timeNowRefLineModel = null;
        if (this.ganttChartModel.getTimeNowReferenceLineModel() != null) {
            this.timeNowRefLineModel = new ReferenceLineModel();
            this.timeNowRefLineModel.apply(this.ganttChartModel.getTimeNowReferenceLineModel());
            double position = Double.NaN;
            try {
                position = Util.getPositionValue(this.earlyStartVariable, this.timeNowRefLineModel);
            }
            catch (MissingValueException e) {
                position = Double.NaN;
            }
            this.timeNowRefLineModel.setPosition(position);
            if (!Double.isNaN(position) && (position < this.dMapper.getInputMin() || position > this.dMapper.getInputMax())) {
                this.timeNowRefLineModel.setVisible(false);
                this.timeNowRefLineModel.setPosition(Double.NaN);
            }
        }
        this.weekendFillStyle = depAxisModel.getWeekendBandFillStyle();
        this.renderingOptimized = true;
        Util.Events.MouseEventListenerRecasterFactory mlf = this.cellModel.getMouseEventListenerRecasterFactory();
        if (mlf != null) {
            this.addMouseListener(mlf.newMouseListener());
            this.addMouseMotionListener(mlf.newMouseMotionListener());
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.scheduleDataSource;
    }

    @Override
    protected synchronized void construct() {
        if (this.scheduleDataSource == null) {
            return;
        }
        this.bounds = this.getBounds();
        if (this.earlyStartVariable != null && this.earlyFinishVariable != null || this.actualStartVariable != null && this.actualFinishVariable != null || this.resourceStartVariable != null && this.resourceFinishVariable != null || this.custom1StartVariable != null && this.custom1FinishVariable != null || this.custom2StartVariable != null && this.custom2FinishVariable != null || this.baselineStartVariable != null && this.baselineFinishVariable != null) {
            this.ganttElement = new ComplexGanttBox();
            Util.SelectInfo.selectEnable((Element)this.ganttElement, null, 3);
            this.stride = this.IdMapper.getStrideValue();
            if (this.stride == 0.0) {
                this.stride = this.cellModel.getIndependentAxisCellModel().getMargin().height * 2;
            }
            this.strideValue = this.stride;
            if (this.stride < 0.0) {
                this.stride = -this.stride;
            }
            this.ganttElement.boxThickness.setValue(this.stride);
            boolean showConnectingLines = true;
            LineStyle connectingLines = this.ganttChartModel.getDataElementStyles().getConnectingLineStyle();
            if (connectingLines != null && connectingLines.getVisibilityPolicy() == 10202) {
                showConnectingLines = false;
            }
            if (this.successorVariableArray != null && showConnectingLines) {
                for (int ii = 0; ii < this.successorVariableCount; ++ii) {
                    if (this.successorVariableArray[ii] instanceof StringVariable) {
                        this.ganttElement.addSuccessorPipe(((StringVariable)this.successorVariableArray[ii]).value);
                        continue;
                    }
                    if (!(this.successorVariableArray[ii] instanceof NumericVariable)) continue;
                    this.ganttElement.addSuccessorPipe(((NumericVariable)this.successorVariableArray[ii]).formattedValue);
                }
            }
            this.ganttElement.task.connectFrom(this.taskValue);
            if (this.calendarValue != null) {
                this.ganttElement.calendar.connectFrom(this.calendarValue);
            }
            this.margin = new Dimension(this.localDateAxisCellModel.getMargin().width, this.localTaskAxisCellModel.getMargin().height);
            this._getAxisLengths();
            double constant = 1.0;
            this._addVariablePipes(constant);
            this._addAnnotationPipes();
            this._addBreaktimePipes(constant);
            this._setBoxColors();
            if (this.cellModel.getColorMapper() != null) {
                StringToColorMapper cm = (StringToColorMapper)this.cellModel.getColorMapper();
                if (this.scheduleDataSourceChanged) {
                    StringPipe sbValue;
                    if (this.styleByVariable instanceof StringVariable) {
                        sbValue = ((StringVariable)this.styleByVariable).formattedValue;
                    } else {
                        StringVariable tv = new StringVariable();
                        tv.connectFrom((NumericVariable)this.styleByVariable);
                        sbValue = tv.formattedValue;
                    }
                    cm.input.connectFrom(sbValue);
                }
                this.ganttElement.normalColor.connectFrom(cm.value);
                this.ganttElement.criticalColor.connectFrom(cm.value);
                this.ganttElement.slackColor.connectFrom(cm.value);
            }
            this._addAxisWall();
            this._setFrameAttributes();
            this._addGridLines(false);
            this._addVertRefLines(false);
            this.ganttElement.boxConnectionStyle.setValue(this.boxConnectionStyle);
            this.getComposite().addElement((Element)this.ganttElement);
            this._addGridLines(true);
            this._addVertRefLines(true);
            this._setClippingBounds();
            if (this.frame != null) {
                this.getComposite().addElement((Element)this.frame);
            }
            this.getComposite().transform.translateX.setValue((double)this.margin.width);
            this.getComposite().transform.translateY.setValue((double)(-this.margin.height));
        }
        try {
            this.ganttElement.preProcess();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        if (this.barModel != null) {
            this.barModel.dispose();
            this.barModel = null;
        }
        this.taskVariable = null;
        this.successorVariableArray = null;
        this.earlyStartVariable = null;
        this.earlyFinishVariable = null;
        this.custom1StartVariable = null;
        this.custom1FinishVariable = null;
        this.custom2StartVariable = null;
        this.custom2FinishVariable = null;
        this.lateStartVariable = null;
        this.lateFinishVariable = null;
        this.resourceStartVariable = null;
        this.resourceFinishVariable = null;
        this.actualStartVariable = null;
        this.actualFinishVariable = null;
        this.baselineStartVariable = null;
        this.baselineFinishVariable = null;
        this.durationVariable = null;
        this.targetVariable = null;
        this.drawBarVariable = null;
        this.colorVariable = null;
        this.styleByVariable = null;
        this.parentVariable = null;
        this.descriptionVariable = null;
        this.dataTipVariables = null;
        this.auxiliaryVariables = null;
        this.selectionVariable = null;
        this.markerTaskVariable = null;
        this.markerLocationVariable = null;
        this.markerPositionVariable = null;
        this.markerSymbolVariable = null;
        this.markerTextVariable = null;
        this.markerSymbolColorVariable = null;
        this.markerTextColorVariable = null;
        this.markerTextJustificationVariable = null;
        this.annoTaskVariable = null;
        this.annoLocationVariable = null;
        this.annoPositionVariable = null;
        this.annoSymbolVariable = null;
        this.annoTextVariable = null;
        this.annoSymbolColorVariable = null;
        this.annoTextColorVariable = null;
        this.annoTextJustificationVariable = null;
        this.breaktimeStartVariable = null;
        this.breaktimeFinishVariable = null;
        this.breaktimeCalendarVariable = null;
        this.breaktimeDurationVariable = null;
        this.calendarVariable = null;
        super.dispose();
    }

    private void _addWeekendBands(double yAxisLength, boolean dAxisVisible) {
        double min = this.dMapper.getInputMin();
        double max = this.dMapper.getInputMax();
        double[] weekends = ZxAxisExt.getWeekends((double)min, (double)max, (SASFormat)this.fmtInst);
        double d = this.daySize = this.localDateAxisCellModel.isDateValue() ? 1.0 : 86400.0;
        if (weekends != null) {
            boolean oneDayFirst = false;
            if (weekends[0] == Double.NaN) {
                oneDayFirst = true;
            }
            boolean oneDayLast = false;
            for (int ii = 0; ii < weekends.length; ++ii) {
                if (oneDayFirst) {
                    this._addBandReferences(weekends[++ii], weekends[ii], this.dMapper, yAxisLength, dAxisVisible, this.weekendFillStyle, null, null);
                    oneDayFirst = false;
                    continue;
                }
                if (ii + 1 >= weekends.length) {
                    oneDayLast = true;
                }
                if (oneDayLast) {
                    this._addBandReferences(weekends[ii], weekends[ii], this.dMapper, yAxisLength, dAxisVisible, this.weekendFillStyle, null, null);
                    continue;
                }
                this._addBandReferences(weekends[ii], weekends[++ii], this.dMapper, yAxisLength, dAxisVisible, this.weekendFillStyle, null, null);
            }
        }
    }

    private void _addHolidayBands(double yAxisLength, boolean dAxisVisible) {
        ReferenceBandModel[] holidays = this.localDateAxisModel.getReferenceBandModels();
        double d = this.daySize = this.localDateAxisCellModel.isDateValue() ? 1.0 : 0.0;
        if (holidays != null) {
            for (int mm = 0; mm < holidays.length; ++mm) {
                ReferenceLineModel endLine;
                if (holidays[mm] == null || !holidays[mm].isVisible()) continue;
                ReferenceLineModel beginLine = holidays[mm].getBeginReferenceLineModel() == null ? null : holidays[mm].getBeginReferenceLineModel();
                ReferenceLineModel referenceLineModel = endLine = holidays[mm].getEndReferenceLineModel() == null ? null : holidays[mm].getEndReferenceLineModel();
                if (beginLine == null || endLine == null || Double.isNaN(beginLine.getPosition())) continue;
                if (Double.isNaN(endLine.getPosition())) {
                    this._addBandReferences(beginLine.getPosition(), beginLine.getPosition(), this.dMapper, yAxisLength, dAxisVisible, holidays[mm].getFillStyle(), beginLine, endLine);
                    continue;
                }
                this._addBandReferences(beginLine.getPosition(), endLine.getPosition(), this.dMapper, yAxisLength, dAxisVisible, holidays[mm].getFillStyle(), beginLine, endLine);
            }
        }
    }

    public int getTaskUniqueValueCount() {
        return this.taskUniqueValueCount;
    }

    @Override
    public void reconstruct() {
        if (this.sizeChange) {
            super.reconstruct();
            this.sizeChange = false;
        }
    }

    private void _addBandReferences(double firstDay, double secondDay, ContinuousRangeToNumericMapper mapper, double length, boolean axisVisible, FillStyle fillStyle, ReferenceLineModel firstLine, ReferenceLineModel secondLine) {
        if (firstDay <= 0.0 || secondDay <= 0.0) {
            return;
        }
        double[] boxLoc = new double[]{mapper.getValue(firstDay), mapper.getValue(secondDay + this.daySize)};
        Bar newBar = new Bar();
        newBar.verticalOn.setValue(false);
        newBar.position.setValue(this.localTaskAxisCellModel.getLength() * 0.5 + this.stride * 0.5);
        newBar.thickness.setValue(length);
        newBar.startValue.setValue(boxLoc[0]);
        newBar.endValue.setValue(boxLoc[1]);
        GanttChartCell._applyFillStyle(newBar, fillStyle);
        newBar.selectEnabled.setValue(false);
        newBar.edgeOn.setValue(false);
        newBar.edgeColor.setValue(Color.GRAY);
        this.getComposite().addElement((Element)newBar);
        double[] vertPos = new double[]{(double)(-this.margin.height) + this.stride, this.taskAxisLength - (double)this.margin.height + this.stride};
        if (firstLine != null && firstLine.getLineStyle() != null && firstLine.getLineStyle().getVisibilityPolicy() != 10202) {
            this._addVertReferenceLine(firstLine, this.dMapper, this.margin.width, vertPos, true, axisVisible, null);
        }
        if (secondLine != null && secondLine.getLineStyle() != null && secondLine.getLineStyle().getVisibilityPolicy() != 10202) {
            ReferenceLineModel ref = new ReferenceLineModel();
            ref.apply(secondLine);
            ref.setPosition(secondDay + this.daySize);
            this._addVertReferenceLine(ref, this.dMapper, this.margin.width, vertPos, true, axisVisible, null);
        }
    }

    private static void _applyFillStyle(Bar bar, FillStyle fillStyle) {
        bar.fillOn.setValue(fillStyle.isVisible());
        if (fillStyle.isVisible()) {
            int fillType = fillStyle.getFillType();
            bar.color1.setValue(fillStyle.getSolidFillColor());
            boolean gradientFillEnabled = fillType == 20001 || fillType == 20004;
            bar.gradientOn.setValue(gradientFillEnabled);
            if (gradientFillEnabled) {
                switch (fillStyle.getGradientFill()) {
                    default: {
                        bar.gradientDirection.setValue(1);
                        break;
                    }
                    case 20104: {
                        bar.gradientDirection.setValue(3);
                        break;
                    }
                    case 20103: {
                        bar.gradientDirection.setValue(2);
                        break;
                    }
                    case 20100: {
                        bar.gradientDirection.setValue(0);
                    }
                }
                if (fillStyle.getGradientFill() == 20101) {
                    bar.color1.setValue(fillStyle.getGradientFillEndColor());
                    bar.color2.setValue(fillStyle.getGradientFillBeginColor());
                } else {
                    bar.color1.setValue(fillStyle.getGradientFillBeginColor());
                    bar.color2.setValue(fillStyle.getGradientFillEndColor());
                }
            }
            boolean imageFillEnabled = fillStyle.getImageIcon() != null && fillStyle.getImageIcon().getImage() != null && fillStyle.getImageIcon().getIconHeight() > 0 && (fillType == 20002 || fillType == 20003 || fillType == 20004);
            bar.textureOn.setValue(imageFillEnabled);
            if (imageFillEnabled) {
                bar.textureMode.setValue(fillType == 20003 ? 3 : 2);
                bar.textureStyle.setValue(fillStyle.getImageFill() == 20200 ? 4 : 5);
                bar.setTextureImage(new BufferedImage[]{Bar.convertImageToBufferedImage((Image)fillStyle.getImageIcon().getImage())});
                bar.textureIndex.setValue(0);
                if (fillType == 20003) {
                    bar.color1.setValue(fillStyle.getSolidBlendColor());
                } else if (fillType == 20004) {
                    if (fillStyle.getGradientFill() == 20101) {
                        bar.color1.setValue(fillStyle.getGradientBlendEndColor());
                        bar.color2.setValue(fillStyle.getGradientBlendBeginColor());
                    } else {
                        bar.color1.setValue(fillStyle.getGradientBlendBeginColor());
                        bar.color2.setValue(fillStyle.getGradientBlendEndColor());
                    }
                }
            }
        }
    }

    public void setConnectionStyle(int boxConnectionStyle) {
        switch (boxConnectionStyle) {
            case 0: 
            case 1: 
            case 2: {
                this.boxConnectionStyle = boxConnectionStyle;
            }
        }
    }

    public int getConnectionStyle() {
        return this.boxConnectionStyle;
    }

    public void setContainedStyle(int containedStyle) {
        switch (containedStyle) {
            case 0: 
            case 1: {
                this.containedStyle = containedStyle;
            }
        }
    }

    public int getContainedStyle() {
        return this.containedStyle;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize != null) {
            return this.cachedPreferredSize;
        }
        this.cachedPreferredSize = this._getPreferredSize();
        return this.cachedPreferredSize == null ? super.getPreferredSize() : this.cachedPreferredSize;
    }

    private Dimension _getPreferredSize() {
        if (this.taskVariable != null && this.localTaskAxisCellModel != null && this.localDateAxisCellModel != null) {
            int catAxisAdj = this.localDateAxisCellModel.getAxisVisible() != false ? this.localTaskAxisCellModel.getCatAxisAdj().intValue() : 0;
            Dimension margin = this.localTaskAxisCellModel.getMargin();
            int h = (int)this.localTaskAxisCellModel.getIdealPreferredLength().doubleValue() + 2 * margin.height + catAxisAdj;
            int resAxisAdj = this.localTaskAxisCellModel.getAxisVisible() != false ? this.localDateAxisCellModel.getResAxisAdj().intValue() : 0;
            int w = this.localDateAxisCellModel.getPreferredLength().intValue() + 2 * margin.width + resAxisAdj;
            return new Dimension(w, h);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isRenderingOptimized() {
        return this.renderingOptimized;
    }

    public void setRenderingOptimized(boolean optimized) {
        this.renderingOptimized = optimized;
        this._setClippingBounds();
    }

    private void _setClippingBounds() {
        int yEnd;
        int yStart;
        this.drawX = this.getVisibleBounds().x;
        this.drawY = this.getVisibleBounds().y;
        if (this.drawY < 0) {
            this.drawY = -this.drawY;
        }
        int aLittleExtra = 20;
        this.chartVisibleHeight = this.getVisibleBounds().height + aLittleExtra;
        this.chartScrollableHeight = this.getBounds().height;
        this.chartScrollableWidth = this.getBounds().width;
        if (this.renderingOptimized) {
            yStart = this.chartScrollableHeight - this.drawY;
            yEnd = yStart - (this.chartVisibleHeight + (int)this.stride * 2);
        } else {
            yStart = this.chartScrollableHeight;
            yEnd = 0;
        }
        if (this.ganttElement != null) {
            this.ganttElement.yStart.setValue(yStart);
            this.ganttElement.yEnd.setValue(yEnd);
            this.ganttElement.xEnd.setValue(this.chartScrollableWidth);
        }
        if (this.taskGridLines != null) {
            this.taskGridLines.yClipStart.setValue((double)yEnd);
            this.taskGridLines.yClipEnd.setValue((double)yStart);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.bounds == null || width != this.bounds.width || height != this.bounds.height) {
            this.sizeChange = true;
        }
        super.setBounds(x, y, width, height);
        this.bounds = this.getBounds();
    }

    @Override
    public void setVisibleBounds(Rectangle bounds) {
        if (bounds != null) {
            super.setVisibleBounds(bounds);
            this._setClippingBounds();
        }
    }

    private void _addVariablePipes(double constant) {
        ContinuousRangeToNumericMapper lateFinishMapper;
        ContinuousRangeToNumericMapper lateStartMapper;
        ContinuousRangeToNumericMapper earlyFinishMapper;
        ContinuousRangeToNumericMapper earlyStartMapper;
        Calculator c = new Calculator("inA + inB");
        c.inA.connectFrom((NumericPipe)this.IdMapper);
        c.inB.setValue(this.strideValue * this.boxSizeAdjustment);
        this.ganttElement.transform.translateY.connectFrom((NumericPipe)c);
        this.ganttElement.boxSizeAdjustment.setValue(this.boxSizeAdjustment);
        if (this.showSlackTime()) {
            if (this.earlyStartVariable != null && this.earlyFinishVariable != null) {
                this.ganttElement.ganttBoxVisible.setValue(this.ganttChartModel.isGanttBarEnabled());
                this.ganttElement.slackTimeVisible.setValue(this.ganttChartModel.isSlackTimeEnabled());
                earlyStartMapper = this._createMapper((Variable)this.earlyStartVariable, this.dMapper);
                earlyFinishMapper = this._createMapper((Variable)this.earlyFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                this.ganttElement.earlyStart.connectFrom(earlyStartMapper.value);
                this.ganttElement.earlyFinish.connectFrom(earlyFinishMapper.value);
                if (this.lateStartVariable != null && this.lateFinishVariable != null) {
                    lateStartMapper = this._createMapper((Variable)this.lateStartVariable, this.dMapper);
                    lateFinishMapper = this._createMapper((Variable)this.lateFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                    this.ganttElement.lateStart.connectFrom(lateStartMapper.value);
                    this.ganttElement.lateFinish.connectFrom(lateFinishMapper.value);
                } else {
                    lateStartMapper = this._createMapper((Variable)this.earlyStartVariable, this.dMapper);
                    lateFinishMapper = this._createMapper((Variable)this.earlyFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                    this.ganttElement.lateStart.connectFrom(lateStartMapper.value);
                    this.ganttElement.lateFinish.connectFrom(lateFinishMapper.value);
                }
            } else if (this.lateStartVariable != null && this.lateFinishVariable != null && this.ganttChartModel.isGanttBarEnabled()) {
                this.ganttElement.ganttBoxVisible.setValue(this.ganttChartModel.isGanttBarEnabled());
                ContinuousRangeToNumericMapper lateStartMapper2 = this._createMapper((Variable)this.lateStartVariable, this.dMapper);
                ContinuousRangeToNumericMapper lateFinishMapper2 = this._createMapper((Variable)this.lateFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                this.ganttElement.lateStart.connectFrom(lateStartMapper2.value);
                this.ganttElement.lateFinish.connectFrom(lateFinishMapper2.value);
                ContinuousRangeToNumericMapper earlyStartMapper2 = this._createMapper((Variable)this.lateStartVariable, this.dMapper);
                ContinuousRangeToNumericMapper earlyFinishMapper2 = this._createMapper((Variable)this.lateFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                this.ganttElement.earlyStart.connectFrom(earlyStartMapper2.value);
                this.ganttElement.earlyFinish.connectFrom(earlyFinishMapper2.value);
            }
        } else if (this.earlyStartVariable != null && this.earlyFinishVariable != null) {
            this.ganttElement.ganttBoxVisible.setValue(this.ganttChartModel.isGanttBarEnabled());
            this.ganttElement.slackTimeVisible.setValue(this.ganttChartModel.isSlackTimeEnabled());
            earlyStartMapper = this._createMapper((Variable)this.earlyStartVariable, this.dMapper);
            earlyFinishMapper = this._createMapper((Variable)this.earlyFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
            this.ganttElement.earlyStart.connectFrom(earlyStartMapper.value);
            this.ganttElement.earlyFinish.connectFrom(earlyFinishMapper.value);
            if (this.showSlackTime()) {
                lateStartMapper = null;
                lateFinishMapper = null;
                if (this.lateStartVariable != null && this.lateFinishVariable != null) {
                    lateStartMapper = this._createMapper((Variable)this.lateStartVariable, this.dMapper);
                    lateFinishMapper = this._createMapper((Variable)this.lateFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                } else {
                    lateStartMapper = this._createMapper((Variable)this.earlyStartVariable, this.dMapper);
                    lateFinishMapper = this._createMapper((Variable)this.earlyFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
                }
                this.ganttElement.lateStart.connectFrom(lateStartMapper.value);
                this.ganttElement.lateFinish.connectFrom(lateFinishMapper.value);
            }
        }
        if (this.actualStartVariable != null && this.actualFinishVariable != null && this.ganttChartModel.isActualBarEnabled()) {
            double timeNow;
            this.ganttElement.actualBoxVisible.setValue(this.ganttChartModel.isActualBarEnabled());
            ContinuousRangeToNumericMapper actualStartMapper = this._createMapper((Variable)this.actualStartVariable, this.dMapper);
            ContinuousRangeToNumericMapper actualFinishMapper = new ContinuousRangeToNumericMapper();
            actualFinishMapper.shareMap(this.dMapper);
            Calculator cal = null;
            if (this.durationVariable != null) {
                cal = this._createCalculator((Variable)this.actualFinishVariable, (Variable)this.durationVariable, constant);
            }
            if (this.timeNowRefLineModel != null && !Double.isNaN(this.timeNowRefLineModel.getPosition())) {
                timeNow = this.timeNowRefLineModel.getPosition();
            } else {
                timeNow = Math.max(this.actualFinishVariable.getMax(), this.actualStartVariable.getMax());
                if (cal != null) {
                    boolean isMilestone = true;
                    Double actualStartValue = null;
                    Double actualFinishValue = null;
                    NumericPipe actualStartValuePipe = null;
                    NumericPipe actualFinishValuePipe = null;
                    if (this.actualFinishVariable.getMax() == this.actualStartVariable.getMax()) {
                        actualFinishValuePipe = this.actualFinishVariable.value;
                        actualStartValuePipe = this.actualStartVariable.value;
                        double max = this.actualFinishVariable.getMax();
                        for (int ii = 0; ii < this.actualFinishVariable.getValueCount(); ++ii) {
                            try {
                                actualFinishValue = new Double(actualFinishValuePipe.getValue(ii));
                            }
                            catch (MissingValueException e) {
                                actualFinishValue = new Double(e.getMissingValue().getDoubleValue());
                            }
                            if (max != actualFinishValue) continue;
                            try {
                                actualStartValue = new Double(actualStartValuePipe.getValue(ii));
                            }
                            catch (MissingValueException e) {
                                actualStartValue = new Double(e.getMissingValue().getDoubleValue());
                            }
                            if (actualStartValue == max) continue;
                            isMilestone = false;
                        }
                    } else {
                        isMilestone = false;
                    }
                    if (!isMilestone) {
                        timeNow += constant;
                    }
                }
            }
            if (this.timeNowRefLineModel != null) {
                this.timeNowRefLineModel.setPosition(timeNow);
            }
            if (this.timeNowRefLineModel != null) {
                this.timeNowRefLineModel.setVisible(true);
            }
            if (this.ganttChartModel.isTimeNowEnabled() && this.ganttChartModel.getTimeNowReferenceLineModel() == null) {
                this.ganttChartModel.setTimeNowReferenceLineModel(new ReferenceLineModel());
                StrokeLineStyle redLine = new StrokeLineStyle();
                redLine.setColor(Color.red);
                this.ganttChartModel.getTimeNowReferenceLineModel().setLineStyle(redLine);
                this.ganttChartModel.getTimeNowReferenceLineModel().setInFront(true);
                this.ganttChartModel.getTimeNowReferenceLineModel().setVisible(true);
                this.ganttChartModel.getTimeNowReferenceLineModel().setPosition(timeNow);
                this.ganttChartModel.setViewStart(timeNow);
            }
            NumericMissingValueReplacement nmvr = new NumericMissingValueReplacement();
            nmvr.setReplacementValue(timeNow);
            if (cal == null) {
                nmvr.input.connectFrom(this.actualFinishVariable.value);
            } else {
                nmvr.input.connectFrom((NumericPipe)cal);
            }
            actualFinishMapper.input.connectFrom(nmvr.value);
            if (this.ganttChartModel.isActualBarOverlaid()) {
                this.ganttElement.actualOverlaid.setValue(true);
            } else {
                this.ganttElement.actualOverlaid.setValue(false);
            }
            this.ganttElement.actualStart.connectFrom(actualStartMapper.value);
            this.ganttElement.actualFinish.connectFrom(actualFinishMapper.value);
        } else if (this.timeNowRefLineModel != null && this.timeNowRefLineModel.isVisible() && Double.isNaN(this.timeNowRefLineModel.getPosition())) {
            Date currentTime = new Date();
            double javaDateValue = currentTime.getTime();
            double timeNow = this._convertJavaToSASDate(javaDateValue);
            this.timeNowRefLineModel.setPosition(timeNow);
            if (timeNow < this.dMapper.getInputMin() || timeNow > this.dMapper.getInputMax()) {
                this.timeNowRefLineModel.setVisible(false);
            }
            if (this.ganttChartModel.isTimeNowEnabled() && this.ganttChartModel.getTimeNowReferenceLineModel() == null) {
                this.ganttChartModel.setTimeNowReferenceLineModel(new ReferenceLineModel());
                StrokeLineStyle redLine = new StrokeLineStyle();
                redLine.setColor(Color.red);
                this.ganttChartModel.getTimeNowReferenceLineModel().setLineStyle(redLine);
                this.ganttChartModel.getTimeNowReferenceLineModel().setInFront(true);
                this.ganttChartModel.getTimeNowReferenceLineModel().setVisible(true);
                this.ganttChartModel.getTimeNowReferenceLineModel().setPosition(timeNow);
                this.ganttChartModel.setViewStart(timeNow);
            }
        }
        if (this.resourceStartVariable != null && this.resourceFinishVariable != null && this.ganttChartModel.isResourceBarEnabled()) {
            this.ganttElement.resourceBoxVisible.setValue(this.ganttChartModel.isResourceBarEnabled());
            ContinuousRangeToNumericMapper resourceStartMapper = this._createMapper((Variable)this.resourceStartVariable, this.dMapper);
            ContinuousRangeToNumericMapper resourceFinishMapper = this._createMapper((Variable)this.resourceFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
            this.ganttElement.resourceStart.connectFrom(resourceStartMapper.value);
            this.ganttElement.resourceFinish.connectFrom(resourceFinishMapper.value);
        }
        if (this.custom1StartVariable != null && this.custom1FinishVariable != null && this.ganttChartModel.isCustomBar1Enabled()) {
            this.ganttElement.customBox1Visible.setValue(this.ganttChartModel.isCustomBar1Enabled());
            ContinuousRangeToNumericMapper custom1StartMapper = this._createMapper((Variable)this.custom1StartVariable, this.dMapper);
            ContinuousRangeToNumericMapper custom1FinishMapper = this._createMapper((Variable)this.custom1FinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
            this.ganttElement.custom1Start.connectFrom(custom1StartMapper.value);
            this.ganttElement.custom1Finish.connectFrom(custom1FinishMapper.value);
        }
        if (this.custom2StartVariable != null && this.custom2FinishVariable != null && this.ganttChartModel.isCustomBar2Enabled()) {
            this.ganttElement.customBox2Visible.setValue(this.ganttChartModel.isCustomBar2Enabled());
            ContinuousRangeToNumericMapper custom2StartMapper = this._createMapper((Variable)this.custom2StartVariable, this.dMapper);
            ContinuousRangeToNumericMapper custom2FinishMapper = this._createMapper((Variable)this.custom2FinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
            this.ganttElement.custom2Start.connectFrom(custom2StartMapper.value);
            this.ganttElement.custom2Finish.connectFrom(custom2FinishMapper.value);
        }
        if (this.baselineStartVariable != null && this.baselineFinishVariable != null && this.ganttChartModel.isBaselineBarEnabled()) {
            this.ganttElement.baselineBoxVisible.setValue(this.ganttChartModel.isBaselineBarEnabled());
            ContinuousRangeToNumericMapper baselineStartMapper = this._createMapper((Variable)this.baselineStartVariable, this.dMapper);
            ContinuousRangeToNumericMapper baselineFinishMapper = this._createMapper((Variable)this.baselineFinishVariable, this.dMapper, (Variable)this.durationVariable, constant);
            this.ganttElement.baselineStart.connectFrom(baselineStartMapper.value);
            this.ganttElement.baselineFinish.connectFrom(baselineFinishMapper.value);
        }
        if (this.drawBarVariable != null) {
            this.ganttElement.drawBar.connectFrom(this.drawBarVariable.value);
        }
        MarkerStyle milestone = null;
        if (this.durationVariable != null) {
            this.ganttElement.duration.connectFrom(this.durationVariable.value);
            milestone = this.ganttChartModel.getDataElementStyles().getMilestoneMarkerStyle();
            if (milestone != null) {
                this.ganttElement.milestoneSymbol.setValue(milestone.getSymbol());
                this.ganttElement.milestoneColor.setValue(milestone.getColor());
                BaseLength size = milestone.getSize();
                double mkSize = size.getMagnitude(size.getUnit());
                if (mkSize == 0.0) {
                    this.ganttElement.milestoneSize.setValue(-1.0);
                } else {
                    this.ganttElement.milestoneSize.setValue(mkSize);
                }
                this.ganttElement.milestoneVisible.setValue(milestone.isVisible());
            } else {
                this.ganttElement.milestoneSymbol.setValue(108);
                this.ganttElement.milestoneColor.setValue(Color.BLACK);
                this.ganttElement.milestoneSize.setValue(-1.0);
                this.ganttElement.milestoneVisible.setValue(true);
            }
        }
        if (this.targetVariable != null) {
            boolean showTargetMarker = true;
            MarkerStyle mkrStyle = this.ganttChartModel.getDataElementStyles().getTargetMarkerStyle();
            if (mkrStyle != null) {
                if (mkrStyle.isVisible()) {
                    this.ganttElement.targetSymbol.setValue(mkrStyle.getSymbol());
                    this.ganttElement.targetColor.setValue(mkrStyle.getColor());
                    BaseLength size = mkrStyle.getSize();
                    double mkSize = size.getMagnitude(size.getUnit());
                    if (mkSize == 0.0) {
                        this.ganttElement.targetSize.setValue(-1.0);
                    } else {
                        this.ganttElement.targetSize.setValue(mkSize);
                    }
                    this.ganttElement.targetVisible.setValue(mkrStyle.isVisible());
                } else {
                    this.ganttElement.targetSymbol.setValue(112);
                    this.ganttElement.targetColor.setValue(new Color(252, 183, 53));
                    this.ganttElement.targetSize.setValue(-1.0);
                    this.ganttElement.targetVisible.setValue(false);
                    showTargetMarker = false;
                }
            } else {
                this.ganttElement.targetSymbol.setValue(112);
                this.ganttElement.targetColor.setValue(new Color(252, 183, 53));
                this.ganttElement.targetSize.setValue(-1.0);
                this.ganttElement.targetVisible.setValue(true);
            }
            if (showTargetMarker) {
                ContinuousRangeToNumericMapper targetMapper = this._createMapper((Variable)this.targetVariable, this.dMapper);
                this.ganttElement.target.connectFrom(targetMapper.value);
            }
        }
        if (this.styleByVariable == null && this.colorVariable != null && this.colorVariable instanceof StringVariable) {
            this.ganttElement.color.connectFrom(((StringVariable)this.colorVariable).formattedValue);
        }
        if (this.markerTaskVariable != null && this.markerTaskVariable instanceof StringVariable) {
            this.ganttElement.markerTask.connectFrom(((StringVariable)this.markerTaskVariable).value);
        }
        if (this.markerLocationVariable != null && this.markerLocationVariable instanceof StringVariable) {
            this.ganttElement.markerLocation.connectFrom(((StringVariable)this.markerLocationVariable).value);
        }
        if (this.markerPositionVariable != null && this.markerPositionVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper markerPositonMapper = this._createMapper(this.markerPositionVariable, this.dMapper);
            this.ganttElement.markerPosition.connectFrom(markerPositonMapper.value);
        }
        if (this.markerSymbolVariable != null && this.markerSymbolVariable instanceof NumericVariable) {
            this.ganttElement.markerSymbol.connectFrom(((NumericVariable)this.markerSymbolVariable).value);
        }
        if (this.markerSymbolColorVariable != null && this.markerSymbolColorVariable instanceof StringVariable) {
            this.ganttElement.markerSymbolColor.connectFrom(((StringVariable)this.markerSymbolColorVariable).formattedValue);
        }
        if (this.markerTextVariable != null && this.markerTextVariable instanceof StringVariable) {
            this.ganttElement.markerText.connectFrom(((StringVariable)this.markerTextVariable).value);
        }
        if (this.markerTextColorVariable != null && this.markerTextColorVariable instanceof StringVariable) {
            this.ganttElement.markerTextColor.connectFrom(((StringVariable)this.markerTextColorVariable).formattedValue);
        }
        if (this.markerTextJustificationVariable instanceof StringVariable) {
            StringToNumberMapper markerTextJustMapper = GanttChartCell._newStringToNumberMapper((StringVariable)this.markerTextJustificationVariable);
            this.ganttElement.markerTextJustification.connectFrom(markerTextJustMapper.value);
        } else if (this.markerTextJustificationVariable instanceof NumericVariable) {
            this.ganttElement.markerTextJustification.connectFrom(((NumericVariable)this.markerTextJustificationVariable).value);
        }
        this.ganttElement.setAnnoFont(this.ganttChartModel.getAnnotationLabelTextStyle().getFont());
        this.ganttElement.setAnnoFontColor(this.ganttChartModel.getAnnotationLabelTextStyle().getColor());
        BaseLength symSize = this.ganttChartModel.getAnnotationSymbolSize();
        if (symSize != null) {
            double mkSize = symSize.getMagnitude(symSize.getUnit());
            if (mkSize == 0.0) {
                this.ganttElement.annoSymbolSize.setValue(-1.0);
            } else {
                this.ganttElement.annoSymbolSize.setValue(mkSize);
            }
        }
    }

    private boolean showSlackTime() {
        if (this.styleByVariable != null) {
            return true;
        }
        return this.ganttChartModel.isSlackTimeEnabled();
    }

    private void _setBoxColors() {
        DataElementStyles des = this.ganttChartModel.getDataElementStyles();
        if (des.getNormalFillStyle() != null) {
            this.ganttElement.normalColor.setValue(des.getNormalFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.normalColor.setValue(new Color(175, 193, 122));
        }
        if (des.getSlackFillStyle() != null) {
            this.ganttElement.slackColor.setValue(des.getSlackFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.slackColor.setValue(new Color(242, 229, 157));
        }
        if (des.getCriticalFillStyle() != null) {
            this.ganttElement.criticalColor.setValue(des.getCriticalFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.criticalColor.setValue(new Color(218, 123, 123));
        }
        if (des.getActualFillStyle() != null) {
            this.ganttElement.actualColor.setValue(des.getActualFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.actualColor.setValue(new Color(156, 167, 199));
        }
        if (des.getResourceFillStyle() != null) {
            this.ganttElement.resourceColor.setValue(des.getResourceFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.resourceColor.setValue(new Color(171, 145, 169));
        }
        if (des.getCustomSchedule1FillStyle() != null) {
            this.ganttElement.custom1Color.setValue(des.getCustomSchedule1FillStyle().getSolidFillColor());
        } else {
            this.ganttElement.custom1Color.setValue(new Color(255, 255, 119));
        }
        if (des.getCustomSchedule2FillStyle() != null) {
            this.ganttElement.custom2Color.setValue(des.getCustomSchedule2FillStyle().getSolidFillColor());
        } else {
            this.ganttElement.custom2Color.setValue(new Color(255, 255, 119));
        }
        if (des.getBaselineFillStyle() != null) {
            this.ganttElement.baselineColor.setValue(des.getBaselineFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.baselineColor.setValue(new Color(195, 210, 213));
        }
        if (des.getBreakTimeFillStyle() != null) {
            this.ganttElement.breaktimeColor.setValue(des.getBreakTimeFillStyle().getSolidFillColor());
        } else {
            this.ganttElement.breaktimeColor.setValue(new Color(102, 102, 102));
        }
        this.ganttElement.outlineColor.setValue(this.ganttChartModel.getDataElementStyles().getOutlineLineStyle().getColor());
        LineStyle connectingLines = this.ganttChartModel.getDataElementStyles().getConnectingLineStyle();
        if (connectingLines != null && connectingLines.getVisibilityPolicy() != 10202) {
            double connectingLinesWidth = connectingLines.getThickness().getMagnitude((Object)"px");
            this.ganttElement.connectingLineColor.setValue(connectingLines.getColor());
            this.ganttElement.connectingLineWidth.setValue(connectingLinesWidth);
        }
        if (this.selectionVariable != null) {
            this.ganttElement.highlightFillColor.setValue(this.ganttChartModel.getBrushModel().getSelectionColor());
            this.ganttElement.highlightEdgeColor.setValue(this.ganttChartModel.getBrushModel().getSelectionAccentColor());
            this.ganttElement.highlightOn.connectFrom(((NumericVariable)this.selectionVariable).value);
        }
    }

    private void _addBreaktimePipes(double constant) {
        if (this.breaktimeCalendarVariable != null && this.breaktimeCalendarVariable instanceof StringVariable) {
            this.ganttElement.breaktimeCalendar.connectFrom(((StringVariable)this.breaktimeCalendarVariable).value);
        }
        if (this.breaktimeStartVariable != null && this.breaktimeStartVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper breaktimeStartMapper = this._createMapper(this.breaktimeStartVariable, this.dMapper);
            this.ganttElement.breaktimeStart.connectFrom(breaktimeStartMapper.value);
        }
        if (this.breaktimeFinishVariable != null && this.breaktimeFinishVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper breaktimeFinishMapper = this._createMapper(this.breaktimeFinishVariable, this.dMapper, constant);
            this.ganttElement.breaktimeFinish.connectFrom(breaktimeFinishMapper.value);
        }
        if (this.breaktimeDurationVariable != null && this.breaktimeDurationVariable instanceof NumericVariable && this.breaktimeStartVariable != null && this.breaktimeStartVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper breaktimeDurationMapper = this._createMapper(this.breaktimeStartVariable, (Variable)this.breaktimeDurationVariable, this.dMapper);
            this.ganttElement.breaktimeDuration.connectFrom(breaktimeDurationMapper.value);
        }
    }

    private void _addAnnotationPipes() {
        if (this.annoTaskVariable != null && this.annoTaskVariable instanceof StringVariable) {
            this.ganttElement.annoTask.connectFrom(((StringVariable)this.annoTaskVariable).value);
        }
        if (this.annoLocationVariable != null && this.annoLocationVariable instanceof StringVariable) {
            this.ganttElement.annoLocation.connectFrom(((StringVariable)this.annoLocationVariable).value);
        }
        if (this.annoPositionVariable != null && this.annoPositionVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper annoPositonMapper = this._createMapper(this.annoPositionVariable, this.dMapper);
            this.ganttElement.annoPosition.connectFrom(annoPositonMapper.value);
        }
        if (this.annoSymbolVariable != null && this.annoSymbolVariable instanceof NumericVariable) {
            this.ganttElement.annoSymbol.connectFrom(((NumericVariable)this.annoSymbolVariable).value);
        }
        if (this.annoSymbolColorVariable != null && this.annoSymbolColorVariable instanceof StringVariable) {
            this.ganttElement.annoSymbolColor.connectFrom(((StringVariable)this.annoSymbolColorVariable).formattedValue);
        }
        if (this.annoTextVariable != null && this.annoTextVariable instanceof StringVariable) {
            this.ganttElement.annoText.connectFrom(((StringVariable)this.annoTextVariable).value);
        }
        if (this.annoTextColorVariable != null && this.annoTextColorVariable instanceof StringVariable) {
            this.ganttElement.annoTextColor.connectFrom(((StringVariable)this.annoTextColorVariable).formattedValue);
        }
        if (this.annoTextJustificationVariable instanceof StringVariable) {
            StringToNumberMapper annoTextJustMapper = GanttChartCell._newStringToNumberMapper((StringVariable)this.annoTextJustificationVariable);
            this.ganttElement.annoTextJustification.connectFrom(annoTextJustMapper.value);
        } else if (this.annoTextJustificationVariable instanceof NumericVariable) {
            this.ganttElement.annoTextJustification.connectFrom(((NumericVariable)this.annoTextJustificationVariable).value);
        }
    }

    private void _addAxisWall() {
        FillStyle wallFillStyle = this.ganttChartModel.getAxisWallModel().getWallFillStyle();
        if (wallFillStyle.isVisible()) {
            Grid axisWall = new Grid();
            axisWall.selectEnabled.setValue(false);
            axisWall.getStyle().setBorderOn(false);
            axisWall.getStyle().setBackgroundColor(wallFillStyle.getSolidFillColor());
            axisWall.transform.translateX.setValue((double)(-this.margin.width));
            axisWall.transform.translateY.setValue((double)(-this.margin.height) + this.stride);
            axisWall.setWidth(this.dateAxisLength);
            axisWall.setHeight(this.taskAxisLength);
            if (wallFillStyle.getFillType() == 20001) {
                GridStyle style = axisWall.getStyle();
                style.setBackgroundOn(true);
                style.setBackgroundColor(wallFillStyle.getGradientFillBeginColor());
                style.setBackgroundColor2(wallFillStyle.getGradientFillEndColor());
                style.setGradientOn(true);
                style.setGradientDirection(wallFillStyle.getGradientFill());
            }
            this.getComposite().addElement((Element)axisWall);
        }
    }

    private void _setFrameAttributes() {
        if (this.cellModel.getFrameVisible().booleanValue()) {
            this.setBorder(new LineBorder(this.ganttChartModel.getFrameLineStyle().getColor()));
        } else {
            this.setBorder(null);
        }
    }

    private ContinuousRangeToNumericMapper _createMapper(Variable variable, ContinuousRangeToNumericMapper dm) {
        return this._createMapper(variable, dm, null, 0.0);
    }

    private Calculator _createCalculator(Variable variable, Variable duration, double endSize) {
        Calculator c = new Calculator("inA + ((inB>0)? " + endSize + " : 0)");
        c.inA.connectFrom(((NumericVariable)variable).value);
        c.inB.connectFrom(((NumericVariable)duration).value);
        return c;
    }

    private Calculator _createCalculator(Variable variable, Variable duration) {
        Calculator c = new Calculator("inA + inB");
        c.inA.connectFrom(((NumericVariable)variable).value);
        c.inB.connectFrom(((NumericVariable)duration).value);
        return c;
    }

    private Calculator _createCalculator(Variable variable, double endSize) {
        Calculator c = new Calculator("inA + " + endSize);
        c.inA.connectFrom(((NumericVariable)variable).value);
        return c;
    }

    private ContinuousRangeToNumericMapper _createMapper(Variable variable, ContinuousRangeToNumericMapper dm, Variable duration, double endSize) {
        ContinuousRangeToNumericMapper newMapper = new ContinuousRangeToNumericMapper();
        newMapper.shareMap(dm);
        if (duration != null) {
            Calculator c = this._createCalculator(variable, duration, endSize);
            newMapper.input.connectFrom((NumericPipe)c);
        } else {
            newMapper.input.connectFrom(((NumericVariable)variable).value);
        }
        return newMapper;
    }

    private ContinuousRangeToNumericMapper _createMapper(Variable variable, ContinuousRangeToNumericMapper dm, double endSize) {
        ContinuousRangeToNumericMapper newMapper = new ContinuousRangeToNumericMapper();
        newMapper.shareMap(dm);
        Calculator c = this._createCalculator(variable, endSize);
        newMapper.input.connectFrom((NumericPipe)c);
        return newMapper;
    }

    private ContinuousRangeToNumericMapper _createMapper(Variable variable, Variable duration, ContinuousRangeToNumericMapper dm) {
        ContinuousRangeToNumericMapper newMapper = new ContinuousRangeToNumericMapper();
        newMapper.shareMap(dm);
        Calculator c = this._createCalculator(variable, duration);
        newMapper.input.connectFrom((NumericPipe)c);
        return newMapper;
    }

    private static StringToNumberMapper _newStringToNumberMapper(StringVariable stringVariable) {
        if (stringVariable == null) {
            return null;
        }
        StringToNumberMapper numberMapper = new StringToNumberMapper();
        numberMapper.setLabelMissingValues(false);
        numberMapper.setReplaceMissingValues(false);
        int size = stringVariable.getUniqueValueCount();
        Integer number = null;
        for (int ii = 0; ii < size; ++ii) {
            number = null;
            try {
                String value = stringVariable.uniqueValue.getValue(ii);
                if (value != null) {
                    if (value.equalsIgnoreCase("LEFT") || value.equalsIgnoreCase("L")) {
                        number = new Integer(2);
                    } else if (value.equalsIgnoreCase("RIGHT") || value.equalsIgnoreCase("R")) {
                        number = new Integer(4);
                    } else if (value.equalsIgnoreCase("CENTER") || value.equalsIgnoreCase("C")) {
                        number = new Integer(0);
                    }
                }
                if (number == null) continue;
                numberMapper.add(value, number);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        numberMapper.input.connectFrom(stringVariable.value);
        return numberMapper;
    }

    private void _addVertReferenceLine(ReferenceLineModel refLineModel, ContinuousRangeToNumericMapper mapper, int offSet, double[] pos, boolean front, boolean axisVisible, LineStyle defaultLineStyle) {
        int labelPlacement;
        AdvancedTextStyle textStyle;
        if (refLineModel == null || refLineModel.isInFront() != front) {
            return;
        }
        double position = Double.NaN;
        try {
            position = Util.getPositionValue(this.earlyStartVariable, refLineModel);
        }
        catch (MissingValueException e) {
            position = Double.NaN;
        }
        double[] lineLoc = new double[4];
        lineLoc[0] = lineLoc[1] = mapper.getValue(position);
        lineLoc[2] = pos[0];
        lineLoc[3] = pos[1];
        LineStyle lineStyle = refLineModel.getLineStyle();
        if (lineStyle == null && defaultLineStyle != null) {
            lineStyle = defaultLineStyle;
        }
        if (lineStyle == null) {
            return;
        }
        this._addALine(lineLoc, lineStyle, 0);
        TextStyle textStyle2 = textStyle = refLineModel.getTextStyle() != null ? refLineModel.getTextStyle() : this.ganttChartModel.getDateAxisModel().getTimePeriodModel1().getTextStyle();
        if (textStyle.isVisible() && ((labelPlacement = refLineModel.getLabelPlacement()) == 11301 || labelPlacement == 10200 || labelPlacement == 11321 || labelPlacement == 11320)) {
            RasterLabel label = new RasterLabel();
            label.selectEnabled.setValue(false);
            label.trimOn.setValue(false);
            label.string.setValue(refLineModel.getLabel());
            Font font = textStyle.getFont();
            label.fontName.setValue(font.getName());
            label.fontSize.setValue(font.getSize());
            label.fontStyle.setValue(font.getStyle());
            label.color.setValue(textStyle.getColor());
            label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
            label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
            label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            label.angle.setValue(90.0);
            label.transform.translateX.setValue(lineLoc[1] - Math.ceil(lineStyle.getThickness().getMagnitude((Object)"px") / 2.0));
            label.horizontalJustification.setValue(labelPlacement == 11321 ? 0 : 2);
            label.verticalJustification.setValue(0);
            label.transform.translateY.connectFrom((NumericPipe)this.labelYPosition);
            this.getComposite().addElement((Element)label);
        }
    }

    public void setCurrentTaskScrollValue(int v) {
        this.labelYPosition.setValue(this.originalYPosition - (double)v);
    }

    private void _addALine(double[] loc, LineStyle lineStyle, int offSet) {
        LineSegment eSegment = new LineSegment();
        eSegment.selectEnabled.setValue(false);
        BasicStroke stroke = null;
        double width = 1.0;
        if (lineStyle instanceof StrokeLineStyle) {
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes((StrokeLineStyle)lineStyle);
            eSegment.setStipple(gla.stipplePattern, gla.stippleFactor);
            stroke = ((StrokeLineStyle)lineStyle).getStroke();
            width = stroke instanceof BasicStroke ? (double)stroke.getLineWidth() : lineStyle.getThickness().getMagnitude((Object)"px");
        }
        eSegment.lineWidth.setValue(width);
        eSegment.beginX.setValue(loc[0]);
        eSegment.endX.setValue(loc[1]);
        eSegment.beginY.setValue(loc[2]);
        eSegment.endY.setValue(loc[3]);
        eSegment.color.setValue(lineStyle.getColor());
        eSegment.transform.translateX.setValue((double)offSet);
        this.getComposite().addElement((Element)eSegment);
    }

    private void _findDateVariableFormat() {
        SASFormat f;
        VariableDefinition earlyStartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getEarlyStartRole(), 0);
        VariableDefinition earlyFinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getEarlyFinishRole(), 0);
        VariableDefinition lateStartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getLateStartRole(), 0);
        VariableDefinition lateFinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getLateFinishRole(), 0);
        VariableDefinition resourceStartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getResourceStartRole(), 0);
        VariableDefinition resourceFinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getResourceFinishRole(), 0);
        VariableDefinition actualStartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getActualStartRole(), 0);
        VariableDefinition actualFinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getActualFinishRole(), 0);
        VariableDefinition custom1StartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getCustom1StartRole(), 0);
        VariableDefinition custom1FinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getCustom1FinishRole(), 0);
        VariableDefinition custom2StartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getCustom2StartRole(), 0);
        VariableDefinition custom2FinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getCustom2FinishRole(), 0);
        VariableDefinition baselineStartVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getBaselineStartRole(), 0);
        VariableDefinition baselineFinishVarDef = this.scheduleDataSource.getVariableDefinition(this.cellModel.getBaselineFinishRole(), 0);
        if (earlyStartVarDef != null && earlyFinishVarDef != null) {
            this.fmt = earlyStartVarDef.getFormat();
            if (this.fmt == null) {
                this.fmt = earlyFinishVarDef.getFormat();
            }
            if (lateStartVarDef != null && lateFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = lateStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = lateFinishVarDef.getFormat();
                }
            }
            if (actualStartVarDef != null && actualFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = actualStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = actualFinishVarDef.getFormat();
                }
            }
            if (custom1StartVarDef != null && custom1FinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = custom1StartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = custom1FinishVarDef.getFormat();
                }
            }
            if (custom2StartVarDef != null && custom2FinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = custom2StartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = custom2FinishVarDef.getFormat();
                }
            }
            if (resourceStartVarDef != null && resourceFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = resourceStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = resourceFinishVarDef.getFormat();
                }
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (lateStartVarDef != null && lateFinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = lateStartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = lateFinishVarDef.getFormat();
            }
            if (actualStartVarDef != null && actualFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = actualStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = actualFinishVarDef.getFormat();
                }
            }
            if (custom1StartVarDef != null && custom1FinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = custom1StartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = custom1FinishVarDef.getFormat();
                }
            }
            if (custom2StartVarDef != null && custom2FinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = custom2StartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = custom2FinishVarDef.getFormat();
                }
            }
            if (resourceStartVarDef != null && resourceFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = resourceStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = resourceFinishVarDef.getFormat();
                }
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (actualStartVarDef != null && actualFinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = actualStartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = actualFinishVarDef.getFormat();
            }
            if (resourceStartVarDef != null && resourceFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = resourceStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = resourceFinishVarDef.getFormat();
                }
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (custom1StartVarDef != null && custom1FinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = custom1StartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = custom1FinishVarDef.getFormat();
            }
            if (resourceStartVarDef != null && resourceFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = resourceStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = resourceFinishVarDef.getFormat();
                }
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (custom2StartVarDef != null && custom2FinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = custom2StartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = custom2FinishVarDef.getFormat();
            }
            if (custom1StartVarDef != null && custom1FinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = custom1StartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = custom1FinishVarDef.getFormat();
                }
            }
            if (resourceStartVarDef != null && resourceFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = resourceStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = resourceFinishVarDef.getFormat();
                }
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (resourceStartVarDef != null && resourceFinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = resourceStartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = resourceFinishVarDef.getFormat();
            }
            if (baselineStartVarDef != null && baselineFinishVarDef != null) {
                if (this.fmt == null) {
                    this.fmt = baselineStartVarDef.getFormat();
                }
                if (this.fmt == null) {
                    this.fmt = baselineFinishVarDef.getFormat();
                }
            }
        } else if (baselineStartVarDef != null && baselineFinishVarDef != null) {
            if (this.fmt == null) {
                this.fmt = baselineStartVarDef.getFormat();
            }
            if (this.fmt == null) {
                this.fmt = baselineFinishVarDef.getFormat();
            }
        }
        if (this.fmt == null) {
            this.fmt = "DATE7.";
        }
        this.fmtInst = (f = SASFormat.getInstance((String)this.fmt)) instanceof SASDateTimeFormat ? (SASDateTimeFormat)f : null;
    }

    private void _addVertRefLines(boolean front) {
        if (this.localDateAxisCellModel != null && this.localTaskAxisCellModel != null) {
            ReferenceLineModel[] rlma;
            LineStyle defaultLineStyle = this.localDateAxisModel.getValueCellStyle().getFrameLineStyle();
            double[] vertPos = new double[]{(double)(-this.margin.height) + this.stride, this.taskAxisLength - (double)this.margin.height + this.stride};
            if (!front && this.weekendFillStyle.isVisible()) {
                this._addWeekendBands(this.taskAxisLength, this.dateAxisVisible);
            }
            if (!front && this.localDateAxisModel.getReferenceBandModels() != null) {
                this._addHolidayBands(this.taskAxisLength, this.dateAxisVisible);
            }
            if (this.labelYPosition.getValue() == 0.0) {
                this.originalYPosition = vertPos[1] - vertPos[0];
                this.labelYPosition.setValue(this.originalYPosition);
            }
            if ((rlma = this.localDateAxisModel.getReferenceLineModels()) != null) {
                for (int ii = 0; ii < rlma.length; ++ii) {
                    if (!rlma[ii].isVisible()) continue;
                    LineStyle refLineStyle = rlma[ii].getLineStyle();
                    if (refLineStyle == null) {
                        refLineStyle = defaultLineStyle;
                    }
                    if (refLineStyle.getVisibilityPolicy() == 10202) continue;
                    this._addVertReferenceLine(rlma[ii], this.dMapper, this.margin.width, vertPos, front, this.dateAxisVisible, defaultLineStyle);
                }
            }
            if (this.timeNowRefLineModel != null && this.timeNowRefLineModel.isVisible()) {
                LineStyle refLineStyle = this.timeNowRefLineModel.getLineStyle();
                if (refLineStyle == null) {
                    refLineStyle = defaultLineStyle;
                }
                if (refLineStyle.getVisibilityPolicy() != 10202) {
                    this._addVertReferenceLine(this.timeNowRefLineModel, this.dMapper, this.margin.width, vertPos, front, this.dateAxisVisible, defaultLineStyle);
                }
            }
        }
    }

    private void _getAxisLengths() {
        double xLength;
        this.dateAxisLength = xLength = (double)Math.round(this.localDateAxisCellModel.getLength());
        if (Math.abs(this.dateAxisLength - (double)this.bounds.width) > 3.0) {
            this.dateAxisLength = xLength = (double)Math.round(this.localDateAxisCellModel.getLength());
        }
        BaseLength start = this.localTaskAxisModel.getStartOffset();
        BaseLength end = this.localTaskAxisModel.getEndOffset();
        double ystart = start == null ? (double)this.margin.height : start.getMagnitude((Object)"py");
        double yend = end == null ? (double)this.margin.height : end.getMagnitude((Object)"py");
        double yLength = Math.round(this.localTaskAxisCellModel.getLength());
        this.taskAxisLength = yLength + ystart + yend - this.stride;
    }

    private void _addGridLines(boolean front) {
        if (this.localDateAxisModel != null && this.localDateAxisModel.getGridLineStyle().getVisibilityPolicy() == 10201 && this.localDateAxisModel.isGridInFront() == front) {
            this.dateGridLines = new Grid();
            this.dateGridLines.selectEnabled.setValue(false);
            NumericPipe dateOffset = this.localDateAxisCellModel.getValues2();
            if (dateOffset == null) {
                dateOffset = this.localDateAxisCellModel.getValues1();
            }
            if (dateOffset == null) {
                dateOffset = this.localDateAxisCellModel.getValues3();
            }
            this.dateGridLines.transform.translateY.setValue((double)(-this.margin.height) + this.stride);
            this.dateGridLines.setHeight(this.taskAxisLength + (double)(2 * this.margin.height) - 2.0);
            this.dateGridLines.setWidth(this.dateAxisLength + (double)(2 * this.margin.width));
            this.dateGridLines.verticalLineOffset.connectFrom(dateOffset);
            GridStyle gtkGridStyle = this.dateGridLines.getStyle();
            gtkGridStyle.setBorderOn(false);
            gtkGridStyle.setBackgroundOn(false);
            StrokeLineStyle gridlineLineStyle = this.localDateAxisModel.getGridLineStyle();
            gtkGridStyle.setMajorLineColor(gridlineLineStyle.getColor());
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridlineLineStyle);
            gtkGridStyle.setLineWidth(gla.lineWidth);
            gtkGridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            this.getComposite().addElement((Element)this.dateGridLines);
        }
        if (this.tableAxisModel != null && this.tableAxisModel.getGridLineStyle().getVisibilityPolicy() == 10201 && this.tableAxisModel.isGridInFront() == front) {
            this.taskGridLines = new Grid();
            this.taskGridLines.selectEnabled.setValue(false);
            Dimension catAxisMargin = new Dimension();
            if (this.IdMapper.getUniqueValueCount() > 0) {
                catAxisMargin = new Dimension(this.margin);
            }
            this.taskGridLines.transform.translateX.setValue((double)(-this.margin.width));
            this.taskGridLines.setHeight(this.taskAxisLength + (double)(2 * catAxisMargin.height) - 2.0);
            this.taskGridLines.setWidth(this.dateAxisLength + (double)(2 * this.margin.width));
            Calculator c = new Calculator("inA + inB");
            c.inA.connectFrom((NumericPipe)this.IdMapper);
            c.inB.setValue(this.strideValue * 0.5);
            this.taskGridLines.horizontalLineOffset.connectFrom((NumericPipe)c);
            GridStyle gtkGridStyle = this.taskGridLines.getStyle();
            gtkGridStyle.setBorderOn(false);
            gtkGridStyle.setBackgroundOn(false);
            StrokeLineStyle gridlineLineStyle = this.tableAxisModel.getGridLineStyle();
            gtkGridStyle.setMajorLineColor(gridlineLineStyle.getColor());
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridlineLineStyle);
            gtkGridStyle.setLineWidth(gla.lineWidth);
            gtkGridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            this.getComposite().addElement((Element)this.taskGridLines);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Graphics gc = this.getGraphics();
        if (gc != null && this.taskVariable != null && this.localTaskAxisCellModel != null && this.localDateAxisCellModel != null) {
            int catAxisAdj = this.localDateAxisCellModel.getAxisVisible() != false ? this.localTaskAxisCellModel.getCatAxisAdj().intValue() : 0;
            Dimension margin = this.localTaskAxisCellModel.getMargin();
            int h = (int)this.localTaskAxisCellModel.getIdealPreferredLength().doubleValue() + 2 * margin.height + catAxisAdj;
            int resAxisAdj = this.localTaskAxisCellModel.getAxisVisible() != false ? this.localDateAxisCellModel.getResAxisAdj().intValue() : 0;
            int w = (int)(this.localDateAxisCellModel.getPreferredLength() / this.localDateAxisCellModel.getViewFactor()) + 2 * margin.width + resAxisAdj;
            return new Dimension(w, h);
        }
        return super.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        Vector[] pairs = this._getLabelValuePairs(obsIndex);
        return new PickInfo(pairs, obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    private Vector[] _getLabelValuePairs(int obsIndex) {
        boolean graphDataIsVisible;
        Vector labelValuePairs = new Vector();
        boolean bl = graphDataIsVisible = this.dataTipVariables == null || this.dataTipVariables.length <= 0 || this.dataTipVariables[0] == null || this.ganttChartModel.getDataTipModel().getContent() != 11401;
        if (this.taskVariable != null) {
            TableModel tm = (TableModel)this.scheduleDataSource.getRootDataSource().getModel();
            if (this.scheduleDataSourceChanged && tm instanceof GanttBarTableModel) {
                Hashtable<String, Object> entry = new Hashtable<String, Object>();
                entry.put(PickInfo.VISIBLE, graphDataIsVisible ? Boolean.TRUE : Boolean.FALSE);
                entry.put(PickInfo.ID, this.cellModel.getTaskRole());
                entry.put(PickInfo.LABEL, this.taskVariable.getLabel());
                int idx = this.cellModel._findColumnIndex(this.newTaskColumnName, tm);
                Object value = tm.getValueAt(obsIndex, idx);
                String formattedValue = this.taskVariable.getFormatter().format(value).trim();
                entry.put(PickInfo.VALUE, value);
                entry.put(PickInfo.FORMATTED_VALUE, formattedValue);
                labelValuePairs.add(entry);
            } else {
                GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getTaskRole(), this.taskVariable, obsIndex, graphDataIsVisible);
            }
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getParentRole(), this.parentVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getEarlyStartRole(), (Variable)this.earlyStartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getEarlyFinishRole(), (Variable)this.earlyFinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getLateStartRole(), (Variable)this.lateStartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getLateFinishRole(), (Variable)this.lateFinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getResourceStartRole(), (Variable)this.resourceStartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getResourceFinishRole(), (Variable)this.resourceFinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getCustom1StartRole(), (Variable)this.custom1StartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getCustom1FinishRole(), (Variable)this.custom1FinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getCustom2StartRole(), (Variable)this.custom2StartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getCustom2FinishRole(), (Variable)this.custom2FinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getActualStartRole(), (Variable)this.actualStartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getActualFinishRole(), (Variable)this.actualFinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getBaselineStartRole(), (Variable)this.baselineStartVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getBaselineFinishRole(), (Variable)this.baselineFinishVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getDurationRole(), (Variable)this.durationVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getTargetRole(), (Variable)this.targetVariable, obsIndex, graphDataIsVisible);
        if (this.styleByVariable != null) {
            GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getStyleByRole(), this.styleByVariable, obsIndex, graphDataIsVisible);
        } else {
            GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getColorRole(), this.colorVariable, obsIndex, graphDataIsVisible);
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getDataTipRole(), this.dataTipVariables, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getAuxiliaryRole(), this.auxiliaryVariables, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    public void setRangeModelExtent(int newWidth) {
        this.localDateAxisCellModel.setVisibleLength(newWidth);
        this.cachedPreferredSize = null;
    }

    private double _convertJavaToSASDate(double javaDateValue) {
        if (this.fmtInst == null) {
            String message = Message.format((String)RB.getStringResource("inFormatNotSupported.fmt.txt"), (Object)this.fmt.trim());
            throw new IllegalStateException(message);
        }
        return this.fmtInst.convertFromJavaDate((long)javaDateValue);
    }

    private NumericVariable _makeNumericVariable(Variable v) {
        NumericVariable newVar = null;
        try {
            newVar = (NumericVariable)v;
        }
        catch (ClassCastException e) {
            newVar = null;
        }
        return newVar;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g instanceof Graphics2D) {
            TreeTable treeTable = (TreeTable)this.cellModel.getTable();
            treeTable.getZones().paint((Graphics2D)g, (Component)this);
        }
    }
}

