/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.ganttchart;

import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class GanttBarTableModel
implements TableModel {
    TreeTableModel wrappedModel;
    MappedRange ranges;
    SelectionRelay relay;
    TableModelListener wrappedModelListener;
    int parentColIdx;
    int taskColIdx;
    int mapColIdx;
    int actualTaskColIdx;
    String actualTaskColName;
    private static Boolean T = new Boolean(true);
    private static Boolean F = new Boolean(false);

    public GanttBarTableModel(TreeTableModel wrapped, int parentIdx, int taskIdx, int multiIdx, String newTaskColName, ListSelectionModel wrappedSelectionModel, ListSelectionModel mySelectionModel) {
        this.wrappedModel = wrapped;
        this.parentColIdx = parentIdx;
        this.taskColIdx = taskIdx;
        this.mapColIdx = multiIdx;
        this.actualTaskColName = newTaskColName;
        Object[] ttRow = this.wrappedModel.getRowAt(0, false).getTableRow();
        this.actualTaskColIdx = ttRow.length;
        this.ranges = new MappedRange(this.wrappedModel);
        this.wrappedModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GanttBarTableModel.this.ranges.rebuild();
            }
        };
        this.wrappedModel.addTableModelListener(this.wrappedModelListener);
        this.relay = new SelectionRelay((TableModel)wrapped, wrappedSelectionModel, taskIdx, this, mySelectionModel, taskIdx);
    }

    public void dispose() {
        if (this.relay != null) {
            this.relay.dispose();
            this.relay = null;
        }
        if (this.wrappedModelListener != null) {
            this.wrappedModel.removeTableModelListener(this.wrappedModelListener);
            this.wrappedModelListener = null;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.wrappedModel.addTableModelListener(l);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == this.actualTaskColIdx) {
            columnIndex = this.taskColIdx;
        }
        return this.wrappedModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.wrappedModel.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.actualTaskColIdx) {
            return this.actualTaskColName;
        }
        return this.wrappedModel.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.ranges.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        Object[] row = this.ranges.findGanttBarData(rowIndex);
        if (row == null || columnIndex >= row.length) {
            return null;
        }
        return row[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rx, int cx) {
        MappedRangeElement r = this.ranges.findRange(rx);
        if (r == null) {
            return false;
        }
        int ttcx = cx;
        if (cx == this.actualTaskColIdx) {
            ttcx = this.taskColIdx;
        }
        if (cx == this.taskColIdx) {
            ttcx = r.type == 2 ? this.parentColIdx : this.taskColIdx;
        }
        int ttrx = r.findTreeTableIndex(rx);
        return this.wrappedModel.isCellEditable(ttrx, ttcx);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.wrappedModel.removeTableModelListener(l);
    }

    @Override
    public void setValueAt(Object newValue, int rx, int cx) {
        MappedRangeElement r = this.ranges.findRange(rx);
        if (r == null) {
            return;
        }
        int ttcx = cx;
        if (cx == this.actualTaskColIdx) {
            ttcx = this.taskColIdx;
        }
        if (cx == this.taskColIdx) {
            ttcx = r.type == 2 ? this.parentColIdx : this.taskColIdx;
        }
        int ttrx = r.findTreeTableIndex(rx);
        this.wrappedModel.setValueAt(newValue, ttrx, ttcx);
    }

    private class MappedRange
    extends Vector {
        TreeTableModel ttm;
        MappedRangeElement lastRange = null;
        int lastGbIndex = -1;
        int cachedRowIndex;
        TreeTableRow cachedTreeTableRow;
        MappedRangeElement cachedRange;
        Object[] cachedRowData;

        public MappedRange(TreeTableModel m) {
            this.ttm = m;
            Object[] ttRow = m.getRowAt(0, false).getTableRow();
            this.cachedRowData = new Object[ttRow.length + 1];
            this.cachedTreeTableRow = null;
            this.cachedRowIndex = -1;
            this.rebuild();
        }

        private MappedRangeElement getRange(int rangeElementIndex) {
            return (MappedRangeElement)this.elementAt(rangeElementIndex);
        }

        public MappedRangeElement findRange(int ganttBarIndex) {
            return this.findRange(ganttBarIndex, true);
        }

        private MappedRangeElement findRange(int ganttBarIndex, boolean exact) {
            if (ganttBarIndex == this.cachedRowIndex) {
                return this.cachedRange;
            }
            int lo = -1;
            int hi = GanttBarTableModel.this.ranges.size();
            MappedRangeElement r = null;
            while (true) {
                if (hi - lo <= 1) {
                    if (exact || lo == -1) {
                        return null;
                    }
                    return this.getRange(lo);
                }
                int mid = (lo + hi) / 2;
                r = this.getRange(mid);
                if (r.gbmax < ganttBarIndex) {
                    lo = mid;
                    continue;
                }
                if (r.gbmin <= ganttBarIndex) break;
                hi = mid;
            }
            return r;
        }

        @Override
        public void removeAllElements() {
            this.clearCache();
            super.removeAllElements();
        }

        @Override
        public void clear() {
            this.clearCache();
            super.clear();
        }

        @Override
        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeElement(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeElementAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int i0, int i1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void setElementAt(Object x, int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i, Object x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object x) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public void addElement(Object x) {
            throw new UnsupportedOperationException();
        }

        public void _remove(int i) {
            super.remove(i);
        }

        public void _addElement(Object x) {
            super.addElement(x);
        }

        private void clearCache() {
            this.lastRange = null;
            this.lastGbIndex = -1;
            this.cachedTreeTableRow = null;
            this.cachedRowIndex = -1;
        }

        @Override
        public void add(int ttIndex, int rType) {
            if (this.lastRange != null && this.lastRange.type == rType && this.lastRange.ttmax + 1 == ttIndex) {
                ++this.lastRange.gbmax;
                ++this.lastRange.ttmax;
            } else {
                this.lastRange = new MappedRangeElement(this.lastGbIndex + 1, ttIndex, rType);
                this._addElement(this.lastRange);
            }
            this.lastGbIndex = this.lastRange.gbmax;
        }

        public int getRowCount() {
            return this.lastGbIndex + 1;
        }

        private void rebuild() {
            int ttx = -1;
            this.removeAllElements();
            this.cachedRowIndex = -1;
            int i1 = this.ttm.getRowCount() - 1;
            for (int i = 0; i <= i1; ++i) {
                Number b = (Number)this.ttm.getValueAt(i, GanttBarTableModel.this.mapColIdx);
                boolean multiParent = b != null && b.intValue() != 0;
                ttx = i;
                if (!multiParent) {
                    this.add(ttx, 1);
                    continue;
                }
                TreeTableRow parent_ttr = this.ttm.getRowAt(i);
                int numChildren = parent_ttr.getChildCount();
                if (numChildren == 0) {
                    this.add(ttx, 0);
                    continue;
                }
                for (int ch = 0; ch < numChildren; ++ch) {
                    TreeTableRow next_ttr;
                    TreeTableRow child_ttr = (TreeTableRow)parent_ttr.getChildAt(ch);
                    ttx = child_ttr == (next_ttr = this.ttm.getRowAt(ttx + 1, false)) ? ttx + 1 : this.ttm.indexOf(child_ttr, false);
                    this.add(ttx, 2);
                }
            }
        }

        public Object[] findGanttBarData(int ganttBarIndex) {
            int i;
            if (ganttBarIndex == this.cachedRowIndex) {
                return this.cachedRowData;
            }
            MappedRangeElement r = this.findRange(ganttBarIndex);
            if (r == null) {
                return null;
            }
            int ttIndex = r.findTreeTableIndex(ganttBarIndex);
            TreeTableRow ttRow = this.ttm.getRowAt(ttIndex, r.type != 2);
            if (ttRow == null) {
                return null;
            }
            Object[] ttRowData = ttRow.getTableRow();
            if (ttRowData == null) {
                return null;
            }
            this.cachedRowIndex = ganttBarIndex;
            this.cachedTreeTableRow = ttRow;
            this.cachedRange = r;
            for (i = 0; i < ttRowData.length; ++i) {
                this.cachedRowData[i] = ttRowData[i];
            }
            this.cachedRowData[GanttBarTableModel.this.actualTaskColIdx] = ttRowData[GanttBarTableModel.this.taskColIdx];
            if (r.type == 0) {
                for (i = 0; i < this.cachedRowData.length; ++i) {
                    if (i == GanttBarTableModel.this.taskColIdx || i == GanttBarTableModel.this.actualTaskColIdx || i == GanttBarTableModel.this.parentColIdx) continue;
                    this.cachedRowData[i] = null;
                }
            }
            if (r.type == 2) {
                this.cachedRowData[GanttBarTableModel.this.taskColIdx] = ttRowData[GanttBarTableModel.this.parentColIdx];
            }
            return this.cachedRowData;
        }
    }

    private class SelectionRelay
    implements ListSelectionListener {
        Vector models = new Vector();
        boolean selecting = false;

        public SelectionRelay() {
        }

        public SelectionRelay(TableModel m1, ListSelectionModel s1, int t1, TableModel m2, ListSelectionModel s2, int t2) {
            this();
            this.selecting = true;
            this.addModel(new RelayItem(m1, s1, t1));
            this.addModel(new RelayItem(m2, s2, t2));
            this.selecting = false;
        }

        public boolean refersToModel(Object m) {
            for (int i = 0; i < this.models.size(); ++i) {
                RelayItem ri = (RelayItem)this.models.elementAt(i);
                if (ri.tableModel != m && ri.selectionModel != m) continue;
                return true;
            }
            return false;
        }

        private void addModel(RelayItem new_rm) {
            if (this.models.size() > 0) {
                new_rm.selectionModel.clearSelection();
                for (int i = this.models.size() - 1; i >= 0; --i) {
                    RelayItem old_rm = (RelayItem)this.models.elementAt(i);
                    ListSelectionModel old_sm = old_rm.selectionModel;
                    int s0 = old_sm.getMinSelectionIndex();
                    int s1 = old_sm.getMaxSelectionIndex();
                    for (int s = s0; s <= s1; ++s) {
                        if (!old_sm.isSelectedIndex(s)) continue;
                        Object key = old_rm.tableModel.getValueAt(s, old_rm.keyCol);
                        this._selectKeyInTable(key, true, new_rm);
                    }
                }
                RelayItem rm0 = (RelayItem)this.models.elementAt(0);
                int rm0_anchorIndex = rm0.selectionModel.getAnchorSelectionIndex();
                if (rm0_anchorIndex >= 0) {
                    Object rm0_anchorKey = rm0.tableModel.getValueAt(rm0_anchorIndex, rm0.keyCol);
                    boolean rm0_anchorSel = rm0.selectionModel.isSelectedIndex(rm0_anchorIndex);
                    this._selectKeyInTable(rm0_anchorKey, rm0_anchorSel, new_rm);
                }
            }
            this.models.addElement(new_rm);
            new_rm.selectionModel.addListSelectionListener(this);
        }

        private void removeModel(RelayItem rm) {
            rm.selectionModel.removeListSelectionListener(this);
            this.models.removeElement(rm);
        }

        private void dispose() {
            while (this.models.size() > 0) {
                RelayItem rm = (RelayItem)this.models.elementAt(0);
                this.removeModel(rm);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int i0 = e.getFirstIndex();
            int i1 = e.getLastIndex();
            if (i0 < 0 || i1 < i0 || this.selecting) {
                return;
            }
            this.selecting = true;
            RelayItem rm = null;
            for (int i = 0; i < this.models.size(); ++i) {
                RelayItem rmi = (RelayItem)this.models.elementAt(i);
                if (e.getSource() != rmi.selectionModel) continue;
                rm = rmi;
                break;
            }
            if (rm != null) {
                this._valueChanged(e, rm);
            }
            this.selecting = false;
        }

        private void _valueChanged(ListSelectionEvent e, RelayItem rm) {
            int rx;
            int maxRow;
            int s1;
            Object key = null;
            Boolean sel = null;
            int s0 = e.getFirstIndex();
            if (s0 > (s1 = e.getLastIndex())) {
                int t = s0;
                s0 = s1;
                s1 = t;
            }
            int a0 = rm.selectionModel.getAnchorSelectionIndex();
            int a1 = rm.selectionModel.getLeadSelectionIndex();
            if (a1 == -1) {
                a1 = a0;
            }
            if (a0 > a1) {
                int t = a0;
                a0 = a1;
                a1 = t;
            }
            if (s0 > (maxRow = rm.tableModel.getRowCount() - 1)) {
                return;
            }
            if (s1 > maxRow) {
                s1 = maxRow;
            }
            Hashtable<Object, Boolean> selectKeys = new Hashtable<Object, Boolean>();
            Hashtable<Object, Boolean> anchorKeys = new Hashtable<Object, Boolean>();
            for (rx = a0; rx <= a1; ++rx) {
                key = rm.tableModel.getValueAt(rx, rm.keyCol);
                Boolean bl = sel = rm.selectionModel.isSelectedIndex(rx) ? T : F;
                if (anchorKeys.contains(key)) continue;
                anchorKeys.put(key, sel);
            }
            for (rx = s0; rx <= s1; ++rx) {
                if (rx == a0) {
                    rx = a1;
                    continue;
                }
                key = rm.tableModel.getValueAt(rx, rm.keyCol);
                Boolean bl = sel = rm.selectionModel.isSelectedIndex(rx) ? T : F;
                if (anchorKeys.contains(key) || selectKeys.contains(key)) continue;
                selectKeys.put(key, sel);
            }
            for (int i = 0; i < this.models.size(); ++i) {
                RelayItem rmi = (RelayItem)this.models.elementAt(i);
                this._selectInModel(rmi, rm, selectKeys, anchorKeys);
            }
        }

        private void _selectInModel(RelayItem toRm, RelayItem fromRm, Hashtable sKeys, Hashtable aKeys) {
            int a0 = -1;
            int a1 = -1;
            boolean a0sel = false;
            int fromRm_a0 = fromRm.selectionModel.getAnchorSelectionIndex();
            int fromRm_a1 = fromRm.selectionModel.getLeadSelectionIndex();
            boolean fromRm_a0sel = fromRm.selectionModel.isSelectedIndex(fromRm_a0);
            int rx1 = toRm.tableModel.getRowCount();
            for (int rx = 0; rx < rx1; ++rx) {
                boolean sel;
                Object key_rx = toRm.tableModel.getValueAt(rx, toRm.keyCol);
                if (aKeys.containsKey(key_rx)) {
                    sel = (Boolean)aKeys.get(key_rx);
                    if (a1 != -1 && rx > a1 + 1) {
                        this._select(toRm.selectionModel, a0, a1, a0sel);
                        a1 = -1;
                        a0 = -1;
                    }
                    if (a0 == -1) {
                        a0 = a1 = rx;
                        a0sel = sel;
                        continue;
                    }
                    if (rx != a1 + 1) continue;
                    a1 = rx;
                    continue;
                }
                if (!sKeys.containsKey(key_rx)) continue;
                sel = (Boolean)sKeys.get(key_rx);
                this._select(toRm.selectionModel, rx, rx, sel);
            }
            if (a0 != -1) {
                this._select(toRm.selectionModel, a0, a1, a0sel);
            }
            if (toRm == fromRm) {
                this._select(toRm.selectionModel, fromRm_a0, fromRm_a1, fromRm_a0sel);
            }
        }

        private void _selectKeyInTable(Object key, boolean sel, RelayItem rm) {
            int rx1 = rm.tableModel.getRowCount();
            for (int rx = 0; rx < rx1; ++rx) {
                Object key_rx = rm.tableModel.getValueAt(rx, rm.keyCol);
                if (!key_rx.equals(key)) continue;
                this._select(rm.selectionModel, rx, rx, sel);
            }
        }

        private void _select(ListSelectionModel m, int rx0, int rx1, boolean sel) {
            if (sel) {
                m.addSelectionInterval(rx0, rx1);
            } else {
                m.removeSelectionInterval(rx0, rx1);
            }
        }

        private class RelayItem {
            TableModel tableModel;
            ListSelectionModel selectionModel;
            int keyCol;

            public RelayItem(TableModel t, ListSelectionModel s, int i) {
                this.tableModel = t;
                this.selectionModel = s;
                this.keyCol = i;
            }
        }
    }

    private class MappedRangeElement {
        public TreeTableModel ttm;
        public int gbmin;
        public int gbmax;
        public int ttmin;
        public int ttmax;
        public int type;

        public MappedRangeElement() {
            this.type = -1;
            this.ttmax = -1;
            this.ttmin = -1;
            this.gbmax = -1;
            this.gbmin = -1;
        }

        public MappedRangeElement(int gbindex, int ttindex, int t) {
            this.gbmin = this.gbmax = gbindex;
            this.ttmin = this.ttmax = ttindex;
            this.type = t;
        }

        public int findTreeTableIndex(int ganttBarIndex) {
            return this.ttmin + (ganttBarIndex - this.gbmin);
        }
    }
}

