/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.barlinechart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.util.barlinechart.BarLineChartModel;
import com.sas.graphics.resources.GraphResources;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.StringToFillStyleToGTKValues;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.cell.barlinechart.BIPBarSkinFactory;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Accumulator;
import com.sas.graphics.util.gtk.BarClusterer;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.Mapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericCache;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringMissingValueReplacement;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.BaseBar;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.MultiResponseStackedBar;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.SplineConnector;
import com.sas.graphics.util.gtk.gl.StepConnector;
import com.sas.graphics.util.gtk.gl.Switch;
import com.sas.measures.BaseLength;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public abstract class BarLineChartUtil {
    public static final int MAX_PREFERRED_ADJUSTED_RESPONSE_AXIS = (int)new BaseLength(12.0, "pt").getMagnitude((Object)"py") * 21;
    public static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);
    public static final BaseLength TARGET_SIZE = new BaseLength(6.0, "pt");
    public static final NumericProperty HIGHLIGHT_OFF = new NumericProperty();
    public static final int ADDBARS_DEFAULT = 0;
    public static final int ADDBARS_WATERFALL_TRENDLINE_ONLY = 1;
    public static final int ADDBARS_WATERFALL_BARS_ONLY = 2;

    public static void addStackedSubgroupedBars(Composites composites, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, double barElementPositionTranslation, int barClusterPosition, double barElementWidth, AdvancedTextStyle insideBarLabelTextStyle, AdvancedTextStyle outsideBarLabelTextStyle, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, double axisBaseline, boolean is3D, double z, ArrayList bb) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getBarVariableCount();
        Variable[] variableArray = axis.barVariableArray;
        Variable[] selectionVariableArray = axis.barSelectionVariableArray;
        Variable styleByVariable = variables.styleByVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        NumericVariable selectedPercentageVariable = variables.selectedPercentageVariable;
        Variable[] insideBarLabelVariableArray = variables.insideBarLabelVariableArray;
        Variable[] outsideBarLabelVariableArray = variables.outsideBarLabelVariableArray;
        boolean isResponseAxis = axis == variables.responseAxis;
        double axisLowerThreshold = isResponseAxis ? barLineChartModel.getResponseAxisLowerThreshold() : barLineChartModel.getResponse2AxisLowerThreshold();
        double axisUpperThreshold = isResponseAxis ? barLineChartModel.getResponseAxisUpperThreshold() : barLineChartModel.getResponse2AxisUpperThreshold();
        FillStyle lowerThresholdFillStyle = graphModel.getDataElementStyles().getLowerThresholdFillStyle();
        FillStyle upperThresholdFillStyle = graphModel.getDataElementStyles().getUpperThresholdFillStyle();
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        int skin = barLineChartModel.getSkin();
        ImageIcon barEffectsIcon = null;
        if (variableCount > 0) {
            axisBaselineMapper.shareMap(axisMapper);
            axisBaselineMapper.input.setValue(axisBaseline);
        }
        barEffectsIcon = BarLineChartUtil.createSkinIcon(skin, is3D, isVerticalOrientation);
        for (int n2 = 0; n2 < variableCount; ++n2) {
            NumericVariable barVariable;
            int ii = n2;
            if (!isVerticalOrientation) {
                ii = variableCount - 1 - n2;
            }
            if ((barVariable = (NumericVariable)variableArray[ii]) == null) continue;
            Bar bar = new Bar();
            bar.setDrawOrderSortEnabled(true);
            bb.add(bar);
            int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > ii ? 7 : 5;
            Util.SelectInfo.selectEnable((Element)bar, variableArray[ii], selectionOptions);
            bar.setTwoD(!is3D);
            if (z > 0.0 && barElementWidth > z) {
                barElementWidth = z;
            }
            bar.thickness.setValue(barElementWidth);
            bar.verticalOn.setValue(isVerticalOrientation);
            boolean edgeOn = outlineLineStyle.getVisibilityPolicy() == 10201 || outlineLineStyle.getVisibilityPolicy() == 10200 && bar.thickness.getValue() > 3.0;
            bar.edgeOn.setValue(edgeOn);
            bar.edgeColor.setValue(outlineLineStyle.getColor());
            bar.edgeWidth.setValue(outlineLineStyle.getThickness().getMagnitude((Object)"px"));
            bar.marker3DShape.setValue(barLineChartModel.getBarShape() == 10301 ? 1 : 0);
            if (styleByVariable instanceof StringVariable) {
                BarLineChartUtil.applyFillStyle(bar, cellModel.getFormattedValueToFillStyle(), (StringVariable)styleByVariable);
            } else if (styleByVariable instanceof NumericVariable) {
                BarLineChartUtil.applyNumericStyleByColors(bar, (NumericVariable)styleByVariable, cellModel, axisBaseline);
            }
            BidirectionalAccumulatorByCategory accStart = new BidirectionalAccumulatorByCategory();
            accStart.setPostAccumulate(true);
            accStart.category.connectFrom(categoryVariable.category);
            accStart.input.connectFrom(barVariable.value);
            ContinuousRangeToNumericMapper barStartMapper = new ContinuousRangeToNumericMapper();
            barStartMapper.shareMap(axisMapper);
            barStartMapper.input.connectFrom((NumericPipe)accStart);
            bar.startValue.connectFrom((NumericPipe)barStartMapper);
            BidirectionalAccumulatorByCategory accEnd = new BidirectionalAccumulatorByCategory();
            accEnd.setPostAccumulate(false);
            accEnd.category.connectFrom(categoryVariable.category);
            accEnd.input.connectFrom(barVariable.value);
            ContinuousRangeToNumericMapper barEndMapper = new ContinuousRangeToNumericMapper();
            barEndMapper.shareMap(axisMapper);
            barEndMapper.input.connectFrom((NumericPipe)accEnd);
            bar.endValue.connectFrom((NumericPipe)barEndMapper);
            bar.position.connectFrom((NumericPipe)categoryAxisMapper);
            int barPosition = (isVerticalOrientation ? ii : variableCount - 1 - ii) + barClusterPosition;
            if (isVerticalOrientation) {
                bar.transform.translateX.setValue(barElementPositionTranslation + barElementWidth * (double)barPosition);
            } else {
                bar.transform.translateY.setValue(barElementPositionTranslation + barElementWidth * (double)barPosition);
            }
            if (selectionVariableArray != null && selectionVariableArray.length > ii && selectionVariableArray[ii] instanceof NumericVariable && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName()))) {
                bar.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                if (selectedPercentageVariable != null) {
                    bar.highlightPercentage.connectFrom(selectedPercentageVariable.value);
                }
                bar.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                bar.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
            }
            if (barEffectsIcon != null) {
                bar.setSkin(barEffectsIcon.getImage());
            }
            BarLineChartUtil.applyThreshold(bar, axisBaseline, axisLowerThreshold, axisUpperThreshold, lowerThresholdFillStyle, upperThresholdFillStyle, barVariable.value, axisMapper);
            for (int bl = 0; bl < 2; ++bl) {
                Variable[] va = null;
                AdvancedTextStyle blts = null;
                NumericVariable dlv = null;
                StringPipe labelPipe = null;
                NumericPipe positionPipe = barVariable.value;
                double angle = Double.NaN;
                ContinuousRangeToNumericMapper labelMapper = new ContinuousRangeToNumericMapper();
                labelMapper.shareMap(axisMapper);
                switch (bl) {
                    case 0: {
                        BidirectionalAccumulatorByCategory accEnd2 = new BidirectionalAccumulatorByCategory();
                        accEnd2.setPostAccumulate(false);
                        accEnd2.category.connectFrom(categoryVariable.category);
                        accEnd2.input.connectFrom(barVariable.value);
                        labelMapper.input.connectFrom((NumericPipe)accEnd2);
                        va = insideBarLabelVariableArray;
                        blts = insideBarLabelTextStyle;
                        switch (barLineChartModel.getInsideBarLabelContent()) {
                            default: {
                                dlv = va != null ? va[ii % va.length] : null;
                                break;
                            }
                            case 10603: {
                                dlv = barVariable;
                                break;
                            }
                            case 10602: {
                                dlv = categoryVariable;
                            }
                        }
                        if (dlv != null) {
                            labelPipe = dlv.formattedValue;
                        }
                        angle = Double.NaN;
                        break;
                    }
                    case 1: {
                        int categoryIndex;
                        int kk;
                        va = outsideBarLabelVariableArray;
                        blts = outsideBarLabelTextStyle;
                        switch (barLineChartModel.getOutsideBarLabelContent()) {
                            default: {
                                dlv = va != null ? va[ii % va.length] : null;
                                break;
                            }
                            case 10603: {
                                dlv = barVariable;
                                break;
                            }
                            case 10602: {
                                dlv = categoryVariable;
                            }
                        }
                        int valueCount = categoryVariable.getValueCount();
                        double[] dataLabelValue = new double[valueCount];
                        double[] dataLabelPosition = new double[valueCount];
                        int uniqueValueCount = categoryVariable.getUniqueValueCount();
                        double[] uniqueDataLabelValue = new double[uniqueValueCount];
                        double[] uniqueDataLabelPosition = new double[uniqueValueCount];
                        for (kk = 0; kk < valueCount; ++kk) {
                            double barValue;
                            double dlvValue;
                            categoryIndex = GTKUtil.PipeAccess.getValue_as_int(categoryVariable.category, kk, -1);
                            if (categoryIndex < 0) continue;
                            if (dlv instanceof NumericVariable && !Double.isNaN(dlvValue = GTKUtil.PipeAccess.getValue_as_double(dlv.value, kk))) {
                                int n = categoryIndex;
                                uniqueDataLabelValue[n] = uniqueDataLabelValue[n] + dlvValue;
                            }
                            if (Double.isNaN(barValue = GTKUtil.PipeAccess.getValue_as_double(barVariable.value, kk))) continue;
                            if (barValue < 0.0) {
                                if (!(uniqueDataLabelPosition[categoryIndex] <= 0.0)) continue;
                                int n = categoryIndex;
                                uniqueDataLabelPosition[n] = uniqueDataLabelPosition[n] + barValue;
                                continue;
                            }
                            if (!(barValue > 0.0)) continue;
                            if (uniqueDataLabelPosition[categoryIndex] < 0.0) {
                                uniqueDataLabelPosition[categoryIndex] = barValue;
                                continue;
                            }
                            int n = categoryIndex;
                            uniqueDataLabelPosition[n] = uniqueDataLabelPosition[n] + barValue;
                        }
                        for (kk = 0; kk < valueCount; ++kk) {
                            categoryIndex = GTKUtil.PipeAccess.getValue_as_int(categoryVariable.category, kk, -1);
                            if (categoryIndex < 0) continue;
                            dataLabelValue[kk] = uniqueDataLabelValue[categoryIndex];
                            dataLabelPosition[kk] = uniqueDataLabelPosition[categoryIndex];
                            uniqueDataLabelValue[categoryIndex] = Double.NaN;
                            uniqueDataLabelPosition[categoryIndex] = Double.NaN;
                        }
                        if (dlv instanceof StringVariable) {
                            labelPipe = ((StringVariable)dlv).formattedValue;
                        } else if (dlv instanceof NumericVariable) {
                            NumericVectorVariable valueVar = VariableFactory.newNumericVectorVariable(dataLabelValue);
                            valueVar.setFormat(dlv.getFormat());
                            labelPipe = valueVar.formattedValue;
                        }
                        NumericVectorVariable positionVar = VariableFactory.newNumericVectorVariable(dataLabelPosition);
                        positionPipe = positionVar.value;
                        labelMapper.input.connectFrom(positionPipe);
                        double d = angle = cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN;
                    }
                }
                if (dlv == null) continue;
                BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, new Double(barElementPositionTranslation + barElementWidth * (double)barPosition), (NumericPipe)labelMapper, isVerticalOrientation ? null : new Double(5.0), z > 0.0 ? new Double(-z) : null, positionPipe, axisBaseline, blts, bl == 0, isVerticalOrientation, 0, false, angle);
            }
        }
    }

    public static void addStackedMultipleResponseBars(Composites composites, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, int previousVariableCount, double barElementPositionTranslation, int barClusterPosition, double barElementWidth, AdvancedTextStyle insideBarLabelTextStyle, AdvancedTextStyle outsideBarLabelTextStyle, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, boolean is3D, double z) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getBarVariableCount();
        if (variableCount <= 0) {
            return;
        }
        Variable[] variableArray = axis.barVariableArray;
        Variable[] selectionVariableArray = axis.barSelectionVariableArray;
        Color[] cycleColors = graphModel.getDataElementStyles().getDiscreteFillColors();
        FillStyle[] fillStyles = graphModel.getDataElementStyles().getFillStyles();
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        StringVariable categoryVariable = variables.categoryVariable;
        int skin = barLineChartModel.getSkin();
        ImageIcon barEffectsIcon = null;
        AdvancedTextStyle blts = null;
        NumericVariable blv = null;
        StringPipe labelPipe = null;
        NumericPipe positionPipe = null;
        NumericVariable barVariable = (NumericVariable)variableArray[0];
        double angle = Double.NaN;
        ContinuousRangeToNumericMapper labelMapper = new ContinuousRangeToNumericMapper();
        labelMapper.shareMap(axisMapper);
        axisBaselineMapper.shareMap(axisMapper);
        axisBaselineMapper.input.setValue(0.0);
        MultiResponseStackedBar mrsBar = new MultiResponseStackedBar();
        mrsBar.setDrawOrderSortEnabled(true);
        int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > 0 ? 7 : 5;
        Util.SelectInfo.selectEnable((Element)mrsBar, variableArray[0], selectionOptions);
        barEffectsIcon = BarLineChartUtil.createSkinIcon(skin, is3D, isVerticalOrientation);
        if (barEffectsIcon != null) {
            mrsBar.setSkin(barEffectsIcon.getImage());
        }
        mrsBar.setTwoD(!is3D);
        if (z > 0.0 && barElementWidth > z) {
            barElementWidth = z;
        }
        mrsBar.thickness.setValue(barElementWidth);
        mrsBar.marker3DShape.setValue(barLineChartModel.getBarShape() == 10301 ? 1 : 0);
        boolean edgeOn = outlineLineStyle.getVisibilityPolicy() == 10201 || outlineLineStyle.getVisibilityPolicy() == 10200 && mrsBar.thickness.getValue() > 3.0;
        mrsBar.edgeOn.setValue(edgeOn);
        mrsBar.edgeColor.setValue(outlineLineStyle.getColor());
        mrsBar.edgeWidth.setValue((double)((int)outlineLineStyle.getThickness().getMagnitude((Object)"px")));
        mrsBar.verticalOn.setValue(isVerticalOrientation);
        mrsBar.position.connectFrom((NumericPipe)categoryAxisMapper);
        if (isVerticalOrientation) {
            mrsBar.transform.translateX.setValue(barElementPositionTranslation + (double)barClusterPosition * barElementWidth);
        } else {
            mrsBar.transform.translateY.setValue(barElementPositionTranslation + (double)barClusterPosition * barElementWidth);
        }
        NumericProperty np = new NumericProperty();
        np.setValue(0.0);
        ContinuousRangeToNumericMapper rabm = new ContinuousRangeToNumericMapper();
        rabm.shareMap(axisMapper);
        rabm.input.connectFrom((NumericPipe)np);
        mrsBar.baseline.connectFrom(rabm.value);
        BarLineChartUtil.applyVariableAndFillStyle(mrsBar, fillStyles, cycleColors, previousVariableCount, variableArray, selectionVariableArray, variables.selectedPercentageVariable, axisMapper, cellModel);
        block10: for (int bl = 0; bl < 2; ++bl) {
            switch (bl) {
                case 0: {
                    blv = null;
                    continue block10;
                }
                case 1: {
                    int valueCount = categoryVariable.getValueCount();
                    double[] dataLabelValues = new double[valueCount];
                    double[] labelPositionValues = new double[valueCount];
                    blts = outsideBarLabelTextStyle;
                    switch (barLineChartModel.getOutsideBarLabelContent()) {
                        default: {
                            blv = null;
                            break;
                        }
                        case 10603: {
                            blv = barVariable;
                            break;
                        }
                        case 10602: {
                            blv = categoryVariable;
                        }
                    }
                    for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                        double sumOfBarValues = Double.NaN;
                        double negativeLabelPosition = 0.0;
                        double positiveLabelPosition = 0.0;
                        boolean foundPositive = false;
                        for (int variableIndex = 0; variableIndex < variableCount; ++variableIndex) {
                            barVariable = (NumericVariable)variableArray[variableIndex];
                            if (barVariable == null) continue;
                            try {
                                double barValue = barVariable.value.getValue(valueIndex);
                                sumOfBarValues = Double.isNaN(sumOfBarValues) ? barValue : (sumOfBarValues += barValue);
                                if (barValue > 0.0) {
                                    positiveLabelPosition += barValue;
                                    foundPositive = true;
                                    continue;
                                }
                                if (!(barValue < 0.0)) continue;
                                negativeLabelPosition += barValue;
                                continue;
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                        }
                        dataLabelValues[valueIndex] = sumOfBarValues;
                        labelPositionValues[valueIndex] = Double.isNaN(sumOfBarValues) ? Double.NaN : (foundPositive ? positiveLabelPosition : negativeLabelPosition);
                    }
                    if (blv instanceof StringVariable) {
                        labelPipe = ((StringVariable)blv).formattedValue;
                    } else if (blv instanceof NumericVariable) {
                        NumericVectorVariable valueVar = VariableFactory.newNumericVectorVariable(dataLabelValues);
                        GTKFormat format = axisMapper.getFormat();
                        valueVar.setFormat(format);
                        labelPipe = valueVar.formattedValue;
                    }
                    NumericVectorVariable positionVar = new NumericVectorVariable();
                    positionVar.connectFrom(labelPositionValues);
                    positionPipe = positionVar.value;
                    labelMapper.input.connectFrom(positionPipe);
                    angle = cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN;
                }
            }
        }
        if (blv != null) {
            BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, new Double(barElementPositionTranslation + (double)barClusterPosition * barElementWidth), (NumericPipe)labelMapper, isVerticalOrientation ? null : new Double(5.0), z > 0.0 ? new Double(-z) : null, positionPipe, 0.0, blts, false, isVerticalOrientation, 0, false, angle);
        }
        composites.barComposite = BarLineChartUtil.composite(composites, composites.barComposite);
        composites.barComposite.addElement((Element)mrsBar);
    }

    public static void addClusteredSubgroupedBars(Composites composites, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, double barElementWidth, AdvancedTextStyle insideBarLabelTextStyle, AdvancedTextStyle outsideBarLabelTextStyle, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, double axisBaseline, boolean is3D, double z, double axisLowerThreshold, double axisUpperThreshold) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getBarVariableCount();
        Variable[] variableArray = axis.barVariableArray;
        Variable[] selectionVariableArray = axis.barSelectionVariableArray;
        Variable[] highVariableArray = axis.barHighVariableArray;
        Variable[] lowVariableArray = axis.barLowVariableArray;
        Variable[] targetVariableArray = axis.barTargetVariableArray;
        StringVariable subgroupVariable = variables.subgroupVariable;
        Variable styleByVariable = variables.styleByVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        NumericVariable selectedPercentageVariable = variables.selectedPercentageVariable;
        Variable[] insideBarLabelVariableArray = variables.insideBarLabelVariableArray;
        Variable[] outsideBarLabelVariableArray = variables.outsideBarLabelVariableArray;
        FillStyle upperThresholdFillStyle = graphModel.getDataElementStyles().getUpperThresholdFillStyle();
        FillStyle lowerThresholdFillStyle = graphModel.getDataElementStyles().getLowerThresholdFillStyle();
        FillStyle errorFillStyle = graphModel.getDataElementStyles().getErrorFillStyles()[0];
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        int skin = barLineChartModel.getSkin();
        ImageIcon barEffectsIcon = null;
        if (variableCount > 0) {
            axisBaselineMapper.shareMap(axisMapper);
            axisBaselineMapper.input.setValue(axisBaseline);
            barEffectsIcon = BarLineChartUtil.createSkinIcon(skin, is3D, isVerticalOrientation);
            NumericVariable barVariable = (NumericVariable)variableArray[0];
            NumericVariable barHighVariable = (NumericVariable)highVariableArray[0];
            NumericVariable barLowVariable = (NumericVariable)lowVariableArray[0];
            NumericVariable barTargetVariable = (NumericVariable)targetVariableArray[0];
            Bar bar = new Bar();
            bar.setDrawOrderSortEnabled(true);
            composites.barComposite.addElement((Element)bar);
            int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > 0 ? 7 : 5;
            Util.SelectInfo.selectEnable((Element)bar, variableArray[0], selectionOptions);
            bar.setTwoD(!is3D);
            if (z > 0.0 && barElementWidth > z) {
                barElementWidth = z;
            }
            bar.thickness.setValue(barElementWidth);
            bar.marker3DShape.setValue(barLineChartModel.getBarShape() == 10301 ? 1 : 0);
            boolean edgeOn = outlineLineStyle.getVisibilityPolicy() == 10201 || outlineLineStyle.getVisibilityPolicy() == 10200 && bar.thickness.getValue() > 3.0;
            bar.edgeOn.setValue(edgeOn);
            bar.edgeColor.setValue(outlineLineStyle.getColor());
            bar.edgeWidth.setValue(outlineLineStyle.getThickness().getMagnitude((Object)"px"));
            bar.verticalOn.setValue(isVerticalOrientation);
            if (barTargetVariable != null) {
                ContinuousRangeToNumericMapper barTargetMapper = new ContinuousRangeToNumericMapper();
                barTargetMapper.shareMap(axisMapper);
                barTargetMapper.input.connectFrom(barTargetVariable.value);
                bar.targetValue.connectFrom((NumericPipe)barTargetMapper);
                bar.targetThickness.setValue((double)((int)(TARGET_SIZE.getMagnitude((Object)"px") + 0.5)));
                bar.targetGran.setValue(1.0);
                bar.targetOn.setValue(true);
                bar.targetColor.setValue(graphModel.getDataElementStyles().getTargetColor());
            }
            if (barHighVariable != null) {
                ContinuousRangeToNumericMapper barHighMapper = new ContinuousRangeToNumericMapper();
                barHighMapper.shareMap(axisMapper);
                barHighMapper.input.connectFrom(barHighVariable.value);
                bar.highValue.connectFrom((NumericPipe)barHighMapper);
                bar.highLowThickness.setValue(barElementWidth / 2.0);
                bar.highOn.setValue(true);
                bar.highColor.setValue(errorFillStyle.getSolidFillColor());
            }
            if (barLowVariable != null) {
                ContinuousRangeToNumericMapper barLowMapper = new ContinuousRangeToNumericMapper();
                barLowMapper.shareMap(axisMapper);
                barLowMapper.input.connectFrom(barLowVariable.value);
                bar.lowValue.connectFrom((NumericPipe)barLowMapper);
                bar.highLowThickness.setValue(barElementWidth / 2.0);
                bar.lowOn.setValue(true);
                bar.lowColor.setValue(errorFillStyle.getSolidFillColor());
            }
            if (styleByVariable instanceof StringVariable) {
                BarLineChartUtil.applyFillStyle(bar, cellModel.getFormattedValueToFillStyle(), (StringVariable)styleByVariable);
            } else if (styleByVariable instanceof NumericVariable) {
                BarLineChartUtil.applyNumericStyleByColors(bar, (NumericVariable)styleByVariable, cellModel, axisBaseline);
            }
            BarLineChartUtil.applyThreshold(bar, axisBaseline, axisLowerThreshold, axisUpperThreshold, lowerThresholdFillStyle, upperThresholdFillStyle, barVariable.value, axisMapper);
            ContinuousRangeToNumericMapper barEndMapper = new ContinuousRangeToNumericMapper();
            barEndMapper.shareMap(axisMapper);
            barEndMapper.input.connectFrom(barVariable.value);
            bar.position.connectFrom((NumericPipe)categoryAxisMapper);
            BarClusterer categoryCluster = new BarClusterer();
            categoryCluster.verticalOn.setValue(isVerticalOrientation);
            categoryCluster.setBarThickness(barElementWidth);
            categoryCluster.inputCategoryPosition.connectFrom((NumericPipe)categoryAxisMapper);
            categoryCluster.category.connectFrom(categoryVariable.formattedValue);
            categoryCluster.subgroup.connectFrom(subgroupVariable.formattedValue);
            categoryCluster.response.connectFrom(barVariable.value);
            bar.position.connectFrom(categoryCluster.outputCategoryPosition);
            bar.startValue.connectFrom((NumericPipe)axisBaselineMapper);
            bar.endValue.connectFrom((NumericPipe)barEndMapper);
            if (selectionVariableArray != null && selectionVariableArray.length > 0 && selectionVariableArray[0] instanceof NumericVariable && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(variableArray[0].getRootVariable().getColumnName()))) {
                bar.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[0]).value);
                if (selectedPercentageVariable != null) {
                    bar.highlightPercentage.connectFrom(selectedPercentageVariable.value);
                }
                bar.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                bar.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
            }
            if (barEffectsIcon != null) {
                bar.setSkin(barEffectsIcon.getImage());
            }
            for (int jj = 0; jj < 2; ++jj) {
                Variable dlv;
                int blc = 0;
                Variable[] va = null;
                AdvancedTextStyle blts = null;
                double angle = Double.NaN;
                switch (jj) {
                    case 0: {
                        va = insideBarLabelVariableArray;
                        blc = barLineChartModel.getInsideBarLabelContent();
                        blts = insideBarLabelTextStyle;
                        angle = Double.NaN;
                        break;
                    }
                    case 1: {
                        va = outsideBarLabelVariableArray;
                        blc = barLineChartModel.getOutsideBarLabelContent();
                        blts = outsideBarLabelTextStyle;
                        angle = cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN;
                    }
                }
                Variable variable = dlv = va == null ? null : va[0];
                if (blc == 10603) {
                    dlv = new StringVariable();
                    ((StringVariable)dlv).connectFrom(barVariable);
                } else if (blc == 10602) {
                    dlv = categoryVariable;
                }
                if (dlv == null) continue;
                StringPipe labelPipe = dlv instanceof StringVariable ? ((StringVariable)dlv).formattedValue : ((NumericVariable)dlv).formattedValue;
                BarClusterer categoryCluster2 = new BarClusterer();
                categoryCluster2.verticalOn.setValue(isVerticalOrientation);
                categoryCluster2.setBarThickness(barElementWidth);
                categoryCluster2.inputCategoryPosition.connectFrom((NumericPipe)categoryAxisMapper);
                categoryCluster2.category.connectFrom(categoryVariable.formattedValue);
                categoryCluster2.subgroup.connectFrom(subgroupVariable.formattedValue);
                categoryCluster2.response.connectFrom(barVariable.value);
                BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, categoryCluster2, (NumericPipe)barEndMapper, isVerticalOrientation ? null : new Double(5.0), z > 0.0 ? new Double(-z) : null, barVariable.value, axisBaseline, blts, jj == 0, isVerticalOrientation, 0, false, angle);
            }
        }
    }

    public static void addBars(Composites composites, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, int previousVariableCount, double barElementPositionTranslation, int barClusterPosition, Double initialBarHeight, double barElementWidth, AdvancedTextStyle insideBarLabelTextStyle, AdvancedTextStyle outsideBarLabelTextStyle, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, double axisBaseline, boolean is3D, double z, double axisLowerThreshold, double axisUpperThreshold, ArrayList bb, double waterfallLineXDist, String waterfallInitialBarID, String waterfallFinalBarID, double[] waterfallFinalResponseValues, double[] waterfallFinalOutsideDataLabelValues, int variant, BoundingBox graphAreaClippingBox) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getBarVariableCount();
        Variable[] variableArray = axis.barVariableArray;
        Variable[] selectionVariableArray = axis.barSelectionVariableArray;
        Variable[] highVariableArray = axis.barHighVariableArray;
        Variable[] lowVariableArray = axis.barLowVariableArray;
        Variable[] targetVariableArray = axis.barTargetVariableArray;
        Variable styleByVariable = variables.styleByVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        NumericVariable selectedPercentageVariable = variables.selectedPercentageVariable;
        Variable[] insideBarLabelVariableArray = variables.insideBarLabelVariableArray;
        Variable[] outsideBarLabelVariableArray = variables.outsideBarLabelVariableArray;
        int totalBarVariableCount = variables.getTotalBarVariableCount();
        int totalLineVariableCount = variables.getTotalLineVariableCount();
        FillStyle upperThresholdFillStyle = graphModel.getDataElementStyles().getUpperThresholdFillStyle();
        FillStyle lowerThresholdFillStyle = graphModel.getDataElementStyles().getLowerThresholdFillStyle();
        FillStyle errorFillStyle = graphModel.getDataElementStyles().getErrorFillStyles()[0];
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        Color[] cycleColors = graphModel.getDataElementStyles().getDiscreteFillColors();
        FillStyle[] fillStyles = graphModel.getDataElementStyles().getFillStyles();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        int skin = barLineChartModel.getSkin();
        ImageIcon barEffectsIcon = null;
        if (variableCount > 0) {
            axisBaselineMapper.shareMap(axisMapper);
            axisBaselineMapper.input.setValue(axisBaseline);
            barEffectsIcon = BarLineChartUtil.createSkinIcon(skin, is3D, isVerticalOrientation);
            for (int n = 0; n < variableCount; ++n) {
                int ii = isVerticalOrientation ? n : variableCount - 1 - n;
                NumericVariable barVariable = (NumericVariable)variableArray[ii];
                NumericVariable barHighVariable = (NumericVariable)highVariableArray[ii];
                NumericVariable barLowVariable = (NumericVariable)lowVariableArray[ii];
                NumericVariable barTargetVariable = (NumericVariable)targetVariableArray[ii];
                if (barVariable == null) continue;
                Variable outsideBarLabelVariable = outsideBarLabelVariableArray != null && outsideBarLabelVariableArray.length > ii ? outsideBarLabelVariableArray[ii] : null;
                Bar bar = new Bar();
                bb.add(bar);
                int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > ii ? 7 : 5;
                Util.SelectInfo.selectEnable((Element)bar, variableArray[ii], selectionOptions);
                bar.setTwoD(!is3D);
                if (z > 0.0 && barElementWidth > z) {
                    barElementWidth = z;
                }
                bar.thickness.setValue(barElementWidth);
                bar.verticalOn.setValue(isVerticalOrientation);
                boolean edgeOn = outlineLineStyle.getVisibilityPolicy() == 10201 || outlineLineStyle.getVisibilityPolicy() == 10200 && bar.thickness.getValue() > 3.0;
                bar.edgeOn.setValue(edgeOn);
                bar.edgeColor.setValue(outlineLineStyle.getColor());
                bar.edgeWidth.setValue(outlineLineStyle.getThickness().getMagnitude((Object)"px"));
                bar.marker3DShape.setValue(barLineChartModel.getBarShape() == 10301 ? 1 : 0);
                if (barEffectsIcon != null) {
                    bar.setSkin(barEffectsIcon.getImage());
                }
                if (totalBarVariableCount + totalLineVariableCount > 1 || styleByVariable == null) {
                    FillStyle fillStyle = Util.newCycledFillStyle(fillStyles, cycleColors, ii + previousVariableCount);
                    BarLineChartUtil.applyFillStyle(bar, fillStyle);
                } else if (styleByVariable instanceof StringVariable) {
                    BarLineChartUtil.applyFillStyle(bar, cellModel.getFormattedValueToFillStyle(), (StringVariable)styleByVariable);
                } else if (styleByVariable instanceof NumericVariable) {
                    BarLineChartUtil.applyNumericStyleByColors(bar, (NumericVariable)styleByVariable, cellModel, barLineChartModel.isWaterfallEnabled() ? 0.0 : axisBaseline);
                }
                BarLineChartUtil.applyThreshold(bar, axisBaseline, axisLowerThreshold, axisUpperThreshold, lowerThresholdFillStyle, upperThresholdFillStyle, barVariable.value, axisMapper);
                ContinuousRangeToNumericMapper barEndMapper = new ContinuousRangeToNumericMapper();
                barEndMapper.shareMap(axisMapper);
                barEndMapper.input.connectFrom(barVariable.value);
                bar.endValue.connectFrom((NumericPipe)barEndMapper);
                bar.position.connectFrom((NumericPipe)categoryAxisMapper);
                bar.startValue.connectFrom((NumericPipe)axisBaselineMapper);
                int barPosition = (isVerticalOrientation ? ii : variableCount - 1 - ii) + barClusterPosition;
                if (isVerticalOrientation) {
                    bar.transform.translateX.setValue(barElementPositionTranslation + barElementWidth * (double)barPosition);
                } else {
                    bar.transform.translateY.setValue(barElementPositionTranslation + barElementWidth * (double)barPosition);
                }
                if (!barLineChartModel.isWaterfallEnabled()) {
                    if (barTargetVariable != null) {
                        ContinuousRangeToNumericMapper barTargetMapper = new ContinuousRangeToNumericMapper();
                        barTargetMapper.shareMap(axisMapper);
                        barTargetMapper.input.connectFrom(barTargetVariable.value);
                        bar.targetValue.connectFrom((NumericPipe)barTargetMapper);
                        bar.targetThickness.setValue((double)((int)(TARGET_SIZE.getMagnitude((Object)"px") + 0.5)));
                        bar.targetGran.setValue(1.0);
                        bar.targetOn.setValue(true);
                        bar.targetColor.setValue(graphModel.getDataElementStyles().getTargetColor());
                    }
                    if (barHighVariable != null) {
                        ContinuousRangeToNumericMapper barHighMapper = new ContinuousRangeToNumericMapper();
                        barHighMapper.shareMap(axisMapper);
                        barHighMapper.input.connectFrom(barHighVariable.value);
                        bar.highValue.connectFrom((NumericPipe)barHighMapper);
                        bar.highLowThickness.setValue(barElementWidth / 2.0);
                        bar.highOn.setValue(true);
                        bar.highColor.setValue(errorFillStyle.getSolidFillColor());
                    }
                    if (barLowVariable != null) {
                        ContinuousRangeToNumericMapper barLowMapper = new ContinuousRangeToNumericMapper();
                        barLowMapper.shareMap(axisMapper);
                        barLowMapper.input.connectFrom(barLowVariable.value);
                        bar.lowValue.connectFrom((NumericPipe)barLowMapper);
                        bar.highLowThickness.setValue(barElementWidth / 2.0);
                        bar.lowOn.setValue(true);
                        bar.lowColor.setValue(errorFillStyle.getSolidFillColor());
                    }
                    if (variables.responseAxis.barVariableArray != null && variables.response2Axis.barVariableArray != null && variables.responseAxis.barVariableArray.length > 0 && variables.response2Axis.barVariableArray.length > 0) {
                        bar.setConfidenceLimitEnabled(false);
                    } else if (barLowVariable != null && barLowVariable.getValueCount() > 0 && barHighVariable != null && barHighVariable.getValueCount() > 0) {
                        bar.setConfidenceLimitEnabled(barLineChartModel.isConfidenceLimitEnabled());
                    }
                } else {
                    double startValue = initialBarHeight != null ? initialBarHeight : 0.0;
                    Accumulator waterfallStartAcc = new Accumulator();
                    waterfallStartAcc.setPostAccumulate(true);
                    waterfallStartAcc.input.connectFrom(barVariable.value);
                    waterfallStartAcc.setStartValue(startValue);
                    ContinuousRangeToNumericMapper waterfallBarStartMapper = new ContinuousRangeToNumericMapper();
                    waterfallBarStartMapper.shareMap(axisMapper);
                    waterfallBarStartMapper.input.connectFrom((NumericPipe)waterfallStartAcc);
                    bar.startValue.disconnect();
                    bar.startValue.connectFrom((NumericPipe)waterfallBarStartMapper);
                    Accumulator waterfallEndAcc = new Accumulator();
                    waterfallEndAcc.setPostAccumulate(false);
                    waterfallEndAcc.input.connectFrom(barVariable.value);
                    waterfallEndAcc.setStartValue(startValue);
                    barEndMapper.input.disconnect();
                    barEndMapper.input.connectFrom((NumericPipe)waterfallEndAcc);
                    String initialBarOutsideBarLabelDataLabel = null;
                    String finalBarOutsideBarLabelDataLabel = null;
                    Formatter outsideBarDataLabelFormatter = null;
                    switch (barLineChartModel.getOutsideBarLabelContent()) {
                        default: {
                            if (!(outsideBarLabelVariable instanceof NumericVariable)) break;
                            outsideBarDataLabelFormatter = outsideBarLabelVariable.getFormatter();
                            if (waterfallFinalOutsideDataLabelValues == null || ii >= waterfallFinalOutsideDataLabelValues.length) break;
                            double finalBarOutsideDatalabelValue = waterfallFinalOutsideDataLabelValues[ii];
                            finalBarOutsideBarLabelDataLabel = outsideBarDataLabelFormatter.format((Object)new Double(finalBarOutsideDatalabelValue));
                            break;
                        }
                        case 10603: {
                            outsideBarDataLabelFormatter = barVariable.getFormatter();
                            if (waterfallFinalResponseValues == null || ii >= waterfallFinalResponseValues.length) break;
                            double finalBarOutsideDatalabelValue = waterfallFinalResponseValues[ii];
                            finalBarOutsideBarLabelDataLabel = outsideBarDataLabelFormatter.format((Object)new Double(finalBarOutsideDatalabelValue));
                            break;
                        }
                        case 10602: {
                            if (waterfallFinalBarID == null) break;
                            finalBarOutsideBarLabelDataLabel = waterfallFinalBarID;
                        }
                    }
                    if (initialBarHeight != null) {
                        Formatter initialBarDataLabelFormatter = null;
                        switch (barLineChartModel.getOutsideBarLabelContent()) {
                            default: {
                                Integer outsideBarLabelStatistic;
                                if (!(outsideBarLabelVariable instanceof NumericVariable)) break;
                                VariableDefinition barResponseVariableDefinition = variables.dataSource.getVariableDefinition(variables.responseAxis.barRole, ii);
                                VariableDefinition outsideBarLabelVariableDefinition = variables.dataSource.getVariableDefinition(variables.outsideBarLabelRole, ii);
                                if (!(barResponseVariableDefinition instanceof AnalysisVariableDefinition) || !(outsideBarLabelVariableDefinition instanceof AnalysisVariableDefinition) || !((AnalysisVariableDefinition)barResponseVariableDefinition).isCompatableStatistic(outsideBarLabelStatistic = ((AnalysisVariableDefinition)outsideBarLabelVariableDefinition).getStatistic())) break;
                                initialBarDataLabelFormatter = outsideBarLabelVariable.getFormatter();
                                initialBarOutsideBarLabelDataLabel = initialBarDataLabelFormatter.format((Object)initialBarHeight);
                                break;
                            }
                            case 10603: {
                                initialBarDataLabelFormatter = barVariable.getFormatter();
                                initialBarOutsideBarLabelDataLabel = initialBarDataLabelFormatter.format((Object)initialBarHeight);
                                break;
                            }
                            case 10602: {
                                if (waterfallInitialBarID == null) break;
                                initialBarOutsideBarLabelDataLabel = waterfallInitialBarID;
                            }
                        }
                    }
                    if (variant == 0 || variant == 1) {
                        if (variant == 1) {
                            bar.edgeOn.setValue(false);
                            bar.fillOn.setValue(false);
                        }
                        if (barLineChartModel.getTrendlineType() != 11900 && graphModel.getDataElementStyles().getOutlineLineStyle().getVisibilityPolicy() != 10202) {
                            bar.trendLineOn.setValue(true);
                            switch (barLineChartModel.getTrendlineType()) {
                                default: {
                                    bar.trendLineType.setValue(1);
                                    break;
                                }
                                case 11902: {
                                    bar.trendLineType.setValue(0);
                                }
                            }
                            Color negativeSlopeColor = graphModel.getDataElementStyles().getContinuousContrastThreeColorStartColor();
                            Color zeroSlopeColor = graphModel.getDataElementStyles().getContinuousContrastThreeColorNeutralColor();
                            Color positiveSlopeColor = graphModel.getDataElementStyles().getContinuousContrastThreeColorEndColor();
                            DiscreteRangeToColorMapper trendLineColorMapper = new DiscreteRangeToColorMapper();
                            trendLineColorMapper.setReplaceMissingValues(false);
                            NumericRangeSegment negativeSlopeRange = new NumericRangeSegment(Double.NEGATIVE_INFINITY, 0.0, false, false, (Object)negativeSlopeColor);
                            NumericRangeSegment zeroSlopeRange = new NumericRangeSegment(0.0, 0.0, true, true, (Object)zeroSlopeColor);
                            NumericRangeSegment positiveSlopeRange = new NumericRangeSegment(0.0, Double.POSITIVE_INFINITY, false, false, (Object)positiveSlopeColor);
                            trendLineColorMapper.setRangeSegments(new NumericRangeSegment[]{negativeSlopeRange, zeroSlopeRange, positiveSlopeRange});
                            trendLineColorMapper.input.connectFrom(barVariable.value);
                            bar.trendLineColor.connectFrom((ColorPipe)trendLineColorMapper);
                            bar.trendLineInitialOn.setValue(initialBarHeight != null);
                            bar.trendLineInitialX.setValue(barElementWidth / 2.0);
                            bar.trendLineInitialY.setValue(axisMapper.getValue(startValue));
                        }
                    }
                    composites.waterfallComposite = BarLineChartUtil.composite(composites, composites.waterfallComposite);
                    if (is3D) {
                        composites.waterfallComposite.transform.translateZ.setValue(-z / 2.0);
                    }
                    if (graphAreaClippingBox != null) {
                        composites.waterfallComposite.setClipBounds(graphAreaClippingBox);
                    }
                    if (variant == 0 || variant == 2) {
                        if (variant == 2) {
                            bar.trendLineOn.setValue(false);
                        }
                        if (initialBarHeight != null) {
                            BarLineChartUtil.addExtraBar(composites.waterfallComposite, bar, graphModel.getDataElementStyles().getInitialFillStyle(), axisMapper, axisBaselineMapper, initialBarHeight, barElementPositionTranslation + barElementWidth * (double)(ii + barClusterPosition), categoryAxisMapper, waterfallInitialBarID);
                            BarLineChartUtil.addExtraDataLabel(composites.dataLabelComposite, false, axisMapper, initialBarHeight, barElementPositionTranslation + barElementWidth * (double)(ii + barClusterPosition), is3D ? -z : 0.0, categoryAxisMapper, waterfallInitialBarID, outsideBarLabelTextStyle, isVerticalOrientation, axisBaseline, isVerticalOrientation ? null : new Double(5.0), initialBarOutsideBarLabelDataLabel, cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN);
                        }
                        if (waterfallFinalBarID != null) {
                            BarLineChartUtil.addExtraBar(composites.waterfallComposite, bar, graphModel.getDataElementStyles().getFinalFillStyle(), axisMapper, axisBaselineMapper, waterfallFinalResponseValues[ii], barElementPositionTranslation + barElementWidth * (double)(ii + barClusterPosition), categoryAxisMapper, waterfallFinalBarID);
                            BarLineChartUtil.addExtraDataLabel(composites.dataLabelComposite, false, axisMapper, waterfallFinalResponseValues[ii], barElementPositionTranslation + barElementWidth * (double)(ii + barClusterPosition), is3D ? -z : 0.0, categoryAxisMapper, waterfallFinalBarID, outsideBarLabelTextStyle, isVerticalOrientation, axisBaseline, isVerticalOrientation ? null : new Double(5.0), finalBarOutsideBarLabelDataLabel, cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN);
                        }
                    }
                }
                if (selectionVariableArray != null && selectionVariableArray.length > ii && selectionVariableArray[ii] instanceof NumericVariable && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName()))) {
                    bar.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                    if (selectedPercentageVariable != null) {
                        bar.highlightPercentage.connectFrom(selectedPercentageVariable.value);
                    }
                    bar.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                    bar.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
                }
                for (int jj = 0; jj < 2; ++jj) {
                    Variable dlv;
                    int blc = 0;
                    Variable[] va = null;
                    AdvancedTextStyle blts = null;
                    double angle = Double.NaN;
                    switch (jj) {
                        case 0: {
                            va = insideBarLabelVariableArray;
                            blc = barLineChartModel.getInsideBarLabelContent();
                            blts = insideBarLabelTextStyle;
                            angle = Double.NaN;
                            break;
                        }
                        case 1: {
                            va = outsideBarLabelVariableArray;
                            blc = barLineChartModel.getOutsideBarLabelContent();
                            blts = outsideBarLabelTextStyle;
                            angle = cellModel.getDataLabelAdjustmentInfo() != null ? cellModel.getDataLabelAdjustmentInfo().outsideBarLabelAngle : Double.NaN;
                        }
                    }
                    Variable variable = dlv = va == null ? null : va[(ii + previousVariableCount) % va.length];
                    if (blc == 10603) {
                        dlv = new StringVariable();
                        ((StringVariable)dlv).connectFrom(barVariable);
                    } else if (blc == 10602) {
                        dlv = categoryVariable;
                    }
                    if (dlv == null) continue;
                    StringPipe labelPipe = dlv instanceof StringVariable ? ((StringVariable)dlv).formattedValue : ((NumericVariable)dlv).formattedValue;
                    BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, new Double(barElementPositionTranslation + barElementWidth * (double)barPosition), (NumericPipe)barEndMapper, isVerticalOrientation ? null : new Double(5.0), z > 0.0 ? new Double(-z) : null, barVariable.value, barLineChartModel.isWaterfallEnabled() ? 0.0 : axisBaseline, blts, jj == 0, isVerticalOrientation, 0, barLineChartModel.isWaterfallEnabled(), angle);
                }
            }
        }
    }

    public static void addLines(Composites composites, DataSource dataSource, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, int previousVariableCount, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, double axisBaseline, boolean linesOnBackWall, double z) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getLineVariableCount();
        Variable[] variableArray = axis.lineVariableArray;
        Variable[] selectionVariableArray = axis.lineSelectionVariableArray;
        Variable styleByVariable = variables.styleByVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        Variable[] outsideMarkerLabelVariableArray = variables.outsideMarkerLabelVariableArray;
        int totalBarVariableCount = variables.getTotalBarVariableCount();
        int totalLineVariableCount = variables.getTotalLineVariableCount();
        FillStyle[] fillStyles = graphModel.getDataElementStyles().getFillStyles();
        StrokeLineStyle[] lineStyles = graphModel.getDataElementStyles().getLineStyles();
        MarkerStyle[] markerStyles = graphModel.getDataElementStyles().getMarkerStyles();
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        Color[] cycleColors = graphModel.getDataElementStyles().getDiscreteFillColors();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        ImageIcon markerEffectsIcon = null;
        if (barLineChartModel.isMarkerEnabled()) {
            int skint = barLineChartModel.getSkin();
            switch (skint) {
                case 12301: {
                    markerEffectsIcon = GraphResources.getImageIcon("skin/satin/marker/MarkerEffects.png");
                    break;
                }
                case 12302: {
                    markerEffectsIcon = GraphResources.getImageIcon("skin/modern/marker/MarkerEffects.png");
                    break;
                }
            }
        }
        if (variableCount > 0) {
            axisBaselineMapper.shareMap(axisMapper);
            axisBaselineMapper.input.setValue(axisBaseline);
        }
        for (int ii = 0; ii < variableCount; ++ii) {
            NumericVariable lineVariable = (NumericVariable)variableArray[ii];
            if (lineVariable == null) continue;
            ContinuousRangeToNumericMapper vertexMapper = new ContinuousRangeToNumericMapper();
            vertexMapper.shareMap(axisMapper);
            vertexMapper.input.connectFrom(lineVariable.value);
            StrokeLineStyle lineStyle = Util.newCycledLineStyle(lineStyles, cycleColors, ii + previousVariableCount + totalBarVariableCount);
            MarkerStyle markerStyle = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii + previousVariableCount + totalBarVariableCount);
            FillStyle fillStyle = barLineChartModel.isFillAreaEnabled() ? Util.newCycledFillStyle(fillStyles, cycleColors, ii + previousVariableCount + totalBarVariableCount) : null;
            FilledLineConnector line = BarLineChartUtil.newLineConnector(lineStyle, markerStyle, barLineChartModel.isInterpolationEnabled(), barLineChartModel.isMarkerEnabled());
            composites.lineComposite = BarLineChartUtil.composite(composites, composites.lineComposite);
            composites.lineComposite.addElement((Element)line);
            line.setSkipMissingOn(barLineChartModel.isSkipMissing());
            if (dataSource.isSummarizationEnabled() || markerStyle.getConnectionOrder() == 40100) {
                line.pointX.connectFrom((NumericPipe)categoryAxisMapper);
                line.pointY.connectFrom((NumericPipe)vertexMapper);
            } else {
                NumericCache xCache = new NumericCache();
                NumericCache yCache = new NumericCache();
                xCache.input.connectFrom(categoryAxisMapper.value);
                yCache.input.connectFrom(vertexMapper.value);
                line.pointX.connectFrom((NumericPipe)xCache);
                line.pointY.connectFrom((NumericPipe)yCache);
            }
            if (linesOnBackWall) {
                line.transform.translateZ.setValue(-z);
            }
            if (fillStyle != null && fillStyle.isVisible()) {
                line.fillOn.setValue(true);
                line.fillColor.setValue(fillStyle.getSolidFillColor());
                double baseLinePositionInWorld = 0.0;
                try {
                    baseLinePositionInWorld = axisBaselineMapper.getValue(0);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                line.setFillToPlane(new Plane(new Vec3d(0.0, baseLinePositionInWorld, 0.0), new Vec3d(1.0, baseLinePositionInWorld, 0.0), new Vec3d(0.0, baseLinePositionInWorld, 1.0)));
            }
            Double dataLabelAdjustemnt = null;
            if (barLineChartModel.isMarkerEnabled()) {
                if (styleByVariable instanceof StringVariable && totalBarVariableCount + totalLineVariableCount < 2) {
                    Switch markerSwitch = new Switch();
                    composites.markerComposite = BarLineChartUtil.composite(composites, composites.markerComposite);
                    composites.markerComposite.addElement((Element)markerSwitch);
                    if (linesOnBackWall) {
                        markerSwitch.transform.translateZ.setValue(-z);
                    }
                    markerSwitch.whichChoice.connectFrom(((StringVariable)styleByVariable).category);
                    int count = styleByVariable.getUniqueValueCount();
                    for (int jj = 0; jj < count; ++jj) {
                        markerStyle = Util.newCycledMarkerStyle(markerStyles, cycleColors, jj);
                        if (markerStyle == null) continue;
                        Marker marker = new Marker();
                        markerSwitch.addChoice((Element)marker);
                        int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > ii ? 7 : 5;
                        Util.SelectInfo.selectEnable((Element)marker, variableArray[ii], selectionOptions);
                        marker.coordX.connectFrom((NumericPipe)categoryAxisMapper);
                        marker.coordY.connectFrom((NumericPipe)vertexMapper);
                        marker.setFast(false);
                        if (linesOnBackWall) {
                            marker.transform.translateZ.setValue(-z);
                        }
                        if (markerStyle.isVisible() && markerStyle.getSymbol() != -1) {
                            marker.type.setValue(markerStyle.getSymbol());
                            marker.color.setValue(markerStyle.getColor());
                            if (outlineLineStyle.getVisibilityPolicy() == 10201) {
                                marker.edgeColor.setValue(outlineLineStyle.getColor());
                            } else {
                                marker.edgeColor.setValue(markerStyle.getColor());
                            }
                            if (markerEffectsIcon != null) {
                                marker.setSkin(markerEffectsIcon.getImage());
                            }
                        } else {
                            marker.type.setValue(-1);
                            marker.color.setValue(INVISIBLE_COLOR);
                            marker.edgeColor.setValue(INVISIBLE_COLOR);
                        }
                        dataLabelAdjustemnt = new Double(markerStyle.getSize().getMagnitude((Object)"px") / 2.0);
                        marker.size.setValue((int)(dataLabelAdjustemnt * 2.0));
                        if (selectionVariableArray == null || selectionVariableArray.length <= ii || !(selectionVariableArray[ii] instanceof NumericVariable) || cellModel.getRuleTargetIdentifier() != null && !cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName())) continue;
                        marker.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                        marker.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                        marker.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
                    }
                } else {
                    Marker marker = new Marker();
                    composites.markerComposite = BarLineChartUtil.composite(composites, composites.markerComposite);
                    composites.markerComposite.addElement((Element)marker);
                    int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > ii ? 7 : 5;
                    Util.SelectInfo.selectEnable((Element)marker, variableArray[ii], selectionOptions);
                    marker.coordX.connectFrom((NumericPipe)categoryAxisMapper);
                    marker.coordY.connectFrom((NumericPipe)vertexMapper);
                    if (markerStyle != null && markerStyle.isVisible() && markerStyle.getSymbol() != -1) {
                        if (linesOnBackWall) {
                            marker.transform.translateZ.setValue(-z);
                        }
                        marker.type.setValue(markerStyle.getSymbol());
                        if (styleByVariable instanceof NumericVariable && totalBarVariableCount + totalLineVariableCount < 2) {
                            ContinuousRangeToColorMapper colorMapper;
                            ContinuousRangeToColorMapper cr2cm = cellModel.getValueToContinuousColor();
                            DiscreteRangeToColorMapper dr2cm = cellModel.getFormattedValueToDiscreteColor();
                            if (cr2cm != null) {
                                colorMapper = new ContinuousRangeToColorMapper();
                                colorMapper.shareMap(cr2cm);
                                colorMapper.input.connectFrom(((NumericVariable)styleByVariable).value);
                                marker.color.connectFrom((ColorPipe)cr2cm);
                            } else if (dr2cm != null) {
                                colorMapper = new DiscreteRangeToColorMapper();
                                colorMapper.shareMap(dr2cm);
                                colorMapper.input.connectFrom(((NumericVariable)styleByVariable).value);
                                marker.color.connectFrom((ColorPipe)dr2cm);
                            }
                        } else {
                            marker.color.setValue(markerStyle.getColor());
                        }
                        if (outlineLineStyle.getVisibilityPolicy() == 10201) {
                            marker.edgeColor.setValue(outlineLineStyle.getColor());
                        } else {
                            marker.edgeColor.setValue(markerStyle.getColor());
                        }
                        dataLabelAdjustemnt = new Double(markerStyle.getSize().getMagnitude((Object)"px") / 2.0);
                        marker.size.setValue((int)(dataLabelAdjustemnt * 2.0));
                        if (markerEffectsIcon != null) {
                            marker.setSkin(markerEffectsIcon.getImage());
                        }
                    } else {
                        marker.type.setValue(-1);
                        marker.color.setValue(INVISIBLE_COLOR);
                        marker.edgeColor.setValue(INVISIBLE_COLOR);
                    }
                    if (selectionVariableArray != null && selectionVariableArray.length > ii && selectionVariableArray[ii] instanceof NumericVariable && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName()))) {
                        marker.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                        marker.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                        marker.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
                    }
                }
            }
            for (int jj = 1; jj < 2; ++jj) {
                Variable dlv;
                int blc = 0;
                Variable[] va = null;
                AdvancedTextStyle blts = null;
                switch (jj) {
                    case 1: {
                        va = outsideMarkerLabelVariableArray;
                        blc = barLineChartModel.getOutsideMarkerLabelContent();
                        blts = barLineChartModel.getOutsideMarkerLabelTextStyle();
                    }
                }
                Variable variable = dlv = va == null ? null : va[(ii + previousVariableCount) % va.length];
                if (blc == 10603) {
                    dlv = new StringVariable();
                    ((StringVariable)dlv).connectFrom(lineVariable);
                } else if (blc == 10602) {
                    dlv = categoryVariable;
                }
                if (dlv == null) continue;
                StringPipe labelPipe = dlv instanceof StringVariable ? ((StringVariable)dlv).formattedValue : ((NumericVariable)dlv).formattedValue;
                BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, null, (NumericPipe)vertexMapper, dataLabelAdjustemnt, z > 0.0 ? new Double(-z) : null, lineVariable.value, axisBaseline, blts, jj == 0, isVerticalOrientation, linesOnBackWall ? 1 : 2, false, Double.NaN);
            }
        }
    }

    public static void addAxisWall(Channel channel, Composites composites, BarLineChartVariables variables, BarLineChartAxisVariables axis, DataSource dataSource, int cellRow, int cellColumn, StringToNumericMapper categoryAxisMapper, boolean is3D, double xAxisLength, int xStart, int xEnd, double yAxisLength, int yStart, int yEnd, BarLineChartCellModel cellModel, AxisCellModel responseAxisCellModel, AxisCellModel response2AxisCellModel, AxisCellModel categoryAxisCellModel, int categoryAxisTitleWidth, int categoryAxisTitleHeight, double z, Rectangle b, BoundingBox graphAreaClippingBox) {
        GTKUtil.LineAttributes gla;
        StrokeLineStyle gridlineLineStyle;
        GridStyle gtkGridStyle;
        boolean isVerticalOrientation;
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int barVariableCount = axis.getBarVariableCount();
        int lineVariableCount = axis.getLineVariableCount();
        StringVariable categoryVariable = variables.categoryVariable;
        boolean bl = isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        if (barLineChartModel.getAxisWallModel().getWallFillStyle().isVisible()) {
            FillStyle wallFillStyle = barLineChartModel.getAxisWallModel().getWallFillStyle();
            if (is3D) {
                Box frameBox = new Box();
                composites.axisWallComposite = BarLineChartUtil.composite(composites, composites.axisWallComposite);
                composites.axisWallComposite.addElement((Element)frameBox);
                frameBox.selectEnabled.setValue(false);
                frameBox.setNormalsReversed(true);
                frameBox.sizeX.setValue(xAxisLength + (double)xStart + (double)xEnd - 1.0);
                frameBox.sizeY.setValue(yAxisLength + (double)yStart + (double)yEnd);
                frameBox.sizeZ.setValue(z);
                frameBox.transform.translateX.setValue((double)(-xStart) / 2.0 + (xAxisLength + (double)xEnd) / 2.0 - 1.0);
                frameBox.transform.translateY.setValue((double)(-yStart) / 2.0 + (yAxisLength + (double)yEnd) / 2.0);
                frameBox.transform.translateZ.setValue(-z / 2.0);
                frameBox.origin.setValue(0);
                frameBox.color.setValue(wallFillStyle.getSolidFillColor());
                frameBox.fillOn.setValue(true);
                frameBox.edgeOn.setValue(true);
                frameBox.edgeColor.setValue(graphModel.getFrameLineStyle().getColor());
            } else {
                Grid axisWall = new Grid();
                axisWall.selectEnabled.setValue(false);
                GTKUtil.applyFillStyle(axisWall, wallFillStyle);
                composites.axisWallComposite = BarLineChartUtil.composite(composites, composites.axisWallComposite);
                composites.axisWallComposite.addElement((Element)axisWall);
                if (isVerticalOrientation) {
                    axisWall.transform.translateX.setValue((double)(-xStart + (barVariableCount + lineVariableCount > 0 ? 0 : 1)));
                    axisWall.transform.translateY.setValue((double)(-yStart));
                    axisWall.setWidth((double)(b.width - categoryAxisTitleWidth - 1));
                    axisWall.setHeight(yAxisLength + (double)yStart + (double)yEnd);
                } else {
                    axisWall.transform.translateX.setValue((double)(-xStart));
                    axisWall.transform.translateY.setValue((double)(-yStart));
                    axisWall.setHeight((double)(b.height - categoryAxisTitleHeight - 1));
                    axisWall.setWidth(xAxisLength + (double)xStart + (double)xEnd);
                }
            }
        }
        if (responseAxisCellModel != null && (barLineChartModel.getResponseAxisModel().getGridLineStyle().getVisibilityPolicy() == 10201 || barLineChartModel.getResponseAxisModel().getGridLineStyle().getVisibilityPolicy() == 10200 && is3D)) {
            Grid responseGridLines = new Grid();
            responseGridLines.selectEnabled.setValue(false);
            if (isVerticalOrientation) {
                responseGridLines.transform.translateX.setValue((double)(-xStart));
                responseGridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd - (double)(!is3D ? 1 : 0));
                if (responseAxisCellModel.getMapper() != null) {
                    responseGridLines.horizontalLineOffset.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                }
                responseGridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd);
            } else {
                responseGridLines.transform.translateY.setValue((double)(-yStart));
                responseGridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd - (double)(!is3D ? 1 : 0));
                if (responseAxisCellModel.getMapper() != null) {
                    responseGridLines.verticalLineOffset.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                }
                responseGridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd);
            }
            if (barLineChartModel.getResponseAxisModel().isGridInFront()) {
                composites.gridLinesFrontWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesFrontWallComposite);
                composites.gridLinesFrontWallComposite.addElement((Element)responseGridLines);
            } else {
                composites.gridLinesBackWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesBackWallComposite);
                composites.gridLinesBackWallComposite.addElement((Element)responseGridLines);
                responseGridLines.transform.translateZ.setValue(-z + 1.0);
            }
            gtkGridStyle = responseGridLines.getStyle();
            gtkGridStyle.setBorderOn(false);
            gtkGridStyle.setBackgroundOn(false);
            gridlineLineStyle = barLineChartModel.getResponseAxisModel().getGridLineStyle();
            gtkGridStyle.setMajorLineColor(gridlineLineStyle.getColor());
            gla = GTKUtil.getLineAttributes(gridlineLineStyle);
            gtkGridStyle.setLineWidth(gla.lineWidth);
            gtkGridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            if (is3D) {
                LineSegment responseZGridLines = new LineSegment();
                composites.axisWallComposite = BarLineChartUtil.composite(composites, composites.axisWallComposite);
                composites.axisWallComposite.addElement((Element)responseZGridLines);
                responseZGridLines.selectEnabled.setValue(false);
                if (isVerticalOrientation) {
                    responseZGridLines.beginX.setValue((double)(-xStart));
                    responseZGridLines.endX.setValue((double)(-xStart));
                    if (responseAxisCellModel.getMapper() != null) {
                        responseZGridLines.beginY.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                        responseZGridLines.endY.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                    }
                } else {
                    responseZGridLines.beginY.setValue((double)(-yStart));
                    responseZGridLines.endY.setValue((double)(-yStart));
                    if (responseAxisCellModel.getMapper() != null) {
                        responseZGridLines.beginX.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                        responseZGridLines.endX.connectFrom(responseAxisCellModel.getMapper().uniqueValue);
                    }
                }
                responseZGridLines.beginZ.setValue(0.0);
                responseZGridLines.endZ.setValue(-z + 1.0);
                responseZGridLines.color.setValue(gridlineLineStyle.getColor());
                responseZGridLines.lineWidth.setValue((double)gtkGridStyle.getLineWidth());
                responseZGridLines.setStipple(gtkGridStyle.getStipplePattern(), gtkGridStyle.getStippleFactor());
            }
        }
        if (response2AxisCellModel != null && response2AxisCellModel.getMapper() != null && (barLineChartModel.getResponse2AxisModel().getGridLineStyle().getVisibilityPolicy() == 10201 || barLineChartModel.getResponse2AxisModel().getGridLineStyle().getVisibilityPolicy() == 10200 && is3D) && (responseAxisCellModel == null || barLineChartModel.getResponseAxisModel().getGridLineStyle().getVisibilityPolicy() != 10201 && (barLineChartModel.getResponseAxisModel().getGridLineStyle().getVisibilityPolicy() != 10200 || !is3D) || responseAxisCellModel.getValueCount().intValue() != response2AxisCellModel.getValueCount().intValue() || barLineChartModel.getResponseAxisModel().isGridInFront() != barLineChartModel.getResponse2AxisModel().isGridInFront())) {
            Grid response2GridLines = new Grid();
            response2GridLines.selectEnabled.setValue(false);
            if (isVerticalOrientation) {
                response2GridLines.transform.translateX.setValue((double)(-xStart + 1));
                response2GridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd);
                response2GridLines.horizontalLineOffset.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                response2GridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd);
            } else {
                response2GridLines.transform.translateY.setValue((double)(-yStart + 1));
                response2GridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd - 2.0);
                response2GridLines.verticalLineOffset.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                response2GridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd);
            }
            if (barLineChartModel.getResponse2AxisModel().isGridInFront()) {
                composites.gridLinesFrontWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesFrontWallComposite);
                composites.gridLinesFrontWallComposite.addElement((Element)response2GridLines);
            } else {
                composites.gridLinesBackWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesBackWallComposite);
                composites.gridLinesBackWallComposite.addElement((Element)response2GridLines);
                if (is3D) {
                    response2GridLines.transform.translateZ.setValue(-z + 1.0);
                }
            }
            gtkGridStyle = response2GridLines.getStyle();
            gtkGridStyle.setBorderOn(false);
            gtkGridStyle.setBackgroundOn(false);
            gridlineLineStyle = response2AxisCellModel.getAxisModel().getGridLineStyle();
            gtkGridStyle.setMajorLineColor(gridlineLineStyle.getColor());
            gla = GTKUtil.getLineAttributes(gridlineLineStyle);
            gtkGridStyle.setLineWidth(gla.lineWidth);
            gtkGridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            if (is3D) {
                response2GridLines.transform.translateZ.setValue(-z);
                LineSegment response2ZGridLines = new LineSegment();
                composites.axisWallComposite = BarLineChartUtil.composite(composites, composites.axisWallComposite);
                composites.axisWallComposite.addElement((Element)response2ZGridLines);
                response2ZGridLines.selectEnabled.setValue(false);
                if (isVerticalOrientation) {
                    response2ZGridLines.beginX.setValue((double)(-xStart));
                    response2ZGridLines.endX.setValue((double)(-xStart));
                    response2ZGridLines.beginY.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                    response2ZGridLines.endY.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                } else {
                    response2ZGridLines.beginY.setValue((double)(-yStart));
                    response2ZGridLines.endY.setValue((double)(-yStart));
                    response2ZGridLines.beginX.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                    response2ZGridLines.endX.connectFrom(response2AxisCellModel.getMapper().uniqueValue);
                }
                response2ZGridLines.beginZ.setValue(0.0);
                response2ZGridLines.endZ.setValue(-z);
                response2ZGridLines.color.setValue(gridlineLineStyle.getColor());
                response2ZGridLines.lineWidth.setValue((double)gtkGridStyle.getLineWidth());
                response2ZGridLines.setStipple(gtkGridStyle.getStipplePattern(), gtkGridStyle.getStippleFactor());
            }
        }
        if (categoryAxisCellModel != null && barLineChartModel.getCategoryAxisModel().getGridLineStyle().getVisibilityPolicy() == 10201) {
            Grid categoryGridLines = new Grid();
            categoryGridLines.selectEnabled.setValue(false);
            if (isVerticalOrientation) {
                categoryGridLines.transform.translateY.setValue((double)(-yStart));
                categoryGridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd - (double)(is3D ? 0 : 2));
                categoryGridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd);
                categoryGridLines.verticalLineOffset.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
            } else {
                categoryGridLines.transform.translateX.setValue((double)(-xStart));
                categoryGridLines.setHeight(yAxisLength + (double)yStart + (double)yEnd - (double)(is3D ? 0 : 2));
                categoryGridLines.setWidth(xAxisLength + (double)xStart + (double)xEnd);
                categoryGridLines.horizontalLineOffset.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
            }
            if (barLineChartModel.getCategoryAxisModel().isGridInFront()) {
                composites.gridLinesFrontWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesFrontWallComposite);
                composites.gridLinesFrontWallComposite.addElement((Element)categoryGridLines);
            } else {
                composites.gridLinesBackWallComposite = BarLineChartUtil.composite(composites, composites.gridLinesBackWallComposite);
                composites.gridLinesBackWallComposite.addElement((Element)categoryGridLines);
                categoryGridLines.transform.translateZ.setValue(-z + 1.0);
            }
            gtkGridStyle = categoryGridLines.getStyle();
            gtkGridStyle.setBorderOn(false);
            gtkGridStyle.setBackgroundOn(false);
            gridlineLineStyle = barLineChartModel.getCategoryAxisModel().getGridLineStyle();
            gtkGridStyle.setMajorLineColor(gridlineLineStyle.getColor());
            gla = GTKUtil.getLineAttributes(gridlineLineStyle);
            gtkGridStyle.setLineWidth(gla.lineWidth);
            gtkGridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            if (is3D) {
                LineSegment categoryZGridLines = new LineSegment();
                composites.axisWallComposite = BarLineChartUtil.composite(composites, composites.axisWallComposite);
                composites.axisWallComposite.addElement((Element)categoryZGridLines);
                categoryZGridLines.selectEnabled.setValue(false);
                if (isVerticalOrientation) {
                    categoryZGridLines.beginY.setValue((double)(-yStart));
                    categoryZGridLines.endY.setValue((double)(-yStart));
                    categoryZGridLines.beginX.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
                    categoryZGridLines.endX.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
                } else {
                    categoryZGridLines.beginX.setValue((double)(-xStart));
                    categoryZGridLines.endX.setValue((double)(-xStart));
                    categoryZGridLines.beginY.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
                    categoryZGridLines.endY.connectFrom(categoryAxisCellModel.getMapper().uniqueValue);
                }
                categoryZGridLines.beginZ.setValue(0.0);
                categoryZGridLines.endZ.setValue(-z + 1.0);
                categoryZGridLines.color.setValue(gridlineLineStyle.getColor());
                categoryZGridLines.lineWidth.setValue((double)gtkGridStyle.getLineWidth());
                categoryZGridLines.setStipple(gtkGridStyle.getStipplePattern(), gtkGridStyle.getStippleFactor());
            }
        }
        BarLineChartUtil._createCategoryReferenceBands(channel, composites, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, z);
        BarLineChartUtil._createCategoryReferenceLines(channel, composites, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, z);
        if (!is3D && graphAreaClippingBox != null) {
            if (composites.categoryReferenceLinesBackComposite != null) {
                composites.categoryReferenceLinesBackComposite.setClipBounds(graphAreaClippingBox);
            }
            if (composites.categoryReferenceLinesFrontComposite != null) {
                composites.categoryReferenceLinesFrontComposite.setClipBounds(graphAreaClippingBox);
            }
        }
        if (!is3D && cellModel.getFrameVisible().booleanValue()) {
            Grid frame = new Grid();
            frame.selectEnabled.setValue(false);
            frame.getStyle().setBorderOn(true);
            frame.getStyle().setBackgroundOn(false);
            frame.getStyle().setMajorLineColor(graphModel.getFrameLineStyle().getColor());
            int thickness = (int)graphModel.getFrameLineStyle().getThickness().getMagnitude((Object)"px");
            frame.getStyle().setLineWidth(thickness);
            if (isVerticalOrientation) {
                if (barVariableCount + lineVariableCount < 1) {
                    if (thickness > 1) {
                        frame.transform.translateX.setValue((double)(-xStart));
                    } else {
                        frame.transform.translateX.setValue((double)(-xStart - 1));
                    }
                } else {
                    frame.transform.translateX.setValue((double)(-xStart - 2));
                }
                frame.transform.translateY.setValue((double)(-yStart));
                frame.setWidth(xAxisLength + (double)xStart + (double)xEnd + 1.0);
                if (thickness > 1) {
                    frame.setHeight(yAxisLength + (double)yStart + (double)yEnd - 1.0);
                } else {
                    frame.setHeight(yAxisLength + (double)yStart + (double)yEnd);
                }
            } else {
                frame.transform.translateX.setValue((double)(-xStart));
                if (barVariableCount + lineVariableCount < 1) {
                    frame.transform.translateY.setValue((double)(-yStart));
                } else {
                    frame.transform.translateY.setValue((double)(-yStart));
                }
                frame.setWidth(xAxisLength + (double)xStart + (double)xEnd - 1.0);
                if (thickness > 1) {
                    frame.setHeight(yAxisLength + (double)yStart + (double)yEnd - 1.0);
                } else {
                    frame.setHeight(yAxisLength + (double)yStart + (double)yEnd);
                }
            }
            composites.frameComposite = BarLineChartUtil.composite(composites, composites.frameComposite);
            composites.frameComposite.addElement((Element)frame);
        }
    }

    public static void addSubgroupedLines(Composites composites, DataSource dataSource, BarLineChartCellModel cellModel, BarLineChartVariables variables, BarLineChartAxisVariables axis, int previousVariableCount, StringToNumericMapper categoryAxisMapper, ContinuousRangeToNumericMapper axisMapper, ContinuousRangeToNumericMapper axisBaselineMapper, double axisBaseline, boolean linesOnBackWall, double z) {
        GraphModel graphModel = cellModel.getGraphModel();
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int variableCount = axis.getLineVariableCount();
        Variable[] variableArray = axis.lineVariableArray;
        Variable[] selectionVariableArray = axis.lineSelectionVariableArray;
        StringVariable subgroupVariable = variables.subgroupVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        Variable[] outsideMarkerLabelVariableArray = variables.outsideMarkerLabelVariableArray;
        LineStyle outlineLineStyle = graphModel.getDataElementStyles().getOutlineLineStyle();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        AbstractMarkerSkinFactory skinFactory = null;
        if (barLineChartModel.isMarkerEnabled()) {
            int skint = barLineChartModel.getSkin();
            skinFactory = BarLineChartUtil.createMarkerSkinFactory(barLineChartModel);
        }
        for (int ii = 0; ii < variableCount; ++ii) {
            NumericVariable lineVariable = (NumericVariable)variableArray[ii];
            if (lineVariable == null) continue;
            ContinuousRangeToNumericMapper vertexMapper = new ContinuousRangeToNumericMapper();
            vertexMapper.shareMap(axisMapper);
            vertexMapper.input.connectFrom(lineVariable.value);
            Switch lineSwitch = new Switch();
            lineSwitch.selectEnabled.setValue(false);
            composites.lineComposite = BarLineChartUtil.composite(composites, composites.lineComposite);
            composites.lineComposite.addElement((Element)lineSwitch);
            if (linesOnBackWall) {
                lineSwitch.transform.translateZ.setValue(-z);
            }
            lineSwitch.whichChoice.connectFrom(subgroupVariable.category);
            Double dataLabelAdjustemnt = null;
            Switch markerSwitch = null;
            if (barLineChartModel.isMarkerEnabled()) {
                markerSwitch = new Switch();
                composites.markerComposite = BarLineChartUtil.composite(composites, composites.markerComposite);
                composites.markerComposite.addElement((Element)markerSwitch);
                if (linesOnBackWall) {
                    markerSwitch.transform.translateZ.setValue(-z);
                }
                markerSwitch.whichChoice.connectFrom(subgroupVariable.category);
            }
            Hashtable valueToLineStyle = cellModel.getFormattedValueToLineStyle();
            Hashtable valueToFillStyle = cellModel.getFormattedValueToFillStyle();
            Hashtable valueToMarkerStyle = cellModel.getFormattedValueToMarkerStyle();
            int count = subgroupVariable.getUniqueValueCount();
            for (int jj = 0; jj < count; ++jj) {
                String key = GTKUtil.VariableAccess.getFormattedUniqueValue(subgroupVariable, jj);
                StrokeLineStyle lineStyle = valueToLineStyle != null ? valueToLineStyle.get(key) : null;
                MarkerStyle markerStyle = valueToMarkerStyle != null ? valueToMarkerStyle.get(key) : null;
                FillStyle fillStyle = barLineChartModel.isFillAreaEnabled() && valueToFillStyle != null ? valueToFillStyle.get(key) : null;
                FilledLineConnector line = BarLineChartUtil.newLineConnector(lineStyle, markerStyle, barLineChartModel.isInterpolationEnabled(), barLineChartModel.isMarkerEnabled());
                lineSwitch.addChoice((Element)line);
                line.transform.translateX.setValue(-z);
                if (dataSource.isSummarizationEnabled() || markerStyle != null && markerStyle.getConnectionOrder() == 40100) {
                    line.pointX.connectFrom((NumericPipe)categoryAxisMapper);
                    line.pointY.connectFrom((NumericPipe)vertexMapper);
                } else {
                    NumericCache xCache = new NumericCache();
                    NumericCache yCache = new NumericCache();
                    xCache.input.connectFrom(categoryAxisMapper.value);
                    yCache.input.connectFrom(vertexMapper.value);
                    line.pointX.connectFrom((NumericPipe)xCache);
                    line.pointY.connectFrom((NumericPipe)yCache);
                }
                line.setSkipMissingOn(barLineChartModel.isSkipMissing());
                if (fillStyle != null && fillStyle.isVisible()) {
                    line.fillOn.setValue(true);
                    line.fillColor.setValue(fillStyle.getSolidFillColor());
                    axisBaselineMapper.shareMap(axisMapper);
                    axisBaselineMapper.input.setValue(axisBaseline);
                    double baseLinePositionInWorld = 0.0;
                    try {
                        baseLinePositionInWorld = axisBaselineMapper.getValue(0);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    line.setFillToPlane(new Plane(new Vec3d(0.0, baseLinePositionInWorld, 0.0), new Vec3d(1.0, baseLinePositionInWorld, 0.0), new Vec3d(0.0, baseLinePositionInWorld, 1.0)));
                }
                if (markerSwitch == null || markerStyle == null) continue;
                Marker marker = new Marker();
                int selectionOptions = selectionVariableArray != null && selectionVariableArray.length > ii ? 7 : 5;
                Util.SelectInfo.selectEnable((Element)marker, variableArray[ii], selectionOptions);
                markerSwitch.addChoice((Element)marker);
                marker.coordX.connectFrom((NumericPipe)categoryAxisMapper);
                marker.coordY.connectFrom((NumericPipe)vertexMapper);
                marker.setFast(false);
                if (linesOnBackWall) {
                    marker.transform.translateZ.setValue(-z);
                }
                if (markerStyle.isVisible() && markerStyle.getSymbol() != -1) {
                    marker.type.setValue(markerStyle.getSymbol());
                    marker.color.setValue(markerStyle.getColor());
                    if (outlineLineStyle.getVisibilityPolicy() == 10201) {
                        marker.edgeColor.setValue(outlineLineStyle.getColor());
                    } else {
                        marker.edgeColor.setValue(markerStyle.getColor());
                    }
                    marker.setSkinFactory(skinFactory);
                } else {
                    marker.type.setValue(-1);
                    marker.color.setValue(INVISIBLE_COLOR);
                    marker.edgeColor.setValue(INVISIBLE_COLOR);
                }
                dataLabelAdjustemnt = new Double(markerStyle.getSize().getMagnitude((Object)"px") / 2.0);
                marker.size.setValue((int)(dataLabelAdjustemnt * 2.0));
                if (selectionVariableArray == null || selectionVariableArray.length <= ii || !(selectionVariableArray[ii] instanceof NumericVariable) || cellModel.getRuleTargetIdentifier() != null && !cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName())) continue;
                marker.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                marker.highlightFillColor.setValue(graphModel.getBrushModel().getSelectionColor());
                marker.highlightEdgeColor.setValue(graphModel.getBrushModel().getSelectionAccentColor());
            }
            for (int jj = 1; jj < 2; ++jj) {
                Variable dlv;
                int blc = 0;
                Variable[] va = null;
                AdvancedTextStyle blts = null;
                switch (jj) {
                    case 1: {
                        va = outsideMarkerLabelVariableArray;
                        blc = barLineChartModel.getOutsideMarkerLabelContent();
                        blts = barLineChartModel.getOutsideMarkerLabelTextStyle();
                    }
                }
                Variable variable = dlv = va == null ? null : va[(ii + previousVariableCount) % va.length];
                if (blc == 10603) {
                    dlv = new StringVariable();
                    ((StringVariable)dlv).connectFrom(lineVariable);
                } else if (blc == 10602) {
                    dlv = categoryVariable;
                }
                if (dlv == null) continue;
                StringPipe labelPipe = dlv instanceof StringVariable ? ((StringVariable)dlv).formattedValue : ((NumericVariable)dlv).formattedValue;
                BarLineChartUtil.addDataLabels(composites, labelPipe, (NumericPipe)categoryAxisMapper, null, (NumericPipe)vertexMapper, dataLabelAdjustemnt, z > 0.0 ? new Double(-z) : null, lineVariable.value, axisBaseline, blts, jj == 0, isVerticalOrientation, linesOnBackWall ? 1 : 2, false, Double.NaN);
            }
        }
    }

    public static FilledLineConnector newLineConnector(StrokeLineStyle lineStyle, MarkerStyle markerStyle, boolean interpolationEnabled, boolean markerEnabled) {
        LineConnector line = null;
        if (interpolationEnabled && lineStyle != null && lineStyle.getVisibilityPolicy() != 10202 && markerStyle.getInterpolation() != 40000) {
            switch (markerStyle.getInterpolation()) {
                default: {
                    line = new LineConnector();
                    break;
                }
                case 40006: {
                    line = new SplineConnector();
                    break;
                }
                case 40004: {
                    line = new StepConnector();
                    ((StepConnector)line).setJustification(2);
                    ((StepConnector)line).setJoin(true);
                    break;
                }
                case 40005: {
                    line = new StepConnector();
                    ((StepConnector)line).setJustification(1);
                    ((StepConnector)line).setJoin(true);
                    break;
                }
                case 40003: {
                    line = new StepConnector();
                    ((StepConnector)line).setJustification(0);
                    ((StepConnector)line).setJoin(true);
                }
            }
            line.selectEnabled.setValue(true);
            switch (markerStyle.getConnectionOrder()) {
                default: {
                    line.setConnectionOrder(0);
                    break;
                }
                case 40101: {
                    line.setConnectionOrder(1);
                    break;
                }
                case 40102: {
                    line.setConnectionOrder(2);
                }
            }
            line.color.setValue(lineStyle.getColor());
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(lineStyle);
            line.lineWidth.setValue((double)gla.lineWidth);
            line.setStipple(gla.stipplePattern, gla.stippleFactor);
        } else {
            line = new LineConnector();
            line.lineOn.setValue(false);
            line.selectEnabled.setValue(false);
        }
        if (markerEnabled) {
            // empty if block
        }
        return line;
    }

    public static RasterLabel addDataLabels(Composites composites, StringPipe labelValue, NumericPipe categoryPosition, Object categoryAdjust, NumericPipe responsePosition, Object responseAdjust, Object depthAdjust, NumericPipe responseValue, double baselineValue, AdvancedTextStyle textStyle, boolean inside, boolean verticalOrientation, int depthFlag, boolean waterFallEnabled, double angle) {
        RasterLabel label = null;
        if (textStyle.isVisible()) {
            NumericProperty labelResponse;
            label = new RasterLabel();
            label.selectEnabled.setValue(false);
            label.trimOn.setValue(true);
            Font font = textStyle.getFont();
            label.fontName.setValue(font.getName());
            label.fontSize.setValue(font.getSize());
            label.fontStyle.setValue(font.getStyle());
            label.color.setValue(textStyle.getColor());
            label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
            label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
            label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            if (Double.isNaN(angle)) {
                angle = Util.resolveBaselineAngle(textStyle);
            }
            angle %= 360.0;
            while (angle < 0.0) {
                angle = 360.0 + angle;
            }
            label.angle.setValue(angle);
            label.horizontalJustification.connectFrom((NumericPipe)BarLineChartUtil._newDataLabelJustificationMapper(angle, baselineValue, responseValue, inside, verticalOrientation, true));
            label.verticalJustification.connectFrom((NumericPipe)BarLineChartUtil._newDataLabelJustificationMapper(angle, baselineValue, responseValue, inside, verticalOrientation, false));
            NumericProperty labelCategory = verticalOrientation ? label.transform.translateX : label.transform.translateY;
            NumericProperty numericProperty = labelResponse = verticalOrientation ? label.transform.translateY : label.transform.translateX;
            if (categoryAdjust != null) {
                if (categoryAdjust instanceof BarClusterer) {
                    labelCategory.connectFrom(((BarClusterer)categoryAdjust).outputCategoryPosition);
                } else {
                    Calculator categoryAdjustment = new Calculator("inA + inB");
                    categoryAdjustment.inA.connectFrom(categoryPosition);
                    if (categoryAdjust instanceof Double) {
                        categoryAdjustment.inB.setValue(((Double)categoryAdjust).doubleValue());
                    } else if (categoryAdjust instanceof NumericPipe) {
                        categoryAdjustment.inB.connectFrom((NumericPipe)categoryAdjust);
                    }
                    labelCategory.connectFrom((NumericPipe)categoryAdjustment);
                }
            } else {
                labelCategory.connectFrom(categoryPosition);
            }
            if (responseAdjust != null) {
                String adjustString = waterFallEnabled ? "inA >= " + baselineValue + " ? inB + inC : inB + inC - 3 " : "inA >= " + baselineValue + " ? inB + inC : inB - inC";
                Calculator responseAdjustment = new Calculator(adjustString);
                responseAdjustment.inA.connectFrom(responseValue);
                responseAdjustment.inB.connectFrom(responsePosition);
                if (responseAdjust instanceof Double) {
                    responseAdjustment.inC.setValue(((Double)responseAdjust).doubleValue());
                } else if (responseAdjust instanceof NumericPipe) {
                    responseAdjustment.inC.connectFrom((NumericPipe)responseAdjust);
                }
                labelResponse.connectFrom((NumericPipe)responseAdjustment);
            } else {
                labelResponse.connectFrom(responsePosition);
            }
            if (depthAdjust instanceof Double) {
                if (depthFlag == 0) {
                    double depthAdjust2 = -((Double)depthAdjust).doubleValue() / 2.0;
                    if (inside) {
                        label.transform.translateZ.setValue(depthAdjust2);
                    } else {
                        NumericRangeSegment[] rs = BarLineChartUtil._newBaselineRangeSegments(baselineValue, new Double(depthAdjust2), new Double(-depthAdjust2));
                        DiscreteRangeToNumericMapper zMapper = new DiscreteRangeToNumericMapper();
                        zMapper.setRangeSegments(rs);
                        zMapper.input.connectFrom(responseValue);
                        label.transform.translateZ.connectFrom((NumericPipe)zMapper);
                    }
                } else if (depthFlag == 1) {
                    label.transform.translateZ.setValue(((Double)depthAdjust).doubleValue());
                }
            }
            StringMissingValueReplacement missingValueReplacement = new StringMissingValueReplacement();
            missingValueReplacement.input.connectFrom(labelValue);
            label.string.connectFrom((StringPipe)missingValueReplacement);
            composites.dataLabelComposite = BarLineChartUtil.composite(composites, composites.dataLabelComposite);
            composites.dataLabelComposite.addElement((Element)label);
        }
        return label;
    }

    private static DiscreteRangeToNumericMapper _newDataLabelJustificationMapper(double angle, double baselineValue, NumericPipe value, boolean isInsideLabel, boolean verticalOrientation, boolean horizontalJustification) {
        int justificationAbove;
        int justificationBelow;
        int justification4;
        int justification1 = verticalOrientation ? 0 : 0;
        int justification2 = verticalOrientation ? 2 : 3;
        int justification3 = verticalOrientation ? 3 : 0;
        int n = justification4 = verticalOrientation ? 0 : 2;
        if (verticalOrientation == horizontalJustification) {
            if (angle % 90.0 == 0.0) {
                justificationBelow = 1;
                justificationAbove = 1;
            } else if (angle < 180.0) {
                justificationBelow = isInsideLabel ? justification1 : justification2;
                justificationAbove = isInsideLabel ? justification2 : justification1;
            } else {
                justificationBelow = isInsideLabel ? justification2 : justification1;
                justificationAbove = isInsideLabel ? justification1 : justification2;
            }
        } else if (angle <= 90.0 || angle >= 270.0) {
            justificationBelow = isInsideLabel ? justification3 : justification4;
            justificationAbove = isInsideLabel ? justification4 : justification3;
        } else {
            justificationBelow = isInsideLabel ? justification4 : justification3;
            justificationAbove = isInsideLabel ? justification3 : justification4;
        }
        NumericRangeSegment[] hrs = BarLineChartUtil._newBaselineRangeSegments(baselineValue, new Double(justificationBelow), new Double(justificationAbove));
        DiscreteRangeToNumericMapper justificationMapper = new DiscreteRangeToNumericMapper();
        justificationMapper.setRangeSegments(hrs);
        justificationMapper.input.connectFrom(value);
        return justificationMapper;
    }

    private static NumericRangeSegment[] _newBaselineRangeSegments(double axisBaseline, Object belowValue, Object aboveValue) {
        NumericRangeSegment[] rangeSegments = new NumericRangeSegment[]{new NumericRangeSegment(), new NumericRangeSegment()};
        rangeSegments[0].setMin(Double.NEGATIVE_INFINITY);
        rangeSegments[0].setMax(axisBaseline);
        rangeSegments[0].setMaxExclude(true);
        rangeSegments[0].setValue(belowValue);
        rangeSegments[1].setMin(axisBaseline);
        rangeSegments[1].setMax(Double.POSITIVE_INFINITY);
        rangeSegments[1].setValue(aboveValue);
        return rangeSegments;
    }

    public static RasterLabel addALabel(Composite composite, String text, double[] position, TextStyle textStyle, int horzJustification, int vertJustification) {
        RasterLabel label = new RasterLabel();
        label.selectEnabled.setValue(false);
        Font font = textStyle.getFont();
        label.fontName.setValue(font.getName());
        label.fontSize.setValue(font.getSize());
        label.fontStyle.setValue(font.getStyle());
        label.color.setValue(textStyle.getColor());
        label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
        label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
        label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
        label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
        double xpos = position[0];
        double ypos = position[1];
        if (vertJustification == 1) {
            label.verticalJustification.setValue(0);
        } else if (vertJustification == 0) {
            label.verticalJustification.setValue(1);
        } else {
            label.verticalJustification.setValue(3);
        }
        if (horzJustification == 4) {
            label.horizontalJustification.setValue(2);
        } else if (horzJustification == 0) {
            label.horizontalJustification.setValue(1);
        } else {
            label.horizontalJustification.setValue(0);
        }
        label.angle.setValue(Util.resolveBaselineAngle(textStyle));
        label.transform.translateX.setValue(xpos);
        label.transform.translateY.setValue(ypos);
        if (position.length == 3) {
            label.transform.translateZ.setValue(position[2]);
        }
        label.string.setValue(text);
        label.selectEnabled.setValue(true);
        composite.addElement((Element)label);
        return label;
    }

    public static void applyFillStyle(Bar bar, FillStyle fillStyle) {
        bar.fillOn.setValue(fillStyle.isVisible());
        if (fillStyle.isVisible()) {
            int fillType = fillStyle.getFillType();
            bar.color1.setValue(fillStyle.getSolidFillColor());
            boolean gradientFillEnabled = fillType == 20001 || fillType == 20004;
            bar.gradientOn.setValue(gradientFillEnabled);
            if (gradientFillEnabled) {
                switch (fillStyle.getGradientFill()) {
                    default: {
                        bar.gradientDirection.setValue(1);
                        break;
                    }
                    case 20104: {
                        bar.gradientDirection.setValue(3);
                        break;
                    }
                    case 20103: {
                        bar.gradientDirection.setValue(2);
                        break;
                    }
                    case 20100: {
                        bar.gradientDirection.setValue(0);
                    }
                }
                if (bar.gradientDirection.getValue() == 1) {
                    bar.color1.setValue(fillStyle.getGradientFillEndColor());
                    bar.color2.setValue(fillStyle.getGradientFillBeginColor());
                } else {
                    bar.color1.setValue(fillStyle.getGradientFillBeginColor());
                    bar.color2.setValue(fillStyle.getGradientFillEndColor());
                }
            }
            boolean imageFillEnabled = fillStyle.getImageIcon() != null && fillStyle.getImageIcon().getImage() != null && (fillType == 20002 || fillType == 20003 || fillType == 20004);
            bar.textureOn.setValue(imageFillEnabled);
            if (imageFillEnabled) {
                bar.textureMode.setValue(fillType == 20003 ? 3 : 2);
                bar.textureStyle.setValue(fillStyle.getImageFill() == 20200 ? 4 : 5);
                bar.setTextureImage(new BufferedImage[]{BaseBar.convertImageToBufferedImage((Image)fillStyle.getImageIcon().getImage())});
                bar.textureIndex.setValue(0);
                if (fillType == 20003) {
                    bar.color1.setValue(fillStyle.getSolidBlendColor());
                } else if (fillType == 20004) {
                    if (fillStyle.getGradientFill() == 20101) {
                        bar.color1.setValue(fillStyle.getGradientBlendEndColor());
                        bar.color2.setValue(fillStyle.getGradientBlendBeginColor());
                    } else {
                        bar.color1.setValue(fillStyle.getGradientBlendBeginColor());
                        bar.color2.setValue(fillStyle.getGradientBlendEndColor());
                    }
                }
            }
        }
    }

    public static void applyFillStyle(Bar bar, Hashtable valueToFillStyle, StringVariable variable) {
        StringToFillStyleToGTKValues s2fs = new StringToFillStyleToGTKValues();
        s2fs.input.connectFrom(variable.formattedValue);
        s2fs.setStringToFillStyleMap(valueToFillStyle);
        bar.fillOn.connectFrom(s2fs.fillOn);
        bar.gradientOn.connectFrom(s2fs.gradientOn);
        bar.textureOn.connectFrom(s2fs.textureOn);
        bar.color1.connectFrom(s2fs.color1);
        bar.color2.connectFrom(s2fs.color2);
        bar.gradientDirection.connectFrom(s2fs.gradientDirection);
        bar.textureMode.connectFrom(s2fs.textureMode);
        bar.textureStyle.connectFrom(s2fs.textureStyle);
        bar.textureIndex.connectFrom(s2fs.textureIndex);
        bar.setTextureImage(s2fs.getTextureImages());
    }

    public static void applyVariableAndFillStyle(MultiResponseStackedBar mrsBar, FillStyle[] fillStyles, Color[] cycleColors, int fillStyleStartIndex, Variable[] variableArray, Variable[] selectionVariableArray, NumericVariable selectedPercentageVariable, ContinuousRangeToNumericMapper axisMapper, BarLineChartCellModel cellModel) {
        if (variableArray == null) {
            return;
        }
        int vc = variableArray.length;
        BooleanProperty fillOnProperty = new BooleanProperty();
        BooleanProperty gradientOnProperty = new BooleanProperty();
        BooleanProperty textureOnProperty = new BooleanProperty();
        ColorProperty color1Property = new ColorProperty();
        ColorProperty color2Property = new ColorProperty();
        IntegerProperty gradientDirectionProperty = new IntegerProperty();
        IntegerProperty textureModeProperty = new IntegerProperty();
        IntegerProperty textureStyleProperty = new IntegerProperty();
        IntegerProperty textureIndexProperty = new IntegerProperty();
        BufferedImage[] textureImages = new BufferedImage[vc];
        mrsBar.fillOn.connectFrom((BooleanPipe)fillOnProperty);
        mrsBar.gradientOn.connectFrom((BooleanPipe)gradientOnProperty);
        mrsBar.textureOn.connectFrom((BooleanPipe)textureOnProperty);
        mrsBar.color1.connectFrom((ColorPipe)color1Property);
        mrsBar.color2.connectFrom((ColorPipe)color2Property);
        mrsBar.gradientDirection.connectFrom((IntegerPipe)gradientDirectionProperty);
        mrsBar.textureMode.connectFrom((IntegerPipe)textureModeProperty);
        mrsBar.textureStyle.connectFrom((IntegerPipe)textureStyleProperty);
        mrsBar.textureIndex.connectFrom((IntegerPipe)textureIndexProperty);
        mrsBar.setTextureImage(textureImages);
        BooleanVector fillOnVector = new BooleanVector(vc);
        BooleanVector gradientOnVector = new BooleanVector(vc);
        BooleanVector textureOnVector = new BooleanVector(vc);
        ColorVector color1Vector = new ColorVector(vc);
        ColorVector color2Vector = new ColorVector(vc);
        IntegerVector gradientDirectionVector = new IntegerVector(vc);
        IntegerVector textureModeVector = new IntegerVector(vc);
        IntegerVector textureStyleVector = new IntegerVector(vc);
        IntegerVector textureIndexVector = new IntegerVector(vc);
        fillOnVector.setSize(vc);
        gradientOnVector.setSize(vc);
        textureOnVector.setSize(vc);
        color1Vector.setSize(vc);
        color2Vector.setSize(vc);
        gradientDirectionVector.setSize(vc);
        textureModeVector.setSize(vc);
        textureStyleVector.setSize(vc);
        textureIndexVector.setSize(vc);
        fillOnProperty.connectFrom((BooleanPipe)fillOnVector);
        gradientOnProperty.connectFrom((BooleanPipe)gradientOnVector);
        textureOnProperty.connectFrom((BooleanPipe)textureOnVector);
        color1Property.connectFrom((ColorPipe)color1Vector);
        color2Property.connectFrom((ColorPipe)color2Vector);
        gradientDirectionProperty.connectFrom((IntegerPipe)gradientDirectionVector);
        textureModeProperty.connectFrom((IntegerPipe)textureModeVector);
        textureStyleProperty.connectFrom((IntegerPipe)textureStyleVector);
        textureIndexProperty.connectFrom((IntegerPipe)textureIndexVector);
        for (int ii = 0; ii < vc; ++ii) {
            NumericVariable barVariable = (NumericVariable)variableArray[ii];
            ContinuousRangeToNumericMapper barLengthMapper = new ContinuousRangeToNumericMapper();
            barLengthMapper.shareMap(axisMapper);
            barLengthMapper.input.connectFrom(barVariable.value);
            NumericProperty highlightOnPipe = HIGHLIGHT_OFF;
            if (selectionVariableArray != null && selectionVariableArray.length > ii && selectionVariableArray[ii] instanceof NumericVariable && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(variableArray[ii].getRootVariable().getColumnName()))) {
                highlightOnPipe = ((NumericVariable)selectionVariableArray[ii]).value;
                mrsBar.highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                if (selectedPercentageVariable != null) {
                    mrsBar.highlightPercentage.connectFrom(selectedPercentageVariable.value);
                }
                mrsBar.highlightFillColor.setValue(cellModel.getGraphModel().getBrushModel().getSelectionColor());
                mrsBar.highlightEdgeColor.setValue(cellModel.getGraphModel().getBrushModel().getSelectionAccentColor());
            }
            mrsBar.addResponse(barLengthMapper.value, barVariable.value, barVariable.getName(), (NumericPipe)highlightOnPipe);
            FillStyle fillStyle = Util.newCycledFillStyle(fillStyles, cycleColors, ii + fillStyleStartIndex);
            fillOnVector.setValueAt(fillStyle.isVisible(), ii);
            if (!fillStyle.isVisible()) continue;
            int fillType = fillStyle.getFillType();
            color1Vector.setValueAt(fillStyle.getSolidFillColor(), ii);
            color2Vector.setValueAt(fillStyle.getSolidFillColor(), ii);
            boolean gradientFillEnabled = fillType == 20001 || fillType == 20004;
            gradientOnVector.setValueAt(gradientFillEnabled, ii);
            if (gradientFillEnabled) {
                switch (fillStyle.getGradientFill()) {
                    default: {
                        gradientDirectionVector.setValueAt(1, ii);
                        break;
                    }
                    case 20104: {
                        gradientDirectionVector.setValueAt(3, ii);
                        break;
                    }
                    case 20103: {
                        gradientDirectionVector.setValueAt(2, ii);
                        break;
                    }
                    case 20100: {
                        gradientDirectionVector.setValueAt(0, ii);
                    }
                }
                if (fillStyle.getGradientFill() == 20101) {
                    color1Vector.setValueAt(fillStyle.getGradientFillEndColor(), ii);
                    color2Vector.setValueAt(fillStyle.getGradientFillBeginColor(), ii);
                } else {
                    color1Vector.setValueAt(fillStyle.getGradientFillBeginColor(), ii);
                    color2Vector.setValueAt(fillStyle.getGradientFillEndColor(), ii);
                }
            }
            boolean imageFillEnabled = fillStyle.getImageIcon() != null && fillStyle.getImageIcon().getImage() != null && (fillType == 20002 || fillType == 20003 || fillType == 20004);
            textureOnVector.setValueAt(imageFillEnabled, ii);
            if (!imageFillEnabled) continue;
            textureModeVector.setValueAt(fillType == 20003 ? 3 : 2, ii);
            textureStyleVector.setValueAt(fillStyle.getImageFill() == 20200 ? 4 : 5, ii);
            textureIndexVector.setValueAt(ii, ii);
            textureImages[ii] = BaseBar.convertImageToBufferedImage((Image)fillStyle.getImageIcon().getImage());
            if (fillType == 20003) {
                color1Vector.setValueAt(fillStyle.getSolidBlendColor(), ii);
                continue;
            }
            if (fillType != 20004) continue;
            if (fillStyle.getGradientFill() == 20101) {
                color1Vector.setValueAt(fillStyle.getGradientBlendEndColor(), ii);
                color2Vector.setValueAt(fillStyle.getGradientBlendBeginColor(), ii);
                continue;
            }
            color1Vector.setValueAt(fillStyle.getGradientBlendBeginColor(), ii);
            color2Vector.setValueAt(fillStyle.getGradientBlendEndColor(), ii);
        }
    }

    public static RasterLabel addExtraDataLabel(Composite dataLabelComposite, boolean inside, ContinuousRangeToNumericMapper axisMapper, double barHeight, double xTranslation, double zTranslation, StringToNumericMapper categoryAxisMapper, String barID, AdvancedTextStyle textStyle, boolean isVerticalOrientation, double barBaseline, Double responseTranslation, String formattedDataLabelValue, double angle) {
        RasterLabel label = null;
        if (formattedDataLabelValue != null && dataLabelComposite != null && textStyle != null && textStyle.isVisible()) {
            label = new RasterLabel();
            label.selectEnabled.setValue(false);
            dataLabelComposite.addElement((Element)label);
            label.trimOn.setValue(true);
            label.string.setValue(formattedDataLabelValue);
            Font font = textStyle.getFont();
            label.fontName.setValue(font.getName());
            label.fontSize.setValue(font.getSize());
            label.fontStyle.setValue(font.getStyle());
            label.color.setValue(textStyle.getColor());
            label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
            label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
            label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            if (Double.isNaN(angle)) {
                label.angle.setValue(Util.resolveBaselineAngle(textStyle));
            } else {
                label.angle.setValue(angle);
            }
            if (isVerticalOrientation) {
                label.horizontalJustification.setValue(1);
                int verticalJustification = inside ? (barHeight < barBaseline ? 3 : 0) : (barHeight < barBaseline ? 0 : 3);
                label.verticalJustification.setValue(verticalJustification);
            } else {
                label.verticalJustification.setValue(1);
                int horizontalJustification = inside ? (barHeight < barBaseline ? 0 : 2) : (barHeight < barBaseline ? 2 : 0);
                label.horizontalJustification.setValue(horizontalJustification);
            }
            NumericProperty labelCategory = isVerticalOrientation ? label.transform.translateX : label.transform.translateY;
            StringToNumericMapper labelCategoryAxisMapper = new StringToNumericMapper();
            labelCategoryAxisMapper.shareMap(categoryAxisMapper);
            labelCategoryAxisMapper.input.setValue(barID);
            if (!Double.isNaN(xTranslation)) {
                Calculator categoryAdjustment = new Calculator("inA + inB");
                categoryAdjustment.inA.connectFrom((NumericPipe)labelCategoryAxisMapper);
                categoryAdjustment.inB.setValue(xTranslation);
                labelCategory.connectFrom((NumericPipe)categoryAdjustment);
            } else {
                labelCategory.connectFrom((NumericPipe)categoryAxisMapper);
            }
            NumericProperty labelResponse = isVerticalOrientation ? label.transform.translateY : label.transform.translateX;
            ContinuousRangeToNumericMapper extraBarHeightMapper = new ContinuousRangeToNumericMapper();
            extraBarHeightMapper.shareMap(axisMapper);
            extraBarHeightMapper.input.setValue(barHeight);
            if (responseTranslation != null) {
                String adjustString = barHeight >= barBaseline ? "inB + inC " : " inB + inC - 3 ";
                Calculator responseAdjustment = new Calculator(adjustString);
                responseAdjustment.inB.connectFrom((NumericPipe)extraBarHeightMapper);
                responseAdjustment.inC.setValue(responseTranslation.doubleValue());
                labelResponse.connectFrom((NumericPipe)responseAdjustment);
            } else {
                labelResponse.connectFrom((NumericPipe)extraBarHeightMapper);
            }
            if (!Double.isNaN(zTranslation)) {
                if (barHeight >= barBaseline) {
                    label.transform.translateZ.setValue(zTranslation / 2.0);
                } else {
                    label.transform.translateZ.setValue(-zTranslation / 2.0);
                }
            }
        }
        return label;
    }

    public static Bar addExtraBar(Composite extraBarComposite, Bar mimicBar, FillStyle fillStyle, ContinuousRangeToNumericMapper responseAxisMapper, ContinuousRangeToNumericMapper responseAxisBaselineMapper, double barHeight, double xTranslation, StringToNumericMapper categoryAxisMapper, String barID) {
        Bar extraBar = null;
        if (extraBarComposite != null) {
            extraBar = new Bar();
            Util.SelectInfo.selectDisable((Element)extraBar);
            extraBarComposite.addElement((Element)extraBar);
            if (mimicBar != null) {
                extraBar.setTwoD(mimicBar.isTwoD());
                extraBar.setSkin(mimicBar.getSkin());
                extraBar.thickness.setValue(mimicBar.thickness.getValue());
                extraBar.verticalOn.setValue(mimicBar.verticalOn.getValue());
                extraBar.edgeOn.setValue(mimicBar.edgeOn.getValue());
                extraBar.edgeColor.setValue(mimicBar.edgeColor.getValue());
                extraBar.edgeWidth.setValue(mimicBar.edgeWidth.getValue());
                extraBar.marker3DShape.setValue(mimicBar.marker3DShape.getValue());
            }
            BarLineChartUtil.applyFillStyle(extraBar, fillStyle);
            extraBar.startValue.connectFrom((NumericPipe)responseAxisBaselineMapper);
            ContinuousRangeToNumericMapper extraBarHeightMapper = new ContinuousRangeToNumericMapper();
            extraBarHeightMapper.shareMap(responseAxisMapper);
            extraBarHeightMapper.input.setValue(barHeight);
            extraBar.endValue.connectFrom((NumericPipe)extraBarHeightMapper);
            extraBar.transform.translateX.setValue(xTranslation);
            StringToNumericMapper extraBarCategoryAxisMapper = new StringToNumericMapper();
            extraBarCategoryAxisMapper.shareMap(categoryAxisMapper);
            extraBarCategoryAxisMapper.input.setValue(barID);
            extraBar.position.connectFrom((NumericPipe)extraBarCategoryAxisMapper);
        }
        return extraBar;
    }

    public static void applyNumericStyleByColors(Bar bar, NumericVariable styleByVariable, BarLineChartCellModel cellModel, double barBaseline) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        ContinuousRangeToColorMapper cr2cm = cellModel.getValueToContinuousColor();
        DiscreteRangeToColorMapper dr2cm = cellModel.getFormattedValueToDiscreteColor();
        if (cr2cm != null) {
            ContinuousRangeToColorMapper colorMapper = new ContinuousRangeToColorMapper();
            colorMapper.shareMap(cr2cm);
            colorMapper.input.connectFrom(styleByVariable.value);
            bar.color1.connectFrom((ColorPipe)colorMapper);
            if (barLineChartModel.getColorPaletteType() == 11805) {
                double legendBaseline = 0.0;
                if (cellModel.getResultingLegendBaseline() != null) {
                    legendBaseline = cellModel.getResultingLegendBaseline();
                }
                bar.gradientOn.setValue(true);
                bar.gradientDirection.setValue(1);
                bar.color2.setValue(colorMapper.getValue(legendBaseline));
            }
        } else if (dr2cm != null) {
            DiscreteRangeToColorMapper colorMapper = new DiscreteRangeToColorMapper();
            colorMapper.shareMap(dr2cm);
            colorMapper.input.connectFrom(styleByVariable.value);
            bar.color1.connectFrom((ColorPipe)colorMapper);
            if (barLineChartModel.getColorPaletteType() == 11804) {
                double legendBaseline = 0.0;
                if (cellModel.getResultingLegendBaseline() != null) {
                    legendBaseline = cellModel.getResultingLegendBaseline();
                }
                bar.gradientOn.setValue(true);
                bar.gradientDirection.setValue(1);
                bar.color2.setValue(colorMapper.getValue(legendBaseline));
            }
        }
    }

    public static void applyThreshold(Bar bar, double axisBaseline, double axisLowerThreshold, double axisUpperThreshold, FillStyle lowerThresholdFillStyle, FillStyle upperThresholdFillStyle, NumericPipe value, ContinuousRangeToNumericMapper axisMapper) {
        if (!Double.isNaN(axisUpperThreshold) && axisUpperThreshold < axisBaseline || axisUpperThreshold == Double.POSITIVE_INFINITY) {
            axisUpperThreshold = Double.NaN;
        }
        if (!Double.isNaN(axisLowerThreshold) && axisLowerThreshold > axisBaseline || axisLowerThreshold == Double.NEGATIVE_INFINITY) {
            axisLowerThreshold = Double.NaN;
        }
        if (!Double.isNaN(axisUpperThreshold) || !Double.isNaN(axisLowerThreshold)) {
            NumericRangeSegment[] rs = BarLineChartUtil._newBaselineRangeSegments(axisBaseline, lowerThresholdFillStyle.getSolidFillColor(), upperThresholdFillStyle.getSolidFillColor());
            DiscreteRangeToColorMapper thresholdColorMapper = new DiscreteRangeToColorMapper();
            thresholdColorMapper.setRangeSegments(rs);
            thresholdColorMapper.input.connectFrom(value);
            bar.thresholdColor.connectFrom((ColorPipe)thresholdColorMapper);
            rs = BarLineChartUtil._newBaselineRangeSegments(axisBaseline, new Double(Double.isNaN(axisLowerThreshold) ? Double.NEGATIVE_INFINITY : axisLowerThreshold), new Double(Double.isNaN(axisUpperThreshold) ? Double.POSITIVE_INFINITY : axisUpperThreshold));
            DiscreteRangeToNumericMapper thresholdSwitchMapper = new DiscreteRangeToNumericMapper();
            thresholdSwitchMapper.setRangeSegments(rs);
            thresholdSwitchMapper.input.connectFrom(value);
            ContinuousRangeToNumericMapper thresholdMapper = new ContinuousRangeToNumericMapper();
            thresholdMapper.shareMap(axisMapper);
            thresholdMapper.input.connectFrom((NumericPipe)thresholdSwitchMapper);
            bar.thresholdValue.connectFrom((NumericPipe)thresholdMapper);
            bar.thresholdOn.setValue(true);
        }
    }

    private static void _createCategoryReferenceLines(Channel channel, Composites composites, BarLineChartCellModel cellModel, DataSource dataSource, int cellRow, int cellColumn, StringVariable categoryVariable, StringToNumericMapper categoryAxisMapper, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength, boolean isVerticalOrientation, double z) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        ReferenceLineModel[] rlma = barLineChartModel.getCategoryAxisModel().getReferenceLineModels();
        composites.categoryReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesBackComposite);
        composites.categoryReferenceLinesFrontComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesFrontComposite);
        BarLineChartUtil._addCategoryReferenceLines(channel, composites.categoryReferenceLinesBackComposite, composites.categoryReferenceLinesFrontComposite, rlma, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, -z, false, true);
        BarLineChartUtil._addCategoryReferenceLines(channel, composites.categoryReferenceLinesFrontComposite, composites.categoryReferenceLinesFrontComposite, rlma, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, 0.0, true, true);
    }

    private static void _createCategoryReferenceBands(Channel channel, Composites composites, BarLineChartCellModel cellModel, DataSource dataSource, int cellRow, int cellColumn, StringVariable categoryVariable, StringToNumericMapper categoryAxisMapper, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength, boolean isVerticalOrientation, double z) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        ReferenceBandModel[] rbma = barLineChartModel.getCategoryAxisModel().getReferenceBandModels();
        if (rbma != null) {
            BarLineChartUtil._addCategoryReferenceBands(channel, composites, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, z);
            ReferenceLineModel[] rlma = Util.getReferenceLineModels(rbma);
            composites.categoryReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesBackComposite);
            BarLineChartUtil._addCategoryReferenceLines(channel, composites.categoryReferenceLinesBackComposite, composites.categoryReferenceLinesBackComposite, rlma, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, -z, false, false);
            BarLineChartUtil._addCategoryReferenceLines(channel, composites.categoryReferenceLinesBackComposite, composites.categoryReferenceLinesBackComposite, rlma, cellModel, dataSource, cellRow, cellColumn, categoryVariable, categoryAxisMapper, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, -z, true, false);
        }
    }

    private static void _addCategoryReferenceLines(Channel channel, Composite lineComposite, Composite labelComposite, ReferenceLineModel[] rlma, BarLineChartCellModel cellModel, DataSource dataSource, int cellRow, int cellColumn, StringVariable categoryVariable, StringToNumericMapper categoryAxisMapper, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength, boolean isVerticalOrientation, double z, boolean processInFrontRefLines, boolean automaticRefLineVisibilityPolicyValue) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int maxRow = cellModel.getMaxRow();
        int maxColumn = cellModel.getMaxColumn();
        Util.addReferenceLines(rlma, channel, dataSource, categoryVariable, (Mapper)categoryAxisMapper, barLineChartModel.getCategoryAxisModel(), xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, isVerticalOrientation, lineComposite, labelComposite, cellRow, cellColumn, maxRow, maxColumn, z, 4, 11301, processInFrontRefLines, automaticRefLineVisibilityPolicyValue);
    }

    private static void _addCategoryReferenceBands(Channel channel, Composites composites, BarLineChartCellModel cellModel, DataSource dataSource, int cellRow, int cellColumn, StringVariable categoryVariable, StringToNumericMapper categoryAxisMapper, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength, boolean isVerticalOrientation, double z) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        ReferenceBandModel[] rbma = barLineChartModel.getCategoryAxisModel().getReferenceBandModels();
        if (rbma != null) {
            for (int ii = 0; ii < rbma.length; ++ii) {
                double endPosition;
                double d;
                double beginPosition;
                double d2;
                if (rbma[ii] == null || !rbma[ii].isVisible()) continue;
                String labelString = rbma[ii].getLabel();
                TextStyle textStyle = rbma[ii].getTextStyle() != null ? rbma[ii].getTextStyle() : barLineChartModel.getCategoryAxisModel().getValueTextStyle();
                channel.glSelect2DFont(textStyle.getFont());
                boolean isDrawLabel = textStyle.isVisible() && labelString != null && (isVerticalOrientation && cellRow < 1 || !isVerticalOrientation && cellColumn == cellModel.getMaxColumn());
                Object categoryBeginPosition = rbma[ii].getBeginReferenceLineModel().getPositionAsObject();
                if (categoryBeginPosition == null && !Double.isNaN(d2 = rbma[ii].getBeginReferenceLineModel().getPosition()) && !Double.isInfinite(d2)) {
                    categoryBeginPosition = new Double(d2);
                }
                if (Double.isNaN(beginPosition = Util.asWorldValue(dataSource, categoryVariable, (StringToNumericMap)categoryAxisMapper.getNumericMap(), categoryBeginPosition))) continue;
                Object categoryEndPosition = rbma[ii].getEndReferenceLineModel().getPositionAsObject();
                if (categoryEndPosition == null && !Double.isNaN(d = rbma[ii].getEndReferenceLineModel().getPosition()) && !Double.isInfinite(d)) {
                    categoryEndPosition = new Double(d);
                }
                if (Double.isNaN(endPosition = Util.asWorldValue(dataSource, categoryVariable, (StringToNumericMap)categoryAxisMapper.getNumericMap(), categoryEndPosition))) continue;
                Grid band = new Grid();
                band.selectEnabled.setValue(false);
                GTKUtil.applyFillStyle(band, rbma[ii].getFillStyle());
                if (rbma[ii].getFillStyle().isVisible()) {
                    if (isVerticalOrientation) {
                        double beginY = -yStart;
                        double endY = yAxisLength + (double)yStart + (double)yEnd;
                        band.transform.translateX.setValue(beginPosition);
                        band.transform.translateY.setValue(beginY);
                        band.transform.translateZ.setValue(-z);
                        band.setWidth(endPosition - beginPosition);
                        band.setHeight(endY - beginY);
                    } else {
                        double beginX = -xStart;
                        double endX = (double)xStart + xAxisLength + (double)xEnd;
                        band.transform.translateX.setValue(beginX);
                        band.transform.translateY.setValue(beginPosition);
                        band.transform.translateZ.setValue(-z);
                        band.setWidth(endX - beginX);
                        band.setHeight(endPosition - beginPosition);
                    }
                    composites.categoryReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesBackComposite);
                    composites.categoryReferenceLinesBackComposite.addElement((Element)band);
                }
                if (!isDrawLabel) continue;
                RasterLabel label = new RasterLabel();
                label.selectEnabled.setValue(false);
                label.trimOn.setValue(false);
                label.string.setValue(rbma[ii].getLabel());
                Font font = textStyle.getFont();
                label.fontName.setValue(font.getName());
                label.fontSize.setValue(font.getSize());
                label.fontStyle.setValue(font.getStyle());
                label.color.setValue(textStyle.getColor());
                label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
                label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
                label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
                label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
                if (isVerticalOrientation) {
                    switch (textStyle.getJustification()) {
                        default: {
                            label.horizontalJustification.setValue(1);
                            label.transform.translateX.setValue(beginPosition + (endPosition - beginPosition) / 2.0);
                            break;
                        }
                        case 2: {
                            label.horizontalJustification.setValue(0);
                            label.transform.translateX.setValue(beginPosition);
                            break;
                        }
                        case 4: {
                            label.horizontalJustification.setValue(2);
                            label.transform.translateX.setValue(endPosition);
                        }
                    }
                    label.verticalJustification.setValue(0);
                    label.transform.translateY.setValue(yAxisLength + (double)yEnd);
                    composites.categoryReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesBackComposite);
                    composites.categoryReferenceLinesBackComposite.addElement((Element)label);
                } else {
                    switch (textStyle.getJustification()) {
                        default: {
                            label.verticalJustification.setValue(1);
                            label.transform.translateY.setValue(beginPosition + (endPosition - beginPosition) / 2.0);
                            break;
                        }
                        case 2: {
                            label.verticalJustification.setValue(0);
                            label.transform.translateY.setValue(beginPosition);
                            break;
                        }
                        case 4: {
                            label.verticalJustification.setValue(3);
                            label.transform.translateY.setValue(endPosition);
                        }
                    }
                    label.horizontalJustification.setValue(2);
                    label.transform.translateX.setValue(xAxisLength + (double)xEnd);
                    composites.categoryReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.categoryReferenceLinesBackComposite);
                    composites.categoryReferenceLinesBackComposite.addElement((Element)label);
                }
                label.transform.translateZ.setValue(-z);
            }
        }
    }

    public static void addResponseReferenceLines(Channel channel, Composites composites, BarLineChartCellModel cellModel, DataSource dataSource, int cellRow, int cellColumn, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength, double z) {
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        int maxRow = cellModel.getMaxRow();
        int maxColumn = cellModel.getMaxColumn();
        AxisModel responseAxisModel = barLineChartModel.getResponseAxisModel();
        AxisModel response2AxisModel = barLineChartModel.getResponse2AxisModel();
        NumericMapper responseMapper = cellModel.getResponseAxisCellModel().getMapper();
        NumericMapper response2Mapper = cellModel.getResponse2AxisCellModel().getMapper();
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        composites.responseReferenceLinesFrontComposite = BarLineChartUtil.composite(composites, composites.responseReferenceLinesFrontComposite);
        composites.responseReferenceLinesBackComposite = BarLineChartUtil.composite(composites, composites.responseReferenceLinesBackComposite);
        Util.addReferenceLines(responseAxisModel.getReferenceLineModels(), channel, dataSource, null, (Mapper)responseMapper, responseAxisModel, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, !isVerticalOrientation, composites.responseReferenceLinesFrontComposite, composites.responseReferenceLinesFrontComposite, cellRow, cellColumn, maxRow, maxColumn, -z, 2, 11302, true, true);
        Util.addReferenceLines(response2AxisModel.getReferenceLineModels(), channel, dataSource, null, (Mapper)response2Mapper, response2AxisModel, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, !isVerticalOrientation, composites.responseReferenceLinesFrontComposite, composites.responseReferenceLinesFrontComposite, cellRow, cellColumn, maxRow, maxColumn, -z, 4, 11302, true, true);
        Util.addReferenceLines(responseAxisModel.getReferenceLineModels(), channel, dataSource, null, (Mapper)responseMapper, responseAxisModel, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, !isVerticalOrientation, composites.responseReferenceLinesBackComposite, composites.responseReferenceLinesFrontComposite, cellRow, cellColumn, maxRow, maxColumn, -z, 2, 11302, false, true);
        Util.addReferenceLines(response2AxisModel.getReferenceLineModels(), channel, dataSource, null, (Mapper)response2Mapper, response2AxisModel, xStart, xEnd, yStart, yEnd, yAxisLength, xAxisLength, !isVerticalOrientation, composites.responseReferenceLinesBackComposite, composites.responseReferenceLinesFrontComposite, cellRow, cellColumn, maxRow, maxColumn, -z, 4, 11302, false, true);
    }

    public static Variable[] newRelationalSelectionVariableArray(Variable[] selectionVariableArray, Variable[] responseVariableArray) {
        Variable[] newSelectionVariableArray;
        if (selectionVariableArray == null || selectionVariableArray.length < 1 || selectionVariableArray[0] == null) {
            return null;
        }
        Variable[] variableArray = newSelectionVariableArray = responseVariableArray == null ? null : new Variable[responseVariableArray.length];
        if (newSelectionVariableArray != null) {
            for (int ii = 0; ii < newSelectionVariableArray.length; ++ii) {
                newSelectionVariableArray[ii] = selectionVariableArray[0];
            }
        }
        return newSelectionVariableArray;
    }

    public static ValueList buildIntegratedCategoryColumnValueList(ValueList columnValueList, ValueList categoryValueList) {
        ValueList list = null;
        while (columnValueList != null) {
            list = new ValueList(columnValueList.getUnformattedValue(), columnValueList.getFormattedValue(), list);
            columnValueList = columnValueList.getNext();
        }
        if (categoryValueList != null) {
            list = new ValueList(categoryValueList.getUnformattedValue(), categoryValueList.getFormattedValue(), list);
        }
        list = ValueList.reverse(list);
        return list;
    }

    public static LabelZoneList newResponseLabelList(LabelZoneList responseLabelList, Variable[] responseVariableArray, Shape shape, DataZone drillIcon) {
        if (responseVariableArray != null) {
            for (int ii = responseVariableArray.length - 1; ii >= 0; --ii) {
                if (responseVariableArray[ii] == null) continue;
                responseLabelList = new LabelZoneList(shape, responseVariableArray[ii].getName(), responseVariableArray[ii].getLabel(), drillIcon, responseLabelList);
            }
        }
        return responseLabelList;
    }

    public static void addBaseLineElements(Composites composites, BarLineChartCellModel cellModel, ContinuousRangeToNumericMapper baselineMapper, ReferenceLineModel baselineModel, LineStyle refLineStyle, int xStart, int xEnd, int yStart, int yEnd, double yAxisLength, double xAxisLength) {
        double baselineValue;
        boolean isVerticalOrientation;
        BarLineChartModel barLineChartModel = cellModel.getBarLineChartModel();
        boolean bl = isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        if (baselineMapper != null && baselineModel.isVisible() && refLineStyle.getVisibilityPolicy() != 10202 && (baselineValue = baselineMapper.input.getValue()) >= baselineMapper.getInputMin() && baselineValue <= baselineMapper.getInputMax()) {
            LineSegment baseline = new LineSegment();
            baseline.selectEnabled.setValue(false);
            baseline.disableAntialiasingForHorizontalOrVerticalLines.setValue(true);
            if (isVerticalOrientation) {
                baseline.beginX.setValue((double)(-xStart - 2));
                baseline.endX.setValue(xAxisLength + (double)xEnd - 1.0);
                baseline.beginY.connectFrom((NumericPipe)baselineMapper);
                baseline.endY.connectFrom((NumericPipe)baselineMapper);
            } else {
                baseline.beginY.setValue((double)(-yStart));
                baseline.endY.setValue(yAxisLength + (double)yEnd - 2.0);
                baseline.beginX.connectFrom((NumericPipe)baselineMapper);
                baseline.endX.connectFrom((NumericPipe)baselineMapper);
            }
            baseline.color.setValue(refLineStyle.getColor());
            baseline.lineWidth.setValue(refLineStyle.getThickness().getMagnitude((Object)"px"));
            composites.categoryAxisComposite = BarLineChartUtil.composite(composites, composites.categoryAxisComposite);
            composites.categoryAxisComposite.addElement((Element)baseline);
        }
    }

    public static BarLineChartAxisRanges calculateAxisRanges(BarLineChartModel barLineChartModel, BarLineChartVariables variables, boolean stackBarsEnabled, boolean stackLines, double[] waterfallFinalResponseValues, double[] waterfallFinalOutsideDataLabelValues, Double initialBarHeight) {
        double[] range;
        int barVariableCount = variables.responseAxis.getBarVariableCount();
        int bar2VariableCount = variables.response2Axis.getBarVariableCount();
        int lineVariableCount = variables.responseAxis.getLineVariableCount();
        int line2VariableCount = variables.response2Axis.getLineVariableCount();
        int totalBarVariableCount = variables.getTotalBarVariableCount();
        int totalLineVariableCount = variables.getTotalLineVariableCount();
        StringVariable subgroupVariable = variables.subgroupVariable;
        StringVariable categoryVariable = variables.categoryVariable;
        Variable[] barVariableArray = variables.responseAxis.barVariableArray;
        Variable[] barLowVariableArray = variables.responseAxis.barLowVariableArray;
        Variable[] barHighVariableArray = variables.responseAxis.barHighVariableArray;
        Variable[] barTargetVariableArray = variables.responseAxis.barTargetVariableArray;
        Variable[] bar2VariableArray = variables.response2Axis.barVariableArray;
        Variable[] bar2LowVariableArray = variables.response2Axis.barLowVariableArray;
        Variable[] bar2HighVariableArray = variables.response2Axis.barHighVariableArray;
        Variable[] bar2TargetVariableArray = variables.response2Axis.barTargetVariableArray;
        Variable[] lineVariableArray = variables.responseAxis.lineVariableArray;
        Variable[] line2VariableArray = variables.response2Axis.lineVariableArray;
        Variable[] outsideBarLabelVariableArray = variables.outsideBarLabelVariableArray;
        double min1 = Double.POSITIVE_INFINITY;
        double max1 = Double.NEGATIVE_INFINITY;
        double min2 = Double.POSITIVE_INFINITY;
        double max2 = Double.NEGATIVE_INFINITY;
        double responseAxisBaselinePosition = barLineChartModel.getResponseAxisBaselineModel().getPosition();
        double response2AxisBaselinePosition = barLineChartModel.getResponse2AxisBaselineModel().getPosition();
        if (Double.isInfinite(responseAxisBaselinePosition)) {
            responseAxisBaselinePosition = Double.NaN;
        }
        if (Double.isInfinite(response2AxisBaselinePosition)) {
            response2AxisBaselinePosition = Double.NaN;
        }
        if (Double.isNaN(responseAxisBaselinePosition) && barVariableCount > 0) {
            responseAxisBaselinePosition = 0.0;
        }
        if (Double.isNaN(response2AxisBaselinePosition) && bar2VariableCount > 0) {
            response2AxisBaselinePosition = 0.0;
        }
        if (totalBarVariableCount > 0) {
            if (stackBarsEnabled && subgroupVariable != null) {
                int ii;
                BidirectionalAccumulatorByCategory accEnd = new BidirectionalAccumulatorByCategory();
                accEnd.setPostAccumulate(false);
                accEnd.category.connectFrom(categoryVariable.category);
                for (ii = 0; ii < barVariableCount; ++ii) {
                    accEnd.input.disconnect();
                    accEnd.input.connectFrom(((NumericVariable)barVariableArray[ii]).value);
                    range = accEnd.getAccumulation();
                    min1 = Math.min(min1, range[0]);
                    max1 = Math.max(max1, range[1]);
                }
                for (ii = 0; ii < bar2VariableCount; ++ii) {
                    accEnd.input.disconnect();
                    accEnd.input.connectFrom(((NumericVariable)bar2VariableArray[ii]).value);
                    range = accEnd.getAccumulation();
                    min2 = Math.min(min2, range[0]);
                    max2 = Math.max(max2, range[1]);
                }
            } else if (stackBarsEnabled && (barVariableCount > 1 || bar2VariableCount > 1)) {
                int ii;
                MultiResponseStackedBar mrsBar;
                if (barVariableCount > 0) {
                    mrsBar = new MultiResponseStackedBar();
                    for (ii = 0; ii < barVariableCount; ++ii) {
                        mrsBar.addResponse(((NumericVariable)barVariableArray[ii]).value, ((NumericVariable)barVariableArray[ii]).value);
                    }
                    mrsBar.init(new AInitAction());
                    min1 = mrsBar.getNegativeExtent();
                    max1 = mrsBar.getPositiveExtent();
                }
                if (bar2VariableCount > 0) {
                    mrsBar = new MultiResponseStackedBar();
                    for (ii = 0; ii < bar2VariableCount; ++ii) {
                        mrsBar.addResponse(((NumericVariable)bar2VariableArray[ii]).value, ((NumericVariable)bar2VariableArray[ii]).value);
                    }
                    mrsBar.init(new AInitAction());
                    min2 = mrsBar.getNegativeExtent();
                    max2 = mrsBar.getPositiveExtent();
                }
            } else if (barLineChartModel.isWaterfallEnabled() && waterfallFinalResponseValues != null && waterfallFinalResponseValues.length == barVariableCount) {
                for (int ii = 0; ii < barVariableCount; ++ii) {
                    if (barVariableArray[ii] == null) continue;
                    double rtmax = initialBarHeight != null ? initialBarHeight : 0.0;
                    double rtmin = rtmax;
                    double rt = rtmax;
                    double[] values = GTKUtil.PipeAccess.getValues_as_doubleArray(((NumericVariable)barVariableArray[ii]).value);
                    for (int kk = 0; kk < values.length; ++kk) {
                        if (Double.isNaN(values[kk])) continue;
                        rtmin = Math.min(rtmin, rt += values[kk]);
                        rtmax = Math.max(rtmax, rt);
                    }
                    waterfallFinalResponseValues[ii] = rt;
                    min1 = Math.min(min1, rtmin);
                    max1 = Math.max(max1, rtmax);
                    if (outsideBarLabelVariableArray == null || outsideBarLabelVariableArray.length <= ii || !(outsideBarLabelVariableArray[ii] instanceof NumericVariable) || waterfallFinalOutsideDataLabelValues == null || waterfallFinalOutsideDataLabelValues.length != outsideBarLabelVariableArray.length) continue;
                    rt = 0.0;
                    if (initialBarHeight != null) {
                        Integer outsideBarLabelStatistic;
                        VariableDefinition barResponseVariableDefinition = variables.dataSource.getVariableDefinition(variables.responseAxis.barRole, ii);
                        VariableDefinition outsideBarLabelVariableDefinition = variables.dataSource.getVariableDefinition(variables.outsideBarLabelRole, ii);
                        if (barResponseVariableDefinition instanceof AnalysisVariableDefinition && outsideBarLabelVariableDefinition instanceof AnalysisVariableDefinition && ((AnalysisVariableDefinition)barResponseVariableDefinition).isCompatableStatistic(outsideBarLabelStatistic = ((AnalysisVariableDefinition)outsideBarLabelVariableDefinition).getStatistic())) {
                            rt = initialBarHeight;
                        }
                    }
                    double[] values2 = GTKUtil.PipeAccess.getValues_as_doubleArray(((NumericVariable)outsideBarLabelVariableArray[ii]).value);
                    for (int kk = 0; kk < values2.length; ++kk) {
                        if (Double.isNaN(values2[kk])) continue;
                        rt += values2[kk];
                    }
                    waterfallFinalOutsideDataLabelValues[ii] = rt;
                }
                double baseline = Double.isNaN(responseAxisBaselinePosition) ? 0.0 : responseAxisBaselinePosition;
                min1 = Math.min(min1, baseline);
                max1 = Math.max(max1, baseline);
            } else {
                if (!Double.isNaN(responseAxisBaselinePosition)) {
                    min1 = max1 = responseAxisBaselinePosition;
                }
                Variable[][] bars = new Variable[][]{barVariableArray, barHighVariableArray, barLowVariableArray, barTargetVariableArray};
                double[] minMax = GTKUtil.GtkVariable.calcMinMax(bars);
                min1 = Math.min(min1, minMax[0]);
                max1 = Math.max(max1, minMax[1]);
                if (!Double.isNaN(response2AxisBaselinePosition)) {
                    min2 = max2 = response2AxisBaselinePosition;
                }
                Variable[][] bar2s = new Variable[][]{bar2VariableArray, bar2HighVariableArray, bar2LowVariableArray, bar2TargetVariableArray};
                minMax = GTKUtil.GtkVariable.calcMinMax(bar2s);
                min2 = Math.min(min2, minMax[0]);
                max2 = Math.max(max2, minMax[1]);
            }
        }
        if (totalLineVariableCount > 0) {
            if (stackLines) {
                if (subgroupVariable != null) {
                    int ii;
                    BidirectionalAccumulatorByCategory accY = new BidirectionalAccumulatorByCategory();
                    accY.setPostAccumulate(false);
                    accY.category.connectFrom(categoryVariable.category);
                    for (ii = 0; ii < lineVariableCount; ++ii) {
                        accY.input.connectFrom(((NumericVariable)lineVariableArray[ii]).value);
                        range = accY.getAccumulation();
                        min1 = Math.min(min1, range[0]);
                        max1 = Math.max(max1, range[1]);
                    }
                    for (ii = 0; ii < line2VariableCount; ++ii) {
                        accY.input.connectFrom(((NumericVariable)line2VariableArray[ii]).value);
                        range = accY.getAccumulation();
                        min2 = Math.min(min2, range[0]);
                        max2 = Math.max(max2, range[1]);
                    }
                }
            } else {
                int ii;
                if (!Double.isNaN(responseAxisBaselinePosition)) {
                    min1 = Math.min(min1, responseAxisBaselinePosition);
                    max1 = Math.max(max1, responseAxisBaselinePosition);
                }
                for (ii = 0; ii < lineVariableCount; ++ii) {
                    min1 = Math.min(min1, ((NumericVariable)lineVariableArray[ii]).getMin());
                    max1 = Math.max(max1, ((NumericVariable)lineVariableArray[ii]).getMax());
                }
                if (!Double.isNaN(response2AxisBaselinePosition)) {
                    min2 = Math.min(min2, response2AxisBaselinePosition);
                    max2 = Math.max(max2, response2AxisBaselinePosition);
                }
                for (ii = 0; ii < line2VariableCount; ++ii) {
                    min2 = Math.min(min2, ((NumericVariable)line2VariableArray[ii]).getMin());
                    max2 = Math.max(max2, ((NumericVariable)line2VariableArray[ii]).getMax());
                }
            }
        }
        BarLineChartAxisRange responseAxisRange = new BarLineChartAxisRange(min1, max1);
        BarLineChartAxisRange response2AxisRange = new BarLineChartAxisRange(min2, max2);
        return new BarLineChartAxisRanges(responseAxisRange, response2AxisRange);
    }

    public static Composite composite(Composites composites, Composite c) {
        return BarLineChartUtil.composite(composites.source, c);
    }

    public static Composite composite(Composite source, Composite c) {
        if (c == null) {
            c = new Composite();
            if (source != null) {
                c.transform.translateX.connectFrom((NumericPipe)source.transform.translateX);
                c.transform.translateY.connectFrom((NumericPipe)source.transform.translateY);
            }
        }
        return c;
    }

    public static Composite translate(Composite c, double x, double y) {
        Composite t = null;
        if (c != null) {
            t = new Composite();
            t.transform.translateX.setValue(x);
            t.transform.translateY.setValue(y);
            t.addElement((Element)c);
        }
        return t;
    }

    public static boolean isAxisReverse(AxisCellModel acm) {
        Boolean reverseObj = acm.getReverse();
        boolean reverse = reverseObj != null ? reverseObj : false;
        return reverse != acm.getAxisModel().isReverseDirection();
    }

    private static ImageIcon createSkinIcon(int skin, boolean is3D, boolean isVerticalOrientation) {
        ImageIcon barEffectsIcon = null;
        if (!is3D) {
            switch (skin) {
                case 12301: {
                    if (isVerticalOrientation) {
                        barEffectsIcon = GraphResources.getImageIcon("skin/satin/bar/vertical/BarEffects.png");
                        break;
                    }
                    barEffectsIcon = GraphResources.getImageIcon("skin/satin/bar/horizontal/BarEffects.png");
                    break;
                }
                case 12302: {
                    if (isVerticalOrientation) {
                        barEffectsIcon = GraphResources.getImageIcon("skin/modern/bar/vertical/BarEffects.png");
                        break;
                    }
                    barEffectsIcon = GraphResources.getImageIcon("skin/modern/bar/horizontal/BarEffects.png");
                    break;
                }
            }
        }
        return barEffectsIcon;
    }

    private static AbstractMarkerSkinFactory createMarkerSkinFactory(BarLineChartModel barLineChartModel) {
        int skin = barLineChartModel.getSkin();
        if (skin == 12302 || skin == 12301) {
            boolean is3D = barLineChartModel.getDimension() == 10101;
            boolean isVertical = barLineChartModel.getOrientation() == 1;
            return BIPBarSkinFactory.getInstance(skin, is3D, isVertical);
        }
        return null;
    }

    static {
        HIGHLIGHT_OFF.setValue(0.0);
    }

    public static class BarLineChartAxisVariables {
        public final Object barRole;
        public final Object barSelectionRole;
        public final Object lineRole;
        public final Object lineSelectionRole;
        public final Variable[] barVariableArray;
        public final Variable[] barHighVariableArray;
        public final Variable[] barLowVariableArray;
        public final Variable[] barTargetVariableArray;
        public final Variable[] barSelectionVariableArray;
        public final Variable[] lineVariableArray;
        public final Variable[] lineHighVariableArray;
        public final Variable[] lineLowVariableArray;
        public final Variable[] lineTargetVariableArray;
        public final Variable[] lineSelectionVariableArray;

        public BarLineChartAxisVariables(DataSource dataSource, Object barRole, Object lineRole, Object barSelectionRole, Object lineSelectionRole, Object selectionRole) {
            this.barRole = barRole;
            this.barSelectionRole = barSelectionRole;
            this.lineRole = lineRole;
            this.lineSelectionRole = lineSelectionRole;
            this.barVariableArray = dataSource.getVariable(barRole);
            this.barHighVariableArray = dataSource.getHighVariable(barRole);
            this.barLowVariableArray = dataSource.getLowVariable(barRole);
            this.barTargetVariableArray = dataSource.getTargetVariable(barRole);
            this.lineVariableArray = dataSource.getVariable(lineRole);
            this.lineHighVariableArray = dataSource.getHighVariable(lineRole);
            this.lineLowVariableArray = dataSource.getLowVariable(lineRole);
            this.lineTargetVariableArray = dataSource.getTargetVariable(lineRole);
            if (dataSource.isOLAPData()) {
                this.barSelectionVariableArray = dataSource.getVariable(barSelectionRole);
                this.lineSelectionVariableArray = dataSource.getVariable(lineSelectionRole);
            } else {
                Variable[] selectionVariableArray = dataSource.getVariable(selectionRole);
                this.barSelectionVariableArray = BarLineChartUtil.newRelationalSelectionVariableArray(selectionVariableArray, this.barVariableArray);
                this.lineSelectionVariableArray = BarLineChartUtil.newRelationalSelectionVariableArray(selectionVariableArray, this.lineVariableArray);
            }
        }

        public int getBarVariableCount() {
            return this.barVariableArray == null ? 0 : this.barVariableArray.length;
        }

        public int getLineVariableCount() {
            return this.lineVariableArray == null ? 0 : this.lineVariableArray.length;
        }
    }

    public static class BarLineChartVariables {
        public final Object categoryRole;
        public final Object categorySortRole;
        public final Object subgroupRole;
        public final Object styleByRole;
        public final BarLineChartAxisVariables responseAxis;
        public final BarLineChartAxisVariables response2Axis;
        public final Object selectionRole;
        public final Object outsideBarLabelRole;
        public final Object insideBarLabelRole;
        public final Object outsideMarkerLabelRole;
        public final Object dataTipRole;
        public final Object auxiliaryRole;
        public final StringVariable categoryVariable;
        public final Variable categorySortVariable;
        public final StringVariable subgroupVariable;
        public final Variable styleByVariable;
        public final NumericVariable selectedPercentageVariable;
        public final Variable[] outsideBarLabelVariableArray;
        public final Variable[] insideBarLabelVariableArray;
        public final Variable[] outsideMarkerLabelVariableArray;
        public final Variable[] dataTipVariableArray;
        public final Variable[] auxiliaryVariableArray;
        private final int _totalBarVariableCount;
        private final int _totalLineVariableCount;
        public final DataSource dataSource;

        public BarLineChartVariables(DataSource dataSource, BarLineChartCellModel cellModel) {
            this.dataSource = dataSource;
            this.categoryRole = cellModel.getCategoryRole();
            this.categorySortRole = cellModel.getCategorySortRole();
            this.styleByRole = cellModel.getStyleByRole();
            this.subgroupRole = cellModel.getSubgroupRole();
            this.outsideBarLabelRole = cellModel.getOutsideBarLabelRole();
            this.insideBarLabelRole = cellModel.getInsideBarLabelRole();
            this.outsideMarkerLabelRole = cellModel.getOutsideMarkerLabelRole();
            this.selectionRole = cellModel.getSelectionRole();
            this.dataTipRole = cellModel.getDataTipRole();
            this.auxiliaryRole = cellModel.getAuxiliaryRole();
            this.categoryVariable = (StringVariable)dataSource.getVariable(this.categoryRole, 0);
            this.subgroupVariable = (StringVariable)dataSource.getVariable(this.subgroupRole, 0);
            this.categorySortVariable = dataSource.getVariable(this.categorySortRole, 0);
            this.styleByVariable = dataSource.getVariable(this.styleByRole, 0);
            this.dataTipVariableArray = Util.getGTKVariableArray(dataSource, this.dataTipRole);
            this.auxiliaryVariableArray = Util.getGTKVariableArray(dataSource, this.auxiliaryRole);
            this.outsideBarLabelVariableArray = dataSource.getVariable(this.outsideBarLabelRole);
            this.insideBarLabelVariableArray = dataSource.getVariable(this.insideBarLabelRole);
            this.outsideMarkerLabelVariableArray = dataSource.getVariable(this.outsideMarkerLabelRole);
            this.selectedPercentageVariable = dataSource.getSelectedPercentageVariable();
            this.responseAxis = new BarLineChartAxisVariables(dataSource, cellModel.getBarRole(), cellModel.getLineRole(), cellModel.getBarSelectionRole(), cellModel.getLineSelectionRole(), cellModel.getSelectionRole());
            this.response2Axis = new BarLineChartAxisVariables(dataSource, cellModel.getBar2Role(), cellModel.getLine2Role(), cellModel.getBar2SelectionRole(), cellModel.getLine2SelectionRole(), cellModel.getSelectionRole());
            this._totalBarVariableCount = this.responseAxis.getBarVariableCount() + this.response2Axis.getBarVariableCount();
            this._totalLineVariableCount = this.responseAxis.getLineVariableCount() + this.response2Axis.getLineVariableCount();
        }

        public int getTotalBarVariableCount() {
            return this._totalBarVariableCount;
        }

        public int getTotalLineVariableCount() {
            return this._totalLineVariableCount;
        }
    }

    public static class Composites {
        public final Composite source;
        public Composite axisWallComposite;
        public Composite gridLinesBackWallComposite;
        public Composite dataLabelComposite;
        public Composite barComposite;
        public Composite waterfallComposite;
        public Composite lineComposite;
        public Composite markerComposite;
        public Composite gridLinesFrontWallComposite;
        public Composite categoryAxisComposite;
        public Composite frameComposite;
        public Composite responseReferenceLinesBackComposite;
        public Composite responseReferenceLinesFrontComposite;
        public Composite categoryReferenceLinesBackComposite;
        public Composite categoryReferenceLinesFrontComposite;

        public Composites(Composite source) {
            this.source = source;
        }
    }

    public static class BarLineChartAxisRange {
        private final double min;
        private final double max;

        public BarLineChartAxisRange(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }

    public static class BarLineChartAxisRanges {
        private final BarLineChartAxisRange responseAxisRange;
        private final BarLineChartAxisRange response2AxisRange;

        public BarLineChartAxisRanges(BarLineChartAxisRange responseAxisRange, BarLineChartAxisRange response2AxisRange) {
            this.responseAxisRange = responseAxisRange;
            this.response2AxisRange = response2AxisRange;
        }

        public BarLineChartAxisRange getResponseAxisRange() {
            return this.responseAxisRange;
        }

        public BarLineChartAxisRange getResponse2AxisRange() {
            return this.response2AxisRange;
        }
    }
}

