/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.barlinechart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.util.barlinechart.BarLineChartModel;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCellModel;
import com.sas.graphics.util.cell.barlinechart.BarLineChartUtil;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.AxisDetail;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.MultiResponseStackedBarDetail;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.MultiResponseStackedBar;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.measures.BaseLength;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BarLineChartCell
extends Cell
implements PropertyChangeListener,
ChartImageMapInfo.ChartImageMapInfoAuthorInterface {
    private static final double ANGLE = Math.atan(1.0);
    private static final double COS_ANGLE = Math.cos(ANGLE);
    private static final double DISTORTION_FACTOR = 0.3;
    private static final int MIN_DATA_LABEL_FONT_SIZE = 8;
    private final transient GraphModel graphModel;
    private final transient DataSource dataSource;
    private final transient BarLineChartModel barLineChartModel;
    private final transient BarLineChartCellModel cellModel;
    private final transient BarLineChartUtil.BarLineChartVariables variables;
    private final transient StringToNumericMapper categoryAxisMapper = new StringToNumericMapper();
    private final transient BarLineChartUtil.BarLineChartAxisRanges axisRanges;
    private final transient int categoryUniqueValueCount;
    private final transient int maxBarsPerCategory;
    private final transient int preferredCategoryAxisStride;
    private transient int maxPreferredCategoryAxisStride;
    private final transient boolean stackBarsEnabled;
    private final transient boolean stackLines;
    private final transient AdvancedTextStyle outsideBarLabelTextStyle;
    private final transient AdvancedTextStyle insideBarLabelTextStyle;
    private final transient AdvancedTextStyle outsideMarkerLabelTextStyle;
    private final transient boolean isCategoryAxisIntegrated;
    private final transient boolean isVerticalOrientation;
    private final transient AxisCellModel categoryAxisCellModel;
    private final transient double[] waterfallFinalResponseValues;
    private final transient double[] waterfallFinalOutsideDataLabelValues;
    private transient Double initialBarHeight;
    private transient String waterfallInitialBarID;
    private transient String waterfallFinalBarID;
    private transient boolean allowAntiAliasing;
    private transient int titleHeight;
    private transient int titleWidth;
    private transient double xAxisLength;
    private transient double yAxisLength;
    private transient int xAxisAdj;
    private transient int yAxisAdj;
    private transient int xStart = 0;
    private transient int yStart = 0;
    private transient int xEnd = 0;
    private transient int yEnd = 0;
    private transient double z;
    private transient double totalBarWidth;
    private final transient ValueList columnValueList;
    private final transient ValueList rowValueList;
    Dimension cachedPreferredSize = null;
    AlignableComponentConstraints cachedAlignableComponentConstraints = null;
    private transient double categoryAxisStrideLength = 0.0;

    public BarLineChartCell(BarLineChartCellModel newCellModel, DataSource newDataSource, Object columnOrdinal, Object rowOrdinal, Channel channel) {
        super(newCellModel, channel);
        if (newDataSource == null) {
            throw new IllegalArgumentException("null dataSource not allowed");
        }
        if (newCellModel == null) {
            throw new IllegalArgumentException("null cell-model not allowed");
        }
        this.dataSource = newDataSource;
        this.cellModel = newCellModel;
        this.graphModel = this.cellModel.getGraphModel();
        this.barLineChartModel = this.cellModel.getBarLineChartModel();
        this.columnValueList = Util.DataTreeGroupNodeUtil.toValueList(columnOrdinal);
        this.rowValueList = Util.DataTreeGroupNodeUtil.toValueList(rowOrdinal);
        this.variables = new BarLineChartUtil.BarLineChartVariables(this.dataSource, this.cellModel);
        this.setSelectionModel(this.dataSource.getDataSourceSelectionModel());
        boolean bl = this.isVerticalOrientation = this.barLineChartModel.getOrientation() == 1;
        if (this.dataSource.isAnimationEnabled()) {
            ((StringToNumericMap)this.categoryAxisMapper.getNumericMap()).removeAllStringPipes();
            ((StringToNumericMap)this.categoryAxisMapper.getNumericMap()).addStringPipe(this.variables.categoryVariable.formattedUniqueValue);
        }
        this.categoryAxisMapper.input.connectFrom(this.variables.categoryVariable.formattedValue);
        Boolean ia = this.cellModel.getIntegratedAxisEnabled();
        boolean bl2 = this.isCategoryAxisIntegrated = ia != null && ia != false;
        if (this.cellModel.getUniformCategoryAxisMapper() != null) {
            this.categoryAxisMapper.shareMap(this.cellModel.getUniformCategoryAxisMapper());
        } else if (this.cellModel.getUniformCategoryAxisMappers() != null) {
            Hashtable uniformCategoryMappers = this.cellModel.getUniformCategoryAxisMappers();
            if (this.isVerticalOrientation) {
                this.categoryAxisMapper.shareMap((StringToNumericMapper)uniformCategoryMappers.get(columnOrdinal));
            } else {
                this.categoryAxisMapper.shareMap((StringToNumericMapper)uniformCategoryMappers.get(rowOrdinal));
            }
        } else {
            StringVariable sortedCategoryVariable = this.variables.categoryVariable;
            if (this.variables.categorySortVariable != null) {
                VariableDefinition csvd = this.dataSource.getVariableDefinition(this.variables.categorySortRole, 0);
                if (this.variables.subgroupVariable != null && this.variables.categorySortVariable instanceof NumericVariable && csvd.asGTKSort() != 0) {
                    StringVariable c = VariableFactory.newStringVariable((Variable)this.variables.categoryVariable);
                    StringVariable c2 = VariableFactory.newStringVariable((Variable)c);
                    NumericVariable csv = new NumericVariable();
                    csv.connectFrom((NumericVariable)this.variables.categorySortVariable);
                    if (csvd.getFormat() != null) {
                        csv.setSortByFormattedValues(csvd.isSortByFormattedValue(this.variables.categorySortVariable));
                    }
                    VariableProcessor vp = new VariableProcessor();
                    vp.addGroupVariable((Variable)c);
                    vp.addVariable((Variable)csv, 6);
                    vp.setSort((Variable)csv, csvd.asGTKSort());
                    StringToNumericMap m = new StringToNumericMap();
                    m.addStringPipe(c2.formattedValue);
                    this.categoryAxisMapper.setMap(m);
                } else {
                    this.dataSource.sortBy(this.variables.categorySortRole);
                    StringVariable c2 = new StringVariable();
                    c2.connectFrom(this.variables.categoryVariable);
                    this.categoryAxisMapper.input.connectFrom(c2.formattedValue);
                    sortedCategoryVariable = c2;
                }
            }
            if (this.barLineChartModel.isWaterfallEnabled() && sortedCategoryVariable.getValueCount() > 0) {
                double v = this.barLineChartModel.getWaterfallInitialBarHeight();
                this.initialBarHeight = this.barLineChartModel.isWaterfallEnabled() && !Double.isNaN(v) && !Double.isInfinite(v) ? new Double(v) : null;
                String id = null;
                if (this.initialBarHeight != null) {
                    id = this.barLineChartModel.getWaterfallInitialBarID();
                    id = id == null ? "" : id.trim();
                }
                this.waterfallInitialBarID = id;
                id = null;
                if (this.barLineChartModel.isWaterfallFinalBarEnabled()) {
                    id = this.barLineChartModel.getWaterfallFinalBarID();
                    id = id == null ? "" : id.trim();
                }
                this.waterfallFinalBarID = id;
                if (this.waterfallInitialBarID != null || this.waterfallFinalBarID != null) {
                    int uvc = sortedCategoryVariable.getUniqueValueCount();
                    Vector<String> ufValues = new Vector<String>(uvc + 2);
                    if (this.waterfallInitialBarID != null) {
                        ufValues.add(this.waterfallInitialBarID);
                    }
                    for (int kk = 0; kk < uvc; ++kk) {
                        ufValues.add(GTKUtil.VariableAccess.getFormattedUniqueValue(sortedCategoryVariable, kk));
                    }
                    if (this.waterfallFinalBarID != null) {
                        ufValues.add(this.waterfallFinalBarID);
                    }
                    StringVectorVariable stringVariable = VariableFactory.newStringVectorVariable(ufValues);
                    stringVariable.setLocale(sortedCategoryVariable.getLocale());
                    stringVariable.setSortStrategy(sortedCategoryVariable.getSortStrategy());
                    stringVariable.setUniqueValueSort(0);
                    stringVariable.setLabel(sortedCategoryVariable.getLabel());
                    stringVariable.setFormat(null);
                    stringVariable.setBlankMissing(false);
                    sortedCategoryVariable = stringVariable;
                    StringToNumericMapper waterfallCategoryAxisMapper = new StringToNumericMapper();
                    waterfallCategoryAxisMapper.setLabelMissingValues(true);
                    waterfallCategoryAxisMapper.input.connectFrom(sortedCategoryVariable.formattedValue);
                    this.categoryAxisMapper.shareMap(waterfallCategoryAxisMapper);
                }
            }
        }
        this.categoryUniqueValueCount = this.categoryAxisMapper.getUniqueValueCount();
        int stackBarPolicy = this.barLineChartModel.getStackBarPolicy();
        boolean bl3 = this.stackBarsEnabled = this.variables.subgroupVariable != null && this.variables.getTotalBarVariableCount() > 1 || stackBarPolicy == 10200 && this.variables.subgroupVariable != null || stackBarPolicy == 10201;
        if (this.variables.subgroupVariable != null && !this.stackBarsEnabled) {
            int vc = this.variables.subgroupVariable.getValueCount();
            Hashtable<String, ArrayList<String>> ht = new Hashtable<String, ArrayList<String>>(vc);
            for (int ii = 0; ii < vc; ++ii) {
                String catValue = GTKUtil.VariableAccess.getFormattedValue(this.variables.categoryVariable, ii);
                String subValue = GTKUtil.VariableAccess.getFormattedValue(this.variables.subgroupVariable, ii);
                ArrayList<String> al = (ArrayList<String>)ht.get(catValue);
                if (al == null) {
                    al = new ArrayList<String>();
                    al.add(subValue);
                    ht.put(catValue, al);
                    continue;
                }
                al.add(subValue);
            }
            int max = 0;
            Enumeration catValues = ht.keys();
            while (catValues.hasMoreElements()) {
                max = Math.max(max, ((ArrayList)ht.get(catValues.nextElement())).size());
            }
            this.maxBarsPerCategory = max;
        } else {
            this.maxBarsPerCategory = this.variables.subgroupVariable != null && this.stackBarsEnabled || !this.stackBarsEnabled ? this.variables.getTotalBarVariableCount() : (this.variables.responseAxis.getBarVariableCount() > 0 && this.variables.response2Axis.getBarVariableCount() > 0 ? 2 : 1);
        }
        this.stackLines = false;
        this.waterfallFinalResponseValues = new double[this.variables.responseAxis.getBarVariableCount()];
        this.waterfallFinalOutsideDataLabelValues = (double[])(this.variables.outsideBarLabelVariableArray != null ? new double[this.variables.outsideBarLabelVariableArray.length] : null);
        this.axisRanges = BarLineChartUtil.calculateAxisRanges(this.barLineChartModel, this.variables, this.stackBarsEnabled, this.stackLines, this.waterfallFinalResponseValues, this.waterfallFinalOutsideDataLabelValues, this.initialBarHeight);
        AxisCellModel ancestorCategoryAxisCellModel = this.cellModel.getCategoryAxisCellModel();
        this.categoryAxisCellModel = new AxisCellModel(null, ancestorCategoryAxisCellModel);
        this.categoryAxisCellModel.setMapper((NumericMapper)this.categoryAxisMapper);
        this.categoryAxisCellModel.setMaximizeSpace(Boolean.FALSE);
        this.categoryAxisCellModel.setMargin(new Dimension(0, 0));
        this.categoryAxisCellModel.computeParameters(this.getChannel());
        if (ancestorCategoryAxisCellModel.getTitlePlacementType() == 11306) {
            this.categoryAxisCellModel.setTitlePlacementType(11306);
            this.categoryAxisCellModel.setTitleOn(ancestorCategoryAxisCellModel.getTitleOn());
            this.categoryAxisCellModel.setTitleHeight(new Double(0.0));
            this.categoryAxisCellModel.setTitleWidth(new Double(0.0));
            if (!this.isVerticalOrientation) {
                this.categoryAxisCellModel.setTitleAngle(new Double(90.0));
            }
        }
        Insets outerMargin = this.cellModel.getOuterMargin();
        if (this.isVerticalOrientation) {
            int catAxisAdj = this.categoryAxisCellModel.getCatAxisAdj().intValue();
            if (catAxisAdj > outerMargin.bottom) {
                outerMargin.bottom = catAxisAdj;
                ancestorCategoryAxisCellModel.setCatAxisAdj(new Double(outerMargin.bottom));
            }
        } else {
            int resAxisAdj = this.categoryAxisCellModel.getResAxisAdj().intValue();
            if (resAxisAdj > outerMargin.left) {
                outerMargin.left = resAxisAdj;
                ancestorCategoryAxisCellModel.setResAxisAdj(new Double(outerMargin.left));
            }
        }
        this.categoryAxisCellModel.setCatAxisAdj(null);
        this.categoryAxisCellModel.setResAxisAdj(null);
        this.categoryAxisCellModel.setPreferredMargin(new Dimension(0, 0));
        double d = Math.max(1, this.categoryUniqueValueCount - 1);
        this.preferredCategoryAxisStride = (int)((double)this.categoryAxisCellModel.getLength().intValue() / d + 0.5);
        this.outsideBarLabelTextStyle = new AdvancedTextStyle();
        this.insideBarLabelTextStyle = new AdvancedTextStyle();
        this.outsideMarkerLabelTextStyle = new AdvancedTextStyle();
        this.outsideBarLabelTextStyle.apply(this.barLineChartModel.getOutsideBarLabelTextStyle());
        this.insideBarLabelTextStyle.apply(this.barLineChartModel.getInsideBarLabelTextStyle());
        this.outsideMarkerLabelTextStyle.apply(this.barLineChartModel.getOutsideMarkerLabelTextStyle());
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public double getResponseAxisRangeMin() {
        return this.axisRanges.getResponseAxisRange().getMin();
    }

    public double getResponseAxisRangeMax() {
        return this.axisRanges.getResponseAxisRange().getMax();
    }

    public double getResponse2AxisRangeMin() {
        return this.axisRanges.getResponse2AxisRange().getMin();
    }

    public double getResponse2AxisRangeMax() {
        return this.axisRanges.getResponse2AxisRange().getMax();
    }

    public int getMaxBarsPerCategory() {
        return this.maxBarsPerCategory;
    }

    public int getPreferredCategoryAxisStride() {
        return this.preferredCategoryAxisStride;
    }

    public int getCategoryUniqueValueCount() {
        return this.categoryUniqueValueCount;
    }

    public AxisCellModel getCategoryAxisCellModel() {
        return this.categoryAxisCellModel;
    }

    public BarLineChartCellModel getBarLineChartCellModel() {
        return this.cellModel;
    }

    public void setMaxPreferredCategoryAxisStride(int s) {
        this.maxPreferredCategoryAxisStride = s;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.dataSource.isAnimationEnabled() && this.dataSource.setAnimationPosition(animationPosition)) {
            this.repaint();
        }
    }

    @Override
    protected synchronized void construct() {
        AxisModel validResponseAxisModel;
        AxisCellModel validResponseAxisCellModel;
        double responseAxisLength;
        BarLineChartUtil.Composites composites = new BarLineChartUtil.Composites(this.getComposite());
        this.allowAntiAliasing = false;
        AxisCellModel responseAxisCellModel = this.cellModel.getResponseAxisCellModel();
        AxisCellModel response2AxisCellModel = this.cellModel.getResponse2AxisCellModel();
        AxisModel categoryAxisModel = this.barLineChartModel.getCategoryAxisModel();
        double categoryAxisLength = this.categoryAxisCellModel.getLength();
        double response2AxisLength = response2AxisCellModel != null ? response2AxisCellModel.getLength() : 0.0;
        double d = responseAxisLength = responseAxisCellModel != null ? responseAxisCellModel.getLength() : response2AxisLength;
        if (responseAxisCellModel != null) {
            validResponseAxisCellModel = responseAxisCellModel;
            validResponseAxisModel = this.barLineChartModel.getResponseAxisModel();
        } else {
            validResponseAxisCellModel = response2AxisCellModel;
            validResponseAxisModel = this.barLineChartModel.getResponse2AxisModel();
        }
        if (this.isVerticalOrientation) {
            this.xAxisAdj = this.cellModel.getOuterMargin().bottom;
            this.yAxisAdj = 0;
            this.titleHeight = validResponseAxisCellModel.getTitleHeight().intValue();
            this.titleWidth = this.categoryAxisCellModel.getTitleWidth().intValue();
        } else {
            this.yAxisAdj = this.cellModel.getOuterMargin().left;
            this.xAxisAdj = 0;
            this.titleWidth = validResponseAxisCellModel.getTitleWidth().intValue();
            this.titleHeight = this.categoryAxisCellModel.getTitleHeight().intValue();
        }
        if (this.variables.categoryVariable != null && this.variables.getTotalBarVariableCount() + this.variables.getTotalLineVariableCount() > 0) {
            boolean attemptToAddBaselineElement;
            double delta;
            boolean response2ExtendToEndMargin;
            boolean response2ExtendToStartMargin;
            boolean response2ExtendToMargins;
            boolean response2EndOffset;
            boolean response2StartOffset;
            boolean responseExtendToEndMargin;
            boolean responseExtendToStartMargin;
            boolean responseExtendToMargins;
            int responseEnd;
            boolean responseEndOffset;
            int responseStart;
            boolean responseStartOffset;
            boolean categoryExtendToEndMargin;
            boolean categoryExtendToStartMargin;
            boolean categoryExtendToMargins;
            int categoryEnd;
            boolean categoryEndOffset;
            int categoryStart;
            boolean categoryStartOffset;
            BaseLength bl;
            Dimension m;
            int r2amh;
            int ramh;
            Rectangle b = this.getBounds();
            Dimension depth = this.categoryAxisCellModel.getDepth();
            boolean is3D = this.isVerticalOrientation ? depth.height > 0 : depth.width > 0;
            this.totalBarWidth = this.barLineChartModel.getBarWidth().getMagnitude((Object)"px");
            double totalBarWidthMargin = this.barLineChartModel.getBarWidthSpace().getMagnitude((Object)"px");
            double barPercentage = this.totalBarWidth / (this.totalBarWidth + totalBarWidthMargin);
            double totalCategoryWidth = 0.0;
            if (this.cellModel.getCommonBarWidth() != null) {
                totalCategoryWidth = this.cellModel.getCommonCategoryWidth();
                this.totalBarWidth = this.cellModel.getCommonBarWidth();
            } else {
                totalCategoryWidth = this.categoryAxisMapper.getStrideValue();
                if (totalCategoryWidth == 0.0) {
                    totalCategoryWidth = Math.abs(this.isVerticalOrientation ? this.categoryAxisCellModel.getMargin().getWidth() : this.categoryAxisCellModel.getMargin().getHeight());
                }
                if (this.barLineChartModel.isGrowBarWidthEnabled() || totalCategoryWidth * barPercentage < this.totalBarWidth) {
                    this.totalBarWidth = totalCategoryWidth * barPercentage;
                }
                this.cellModel.setCommonCategoryWidth(new Double(totalCategoryWidth));
                this.cellModel.setCommonBarWidth(new Double(this.totalBarWidth));
            }
            double categoryAxisStride = this.categoryAxisMapper.getStrideValue();
            if (this.isVerticalOrientation) {
                ramh = responseAxisCellModel != null ? responseAxisCellModel.getMargin().height : 0;
                r2amh = response2AxisCellModel != null ? response2AxisCellModel.getMargin().height : 0;
                m = new Dimension(this.categoryAxisCellModel.getMargin().width, Math.max(ramh, r2amh));
            } else {
                ramh = responseAxisCellModel != null ? responseAxisCellModel.getMargin().width : 0;
                r2amh = response2AxisCellModel != null ? response2AxisCellModel.getMargin().width : 0;
                m = new Dimension(Math.max(ramh, r2amh), this.categoryAxisCellModel.getMargin().height);
            }
            Dimension margin = m;
            int y2Start = 0;
            int x2Start = 0;
            int response2Offset = 0;
            if (this.isVerticalOrientation) {
                bl = categoryAxisModel.getStartOffset();
                categoryStartOffset = bl != null;
                categoryStart = categoryStartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = categoryAxisModel.getEndOffset();
                categoryEndOffset = bl != null;
                categoryEnd = categoryEndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                categoryExtendToMargins = this.categoryAxisCellModel.getExtendToMargin();
                categoryExtendToStartMargin = !categoryStartOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToStartMargin() != false);
                categoryExtendToEndMargin = !categoryEndOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToEndMargin() != false);
                this.xStart = Math.min(b.width, categoryStart);
                if (categoryExtendToStartMargin) {
                    this.xStart = margin.width;
                }
                this.xEnd = categoryEnd;
                if (categoryExtendToEndMargin) {
                    this.xEnd = margin.width;
                }
                responseStartOffset = (bl = validResponseAxisModel.getStartOffset()) != null;
                responseStart = responseStartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = validResponseAxisModel.getEndOffset();
                responseEndOffset = bl != null;
                responseEnd = responseEndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                responseExtendToMargins = validResponseAxisCellModel.getExtendToMargin();
                responseExtendToStartMargin = !responseStartOffset && (responseExtendToMargins || validResponseAxisCellModel.getExtendToStartMargin() != false);
                responseExtendToEndMargin = !responseEndOffset && (responseExtendToMargins || validResponseAxisCellModel.getExtendToEndMargin() != false);
                this.yStart = Math.min(b.height, responseStart);
                if (responseExtendToStartMargin) {
                    this.yStart = margin.height;
                }
                this.yEnd = responseEnd;
                if (responseExtendToEndMargin) {
                    this.yEnd = margin.height;
                }
                this.xAxisLength = categoryAxisLength;
                this.yAxisLength = responseAxisLength;
                if (response2AxisLength != 0.0) {
                    bl = this.barLineChartModel.getResponse2AxisModel().getStartOffset();
                    response2StartOffset = bl != null;
                    y2Start = response2StartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                    bl = this.barLineChartModel.getResponse2AxisModel().getEndOffset();
                    response2EndOffset = bl != null;
                    int y2End = response2EndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                    response2ExtendToMargins = response2AxisCellModel.getExtendToMargin();
                    response2ExtendToStartMargin = !response2StartOffset && (response2ExtendToMargins || response2AxisCellModel.getExtendToStartMargin() != false);
                    boolean bl2 = response2ExtendToEndMargin = !response2EndOffset && (response2ExtendToMargins || response2AxisCellModel.getExtendToEndMargin() != false);
                    if (response2ExtendToStartMargin) {
                        y2Start = margin.height;
                    }
                    if (response2ExtendToEndMargin) {
                        y2End = margin.height;
                    }
                    if ((delta = response2AxisLength + (double)y2Start + (double)y2End - (responseAxisLength + (double)this.yStart + (double)this.yEnd)) > 0.0) {
                        this.yAxisLength += delta;
                    }
                    response2Offset = -this.yStart + y2Start;
                }
            } else {
                bl = categoryAxisModel.getStartOffset();
                categoryStartOffset = bl != null;
                categoryStart = categoryStartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = categoryAxisModel.getEndOffset();
                categoryEndOffset = bl != null;
                categoryEnd = categoryEndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                categoryExtendToMargins = this.categoryAxisCellModel.getExtendToMargin();
                categoryExtendToStartMargin = !categoryStartOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToStartMargin() != false);
                categoryExtendToEndMargin = !categoryEndOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToEndMargin() != false);
                this.yStart = Math.min(categoryStart, b.height);
                if (categoryExtendToStartMargin) {
                    this.yStart = margin.height;
                }
                this.yEnd = categoryEnd;
                if (categoryExtendToEndMargin) {
                    this.yEnd = margin.height;
                }
                responseStartOffset = (bl = validResponseAxisModel.getStartOffset()) != null;
                responseStart = responseStartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = validResponseAxisModel.getEndOffset();
                responseEndOffset = bl != null;
                responseEnd = responseEndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                responseExtendToMargins = validResponseAxisCellModel.getExtendToMargin();
                responseExtendToStartMargin = !responseStartOffset && (responseExtendToMargins || validResponseAxisCellModel.getExtendToStartMargin() != false);
                responseExtendToEndMargin = !responseEndOffset && (responseExtendToMargins || validResponseAxisCellModel.getExtendToEndMargin() != false);
                this.xStart = Math.min(responseStart, b.width);
                if (responseExtendToStartMargin) {
                    this.xStart = margin.width;
                }
                this.xEnd = responseEnd;
                if (responseExtendToEndMargin) {
                    this.xEnd = margin.width;
                }
                this.yAxisLength = categoryAxisLength;
                this.xAxisLength = responseAxisLength;
                if (response2AxisLength != 0.0) {
                    bl = this.barLineChartModel.getResponse2AxisModel().getStartOffset();
                    response2StartOffset = bl != null;
                    x2Start = response2StartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                    bl = this.barLineChartModel.getResponse2AxisModel().getEndOffset();
                    response2EndOffset = bl != null;
                    int x2End = response2EndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                    response2ExtendToMargins = response2AxisCellModel.getExtendToMargin();
                    response2ExtendToStartMargin = !response2StartOffset && (response2ExtendToMargins || response2AxisCellModel.getExtendToStartMargin() != false);
                    boolean bl3 = response2ExtendToEndMargin = !response2EndOffset && (response2ExtendToMargins || response2AxisCellModel.getExtendToEndMargin() != false);
                    if (response2ExtendToStartMargin) {
                        x2Start = margin.width;
                    }
                    if (response2ExtendToEndMargin) {
                        x2End = margin.width;
                    }
                    if ((delta = response2AxisLength + (double)x2Start + (double)x2End - (responseAxisLength + (double)this.xStart + (double)this.xEnd)) > 0.0) {
                        this.xAxisLength += delta + 1.0;
                    }
                    response2Offset = -this.xStart + x2Start;
                }
            }
            this.z = 0.0;
            if (is3D) {
                if (this.variables.response2Axis.getLineVariableCount() > 0 || this.barLineChartModel.isWaterfallEnabled() || this.barLineChartModel.getBarShape() != 10300) {
                    this.allowAntiAliasing = true;
                }
                this.updateChannel();
            }
            boolean linesOnBackWall = this.variables.getTotalBarVariableCount() > 0 && this.barLineChartModel.isFillAreaEnabled();
            ContinuousRangeToNumericMapper responseAxisMapper = (ContinuousRangeToNumericMapper)(responseAxisCellModel != null ? responseAxisCellModel.getMapper() : null);
            ContinuousRangeToNumericMapper response2AxisMapper = (ContinuousRangeToNumericMapper)(response2AxisCellModel != null ? response2AxisCellModel.getMapper() : null);
            if (response2Offset != 0) {
                ContinuousRangeToNumericMapper mapper = new ContinuousRangeToNumericMapper();
                mapper.setInputMin(response2AxisMapper.getInputMin());
                mapper.setInputMax(response2AxisMapper.getInputMax());
                mapper.setOutputMin(response2AxisMapper.getOutputMin());
                mapper.setOutputMax(response2AxisMapper.getOutputMax());
                mapper.setOffset(response2Offset);
                response2AxisMapper = mapper;
            }
            double responseAxisBaselinePosition = this.barLineChartModel.getResponseAxisBaselineModel().getPosition();
            double response2AxisBaselinePosition = this.barLineChartModel.getResponse2AxisBaselineModel().getPosition();
            if (responseAxisMapper != null && (Double.isNaN(responseAxisBaselinePosition) || Double.isInfinite(responseAxisBaselinePosition))) {
                double min = responseAxisMapper.getInputMin();
                double max = responseAxisMapper.getInputMax();
                if (min < 0.0 && max > 0.0) {
                    responseAxisBaselinePosition = 0.0;
                } else {
                    double d2 = responseAxisBaselinePosition = Math.abs(min) < Math.abs(max) ? min : max;
                }
            }
            if (response2AxisMapper != null && (Double.isNaN(response2AxisBaselinePosition) || Double.isInfinite(response2AxisBaselinePosition))) {
                double min = response2AxisMapper.getInputMin();
                double max = response2AxisMapper.getInputMax();
                response2AxisBaselinePosition = min < 0.0 && max > 0.0 ? 0.0 : (Math.abs(min) < Math.abs(max) ? min : max);
            }
            ContinuousRangeToNumericMapper responseAxisBaselineMapper = null;
            ContinuousRangeToNumericMapper response2AxisBaselineMapper = null;
            int categoryAxisTitleHeight = this.categoryAxisCellModel.getTitleHeight().intValue();
            int categoryAxisTitleWidth = this.categoryAxisCellModel.getTitleWidth().intValue();
            BoundingBox graphAreaClippingBox = new BoundingBox();
            if (graphAreaClippingBox != null) {
                if (this.isVerticalOrientation) {
                    double w = b.width - categoryAxisTitleWidth;
                    double h = is3D ? this.yAxisLength + (double)this.yStart + (double)this.yEnd + (double)depth.height : this.yAxisLength + (double)this.yStart + (double)this.yEnd;
                    double x = w / 2.0 - (double)this.xStart;
                    double y = is3D ? (double)(-this.yStart) + h / 2.0 - (double)depth.height / 2.0 : (double)(-this.yStart) + h / 2.0;
                    graphAreaClippingBox.setCenter(x, y, 0.0);
                    graphAreaClippingBox.setSize(w, h, 0.0);
                } else {
                    double w = Math.min((double)b.width, is3D ? this.xAxisLength + (double)this.xStart + (double)this.xEnd + (double)depth.width : this.xAxisLength + (double)this.xStart + (double)this.xEnd);
                    double h = b.height - categoryAxisTitleHeight;
                    double x = is3D ? (double)(-this.xStart) + w / 2.0 - (double)depth.width / 2.0 : (double)(-this.xStart) + w / 2.0;
                    double y = h / 2.0 - (double)this.yStart;
                    graphAreaClippingBox.setCenter(x, y, 0.0);
                    graphAreaClippingBox.setSize(w, h, 0.0);
                }
            }
            composites.dataLabelComposite = this._composite(null);
            if (is3D) {
                composites.dataLabelComposite.transform.translateZ.setValue(-this.z / 2.0);
            }
            if (graphAreaClippingBox != null) {
                composites.dataLabelComposite.setClipBounds(graphAreaClippingBox);
            }
            if (this.variables.getTotalBarVariableCount() > 0 && this.variables.categoryVariable.getValueCount() > 0) {
                composites.barComposite = this._composite(null);
                if (is3D) {
                    composites.barComposite.transform.translateZ.setValue(-this.z / 2.0);
                }
                if (graphAreaClippingBox != null) {
                    composites.barComposite.setClipBounds(graphAreaClippingBox);
                }
                if (this.stackBarsEnabled && this.variables.subgroupVariable != null) {
                    double barElementWidth = this.totalBarWidth / (double)this.variables.getTotalBarVariableCount();
                    double barElementPositionTranslation = -((double)(this.variables.getTotalBarVariableCount() - 1) * barElementWidth / 2.0);
                    ArrayList barElements = new ArrayList();
                    ArrayList bar2Elements = new ArrayList();
                    if (this.variables.responseAxis.getBarVariableCount() > 0) {
                        responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addStackedSubgroupedBars(composites, this.cellModel, this.variables, this.variables.responseAxis, barElementPositionTranslation, this.isVerticalOrientation ? 0 : this.variables.response2Axis.getBarVariableCount(), barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, 0.0, is3D, this.z, barElements);
                    }
                    if (this.variables.response2Axis.getBarVariableCount() > 0) {
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        response2AxisBaselineMapper.setOffset(response2Offset);
                        BarLineChartUtil.addStackedSubgroupedBars(composites, this.cellModel, this.variables, this.variables.response2Axis, barElementPositionTranslation, this.isVerticalOrientation ? this.variables.responseAxis.getBarVariableCount() : 0, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, 0.0, is3D, this.z, bar2Elements);
                    }
                    ArrayList elements = this.isVerticalOrientation ? barElements : bar2Elements;
                    elements.addAll(this.isVerticalOrientation ? bar2Elements : barElements);
                    for (int ii = 0; ii < elements.size(); ++ii) {
                        Bar nextBar = (Bar)elements.get(ii);
                        if (nextBar == null) continue;
                        composites.barComposite.addElement((Element)nextBar);
                    }
                } else if (this.stackBarsEnabled && (this.variables.responseAxis.getBarVariableCount() > 1 || this.variables.response2Axis.getBarVariableCount() > 1)) {
                    int barClusterPosition;
                    int multiResponseStackedBarElementCount = (this.variables.responseAxis.getBarVariableCount() > 0 ? 1 : 0) + (this.variables.response2Axis.getBarVariableCount() > 0 ? 1 : 0);
                    double barElementWidth = this.totalBarWidth / (double)multiResponseStackedBarElementCount;
                    double barElementPositionTranslation = -((double)(multiResponseStackedBarElementCount - 1) * barElementWidth / 2.0);
                    if (this.variables.responseAxis.getBarVariableCount() > 0) {
                        responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        barClusterPosition = this.isVerticalOrientation ? 0 : (this.variables.response2Axis.getBarVariableCount() > 0 ? 1 : 0);
                        BarLineChartUtil.addStackedMultipleResponseBars(composites, this.cellModel, this.variables, this.variables.responseAxis, 0, barElementPositionTranslation, barClusterPosition, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, is3D, this.z);
                    }
                    if (this.variables.response2Axis.getBarVariableCount() > 0) {
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        response2AxisBaselineMapper.setOffset(response2Offset);
                        barClusterPosition = this.isVerticalOrientation ? (this.variables.responseAxis.getBarVariableCount() > 0 ? 1 : 0) : 0;
                        BarLineChartUtil.addStackedMultipleResponseBars(composites, this.cellModel, this.variables, this.variables.response2Axis, this.variables.responseAxis.getBarVariableCount(), barElementPositionTranslation, barClusterPosition, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, is3D, this.z);
                    }
                } else if (this.variables.subgroupVariable != null) {
                    int globalMaxBarsPerCategory = this.cellModel.getMaxBarsPerCategory();
                    double barElementWidth = this.totalBarWidth / (double)globalMaxBarsPerCategory;
                    if (this.variables.responseAxis.getBarVariableCount() > 0) {
                        responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addClusteredSubgroupedBars(composites, this.cellModel, this.variables, this.variables.responseAxis, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, responseAxisBaselinePosition, is3D, this.z, this.barLineChartModel.getResponseAxisLowerThreshold(), this.barLineChartModel.getResponseAxisUpperThreshold());
                    }
                    if (this.variables.response2Axis.getBarVariableCount() > 0) {
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        response2AxisBaselineMapper.setOffset(response2Offset);
                        BarLineChartUtil.addClusteredSubgroupedBars(composites, this.cellModel, this.variables, this.variables.response2Axis, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, response2AxisBaselinePosition, is3D, this.z, this.barLineChartModel.getResponse2AxisLowerThreshold(), this.barLineChartModel.getResponse2AxisUpperThreshold());
                    }
                } else {
                    int[] nArray;
                    double barElementWidth = this.totalBarWidth / (double)this.variables.getTotalBarVariableCount();
                    double barElementPositionTranslation = -((double)(this.variables.getTotalBarVariableCount() - 1) * barElementWidth / 2.0);
                    double waterfallLineXDist = categoryAxisStride - barElementWidth;
                    ArrayList barElements = new ArrayList();
                    ArrayList bar2Elements = new ArrayList();
                    if (this.barLineChartModel.isWaterfallEnabled() && this.variables.getTotalBarVariableCount() > 1) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = 1;
                        nArray = nArray2;
                        nArray2[1] = 2;
                    } else {
                        int[] nArray3 = new int[1];
                        nArray = nArray3;
                        nArray3[0] = 0;
                    }
                    int[] variants = nArray;
                    for (int ii = 0; ii < variants.length; ++ii) {
                        if (this.variables.responseAxis.getBarVariableCount() > 0) {
                            responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                            BarLineChartUtil.addBars(composites, this.cellModel, this.variables, this.variables.responseAxis, 0, barElementPositionTranslation, this.isVerticalOrientation ? 0 : this.variables.response2Axis.getBarVariableCount(), this.initialBarHeight, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, responseAxisBaselinePosition, is3D, this.z, this.barLineChartModel.getResponseAxisLowerThreshold(), this.barLineChartModel.getResponseAxisUpperThreshold(), barElements, waterfallLineXDist, this.waterfallInitialBarID, this.waterfallFinalBarID, this.waterfallFinalResponseValues, this.waterfallFinalOutsideDataLabelValues, variants[ii], graphAreaClippingBox);
                        }
                        if (this.variables.response2Axis.getBarVariableCount() <= 0) continue;
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        response2AxisBaselineMapper.setOffset(response2Offset);
                        BarLineChartUtil.addBars(composites, this.cellModel, this.variables, this.variables.response2Axis, this.variables.responseAxis.getBarVariableCount(), barElementPositionTranslation, this.isVerticalOrientation ? this.variables.responseAxis.getBarVariableCount() : 0, this.initialBarHeight, barElementWidth, this.insideBarLabelTextStyle, this.outsideBarLabelTextStyle, this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, response2AxisBaselinePosition, is3D, this.z, this.barLineChartModel.getResponse2AxisLowerThreshold(), this.barLineChartModel.getResponse2AxisUpperThreshold(), bar2Elements, waterfallLineXDist, this.waterfallInitialBarID, this.waterfallFinalBarID, this.waterfallFinalResponseValues, this.waterfallFinalOutsideDataLabelValues, variants[ii], graphAreaClippingBox);
                    }
                    ArrayList elements = this.isVerticalOrientation ? barElements : bar2Elements;
                    elements.addAll(this.isVerticalOrientation ? bar2Elements : barElements);
                    for (int ii = 0; ii < elements.size(); ++ii) {
                        Bar nextBar = (Bar)elements.get(ii);
                        if (nextBar == null) continue;
                        composites.barComposite.addElement((Element)nextBar);
                    }
                }
            }
            if (this.variables.getTotalLineVariableCount() > 0 && this.variables.categoryVariable.getValueCount() > 0) {
                composites.lineComposite = this._composite(null);
                composites.markerComposite = this._composite(null);
                if (graphAreaClippingBox != null) {
                    composites.lineComposite.setClipBounds(graphAreaClippingBox);
                    composites.markerComposite.setClipBounds(graphAreaClippingBox);
                }
                if (this.variables.subgroupVariable != null) {
                    if (this.variables.responseAxis.getLineVariableCount() > 0) {
                        responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addSubgroupedLines(composites, this.dataSource, this.cellModel, this.variables, this.variables.responseAxis, 0, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, responseAxisBaselinePosition, linesOnBackWall, this.z);
                    }
                    if (this.variables.response2Axis.getLineVariableCount() > 0) {
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addSubgroupedLines(composites, this.dataSource, this.cellModel, this.variables, this.variables.response2Axis, this.variables.responseAxis.getLineVariableCount(), this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, response2AxisBaselinePosition, linesOnBackWall, this.z);
                    }
                } else {
                    if (this.variables.responseAxis.getLineVariableCount() > 0) {
                        responseAxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addLines(composites, this.dataSource, this.cellModel, this.variables, this.variables.responseAxis, 0, this.categoryAxisMapper, responseAxisMapper, responseAxisBaselineMapper, responseAxisBaselinePosition, linesOnBackWall, this.z);
                    }
                    if (this.variables.response2Axis.getLineVariableCount() > 0) {
                        response2AxisBaselineMapper = new ContinuousRangeToNumericMapper();
                        BarLineChartUtil.addLines(composites, this.dataSource, this.cellModel, this.variables, this.variables.response2Axis, this.variables.responseAxis.getLineVariableCount(), this.categoryAxisMapper, response2AxisMapper, response2AxisBaselineMapper, response2AxisBaselinePosition, linesOnBackWall, this.z);
                    }
                }
            }
            BarLineChartUtil.addAxisWall(this.getChannel(), composites, this.variables, this.variables.responseAxis, this.dataSource, this.getRow(), this.getColumn(), this.categoryAxisMapper, is3D, this.xAxisLength, this.xStart, this.xEnd, this.yAxisLength, this.yStart, this.yEnd, this.cellModel, responseAxisCellModel, response2AxisCellModel, this.categoryAxisCellModel, categoryAxisTitleWidth, categoryAxisTitleHeight, this.z, b, graphAreaClippingBox);
            BarLineChartUtil.addResponseReferenceLines(this.getChannel(), composites, this.cellModel, this.dataSource, this.getRow(), this.getColumn(), this.xStart, this.xEnd, this.yStart, this.yEnd, this.yAxisLength, this.xAxisLength, this.z);
            StrokeLineStyle refLineStyle = this.barLineChartModel.getResponseAxisBaselineModel().getLineStyle();
            if (refLineStyle == null) {
                refLineStyle = this.barLineChartModel.getResponseAxisModel().getAxisLineStyle();
            }
            boolean bl4 = attemptToAddBaselineElement = refLineStyle.getVisibilityPolicy() == 10201;
            if (refLineStyle.getVisibilityPolicy() == 10200) {
                boolean bl5 = attemptToAddBaselineElement = this.variables.responseAxis.getLineVariableCount() > 0 && this.barLineChartModel.isFillAreaEnabled() || this.variables.responseAxis.getBarVariableCount() > 0;
            }
            if (attemptToAddBaselineElement && refLineStyle.getThickness().getMagnitude((Object)"px") > 0.0) {
                BarLineChartUtil.addBaseLineElements(composites, this.cellModel, responseAxisBaselineMapper, this.barLineChartModel.getResponseAxisBaselineModel(), refLineStyle, this.xStart, this.xEnd, this.yStart, this.yEnd, this.yAxisLength, this.xAxisLength);
            }
            if ((refLineStyle = this.barLineChartModel.getResponse2AxisBaselineModel().getLineStyle()) == null) {
                refLineStyle = this.barLineChartModel.getResponse2AxisModel().getAxisLineStyle();
            }
            boolean bl6 = attemptToAddBaselineElement = refLineStyle.getVisibilityPolicy() == 10201;
            if (refLineStyle.getVisibilityPolicy() == 10200) {
                boolean bl7 = attemptToAddBaselineElement = this.variables.response2Axis.getLineVariableCount() > 0 && this.barLineChartModel.isFillAreaEnabled() || this.variables.response2Axis.getBarVariableCount() > 0;
            }
            if (attemptToAddBaselineElement && refLineStyle.getThickness().getMagnitude((Object)"px") > 0.0) {
                BarLineChartUtil.addBaseLineElements(composites, this.cellModel, response2AxisBaselineMapper, this.barLineChartModel.getResponse2AxisBaselineModel(), refLineStyle, this.xStart, this.xEnd, this.yStart, this.yEnd, this.yAxisLength, this.xAxisLength);
            }
            if (!this.isCategoryAxisIntegrated && categoryAxisModel.isVisible()) {
                int placement = this.categoryAxisCellModel.getTitlePlacementType();
                RectangularAxis gtkCategoryAxis = this.categoryAxisCellModel.getGTKAxis(this.categoryAxisMapper);
                Util.SelectInfo.selectEnable((Element)gtkCategoryAxis, 4);
                if (this.isVerticalOrientation) {
                    gtkCategoryAxis.transform.translateY.setValue((double)(-this.yStart));
                } else {
                    gtkCategoryAxis.transform.translateX.setValue((double)(-this.xStart));
                }
                AxisStyle gtkAxisStyle = gtkCategoryAxis.getStyle();
                gtkAxisStyle.setMinorTickMarksOn(false);
                if (categoryAxisModel.isDrillIconVisible()) {
                    int titleMarkerID = this.getChannel().addCustomMarker((CustomMarkerInterface)this.cellModel.getCategoryAxisCellModel().getTitleMarker());
                    gtkAxisStyle.setTitleMarkerVisible(true);
                    gtkAxisStyle.setTitleMarkerId(titleMarkerID);
                    gtkAxisStyle.setTitleMarkerSize(this.cellModel.getCategoryAxisCellModel().getTitleMarker().getSize());
                }
                gtkCategoryAxis.labels.connectFrom(this.categoryAxisMapper.label);
                gtkCategoryAxis.labelOffset.connectFrom(this.categoryAxisMapper.uniqueValue);
                gtkCategoryAxis.labelColor.setValue(categoryAxisModel.getValueTextStyle().getColor());
                if (gtkAxisStyle.isTitleOn()) {
                    int maxRow = this.cellModel.getMaxRow();
                    int maxColumn = this.cellModel.getMaxColumn();
                    if (this.isVerticalOrientation) {
                        if (maxColumn == this.getColumn() && maxRow == this.getRow()) {
                            if (maxColumn > 0) {
                                gtkCategoryAxis.title.setValue(this.categoryAxisCellModel.getTitle());
                                gtkCategoryAxis.setTitlePosition(2);
                                gtkAxisStyle.getTitleStyle().setHorizontalJustification(2);
                            } else {
                                gtkCategoryAxis.title.setValue(this.categoryAxisCellModel.getTitle());
                            }
                        } else {
                            gtkCategoryAxis.title.setValue(null);
                        }
                    } else if (0 == maxColumn + maxRow) {
                        gtkCategoryAxis.title.setValue(this.categoryAxisCellModel.getTitle());
                    } else {
                        gtkCategoryAxis.title.setValue(null);
                    }
                }
                composites.categoryAxisComposite = this._composite(composites.categoryAxisComposite);
                composites.categoryAxisComposite.addElement((Element)gtkCategoryAxis);
                gtkAxisStyle.setAxisLineOn(false);
                if (categoryAxisModel.getAxisLineStyle().getVisibilityPolicy() != 10202) {
                    double length;
                    int lineThickness = (int)categoryAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
                    gtkAxisStyle.setAxisLineOn(lineThickness > 0);
                    if (this.isVerticalOrientation) {
                        length = this.xAxisLength + (double)this.xStart - (double)(-this.xEnd);
                        gtkCategoryAxis.setLength(length);
                        gtkCategoryAxis.setLineOffset((double)(-this.xStart - (this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0 ? 1 : 0)));
                    } else {
                        length = this.yAxisLength + (double)this.yStart - 2.0 - (double)(-this.yEnd - 2);
                        gtkCategoryAxis.setLength(length);
                        gtkCategoryAxis.setLineOffset((double)(-this.yStart - 2));
                    }
                    gtkAxisStyle.setAxisLineColor(categoryAxisModel.getAxisLineStyle().getColor());
                    gtkAxisStyle.setLineWidth((int)categoryAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px"));
                }
                if (placement != 11306) {
                    String title = this.categoryAxisCellModel.getTitle();
                    TextStyle labelStyle = categoryAxisModel.getLabelTextStyle();
                    RasterLabel titleLabel = null;
                    if (this.isVerticalOrientation) {
                        titleLabel = placement == 11302 ? BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{categoryAxisLength + (double)this.xEnd + 3.0, -this.yStart - 2}, labelStyle, 2, 1) : (placement == 11303 ? BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{categoryAxisLength + (double)this.xEnd + 3.0, -this.yStart}, labelStyle, 2, 0) : BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{categoryAxisLength + (double)this.xEnd + 3.0, -this.yStart + 2}, labelStyle, 2, 3));
                        Util.SelectInfo.selectEnable((Element)titleLabel, 4, "X");
                    } else {
                        titleLabel = placement == 11302 ? BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{-this.xStart - 2, categoryAxisLength + (double)this.yEnd + 1.0, -this.z}, labelStyle, 4, 3) : (placement == 11303 ? (this.categoryAxisCellModel.getTitleBreak() == null ? BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{-this.xStart, categoryAxisLength + (double)this.yEnd + 1.0, -this.z}, labelStyle, 4, 3) : BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{-this.xStart - this.yAxisAdj + 2, categoryAxisLength + (double)this.yEnd + 1.0, -this.z}, labelStyle, 2, 3)) : BarLineChartUtil.addALabel(composites.categoryAxisComposite, title, new double[]{-this.xStart + 2, categoryAxisLength + (double)this.yEnd + 1.0, -this.z}, labelStyle, 2, 3));
                        Util.SelectInfo.selectEnable((Element)titleLabel, 4, "Y");
                    }
                }
            } else if (this.isCategoryAxisIntegrated && categoryAxisModel.isVisible()) {
                LineSegment falseCategoryAxisLine = new LineSegment();
                falseCategoryAxisLine.selectEnabled.setValue(false);
                falseCategoryAxisLine.disableAntialiasingForHorizontalOrVerticalLines.setValue(true);
                if (this.isVerticalOrientation) {
                    falseCategoryAxisLine.beginX.setValue((double)(-this.xStart - 2));
                    falseCategoryAxisLine.endX.setValue(this.xAxisLength + (double)this.xEnd - 1.0);
                    falseCategoryAxisLine.beginY.setValue((double)(-this.yStart));
                    falseCategoryAxisLine.endY.setValue((double)(-this.yStart));
                } else {
                    falseCategoryAxisLine.beginY.setValue((double)(-this.yStart - 2));
                    falseCategoryAxisLine.endY.setValue(this.yAxisLength + (double)this.yEnd - 1.0);
                    falseCategoryAxisLine.beginX.setValue((double)(-this.xStart));
                    falseCategoryAxisLine.endX.setValue((double)(-this.xStart));
                }
                falseCategoryAxisLine.color.setValue(categoryAxisModel.getAxisLineStyle().getColor());
                falseCategoryAxisLine.lineWidth.setValue(categoryAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px"));
                composites.categoryAxisComposite = this._composite(composites.categoryAxisComposite);
                composites.categoryAxisComposite.addElement((Element)falseCategoryAxisLine);
            }
            if (this.isVerticalOrientation) {
                this.getComposite().transform.translateY.setValue((double)(this.xAxisAdj + this.yStart));
                this.getComposite().transform.translateX.setValue((double)this.xStart);
            } else {
                this.getComposite().transform.translateX.setValue((double)(this.yAxisAdj + this.xStart));
                this.getComposite().transform.translateY.setValue((double)this.yStart);
            }
            if (this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0) {
                double tx = 0.0;
                double ty = 0.0;
                if (this.isVerticalOrientation) {
                    tx = -1.0;
                    composites.markerComposite = BarLineChartUtil.translate(composites.markerComposite, tx, ty);
                    composites.lineComposite = BarLineChartUtil.translate(composites.lineComposite, tx, ty);
                    composites.barComposite = BarLineChartUtil.translate(composites.barComposite, tx, ty);
                    composites.waterfallComposite = BarLineChartUtil.translate(composites.waterfallComposite, tx, ty);
                    composites.categoryAxisComposite = BarLineChartUtil.translate(composites.categoryAxisComposite, tx, ty);
                    composites.gridLinesBackWallComposite = BarLineChartUtil.translate(composites.gridLinesBackWallComposite, tx, ty);
                    composites.gridLinesFrontWallComposite = BarLineChartUtil.translate(composites.gridLinesFrontWallComposite, tx, ty);
                }
            }
            NetworkRoot networkRoot = this.getNetworkRoot();
            networkRoot.removeAllElements();
            networkRoot.addElement((Element)composites.axisWallComposite);
            networkRoot.addElement((Element)composites.gridLinesBackWallComposite);
            networkRoot.addElement((Element)composites.responseReferenceLinesBackComposite);
            networkRoot.addElement((Element)composites.categoryReferenceLinesBackComposite);
            if (this.barLineChartModel.isFillAreaEnabled()) {
                networkRoot.addElement((Element)composites.lineComposite);
                networkRoot.addElement((Element)composites.markerComposite);
                networkRoot.addElement((Element)composites.barComposite);
                networkRoot.addElement((Element)composites.waterfallComposite);
            } else {
                networkRoot.addElement((Element)composites.barComposite);
                networkRoot.addElement((Element)composites.waterfallComposite);
                networkRoot.addElement((Element)composites.lineComposite);
                networkRoot.addElement((Element)composites.markerComposite);
            }
            networkRoot.addElement((Element)composites.gridLinesFrontWallComposite);
            networkRoot.addElement((Element)composites.responseReferenceLinesFrontComposite);
            networkRoot.addElement((Element)composites.categoryReferenceLinesFrontComposite);
            networkRoot.addElement((Element)composites.frameComposite);
            networkRoot.addElement((Element)composites.categoryAxisComposite);
            networkRoot.addElement((Element)composites.dataLabelComposite);
            if (composites.lineComposite != null || composites.waterfallComposite != null) {
                this.allowAntiAliasing = true;
            }
        }
    }

    private Composite _composite(Composite c) {
        return BarLineChartUtil.composite(this.getComposite(), c);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize != null) {
            return this.cachedPreferredSize;
        }
        this.cachedPreferredSize = this._getPreferredSize();
        return this.cachedPreferredSize == null ? super.getPreferredSize() : this.cachedPreferredSize;
    }

    private Dimension _getPreferredSize() {
        AxisCellModel responseAxisCellModel = this.cellModel.getResponseAxisCellModel();
        AxisCellModel response2AxisCellModel = this.cellModel.getResponse2AxisCellModel();
        if (this.variables.categoryVariable != null && this.categoryAxisCellModel != null && (responseAxisCellModel != null || response2AxisCellModel != null)) {
            int numMargins;
            boolean extendToEndMargin;
            boolean extendToStartMargin;
            boolean extendToMargins;
            int end;
            boolean endOffset;
            int start;
            int titleResponseAdj2;
            int titleResponseAdj;
            int titleCategoryAdj;
            int margin2;
            int margin;
            int axisAdj;
            int h = 0;
            int h2 = 0;
            Rectangle bounds = this.getBounds();
            if (this.isVerticalOrientation) {
                axisAdj = this.categoryAxisCellModel.getCatAxisAdj().intValue();
                int n = margin = responseAxisCellModel != null ? responseAxisCellModel.getMargin().height : 0;
                if (margin == 0 && bounds.width == 0 && bounds.height == 0) {
                    margin = responseAxisCellModel != null ? responseAxisCellModel.getPreferredMargin().height : 0;
                }
                int n2 = margin2 = response2AxisCellModel != null ? response2AxisCellModel.getMargin().height : 0;
                if (margin2 == 0 && bounds.width == 0 && bounds.height == 0) {
                    margin2 = response2AxisCellModel != null ? response2AxisCellModel.getPreferredMargin().height : 0;
                }
                titleCategoryAdj = this.categoryAxisCellModel.getTitleWidth().intValue();
                titleResponseAdj = responseAxisCellModel != null ? responseAxisCellModel.getTitleHeight().intValue() : 0;
                titleResponseAdj2 = response2AxisCellModel != null ? response2AxisCellModel.getTitleHeight().intValue() : 0;
            } else {
                int maxRow = this.cellModel.getMaxRow();
                int maxColumn = this.cellModel.getMaxColumn();
                RectangularAxis gtkAxis = this.categoryAxisCellModel.getGTKAxis(this.categoryAxisMapper);
                if (maxRow + maxColumn > 0 && gtkAxis != null && gtkAxis.getStyle().isTitleOn()) {
                    int col = this.getColumn();
                    int row = this.getRow();
                    this.categoryAxisCellModel.setComputeTitleHeightEnabled(false);
                    this.categoryAxisCellModel.setComputeTitleWidthEnabled(false);
                    this.categoryAxisCellModel.setTitleBreak(null);
                    this.getChannel().glSelect2DFont(this.categoryAxisCellModel.getAxisModel().getLabelTextStyle().getFont());
                    int titleHeight = (int)(this.getChannel().glGetTextHeight(this.categoryAxisCellModel.getTitle()) + 4.0);
                    int titleWidth = (int)(this.getChannel().glGetTextWidth(this.categoryAxisCellModel.getTitle()) / 2.0 + 4.0);
                    this.categoryAxisCellModel.getGTKAxis(this.categoryAxisMapper).getStyle().setTitleOn(false);
                    this.categoryAxisCellModel.setTitleWidth(new Double(titleWidth));
                    if (0 == col && 0 == row) {
                        this.categoryAxisCellModel.setTitleHeight(new Double(titleHeight));
                        this.categoryAxisCellModel.setTitlePlacementType(11303);
                    } else {
                        this.categoryAxisCellModel.setTitleOn(Boolean.FALSE);
                        if (0 == row) {
                            this.categoryAxisCellModel.setTitleHeight(new Double(titleHeight));
                            this.categoryAxisCellModel.setTitleWidth(new Double(0.0));
                        } else if (0 == col) {
                            this.categoryAxisCellModel.setTitleHeight(new Double(0.0));
                            this.categoryAxisCellModel.setTitleWidth(new Double(titleWidth));
                        } else {
                            this.categoryAxisCellModel.setTitleHeight(new Double(0.0));
                            this.categoryAxisCellModel.setTitleWidth(new Double(0.0));
                        }
                    }
                }
                axisAdj = this.categoryAxisCellModel.getResAxisAdj().intValue();
                int n = margin = responseAxisCellModel != null ? responseAxisCellModel.getMargin().width : 0;
                if (margin == 0 && bounds.width == 0 && bounds.height == 0) {
                    margin = responseAxisCellModel != null ? responseAxisCellModel.getPreferredMargin().width : 0;
                }
                int n3 = margin2 = response2AxisCellModel != null ? response2AxisCellModel.getMargin().width : 0;
                if (margin2 == 0 && bounds.width == 0 && bounds.height == 0) {
                    margin2 = response2AxisCellModel != null ? response2AxisCellModel.getPreferredMargin().width : 0;
                }
                titleCategoryAdj = this.categoryAxisCellModel.getTitleHeight().intValue();
                titleResponseAdj = responseAxisCellModel != null ? responseAxisCellModel.getTitleWidth().intValue() : 0;
                int n4 = titleResponseAdj2 = response2AxisCellModel != null ? response2AxisCellModel.getTitleWidth().intValue() : 0;
            }
            if (responseAxisCellModel != null) {
                AxisModel axisModel = this.barLineChartModel.getResponseAxisModel();
                BaseLength bl = axisModel.getStartOffset();
                boolean startOffset = bl != null;
                start = startOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = axisModel.getEndOffset();
                endOffset = bl != null;
                end = endOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                extendToMargins = responseAxisCellModel.getExtendToMargin();
                extendToStartMargin = !startOffset && (extendToMargins || responseAxisCellModel.getExtendToStartMargin() != false);
                extendToEndMargin = !endOffset && (extendToMargins || responseAxisCellModel.getExtendToEndMargin() != false);
                int n = numMargins = extendToEndMargin ? 1 : 0;
                if (extendToStartMargin) {
                    ++numMargins;
                }
                h = responseAxisCellModel.getIdealPreferredLength().intValue() + numMargins * margin + start + end + axisAdj + titleResponseAdj;
            }
            if (response2AxisCellModel != null) {
                AxisModel axisModel = this.barLineChartModel.getResponse2AxisModel();
                BaseLength bl = axisModel.getStartOffset();
                boolean startOffset = bl != null;
                start = startOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                bl = axisModel.getEndOffset();
                endOffset = bl != null;
                end = endOffset ? (int)bl.getMagnitude((Object)"px") : 0;
                extendToMargins = response2AxisCellModel.getExtendToMargin();
                extendToStartMargin = !startOffset && (extendToMargins || response2AxisCellModel.getExtendToStartMargin() != false);
                extendToEndMargin = !endOffset && (extendToMargins || response2AxisCellModel.getExtendToEndMargin() != false);
                int n = numMargins = extendToEndMargin ? 1 : 0;
                if (extendToStartMargin) {
                    ++numMargins;
                }
                h2 = response2AxisCellModel.getIdealPreferredLength().intValue() + numMargins * margin2 + start + end + axisAdj + titleResponseAdj2;
            }
            h = Math.max(h, h2);
            int barWidth = (int)(this.barLineChartModel.getBarWidth().getMagnitude((Object)"px") + this.barLineChartModel.getBarWidthSpace().getMagnitude((Object)"px"));
            int stride = Math.max(barWidth, this.maxPreferredCategoryAxisStride);
            AxisModel categoryAxisModel = this.barLineChartModel.getCategoryAxisModel();
            BaseLength bl = categoryAxisModel.getStartOffset();
            boolean categoryStartOffset = bl != null;
            int categoryStart = categoryStartOffset ? (int)bl.getMagnitude((Object)"px") : 0;
            bl = categoryAxisModel.getEndOffset();
            boolean categoryEndOffset = bl != null;
            int categoryEnd = categoryEndOffset ? (int)bl.getMagnitude((Object)"px") : 0;
            boolean categoryExtendToMargins = this.categoryAxisCellModel.getExtendToMargin();
            boolean categoryExtendToStartMargin = !categoryStartOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToStartMargin() != false);
            boolean categoryExtendToEndMargin = !categoryEndOffset && (categoryExtendToMargins || this.categoryAxisCellModel.getExtendToEndMargin() != false);
            int numMargins2 = (categoryExtendToStartMargin ? 1 : 0) + (categoryExtendToEndMargin ? 1 : 0);
            int w = stride * (this.categoryUniqueValueCount - 1) + Math.max(stride, numMargins2 * this.categoryAxisCellModel.getPreferredMargin().width + categoryStart + categoryEnd) + titleCategoryAdj;
            if (this.categoryUniqueValueCount > 0 && (responseAxisCellModel != null && responseAxisCellModel.getCellCount() == 1 || response2AxisCellModel != null && response2AxisCellModel.getCellCount() == 1)) {
                int x = Math.min(8, this.categoryUniqueValueCount);
                if (this.isVerticalOrientation) {
                    double categoryTickSpace = Math.min((double)x * ((double)w / (double)this.categoryUniqueValueCount), (double)BarLineChartUtil.MAX_PREFERRED_ADJUSTED_RESPONSE_AXIS);
                    h = Math.max((int)categoryTickSpace, h);
                } else {
                    double categoryTickSpace = Math.min((double)x * ((double)h / (double)this.categoryUniqueValueCount), (double)BarLineChartUtil.MAX_PREFERRED_ADJUSTED_RESPONSE_AXIS);
                    w = Math.max((int)categoryTickSpace, w);
                }
            }
            Dimension depth = this.categoryAxisCellModel.getDepth();
            if (this.isVerticalOrientation) {
                return new Dimension(w + depth.width, h + depth.height);
            }
            return new Dimension(h + depth.width, w + depth.height);
        }
        return null;
    }

    @Override
    public AlignableComponentConstraints getPreferredAlignableComponentConstraints(Dimension size) {
        if (this.cachedAlignableComponentConstraints != null) {
            return this.cachedAlignableComponentConstraints;
        }
        this.cachedAlignableComponentConstraints = this._getPreferredAlignableComponentConstraints(size);
        return this.cachedAlignableComponentConstraints;
    }

    public AlignableComponentConstraints _getPreferredAlignableComponentConstraints(Dimension size) {
        AlignableComponentConstraints constraints = new AlignableComponentConstraints();
        BarLineChartModel barLineChartModel = this.cellModel.getBarLineChartModel();
        Channel channel = this.getChannel();
        int top = 0;
        if (barLineChartModel.getOutsideBarLabelContent() == 10603 || barLineChartModel.getOutsideBarLabelContent() == 10602 || this.variables.outsideBarLabelVariableArray != null) {
            channel.glSelect2DFont(barLineChartModel.getOutsideBarLabelTextStyle().getFont());
            top = (int)Math.ceil(channel.glGetTextHeight());
        }
        if (barLineChartModel.getOutsideMarkerLabelContent() == 10603 || barLineChartModel.getOutsideMarkerLabelContent() == 10602 || this.variables.outsideMarkerLabelVariableArray != null) {
            channel.glSelect2DFont(barLineChartModel.getOutsideMarkerLabelTextStyle().getFont());
            top = Math.max(top, (int)Math.ceil(channel.glGetTextHeight()));
        }
        constraints.setInnerMargin(new Insets(top, 0, 0, 0));
        return constraints;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension depth = this.categoryAxisCellModel.getDepth();
        if (depth != null) {
            depth.height = 0;
            depth.width = 0;
        }
        super.setBounds(x, y, width, height);
        if (width == 0 || height == 0) {
            return;
        }
        double maxResAxisPercentage = 1.0;
        double maxCatAxisPercentage = 0.4;
        if (this.categoryAxisCellModel.getAxisModel().getValueFitPolicy() == 11603) {
            maxCatAxisPercentage = 0.3;
        }
        if (this.variables.categoryVariable != null && this.categoryAxisCellModel != null && (this.cellModel.getResponseAxisCellModel() != null || this.cellModel.getResponse2AxisCellModel() != null)) {
            Dimension margin = this.categoryAxisCellModel.getMargin();
            margin.width = 0;
            margin.height = 0;
            this._setCategoryAxisSizes(width, height, maxCatAxisPercentage);
            double stride = this._determineStride();
            this._setDepth(depth);
            Dimension resMargin = this._computeAxesParameters(maxCatAxisPercentage, maxResAxisPercentage, depth, width, height);
            this._adjustDataLabelFontSize(resMargin, maxCatAxisPercentage, maxResAxisPercentage, depth, width, height, stride);
            this.cachedPreferredSize = this._getPreferredSize();
            this.setPreferredSize(this.cachedPreferredSize);
        }
        this.updateChannel();
    }

    private double _determineStride() {
        double uvc;
        this.totalBarWidth = this.barLineChartModel.getBarWidth().getMagnitude((Object)"px");
        double totalBarWidthMargin = this.barLineChartModel.getBarWidthSpace().getMagnitude((Object)"px");
        double barPercentage = this.totalBarWidth / (this.totalBarWidth + totalBarWidthMargin);
        double totalCategoryWidth = 0.0;
        double stride = Math.abs(this.categoryAxisMapper.getStrideValue());
        if (stride == 0.0 && (uvc = (double)this.variables.categoryVariable.getUniqueValueCount()) > 0.0) {
            stride = this.isVerticalOrientation ? (double)(this.getWidth() - this.categoryAxisCellModel.getTitleWidth().intValue()) / (uvc + (double)(this.categoryAxisCellModel.getDepth().width > 0 ? 1 : 0)) : (double)(this.getHeight() - this.categoryAxisCellModel.getTitleHeight().intValue()) / (uvc + (double)(this.categoryAxisCellModel.getDepth().height > 0 ? 1 : 0));
        }
        if (stride > 0.0) {
            Double cbw;
            if (this.barLineChartModel.isGrowBarWidthEnabled() || stride * barPercentage < this.totalBarWidth) {
                totalCategoryWidth = stride;
                this.totalBarWidth = stride * barPercentage;
            }
            if ((cbw = this.cellModel.getCommonBarWidth()) == null || this.totalBarWidth < cbw) {
                this.cellModel.setCommonCategoryWidth(new Double(totalCategoryWidth));
                this.cellModel.setCommonBarWidth(new Double(this.totalBarWidth));
            }
        }
        return stride;
    }

    private Dimension _computeAxesParameters(double maxCatAxisPercentage, double maxResAxisPercentage, Dimension depth, int width, int height) {
        Dimension prefMargin = this.categoryAxisCellModel.getPreferredMargin();
        Dimension ancMargin = this.cellModel.getCategoryAxisCellModel().getPreferredMargin();
        Dimension margin = this.categoryAxisCellModel.getMargin();
        AxisCellModel responseAxisCellModel = this.cellModel.getResponseAxisCellModel();
        AxisCellModel response2AxisCellModel = this.cellModel.getResponse2AxisCellModel();
        Insets outerMargin = this.cellModel.getOuterMargin();
        Dimension resMargin = null;
        if (this.isVerticalOrientation) {
            prefMargin.width = this.cellModel.getCommonBarWidth() != null ? Math.max(ancMargin.width, this.cellModel.getCommonBarWidth().intValue() / 2) : ancMargin.width;
            if (!this.isCategoryAxisIntegrated && width != this.categoryAxisCellModel.getLength().intValue() + 2 * margin.width + depth.width) {
                this.categoryAxisCellModel.computeParameters(this.getChannel(), width, maxCatAxisPercentage * (double)height);
            }
            int minCatAxisAdj = 0;
            if (this.barLineChartModel.getResponseAxisModel().getValueTextStyle().isVisible() && this.barLineChartModel.getResponseAxisModel().isVisible() && this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0) {
                minCatAxisAdj = (int)new BaseLength((double)this.barLineChartModel.getResponseAxisModel().getValueTextStyle().getFont().getSize(), "pt").getMagnitude((Object)"py");
            }
            if (this.barLineChartModel.getResponse2AxisModel().getValueTextStyle().isVisible() && this.barLineChartModel.getResponse2AxisModel().isVisible() && this.variables.response2Axis.getBarVariableCount() + this.variables.response2Axis.getLineVariableCount() > 0) {
                minCatAxisAdj = Math.max(minCatAxisAdj, (int)new BaseLength((double)this.barLineChartModel.getResponseAxisModel().getValueTextStyle().getFont().getSize(), "pt").getMagnitude((Object)"py"));
            }
            minCatAxisAdj = (int)((double)minCatAxisAdj * 0.55);
            int catAxisAdj = Math.max(minCatAxisAdj, this.categoryAxisCellModel.getCatAxisAdj().intValue());
            if (this.cellModel.getMinCatAxisAdj() != null) {
                catAxisAdj = (int)Math.max((double)catAxisAdj, this.cellModel.getMinCatAxisAdj());
            }
            if (catAxisAdj > outerMargin.bottom) {
                outerMargin.bottom = catAxisAdj;
                this.cellModel.getCategoryAxisCellModel().setCatAxisAdj(new Double(catAxisAdj));
            } else {
                catAxisAdj = outerMargin.bottom;
            }
            this.categoryAxisCellModel.setCatAxisAdj(null);
            int chartAreaWidth = this.cellModel.getChartAreaWidth() != null ? this.cellModel.getChartAreaWidth() : width;
            double maxResAxisWidth = maxResAxisPercentage * (double)chartAreaWidth;
            if (this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0 && this.variables.response2Axis.getBarVariableCount() + this.variables.response2Axis.getLineVariableCount() > 0) {
                maxResAxisWidth /= 2.0;
            }
            if (this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0) {
                responseAxisCellModel.setCatAxisAdj(new Double(outerMargin.bottom));
                responseAxisCellModel.computeParameters(this.getChannel(), maxResAxisWidth, height);
                resMargin = responseAxisCellModel.getMargin();
            }
            if (this.variables.response2Axis.getBarVariableCount() + this.variables.response2Axis.getLineVariableCount() > 0) {
                int saveMarginHeight = resMargin == null ? 0 : resMargin.height;
                response2AxisCellModel.setCatAxisAdj(new Double(outerMargin.bottom));
                response2AxisCellModel.computeParameters(this.getChannel(), maxResAxisWidth, height);
                resMargin = response2AxisCellModel.getMargin();
                if (resMargin.height > saveMarginHeight && responseAxisCellModel != null) {
                    responseAxisCellModel.computeParameters(this.getChannel(), maxResAxisWidth, height);
                }
            }
        } else {
            prefMargin.height = this.cellModel.getCommonBarWidth() != null ? Math.max(ancMargin.height, this.cellModel.getCommonBarWidth().intValue() / 2) : ancMargin.height;
            if (!this.isCategoryAxisIntegrated && height != this.categoryAxisCellModel.getLength().intValue() + 2 * margin.height + depth.height) {
                this.categoryAxisCellModel.computeParameters(this.getChannel(), maxCatAxisPercentage * (double)width, height);
            }
            int resAxisAdj = this.categoryAxisCellModel.getResAxisAdj().intValue();
            if (!this.cellModel.getIntegratedAxisEnabled().booleanValue()) {
                if (resAxisAdj > outerMargin.left) {
                    outerMargin.left = resAxisAdj;
                    this.cellModel.getCategoryAxisCellModel().setResAxisAdj(new Double(resAxisAdj));
                } else {
                    resAxisAdj = outerMargin.left;
                }
            } else {
                String firstLabel;
                Font font;
                NumericMapper mapper;
                double firstLabelLength = 0.0;
                if (responseAxisCellModel != null && (mapper = responseAxisCellModel.getMapper()) != null) {
                    font = responseAxisCellModel.getAxisModel().getValueTextStyle().getFont();
                    try {
                        firstLabel = mapper.label.getValue(0);
                    }
                    catch (MissingValueException e) {
                        firstLabel = mapper.getMissingValueLabel();
                    }
                    this.getChannel().glSelect2DFont(font);
                    firstLabelLength = this.getChannel().glGetTextWidth(firstLabel);
                }
                if (response2AxisCellModel != null && (mapper = response2AxisCellModel.getMapper()) != null) {
                    font = response2AxisCellModel.getAxisModel().getValueTextStyle().getFont();
                    try {
                        firstLabel = mapper.label.getValue(0);
                    }
                    catch (MissingValueException e) {
                        firstLabel = mapper.getMissingValueLabel();
                    }
                    this.getChannel().glSelect2DFont(font);
                    firstLabelLength = Math.max(this.getChannel().glGetTextWidth(firstLabel), firstLabelLength);
                }
                double offset = firstLabelLength / 2.0 + 1.0;
                offset = Math.min(offset, (double)width * 0.2);
                outerMargin.left = Math.max(outerMargin.left, (int)offset);
                if (resAxisAdj > outerMargin.left) {
                    outerMargin.left = resAxisAdj;
                }
            }
            int chartAreaHeight = this.cellModel.getChartAreaHeight() != null ? this.cellModel.getChartAreaHeight() : height;
            double maxResAxisHeight = maxResAxisPercentage * (double)chartAreaHeight;
            if (responseAxisCellModel != null && response2AxisCellModel != null) {
                maxResAxisHeight /= 2.0;
            }
            if (this.variables.responseAxis.getBarVariableCount() + this.variables.responseAxis.getLineVariableCount() > 0) {
                responseAxisCellModel.setResAxisAdj(new Double(outerMargin.left));
                responseAxisCellModel.computeParameters(this.getChannel(), width, maxResAxisHeight);
                resMargin = responseAxisCellModel.getMargin();
            }
            if (this.variables.response2Axis.getBarVariableCount() + this.variables.response2Axis.getLineVariableCount() > 0) {
                int saveMarginWidth = resMargin == null ? 0 : resMargin.width;
                response2AxisCellModel.setResAxisAdj(new Double(outerMargin.left));
                response2AxisCellModel.computeParameters(this.getChannel(), width, maxResAxisHeight);
                resMargin = response2AxisCellModel.getMargin();
                if (resMargin.width > saveMarginWidth && responseAxisCellModel != null) {
                    responseAxisCellModel.computeParameters(this.getChannel(), width, maxResAxisHeight);
                }
            }
        }
        return resMargin;
    }

    private void _setCategoryAxisSizes(int width, int height, double maxCatAxisPercentage) {
        Dimension prefMargin = this.categoryAxisCellModel.getPreferredMargin();
        Dimension ancMargin = this.cellModel.getCategoryAxisCellModel().getPreferredMargin();
        Dimension margin = this.categoryAxisCellModel.getMargin();
        if (this.isCategoryAxisIntegrated) {
            double categoryAxisStride = this.getCategoryAxisStrideLength();
            if (this.isVerticalOrientation) {
                prefMargin.width = ancMargin.width;
                margin.width = (int)categoryAxisStride / 2;
            } else {
                prefMargin.height = ancMargin.height;
                margin.height = (int)categoryAxisStride / 2;
            }
            StringToNumericMapper sm = (StringToNumericMapper)this.categoryAxisCellModel.getMapper();
            double axisLength = (double)(sm.getUniqueValueCount() - 1) * categoryAxisStride;
            this.categoryAxisCellModel.setLength(new Double(axisLength));
            this.categoryAxisCellModel.setTitleHeight(new Double(0.0));
            this.categoryAxisCellModel.setTitleWidth(new Double(0.0));
            if (BarLineChartUtil.isAxisReverse(this.categoryAxisCellModel)) {
                sm.setStrideValue(-categoryAxisStride);
                sm.setStartValue(axisLength);
            } else {
                sm.setStrideValue(categoryAxisStride);
                sm.setStartValue(0.0);
            }
        } else if (this.isVerticalOrientation) {
            prefMargin.width = ancMargin.width;
            this.categoryAxisCellModel.computeParameters(this.getChannel(), width, maxCatAxisPercentage * (double)height);
        } else {
            prefMargin.height = ancMargin.height;
            this.categoryAxisCellModel.computeParameters(this.getChannel(), maxCatAxisPercentage * (double)width, height);
        }
    }

    private void _adjustDataLabelFontSize(Dimension resMargin, double maxCatAxisPercentage, double maxResAxisPercentage, Dimension depth, int width, int height, double stride) {
        if (stride != 0.0) {
            this.outsideBarLabelTextStyle.apply(this.barLineChartModel.getOutsideBarLabelTextStyle());
            this.insideBarLabelTextStyle.apply(this.barLineChartModel.getInsideBarLabelTextStyle());
            this.outsideMarkerLabelTextStyle.apply(this.barLineChartModel.getOutsideMarkerLabelTextStyle());
            DataLabelAdjustmentInfo adjustmentInfo = this.cellModel.getDataLabelAdjustmentInfo();
            if (adjustmentInfo != null && adjustmentInfo.width == width && adjustmentInfo.height == height && adjustmentInfo.isVerticalOrientation == this.isVerticalOrientation) {
                this.outsideBarLabelTextStyle.setFont(adjustmentInfo.outsideBarLabelFont);
                this.insideBarLabelTextStyle.setFont(adjustmentInfo.insideBarLabelFont);
                this.outsideMarkerLabelTextStyle.setFont(adjustmentInfo.outsideMarkerLabelFont);
                this.outsideBarLabelTextStyle.setVisible(adjustmentInfo.outsideBarLabelVisible);
                if (adjustmentInfo.resMarginHeight != resMargin.height) {
                    resMargin.height = adjustmentInfo.resMarginHeight;
                    this._computeAxesParameters(maxCatAxisPercentage, maxResAxisPercentage, depth, width, height);
                }
                return;
            }
            adjustmentInfo = new DataLabelAdjustmentInfo();
            this.cellModel.setDataLabelAdjustmentInfo(adjustmentInfo);
            adjustmentInfo.width = width;
            adjustmentInfo.height = height;
            adjustmentInfo.isVerticalOrientation = this.isVerticalOrientation;
            int barSize = (int)(this.maxBarsPerCategory < 2 ? stride : this.totalBarWidth / (double)this.maxBarsPerCategory);
            if (this.isVerticalOrientation) {
                boolean twoMargins = BarLineChartCell._isTwoResponseAxisMargins(this.cellModel.getResponseAxisCellModel(), this.barLineChartModel.getResponseAxisBaselineModel().getPosition()) || BarLineChartCell._isTwoResponseAxisMargins(this.cellModel.getResponse2AxisCellModel(), this.barLineChartModel.getResponse2AxisBaselineModel().getPosition());
                int biggestMargin = Math.max((int)((double)height * (twoMargins ? 0.125 : 0.25)), resMargin.height);
                Dimension space = new Dimension(barSize, biggestMargin);
                if (this.outsideBarLabelTextStyle.isVisible() && this.cellModel.getLongestOutsideBarLabel() != null) {
                    adjustmentInfo.outsideBarLabelAngle = this._fitDataLabels((TextStyle)this.outsideBarLabelTextStyle, this.cellModel.getLongestOutsideBarLabel(), space, true);
                    if (this.outsideBarLabelTextStyle.isVisible()) {
                        Bbox bbox = this._getLabelBbox(this.cellModel.getLongestOutsideBarLabel(), this.outsideBarLabelTextStyle.getFont(), adjustmentInfo.outsideBarLabelAngle);
                        int bboxHeight = (int)Math.ceil(bbox.ymax - bbox.ymin);
                        if (bboxHeight > resMargin.height) {
                            resMargin.height = bboxHeight;
                            this._computeAxesParameters(maxCatAxisPercentage, maxResAxisPercentage, depth, width, height);
                        }
                    }
                }
                if ((double)space.width == stride) {
                    space.width = (int)this.totalBarWidth;
                }
                if (this.insideBarLabelTextStyle.isVisible()) {
                    this._fitDataLabels((TextStyle)this.insideBarLabelTextStyle, this.cellModel.getLongestInsideBarLabel(), space, false);
                }
                if (this.outsideMarkerLabelTextStyle.isVisible()) {
                    this._fitDataLabels((TextStyle)this.outsideMarkerLabelTextStyle, this.cellModel.getLongestOutsideMarkerLabel(), new Dimension((int)stride, Integer.MAX_VALUE), false);
                    this._fitDataLabels((TextStyle)this.outsideMarkerLabelTextStyle, this.cellModel.getTallestOutsideLabel(), new Dimension(Integer.MAX_VALUE, resMargin.height), false);
                }
            } else {
                Dimension space = new Dimension(resMargin.width, barSize);
                if (this.outsideBarLabelTextStyle.isVisible()) {
                    adjustmentInfo.outsideBarLabelAngle = this._fitDataLabels((TextStyle)this.outsideBarLabelTextStyle, this.cellModel.getLongestOutsideBarLabel(), space, true);
                }
                if (this.outsideMarkerLabelTextStyle.isVisible()) {
                    this._fitDataLabels((TextStyle)this.outsideMarkerLabelTextStyle, this.cellModel.getLongestOutsideMarkerLabel(), space, false);
                }
            }
            adjustmentInfo.outsideBarLabelFont = this.outsideBarLabelTextStyle.getFont();
            adjustmentInfo.insideBarLabelFont = this.insideBarLabelTextStyle.getFont();
            adjustmentInfo.outsideMarkerLabelFont = this.outsideMarkerLabelTextStyle.getFont();
            adjustmentInfo.outsideBarLabelVisible = this.outsideBarLabelTextStyle.isVisible();
            adjustmentInfo.resMarginHeight = resMargin.height;
        }
    }

    private int _fitDataLabels(TextStyle textStyle, String testLabel, Dimension space, boolean rotateEnabled) {
        double angle = Double.NaN;
        if (textStyle instanceof AdvancedTextStyle) {
            angle = ((AdvancedTextStyle)textStyle).getBaselineAngle();
        }
        if (testLabel == null) {
            return (int)angle;
        }
        if (Double.isNaN(angle)) {
            angle = 0.0;
        } else {
            rotateEnabled = false;
        }
        Font font = textStyle.getFont();
        boolean fits = this._fitDataLabels(textStyle, testLabel, space, angle);
        if (rotateEnabled && !fits) {
            textStyle.setFont(font);
            textStyle.setVisible(this._fitDataLabels(textStyle, testLabel, space, angle + 90.0));
            return (int)(angle + 90.0);
        }
        textStyle.setVisible(fits);
        return (int)angle;
    }

    private boolean _fitDataLabels(TextStyle textStyle, String testLabel, Dimension space, double angle) {
        Font font = textStyle.getFont();
        int fontSize = font.getSize();
        Channel ch = this.getChannel();
        ch.glSelect2DFont(font);
        while (!this._labelFits(testLabel, font, angle, space) && fontSize > 8) {
            font = FontManager.getFont((String)font.getFamily(), (int)font.getStyle(), (int)(--fontSize));
            ch.glSelect2DFont(font);
        }
        textStyle.setFont(font);
        return this._labelFits(testLabel, font, angle, space);
    }

    private Bbox _getLabelBbox(String label, Font font, double angle) {
        Channel ch = this.getChannel();
        ch.glSelect2DFont(font);
        Bbox bbox = new Bbox();
        ch.glGetText2DBbox(label, 0.0, 0.0, 0.0, (int)angle, bbox);
        return bbox;
    }

    private boolean _labelFits(String label, Font font, double angle, Dimension space) {
        Bbox bbox = this._getLabelBbox(label, font, angle);
        boolean fits = Math.round(bbox.xmax - bbox.xmin) <= (long)space.width && Math.round(bbox.ymax - bbox.ymin) <= (long)space.height;
        return fits;
    }

    private static boolean _isTwoResponseAxisMargins(AxisCellModel axisCellModel, double baseline) {
        if (axisCellModel != null && axisCellModel.getMapper() != null) {
            ContinuousRangeToNumericMapper axisMapper = (ContinuousRangeToNumericMapper)axisCellModel.getMapper();
            if (Double.isNaN(baseline)) {
                baseline = 0.0;
            }
            return axisMapper.getInputMax() > 0.0 && axisMapper.getInputMin() < 0.0 && axisMapper.getInputMin() < baseline;
        }
        return false;
    }

    private void _setDepth(Dimension depth) {
        if (this.barLineChartModel.getDimension() == 10101 && this.cellModel.getCommonBarWidth() != null) {
            int barThickness = (int)(this.cellModel.getCommonBarWidth() / ((double)this.cellModel.getMaxBarsPerCategory().intValue() + 2.0));
            depth.width = depth.height = (int)((double)barThickness * (0.3 / COS_ANGLE));
            if (depth.width < 3) {
                depth.height = 0;
                depth.width = 0;
            }
        }
    }

    @Override
    public ChartImageMapInfo getChartImageMapInfo() {
        if (this.dataSource.getValueCount() < 1) {
            return null;
        }
        ChartImageMapInfo2 barChartImageMapInfo = null;
        Hashtable<String, Shape> formattedCategoryValueToShape = new Hashtable<String, Shape>();
        Shape labelMarkerShape = null;
        Shape labelTitleShape = null;
        Shape responseTitleShape = null;
        Shape response2TitleShape = null;
        Vector selectableShapes = this.computeImageMapInfoShapes();
        if (selectableShapes != null) {
            int count = selectableShapes.size();
            ArrayList<ChartValueZone> categoryValueZonesAL = new ArrayList<ChartValueZone>(count);
            ArrayList<ChartValueZone> dataElementValueZonesAL = new ArrayList<ChartValueZone>(count);
            LabelZoneList categoryLabelZoneList = null;
            LabelZoneList subgroupLabelZoneList = null;
            LabelZoneList responseLabelZoneList = null;
            LabelZoneList response2LabelZoneList = null;
            for (int ii = 0; ii < count; ++ii) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                Util.SelectInfo selectInfo = this.getSelectInfo(sr);
                if (element instanceof RectangularAxis) {
                    AxisDetail ad = (AxisDetail)sr.getDetail();
                    if (ad == null) continue;
                    if (ad.getType() == 0) {
                        try {
                            String formattedCategoryValue = ((RectangularAxis)element).labels.getValue(ad.getLabelIndex());
                            formattedCategoryValueToShape.put(formattedCategoryValue, selectableShape.getShape());
                        }
                        catch (MissingValueException formattedCategoryValue) {}
                        continue;
                    }
                    if (ad.getType() == 2) {
                        labelTitleShape = selectableShape.getShape();
                        continue;
                    }
                    if (ad.getType() != 4) continue;
                    labelMarkerShape = selectableShape.getShape();
                    continue;
                }
                if (element instanceof RasterLabel) {
                    String associatedAxis = (String)selectInfo.userData;
                    if (this.isVerticalOrientation) {
                        if ("X".equals(associatedAxis)) {
                            labelTitleShape = selectableShape.getShape();
                            continue;
                        }
                        if ("Y".equals(associatedAxis)) {
                            responseTitleShape = selectableShape.getShape();
                            continue;
                        }
                        if (!"y2".equals(associatedAxis)) continue;
                        response2TitleShape = selectableShape.getShape();
                        continue;
                    }
                    if ("Y".equals(associatedAxis)) {
                        labelTitleShape = selectableShape.getShape();
                        continue;
                    }
                    if ("X".equals(associatedAxis)) {
                        responseTitleShape = selectableShape.getShape();
                        continue;
                    }
                    if (!"X2".equals(associatedAxis)) continue;
                    response2TitleShape = selectableShape.getShape();
                    continue;
                }
                if (!(element instanceof Bar) && !(element instanceof MultiResponseStackedBar) && !(element instanceof Marker)) continue;
                int obsIndex = sr.getValueIndex();
                ValueList categoryValueList = null;
                if (this.variables.categoryVariable != null) {
                    categoryValueList = GTKUtil.toValueList((Variable)this.variables.categoryVariable, obsIndex, null);
                }
                ValueList subgroupValueList = null;
                if (this.variables.subgroupVariable != null) {
                    subgroupValueList = GTKUtil.toValueList((Variable)this.variables.subgroupVariable, obsIndex, null);
                }
                ValueList responseValueList = GTKUtil.toValueList(this.variables.responseAxis.barVariableArray, obsIndex, GTKUtil.toValueList(this.variables.responseAxis.lineVariableArray, obsIndex, null));
                ValueList response2ValueList = GTKUtil.toValueList(this.variables.response2Axis.barVariableArray, obsIndex, GTKUtil.toValueList(this.variables.response2Axis.lineVariableArray, obsIndex, null));
                ValueList dataTipValueList = GTKUtil.toValueList(this.variables.dataTipVariableArray, obsIndex);
                ValueList auxiliaryValueList = GTKUtil.toValueList(this.variables.auxiliaryVariableArray, obsIndex);
                ChartValueZone elementValueZone = new ChartValueZone(selectableShape.getShape(), this.columnValueList, this.rowValueList, categoryValueList, subgroupValueList, responseValueList, response2ValueList, dataTipValueList, auxiliaryValueList);
                dataElementValueZonesAL.add(elementValueZone);
            }
            if (labelTitleShape != null && !this.isCategoryAxisIntegrated) {
                categoryLabelZoneList = new LabelZoneList(labelTitleShape, this.variables.categoryVariable.getName(), this.variables.categoryVariable.getLabel(), new DataZone(labelMarkerShape), null);
            }
            if (responseTitleShape != null) {
                responseLabelZoneList = BarLineChartUtil.newResponseLabelList(BarLineChartUtil.newResponseLabelList(null, this.variables.responseAxis.lineVariableArray, responseTitleShape, null), this.variables.responseAxis.barVariableArray, responseTitleShape, null);
            }
            if (response2TitleShape != null) {
                response2LabelZoneList = BarLineChartUtil.newResponseLabelList(BarLineChartUtil.newResponseLabelList(null, this.variables.response2Axis.lineVariableArray, response2TitleShape, null), this.variables.response2Axis.barVariableArray, response2TitleShape, null);
            }
            if (!this.isCategoryAxisIntegrated && this.variables.categoryVariable != null) {
                int uvcount = this.variables.categoryVariable.getUniqueValueCount();
                for (int ii = 0; ii < uvcount; ++ii) {
                    Object categoryValue = GTKUtil.VariableAccess.getUniqueValue(this.variables.categoryVariable, ii);
                    String formattedCategoryValue = GTKUtil.VariableAccess.getFormattedUniqueValue(this.variables.categoryVariable, ii);
                    Shape shape = (Shape)formattedCategoryValueToShape.get(formattedCategoryValue);
                    if (shape == null) continue;
                    ValueList categoryValueList = new ValueList(categoryValue, formattedCategoryValue, null);
                    ChartValueZone categoryValueZone = new ChartValueZone(shape, this.columnValueList, this.rowValueList, categoryValueList, null);
                    categoryValueZonesAL.add(categoryValueZone);
                }
            }
            ChartValueZone[] categoryValueZones = categoryValueZonesAL.toArray(new ChartValueZone[0]);
            ChartValueZone[] dataElementValueZones = dataElementValueZonesAL.toArray(new ChartValueZone[0]);
            if (dataElementValueZones != null) {
                for (int ii = 0; ii < dataElementValueZones.length / 2; ++ii) {
                    ChartValueZone vz = dataElementValueZones[dataElementValueZones.length - ii - 1];
                    dataElementValueZones[dataElementValueZones.length - ii - 1] = dataElementValueZones[ii];
                    dataElementValueZones[ii] = vz;
                }
            }
            barChartImageMapInfo = new ChartImageMapInfo2(null, null, categoryValueZones, null, dataElementValueZones, null, null, categoryLabelZoneList, subgroupLabelZoneList, responseLabelZoneList, response2LabelZoneList);
            barChartImageMapInfo.source = this;
        }
        return barChartImageMapInfo;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        if (this.isVerticalOrientation && this.categoryAxisMapper != null) {
            try {
                x = (int)(this.categoryAxisMapper.value.getValue(obsIndex) + (this.cellModel.getCommonBarWidth() != null ? this.cellModel.getCommonBarWidth() : 0.0) / 2.0 + this.categoryAxisCellModel.getMargin().getWidth() / 2.0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return new PickInfo(this.getLabelValuePairs(obsIndex), obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    @Override
    protected Util.SelectInfo getSelectInfo(SelectResult sr) {
        Util.SelectInfo result = super.getSelectInfo(sr);
        if (result != null && sr.getElement() instanceof MultiResponseStackedBar) {
            MultiResponseStackedBar mrsBar = (MultiResponseStackedBar)sr.getElement();
            MultiResponseStackedBarDetail detail = (MultiResponseStackedBarDetail)sr.getDetail();
            result.variableName = mrsBar.getNameAt(detail.getResponseIndex());
        }
        return result;
    }

    private Vector[] getLabelValuePairs(int obsIndex) {
        Vector labelValuePairs = new Vector();
        boolean graphDataIsVisible = this.variables.dataTipVariableArray == null || this.variables.dataTipVariableArray.length <= 0 || this.variables.dataTipVariableArray[0] == null || this.graphModel.getDataTipModel().getContent() != 11401;
        Variable[][] responseVariables = new Variable[][]{this.variables.responseAxis.barVariableArray, this.variables.responseAxis.barTargetVariableArray, this.variables.responseAxis.barHighVariableArray, this.variables.responseAxis.barLowVariableArray, this.variables.response2Axis.barVariableArray, this.variables.response2Axis.barTargetVariableArray, this.variables.response2Axis.barHighVariableArray, this.variables.response2Axis.barLowVariableArray, this.variables.responseAxis.lineVariableArray, this.variables.responseAxis.lineTargetVariableArray, this.variables.responseAxis.lineHighVariableArray, this.variables.responseAxis.lineLowVariableArray, this.variables.response2Axis.lineVariableArray, this.variables.response2Axis.lineTargetVariableArray, this.variables.response2Axis.lineHighVariableArray, this.variables.response2Axis.lineLowVariableArray};
        Object[] roles = new Object[]{this.variables.responseAxis.barRole, this.variables.responseAxis.barRole, this.variables.responseAxis.barRole, this.variables.responseAxis.barRole, this.variables.response2Axis.barRole, this.variables.response2Axis.barRole, this.variables.response2Axis.barRole, this.variables.response2Axis.barRole, this.variables.responseAxis.lineRole, this.variables.responseAxis.lineRole, this.variables.responseAxis.lineRole, this.variables.responseAxis.lineRole, this.variables.response2Axis.lineRole, this.variables.response2Axis.lineRole, this.variables.response2Axis.lineRole, this.variables.response2Axis.lineRole};
        for (int vv = 0; vv < responseVariables.length; ++vv) {
            Variable[] variableArray = responseVariables[vv];
            int variableCount = variableArray == null ? 0 : variableArray.length;
            Object role = roles[vv];
            for (int ii = 0; ii < variableCount; ++ii) {
                if (!(variableArray[ii] instanceof NumericVariable)) continue;
                String _role_ = variableCount > 1 ? role.toString() + ii : role.toString();
                GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, (Object)_role_, variableArray[ii], obsIndex, graphDataIsVisible);
            }
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.variables.categoryRole, (Variable)this.variables.categoryVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.variables.subgroupRole, (Variable)this.variables.subgroupVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.variables.dataTipRole, this.variables.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.variables.auxiliaryRole, this.variables.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pe) {
        String property = pe.getPropertyName();
        if (this.isVerticalOrientation && "CatAxisAdj".equals(property)) {
            this.setBounds(this.getBounds());
        } else if (!this.isVerticalOrientation && "ResAxisAdj".equals(property)) {
            this.setBounds(this.getBounds());
        }
    }

    void setCategoryAxisStrideLength(double newValue) {
        this.categoryAxisStrideLength = newValue;
    }

    double getCategoryAxisStrideLength() {
        return this.categoryAxisStrideLength;
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        if (this.allowAntiAliasing) {
            return super.isAntiAliasingEnabled();
        }
        return false;
    }

    @Override
    protected void updateChannel() {
        boolean is3D;
        super.updateChannel();
        Dimension depth = this.categoryAxisCellModel.getDepth();
        boolean bl = this.isVerticalOrientation ? depth.height > 0 : (is3D = depth.width > 0);
        if (is3D) {
            int height;
            Rectangle b = this.getBounds();
            int width = this.isVerticalOrientation ? depth.height : depth.width;
            int n = height = this.isVerticalOrientation ? depth.width : depth.height;
            if (width > 0 && height > 0) {
                this.z = (double)width / 0.3 / COS_ANGLE;
                Channel channel = this.getChannel();
                channel.glViewport(0, height, b.width - width, b.height - height);
                channel.glOblique(0.0, this.xAxisLength + (double)this.xStart + (double)this.xEnd + (double)this.yAxisAdj + (double)this.titleWidth, 0.0, this.yAxisLength + (double)this.yStart + (double)this.yEnd + (double)this.xAxisAdj + (double)this.titleHeight, 0.0, this.z + 1.0, 0.3, 180.0 * ANGLE / Math.PI);
                channel.glEnable(1);
                channel.glShadeModel(1);
                channel.glEnable(3);
                channel.glEnable(19);
                channel.glLight(19, 3, new double[]{0.7, 0.8, 1.0});
                channel.glLight(19, 1, new double[]{1.0, 1.0, 1.0});
                channel.glLight(19, 0, new double[]{0.26, 0.26, 0.26});
                channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
            }
        }
    }

    protected class DataLabelAdjustmentInfo {
        int width;
        int height;
        int resMarginHeight;
        double outsideBarLabelAngle;
        boolean outsideBarLabelVisible;
        boolean isVerticalOrientation;
        Font outsideBarLabelFont;
        Font insideBarLabelFont;
        Font outsideMarkerLabelFont;

        protected DataLabelAdjustmentInfo() {
        }
    }
}

