/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.barlinechart;

import com.sas.graphics.resources.GraphResources;
import com.sas.graphics.util.cell.scatterplot.BIPMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import java.awt.Image;

public class BIPBarSkinFactory
extends AbstractMarkerSkinFactory {
    int skin;
    boolean is3D = false;
    boolean isVerticalOrientation = true;
    private static BIPBarSkinFactory instance;
    private Image[][] cache = new Image[2][2];

    private BIPBarSkinFactory() {
    }

    private void initFactory(int skinType, boolean is3D, boolean isVertical) {
        this.skin = skinType;
        this.is3D = is3D;
        this.isVerticalOrientation = isVertical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AbstractMarkerSkinFactory getInstance(int skinType, boolean is3D, boolean isVertical) {
        if (instance == null) {
            Class<BIPBarSkinFactory> clazz = BIPBarSkinFactory.class;
            // MONITORENTER : com.sas.graphics.util.cell.barlinechart.BIPBarSkinFactory.class
            if (instance == null) {
                instance = new BIPBarSkinFactory();
            }
            // MONITOREXIT : clazz
        }
        instance.initFactory(skinType, is3D, isVertical);
        return instance;
    }

    public Image getSkinImage(int markerStyle) {
        Image img = null;
        switch (markerStyle) {
            case -1: 
            case 3: 
            case 11: 
            case 19: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                img = this.createSkinIcon(this.skin, this.is3D, this.isVerticalOrientation);
                break;
            }
            default: {
                return BIPMarkerSkinFactory.getInstance(this.skin).getSkinImage(markerStyle);
            }
        }
        return img;
    }

    private Image createSkinIcon(int skin, boolean is3D, boolean isVerticalOrientation) {
        Image barEffectsIcon = null;
        if (!is3D) {
            switch (skin) {
                case 12301: {
                    if (isVerticalOrientation) {
                        barEffectsIcon = this._getImage(0, 0, "skin/satin/bar/vertical/BarEffects.png");
                        break;
                    }
                    barEffectsIcon = this._getImage(0, 1, "skin/satin/bar/horizontal/BarEffects.png");
                    break;
                }
                case 12302: {
                    if (isVerticalOrientation) {
                        barEffectsIcon = this._getImage(1, 0, "skin/modern/bar/vertical/BarEffects.png");
                        break;
                    }
                    barEffectsIcon = this._getImage(1, 1, "skin/modern/bar/horizontal/BarEffects.png");
                    break;
                }
            }
        }
        return barEffectsIcon;
    }

    private Image _getImage(int skinIndex, int orientIndex, String fileName) {
        if (this.cache[skinIndex][orientIndex] == null) {
            this.cache[skinIndex][orientIndex] = GraphResources.getImageIcon(fileName).getImage();
        }
        return this.cache[skinIndex][orientIndex];
    }
}

