/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.areabarchart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.areabarchart.AreaBarChartModel;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartCellModel;
import com.sas.graphics.util.cell.areabarchart.StepperByCategory;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AccumulatorByCategory;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StatisticByCategory;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.measures.BaseLength;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;

public class AreaBarChartCell
extends Cell {
    private transient Object categoryRole;
    private transient Object heightRole;
    private transient Object widthRole;
    private transient Object subgroupRole;
    private transient Object insideBarLabelRole;
    private transient Object outsideBarLabelRole;
    private transient Object dataTipRole;
    private transient Object auxiliaryRole;
    private transient Variable category;
    private transient Variable height;
    private transient Variable width;
    private transient Variable subgroup;
    private transient Variable insideBarLabel;
    private transient Variable outsideBarLabel;
    private transient Variable[] dataTipVariableArray;
    private transient Variable[] auxiliaryVariableArray;
    private transient StatisticByCategory barHeightStat;
    private transient StatisticByCategory barWidthStat;
    private transient ContinuousRangeToNumericMapper barHeightMapper;
    private transient ContinuousRangeToNumericMapper barWidthMapper;
    private transient ContinuousRangeToNumericMapper barVerticalOriginMapper;
    private transient ContinuousRangeToNumericMapper barVerticalLimitMapper;
    private transient ContinuousRangeToNumericMapper barHorizontalCenterMapper;
    private transient ContinuousRangeToNumericMapper barVerticalCenterMapper;
    private transient StepperByCategory barHorizontalOrigin;
    private transient AccumulatorByCategory barVerticalOrigin;
    private transient AccumulatorByCategory barVerticalOrigin2;
    private transient AccumulatorByCategory barVerticalOrigin3;
    private transient Calculator barHorizontalCenter;
    private transient Calculator barVerticalCenter;
    private transient Calculator barVerticalLimit;
    private transient DataSource dataSource;
    private final transient AreaBarChartModel graphModel;
    private final transient AreaBarChartCellModel cellModel;
    Dimension margin = new Dimension(0, 0);
    int catAxisAdj = 0;

    public AreaBarChartCell(AreaBarChartCellModel m, DataSource s, Channel channel) {
        super(m, channel);
        this.cellModel = m;
        this.graphModel = this.cellModel.getAreabarChartModel();
        this.dataSource = s;
        this.setOpaque(false);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected synchronized void construct() {
        FillStyle wallFillStyle;
        boolean threeD;
        AxisCellModel yAxisCellModel;
        AxisCellModel xAxisCellModel;
        if (this.dataSource == null) {
            return;
        }
        AreaBarChartCellModel cellModel = (AreaBarChartCellModel)this.getModel();
        this.categoryRole = cellModel.getCategoryRole();
        this.subgroupRole = cellModel.getSubgroupRole();
        this.heightRole = cellModel.getHeightRole();
        this.widthRole = cellModel.getWidthRole();
        this.insideBarLabelRole = cellModel.getInsideBarLabelRole();
        this.outsideBarLabelRole = cellModel.getOutsideBarLabelRole();
        this.dataTipRole = cellModel.getDataTipRole();
        this.auxiliaryRole = cellModel.getAuxiliaryRole();
        this.category = this.dataSource.getVariable(this.categoryRole, 0);
        this.height = this.dataSource.getVariable(this.heightRole, 0);
        this.width = this.dataSource.getVariable(this.widthRole, 0);
        this.subgroup = this.subgroupRole != null ? this.dataSource.getVariable(this.subgroupRole, 0) : null;
        this.insideBarLabel = this.insideBarLabelRole != null ? this.dataSource.getVariable(this.insideBarLabelRole, 0) : null;
        this.outsideBarLabel = this.outsideBarLabelRole != null ? this.dataSource.getVariable(this.outsideBarLabelRole, 0) : null;
        this.dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.dataTipRole);
        this.auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, this.auxiliaryRole);
        if (!(this.category instanceof StringVariable) || this.height.getValueCount() < 0 || this.width.getValueCount() < 0) {
            return;
        }
        int orientation = cellModel.getAreabarChartModel().getOrientation();
        boolean vertical = orientation == 1;
        AxisCellModel heightAxisCellModel = cellModel.getHeightAxisCellModel();
        AxisCellModel widthAxisCellModel = cellModel.getWidthAxisCellModel();
        if (vertical) {
            xAxisCellModel = widthAxisCellModel;
            yAxisCellModel = heightAxisCellModel;
        } else {
            xAxisCellModel = heightAxisCellModel;
            yAxisCellModel = widthAxisCellModel;
        }
        Dimension depth = xAxisCellModel.getDepth();
        boolean bl = threeD = cellModel.getAreabarChartModel().getDimension() == 10101;
        if (threeD) {
            Channel channel = this.getChannel();
            channel.glEnable(1);
            channel.glShadeModel(1);
            channel.glEnable(3);
            channel.glEnable(19);
            channel.glLight(19, 3, new double[]{0.7, 0.8, 1.0});
            channel.glLight(19, 1, new double[]{1.0, 1.0, 1.0});
            channel.glLight(19, 0, new double[]{0.26, 0.26, 0.26});
            channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
        }
        double xAxisLength = xAxisCellModel.getLength();
        double yAxisLength = yAxisCellModel.getLength();
        double zAxisLength = cellModel.getDepthRatio() * (vertical ? xAxisLength : yAxisLength);
        StringVariable stringCategory = (StringVariable)this.category;
        StringVariable stringSubgroup = (StringVariable)this.subgroup;
        NumericVariable numericHeight = (NumericVariable)this.height;
        NumericVariable numericWidth = (NumericVariable)this.width;
        boolean useSubgroups = this.subgroupRole != null && this.subgroup instanceof StringVariable;
        StringVariable colorVar = useSubgroups ? stringSubgroup : stringCategory;
        StringToColorMapper barColorMapper = new StringToColorMapper();
        barColorMapper.shareMap(cellModel.getStringToColorMapper());
        barColorMapper.input.connectFrom(colorVar.formattedValue);
        this.barWidthStat = new StatisticByCategory();
        this.barWidthStat.category.connectFrom(stringCategory.category);
        this.barWidthStat.input.connectFrom(numericWidth.value);
        this.barWidthStat.setStatistic(6);
        ContinuousRangeToNumericMapper widthAxisMapper = (ContinuousRangeToNumericMapper)widthAxisCellModel.getMapper();
        this.barWidthMapper = new ContinuousRangeToNumericMapper();
        this.barWidthMapper.setInputMin(0.0);
        this.barWidthMapper.setInputMax(widthAxisMapper.getInputMax() - widthAxisMapper.getInputMin());
        this.barWidthMapper.setOutputMin(0.0);
        this.barWidthMapper.setOutputMax(widthAxisMapper.getOutputMax() - widthAxisMapper.getOutputMin());
        this.barWidthMapper.input.connectFrom(this.barWidthStat.value);
        this.barHorizontalOrigin = new StepperByCategory();
        this.barHorizontalOrigin.category.connectFrom(stringCategory.category);
        this.barHorizontalOrigin.input.connectFrom(this.barWidthStat.value);
        this.barHorizontalCenter = new Calculator("(inA + inB/2)");
        this.barHorizontalCenter.inA.connectFrom(this.barHorizontalOrigin.value);
        this.barHorizontalCenter.inB.connectFrom(this.barWidthStat.value);
        this.barHorizontalCenterMapper = new ContinuousRangeToNumericMapper();
        this.barHorizontalCenterMapper.shareMap(widthAxisMapper);
        this.barHorizontalCenterMapper.input.connectFrom(this.barHorizontalCenter.value);
        this.barHeightStat = new StatisticByCategory();
        this.barHeightStat.category.connectFrom(stringCategory.category);
        this.barHeightStat.input.connectFrom(numericHeight.value);
        this.barHeightStat.setStatistic(6);
        ContinuousRangeToNumericMapper heightAxisMapper = (ContinuousRangeToNumericMapper)heightAxisCellModel.getMapper();
        this.barHeightMapper = new ContinuousRangeToNumericMapper();
        this.barHeightMapper.shareMap(heightAxisMapper);
        this.barHeightMapper.input.connectFrom(this.barHeightStat.value);
        this.barVerticalOrigin = new AccumulatorByCategory();
        this.barVerticalOrigin.category.connectFrom(stringCategory.category);
        this.barVerticalOrigin.input.connectFrom(numericHeight.value);
        this.barVerticalOriginMapper = new ContinuousRangeToNumericMapper();
        this.barVerticalOriginMapper.shareMap(heightAxisMapper);
        this.barVerticalOriginMapper.input.connectFrom(this.barVerticalOrigin.value);
        this.barVerticalOrigin2 = new AccumulatorByCategory();
        this.barVerticalOrigin2.category.connectFrom(stringCategory.category);
        this.barVerticalOrigin2.input.connectFrom(numericHeight.value);
        this.barVerticalLimit = new Calculator("(inA + inB)");
        this.barVerticalLimit.inA.connectFrom(this.barVerticalOrigin2.value);
        this.barVerticalLimit.inB.connectFrom(numericHeight.value);
        this.barVerticalLimitMapper = new ContinuousRangeToNumericMapper();
        this.barVerticalLimitMapper.shareMap(heightAxisMapper);
        this.barVerticalLimitMapper.input.connectFrom(this.barVerticalLimit.value);
        this.barVerticalOrigin3 = new AccumulatorByCategory();
        this.barVerticalOrigin3.category.connectFrom(stringCategory.category);
        this.barVerticalOrigin3.input.connectFrom(numericHeight.value);
        this.barVerticalCenter = new Calculator("(inA + inB/2)");
        this.barVerticalCenter.inA.connectFrom(this.barVerticalOrigin3.value);
        this.barVerticalCenter.inB.connectFrom(numericHeight.value);
        this.barVerticalCenterMapper = new ContinuousRangeToNumericMapper();
        this.barVerticalCenterMapper.shareMap(heightAxisMapper);
        this.barVerticalCenterMapper.input.connectFrom(this.barVerticalCenter.value);
        AdvancedTextStyle ts = this.graphModel.getInsideBarLabelTextStyle();
        RasterLabel insideBarLabelRaster = null;
        if (this.insideBarLabel != null && ts.isVisible()) {
            StringPipe labelPipe = null;
            if (this.insideBarLabel instanceof StringVariable) {
                labelPipe = ((StringVariable)this.insideBarLabel).formattedValue;
            } else if (this.insideBarLabel instanceof NumericVariable) {
                labelPipe = ((NumericVariable)this.insideBarLabel).formattedValue;
            }
            insideBarLabelRaster = new RasterLabel();
            insideBarLabelRaster.string.connectFrom(labelPipe);
            insideBarLabelRaster.trimOn.setValue(true);
            this._applyTextStyleToRaster(ts, insideBarLabelRaster);
            insideBarLabelRaster.verticalJustification.setValue(1);
            insideBarLabelRaster.horizontalJustification.setValue(1);
            if (vertical) {
                insideBarLabelRaster.transform.translateX.connectFrom((NumericPipe)this.barHorizontalCenterMapper);
                insideBarLabelRaster.transform.translateY.connectFrom((NumericPipe)this.barVerticalCenterMapper);
            } else {
                insideBarLabelRaster.transform.translateX.connectFrom((NumericPipe)this.barVerticalCenterMapper);
                insideBarLabelRaster.transform.translateY.connectFrom((NumericPipe)this.barHorizontalCenterMapper);
            }
            insideBarLabelRaster.transform.translateZ.setValue(0.0);
        }
        ts = this.graphModel.getOutsideBarLabelTextStyle();
        RasterLabel outsideBarLabelRaster = null;
        if (this.outsideBarLabel != null && ts.isVisible() && this.subgroup == null) {
            StringPipe labelPipe = null;
            if (this.outsideBarLabel instanceof StringVariable) {
                labelPipe = ((StringVariable)this.outsideBarLabel).formattedValue;
            } else if (this.outsideBarLabel instanceof NumericVariable) {
                labelPipe = ((NumericVariable)this.outsideBarLabel).formattedValue;
            }
            outsideBarLabelRaster = new RasterLabel();
            outsideBarLabelRaster.string.connectFrom(labelPipe);
            outsideBarLabelRaster.trimOn.setValue(true);
            this._applyTextStyleToRaster(ts, outsideBarLabelRaster);
            if (vertical) {
                outsideBarLabelRaster.verticalJustification.setValue(3);
                outsideBarLabelRaster.horizontalJustification.setValue(1);
                outsideBarLabelRaster.transform.translateX.connectFrom((NumericPipe)this.barHorizontalCenterMapper);
                outsideBarLabelRaster.transform.translateY.connectFrom((NumericPipe)this.barHeightMapper);
            } else {
                Calculator bhm5 = new Calculator("inA+5");
                bhm5.inA.connectFrom(this.barHeightMapper.value);
                outsideBarLabelRaster.verticalJustification.setValue(1);
                outsideBarLabelRaster.horizontalJustification.setValue(0);
                outsideBarLabelRaster.transform.translateX.connectFrom((NumericPipe)bhm5);
                outsideBarLabelRaster.transform.translateY.connectFrom((NumericPipe)this.barHorizontalCenterMapper);
            }
            outsideBarLabelRaster.transform.translateZ.setValue(0.0);
        }
        Grid walls = null;
        if (threeD) {
            wallFillStyle = this.graphModel.getAxisWallModel().getWallFillStyle();
            Box wallbox = new Box();
            wallbox.setNormalsReversed(true);
            wallbox.origin.setValue(0);
            wallbox.sizeX.setValue(xAxisLength - 2.0);
            wallbox.sizeY.setValue(yAxisLength);
            wallbox.sizeZ.setValue(zAxisLength + 2.0);
            wallbox.transform.translateX.setValue(wallbox.sizeX.getValue() / 2.0 - 1.0);
            wallbox.transform.translateY.setValue(wallbox.sizeY.getValue() / 2.0 - 1.0);
            wallbox.transform.translateZ.setValue(-wallbox.sizeZ.getValue() / 2.0);
            wallbox.color.setValue(wallFillStyle.getSolidFillColor());
            wallbox.fillOn.setValue(true);
            wallbox.edgeOn.setValue(true);
            wallbox.edgeColor.setValue(this.graphModel.getFrameLineStyle().getColor());
            walls = wallbox;
        } else {
            Grid wallgrid;
            wallFillStyle = this.graphModel.getAxisWallModel().getWallFillStyle();
            walls = wallgrid = new Grid();
            int borderOutsideX = 0;
            int borderOutsideY = 0;
            if (wallgrid.getStyle().isBorderOn()) {
                int actualthickness = wallgrid.getStyle().getLineWidth();
                if (actualthickness % 2 == 0) {
                    ++actualthickness;
                }
                borderOutsideY = actualthickness / 2;
                borderOutsideX = borderOutsideY + 1;
            }
            wallgrid.transform.translateX.setValue(-1.0);
            wallgrid.transform.translateY.setValue(-1.0);
            wallgrid.setWidth(xAxisLength - (double)borderOutsideX);
            wallgrid.setHeight(yAxisLength - (double)borderOutsideY);
            wallgrid.getStyle().setBackgroundColor(wallFillStyle.getSolidFillColor());
        }
        walls.selectEnabled.setValue(false);
        Bar bars = new Bar();
        bars.color1.connectFrom(barColorMapper.value);
        bars.verticalOn.setValue(vertical);
        bars.position.connectFrom(this.barHorizontalCenterMapper.value);
        bars.thickness.connectFrom(this.barWidthMapper.value);
        bars.startValue.connectFrom(this.barVerticalOriginMapper.value);
        bars.endValue.connectFrom(this.barVerticalLimitMapper.value);
        bars.edgeOn.setValue(true);
        bars.edgeColor.setValue(Color.black);
        bars.setTwoD(!threeD);
        if (threeD) {
            double d = widthAxisCellModel.getLength() * cellModel.getDepthRatio();
            bars.depth.setValue(d);
            bars.transform.translateZ.setValue(-d / 2.0);
        }
        RasterLabel yAxisTitle = null;
        int yTitlePlacement = yAxisCellModel.getTitlePlacementType();
        if (yAxisCellModel.getPrimary().booleanValue() && (yTitlePlacement == 11301 || yTitlePlacement == 11303 && yAxisCellModel.getTitleBreak() != null)) {
            BaseLength xStartOffset = xAxisCellModel.getAxisModel().getStartOffset();
            BaseLength yStartOffset = yAxisCellModel.getAxisModel().getStartOffset();
            double xstart = xStartOffset != null ? xStartOffset.getMagnitude((Object)"px") : (double)this.margin.width;
            double ystart = yStartOffset != null ? yStartOffset.getMagnitude((Object)"py") : (double)this.margin.height;
            String title = yAxisCellModel.getTitle();
            if (yTitlePlacement == 11303) {
                title = title.substring(yAxisCellModel.getTitleBreak());
            }
            yAxisTitle = this._getALabel(yAxisCellModel.getAxisModel().getLabelTextStyle(), title, new double[]{-xstart, yAxisLength + (double)depth.height - ystart + 2.0}, 0, 3);
            yAxisTitle.selectEnabled.setValue(false);
        }
        Composite root = this.getComposite();
        root.transform.translateX.setValue(0.0);
        if (walls != null) {
            root.addElement((Element)walls);
        }
        root.addElement((Element)bars);
        if (insideBarLabelRaster != null) {
            root.addElement((Element)insideBarLabelRaster);
        }
        if (outsideBarLabelRaster != null) {
            root.addElement((Element)outsideBarLabelRaster);
        }
        if (yAxisTitle != null) {
            root.addElement(yAxisTitle);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.dataSource == null) {
            System.out.println("AreaBarChartCell.getPreferredSize() dataSource is null");
            return super.getPreferredSize();
        }
        AreaBarChartCellModel cellModel = (AreaBarChartCellModel)this.getModel();
        if (cellModel == null) {
            System.out.println("AreaBarChartCell.getPreferredSize() cellModel is null");
            return super.getPreferredSize();
        }
        AxisCellModel widthAxisCellModel = cellModel.getWidthAxisCellModel();
        AxisCellModel heightAxisCellModel = cellModel.getHeightAxisCellModel();
        if (widthAxisCellModel != null && heightAxisCellModel != null) {
            Dimension preferred;
            int orientation = cellModel.getAreabarChartModel().getOrientation();
            boolean vertical = orientation == 1;
            double widthAxisLength = widthAxisCellModel.getLength();
            double heightAxisLength = heightAxisCellModel.getLength();
            if (vertical) {
                Dimension margin = new Dimension(heightAxisCellModel.getMargin().width, widthAxisCellModel.getMargin().height);
                preferred = new Dimension((int)widthAxisLength + margin.width * 2, (int)heightAxisLength + margin.height * 2 + this.catAxisAdj);
            } else {
                Dimension margin = new Dimension(widthAxisCellModel.getMargin().width, heightAxisCellModel.getMargin().height);
                preferred = new Dimension((int)heightAxisLength + margin.width * 2, (int)widthAxisLength + margin.height * 2 + this.catAxisAdj);
            }
            return preferred;
        }
        return super.getPreferredSize();
    }

    protected void adjustProjection() {
        Channel channel = this.getChannel();
        double angle = this.cellModel.getRecedingAngle();
        Rectangle bounds = this.getBounds();
        channel.glViewport(0, 0, bounds.width, bounds.height);
        channel.glOblique(0.0, (double)bounds.width, 0.0, (double)bounds.height, (double)(-bounds.width), (double)bounds.width, 1.0, angle);
        channel.gluLookAt(0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0);
    }

    @Override
    protected void updateChannel() {
        this.adjustProjection();
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return new PickInfo(this.getLabelValuePairs(obsIndex), obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    private Vector[] getLabelValuePairs(int obsIndex) {
        Vector labelValuePairs = new Vector();
        boolean graphDataIsVisible = this.dataTipVariableArray == null || this.dataTipVariableArray.length <= 0 || this.dataTipVariableArray[0] == null || this.graphModel.getDataTipModel().getContent() != 11401;
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.heightRole, this.height, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.widthRole, this.width, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.categoryRole, this.category, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.subgroupRole, this.subgroup, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.dataTipRole, this.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.auxiliaryRole, this.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    public double[] getHeightRange() {
        Object hr = this.cellModel.getHeightRole();
        NumericVariable hv = (NumericVariable)this.dataSource.getVariable(hr, 0);
        Object cr = this.cellModel.getCategoryRole();
        StringVariable cv = (StringVariable)this.dataSource.getVariable(cr, 0);
        BidirectionalAccumulatorByCategory acc = new BidirectionalAccumulatorByCategory();
        acc.category.connectFrom(cv.category);
        acc.input.connectFrom(hv.value);
        return new double[]{0.0, acc.getAccumulation()[1]};
    }

    public double[] getWidthRange() {
        Object wr = this.cellModel.getWidthRole();
        NumericVariable wv = (NumericVariable)this.dataSource.getVariable(wr, 0);
        return new double[]{0.0, wv.getSum()};
    }

    public AreaBarChartCellModel getAreaBarChartCellModel() {
        return this.cellModel;
    }

    private void _applyTextStyleToRaster(TextStyle ts, RasterLabel rl) {
        rl.angle.setValue(Util.resolveBaselineAngle(ts));
        Font f = ts.getFont();
        rl.fontName.setValue(f.getName());
        rl.fontSize.setValue(f.getSize());
        rl.fontStyle.setValue(f.getStyle());
        rl.color.setValue(ts.getColor());
        rl.shadowColor.setValue(ts.getShadowStyle().getColor());
        rl.shadowOn.setValue(ts.getShadowStyle().isVisible());
        rl.shadowOffsetX.setValue((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
        rl.shadowOffsetY.setValue((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
    }

    private RasterLabel _getALabel(TextStyle textStyle, String text, double[] loc, int horzJustification, int vertJustification) {
        RasterLabel label = new RasterLabel();
        this._applyTextStyleToRaster(textStyle, label);
        return this._getALabel(label, text, loc, horzJustification, vertJustification);
    }

    private RasterLabel _getALabel(RasterLabel label, String text, double[] loc, int horzJustification, int vertJustification) {
        label.trimOn.setValue(true);
        label.verticalJustification.setValue(vertJustification);
        label.horizontalJustification.setValue(horzJustification);
        label.transform.translateX.setValue(loc[0]);
        label.transform.translateY.setValue(loc[1]);
        label.transform.translateZ.setValue(0.0);
        label.string.setValue(text);
        return label;
    }
}

