/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericAnimationVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringAnimationVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.util.Locale;
import java.util.Vector;

public abstract class VariableFactory
implements Cloneable {
    private static final boolean ENABLED = true;
    private static final boolean NOT_ENABLED = false;
    public static final int SORT_STRATEGY_DEFAULT = 10475;
    private Locale locale = Locale.getDefault();
    private int sortStrategy = 10475;

    public static Variable applyNewVariableDefaults(Variable variable) {
        if (variable != null) {
            variable.setFormattedValueMissingValueExceptionsEnabled(false);
            variable.setSortStrategy(1001);
        }
        return variable;
    }

    public static StringVariable newStringVariable() {
        return VariableFactory.newStringVariable(null);
    }

    public static StringVectorVariable newStringVectorVariable(Vector data) {
        if (data != null) {
            StringVectorVariable sv = new StringVectorVariable();
            VariableFactory.applyNewVariableDefaults((Variable)sv);
            sv.connectFrom(data);
            return sv;
        }
        return null;
    }

    public static StringVectorVariable newStringVectorVariable(String[] data) {
        if (data != null) {
            StringVectorVariable sv = new StringVectorVariable();
            VariableFactory.applyNewVariableDefaults((Variable)sv);
            sv.connectFrom(data);
            return sv;
        }
        return null;
    }

    public static StringVariable newStringVariable(Variable cv) {
        StringVariable sv = new StringVariable();
        VariableFactory.applyNewVariableDefaults((Variable)sv);
        if (cv != null) {
            if (cv instanceof StringVariable) {
                sv.connectFrom((StringVariable)cv);
                sv.setFormat(cv.getFormat());
            } else if (cv instanceof NumericVariable) {
                sv.connectFrom((NumericVariable)cv);
                sv.setFormat(null);
            }
            sv.setLocale(cv.getLocale());
            sv.setSortStrategy(cv.getSortStrategy());
            sv.setLabel(cv.getLabel());
        }
        return sv;
    }

    public static StringVariable newStringAnimationVariable(Variable cv) {
        StringAnimationVariable sv = new StringAnimationVariable();
        VariableFactory.applyNewVariableDefaults((Variable)sv);
        if (cv != null) {
            if (cv instanceof StringVariable) {
                sv.connectFrom((StringVariable)cv);
                sv.setFormat(cv.getFormat());
            } else if (cv instanceof NumericVariable) {
                sv.connectFrom((NumericVariable)cv);
                sv.setFormat(null);
            }
            sv.setLocale(cv.getLocale());
            sv.setSortStrategy(cv.getSortStrategy());
            sv.setLabel(cv.getLabel());
        }
        return sv;
    }

    public static NumericVariable newNumericVariable() {
        return VariableFactory.newNumericVariable(null);
    }

    public static NumericVectorVariable newNumericVectorVariable(Vector data) {
        if (data != null) {
            NumericVectorVariable sv = new NumericVectorVariable();
            VariableFactory.applyNewVariableDefaults((Variable)sv);
            sv.connectFrom(data);
            return sv;
        }
        return null;
    }

    public static NumericVectorVariable newNumericVectorVariable(double[] data) {
        if (data != null) {
            NumericVectorVariable sv = new NumericVectorVariable();
            VariableFactory.applyNewVariableDefaults((Variable)sv);
            sv.connectFrom(data);
            return sv;
        }
        return null;
    }

    public static NumericVariable newNumericVariable(NumericVariable cv) {
        NumericVariable nv = new NumericVariable();
        VariableFactory.applyNewVariableDefaults((Variable)nv);
        if (cv != null) {
            nv.connectFrom(cv);
            nv.setLocale(cv.getLocale());
            nv.setSortStrategy(cv.getSortStrategy());
            nv.setLabel(cv.getLabel());
            nv.setFormat(cv.getFormat());
        }
        return nv;
    }

    public static NumericVariable newNumericAnimationVariable(NumericVariable cv) {
        boolean isInterpolationEnabled = true;
        NumericAnimationVariable nv = new NumericAnimationVariable(isInterpolationEnabled);
        VariableFactory.applyNewVariableDefaults((Variable)nv);
        if (cv != null) {
            nv.connectFrom(cv);
            nv.setLocale(cv.getLocale());
            nv.setSortStrategy(cv.getSortStrategy());
            nv.setLabel(cv.getLabel());
            nv.setFormat(cv.getFormat());
        }
        return nv;
    }

    public static Variable newVariable(Variable cv) {
        if (cv instanceof NumericVariable) {
            return VariableFactory.newNumericVariable((NumericVariable)cv);
        }
        if (cv instanceof StringVariable) {
            return VariableFactory.newStringVariable(cv);
        }
        return null;
    }

    public abstract Object getModel();

    public abstract Variable newVariable(VariableDefinition var1) throws IllegalStateException;

    public abstract NumericVariable newHighVariable(VariableDefinition var1) throws IllegalStateException;

    public abstract NumericVariable newLowVariable(VariableDefinition var1) throws IllegalStateException;

    public abstract NumericVariable newTargetVariable(VariableDefinition var1) throws IllegalStateException;

    public abstract boolean isOLAPData();

    public abstract boolean isRelationalData();

    public abstract Object clone();

    public VariableFactory() {
        this(null, 10475);
    }

    public VariableFactory(Locale newLocale, int newSortStrategy) {
        this.setLocale(newLocale);
        this.setSortStrategy(newSortStrategy);
    }

    public final void setLocale(Locale newLocale) {
        this.locale = newLocale == null ? Locale.getDefault() : newLocale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final void setSortStrategy(int newSortStrategy) {
        if (GraphConstants.SORT_STRATEGY.isValid(newSortStrategy)) {
            this.sortStrategy = newSortStrategy;
        }
    }

    public final int getSortStrategy() {
        return this.sortStrategy;
    }

    protected static void applySortStrategy(Variable variable, int sortStrategy, Locale locale) {
        int gtkSortStrategy = sortStrategy == 10476 ? 1002 : 1001;
        variable.setSortStrategy(gtkSortStrategy);
        variable.setLocale(locale);
    }

    public SASFormat newSASFormat(String formatName) {
        return Util.newSASFormat(formatName, this.getLocale());
    }

    public static GTKFormat newGTKFormat(String formatName, Locale locale) {
        return GTKUtil.newGTKFormat(formatName, locale);
    }

    protected static GTKFormat _applyFormat(Variable variable, String formatName, Locale locale) {
        GTKFormat gtkFormat = null;
        if (formatName != null && (formatName = formatName.trim()).length() > 0 && !"$.".equals(formatName)) {
            gtkFormat = VariableFactory.newGTKFormat(formatName, locale);
        }
        if (gtkFormat != null) {
            variable.setFormat(gtkFormat);
        }
        return gtkFormat;
    }
}

