/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AnalysisVariableList;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ClassificationVariableList;
import com.sas.graphics.components.PlotVariable;
import com.sas.graphics.components.PlotVariableList;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.SummarizedVariable;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.ConstantVariable;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SummarizedVariableDefinition;
import com.sas.graphics.util.gtk.StringVariable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;

public class VariableDefinition
implements Cloneable {
    private final Object value;
    private final String columnName;
    private final Integer columnIndex;
    private final String label;
    private final String format;
    private final String informat;
    private final Integer sort;
    private final Object highValue;
    private final String highColumnName;
    private final Integer highColumnIndex;
    private final String highLabel;
    private final Object lowValue;
    private final String lowColumnName;
    private final Integer lowColumnIndex;
    private final String lowLabel;
    private final Object targetValue;
    private final String targetColumnName;
    private final Integer targetColumnIndex;
    private final String targetLabel;
    private final VariableDefinition next;
    private final int variant;
    private final CategorizationModel categorizationModel;
    private final SegmentedRangeStyle segmentedRangeStyle;
    private ModelColumnInfo columnModelColumnInfo;
    private ModelColumnInfo highColumnModelColumnInfo;
    private ModelColumnInfo lowColumnModelColumnInfo;
    private ModelColumnInfo targetColumnModelColumnInfo;
    public static final int NA = 0;
    public static final int NUMERIC = 1;
    public static final int STRING = 2;
    public static final int NOT_GROUP_VARIABLE = 4;
    public static final int SUBGROUP = 8;
    public static final int CALCULATE_UNIQUE_VALUES_BY_UNFORMATTED_VALUE = 16;

    public VariableDefinition(VariableDefinition fromVarDef) {
        this.columnName = fromVarDef.columnName;
        this.columnIndex = fromVarDef.columnIndex;
        this.value = fromVarDef.value;
        this.format = fromVarDef.format;
        this.informat = fromVarDef.informat;
        this.label = fromVarDef.label;
        this.sort = fromVarDef.sort;
        this.categorizationModel = fromVarDef.categorizationModel;
        this.segmentedRangeStyle = fromVarDef.segmentedRangeStyle;
        this.highValue = fromVarDef.highValue;
        this.highColumnName = fromVarDef.highColumnName;
        this.highColumnIndex = fromVarDef.highColumnIndex;
        this.highLabel = fromVarDef.highLabel;
        this.lowValue = fromVarDef.lowValue;
        this.lowColumnName = fromVarDef.lowColumnName;
        this.lowColumnIndex = fromVarDef.lowColumnIndex;
        this.lowLabel = fromVarDef.lowLabel;
        this.targetValue = fromVarDef.targetValue;
        this.targetColumnName = fromVarDef.targetColumnName;
        this.targetColumnIndex = fromVarDef.targetColumnIndex;
        this.targetLabel = fromVarDef.targetLabel;
        this.variant = fromVarDef.variant;
        this.next = fromVarDef.next != null ? new VariableDefinition(fromVarDef.next) : null;
    }

    public VariableDefinition asLegendVariableDefinition() {
        VariableDefinition newNext = this.getNext() != null ? this.getNext().asLegendVariableDefinition() : null;
        Integer newSort = new Integer(10401);
        int newVariant = this.getVariant();
        return new VariableDefinition(this, newSort, newVariant, newNext);
    }

    protected VariableDefinition(VariableDefinition fromVarDef, Integer newSort, int newVariant, VariableDefinition newNext) {
        this.columnName = fromVarDef.columnName;
        this.columnIndex = fromVarDef.columnIndex;
        this.value = fromVarDef.value;
        this.format = fromVarDef.format;
        this.informat = fromVarDef.informat;
        this.label = fromVarDef.label;
        this.sort = newSort;
        this.categorizationModel = fromVarDef.categorizationModel;
        this.segmentedRangeStyle = fromVarDef.segmentedRangeStyle;
        this.highValue = fromVarDef.highValue;
        this.highColumnName = fromVarDef.highColumnName;
        this.highColumnIndex = fromVarDef.highColumnIndex;
        this.highLabel = fromVarDef.highLabel;
        this.lowValue = fromVarDef.lowValue;
        this.lowColumnName = fromVarDef.lowColumnName;
        this.lowColumnIndex = fromVarDef.lowColumnIndex;
        this.lowLabel = fromVarDef.lowLabel;
        this.targetValue = fromVarDef.targetValue;
        this.targetColumnName = fromVarDef.targetColumnName;
        this.targetColumnIndex = fromVarDef.targetColumnIndex;
        this.targetLabel = fromVarDef.targetLabel;
        this.variant = newVariant;
        this.next = newNext;
    }

    public VariableDefinition(Integer newColumnIndex, String newFormat, VariableDefinition newNext, int newVariant) {
        this.columnName = null;
        this.columnIndex = newColumnIndex;
        this.value = null;
        this.format = newFormat;
        this.informat = null;
        this.label = null;
        this.next = newNext;
        this.sort = null;
        this.categorizationModel = null;
        this.segmentedRangeStyle = null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = null;
        this.highLabel = null;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = null;
        this.lowLabel = null;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = null;
        this.targetLabel = null;
        this.variant = newVariant;
    }

    public VariableDefinition(String newColumnName, String newFormat, VariableDefinition newNext, int newVariant) {
        this.columnName = newColumnName;
        this.columnIndex = null;
        this.value = null;
        this.format = newFormat;
        this.informat = null;
        this.label = null;
        this.next = newNext;
        this.sort = null;
        this.categorizationModel = null;
        this.segmentedRangeStyle = null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = null;
        this.highLabel = null;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = null;
        this.lowLabel = null;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = null;
        this.targetLabel = null;
        this.variant = newVariant;
    }

    public VariableDefinition(String newColumnName, String newFormat, String newInformat, String newLabel, Integer newSort, String newHighColumnName, String newHighLabel, String newLowColumnName, String newLowLabel, String newTargetColumnName, String newTargetLabel, VariableDefinition newNext, int newVariant) {
        this.columnName = newColumnName;
        this.columnIndex = null;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = null;
        this.segmentedRangeStyle = null;
        this.highValue = null;
        this.highColumnName = newHighColumnName;
        this.highColumnIndex = null;
        this.highLabel = newHighLabel;
        this.lowValue = null;
        this.lowColumnName = newLowColumnName;
        this.lowColumnIndex = null;
        this.lowLabel = newLowLabel;
        this.targetValue = null;
        this.targetColumnName = newTargetColumnName;
        this.targetColumnIndex = null;
        this.targetLabel = newTargetLabel;
        this.variant = newVariant;
    }

    public VariableDefinition(String newColumnName, String newFormat, String newInformat, String newLabel, Integer newSort, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, String newHighColumnName, String newHighLabel, String newLowColumnName, String newLowLabel, String newTargetColumnName, String newTargetLabel, VariableDefinition newNext, int newVariant) {
        this.columnName = newColumnName;
        this.columnIndex = null;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = newCategorizationModel;
        this.segmentedRangeStyle = this.categorizationModel != null ? newSegmentedRangeStyle : null;
        this.highValue = null;
        this.highColumnName = newHighColumnName;
        this.highColumnIndex = null;
        this.highLabel = newHighLabel;
        this.lowValue = null;
        this.lowColumnName = newLowColumnName;
        this.lowColumnIndex = null;
        this.lowLabel = newLowLabel;
        this.targetValue = null;
        this.targetColumnName = newTargetColumnName;
        this.targetColumnIndex = null;
        this.targetLabel = newTargetLabel;
        this.variant = newVariant;
    }

    public VariableDefinition(Integer newColumnIndex, String newFormat, String newInformat, String newLabel, Integer newSort, Integer newHighColumnIndex, String newHighLabel, Integer newLowColumnIndex, String newLowLabel, Integer newTargetColumnIndex, String newTargetLabel, VariableDefinition newNext, int newVariant) {
        this.columnName = null;
        this.columnIndex = newColumnIndex;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = null;
        this.segmentedRangeStyle = null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = newHighColumnIndex;
        this.highLabel = newHighLabel;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = newLowColumnIndex;
        this.lowLabel = newLowLabel;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = newTargetColumnIndex;
        this.targetLabel = newTargetLabel;
        this.variant = newVariant;
    }

    public VariableDefinition(Integer newColumnIndex, String newFormat, String newInformat, String newLabel, Integer newSort, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, Integer newHighColumnIndex, String newHighLabel, Integer newLowColumnIndex, String newLowLabel, Integer newTargetColumnIndex, String newTargetLabel, VariableDefinition newNext, int newVariant) {
        this.columnName = null;
        this.columnIndex = newColumnIndex;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = newCategorizationModel;
        this.segmentedRangeStyle = this.categorizationModel != null ? newSegmentedRangeStyle : null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = newHighColumnIndex;
        this.highLabel = newHighLabel;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = newLowColumnIndex;
        this.lowLabel = newLowLabel;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = newTargetColumnIndex;
        this.targetLabel = newTargetLabel;
        this.variant = newVariant;
    }

    public VariableDefinition(String newColumnName, String newFormat, String newInformat, String newLabel, Integer newSort, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, VariableDefinition newNext, int newVariant) {
        this.columnName = newColumnName;
        this.columnIndex = null;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = newCategorizationModel;
        this.segmentedRangeStyle = this.categorizationModel != null ? newSegmentedRangeStyle : null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = null;
        this.highLabel = null;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = null;
        this.lowLabel = null;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = null;
        this.targetLabel = null;
        this.variant = newVariant;
    }

    public VariableDefinition(Integer newColumnIndex, String newFormat, String newInformat, String newLabel, Integer newSort, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, VariableDefinition newNext, int newVariant) {
        this.columnName = null;
        this.columnIndex = newColumnIndex;
        this.value = null;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = newNext;
        this.sort = newSort;
        this.categorizationModel = newCategorizationModel;
        this.segmentedRangeStyle = this.categorizationModel != null ? newSegmentedRangeStyle : null;
        this.highValue = null;
        this.highColumnName = null;
        this.highColumnIndex = null;
        this.highLabel = null;
        this.lowValue = null;
        this.lowColumnName = null;
        this.lowColumnIndex = null;
        this.lowLabel = null;
        this.targetValue = null;
        this.targetColumnName = null;
        this.targetColumnIndex = null;
        this.targetLabel = null;
        this.variant = newVariant;
    }

    public VariableDefinition(Object newValue, String newFormat, String newInformat, String newLabel, Object newHighValue, String newHighLabel, Object newLowValue, String newLowLabel, Object newTargetValue, String newTargetLabel, int newVariant) {
        this.columnName = null;
        this.columnIndex = null;
        this.value = newValue;
        this.format = newFormat;
        this.informat = newInformat;
        this.label = newLabel;
        this.next = null;
        this.sort = null;
        this.categorizationModel = null;
        this.segmentedRangeStyle = null;
        this.highValue = newHighValue;
        this.highColumnName = null;
        this.highColumnIndex = null;
        this.highLabel = null;
        this.lowValue = newLowValue;
        this.lowColumnName = null;
        this.lowColumnIndex = null;
        this.lowLabel = null;
        this.targetValue = newTargetValue;
        this.targetColumnName = null;
        this.targetColumnIndex = null;
        this.targetLabel = null;
        this.variant = newVariant;
    }

    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="this is legacy code and require major restructuring for this violation")
    public Object clone() {
        if (this.value != null) {
            return new VariableDefinition(this.value, this.format, this.informat, this.label, this.highValue, this.highLabel, this.lowValue, this.lowLabel, this.targetValue, this.targetLabel, this.variant);
        }
        if (this.columnIndex != null) {
            return new VariableDefinition(this.columnIndex, this.format, this.informat, this.label, this.sort, this.highColumnIndex, this.highLabel, this.lowColumnIndex, this.lowLabel, this.targetColumnIndex, this.targetLabel, this.next == null ? null : (VariableDefinition)this.next.clone(), this.variant);
        }
        return new VariableDefinition(this.columnName, this.format, this.informat, this.label, this.sort, this.highColumnName, this.highLabel, this.lowColumnName, this.lowLabel, this.targetColumnName, this.targetLabel, this.next == null ? null : (VariableDefinition)this.next.clone(), this.variant);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getColumnLabel() {
        return this.label;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getFormat() {
        return this.format;
    }

    public String getInformat() {
        return this.informat;
    }

    public VariableDefinition getNext() {
        return this.next;
    }

    public int getVariant() {
        return this.variant;
    }

    public Object getHighValue() {
        return this.highValue;
    }

    public String getHighColumnName() {
        return this.highColumnName;
    }

    public Integer getHighColumnIndex() {
        return this.highColumnIndex;
    }

    public String getHighLabel() {
        return this.highLabel;
    }

    public Object getLowValue() {
        return this.lowValue;
    }

    public String getLowColumnName() {
        return this.lowColumnName;
    }

    public Integer getLowColumnIndex() {
        return this.lowColumnIndex;
    }

    public String getLowLabel() {
        return this.lowLabel;
    }

    public Object getTargetValue() {
        return this.targetValue;
    }

    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public Integer getTargetColumnIndex() {
        return this.targetColumnIndex;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public int asGTKSort() {
        return VariableDefinition.asGTKSort(this.sort != null ? this.sort : 0);
    }

    public static int asGTKSort(int bipSort) {
        switch (bipSort) {
            default: {
                return 0;
            }
            case 10401: 
            case 10403: 
            case 10405: {
                return 1;
            }
            case 10402: 
            case 10404: 
            case 10406: 
        }
        return 2;
    }

    public boolean isSortByFormattedValue(com.sas.graphics.util.gtk.Variable v) {
        switch (this.sort != null ? this.sort : 0) {
            default: {
                return false;
            }
            case 10403: 
            case 10404: {
                return true;
            }
            case 10401: 
            case 10402: 
        }
        return v instanceof StringVariable;
    }

    public void setColumnModelColumnInfo(ModelColumnInfo modelColumnInfo) {
        this.columnModelColumnInfo = modelColumnInfo;
    }

    public ModelColumnInfo getColumnModelColumnInfo() {
        return this.columnModelColumnInfo;
    }

    public void setHighColumnModelColumnInfo(ModelColumnInfo modelColumnInfo) {
        this.highColumnModelColumnInfo = modelColumnInfo;
    }

    public ModelColumnInfo getHighColumnModelColumnInfo() {
        return this.highColumnModelColumnInfo;
    }

    public void setLowColumnModelColumnInfo(ModelColumnInfo modelColumnInfo) {
        this.lowColumnModelColumnInfo = modelColumnInfo;
    }

    public ModelColumnInfo getLowColumnModelColumnInfo() {
        return this.lowColumnModelColumnInfo;
    }

    public void setTargetColumnModelColumnInfo(ModelColumnInfo modelColumnInfo) {
        this.targetColumnModelColumnInfo = modelColumnInfo;
    }

    public ModelColumnInfo getTargetColumnModelColumnInfo() {
        return this.targetColumnModelColumnInfo;
    }

    public CategorizationModel getCategorizationModel() {
        return this.categorizationModel;
    }

    public SegmentedRangeStyle getSegmentedRangeStyle() {
        return this.segmentedRangeStyle;
    }

    public static class ModelColumnInfo {
        private String columnName = null;
        private String columnLabel = null;
        private int columnIndex = -1;
        private String columnFormat = null;

        public void setColumnName(String name) {
            this.columnName = name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnLabel(String label) {
            this.columnLabel = label;
        }

        public String getColumnLabel() {
            return this.columnLabel;
        }

        public void setColumnIndex(int index) {
            this.columnIndex = index;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnFormat(String format) {
            this.columnFormat = format;
        }

        public String getColumnFormat() {
            return this.columnFormat;
        }
    }

    public static abstract class Factory {
        private static final ArrayList uniArrayList = new ArrayList();

        public static final VariableDefinition newVariableDefinition(ConstantVariable constantVariable, int variant) {
            VariableDefinition vd = null;
            if (constantVariable != null) {
                vd = new VariableDefinition(constantVariable.getValue(), constantVariable.getFormat(), constantVariable.getInformat(), constantVariable.getLabel(), constantVariable.getHighValue(), constantVariable.getHighLabel(), constantVariable.getLowValue(), constantVariable.getLowLabel(), constantVariable.getTargetValue(), constantVariable.getTargetLabel(), variant);
            }
            return vd;
        }

        public static final VariableDefinition newVariableDefinition(Variable variable) {
            return Factory.newVariableDefinition(variable, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final VariableDefinition newVariableDefinition(Variable variable, int variant) {
            VariableDefinition vd = null;
            ArrayList arrayList = null;
            if (variable != null) {
                ArrayList arrayList2 = uniArrayList;
                synchronized (arrayList2) {
                    if (variable instanceof ClassificationVariableList) {
                        arrayList = ((ClassificationVariableList)variable).asArrayList();
                    } else if (variable instanceof AnalysisVariableList) {
                        arrayList = ((AnalysisVariableList)variable).asArrayList();
                    } else if (variable instanceof VariableList) {
                        arrayList = ((VariableList)variable).asArrayList();
                    } else if (variable instanceof PlotVariableList) {
                        arrayList = ((PlotVariableList)variable).asArrayList();
                    } else {
                        uniArrayList.clear();
                        uniArrayList.add(variable);
                        arrayList = uniArrayList;
                    }
                    for (int ii = arrayList.size() - 1; ii >= 0; --ii) {
                        String targetLabel;
                        Integer targetColumnIndex;
                        String targetColumnName;
                        String lowLabel;
                        Integer lowColumnIndex;
                        String lowColumnName;
                        String highLabel;
                        Integer highColumnIndex;
                        String highColumnName;
                        Variable v = (Variable)arrayList.get(ii);
                        String columnName = v.getColumnName();
                        Integer columnIndex = v.getColumnIndex() >= 0 ? new Integer(v.getColumnIndex()) : null;
                        String label = v.getLabel();
                        String format = v.getFormat();
                        String informat = v.getInformat();
                        CategorizationModel categorizationModel = v.getCategorizationModel();
                        SegmentedRangeStyle segmentedRangeStyle = v.getSegmentedRangeStyle();
                        if (format != null && format.trim().length() < 1) {
                            format = null;
                        }
                        if (informat != null && informat.trim().length() < 1) {
                            informat = null;
                        }
                        if (v instanceof ClassificationVariable) {
                            Integer sort = new Integer(((ClassificationVariable)v).getSort());
                            vd = columnName != null ? new ClassificationVariableDefinition(columnName, format, informat, label, sort, categorizationModel, segmentedRangeStyle, (ClassificationVariableDefinition)vd, variant) : (columnIndex != null ? new ClassificationVariableDefinition(columnIndex, format, informat, label, sort, categorizationModel, segmentedRangeStyle, (ClassificationVariableDefinition)vd, variant) : null);
                            continue;
                        }
                        if (v instanceof AnalysisVariable) {
                            AnalysisVariable av = (AnalysisVariable)v;
                            int statistic = av.getStatistic();
                            if (columnName != null && columnName.length() < 1) {
                                columnName = null;
                            }
                            if (columnName == null && columnIndex == null) {
                                switch (statistic) {
                                    default: {
                                        statistic = 10502;
                                    }
                                    case 10502: 
                                    case 10503: 
                                    case 10504: 
                                    case 10505: 
                                }
                            }
                            Integer stat = new Integer(statistic);
                            if (statistic == 10502 || statistic == 10504) {
                                format = null;
                            } else if (!(statistic != 10507 && statistic != 10503 && statistic != 10505 && statistic != 10509 || format == null || format.toUpperCase().startsWith("PERCENT"))) {
                                format = null;
                            }
                            if (columnName == null && columnIndex == null) {
                                if (label == null) {
                                    switch (statistic) {
                                        case 10502: {
                                            label = RB.getStringResource("frequency.txt");
                                            break;
                                        }
                                        case 10504: {
                                            label = RB.getStringResource("cumulativeFrequency.txt");
                                            break;
                                        }
                                        case 10503: {
                                            label = RB.getStringResource("percentFrequency.txt");
                                            break;
                                        }
                                        case 10505: {
                                            label = RB.getStringResource("cumulativePercentFrequency.txt");
                                        }
                                    }
                                }
                                vd = new FreqVariableDefinition(format, label, stat, categorizationModel, segmentedRangeStyle, (AnalysisVariableDefinition)vd, variant);
                                continue;
                            }
                            if (v instanceof SummarizedVariable) {
                                String freqColumnName = ((SummarizedVariable)av).getFreqColumnName();
                                Integer freqColumnIndex = ((SummarizedVariable)av).getFreqColumnIndex() >= 0 ? new Integer(((SummarizedVariable)av).getFreqColumnIndex()) : null;
                                highColumnName = av.getHighColumnName();
                                highColumnIndex = av.getHighColumnIndex() >= 0 ? new Integer(av.getHighColumnIndex()) : null;
                                highLabel = av.getHighLabel();
                                lowColumnName = av.getLowColumnName();
                                lowColumnIndex = av.getLowColumnIndex() >= 0 ? new Integer(av.getLowColumnIndex()) : null;
                                lowLabel = av.getLowLabel();
                                targetColumnName = av.getTargetColumnName();
                                targetColumnIndex = av.getTargetColumnIndex() >= 0 ? new Integer(av.getTargetColumnIndex()) : null;
                                targetLabel = av.getTargetLabel();
                                Integer varStat = null;
                                switch (statistic) {
                                    default: {
                                        varStat = new Integer(10506);
                                        break;
                                    }
                                    case 10501: {
                                        varStat = new Integer(10501);
                                        break;
                                    }
                                    case 10502: 
                                    case 10503: 
                                    case 10504: 
                                    case 10505: {
                                        varStat = new Integer(10502);
                                    }
                                }
                                vd = columnName != null ? new SummarizedVariableDefinition(columnName, freqColumnName, freqColumnIndex, format, informat, label, null, stat, varStat, highColumnName, highLabel, lowColumnName, lowLabel, targetColumnName, targetLabel, (AnalysisVariableDefinition)vd, variant) : (columnIndex != null ? new SummarizedVariableDefinition(columnIndex, freqColumnName, freqColumnIndex, format, informat, label, null, stat, varStat, highColumnIndex, highLabel, lowColumnIndex, lowLabel, targetColumnIndex, targetLabel, (AnalysisVariableDefinition)vd, variant) : null);
                                continue;
                            }
                            highColumnName = av.getHighColumnName();
                            highColumnIndex = av.getHighColumnIndex() >= 0 ? new Integer(av.getHighColumnIndex()) : null;
                            highLabel = av.getHighLabel();
                            lowColumnName = av.getLowColumnName();
                            lowColumnIndex = av.getLowColumnIndex() >= 0 ? new Integer(av.getLowColumnIndex()) : null;
                            lowLabel = av.getLowLabel();
                            targetColumnName = av.getTargetColumnName();
                            targetColumnIndex = av.getTargetColumnIndex() >= 0 ? new Integer(av.getTargetColumnIndex()) : null;
                            targetLabel = av.getTargetLabel();
                            vd = columnName != null ? new AnalysisVariableDefinition(columnName, format, informat, label, null, stat, categorizationModel, segmentedRangeStyle, highColumnName, highLabel, lowColumnName, lowLabel, targetColumnName, targetLabel, (AnalysisVariableDefinition)vd, variant) : (columnIndex != null ? new AnalysisVariableDefinition(columnIndex, format, informat, label, null, stat, categorizationModel, segmentedRangeStyle, highColumnIndex, highLabel, lowColumnIndex, lowLabel, targetColumnIndex, targetLabel, (AnalysisVariableDefinition)vd, variant) : null);
                            continue;
                        }
                        if (v instanceof PlotVariable) {
                            PlotVariable pv = (PlotVariable)v;
                            highColumnName = pv.getHighColumnName();
                            highColumnIndex = pv.getHighColumnIndex() >= 0 ? new Integer(pv.getHighColumnIndex()) : null;
                            highLabel = pv.getHighLabel();
                            lowColumnName = pv.getLowColumnName();
                            lowColumnIndex = pv.getLowColumnIndex() >= 0 ? new Integer(pv.getLowColumnIndex()) : null;
                            lowLabel = pv.getLowLabel();
                            targetColumnName = pv.getTargetColumnName();
                            targetColumnIndex = pv.getTargetColumnIndex() >= 0 ? new Integer(pv.getTargetColumnIndex()) : null;
                            targetLabel = pv.getTargetLabel();
                            vd = columnName != null ? new VariableDefinition(columnName, format, informat, label, null, highColumnName, highLabel, lowColumnName, lowLabel, targetColumnName, targetLabel, vd, variant) : (columnIndex != null ? new VariableDefinition(columnIndex, format, informat, label, null, highColumnIndex, highLabel, lowColumnIndex, lowLabel, targetColumnIndex, targetLabel, vd, variant) : null);
                            continue;
                        }
                        vd = columnName != null ? new VariableDefinition(columnName, format, informat, label, null, null, null, null, null, null, null, vd, variant) : (columnIndex != null ? new VariableDefinition(columnIndex, format, informat, label, null, null, null, null, null, null, null, vd, variant) : null);
                    }
                    uniArrayList.clear();
                }
            }
            return vd;
        }

        public static final VariableDefinition[] newVariableDefinition(ConstantVariable[] constantVars, int variant) {
            VariableDefinition[] defs = null;
            if (constantVars != null) {
                defs = new VariableDefinition[constantVars.length];
                for (int ii = 0; ii < constantVars.length; ++ii) {
                    defs[ii] = constantVars[ii] != null ? Factory.newVariableDefinition(constantVars[ii], variant) : null;
                }
            }
            return defs;
        }

        public static final VariableDefinition[] newVariableDefinition(Variable[] vars) {
            return Factory.newVariableDefinition(vars, 0);
        }

        public static final VariableDefinition[] newVariableDefinition(Variable[] vars, int variant) {
            VariableDefinition[] defs = null;
            if (vars != null) {
                defs = new VariableDefinition[vars.length];
                for (int ii = 0; ii < vars.length; ++ii) {
                    defs[ii] = vars[ii] != null ? Factory.newVariableDefinition(vars[ii], variant) : null;
                }
            }
            return defs;
        }
    }
}

