/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AlignableComponentInterface;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GenericActionProviderView;
import com.sas.graphics.util.cell.GridDimension;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.MultiStyleStringComponent;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ValuePane
extends HierarchicalPane {
    public static final int COLUMN_ROLE = 0;
    public static final int ROW_ROLE = 1;
    public static final int CATEGORY_ROLE = 2;
    public static final int SUBGROUP_ROLE = 3;
    public static final int GROUP_ROLE = 4;
    private final ValueComponentFactory valueComponentFactory;
    private final LineStyle frameLineStyle;
    private static final int NODE_PROCESSING_POLICY_INCLUDE_ALL_VALUES = 0;
    private static final int NODE_PROCESSING_POLICY_INCLUDE_ONLY_CATEGORY_VALUES = 1;
    private static final int NODE_PROCESSING_POLICY_EXCLUDE_CATEGORY_VALUES = 2;

    public ValuePane(ValueTree tree, LineStyle frameLineStyle, TextStyle textStyle, ListSelectionModel selectionModel, Channel channel) {
        this(tree, null, frameLineStyle, textStyle, selectionModel, null, channel);
    }

    public ValuePane(ValueTree tree, LineStyle frameLineStyle, TextStyle textStyle, ListSelectionModel selectionModel, SwingActionProvider actionProvider, Channel channel) {
        this(tree, null, frameLineStyle, textStyle, selectionModel, actionProvider, channel);
    }

    public ValuePane(ValueTree tree, LineStyle frameLineStyle, ValueComponentFactory valueComponentFactory, Channel channel) {
        this(tree, valueComponentFactory, frameLineStyle, null, null, null, channel);
    }

    private ValuePane(ValueTree tree, ValueComponentFactory valueComponentFactory, LineStyle frameLineStyle, TextStyle textStyle, ListSelectionModel selectionModel, SwingActionProvider actionProvider, Channel channel) {
        super(tree);
        this.valueComponentFactory = valueComponentFactory != null ? valueComponentFactory : new DefaultValueComponentFactory(textStyle, selectionModel, actionProvider, this, channel);
        this.frameLineStyle = frameLineStyle;
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        Enumeration e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DataTreeGroupNode node;
            JComponent valueComponent;
            Object n = e.nextElement();
            if (!(n instanceof DataTreeGroupNode) || (valueComponent = this.valueComponentFactory.newValueComponent((TreeNode)(node = (DataTreeGroupNode)n))) == null) continue;
            this.contentPanel.add(valueComponent);
            this.componentMap.put(node, valueComponent);
        }
        this.applyFrame(1);
    }

    public void applyFrame(int growthDirection) {
        boolean isReverse;
        boolean isVertical;
        if (this.tree == null) {
            return;
        }
        switch (growthDirection) {
            default: {
                isVertical = false;
                isReverse = true;
                break;
            }
            case 5: {
                isVertical = false;
                isReverse = false;
                break;
            }
            case 3: {
                isVertical = true;
                isReverse = false;
                break;
            }
            case 7: {
                isVertical = true;
                isReverse = true;
            }
        }
        if (this.frameLineStyle.getVisibilityPolicy() != 10202) {
            int f = (int)this.frameLineStyle.getThickness().getMagnitude((Object)"px");
            DataTreeGroupNode root = (DataTreeGroupNode)this.tree.getRoot();
            Enumeration e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DataTreeGroupNode node;
                JComponent valueComponent;
                Object n = e.nextElement();
                if (!(n instanceof DataTreeGroupNode) || (valueComponent = (JComponent)this.componentMap.get(node = (DataTreeGroupNode)n)) == null) continue;
                if ((valueComponent.getSize().getWidth() < 3.0 || valueComponent.getSize().getHeight() < 3.0) && (!(valueComponent instanceof StringComponent) || ((StringComponent)valueComponent).canFrameBeTurnedOff())) {
                    valueComponent.setBorder(null);
                    continue;
                }
                int t = f;
                int l = 0;
                int b = 0;
                int r = f;
                if (node.isLeaf()) {
                    b = f;
                }
                boolean isFarLeft = node.getPreviousSibling() == null;
                for (DataTreeGroupNode parent = (DataTreeGroupNode)node.getParent(); isFarLeft && parent != null; parent = (DataTreeGroupNode)parent.getParent()) {
                    isFarLeft = parent.getPreviousSibling() == null;
                }
                if (isFarLeft) {
                    l = f;
                }
                MatteBorder border = isVertical ? (isReverse ? new MatteBorder(l, b, r, t, this.frameLineStyle.getColor()) : new MatteBorder(l, t, r, b, this.frameLineStyle.getColor())) : (isReverse ? new MatteBorder(b, l, t, r, this.frameLineStyle.getColor()) : new MatteBorder(t, l, b, r, this.frameLineStyle.getColor()));
                valueComponent.setBorder(border);
            }
        }
    }

    public JComponent getValueComponent(TreeNode node) {
        return (JComponent)this.componentMap.get(node);
    }

    public PlotValueZone[] toPlotValueZones(JComponent ancestor, int role) {
        return this.toPlotValueZoneArray(ancestor, role, 0);
    }

    public ChartValueZone[] toChartValueZones(Component ancestor, int role) {
        return this.toChartValueZones(ancestor, role, 0);
    }

    public ChartValueZone[] toChartValueZones_IncludeOnlyCategoryValues(Component ancestor, int role) {
        return this.toChartValueZones(ancestor, role, 1);
    }

    public ChartValueZone[] toChartValueZones_ExcludeCategoryValues(Component ancestor, int role) {
        return this.toChartValueZones(ancestor, role, 2);
    }

    private ChartValueZone[] toChartValueZones(Component ancestor, int role, int nodeProcessingPolicy) {
        if (!this.isVisible()) {
            return null;
        }
        Rectangle b = this.getBounds();
        if (b.width < 1 || b.height < 1) {
            return null;
        }
        return this.toChartValueZoneArray(ancestor, role, nodeProcessingPolicy);
    }

    private ChartValueZone[] toChartValueZoneArray(Component ancestor, int role, int nodeProcessingPolicy) {
        return (ChartValueZone[])this.toValueZoneArray(ancestor, role, ChartValueZone.class, nodeProcessingPolicy);
    }

    private PlotValueZone[] toPlotValueZoneArray(Component ancestor, int role, int nodeProcessingPolicy) {
        return (PlotValueZone[])this.toValueZoneArray(ancestor, role, PlotValueZone.class, nodeProcessingPolicy);
    }

    private Object toValueZoneArray(Component ancestor, int role, Class valueZoneType, int nodeProcessingPolicy) {
        Variable categoryVariable;
        DataTreeInfo dataTreeInfo;
        int groupVariableCount;
        Container parent;
        if (this.tree == null) {
            return null;
        }
        if (role == 2 && nodeProcessingPolicy == 1) {
            throw new IllegalStateException();
        }
        Rectangle bounds = this.getBounds();
        int xAdj = bounds.x;
        int yAdj = bounds.y;
        for (parent = this.getParent(); parent != null && parent != ancestor; parent = parent.getParent()) {
            bounds = parent.getBounds();
            xAdj += bounds.x;
            yAdj += bounds.y;
        }
        if (parent == null) {
            xAdj = 0;
            yAdj = 0;
        }
        bounds = this.contentPanel.getBounds();
        xAdj += bounds.x;
        yAdj += bounds.y;
        ArrayList<DataZone> zoneList = new ArrayList<DataZone>();
        DataTreeGroupNode root = (DataTreeGroupNode)this.tree.getRoot();
        String categoryHierarchy = null;
        if (nodeProcessingPolicy != 0 && root.getValue() instanceof DataTreeInfo && (groupVariableCount = (dataTreeInfo = (DataTreeInfo)root.getValue()).getGroupVariableCount()) > 0 && (categoryVariable = dataTreeInfo.getGroupVariableAt(groupVariableCount - 1)) instanceof OLAPLevelVariable) {
            categoryHierarchy = ((OLAPLevelVariable)categoryVariable).getHierachyName();
        }
        Enumeration e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            ValueList rowValueList;
            ValueList columnValueList;
            JComponent valueComponent;
            DataTreeGroupNode node = (DataTreeGroupNode)e.nextElement();
            if (node.isRoot()) continue;
            if (nodeProcessingPolicy != 0 && valueZoneType == ChartValueZone.class) {
                boolean isCategoryNode;
                boolean bl = isCategoryNode = categoryHierarchy != null ? categoryHierarchy.equals(Util.DataTreeGroupNodeUtil.getHierarchyName(node)) : node.isLeaf();
                if (!isCategoryNode ? nodeProcessingPolicy == 1 : nodeProcessingPolicy == 2) continue;
            }
            if ((valueComponent = this.getValueComponent((TreeNode)node)) == null) continue;
            bounds = valueComponent.getBounds();
            bounds.x += xAdj;
            bounds.y += yAdj;
            TupleElementInterface tupleElement = null;
            if (node.getValue() instanceof TupleElementInterface) {
                tupleElement = (TupleElementInterface)node.getValue();
            }
            if (valueZoneType == ChartValueZone.class) {
                columnValueList = null;
                rowValueList = null;
                ValueList categoryValueList = null;
                ValueList subgroupValueList = null;
                block0 : switch (nodeProcessingPolicy) {
                    default: {
                        ValueList valueList = Util.DataTreeGroupNodeUtil.toValueList(node);
                        switch (role) {
                            default: {
                                columnValueList = valueList;
                                break block0;
                            }
                            case 1: {
                                rowValueList = valueList;
                                break block0;
                            }
                            case 2: {
                                categoryValueList = valueList;
                                break block0;
                            }
                            case 3: 
                        }
                        subgroupValueList = valueList;
                        break;
                    }
                    case 1: {
                        categoryValueList = Util.DataTreeGroupNodeUtil.toValueList_pathOfThisHierarchy(node);
                        ValueList nonCategoryValueList = Util.DataTreeGroupNodeUtil.toValueList_pathNotOfThisHierarchy(node);
                        switch (role) {
                            default: {
                                columnValueList = nonCategoryValueList;
                                break block0;
                            }
                            case 1: 
                        }
                        rowValueList = nonCategoryValueList;
                    }
                }
                ChartValueZone chartValueZone = new ChartValueZone(bounds, tupleElement, columnValueList, rowValueList, categoryValueList, subgroupValueList);
                zoneList.add(chartValueZone);
                continue;
            }
            if (valueZoneType == PlotValueZone.class) {
                columnValueList = null;
                rowValueList = null;
                ValueList xValueList = null;
                ValueList yValueList = null;
                ValueList y2ValueList = null;
                ValueList sizeValueList = null;
                ValueList groupValueList = null;
                ValueList valueList = Util.DataTreeGroupNodeUtil.toValueList(node);
                switch (role) {
                    default: {
                        columnValueList = valueList;
                        break;
                    }
                    case 1: {
                        rowValueList = valueList;
                        break;
                    }
                    case 4: {
                        groupValueList = valueList;
                    }
                }
                PlotValueZone plotValueZone = new PlotValueZone(bounds, tupleElement, columnValueList, rowValueList, xValueList, yValueList, y2ValueList, sizeValueList, groupValueList);
                zoneList.add(plotValueZone);
                continue;
            }
            throw new IllegalStateException("Bad class.");
        }
        if (valueZoneType == ChartValueZone.class) {
            return zoneList.toArray(new ChartValueZone[zoneList.size()]);
        }
        if (valueZoneType == PlotValueZone.class) {
            return zoneList.toArray(new PlotValueZone[zoneList.size()]);
        }
        return null;
    }

    public static GridDimension getPreferredGridSize(ValuePane valuePane, int growthDirection) {
        int yCellCount;
        int xCellCount;
        GridDimension bounds = new GridDimension();
        if (valuePane == null) {
            return bounds;
        }
        ValueTree tree = valuePane.getTree();
        if (tree == null) {
            return bounds;
        }
        valuePane.applyFrame(growthDirection);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        boolean isVertical = growthDirection == 3 || growthDirection == 7;
        ArrayList path = new ArrayList();
        DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
        int leafCount = leaves.length;
        int maxLeafDepth = 0;
        for (int i = 0; i < leafCount; ++i) {
            ValuePane.makePath((DataTreeGroupNode)leaves[i], path);
            int leafDepth = 0;
            for (int j = 0; j < path.size(); ++j) {
                DataTreeGroupNode node = (DataTreeGroupNode)path.get(j);
                leafDepth += ValuePane.computeLevelSpan(node);
            }
            if (leafDepth <= maxLeafDepth) continue;
            maxLeafDepth = leafDepth;
        }
        if (isVertical) {
            xCellCount = maxLeafDepth;
            yCellCount = leafCount;
        } else {
            yCellCount = maxLeafDepth;
            xCellCount = leafCount;
        }
        bounds.setGridSize(xCellCount, !isVertical, yCellCount, isVertical);
        int xCells = 0;
        int yCells = 0;
        for (int i = 0; i < leafCount; ++i) {
            ValuePane.makePath((DataTreeGroupNode)leaves[i], path);
            if (isVertical) {
                xCells = 0;
            } else {
                yCells = 0;
            }
            for (int j = 0; j < path.size(); ++j) {
                DataTreeGroupNode node = (DataTreeGroupNode)path.get(j);
                JComponent component = valuePane.getValueComponent((TreeNode)node);
                if (component == null) continue;
                Dimension cps = component.getPreferredSize();
                int levelSpan = ValuePane.computeLevelSpan(node);
                Insets outerMargin = ValuePane.computeOuterMargin(node, growthDirection);
                if (isVertical) {
                    bounds.mergeColWidth(xCells + outerMargin.top, cps.width);
                    bounds.mergeRowHeight(yCells, cps.height);
                    xCells += levelSpan;
                    continue;
                }
                bounds.mergeColWidth(xCells, cps.width);
                bounds.mergeRowHeight(yCells + outerMargin.top, cps.height);
                yCells += levelSpan;
            }
            if (isVertical) {
                ++yCells;
                continue;
            }
            ++xCells;
        }
        return bounds;
    }

    public static Dimension getPreferredSize(ValuePane valuePane, int growthDirection) {
        if (valuePane != null && valuePane.getTree() != null) {
            valuePane.applyFrame(growthDirection);
            DataTreeGroupNode root = (DataTreeGroupNode)valuePane.getTree().getRoot();
            Dimension preferredSize = new Dimension(0, 0);
            Enumeration e = root.breadthFirstEnumeration();
            int leafLevelWidth = -1;
            int leafLevelHeight = -1;
            while (e.hasMoreElements()) {
                DataTreeGroupNode node = (DataTreeGroupNode)e.nextElement();
                boolean isLeaf = node.isLeaf();
                JComponent component = valuePane.getValueComponent((TreeNode)node);
                if (component == null) continue;
                Dimension ps = component.getPreferredSize();
                if (isLeaf) {
                    if (growthDirection == 1 || growthDirection == 5) {
                        leafLevelHeight = Math.max(ps.height, leafLevelHeight);
                        if (preferredSize.width >= ps.width) continue;
                        preferredSize.width = ps.width;
                        continue;
                    }
                    leafLevelWidth = Math.max(ps.width, leafLevelWidth);
                    if (preferredSize.height >= ps.height) continue;
                    preferredSize.height = ps.height;
                    continue;
                }
                if (preferredSize.height < ps.height) {
                    preferredSize.height = ps.height;
                }
                if (preferredSize.width >= ps.width) continue;
                preferredSize.width = ps.width;
            }
            if (root.getChildCount() > 0) {
                int frameThickness = 0;
                if (valuePane.frameLineStyle.getVisibilityPolicy() != 10202) {
                    frameThickness = (int)valuePane.frameLineStyle.getThickness().getMagnitude((Object)"px") + 1;
                }
                preferredSize.width += frameThickness;
                preferredSize.height += frameThickness;
                leafLevelHeight += frameThickness;
                leafLevelWidth += frameThickness;
                int leafCount = root.getLeafCount();
                int depth = root.getDepth();
                switch (growthDirection) {
                    default: {
                        return new Dimension(leafCount * preferredSize.width, (depth - 1) * preferredSize.height + leafLevelHeight);
                    }
                    case 3: 
                    case 7: 
                }
                return new Dimension((depth - 1) * preferredSize.width + leafLevelWidth, leafCount * preferredSize.height);
            }
        }
        return new Dimension(0, 0);
    }

    private static Insets computeOuterMargin(DataTreeGroupNode node, int growthDirection) {
        Insets outerMargin = new Insets(0, 0, 0, 0);
        Object v = node.getValue();
        if (v instanceof TupleElementInterface) {
            TupleElementInterface te = (TupleElementInterface)v;
            try {
                int ii;
                int spanDepth = te.getSpanDepth();
                int span = te.getSpan();
                block8: for (ii = 1; ii < spanDepth; ++ii) {
                    switch (growthDirection) {
                        default: {
                            ++outerMargin.bottom;
                            continue block8;
                        }
                        case 3: 
                        case 5: {
                            ++outerMargin.top;
                        }
                    }
                }
                block9: for (ii = span; ii > spanDepth; --ii) {
                    switch (growthDirection) {
                        default: {
                            ++outerMargin.top;
                            continue block9;
                        }
                        case 3: 
                        case 5: {
                            ++outerMargin.bottom;
                        }
                    }
                }
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }
        return outerMargin;
    }

    private static int computeLevelSpan(DataTreeGroupNode node) {
        int span;
        Object v = node.getValue();
        if (v instanceof TupleElementInterface) {
            TupleElementInterface te = (TupleElementInterface)v;
            try {
                span = te.getSpan();
            }
            catch (OLAPException e) {
                e.printStackTrace();
                span = 1;
            }
        } else {
            span = 1;
        }
        return span;
    }

    private static void makePath(DataTreeGroupNode leaf, List path) {
        DataTreeGroupNode node = leaf;
        path.clear();
        path.add(node);
        while (node.getParent().getParent() != null) {
            node = (DataTreeGroupNode)node.getParent();
            path.add(0, node);
        }
    }

    private static int computeSize(DataTreeGroupNode node, Map leafNodeToComponentSize) {
        int result = 1;
        if (node.isLeaf()) {
            result = (Integer)leafNodeToComponentSize.get(node);
        } else {
            Enumeration e = node.depthFirstEnumeration();
            result = 0;
            while (e.hasMoreElements()) {
                DataTreeGroupNode n = (DataTreeGroupNode)e.nextElement();
                if (!n.isLeaf()) continue;
                result += ((Integer)leafNodeToComponentSize.get(n)).intValue();
            }
        }
        return result;
    }

    private static int computeDescendantLeafCount(DataTreeGroupNode node) {
        int result = 1;
        if (!node.isLeaf()) {
            int childCount = node.getChildCount();
            result = 0;
            for (int ii = 0; ii < childCount; ++ii) {
                DataTreeGroupNode child = (DataTreeGroupNode)node.getChildAt(ii);
                if (child.isLeaf()) {
                    ++result;
                    continue;
                }
                result += ValuePane.computeDescendantLeafCount(child);
            }
        }
        return result;
    }

    private static void _removeAlignableComponentConstraints(ValuePane valuePane) {
        Component[] components = valuePane.getContentPanelComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof AlignableComponentInterface)) continue;
            ((AlignableComponentInterface)((Object)components[ii])).setAlignableComponentConstraints(null);
        }
    }

    public static void doLayout(ValuePane valuePane, int growthDirection, Map leafNodeToComponentSize, int constantSize, int componentStartOffest, int componentEndOffset, int transX, int transY) {
        boolean isReverse;
        boolean isVertical;
        if (valuePane == null) {
            return;
        }
        ValueTree tree = valuePane.getTree();
        if (tree == null) {
            return;
        }
        ValuePane._removeAlignableComponentConstraints(valuePane);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo dataTreeInfo = (DataTreeInfo)root.getValue();
        int levelCount = dataTreeInfo.getGroupVariableCount();
        int componentHeight = 0;
        int componentWidth = 0;
        switch (growthDirection) {
            default: {
                isVertical = false;
                isReverse = true;
                componentHeight = constantSize;
                break;
            }
            case 5: {
                isVertical = false;
                isReverse = false;
                componentHeight = constantSize;
                break;
            }
            case 3: {
                isVertical = true;
                isReverse = false;
                componentWidth = constantSize;
                break;
            }
            case 7: {
                isVertical = true;
                isReverse = true;
                componentWidth = constantSize;
            }
        }
        DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
        ArrayList path = new ArrayList();
        int cellX = 0;
        int cellY = 0;
        for (int ii = 0; ii < leaves.length; ++ii) {
            DataTreeGroupNode leaf = (DataTreeGroupNode)leaves[ii];
            int leafSize = (Integer)leafNodeToComponentSize.get(leaf);
            if (isVertical) {
                cellX = 0;
                componentHeight = leafSize;
            } else {
                cellY = 0;
                componentWidth = leafSize;
            }
            ValuePane.makePath(leaf, path);
            for (int j = 0; j < path.size(); ++j) {
                int heightPixels;
                int widthPixels;
                int yPixels;
                int xPixels;
                int cellHeight;
                int cellWidth;
                DataTreeGroupNode node = (DataTreeGroupNode)path.get(j);
                StringComponent component = (StringComponent)valuePane.getValueComponent((TreeNode)node);
                if (component == null) continue;
                int levelSpan = ValuePane.computeLevelSpan(node);
                int size = ValuePane.computeSize(node, leafNodeToComponentSize);
                Insets outerMargin = ValuePane.computeOuterMargin(node, growthDirection);
                if (isVertical) {
                    cellWidth = levelSpan;
                    cellHeight = size;
                    xPixels = cellX * componentWidth;
                    yPixels = cellY;
                    widthPixels = componentWidth * cellWidth;
                    heightPixels = cellHeight;
                    outerMargin.left = outerMargin.top * componentWidth;
                    outerMargin.right = outerMargin.bottom * componentWidth;
                    outerMargin.top = 0;
                    outerMargin.bottom = 0;
                } else {
                    cellHeight = levelSpan;
                    cellWidth = size;
                    xPixels = cellX;
                    yPixels = cellY * componentHeight;
                    widthPixels = cellWidth;
                    heightPixels = componentHeight * cellHeight;
                    outerMargin.top *= componentHeight;
                    outerMargin.bottom *= componentHeight;
                }
                if (component.getAlignableComponentConstraints() == null) {
                    Rectangle bounds = null;
                    bounds = new Rectangle(xPixels, yPixels, widthPixels, heightPixels);
                    AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                    constraints.setBounds(bounds);
                    constraints.setOuterMargin(outerMargin);
                    component.setAlignableComponentConstraints(constraints);
                }
                if (isVertical) {
                    cellX += cellWidth;
                    continue;
                }
                cellY += cellHeight;
            }
            if (isVertical) {
                cellY += leafSize;
                continue;
            }
            cellX += leafSize;
        }
        valuePane.applyFrame(growthDirection);
        if (isVertical) {
            valuePane.setContentPanelBounds(transX, transY, levelCount * componentWidth, ValuePane.computeSize(root, leafNodeToComponentSize));
        } else {
            valuePane.setContentPanelBounds(transX, transY, ValuePane.computeSize(root, leafNodeToComponentSize), levelCount * componentHeight);
        }
        if (isReverse) {
            if (isVertical) {
                ValuePane.flipX(valuePane);
            } else {
                ValuePane.flipY(valuePane);
            }
        }
    }

    public static void doLayout(ValuePane valuePane, int growthDirection, int componentWidth, int componentHeight, int componentStartOffest, int componentEndOffset, int transX, int transY, int lastLevelSize) {
        Dimension contentPanelBounds = ValuePane._doLayout(valuePane, growthDirection, componentWidth, componentHeight, componentStartOffest, componentEndOffset, transX, transY);
        if (contentPanelBounds == null) {
            return;
        }
        ValueTree tree = valuePane.getTree();
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo dataTreeInfo = (DataTreeInfo)root.getValue();
        int levelCount = dataTreeInfo.getGroupVariableCount();
        DefaultMutableTreeNode[] nodes = valuePane.getTree().getLeafNodes();
        for (int ii = 0; ii < nodes.length; ++ii) {
            JComponent component = valuePane.getValueComponent(nodes[ii]);
            Rectangle bounds = component.getBounds();
            switch (growthDirection) {
                case 1: 
                case 5: {
                    bounds.height = lastLevelSize;
                    break;
                }
                case 3: 
                case 7: {
                    bounds.width = lastLevelSize;
                }
            }
            component.setBounds(bounds);
        }
        Enumeration<TreeNode> e = valuePane.getTree().getRoot().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            JComponent component;
            TreeNode node = e.nextElement();
            if (node.isLeaf() || (component = valuePane.getValueComponent(node)) == null) continue;
            Rectangle bounds = component.getBounds();
            switch (growthDirection) {
                case 1: {
                    bounds.y += lastLevelSize - componentHeight;
                    break;
                }
                case 3: {
                    bounds.x += lastLevelSize - componentWidth;
                }
            }
            component.setBounds(bounds);
        }
        switch (growthDirection) {
            case 1: 
            case 5: {
                int levelHeight = contentPanelBounds.height / levelCount;
                contentPanelBounds.height += lastLevelSize - levelHeight;
                break;
            }
            case 3: 
            case 7: {
                int levelWidth = contentPanelBounds.width / levelCount;
                contentPanelBounds.width += lastLevelSize - levelWidth;
            }
        }
        valuePane.setContentPanelBounds(transX, transY, contentPanelBounds.width, contentPanelBounds.height);
    }

    public static void doLayout(ValuePane valuePane, int growthDirection, int componentWidth, int componentHeight, int componentStartOffest, int componentEndOffset, int transX, int transY) {
        ValuePane._doLayout(valuePane, growthDirection, componentWidth, componentHeight, componentStartOffest, componentEndOffset, transX, transY);
    }

    public static void doLayout(ValuePane valuePane, int growthDirection, GridDimension componentSize, int transX, int transY) {
        ValuePane._doLayout(valuePane, growthDirection, componentSize, transX, transY);
    }

    private static Dimension _doLayout(ValuePane valuePane, int growthDirection, int componentWidth, int componentHeight, int componentStartOffest, int componentEndOffset, int transX, int transY) {
        boolean isReverse;
        boolean isVertical;
        if (valuePane == null) {
            return null;
        }
        ValueTree tree = valuePane.getTree();
        if (tree == null) {
            return null;
        }
        ValuePane._removeAlignableComponentConstraints(valuePane);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo dataTreeInfo = (DataTreeInfo)root.getValue();
        int levelCount = dataTreeInfo.getGroupVariableCount();
        switch (growthDirection) {
            default: {
                isVertical = false;
                isReverse = true;
                break;
            }
            case 5: {
                isVertical = false;
                isReverse = false;
                break;
            }
            case 3: {
                isVertical = true;
                isReverse = false;
                break;
            }
            case 7: {
                isVertical = true;
                isReverse = true;
            }
        }
        DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
        int leafCount = leaves.length;
        ArrayList path = new ArrayList();
        Insets outerMargin = null;
        int cellX = 0;
        int cellY = 0;
        for (int ii = 0; ii < leaves.length; ++ii) {
            ValuePane.makePath((DataTreeGroupNode)leaves[ii], path);
            if (isVertical) {
                cellX = 0;
            } else {
                cellY = 0;
            }
            for (int j = 0; j < path.size(); ++j) {
                int yPixels;
                int xPixels;
                int cellHeight;
                int cellWidth;
                DataTreeGroupNode node = (DataTreeGroupNode)path.get(j);
                AlignableComponentInterface component = (AlignableComponentInterface)((Object)valuePane.getValueComponent((TreeNode)node));
                if (component == null) continue;
                int levelSpan = ValuePane.computeLevelSpan(node);
                outerMargin = ValuePane.computeOuterMargin(node, growthDirection);
                int descendantLeafCount = ValuePane.computeDescendantLeafCount(node);
                if (isVertical) {
                    cellWidth = levelSpan;
                    cellHeight = descendantLeafCount;
                    outerMargin.left = outerMargin.top * componentWidth;
                    outerMargin.right = outerMargin.bottom * componentWidth;
                    outerMargin.top = 0;
                    outerMargin.bottom = 0;
                    xPixels = cellX * componentWidth;
                    yPixels = cellY * componentHeight;
                    cellX += cellWidth;
                } else {
                    cellHeight = levelSpan;
                    cellWidth = descendantLeafCount;
                    outerMargin.top *= componentHeight;
                    outerMargin.bottom *= componentHeight;
                    xPixels = cellX * componentWidth;
                    yPixels = cellY * componentHeight;
                    cellY += cellHeight;
                }
                if (component.getAlignableComponentConstraints() != null) continue;
                int widthPixels = componentWidth * cellWidth;
                int heightPixels = componentHeight * cellHeight;
                Rectangle bounds = new Rectangle(xPixels, yPixels, widthPixels, heightPixels);
                AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                constraints.setBounds(bounds);
                constraints.setOuterMargin(outerMargin);
                component.setAlignableComponentConstraints(constraints);
            }
            if (isVertical) {
                ++cellY;
                continue;
            }
            ++cellX;
        }
        valuePane.applyFrame(growthDirection);
        Dimension bounds = new Dimension();
        if (isVertical) {
            bounds.width = levelCount * componentWidth;
            bounds.height = leafCount * componentHeight;
        } else {
            bounds.width = leafCount * componentWidth;
            bounds.height = levelCount * componentHeight;
        }
        valuePane.setContentPanelBounds(transX, transY, bounds.width, bounds.height);
        if (isReverse) {
            if (isVertical) {
                ValuePane.flipX(valuePane);
            } else {
                ValuePane.flipY(valuePane);
            }
        }
        return bounds;
    }

    private static Dimension _doLayout(ValuePane valuePane, int growthDirection, GridDimension componentSizes, int transX, int transY) {
        boolean isReverse;
        int i;
        if (valuePane == null) {
            return null;
        }
        Dimension gridSize = componentSizes.getGridSize();
        ValueTree tree = valuePane.getTree();
        if (tree == null) {
            return null;
        }
        ValuePane._removeAlignableComponentConstraints(valuePane);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        boolean isVertical = growthDirection == 3 || growthDirection == 7;
        DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
        int leafCount = leaves.length;
        ArrayList path = new ArrayList();
        Insets outerMargin = null;
        int xCells = 0;
        int yCells = 0;
        int xPixels = 0;
        int yPixels = 0;
        for (int i2 = 0; i2 < leafCount; ++i2) {
            ValuePane.makePath((DataTreeGroupNode)leaves[i2], path);
            if (isVertical) {
                xCells = 0;
                xPixels = 0;
            } else {
                yCells = 0;
                yPixels = 0;
            }
            for (int j = 0; j < path.size(); ++j) {
                int k;
                int k2;
                int k1;
                int k0;
                int postCells;
                int preCells;
                boolean forward;
                DataTreeGroupNode node = (DataTreeGroupNode)path.get(j);
                AlignableComponentInterface component = (AlignableComponentInterface)((Object)valuePane.getValueComponent((TreeNode)node));
                if (component == null) continue;
                boolean firstHit = component.getAlignableComponentConstraints() == null;
                int levelSpan = ValuePane.computeLevelSpan(node);
                outerMargin = ValuePane.computeOuterMargin(node, growthDirection);
                int descendantLeafCount = ValuePane.computeDescendantLeafCount(node);
                int widthPixels = 0;
                int heightPixels = 0;
                int widthCells = 0;
                int heightCells = 0;
                boolean bl = forward = growthDirection == 3 || growthDirection == 5;
                if (forward) {
                    preCells = outerMargin.top;
                    postCells = outerMargin.bottom;
                } else {
                    preCells = outerMargin.bottom;
                    postCells = outerMargin.top;
                }
                int postPixels = 0;
                int prePixels = 0;
                outerMargin.right = 0;
                outerMargin.left = 0;
                outerMargin.bottom = 0;
                outerMargin.top = 0;
                if (isVertical) {
                    widthCells = levelSpan;
                    heightCells = descendantLeafCount;
                    k0 = xCells;
                    k1 = k0 + preCells;
                    k2 = k1 + 1 + postCells;
                    for (k = k0; k < gridSize.width && k < k2; ++k) {
                        int w = componentSizes.getColWidth(k);
                        if (k < k1) {
                            prePixels += w;
                        } else if (k > k1) {
                            postPixels += w;
                        }
                        widthPixels += w;
                    }
                    if (forward) {
                        outerMargin.left = prePixels;
                        outerMargin.right = postPixels;
                    } else {
                        outerMargin.left = postPixels;
                        outerMargin.right = prePixels;
                    }
                    if (firstHit) {
                        k0 = yCells;
                        k1 = k0 + descendantLeafCount;
                        heightPixels = 0;
                        for (k = k0; k < k1; ++k) {
                            heightPixels += componentSizes.getRowHeight(k);
                        }
                    }
                } else {
                    heightCells = levelSpan;
                    widthCells = descendantLeafCount;
                    k0 = yCells;
                    k1 = k0 + preCells;
                    k2 = k1 + 1 + postCells;
                    for (k = k0; k < gridSize.height && k < k2; ++k) {
                        int h = componentSizes.getRowHeight(k);
                        if (k < k1) {
                            prePixels += h;
                        } else if (k > k1) {
                            postPixels += h;
                        }
                        heightPixels += h;
                    }
                    if (forward) {
                        outerMargin.top = prePixels;
                        outerMargin.bottom = postPixels;
                    } else {
                        outerMargin.top = postPixels;
                        outerMargin.bottom = prePixels;
                    }
                    if (firstHit) {
                        k0 = xCells;
                        k1 = k0 + descendantLeafCount;
                        widthPixels = 0;
                        for (k = k0; k < k1; ++k) {
                            widthPixels += componentSizes.getColWidth(k);
                        }
                    }
                }
                if (firstHit) {
                    Rectangle bounds = new Rectangle(xPixels, yPixels, widthPixels, heightPixels);
                    AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                    constraints.setBounds(bounds);
                    constraints.setOuterMargin(outerMargin);
                    component.setAlignableComponentConstraints(constraints);
                }
                if (isVertical) {
                    xCells += widthCells;
                    xPixels += widthPixels;
                    continue;
                }
                yCells += heightCells;
                yPixels += heightPixels;
            }
            if (isVertical) {
                ++yCells;
                yPixels += componentSizes.getRowHeight(i2);
                continue;
            }
            ++xCells;
            xPixels += componentSizes.getColWidth(i2);
        }
        valuePane.applyFrame(growthDirection);
        Dimension bounds = new Dimension(0, 0);
        if (isVertical) {
            for (i = 0; i < gridSize.width; ++i) {
                bounds.width += componentSizes.getColWidth(i);
            }
            bounds.height = componentSizes.height;
        } else {
            bounds.width = componentSizes.width;
            for (i = 0; i < gridSize.height; ++i) {
                bounds.height += componentSizes.getRowHeight(i);
            }
        }
        valuePane.setContentPanelBounds(transX, transY, bounds.width, bounds.height);
        boolean bl = isReverse = growthDirection != 3 && growthDirection != 5;
        if (isReverse) {
            if (isVertical) {
                ValuePane.flipX(valuePane);
            } else {
                ValuePane.flipY(valuePane);
            }
        }
        return bounds;
    }

    public static interface ValueComponentFactory {
        public JComponent newValueComponent(TreeNode var1);
    }

    public static class DefaultValueComponentFactory
    implements ValueComponentFactory {
        private final TextStyle textStyle;
        private final ListSelectionModel selectionModel;
        private final SwingActionProvider actionProvider;
        private final ActionUIFactory actionUIFactory;
        private final ActionSupportFilter labelFilter;
        private final GenericActionProviderView actionProviderView;
        private final Channel channel;

        public DefaultValueComponentFactory(TextStyle textStyle, ListSelectionModel selectionModel, Channel channel) {
            this(textStyle, selectionModel, null, null, channel);
        }

        public DefaultValueComponentFactory(TextStyle textStyle, ListSelectionModel selectionModel, SwingActionProvider actionProvider, JComponent parentedComponent, Channel channel) {
            this.textStyle = textStyle != null ? textStyle : new TextStyle();
            this.selectionModel = selectionModel;
            this.actionProvider = actionProvider;
            this.channel = channel;
            if (this.actionProvider != null) {
                this.actionUIFactory = new ActionUIFactory();
                this.actionProviderView = new GenericActionProviderView(parentedComponent);
                this.labelFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA", (ActionProviderViewInterface)this.actionProviderView);
            } else {
                this.actionUIFactory = null;
                this.actionProviderView = null;
                this.labelFilter = null;
            }
        }

        @Override
        public JComponent newValueComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode) {
                String text;
                OLAPLevelVariable v;
                DataTreeGroupNode dtgNode = (DataTreeGroupNode)node;
                if (dtgNode == dtgNode.getRoot()) {
                    return null;
                }
                OLAPDataSetInterface olapDataSet = null;
                HashMap<String, Object> actionSupportFilterAttributes = null;
                DataTreeInfo info = (DataTreeInfo)((DataTreeGroupNode)dtgNode.getRoot()).getValue();
                if (info.getGroupVariableAt(0) instanceof OLAPLevelVariable && (olapDataSet = (OLAPDataSetInterface)(v = (OLAPLevelVariable)info.getGroupVariableAt(0)).getFactory().getResultSet()) instanceof GraphOLAPDataSet) {
                    olapDataSet = ((GraphOLAPDataSet)olapDataSet).getDelegateModel();
                }
                actionSupportFilterAttributes = new HashMap<String, Object>();
                if (dtgNode.getValue() instanceof TupleElementInterface) {
                    actionSupportFilterAttributes.put("tupleElement", dtgNode.getValue());
                    actionSupportFilterAttributes.put("isMeasure", Boolean.FALSE);
                    if (olapDataSet instanceof BusinessQueryToOLAPDataSetAdapter) {
                        try {
                            Method getBusinessQueryMethod = olapDataSet.getClass().getMethod("getBusinessQuery", null);
                            Object businessQuery = getBusinessQueryMethod.invoke((Object)olapDataSet, null);
                            Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                            Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), TupleElementInterface.class};
                            Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                            Object dataItem = findDataItemMethod.invoke(null, businessQuery, dtgNode.getValue());
                            actionSupportFilterAttributes.put("dataItem", dataItem);
                        }
                        catch (SecurityException getBusinessQueryMethod) {
                        }
                        catch (NoSuchMethodException getBusinessQueryMethod) {
                        }
                        catch (IllegalArgumentException getBusinessQueryMethod) {
                        }
                        catch (IllegalAccessException getBusinessQueryMethod) {
                        }
                        catch (InvocationTargetException getBusinessQueryMethod) {
                        }
                        catch (ClassNotFoundException getBusinessQueryMethod) {
                            // empty catch block
                        }
                    }
                }
                StringComponent.CellNodeInfo cellNodeInfo = (StringComponent.CellNodeInfo)dtgNode.getUserObject();
                int[] selectionIndexes = null;
                Iterator iter = dtgNode.getValueIndexIterator();
                if (iter != null) {
                    ArrayList indexList = new ArrayList();
                    while (iter.hasNext()) {
                        indexList.add(iter.next());
                    }
                    int size = indexList.size();
                    if (size > 0) {
                        selectionIndexes = new int[size];
                        for (int ii = 0; ii < size; ++ii) {
                            selectionIndexes[ii] = (Integer)indexList.get(ii);
                        }
                    }
                }
                if ((text = dtgNode.getFormattedValue()) == null) {
                    text = dtgNode.getValue().toString();
                }
                if (text != null) {
                    return new StringComponent(text.trim(), this.textStyle, this.selectionModel, selectionIndexes, this.actionUIFactory, this.labelFilter, this.actionProvider, actionSupportFilterAttributes, olapDataSet, cellNodeInfo, this.channel);
                }
            }
            return null;
        }
    }

    public static class MultiStyleValueComponentFactory
    implements ValueComponentFactory {
        private final TextStyle textStyle;
        private final ListSelectionModel selectionModel;
        private final SwingActionProvider actionProvider;
        private final ActionUIFactory actionUIFactory;
        private final ActionSupportFilter labelFilter;
        private final GenericActionProviderView actionProviderView;
        private final HashMap formattedValue2FillStyleMap;
        private final HashMap formattedValue2MarkerStyleMap;
        private final HashMap formattedValue2LineStyleMap;
        private final boolean isFillStyleEnabled;
        private final boolean isMarkerStyleEnabled;
        private final boolean isLineStyleEnabled;
        private final StringVariable variable;
        private final Color defaultBackgroundColor;
        private final Channel channel;
        private final AbstractMarkerSkinFactory skinFactory;

        public MultiStyleValueComponentFactory(TextStyle textStyle, HashMap formattedValue2FillStyleMap, HashMap formattedValue2MarkerStyleMap, HashMap formattedValue2LineStyleMap, boolean isFillStyleEnabled, boolean isMarkerStyleEnabled, boolean isLineStyleEnabled, ListSelectionModel selectionModel, SwingActionProvider actionProvider, StringVariable variable, JComponent parentedComponent, Color defaultBackgroundColor, Channel channel, AbstractMarkerSkinFactory skinFactory) {
            this.textStyle = textStyle != null ? textStyle : new TextStyle();
            this.selectionModel = selectionModel;
            this.actionProvider = actionProvider;
            this.formattedValue2FillStyleMap = formattedValue2FillStyleMap;
            this.formattedValue2MarkerStyleMap = formattedValue2MarkerStyleMap;
            this.formattedValue2LineStyleMap = formattedValue2LineStyleMap;
            this.variable = variable;
            this.channel = channel;
            this.isFillStyleEnabled = isFillStyleEnabled;
            this.isLineStyleEnabled = isLineStyleEnabled;
            this.isMarkerStyleEnabled = isMarkerStyleEnabled;
            this.defaultBackgroundColor = defaultBackgroundColor;
            this.skinFactory = skinFactory;
            if (this.actionProvider != null) {
                this.actionUIFactory = new ActionUIFactory();
                this.actionProviderView = new GenericActionProviderView(parentedComponent);
                this.labelFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA", (ActionProviderViewInterface)this.actionProviderView);
            } else {
                this.actionUIFactory = null;
                this.actionProviderView = null;
                this.labelFilter = null;
            }
        }

        @Override
        public JComponent newValueComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode) {
                String text;
                OLAPLevelVariable v;
                DataTreeGroupNode dtgNode = (DataTreeGroupNode)node;
                if (dtgNode == dtgNode.getRoot()) {
                    return null;
                }
                OLAPDataSetInterface olapDataSet = null;
                HashMap<String, Object> actionSupportFilterAttributes = null;
                DataTreeInfo info = (DataTreeInfo)((DataTreeGroupNode)dtgNode.getRoot()).getValue();
                if (info.getGroupVariableAt(0) instanceof OLAPLevelVariable && (olapDataSet = (OLAPDataSetInterface)(v = (OLAPLevelVariable)info.getGroupVariableAt(0)).getFactory().getResultSet()) instanceof GraphOLAPDataSet) {
                    olapDataSet = ((GraphOLAPDataSet)olapDataSet).getDelegateModel();
                }
                actionSupportFilterAttributes = new HashMap<String, Object>();
                if (dtgNode.getValue() instanceof TupleElementInterface) {
                    actionSupportFilterAttributes.put("tupleElement", dtgNode.getValue());
                    actionSupportFilterAttributes.put("isMeasure", Boolean.FALSE);
                    if (olapDataSet instanceof BusinessQueryToOLAPDataSetAdapter) {
                        try {
                            Method getBusinessQueryMethod = olapDataSet.getClass().getMethod("getBusinessQuery", null);
                            Object businessQuery = getBusinessQueryMethod.invoke((Object)olapDataSet, null);
                            Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                            Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), TupleElementInterface.class};
                            Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                            Object dataItem = findDataItemMethod.invoke(null, businessQuery, dtgNode.getValue());
                            actionSupportFilterAttributes.put("dataItem", dataItem);
                        }
                        catch (SecurityException getBusinessQueryMethod) {
                        }
                        catch (NoSuchMethodException getBusinessQueryMethod) {
                        }
                        catch (IllegalArgumentException getBusinessQueryMethod) {
                        }
                        catch (IllegalAccessException getBusinessQueryMethod) {
                        }
                        catch (InvocationTargetException getBusinessQueryMethod) {
                        }
                        catch (ClassNotFoundException getBusinessQueryMethod) {
                            // empty catch block
                        }
                    }
                }
                Color backgroundColor = this.defaultBackgroundColor;
                boolean backgroundRepresentsValue = false;
                MarkerStyle markerStyle = null;
                LineStyle lineStyle = null;
                String formattedValue = GTKUtil.VariableAccess.getFormattedValue(this.variable, dtgNode.getFirstValueIndex());
                if (this.isFillStyleEnabled && this.formattedValue2FillStyleMap != null) {
                    backgroundColor = ((FillStyle)this.formattedValue2FillStyleMap.get(formattedValue)).getSolidFillColor();
                    backgroundRepresentsValue = true;
                }
                if (this.isMarkerStyleEnabled && this.formattedValue2MarkerStyleMap != null) {
                    markerStyle = (MarkerStyle)this.formattedValue2MarkerStyleMap.get(formattedValue);
                }
                if (this.isLineStyleEnabled && this.formattedValue2LineStyleMap != null) {
                    lineStyle = (LineStyle)this.formattedValue2LineStyleMap.get(formattedValue);
                }
                int[] selectionIndexes = null;
                Iterator iter = dtgNode.getValueIndexIterator();
                if (iter != null) {
                    ArrayList indexList = new ArrayList();
                    while (iter.hasNext()) {
                        indexList.add(iter.next());
                    }
                    int size = indexList.size();
                    if (size > 0) {
                        selectionIndexes = new int[size];
                        for (int ii = 0; ii < size; ++ii) {
                            selectionIndexes[ii] = (Integer)indexList.get(ii);
                        }
                    }
                }
                if ((text = dtgNode.getFormattedValue()) == null) {
                    text = dtgNode.getValue().toString();
                }
                return new MultiStyleStringComponent(text, this.textStyle, markerStyle, lineStyle, this.selectionModel, selectionIndexes, this.actionUIFactory, this.labelFilter, this.actionProvider, actionSupportFilterAttributes, olapDataSet, new StringComponent.CellNodeInfo(backgroundColor, backgroundRepresentsValue, false), this.channel, this.skinFactory);
            }
            return null;
        }

        public HashMap getFormattedValue2FillStyleMap() {
            return this.formattedValue2FillStyleMap;
        }

        public HashMap getFormattedValue2LineStyleMap() {
            return this.formattedValue2LineStyleMap;
        }

        public HashMap getFormattedValue2MarkerStyleMap() {
            return this.formattedValue2MarkerStyleMap;
        }
    }
}

