/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.MissingValues;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AnalysisVariableList;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationCellStyle;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DataModel;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.categorization.Categorizor;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.CategorizationInfo;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.ShadowBorder;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Mapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringTableModelVariable;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.measures.BaseLength;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.table.FormattedInterface;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;

public abstract class Util {
    public static final BaseLength ONE_PX = new BaseLength(1.0, "px");
    public static final BaseLength TWO_PX = new BaseLength(2.0, "px");
    public static final BaseLength MIN_FONT = new BaseLength(8.0, "pt");
    public static final int MIN_FONT_HEIGHT = (int)MIN_FONT.getMagnitude((Object)"py");
    public static final int MIN_FONT_WIDTH = (int)MIN_FONT.getMagnitude((Object)"px");

    public static Point toDescendent(int x, int y, JComponent parent, JComponent descendent) {
        Point invalid = null;
        if (parent != null && descendent != null) {
            Container c;
            Point valid = new Point(x, y);
            for (c = descendent; c != null && c != parent; c = c.getParent()) {
                Rectangle b = c.getBounds();
                valid.x -= b.x;
                valid.y -= b.y;
            }
            if (c != null) {
                return valid;
            }
        }
        return invalid;
    }

    public static Rectangle toDescendent(int x, int y, int w, int h, JComponent parent, JComponent descendent) {
        Point p1;
        Rectangle invalid = null;
        if (w > 0 && h > 0 && (p1 = Util.toDescendent(x, y, parent, descendent)) != null) {
            return new Rectangle(p1.x, p1.y, w, h);
        }
        return invalid;
    }

    public static Point toAscendent(int x, int y, JComponent parent, JComponent descendent) {
        Point invalid = null;
        if (parent != null && descendent != null) {
            Container c;
            Point valid = new Point(x, y);
            for (c = descendent; c != null && c != parent; c = c.getParent()) {
                Rectangle b = c.getBounds();
                valid.x += b.x;
                valid.y += b.y;
            }
            if (c != null) {
                return valid;
            }
        }
        return invalid;
    }

    public static Locale getLocale(Graph graph) {
        Locale locale = null;
        if (graph != null) {
            try {
                locale = graph.getLocale();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return locale != null ? locale : Locale.getDefault();
    }

    public static Locale getFormatLocale(Graph graph, DataModel dataModel) {
        Locale locale;
        Locale locale2 = locale = dataModel != null ? dataModel.getLocale() : null;
        if (locale == null) {
            locale = graph != null ? Util.getLocale(graph) : null;
        }
        return locale;
    }

    public static double asWorldValue(DataSource dataSource, StringVariable v, StringToNumericMap map, Object rawObjectValue) {
        String value = DataSource.asFormattedValue((com.sas.graphics.util.gtk.Variable)v, rawObjectValue);
        if (value != null) {
            try {
                return map.getValue((Object)value);
            }
            catch (MissingValueException missingValueException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public static DiscreteStyleMapModel rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(DataSource dataSource, com.sas.graphics.util.gtk.Variable v, DiscreteStyleMapModel rawObjectValueStyleMapModel) {
        return Util._rawObjectValueStyleMapToFormattedValueStyleMap(dataSource, v, rawObjectValueStyleMapModel, true);
    }

    public static DiscreteStyleMapModel rawObjectValueStyleMapToFormattedValueStyleMap(DataSource dataSource, com.sas.graphics.util.gtk.Variable v, DiscreteStyleMapModel rawObjectValueStyleMapModel) {
        return Util._rawObjectValueStyleMapToFormattedValueStyleMap(dataSource, v, rawObjectValueStyleMapModel, false);
    }

    private static DiscreteStyleMapModel _rawObjectValueStyleMapToFormattedValueStyleMap(DataSource dataSource, com.sas.graphics.util.gtk.Variable v, DiscreteStyleMapModel rawObjectValueStyleMapModel, boolean trimEnabled) {
        Iterator i;
        Set s;
        if (rawObjectValueStyleMapModel != null && rawObjectValueStyleMapModel.size() > 0 && v != null && (s = rawObjectValueStyleMapModel.keySet()) != null && (i = s.iterator()) != null) {
            DiscreteStyleMapModel dataValueMap = new DiscreteStyleMapModel();
            while (i.hasNext()) {
                Object rawObjectValue = i.next();
                String formattedValue = DataSource.asFormattedValue(v, rawObjectValue);
                if (formattedValue == null) continue;
                if (trimEnabled) {
                    formattedValue = formattedValue.trim();
                }
                dataValueMap.put((Object)formattedValue, rawObjectValueStyleMapModel.get(rawObjectValue));
            }
            return dataValueMap;
        }
        return null;
    }

    public static ReferenceLineModel[] getReferenceLineModels(ReferenceBandModel[] rbma) {
        ReferenceLineModel[] rlma = null;
        if (rbma != null) {
            rlma = new ReferenceLineModel[rbma.length * 2];
            for (int ii = 0; ii < rbma.length; ++ii) {
                if (rbma[ii] == null) continue;
                rlma[ii * 2] = rbma[ii].getBeginReferenceLineModel();
                rlma[ii * 2 + 1] = rbma[ii].getEndReferenceLineModel();
            }
        }
        return rlma;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static Class _getTableModelColumnClass(TableModel tableModel, int columnIndex, boolean peekEnabled) {
        Class tableModelColumnClass = null;
        if (tableModel != null && columnIndex >= 0 && columnIndex < tableModel.getColumnCount()) {
            if (tableModel instanceof FormattedInterface) {
                FormattedInterface fi = (FormattedInterface)tableModel;
                tableModelColumnClass = fi.getUnformattedColumnClass(columnIndex);
            } else {
                tableModelColumnClass = tableModel.getColumnClass(columnIndex);
            }
            if (tableModelColumnClass != null && Number.class.isAssignableFrom(tableModelColumnClass)) {
                tableModelColumnClass = Number.class;
            } else if (tableModelColumnClass != null && Date.class.isAssignableFrom(tableModelColumnClass)) {
                tableModelColumnClass = Time.class.isAssignableFrom(tableModelColumnClass) ? Time.class : (Timestamp.class.isAssignableFrom(tableModelColumnClass) ? Timestamp.class : Date.class);
            } else if (tableModelColumnClass != null && String.class.isAssignableFrom(tableModelColumnClass)) {
                tableModelColumnClass = String.class;
            } else if (peekEnabled && (Object.class == tableModelColumnClass || tableModelColumnClass == null)) {
                tableModelColumnClass = null;
                boolean missingEncountered = false;
                boolean objectEncountered = false;
                for (int ii = 0; tableModelColumnClass == null && ii < tableModel.getRowCount(); ++ii) {
                    Object o = tableModel.getValueAt(ii, columnIndex);
                    if (o instanceof MissingValues) {
                        missingEncountered = true;
                        continue;
                    }
                    if (o == null) continue;
                    objectEncountered = true;
                    if (o instanceof Number) {
                        tableModelColumnClass = Number.class;
                        continue;
                    }
                    if (o instanceof Date) {
                        if (o instanceof Time) {
                            tableModelColumnClass = Time.class;
                            continue;
                        }
                        if (o instanceof Timestamp) {
                            tableModelColumnClass = Timestamp.class;
                            continue;
                        }
                        tableModelColumnClass = Date.class;
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    tableModelColumnClass = String.class;
                }
                if (tableModelColumnClass == null) {
                    if (objectEncountered) {
                        tableModelColumnClass = Object.class;
                    } else if (missingEncountered) {
                        tableModelColumnClass = MissingValues.class;
                    }
                }
            } else {
                tableModelColumnClass = tableModelColumnClass != null && MissingValues.class.isAssignableFrom(tableModelColumnClass) ? MissingValues.class : Object.class;
            }
        }
        return tableModelColumnClass;
    }

    public static Class getTableModelColumnClass(TableModel tableModel, int columnIndex) {
        Class c = null;
        if (tableModel != null && columnIndex >= 0 && columnIndex < tableModel.getColumnCount()) {
            c = Util._getTableModelColumnClass(tableModel, columnIndex, true);
            if (c == MissingValues.class) {
                c = Number.class;
            } else if (c == Object.class) {
                c = String.class;
            } else if (c == null) {
                c = String.class;
            }
        }
        return c;
    }

    public static Class resolveDataType(Class genericDataType) {
        if (genericDataType != null) {
            if (Date.class.isAssignableFrom(genericDataType)) {
                if (Timestamp.class.isAssignableFrom(genericDataType)) {
                    return Timestamp.class;
                }
                if (Time.class.isAssignableFrom(genericDataType)) {
                    return Time.class;
                }
                if (Date.class.isAssignableFrom(genericDataType)) {
                    return Date.class;
                }
            } else {
                if (Number.class.isAssignableFrom(genericDataType)) {
                    return Number.class;
                }
                if (MissingValues.class.isAssignableFrom(genericDataType)) {
                    return Number.class;
                }
            }
        }
        return String.class;
    }

    public static int seekStringColumn(TableModel tableModel) {
        return Util.seekStringColumn(tableModel, null);
    }

    public static int seekStringColumn(TableModel tableModel, int[] skipList) {
        return Util.seekColumnByClass(tableModel, String.class, skipList);
    }

    public static int seekNumberColumn(TableModel tableModel) {
        return Util.seekNumberColumn(tableModel, null);
    }

    public static int seekNumberColumn(TableModel tableModel, int[] skipList) {
        return Util.seekColumnByClass(tableModel, Number.class, skipList);
    }

    public static int seekDateColumn(TableModel tableModel) {
        return Util.seekDateColumn(tableModel, null);
    }

    public static int seekDateColumn(TableModel tableModel, int[] skipList) {
        int index = Util.seekColumnByClass(tableModel, Date.class, skipList);
        if (index < 0) {
            index = Util.seekColumnByClass(tableModel, Time.class, skipList);
        }
        if (index < 0) {
            index = Util.seekColumnByClass(tableModel, Timestamp.class, skipList);
        }
        return index;
    }

    public static int seekNonNullColumn(TableModel tableModel) {
        return Util.seekNonNullColumn(tableModel, null);
    }

    public static int seekNonNullColumn(TableModel tableModel, int[] skipList) {
        if (tableModel != null) {
            int columnCount = tableModel.getColumnCount();
            for (int ii = 0; ii < columnCount; ++ii) {
                Class c;
                if (!Util.isValidColumn(ii, skipList) || (c = Util._getTableModelColumnClass(tableModel, ii, true)) == null || c == MissingValues.class) continue;
                return ii;
            }
        }
        return -1;
    }

    private static int seekColumnByClass(TableModel tableModel, Class c, int[] skipList) {
        int peekIndex = -1;
        if (tableModel != null && c != null) {
            int columnCount = tableModel.getColumnCount();
            for (int ii = 0; ii < columnCount; ++ii) {
                if (!Util.isValidColumn(ii, skipList)) continue;
                if (c == Util._getTableModelColumnClass(tableModel, ii, false)) {
                    return ii;
                }
                if (peekIndex >= 0 || c != Util._getTableModelColumnClass(tableModel, ii, true)) continue;
                peekIndex = ii;
            }
        }
        return peekIndex;
    }

    public static int seekNamedColumn(TableModel tableModel, String seekColName) {
        return Util.seekNamedColumn(tableModel, seekColName, null);
    }

    public static int seekNamedColumn(TableModel tableModel, String seekColName, int[] skipList) {
        int altColIndex = -1;
        if (tableModel != null && seekColName != null) {
            int columnCount = tableModel.getColumnCount();
            for (int ii = 0; ii < columnCount; ++ii) {
                if (!Util.isValidColumn(ii, skipList)) continue;
                String colName = tableModel.getColumnName(ii);
                if (seekColName.equals(colName)) {
                    return ii;
                }
                if (altColIndex >= 0 || !seekColName.equalsIgnoreCase(colName)) continue;
                altColIndex = ii;
            }
        }
        return altColIndex;
    }

    public static int getColumnIndex(TableModel tableModel, VariableDefinition varDef) {
        int colIndex = -1;
        if (tableModel != null && varDef != null) {
            int columnCount = tableModel.getColumnCount();
            if (varDef.getColumnIndex() != null) {
                int index = varDef.getColumnIndex();
                if (index >= 0 && index < columnCount) {
                    colIndex = index;
                }
            } else {
                colIndex = Util.seekNamedColumn(tableModel, varDef.getColumnName(), null);
            }
        }
        return colIndex;
    }

    public static int[] getColumnIndices(TableModel tableModel, VariableDefinition varDef) {
        int[] colIndices = null;
        if (tableModel != null && varDef != null) {
            int ii = 0;
            for (VariableDefinition vd = varDef; vd != null; vd = vd.getNext()) {
                ++ii;
            }
            colIndices = new int[ii];
            ii = 0;
            while (varDef != null) {
                colIndices[ii++] = Util.getColumnIndex(tableModel, varDef);
                varDef = varDef.getNext();
            }
        }
        return colIndices;
    }

    private static boolean isValidColumn(int colIndex, int[] skipList) {
        if (skipList != null) {
            for (int ii = 0; ii < skipList.length; ++ii) {
                if (colIndex != skipList[ii]) continue;
                return false;
            }
        }
        return true;
    }

    public static final void setVariableDefinition(DataSource dataSource, String role, String messageKey, Locale locale, VariableDefinition var, boolean missingMessageEnabled) {
        block2: {
            try {
                dataSource.setVariableDefinition(role, var);
            }
            catch (IllegalStateException e) {
                if (!missingMessageEnabled) break block2;
                Util._printMessage(e.getMessage(), messageKey, locale);
            }
        }
    }

    public static final void setVariableDefinition(DataSource dataSource, String role, String messageKey, Locale locale, VariableDefinition[] vars, boolean missingMessageEnabled) {
        if (vars != null) {
            for (int ii = 0; ii < vars.length; ++ii) {
                if (vars[ii] == null) continue;
                Util.setVariableDefinition(dataSource, role + ii, messageKey, locale, vars[ii], missingMessageEnabled);
            }
        }
    }

    public static final void setLegendVariable(DataSource dataSource, String role, String fromRole) {
        try {
            dataSource.setLegendVariable(role, fromRole);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static final AnalysisVariable newAnalysisVaraible(AnalysisVariable[] ava, int newStat) {
        if (ava != null) {
            int ii;
            ArrayList<AnalysisVariable> al = new ArrayList<AnalysisVariable>();
            for (ii = 0; ii < ava.length; ++ii) {
                if (ava[ii] instanceof AnalysisVariableList) {
                    for (AnalysisVariableList avl = (AnalysisVariableList)ava[ii]; avl != null; avl = avl.getNext()) {
                        al.add(avl);
                    }
                    continue;
                }
                if (ava[ii] == null) continue;
                al.add(ava[ii]);
            }
            for (ii = 0; ii < al.size(); ++ii) {
                if (newStat == 10507) {
                    AnalysisVariable av = (AnalysisVariable)al.get(ii);
                    al.set(ii, Util.newAnalysisVaraible(av, "percent", 10507));
                    continue;
                }
                al.set(ii, Util.newAnalysisVaraible((AnalysisVariable)al.get(ii), null, newStat));
            }
            if (al.size() > 0) {
                return new AnalysisVariableList(al.toArray(new AnalysisVariable[0]));
            }
        }
        return null;
    }

    public static final AnalysisVariable newAnalysisVaraible(AnalysisVariable av, String format, int newStat) {
        if (av != null) {
            return av.getColumnName() != null ? new AnalysisVariable(av.getColumnName(), format != null ? format : av.getFormat(), av.getInformat(), av.getLabel(), newStat) : (av.getColumnIndex() > 0 ? new AnalysisVariable(av.getColumnIndex(), format != null ? format : av.getFormat(), av.getInformat(), av.getLabel(), newStat) : null);
        }
        return null;
    }

    public static FillStyle newCycledFillStyle(FillStyle[] fills, Color[] cycleColors, int pos) {
        FillStyle fs = null;
        if (fills != null && fills.length > 0) {
            Color cycledColor;
            fs = new FillStyle();
            fs.apply(fills[pos % fills.length]);
            if (pos / fills.length > 0 && (cycledColor = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, pos)) != null) {
                fs.setSolidFillColor(cycledColor);
                fs.setSolidBlendColor(cycledColor);
                fs.setGradientBlendBeginColor(cycledColor);
                fs.setGradientFillBeginColor(cycledColor);
            }
        }
        return fs;
    }

    public static LineStyle newCycledLineStyle(LineStyle[] lines, Color[] cycleColors, int pos) {
        LineStyle lineStyle = null;
        if (lines != null && lines.length > 0) {
            Color cycledColor;
            lineStyle = lines[pos % lines.length];
            if (pos / lines.length > 0 && (cycledColor = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, pos)) != null) {
                LineStyle ls = new LineStyle();
                ls.apply(lineStyle);
                ls.setColor(cycledColor);
                lineStyle = ls;
            }
        }
        return lineStyle;
    }

    public static StrokeLineStyle newCycledLineStyle(StrokeLineStyle[] lines, Color[] cycleColors, int pos) {
        StrokeLineStyle lineStyle = null;
        if (lines != null && lines.length > 0) {
            Color cycledColor;
            lineStyle = lines[pos % lines.length];
            if (pos / lines.length > 0 && (cycledColor = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, pos)) != null) {
                StrokeLineStyle ls = new StrokeLineStyle();
                ls.apply(lineStyle);
                ls.setColor(cycledColor);
                lineStyle = ls;
            }
        }
        return lineStyle;
    }

    public static MarkerStyle newCycledMarkerStyle(MarkerStyle[] markers, Color[] cycleColors, int pos) {
        MarkerStyle markerStyle = null;
        if (markers != null && markers.length > 0) {
            Color cycledColor;
            markerStyle = markers[pos % markers.length];
            if (pos / markers.length > 0 && (cycledColor = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, pos)) != null) {
                MarkerStyle ms = new MarkerStyle();
                ms.apply(markerStyle);
                ms.setColor(cycledColor);
                markerStyle = ms;
            }
        }
        return markerStyle;
    }

    static void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Util.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                Util.quickSort(a, lo, hi0);
            }
        }
    }

    public static SASFormat newSASFormat(String formatName, Locale locale) {
        SASFormat theSASFormat = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (formatName != null && (formatName = formatName.trim()).length() > 0) {
            try {
                theSASFormat = SASFormat.getInstance((String)formatName, (Locale)locale);
            }
            catch (RuntimeException e) {
                System.err.println(e.getMessage());
            }
        }
        return theSASFormat;
    }

    public static List newValidatedList(Variable rVar, List measureNames, OLAPVariableFactory gtkOLAPFactory, String messageKey, Locale locale) {
        List mNames = null;
        if (measureNames != null) {
            if (rVar instanceof VariableList) {
                Variable[] vars = ((VariableList)rVar).asArray();
                for (int ii = 0; ii < vars.length; ++ii) {
                    mNames = Util._newValidatedList(vars[ii], measureNames, mNames, gtkOLAPFactory, messageKey, locale);
                }
            } else {
                mNames = Util._newValidatedList(rVar, measureNames, null, gtkOLAPFactory, messageKey, locale);
            }
        }
        return mNames;
    }

    private static final List _newValidatedList(Variable rVar, List measureNames, List mNames, OLAPVariableFactory gtkOLAPFactory, String messageKey, Locale locale) {
        if (rVar != null && (rVar.getColumnName() != null || rVar.getColumnIndex() != -1)) {
            if (rVar.getColumnName() != null) {
                String name = rVar.getColumnName().trim();
                if (measureNames.contains(name)) {
                    if (mNames == null) {
                        mNames = new ArrayList<String>();
                    }
                    mNames.add(name);
                } else {
                    boolean found = false;
                    for (int i = 0; i < measureNames.size(); ++i) {
                        String measureName = (String)measureNames.get(i);
                        OLAPMeasureVariable measureVariable = gtkOLAPFactory.newMeasureVariable(measureName);
                        String resultSetID = measureVariable.getResultSetId();
                        if (!name.equals(resultSetID)) continue;
                        if (mNames == null) {
                            mNames = new ArrayList();
                        }
                        mNames.add(0, measureName);
                        found = true;
                        break;
                    }
                    if (!found) {
                        String eText = RB.getStringResource("Graph.", "unfoundVariable.txt", locale);
                        Util._printMessage(eText + name, messageKey, locale);
                    }
                }
            } else {
                int index = rVar.getColumnIndex();
                if (index >= 0 && index < measureNames.size()) {
                    if (mNames == null) {
                        mNames = new ArrayList();
                    }
                    mNames.add((String)measureNames.get(index));
                } else {
                    String eText = RB.getStringResource("Graph.", "indexOutOfBounds.txt", locale);
                    Util._printMessage(eText, messageKey, locale);
                }
            }
        }
        return mNames;
    }

    public static final void setOLAPMeasures(DataSource dataSource, OLAPVariableFactory gtkOLAPFactory, String role, List measureNames, String messageKey, Locale locale, boolean missingMessageEnabled) {
        if (measureNames != null) {
            AnalysisVariableDefinition varDefs = null;
            for (int i = 0; i < measureNames.size(); ++i) {
                String measureName = (String)measureNames.get(i);
                varDefs = new AnalysisVariableDefinition(measureName, gtkOLAPFactory.getFormat(measureName), varDefs, 0);
            }
            Util.setVariableDefinition(dataSource, role, messageKey, locale, varDefs, missingMessageEnabled);
        }
    }

    public static final void setOLAPSelections(DataSource dataSource, ListSelectionModel selectionModel, String role, List measureNames, boolean missingMessageEnabled) {
        if (selectionModel != null && measureNames != null) {
            SelectionVariableDefinition varDefs = null;
            for (int i = 0; i < measureNames.size(); ++i) {
                varDefs = new SelectionVariableDefinition((String)measureNames.get(i), selectionModel, varDefs, 0);
            }
            Util.setVariableDefinition(dataSource, role, null, null, varDefs, missingMessageEnabled);
        }
    }

    public static VariableList newVariablelistFromVariableArray(DataSource dataSource, Object role) {
        int length = 0;
        while (dataSource.getVariable(role.toString() + length++) != null) {
        }
        Object[] roles = new String[length - 1];
        if (--length > 0) {
            for (int ii = 0; ii < roles.length; ++ii) {
                roles[ii] = role.toString() + ii;
            }
        }
        return Util.newVariablelist(dataSource, roles);
    }

    public static VariableList newVariablelist(DataSource dataSource, Object role) {
        return Util._newVariablelist(dataSource, role, null);
    }

    public static VariableList newVariablelist(DataSource dataSource, Object[] roles) {
        VariableList variableList = null;
        if (roles != null) {
            for (int ii = roles.length - 1; ii >= 0; --ii) {
                Object role = roles[ii];
                variableList = Util._newVariablelist(dataSource, role, variableList);
            }
        }
        return variableList;
    }

    private static VariableList _newVariablelist(DataSource dataSource, Object role, VariableList variableList) {
        if (dataSource != null && role != null) {
            VariableDefinition varDef;
            ArrayList<VariableDefinition> list = new ArrayList<VariableDefinition>();
            for (varDef = dataSource.getVariableDefinition(role); varDef != null; varDef = varDef.getNext()) {
                list.add(varDef);
            }
            for (int kk = list.size() - 1; kk >= 0; --kk) {
                String columnLabel;
                varDef = (VariableDefinition)list.get(kk);
                VariableDefinition.ModelColumnInfo varColInfo = varDef.getColumnModelColumnInfo();
                String columnName = varDef.getColumnName();
                if (columnName == null && varColInfo != null) {
                    columnName = varColInfo.getColumnName();
                }
                if ((columnLabel = varDef.getColumnLabel()) == null && varColInfo != null) {
                    columnLabel = varColInfo.getColumnLabel();
                }
                variableList = new VariableList(columnName, varDef.getFormat(), varDef.getInformat(), columnLabel, variableList);
            }
        }
        return variableList;
    }

    public static void setupColors(ValueTree tree, Color[] colors) {
        Util.setupColors(tree, colors, false, null);
    }

    public static void setupColors(ValueTree tree, Color[] colors, boolean isShadingEnabled, Float shadingIntensity) {
        DataTreeGroupNode root;
        float[] hsl = null;
        if (tree != null && colors != null && colors.length > 0 && (root = (DataTreeGroupNode)tree.getRoot()) != null) {
            float f;
            DataTreeInfo rootInfo = (DataTreeInfo)root.getValue();
            float shadingFactor = 0.05f;
            if (shadingIntensity != null && (f = shadingIntensity.floatValue()) >= -1.0f && f <= 1.0f) {
                shadingFactor = f;
            }
            HashMap<String, Color> hierarchyNameToColorMap = new HashMap<String, Color>();
            Enumeration e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DataTreeGroupNode node;
                Object n = e.nextElement();
                if (!(n instanceof DataTreeGroupNode) || (node = (DataTreeGroupNode)n).getLevelIndex() <= -1) continue;
                Color color = null;
                com.sas.graphics.util.gtk.Variable variable = rootInfo.getGroupVariableAt(node.getLevelIndex());
                if (variable instanceof OLAPLevelVariable) {
                    String hierarchyName = ((OLAPLevelVariable)variable).getHierachyName();
                    if (hierarchyNameToColorMap.containsKey(hierarchyName)) {
                        color = (Color)hierarchyNameToColorMap.get(hierarchyName);
                    } else {
                        int hierarchyDepth = hierarchyNameToColorMap.size();
                        color = colors[hierarchyDepth % colors.length];
                        hierarchyNameToColorMap.put(hierarchyName, color);
                    }
                } else {
                    color = colors[node.getLevelIndex() % colors.length];
                }
                boolean isShadowUsed = false;
                if (isShadingEnabled) {
                    int shadeIndex = 0;
                    if (node.getValue() instanceof TupleElementInterface) {
                        TupleElementInterface ti = (TupleElementInterface)node.getValue();
                        try {
                            shadeIndex = Math.max(0, ti.getLevelDepth() - 1);
                        }
                        catch (OLAPException ex) {
                            shadeIndex = 0;
                        }
                    } else {
                        shadeIndex = node.getLevelIndex() / colors.length;
                    }
                    if (shadeIndex > 0) {
                        isShadowUsed = true;
                        hsl = Util.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
                        float h = hsl[0];
                        float s = hsl[1];
                        float l = Math.min(1.0f, Math.max(0.0f, hsl[2] - (float)shadeIndex * shadingFactor));
                        color = Util.HSLAtoRGBA(h, s, l, color.getAlpha());
                    }
                }
                node.setUserObject((Object)new StringComponent.CellNodeInfo(color, false, isShadowUsed));
            }
        }
    }

    private static float[] RGBtoHSL(int r, int g, int b, float[] hsl) {
        float fR = (float)r / 255.0f;
        float fG = (float)g / 255.0f;
        float fB = (float)b / 255.0f;
        float minrgb = fR;
        float maxrgb = fR;
        if (fG > maxrgb) {
            maxrgb = fG;
        }
        if (fB > maxrgb) {
            maxrgb = fB;
        }
        if (fG < minrgb) {
            minrgb = fG;
        }
        if (fB < minrgb) {
            minrgb = fB;
        }
        float lum = (maxrgb + minrgb) / 2.0f;
        float sat = 0.0f;
        float hue = 0.0f;
        if (Float.MIN_VALUE > Math.abs(maxrgb - minrgb)) {
            sat = 0.0f;
            hue = 0.0f;
        } else {
            sat = lum <= 0.5f ? (maxrgb - minrgb) / (maxrgb + minrgb) : (maxrgb - minrgb) / (2.0f - maxrgb - minrgb);
            if (fR == maxrgb) {
                hue = (fG - fB) / (maxrgb - minrgb);
            }
            if (fG == maxrgb) {
                hue = 2.0f + (fB - fR) / (maxrgb - minrgb);
            }
            if (fB == maxrgb) {
                hue = 4.0f + (fR - fG) / (maxrgb - minrgb);
            }
            if ((hue *= 60.0f) < 0.0f) {
                hue += 360.0f;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = lum;
        return hsl;
    }

    private static Color HSLAtoRGBA(float h, float s, float l, int ia) {
        Color color;
        float v = l <= 0.5f ? l * (1.0f + s) : l + s - l * s;
        if (v <= 0.0f) {
            color = Color.BLACK;
        } else {
            float m = l + l - v;
            float sv = (v - m) / v;
            float hs = h / 60.0f;
            int sextant = (int)Math.floor(hs);
            float fract = hs - (float)sextant;
            float vsf = v * sv * fract;
            float mid1 = m + vsf;
            float mid2 = v - vsf;
            int iv = Math.round(255.0f * v);
            int im = Math.round(255.0f * m);
            int imid1 = Math.round(255.0f * mid1);
            int imid2 = Math.round(255.0f * mid2);
            switch (sextant) {
                case 0: {
                    color = new Color(iv, imid1, im, ia);
                    break;
                }
                case 1: {
                    color = new Color(imid2, iv, im, ia);
                    break;
                }
                case 2: {
                    color = new Color(im, iv, imid1, ia);
                    break;
                }
                case 3: {
                    color = new Color(im, imid2, iv, ia);
                    break;
                }
                case 4: {
                    color = new Color(imid1, im, iv, ia);
                    break;
                }
                case 5: {
                    color = new Color(iv, im, imid2, ia);
                    break;
                }
                default: {
                    color = Color.BLACK;
                }
            }
        }
        return color;
    }

    public static ValuePane.MultiStyleValueComponentFactory createMultiStyleValueComponentFactory(ValueTree tree, TextStyle textStyle, DataElementStyles dataElementStyles, boolean isFillStyleEnabled, boolean isMarkerStyleEnabled, boolean isLineStyleEnabled, ListSelectionModel selectionModel, SwingActionProvider actionProvider, StringVariable variable, int sortOrder, JComponent parentedComponent, Color defaultBackgroundColor, Channel channel, AbstractMarkerSkinFactory skinFactory) {
        int uvc = variable.getUniqueValueCount();
        HashMap<String, FillStyle> formattedValue2FillStyleMap = isFillStyleEnabled ? new HashMap<String, FillStyle>(uvc) : null;
        HashMap<String, StrokeLineStyle> formattedValue2LineStyleMap = isLineStyleEnabled ? new HashMap<String, StrokeLineStyle>(uvc) : null;
        HashMap<String, MarkerStyle> formattedValue2MarkerStyleMap = isMarkerStyleEnabled || isLineStyleEnabled ? new HashMap<String, MarkerStyle>(uvc) : null;
        FillStyle[] fillStyles = dataElementStyles.getFillStyles();
        StrokeLineStyle[] lineStyles = dataElementStyles.getLineStyles();
        MarkerStyle[] markerStyles = dataElementStyles.getMarkerStyles();
        Color[] cycleColors = dataElementStyles.getDiscreteFillColors();
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        Util.sortOLAPChildrenForLegend(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            FillStyle fillStyle = formattedValue2FillStyleMap != null ? Util.newCycledFillStyle(fillStyles, cycleColors, i) : null;
            StrokeLineStyle lineStyle = formattedValue2LineStyleMap != null ? Util.newCycledLineStyle(lineStyles, cycleColors, i) : null;
            MarkerStyle markerStyle = formattedValue2MarkerStyleMap != null ? Util.newCycledMarkerStyle(markerStyles, cycleColors, i) : null;
            DataTreeGroupNode child = (DataTreeGroupNode)root.getChildAt(i);
            String key = GTKUtil.VariableAccess.getFormattedValue(variable, child.getFirstValueIndex());
            if (formattedValue2FillStyleMap != null) {
                formattedValue2FillStyleMap.put(key, fillStyle);
            }
            if (formattedValue2LineStyleMap != null) {
                formattedValue2LineStyleMap.put(key, lineStyle);
            }
            if (formattedValue2MarkerStyleMap != null) {
                formattedValue2MarkerStyleMap.put(key, markerStyle);
            }
            Util._setupChildStyles(child, variable, formattedValue2FillStyleMap, formattedValue2LineStyleMap, formattedValue2MarkerStyleMap);
        }
        return new ValuePane.MultiStyleValueComponentFactory(textStyle, formattedValue2FillStyleMap, formattedValue2MarkerStyleMap, formattedValue2LineStyleMap, isFillStyleEnabled, isMarkerStyleEnabled, isLineStyleEnabled, selectionModel, actionProvider, variable, parentedComponent, defaultBackgroundColor, channel, skinFactory);
    }

    public static void moveTotalsChildToEnd(DataTreeGroupNode root) {
        DataTreeInfo dti;
        if (root != null && root.isRoot() && (dti = (DataTreeInfo)root.getValue()).getGroupVariableCount() > 0 && dti.getGroupVariableAt(0) instanceof OLAPLevelVariable) {
            int n = root.getChildCount();
            for (int i = 0; i < n - 1; ++i) {
                DataTreeGroupNode node = (DataTreeGroupNode)root.getChildAt(i);
                TupleElementInterface te = (TupleElementInterface)node.getValue();
                try {
                    if (te.getType() == TupleElementType.SUBTOTAL || te.getType() == TupleElementType.TOTAL) {
                        root.remove(i);
                        root.add((MutableTreeNode)node);
                        return;
                    }
                    continue;
                }
                catch (OLAPException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void _setupChildStyles(DataTreeGroupNode parent, StringVariable variable, HashMap formattedValue2FillStyleMap, HashMap formattedValue2LineStyleMap, HashMap formattedValue2MarkerStyleMap) {
        boolean HUE = false;
        boolean SATURATION = true;
        int BRIGHTNESS = 2;
        float saturationMinimum = 0.055f;
        int parentIndex = parent.getFirstValueIndex();
        FillStyle parentFillStyle = null;
        LineStyle parentLineStyle = null;
        MarkerStyle parentMarkerStyle = null;
        String parentKey = null;
        try {
            parentKey = variable.value.getValue(parentIndex);
        }
        catch (MissingValueException e) {
            parentKey = e.getMissingValue();
        }
        if (formattedValue2FillStyleMap != null) {
            parentFillStyle = (FillStyle)formattedValue2FillStyleMap.get(parentKey);
        }
        if (formattedValue2LineStyleMap != null) {
            parentLineStyle = (LineStyle)formattedValue2LineStyleMap.get(parentKey);
        }
        if (formattedValue2MarkerStyleMap != null) {
            parentMarkerStyle = (MarkerStyle)formattedValue2MarkerStyleMap.get(parentKey);
        }
        int childCount = parent.getChildCount();
        float[] hsb = new float[3];
        for (int i = 0; i < childCount; ++i) {
            float saturationIncrement;
            Color color;
            DataTreeGroupNode child = (DataTreeGroupNode)parent.getChildAt(i);
            int childIndex = child.getFirstValueIndex();
            String childKey = null;
            try {
                childKey = variable.value.getValue(childIndex);
            }
            catch (MissingValueException e) {
                childKey = e.getMissingValue();
            }
            if (formattedValue2FillStyleMap != null) {
                FillStyle childFillStyle = new FillStyle();
                childFillStyle.apply(parentFillStyle);
                color = parentFillStyle.getSolidFillColor();
                hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
                saturationIncrement = (hsb[1] - 0.055f) / (float)childCount;
                hsb[1] = hsb[1] - saturationIncrement * (float)i;
                color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
                childFillStyle.setSolidFillColor(color);
                formattedValue2FillStyleMap.put(childKey, childFillStyle);
            }
            if (formattedValue2LineStyleMap != null) {
                StrokeLineStyle childLineStyle = new StrokeLineStyle();
                childLineStyle.apply(parentLineStyle);
                color = parentLineStyle.getColor();
                hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
                saturationIncrement = (hsb[1] - 0.055f) / (float)childCount;
                hsb[1] = hsb[1] - saturationIncrement * (float)i;
                color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
                childLineStyle.setColor(color);
                formattedValue2LineStyleMap.put(childKey, childLineStyle);
            }
            if (formattedValue2MarkerStyleMap != null) {
                MarkerStyle childMarkerStyle = new MarkerStyle();
                childMarkerStyle.apply(parentMarkerStyle);
                color = parentMarkerStyle.getColor();
                hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
                saturationIncrement = (hsb[1] - 0.055f) / (float)childCount;
                hsb[1] = hsb[1] - saturationIncrement * (float)i;
                color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
                childMarkerStyle.setColor(color);
                formattedValue2MarkerStyleMap.put(childKey, childMarkerStyle);
            }
            Util._setupChildStyles(child, variable, formattedValue2FillStyleMap, formattedValue2LineStyleMap, formattedValue2MarkerStyleMap);
        }
    }

    public static HierarchicalPane[] newMatrixAxisPanes(ValueTree tree, GraphMatrixAxisModel matrixAxisModel, ListSelectionModel selectionModel, SwingActionProvider actionProvider, Channel channel) {
        LabelPane labelPane = null;
        ValuePane valuePane = null;
        if (matrixAxisModel.isVisible() && tree.getRoot().getChildCount() > 0) {
            if (matrixAxisModel.getValueCellStyle().getBackgroundVisibilityPolicy() != 10202) {
                ClassificationCellStyle valueCellStyle = matrixAxisModel.getValueCellStyle();
                Util.setupColors(tree, valueCellStyle.getBackgroundColors(), valueCellStyle.getShadingPolicy() == 10201, valueCellStyle.getShadingIntensity());
            }
            LineStyle valueCellFrameLineStyle = matrixAxisModel.getValueCellStyle().getFrameLineStyle();
            TextStyle valueTextStyle = matrixAxisModel.getValueTextStyle();
            valuePane = new ValuePane(tree, valueCellFrameLineStyle, valueTextStyle, selectionModel, actionProvider, channel);
            TextStyle labelTextStyle = matrixAxisModel.getLabelTextStyle();
            labelPane = new LabelPane(matrixAxisModel.getLabel(), tree, labelTextStyle, actionProvider, channel);
        }
        return new HierarchicalPane[]{labelPane, valuePane};
    }

    public static HierarchicalPane[] newColumnWiseAxisPanes(ValueTree tree, AxisModel axisModel, CellPane.CellComponentFactory axisCellFactory, com.sas.graphics.util.gtk.Variable[] labelVariables, LabelPane.LabelComponentFactory axisLabelFactory, Channel channel) {
        return Util.newAxisPanes(tree, null, axisModel, axisCellFactory, labelVariables, axisLabelFactory, channel);
    }

    public static HierarchicalPane[] newRowWiseAxisPanes(ValueTree tree, AxisModel axisModel, CellPane.CellComponentFactory axisCellFactory, com.sas.graphics.util.gtk.Variable[] labelVariables, LabelPane.LabelComponentFactory axisLabelFactory, Channel channel) {
        return Util.newAxisPanes(null, tree, axisModel, axisCellFactory, labelVariables, axisLabelFactory, channel);
    }

    private static HierarchicalPane[] newAxisPanes(ValueTree columnTree, ValueTree rowTree, AxisModel axisModel, CellPane.CellComponentFactory axisCellFactory, com.sas.graphics.util.gtk.Variable[] labelVariables, LabelPane.LabelComponentFactory axisLabelFactory, Channel channel) {
        LabelPane labelPane = null;
        CellPane cellPane = null;
        if (labelVariables != null && labelVariables.length > 0 && axisModel != null && axisModel.isVisible() && axisCellFactory != null) {
            cellPane = new CellPane(columnTree, rowTree, axisCellFactory, channel);
            TextStyle labelTextStyle = axisModel.getLabelTextStyle();
            if (labelTextStyle.isVisible()) {
                labelPane = axisLabelFactory == null ? new LabelPane(labelVariables, labelTextStyle, channel) : new LabelPane(labelVariables, axisLabelFactory, channel);
            }
        }
        return new HierarchicalPane[]{labelPane, cellPane};
    }

    private static void _printMessage(String eText, String messageKey, Locale locale) {
        if (messageKey != null) {
            String message = com.sas.text.Message.format((String)RB.getStringResource("Graph.", "illegalRole.ex.fmt.txt", locale), (Object)eText, (Object)RB.getStringResource("Graph.", messageKey, locale));
            System.err.println(message);
        }
    }

    public static boolean rotateStringComponents(HierarchicalPane pane, double textAngle) {
        Component[] components;
        if (pane != null && (components = pane.getContentPanelComponents()) != null) {
            boolean itsAllGood = true;
            for (int ii = 0; ii < components.length; ++ii) {
                if (!(components[ii] instanceof StringComponent) || ((StringComponent)components[ii]).setTextAngle(textAngle)) continue;
                itsAllGood = false;
            }
            return itsAllGood;
        }
        return false;
    }

    public static void updateChannel(Channel channel, int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        channel.glDisable(27);
        channel.glViewport(0, 0, width, height);
        channel.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        channel.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
        channel.glDisable(4);
        channel.glDisable(3);
    }

    public static double resolveBaselineAngle(TextStyle textStyle) {
        if (textStyle instanceof AdvancedTextStyle) {
            double baselineAngle = ((AdvancedTextStyle)textStyle).getBaselineAngle();
            if (Double.isNaN(baselineAngle)) {
                baselineAngle = 0.0;
            }
            return baselineAngle;
        }
        return 0.0;
    }

    public static void addCellImageMapInfo(ArrayList cells, List imageMapInfoList) {
        int size = cells != null ? cells.size() : 0;
        for (int ii = 0; ii < size; ++ii) {
            Object cellImageMapInfo = null;
            Object cell = cells.get(ii);
            if (cell instanceof ChartImageMapInfo.ChartImageMapInfoAuthorInterface) {
                cellImageMapInfo = ((ChartImageMapInfo.ChartImageMapInfoAuthorInterface)cell).getChartImageMapInfo();
            } else if (cell instanceof PlotImageMapInfo.PlotImageMapInfoAuthorInterface) {
                cellImageMapInfo = ((PlotImageMapInfo.PlotImageMapInfoAuthorInterface)cell).getPlotImageMapInfo();
            }
            if (cellImageMapInfo == null) continue;
            imageMapInfoList.add(cellImageMapInfo);
        }
    }

    public static com.sas.graphics.util.gtk.Variable[] getGTKVariableArray(DataSource dataSource, Object role) {
        com.sas.graphics.util.gtk.Variable[] variableArray = null;
        if (role != null) {
            int length = 0;
            while (dataSource.getVariable(role.toString() + length++) != null) {
            }
            if (--length > 0) {
                variableArray = new com.sas.graphics.util.gtk.Variable[length];
                for (int ii = 0; ii < variableArray.length; ++ii) {
                    variableArray[ii] = dataSource.getVariable(role.toString() + ii, 0);
                }
            }
        }
        return variableArray;
    }

    public static double validateColorPosition(ColorPosition colorPosition) {
        if (colorPosition == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        double position = colorPosition.getPosition();
        if (Double.isNaN(position) || Double.isInfinite(position)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        return position;
    }

    public static ColorPosition[] validateAndCopyColorPositionArray(ColorPosition[] colorPositionArray, boolean isNormalizedEnforced, boolean isDuplicateEntryAllowed) {
        if (colorPositionArray == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (colorPositionArray.length < 2) {
            String message = com.sas.text.Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(1.0).toString(), (Object)new Double(0.0).toString());
            throw new IllegalArgumentException(message);
        }
        double firstPosition = Util.validateColorPosition(colorPositionArray[0]);
        if (isNormalizedEnforced) {
            double lastPosition = Util.validateColorPosition(colorPositionArray[colorPositionArray.length - 1]);
            if (firstPosition < 0.0 || lastPosition > 1.0) {
                String message = com.sas.text.Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(1.0).toString(), (Object)new Double(0.0).toString());
                throw new IllegalArgumentException(message);
            }
        }
        boolean sameAsPrevious = false;
        double previousPosition = firstPosition;
        for (int ii = 1; ii < colorPositionArray.length; ++ii) {
            double position = Util.validateColorPosition(colorPositionArray[ii]);
            if (position < previousPosition) {
                throw new IllegalArgumentException(RB.getStringResource("invalidRangeOrder.ex.txt"));
            }
            if (position == previousPosition) {
                if (!isDuplicateEntryAllowed || sameAsPrevious) {
                    throw new IllegalArgumentException(RB.getStringResource("invalidReplicatedRangeValue.ex.txt"));
                }
                sameAsPrevious = true;
            } else {
                sameAsPrevious = false;
            }
            previousPosition = position;
        }
        return Util.Copier.copyOf(colorPositionArray);
    }

    public static void collate(CategorizationInfo categorizationInfo) {
        SegmentedRangeStyle segmentedRangeStyle;
        if (categorizationInfo != null && (segmentedRangeStyle = categorizationInfo.getSegmentedRangeStyle()) != null) {
            SegmentedRangeStyle altSegmentedRangeStyle;
            DataElementStyles dataElementStyles = segmentedRangeStyle.getDataElementStyles();
            if (dataElementStyles == null && (altSegmentedRangeStyle = categorizationInfo.getAltSegmentedRangeStyle()) != null) {
                dataElementStyles = altSegmentedRangeStyle.getDataElementStyles();
            }
            if (dataElementStyles != null) {
                RangeInfo[] rangeInfos = categorizationInfo.getRangeInfos();
                switch (segmentedRangeStyle.getPaletteType()) {
                    default: {
                        FillStyle[] fillStyles = Util.collate(dataElementStyles.getFillStyles(), rangeInfos.length);
                        MarkerStyle[] markerStyles = Util.collate(dataElementStyles.getMarkerStyles(), rangeInfos.length);
                        LineStyle[] lineStyles = Util.collate(dataElementStyles.getLineStyles(), rangeInfos.length);
                        for (int ii = 0; ii < rangeInfos.length; ++ii) {
                            rangeInfos[ii].setFillStyle(fillStyles[ii % fillStyles.length]);
                            rangeInfos[ii].setMarkerStyle(markerStyles[ii % markerStyles.length]);
                            rangeInfos[ii].setLineStyle(lineStyles[ii % lineStyles.length]);
                        }
                        break;
                    }
                    case 12101: {
                        Color startColor = dataElementStyles.getContinuousFillTwoColorStartColor();
                        Color endColor = dataElementStyles.getContinuousFillTwoColorEndColor();
                        Color[] colors = Util.collate(startColor, endColor, rangeInfos.length);
                        for (int ii = 0; ii < rangeInfos.length; ++ii) {
                            rangeInfos[ii].setColor(colors[ii % colors.length]);
                        }
                        break;
                    }
                    case 12102: {
                        Color startColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                        Color neutralColor = dataElementStyles.getContinuousFillThreeColorNeutralColor();
                        Color endColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                        Color[] colors = Util.collate(startColor, neutralColor, endColor, rangeInfos.length);
                        for (int ii = 0; ii < rangeInfos.length; ++ii) {
                            rangeInfos[ii].setColor(colors[ii % colors.length]);
                        }
                    }
                }
            }
        }
    }

    public static FillStyle[] collate(FillStyle[] fillStyles, int levels) {
        if (fillStyles == null || levels < 1) {
            return null;
        }
        FillStyle[] collatedFillStyles = new FillStyle[levels];
        for (int ii = 0; ii < collatedFillStyles.length; ++ii) {
            FillStyle fillStyle = new FillStyle();
            fillStyle.apply(fillStyles[ii % fillStyles.length]);
            collatedFillStyles[ii] = fillStyle;
        }
        return collatedFillStyles;
    }

    public static LineStyle[] collate(LineStyle[] lineStyles, int levels) {
        if (lineStyles == null || levels < 1) {
            return null;
        }
        LineStyle[] collatedLineStyles = new LineStyle[levels];
        for (int ii = 0; ii < collatedLineStyles.length; ++ii) {
            LineStyle lineStyle = new LineStyle();
            lineStyle.apply(lineStyles[ii % lineStyles.length]);
            collatedLineStyles[ii] = lineStyle;
        }
        return collatedLineStyles;
    }

    public static MarkerStyle[] collate(MarkerStyle[] markerStyles, int levels) {
        if (markerStyles == null || levels < 1) {
            return null;
        }
        MarkerStyle[] collatedMarkerStyles = new MarkerStyle[levels];
        for (int ii = 0; ii < collatedMarkerStyles.length; ++ii) {
            MarkerStyle markerStyle = new MarkerStyle();
            markerStyle.apply(markerStyles[ii % markerStyles.length]);
            collatedMarkerStyles[ii] = markerStyle;
        }
        return collatedMarkerStyles;
    }

    public static Color[] collate(Color startColor, Color endColor, int levels) {
        if (startColor == null || endColor == null || levels < 1) {
            return null;
        }
        float sr = (float)startColor.getRed() / 255.0f;
        float sg = (float)startColor.getGreen() / 255.0f;
        float sb = (float)startColor.getBlue() / 255.0f;
        float sa = (float)startColor.getAlpha() / 255.0f;
        float er = (float)endColor.getRed() / 255.0f;
        float eg = (float)endColor.getGreen() / 255.0f;
        float eb = (float)endColor.getBlue() / 255.0f;
        float ea = (float)endColor.getAlpha() / 255.0f;
        Color[] colors = new Color[levels];
        for (int ii = 0; ii < colors.length; ++ii) {
            float factor = colors.length == 1 ? 0.5f : (float)ii / (float)(colors.length - 1);
            float r = sr + factor * (er - sr);
            float g = sg + factor * (eg - sg);
            float b = sb + factor * (eb - sb);
            float a = sa + factor * (ea - sa);
            colors[ii] = new Color(r, g, b, a);
        }
        return colors;
    }

    public static Color[] collate(Color startColor, Color neutralColor, Color endColor, int levels) {
        if (startColor == null || neutralColor == null || endColor == null || levels < 1) {
            return null;
        }
        float sr = (float)startColor.getRed() / 255.0f;
        float sg = (float)startColor.getGreen() / 255.0f;
        float sb = (float)startColor.getBlue() / 255.0f;
        float sa = (float)startColor.getAlpha() / 255.0f;
        float nr = (float)neutralColor.getRed() / 255.0f;
        float ng = (float)neutralColor.getGreen() / 255.0f;
        float nb = (float)neutralColor.getBlue() / 255.0f;
        float na = (float)neutralColor.getAlpha() / 255.0f;
        float er = (float)endColor.getRed() / 255.0f;
        float eg = (float)endColor.getGreen() / 255.0f;
        float eb = (float)endColor.getBlue() / 255.0f;
        float ea = (float)endColor.getAlpha() / 255.0f;
        Color[] colors = new Color[levels];
        if (colors.length == 1) {
            colors[0] = new Color(nr, ng, nb, na);
        } else {
            float halfWay = (colors.length + 1) / 2;
            for (int ii = 0; ii < colors.length; ++ii) {
                float a;
                float b;
                float g;
                float r;
                float factor = (float)ii / (float)(colors.length - 1);
                if ((float)ii < halfWay) {
                    r = sr + (factor *= 2.0f) * (nr - sr);
                    g = sg + factor * (ng - sg);
                    b = sb + factor * (nb - sb);
                    a = sa + factor * (na - sa);
                } else {
                    r = nr + factor * (er - nr);
                    g = ng + factor * (eg - ng);
                    b = nb + factor * (eb - nb);
                    a = na + factor * (ea - na);
                }
                colors[ii] = new Color(r, g, b, a);
            }
        }
        return colors;
    }

    public static RangeInfo[] categorize(NumericVariable numericVariable, CategorizationModel categorizationModel, Locale locale) {
        if (categorizationModel != null && numericVariable != null) {
            double[] values = new double[numericVariable.getValueCount()];
            for (int jj = 0; jj < values.length; ++jj) {
                try {
                    values[jj] = numericVariable.value.getValue(jj);
                    continue;
                }
                catch (MissingValueException e) {
                    values[jj] = Double.NaN;
                }
            }
            int parameter = categorizationModel.getParameter();
            if (parameter == 0) {
                parameter = 5;
            }
            double[] ranges = null;
            Vector labels = null;
            switch (categorizationModel.getCategorizationType()) {
                default: {
                    SegmentedRangeModel segmentedRangeModel = categorizationModel.getSegmentedRangeModel();
                    if (segmentedRangeModel != null) {
                        ranges = segmentedRangeModel.getSegmentedRange();
                        break;
                    }
                    ranges = Categorizor.getEqualIntervalRanges((double[])values, (int)(parameter < 1 ? 5 : parameter));
                    break;
                }
                case 12001: {
                    ranges = Categorizor.getEqualIntervalRanges((double[])values, (int)parameter);
                    break;
                }
                case 12000: {
                    ranges = Categorizor.getQuantileRanges((double[])values, (int)parameter);
                    break;
                }
                case 12002: {
                    ranges = Categorizor.getNaturalBreaksRanges((double[])values, (int)parameter);
                    break;
                }
                case 12003: {
                    labels = new Vector();
                    ranges = Categorizor.getStandardDeviationRanges((double[])values, labels, (int)parameter, (Locale)locale);
                }
            }
            if (ranges != null && ranges.length > 1) {
                int ii;
                MessageFormat defaultRangeLabelFormat = null;
                if (labels == null || labels.size() != ranges.length - 1) {
                    labels = null;
                    defaultRangeLabelFormat = new MessageFormat(RB.getStringResource("defaultRangeMessageFormat.txt"));
                }
                RangeInfo[] rangeInfos = new RangeInfo[ranges.length - 1];
                for (ii = 0; ii < rangeInfos.length; ++ii) {
                    RangeInfo rangeInfo;
                    double startValue = ranges[ii];
                    double endValue = ranges[ii + 1];
                    Double startValueD = new Double(startValue);
                    Double endValueD = new Double(endValue);
                    String formattedStartValue = numericVariable.getFormatter().format((Object)startValueD).trim();
                    String formattedEndValue = numericVariable.getFormatter().format((Object)endValueD).trim();
                    String label = labels != null ? (String)labels.get(ii) : defaultRangeLabelFormat.format(new Object[]{startValueD, endValueD});
                    String formattedRangeValue = categorizationModel.getRangeMessageFormat().format(new Object[]{startValueD, endValueD, formattedStartValue, formattedEndValue, label}).trim();
                    SegmentedRangeModel srm = categorizationModel.getSegmentedRangeModel();
                    boolean isStartValueIncluded = srm != null ? srm.isBoundaryInHigherSegment() : true;
                    boolean isEndValueIncluded = !isStartValueIncluded;
                    rangeInfos[ii] = rangeInfo = new RangeInfo(startValue, endValue, isStartValueIncluded, isEndValueIncluded, formattedStartValue, formattedEndValue, formattedRangeValue);
                }
                for (ii = 0; ii < rangeInfos.length; ++ii) {
                    if (ii == 0) {
                        rangeInfos[ii].setStartValueIncluded(true);
                    }
                    if (ii == rangeInfos.length - 1) {
                        rangeInfos[ii].setEndValueIncluded(true);
                        continue;
                    }
                    if (rangeInfos[ii].getStartValue() != rangeInfos[ii].getEndValue()) continue;
                    rangeInfos[ii].setStartValueIncluded(true);
                    rangeInfos[ii].setEndValueIncluded(true);
                    if (ii > 0 && rangeInfos[ii - 1].getEndValue() == rangeInfos[ii].getStartValue()) {
                        rangeInfos[ii - 1].setEndValueIncluded(false);
                    }
                    if (rangeInfos[ii + 1].getStartValue() != rangeInfos[ii].getEndValue()) continue;
                    rangeInfos[ii + 1].setStartValueIncluded(false);
                }
                return rangeInfos;
            }
        }
        return null;
    }

    public static Color newColor(Color c, int alpha) {
        if (c != null) {
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return c;
    }

    public static String getFactorLabel(double factor) {
        String factorString = com.sas.graphics.util.gtk.Util.getFactorLabel((double)factor);
        return factorString;
    }

    public static double findFactor(double product) {
        double factor = com.sas.graphics.util.gtk.Util.findFactor((double)product);
        return factor;
    }

    public String getFormattedPositionValue(StringVariable var, ReferenceLineModel rlm) {
        String position = null;
        if (rlm.getPosition() != Double.NaN) {
            position = null;
        }
        return position;
    }

    private static Object _getPositionAsObject(ReferenceLineModel rlm) {
        Object positionAsObject = null;
        if (Double.isNaN(rlm.getPosition())) {
            positionAsObject = rlm.getPositionAsObject();
            if (positionAsObject == null) {
                positionAsObject = new Double(Double.NaN);
            }
        } else {
            positionAsObject = new Double(rlm.getPosition());
        }
        return positionAsObject;
    }

    public static String getFormattedPositionValue(com.sas.graphics.util.gtk.Variable var, ReferenceLineModel rlm) {
        if (var != null) {
            if ((var = var.getRootVariable()) instanceof NumericTableModelVariable) {
                return ((NumericTableModelVariable)var).getFormattedValue(Util._getPositionAsObject(rlm));
            }
            if (var instanceof StringTableModelVariable) {
                return ((StringTableModelVariable)var).getFormattedValue(Util._getPositionAsObject(rlm));
            }
        }
        return null;
    }

    public static String getPositionValue(StringVariable var, ReferenceLineModel rlm) throws MissingValueException {
        if (var != null) {
            com.sas.graphics.util.gtk.Variable rootVar = var.getRootVariable();
            if (rootVar instanceof NumericTableModelVariable) {
                return ((NumericTableModelVariable)rootVar).getFormattedValue(Util._getPositionAsObject(rlm));
            }
            if (rootVar instanceof StringTableModelVariable) {
                return ((StringTableModelVariable)rootVar).getValue(Util._getPositionAsObject(rlm));
            }
        }
        return null;
    }

    public static double getPositionValue(NumericVariable var, ReferenceLineModel rlm) throws MissingValueException {
        com.sas.graphics.util.gtk.Variable rootVar;
        if (var != null && (rootVar = var.getRootVariable()) instanceof NumericTableModelVariable) {
            return ((NumericTableModelVariable)rootVar).getValue(Util._getPositionAsObject(rlm));
        }
        return Double.NaN;
    }

    public static LineSegment newLineSegment(LineStyle lineStyle) {
        LineSegment line = new LineSegment();
        line.color.setValue(lineStyle.getColor());
        line.disableAntialiasingForHorizontalOrVerticalLines.setValue(true);
        if (lineStyle instanceof StrokeLineStyle) {
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes((StrokeLineStyle)lineStyle);
            line.lineWidth.setValue((double)gla.lineWidth);
            line.setStipple(gla.stipplePattern, gla.stippleFactor);
        } else {
            line.lineWidth.setValue(lineStyle.getThickness().getMagnitude((Object)"px"));
        }
        return line;
    }

    public static void addReferenceLines(ReferenceLineModel[] rlma, Channel channel, DataSource dataSource, StringVariable variable, Mapper axisMapper, AxisModel axisModel, double xStart, double xEnd, double yStart, double yEnd, double yAxisLength, double xAxisLength, boolean isHorizontalAxis, Composite lineComposite, Composite labelComposite, int cellRow, int cellColumn, int maxRow, int maxColumn, double translateZ, int automaticJustification, int automaticLabelPlacement, boolean processInFrontRefLines, boolean automaticRefLineVisibilityPolicyValue) {
        if (rlma != null && axisMapper != null) {
            double horizontalBuffer = new BaseLength(4.0, "pt").getMagnitude((Object)"px");
            double verticalBuffer = new BaseLength(2.0, "pt").getMagnitude((Object)"px");
            for (int ii = 0; ii < rlma.length; ++ii) {
                boolean isRefLineVisible;
                TextStyle textStyle;
                int justification;
                if (rlma[ii] == null || !rlma[ii].isVisible() || rlma[ii].isInFront() != processInFrontRefLines) continue;
                double position = Double.NaN;
                String labelText = rlma[ii].getLabel();
                if (axisMapper instanceof StringToNumericMapper) {
                    Object categoryPosition = rlma[ii].getPositionAsObject();
                    if (categoryPosition != null) {
                        double d;
                        if (labelText == null) {
                            labelText = categoryPosition.toString();
                        }
                        if (!Double.isNaN(d = rlma[ii].getPosition()) && !Double.isInfinite(d)) {
                            categoryPosition = new Double(d);
                        }
                    }
                    position = Util.asWorldValue(dataSource, variable, (StringToNumericMap)((StringToNumericMapper)axisMapper).getNumericMap(), categoryPosition);
                } else {
                    Object positionObject = rlma[ii].getPositionAsObject();
                    if (positionObject != null) {
                        if (labelText == null) {
                            labelText = positionObject.toString();
                        }
                        if (positionObject instanceof Number) {
                            position = ((Number)positionObject).doubleValue();
                        } else if (positionObject instanceof String) {
                            try {
                                position = Double.parseDouble((String)positionObject);
                            }
                            catch (NumberFormatException e) {
                                position = rlma[ii].getPosition();
                            }
                        }
                    } else {
                        position = rlma[ii].getPosition();
                        if (labelText == null) {
                            labelText = Double.toString(position);
                        }
                    }
                    ContinuousRangeToNumericMapper m = (ContinuousRangeToNumericMapper)axisMapper;
                    position = position < m.getInputMin() || position > m.getInputMax() ? Double.NaN : m.getValue(position);
                }
                if (Double.isNaN(position)) continue;
                StrokeLineStyle refLineStyle = rlma[ii].getLineStyle() != null ? rlma[ii].getLineStyle() : axisModel.getAxisLineStyle();
                int labelPlacement = rlma[ii].getLabelPlacement();
                if (labelPlacement == 10200) {
                    labelPlacement = automaticLabelPlacement;
                }
                if ((justification = (textStyle = rlma[ii].getTextStyle() != null ? rlma[ii].getTextStyle() : axisModel.getValueTextStyle()).getJustification()) == 10200) {
                    justification = automaticJustification;
                }
                boolean isDrawLabel = textStyle.isVisible() && labelText != null && (labelPlacement == 11320 || labelPlacement == 11321 || labelPlacement == 11301) && (justification == 0 || isHorizontalAxis && justification == 4 && cellRow < 1 || isHorizontalAxis && justification == 2 && cellRow == maxRow || !isHorizontalAxis && justification == 2 && cellColumn < 1 || !isHorizontalAxis && justification == 4 && cellColumn == maxColumn);
                channel.glSelect2DFont(textStyle.getFont());
                double textHeight = channel.glGetTextHeight();
                double textWidth = channel.glGetTextWidth(labelText);
                boolean bl = refLineStyle.getVisibilityPolicy() == 10200 ? automaticRefLineVisibilityPolicyValue : (isRefLineVisible = refLineStyle.getVisibilityPolicy() == 10201);
                if (isRefLineVisible) {
                    LineSegment refLine = Util.newLineSegment(refLineStyle);
                    refLine.selectEnabled.setValue(false);
                    if (isHorizontalAxis) {
                        double beginY = -yStart;
                        double endY = yAxisLength + yStart + yEnd;
                        if (isDrawLabel && labelPlacement == 11301) {
                            if (justification == 4) {
                                endY = yAxisLength + yEnd - textHeight - verticalBuffer;
                            } else if (justification == 2) {
                                beginY += textHeight + verticalBuffer;
                            }
                        }
                        refLine.beginY.setValue(beginY);
                        refLine.endY.setValue(endY);
                        refLine.beginX.setValue(position);
                        refLine.endX.setValue(position);
                        refLine.transform.translateZ.setValue(translateZ);
                    } else {
                        double beginX = -xStart;
                        double endX = xStart + xAxisLength + xEnd;
                        if (isDrawLabel && labelPlacement == 11301) {
                            if (justification == 4) {
                                endX = xAxisLength + xEnd - textWidth - horizontalBuffer;
                            } else if (justification == 2) {
                                beginX += textWidth + horizontalBuffer;
                            }
                        }
                        refLine.beginX.setValue(beginX);
                        refLine.endX.setValue(endX);
                        refLine.beginY.setValue(position);
                        refLine.endY.setValue(position);
                        refLine.transform.translateZ.setValue(translateZ);
                    }
                    lineComposite.addElement((Element)refLine);
                }
                if (!isDrawLabel) continue;
                RasterLabel label = new RasterLabel();
                label.selectEnabled.setValue(false);
                label.trimOn.setValue(false);
                label.string.setValue(labelText);
                Font font = textStyle.getFont();
                label.fontName.setValue(font.getName());
                label.fontSize.setValue(font.getSize());
                label.fontStyle.setValue(font.getStyle());
                label.color.setValue(textStyle.getColor());
                label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
                label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
                label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
                label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
                if (isHorizontalAxis) {
                    label.transform.translateX.setValue(position);
                    if (labelPlacement == 11321) {
                        label.horizontalJustification.setValue(0);
                        label.angle.setValue(90.0);
                    } else if (labelPlacement == 11320 || textStyle.getJustification() == 0) {
                        label.horizontalJustification.setValue(2);
                        label.angle.setValue(90.0);
                    } else {
                        label.horizontalJustification.setValue(1);
                    }
                    if (justification == 2) {
                        label.verticalJustification.setValue(3);
                        label.transform.translateY.setValue(-yStart + verticalBuffer);
                    } else if (justification == 4) {
                        label.verticalJustification.setValue(0);
                        label.transform.translateY.setValue(yAxisLength + yEnd - verticalBuffer);
                    } else if (justification == 0) {
                        label.verticalJustification.setValue(1);
                        label.transform.translateY.setValue((yAxisLength + yEnd) / 2.0);
                    }
                    labelComposite.addElement((Element)label);
                } else {
                    label.transform.translateY.setValue(position);
                    if (labelPlacement == 11320) {
                        label.verticalJustification.setValue(0);
                    } else if (labelPlacement == 11321 || textStyle.getJustification() == 0) {
                        label.verticalJustification.setValue(3);
                    } else {
                        label.verticalJustification.setValue(1);
                    }
                    if (justification == 2) {
                        label.horizontalJustification.setValue(0);
                        label.transform.translateX.setValue(-xStart + horizontalBuffer - 2.0);
                    } else if (justification == 4) {
                        label.horizontalJustification.setValue(2);
                        label.transform.translateX.setValue(xAxisLength + xEnd - horizontalBuffer + 2.0);
                    } else if (justification == 0) {
                        label.horizontalJustification.setValue(1);
                        label.transform.translateX.setValue((xAxisLength + xEnd) / 2.0);
                    }
                    labelComposite.addElement((Element)label);
                }
                label.transform.translateZ.setValue(translateZ);
            }
        }
    }

    public static void sortOLAPChildrenForLegend(DataTreeGroupNode root) {
        if (root != null && root.isRoot()) {
            OLAPLevelVariable levelVariable;
            com.sas.graphics.util.gtk.Variable v;
            DataTreeInfo info = (DataTreeInfo)root.getValue();
            int n = info.getGroupVariableCount();
            boolean isTime = false;
            if (n > 0 && (v = info.getGroupVariableAt(0)) instanceof OLAPLevelVariable && (levelVariable = (OLAPLevelVariable)v).getDimensionType() == 1) {
                isTime = true;
            }
            if (isTime) {
                root.sortChildren(1, true, false, null);
            }
        }
    }

    public static class LabelWithPosition {
        private String labelText;
        private double position;

        public LabelWithPosition(String labelText, double position) {
            this.labelText = labelText;
            this.position = position;
        }

        public static LabelWithPosition getRefLineLabel(ReferenceLineModel model, ContinuousRangeToNumericMapper cm) {
            String labelText = model.getLabel();
            double position = Double.NaN;
            GTKFormat format = cm.getFormat();
            Object positionObject = model.getPositionAsObject();
            if (positionObject != null) {
                if (positionObject instanceof Number) {
                    position = ((Number)positionObject).doubleValue();
                } else if (positionObject instanceof String) {
                    try {
                        position = Double.parseDouble((String)positionObject);
                    }
                    catch (NumberFormatException e) {
                        position = model.getPosition();
                    }
                }
                if (labelText == null) {
                    labelText = positionObject.toString();
                    if (format != null) {
                        labelText = format.format((Object)new Double(position)).trim();
                    }
                }
            } else {
                position = model.getPosition();
                if (labelText == null) {
                    labelText = Double.toString(position);
                    if (format != null) {
                        labelText = format.format((Object)new Double(position)).trim();
                    }
                }
            }
            if (position < cm.getInputMin() || position > cm.getInputMax()) {
                labelText = null;
            }
            return new LabelWithPosition(labelText, position);
        }

        public void setLabelText(String labelText) {
            this.labelText = labelText;
        }

        public String getLabelText() {
            return this.labelText;
        }

        public void setPosition(double position) {
            this.position = position;
        }

        public double getPosition() {
            return this.position;
        }
    }

    public static abstract class DataTreeGroupNodeUtil {
        private static final int NODE_PROCESSING_POLICY_FULL_PATH = 0;
        private static final int NODE_PROCESSING_POLICY_PATH_OF_THIS_HIERARCHY = 1;
        private static final int NODE_PROCESSING_POLICY_PATH_NOT_OF_THIS_HIERARCHY = 2;
        private static String LEVEL_SEPARATER = ", ";

        public static ValueList toValueList(Object node) {
            if (node instanceof DataTreeGroupNode) {
                return DataTreeGroupNodeUtil.toValueList((DataTreeGroupNode)node, 0);
            }
            return null;
        }

        public static ValueList toValueList_pathOfThisHierarchy(Object node) {
            if (node instanceof DataTreeGroupNode) {
                return DataTreeGroupNodeUtil.toValueList((DataTreeGroupNode)node, 1);
            }
            return null;
        }

        public static ValueList toValueList_pathNotOfThisHierarchy(Object node) {
            if (node instanceof DataTreeGroupNode) {
                return DataTreeGroupNodeUtil.toValueList((DataTreeGroupNode)node, 2);
            }
            return null;
        }

        private static ValueList toValueList(DataTreeGroupNode node, int nodeProcessingPolicy) {
            if (node.isRoot()) {
                return null;
            }
            ValueList valueList = null;
            Object previous_n = null;
            for (Object n = node; n != null; n = n.getParent()) {
                if (!(n instanceof DataTreeGroupNode) || n.isRoot()) continue;
                Object value = n.getValue();
                if (!(value instanceof DataTreeInfo)) {
                    boolean isSameHierarchyAsNode = value instanceof TupleElementInterface ? DataTreeGroupNodeUtil.isSameHierarchy(node, n) : node == n;
                    switch (nodeProcessingPolicy) {
                        default: {
                            valueList = DataTreeGroupNodeUtil.prependNodeValueToValueList(valueList, n, previous_n);
                            break;
                        }
                        case 1: {
                            if (!isSameHierarchyAsNode) break;
                            valueList = DataTreeGroupNodeUtil.prependNodeValueToValueList(valueList, n, previous_n);
                            break;
                        }
                        case 2: {
                            if (isSameHierarchyAsNode) break;
                            valueList = DataTreeGroupNodeUtil.prependNodeValueToValueList(valueList, n, previous_n);
                        }
                    }
                }
                previous_n = n;
            }
            return valueList;
        }

        private static String getDataTipValue(DataTreeGroupNode node) {
            if (node != null) {
                String dataTipValue = node.getFormattedValue();
                return dataTipValue;
            }
            return null;
        }

        private static ValueList prependNodeValueToValueList(ValueList valueList, DataTreeGroupNode node, DataTreeGroupNode previous_node) {
            if (node != null) {
                boolean isSameHierarchyAsPrevious_node;
                Object unformattedValue = node.getValue();
                String formattedValue = DataTreeGroupNodeUtil.getDataTipValue(node);
                boolean bl = isSameHierarchyAsPrevious_node = unformattedValue instanceof TupleElementInterface ? DataTreeGroupNodeUtil.isSameHierarchy(node, previous_node) : false;
                if (isSameHierarchyAsPrevious_node && valueList != null) {
                    formattedValue = formattedValue + LEVEL_SEPARATER + valueList.getFormattedValue();
                    unformattedValue = valueList.getUnformattedValue();
                    valueList = new ValueList(unformattedValue, formattedValue, valueList.getNext());
                } else {
                    valueList = new ValueList(unformattedValue, formattedValue, valueList);
                }
            }
            return valueList;
        }

        public static com.sas.graphics.util.gtk.Variable getVariable(DataTreeGroupNode node) {
            DataTreeGroupNode root;
            DataTreeInfo dataTreeInfo;
            if (node != null && !node.isRoot() && (dataTreeInfo = (DataTreeInfo)(root = (DataTreeGroupNode)node.getRoot()).getValue()) != null) {
                return dataTreeInfo.getGroupVariableAt(node.getLevelIndex());
            }
            return null;
        }

        public static String getHierarchyName(DataTreeGroupNode node) {
            com.sas.graphics.util.gtk.Variable variable = DataTreeGroupNodeUtil.getVariable(node);
            if (variable instanceof OLAPLevelVariable) {
                return ((OLAPLevelVariable)variable).getHierachyName();
            }
            return null;
        }

        public static String getLevelName(DataTreeGroupNode node) {
            com.sas.graphics.util.gtk.Variable variable = DataTreeGroupNodeUtil.getVariable(node);
            if (variable instanceof OLAPLevelVariable) {
                return ((OLAPLevelVariable)variable).getLabel();
            }
            return null;
        }

        private static boolean isSameHierarchy(DataTreeGroupNode node1, DataTreeGroupNode node2) {
            if (node1 != null && node2 != null) {
                String node1HierarchyName = DataTreeGroupNodeUtil.getHierarchyName(node1);
                String node2HierarchyName = DataTreeGroupNodeUtil.getHierarchyName(node2);
                if (node1HierarchyName != null && node2HierarchyName != null) {
                    return node1HierarchyName.equals(node2HierarchyName);
                }
            }
            return false;
        }
    }

    public static class ComponentsMessageException
    extends RuntimeException {
        public ComponentsMessageException(String messageKey, Locale locale) {
            super(RB.getStringResource(messageKey, locale));
        }

        public ComponentsMessageException(String localizedMessage) {
            super(localizedMessage);
        }
    }

    public static class SelectInfo {
        public static final int UNSPECIFIED = 0;
        public static final int DATA_TIP_ENABLED = 1;
        public static final int PICK_ENABLED = 2;
        public static final int IMAGE_MAP_INFO_ENABLED = 4;
        public int variant;
        public Object userData;
        public String variableName;
        public String[] variableNames;
        public List overridenIndices;

        public static void selectEnable(Element e, int flags, boolean detailEnabled) {
            if (e != null) {
                SelectInfo selectInfo = null;
                selectInfo = e.getUserData() instanceof SelectInfo ? (SelectInfo)e.getUserData() : new SelectInfo();
                selectInfo.variant = flags;
                e.setUserData((Object)selectInfo);
                e.selectEnabled.setValue(true);
                e.selectDetailEnabled.setValue(detailEnabled);
            }
        }

        public static void selectEnable(Element e, int flags) {
            SelectInfo.selectEnable(e, flags, true);
        }

        public static void selectEnable(Element e, int flags, Object userData) {
            SelectInfo.selectEnable(e, flags, true);
            ((SelectInfo)e.getUserData()).userData = userData;
        }

        public static void selectEnable(Element e, com.sas.graphics.util.gtk.Variable var, int flags) {
            SelectInfo.selectEnable(e, flags, true);
            if (var != null) {
                ((SelectInfo)e.getUserData()).variableName = var.getName();
            }
        }

        public static void selectEnable(Element e, com.sas.graphics.util.gtk.Variable var1, com.sas.graphics.util.gtk.Variable var2, int flags) {
            SelectInfo.selectEnable(e, flags, true);
            if (var1 != null && var2 != null) {
                ((SelectInfo)e.getUserData()).variableNames = new String[]{var1.getName(), var2.getName()};
            } else if (var1 != null) {
                ((SelectInfo)e.getUserData()).variableName = var1.getName();
            } else if (var2 != null) {
                ((SelectInfo)e.getUserData()).variableName = var2.getName();
            }
        }

        public static void selectDisable(Element e) {
            if (e != null) {
                if (e.getUserData() instanceof SelectInfo) {
                    ((SelectInfo)e.getUserData()).variant = 0;
                }
                e.selectEnabled.setValue(false);
                e.selectDetailEnabled.setValue(false);
            }
        }
    }

    public static class DesignTimePlotTableData
    extends DefaultTableModel {
        private static Class[] columnClass = new Class[]{Double.class, Double.class};
        private static String[] columnNames = new String[]{RB.getStringResource("Graph.", "x.txt"), RB.getStringResource("Graph.", "y.txt")};

        public DesignTimePlotTableData() {
            Object[][] data = new Object[][]{{new Double(15.0), new Double(11.0)}, {new Double(10.0), new Double(16.0)}, {new Double(15.0), new Double(13.0)}, {new Double(20.0), new Double(15.0)}, {new Double(17.0), new Double(20.0)}, {new Double(12.0), new Double(17.0)}, {new Double(11.0), new Double(16.0)}, {new Double(13.0), new Double(13.0)}, {new Double(19.0), new Double(14.0)}};
            this.setDataVector(data, columnNames);
        }

        public Class getColumnClass(int column) {
            return columnClass[column];
        }
    }

    public static class DesignTimeChartTableData
    extends DefaultTableModel {
        private static Class[] columnClass = new Class[]{Double.class, String.class};
        private static String[] columnNames = new String[]{RB.getStringResource("Graph.", "response.txt"), RB.getStringResource("Graph.", "category.txt")};

        public DesignTimeChartTableData() {
            Object[][] data = new Object[][]{{new Double(25.0), RB.getStringResource("Graph.", "a.txt")}, {new Double(45.0), RB.getStringResource("Graph.", "b.txt")}, {new Double(30.0), RB.getStringResource("Graph.", "c.txt")}, {new Double(60.0), RB.getStringResource("Graph.", "d.txt")}, {new Double(40.0), RB.getStringResource("Graph.", "e.txt")}};
            this.setDataVector(data, columnNames);
        }

        public Class getColumnClass(int column) {
            return columnClass[column];
        }
    }

    public static abstract class Debug {
        private static long _DEBUG_FLAG_ = 0L;
        public static final long DEBUG_FLAG_PRINTLN = 1 << (int)_DEBUG_FLAG_++;
        public static final long DEBUG_FLAG_VARIABLE_PROCESSOR_DUMP = 1 << (int)_DEBUG_FLAG_++;
        public static final long DEBUG_FLAG_HIERARCHICAL_PANE_DUMP = 1 << (int)_DEBUG_FLAG_++;
        public static final long DEBUG_FLAG_PROPERTY_CHANGE_EVENTS;
        public static final long DEBUG_ENABLED;

        protected static void println(String m) {
            if ((DEBUG_ENABLED & DEBUG_FLAG_PRINTLN) > 0L) {
                System.out.println(m);
            }
        }

        static {
            DEBUG_ENABLED = DEBUG_FLAG_PROPERTY_CHANGE_EVENTS = (long)(1 << (int)_DEBUG_FLAG_++);
        }
    }

    public static abstract class EventProcessing {
        public static PropertyChangeEvent nextProperty(PropertyChangeEvent e) {
            Object nextEvent;
            if (e != null && (nextEvent = e.getPropagationId()) instanceof PropertyChangeEvent && nextEvent != e) {
                return (PropertyChangeEvent)nextEvent;
            }
            return null;
        }

        public static boolean containsProperty(PropertyChangeEvent e, String property) {
            return EventProcessing.seekProperty(e, property) != null;
        }

        public static PropertyChangeEvent seekProperty(PropertyChangeEvent e, String property) {
            if (property != null) {
                while (e != null) {
                    if (property.equals(e.getPropertyName())) {
                        return e;
                    }
                    e = EventProcessing.nextProperty(e);
                }
            }
            return null;
        }

        public static String getPropertyChangeHistory(PropertyChangeEvent e, String delimiterStart, String delimiterEnd) {
            if (delimiterStart == null) {
                delimiterStart = "";
            }
            if (delimiterEnd == null) {
                delimiterEnd = "";
            }
            String s = null;
            while (e != null) {
                s = (s == null ? "" : s) + delimiterStart + e.getPropertyName() + delimiterEnd;
                e = EventProcessing.nextProperty(e);
            }
            return s;
        }

        public static Object getPropertyChangeRootNewValue(PropertyChangeEvent e) {
            PropertyChangeEvent f = null;
            while (e != null) {
                f = e;
                e = EventProcessing.nextProperty(e);
            }
            return f == null ? null : f.getNewValue();
        }

        public static void dumpPropertyChangeEvent(PropertyChangeEvent e) {
            if ((Debug.DEBUG_ENABLED & Debug.DEBUG_FLAG_PROPERTY_CHANGE_EVENTS) > 0L) {
                String propertyHistory = EventProcessing.getPropertyChangeHistory(e, "[", "] => ");
                if (propertyHistory == "") {
                    System.out.println("Blind PropertyChangeEvent");
                } else {
                    String newValue = "\nnewValue(" + EventProcessing.getPropertyChangeRootNewValue(e) + ")\n";
                    System.out.println(propertyHistory.substring(0, propertyHistory.lastIndexOf(" => ")) + newValue);
                }
            }
        }

        public static abstract class FilteredPropertyChangeListener
        implements PropertyChangeListener {
            private final String[] properties;

            public FilteredPropertyChangeListener(String property) {
                this(new String[]{property});
            }

            public FilteredPropertyChangeListener(String[] properties) {
                this.properties = Util.Copier.copyOf(properties);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (this.properties != null) {
                    for (int ii = 0; ii < this.properties.length; ++ii) {
                        PropertyChangeEvent p = EventProcessing.seekProperty(e, this.properties[ii]);
                        if (p == null) continue;
                        this.filteredPropertyChange(e, p);
                    }
                }
            }

            public abstract void filteredPropertyChange(PropertyChangeEvent var1, PropertyChangeEvent var2);
        }
    }

    public static abstract class Validator {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void validate(Color[] colors) {
            if (colors == null) {
                throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
            }
            Color[] colorArray = colors;
            synchronized (colors) {
                for (int ii = 0; ii < colors.length; ++ii) {
                    if (colors[ii] != null) continue;
                    throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static abstract class Message {
        private static final String MessageUIPrefix = "com.sas.graphics.components.MessageModel.";

        public static JComponent createMessageComponent(MessageModel messageModel, Channel channel) {
            if (messageModel == null) {
                return null;
            }
            return Message._createMessageComponent(messageModel.getTitle(), Message.validCopy(messageModel.getMessage()), Message.getIconByMessageType(messageModel.getMessageType()), Message.getTextColorByMessageType(messageModel.getMessageType()), channel);
        }

        private static final Icon createMessageModelIconByName(String name) {
            Icon icon = UIManager.getIcon(MessageUIPrefix + name);
            if (icon == null) {
                icon = UIManager.getIcon("OptionPane." + name);
            }
            return icon;
        }

        private static final Font createMessageModelFontByName(String name) {
            Font font = UIManager.getFont(MessageUIPrefix + name);
            if (font == null) {
                font = UIManager.getFont("OptionPane.messageFont");
            }
            return font;
        }

        private static final Color createMessageModelTextColorByName(String name) {
            return Message.createUIColorByKey(MessageUIPrefix + name, "OptionPane.foreground");
        }

        private static final Color createUIColorByKey(Object key1, Object key2) {
            Color color;
            Color color2 = color = key1 != null ? UIManager.getColor(key1) : null;
            if (key2 != null && color == null) {
                color = UIManager.getColor(key2);
            }
            return color;
        }

        private static final Color getTextColorByMessageType(int messageType) {
            switch (messageType) {
                default: {
                    return Message.createMessageModelTextColorByName("plainMessageForeground");
                }
                case 1: {
                    return Message.createMessageModelTextColorByName("informationMessageForeground");
                }
                case 0: {
                    return Message.createMessageModelTextColorByName("errorMessageForeground");
                }
                case 2: {
                    return Message.createMessageModelTextColorByName("warningMessageForeground");
                }
                case 3: 
            }
            return Message.createMessageModelTextColorByName("questionMessageForeground");
        }

        private static final Icon getIconByMessageType(int messageType) {
            switch (messageType) {
                default: {
                    return null;
                }
                case 0: {
                    return Message.createMessageModelIconByName("errorIcon");
                }
                case 2: {
                    return Message.createMessageModelIconByName("warningIcon");
                }
                case 1: {
                    return Message.createMessageModelIconByName("informationIcon");
                }
                case 3: 
            }
            return Message.createMessageModelIconByName("questionIcon");
        }

        private static String[] validCopy(String[] strings) {
            if (strings == null || strings.length < 1) {
                return null;
            }
            ArrayList<String> al = new ArrayList<String>();
            for (int ii = 0; ii < strings.length; ++ii) {
                if (strings[ii] == null) continue;
                al.add(strings[ii]);
            }
            al.trimToSize();
            return al.size() > 0 ? al.toArray(new String[al.size()]) : null;
        }

        private static JComponent _createMessageComponent(String title, String[] message, Icon icon, Color messageTextColor, Channel channel) {
            if (title == null && message == null) {
                return null;
            }
            Font titleFont = Message.createMessageModelFontByName("titleFont");
            Font messageFont = Message.createMessageModelFontByName("messageFont");
            TextStyle titleTextStyle = new TextStyle(titleFont, messageTextColor, 2, true);
            TextStyle messageTextStyle = new TextStyle(messageFont, messageTextColor, 2, true);
            JComponent iconPanel = icon == null ? null : (new JPanel(){
                Icon icon = null;

                @Override
                public void paintComponent(Graphics g) {
                    if (g != null && this.icon != null) {
                        Rectangle b = this.getBounds();
                        int w = this.icon.getIconWidth();
                        int h = this.icon.getIconHeight();
                        b.y = 0;
                        b.x = 0;
                        if (b.width >= w) {
                            b.x += (b.width - w) / 2;
                        }
                        b.width = w;
                        if (b.height >= h) {
                            b.y += (b.height - h) / 2;
                        }
                        b.height = h;
                        this.icon.paintIcon(this, g, b.x, b.y);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension ps = (Dimension)super.getPreferredSize().clone();
                    if (this.icon == null) {
                        return ps;
                    }
                    return new Dimension(ps.width + this.icon.getIconWidth(), ps.height + this.icon.getIconHeight());
                }

                private JComponent init(Icon icon) {
                    if (icon == null) {
                        return null;
                    }
                    this.icon = icon;
                    this.setOpaque(false);
                    return this;
                }
            }).init(icon);
            JPanel textPanel = new JPanel();
            textPanel.setOpaque(false);
            textPanel.setLayout(new GridLayout((title != null ? 1 : 0) + (message != null ? message.length : 0), 1));
            if (title != null) {
                LabelComponent titleComponent = new LabelComponent(title, titleTextStyle, channel);
                titleComponent.setOpaque(false);
                textPanel.add(titleComponent);
            }
            if (message != null) {
                for (int ii = 0; ii < message.length; ++ii) {
                    LabelComponent messageComponent = new LabelComponent(message[ii], messageTextStyle, channel);
                    messageComponent.setOpaque(false);
                    textPanel.add(messageComponent);
                }
            }
            JPanel informationPanel = new JPanel();
            informationPanel.setOpaque(false);
            informationPanel.setLayout(new BorderLayout());
            int margin = (int)new BaseLength(8.0, "pt").getMagnitude((Object)"px");
            informationPanel.setBorder(new EmptyBorder(margin / 2, margin, margin / 2, margin));
            if (iconPanel != null) {
                informationPanel.add((Component)iconPanel, "West");
            }
            informationPanel.add((Component)textPanel, "Center");
            JPanel signPanel = new JPanel();
            signPanel.setOpaque(true);
            signPanel.setLayout(new BorderLayout());
            signPanel.setBorder(new LineBorder(messageTextColor, 2, true));
            signPanel.setBackground(Message.createUIColorByKey("com.sas.graphics.components.MessageModel.messageBackground", "OptionPane.background"));
            signPanel.add((Component)informationPanel, "Center");
            JPanel container = new JPanel();
            container.setOpaque(false);
            container.setLayout(new BorderLayout());
            container.setBorder(new ShadowBorder(Message.createUIColorByKey("com.sas.graphics.components.MessageModel.messageShadow", "OptionPane.background"), 3));
            container.add((Component)signPanel, "Center");
            return container;
        }
    }

    public static class LabelAndValueZones {
        private final LabelZoneList labelZone;
        private final ValueZone[] valueZones;

        public LabelAndValueZones(LabelZoneList labelZone, ValueZone[] valueZones) {
            this.labelZone = labelZone;
            this.valueZones = valueZones;
        }

        public ValueZone[] getValueZones() {
            return this.valueZones;
        }

        public LabelZoneList getLabelZone() {
            return this.labelZone;
        }
    }

    public static abstract class Events {

        public static class MouseEventListenerRecasterFactory {
            private final JComponent parent;

            public MouseEventListenerRecasterFactory(JComponent p) {
                this.parent = p;
            }

            public MouseListener newMouseListener() {
                return new MouseListenerRecaster(this.parent);
            }

            public MouseMotionListener newMouseMotionListener() {
                return new MouseMotionListenerRecaster(this.parent);
            }
        }

        public static class MouseListenerRecaster
        extends MouseEventRecaster
        implements MouseListener {
            MouseListenerRecaster(JComponent p) {
                super(p);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }
        }

        public static class MouseMotionListenerRecaster
        extends MouseEventRecaster
        implements MouseMotionListener {
            MouseMotionListenerRecaster(JComponent p) {
                super(p);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.parent.dispatchEvent(this.recast(e));
            }
        }

        private static abstract class MouseEventRecaster {
            protected final JComponent parent;

            MouseEventRecaster(JComponent p) {
                this.parent = p;
            }

            public MouseEvent recast(MouseEvent e) {
                if (e != null) {
                    Component source = (Component)e.getSource();
                    int id = e.getID();
                    long when = e.getWhen();
                    int modifiers = e.getModifiers();
                    int x = e.getX();
                    int y = e.getY();
                    int clickCount = e.getClickCount();
                    boolean popupTrigger = e.isPopupTrigger();
                    int button = e.getButton();
                    Point p = Util.toAscendent(x, y, this.parent, (JComponent)source);
                    source = this.parent;
                    x = (int)p.getX();
                    y = (int)p.getY();
                    e = new MouseEvent(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
                }
                return e;
            }
        }
    }

    public static abstract class Text {
        public static void renderAttributedString(Graphics2D g2d, Rectangle displayArea, AttributedString attributedString, int verticalAlignment, int horizontalAlignment, Insets margin) {
            if (g2d == null || displayArea == null || attributedString == null) {
                return;
            }
            if (margin != null) {
                displayArea.x += margin.left;
                displayArea.y += margin.top;
                displayArea.width -= margin.left + margin.right;
                displayArea.height -= margin.top + margin.bottom;
            }
            if (displayArea.width < 1 || displayArea.height < 1) {
                return;
            }
            Rectangle originalClipBounds = g2d.getClipBounds();
            g2d.setClip(displayArea);
            int xOrigin = displayArea.x;
            int yOrigin = displayArea.y;
            int wrappingWidth = displayArea.width;
            FontRenderContext frc = g2d.getFontRenderContext();
            AttributedCharacterIterator attributedtext = attributedString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(attributedtext, frc);
            if (verticalAlignment == 0) {
                int totalTextHeight = 0;
                while (measurer.getPosition() < attributedtext.getEndIndex()) {
                    TextLayout layout = measurer.nextLayout(wrappingWidth);
                    totalTextHeight = (int)((float)totalTextHeight + layout.getAscent());
                    totalTextHeight = (int)((float)totalTextHeight + layout.getDescent());
                    totalTextHeight = (int)((float)totalTextHeight + layout.getLeading());
                }
                yOrigin += Math.max(0, displayArea.height / 2 - totalTextHeight / 2);
                measurer.setPosition(0);
            }
            while (measurer.getPosition() < attributedtext.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(wrappingWidth);
                if (horizontalAlignment == 0) {
                    xOrigin = displayArea.x + (int)(((double)wrappingWidth - layout.getBounds().getWidth()) / 2.0);
                }
                float dx = layout.isLeftToRight() ? 0.0f : (float)wrappingWidth - layout.getAdvance();
                yOrigin = (int)((float)yOrigin + layout.getAscent());
                layout.draw(g2d, (float)xOrigin + dx, yOrigin);
                yOrigin = (int)((float)yOrigin + layout.getDescent());
                yOrigin = (int)((float)yOrigin + layout.getLeading());
            }
            g2d.setClip(originalClipBounds);
        }
    }
}

