/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.FillStyle;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.BaseBar;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class StringToFillStyleToGTKValues
extends PropertyContainer {
    public final StringProperty input = new StringProperty((PropertyContainer)this, true);
    public final BooleanPipe fillOn = new BooleanFillStyleAccess(0);
    public final BooleanPipe gradientOn = new BooleanFillStyleAccess(1);
    public final BooleanPipe textureOn = new BooleanFillStyleAccess(2);
    public final ColorPipe color1 = new ColorFillStyleAccess(3);
    public final ColorPipe color2 = new ColorFillStyleAccess(4);
    public final IntegerPipe gradientDirection = new IntegerFillStyleAccess(5);
    public final IntegerPipe textureMode = new IntegerFillStyleAccess(6);
    public final IntegerPipe textureStyle = new IntegerFillStyleAccess(7);
    public final IntegerPipe textureIndex = new IntegerFillStyleAccess(8);
    private Map stringToFillStyle;
    private BufferedImage[] textureImages;
    private Map imageIconToTextureIndex = new HashMap();

    public void setStringToFillStyleMap(Map map) {
        this.stringToFillStyle = map;
        this.mapFillStyleImagesToGTKTextures();
        this.setModified();
    }

    public Map getStringToFillStyleMap() {
        return this.stringToFillStyle;
    }

    public BufferedImage[] getTextureImages() {
        return this.textureImages;
    }

    private void mapFillStyleImagesToGTKTextures() {
        this.imageIconToTextureIndex.clear();
        ArrayList<BufferedImage> bufferedImages = new ArrayList<BufferedImage>();
        Set entrySet = this.stringToFillStyle.entrySet();
        for (Map.Entry entry : entrySet) {
            Image image;
            FillStyle fillStyle = (FillStyle)entry.getValue();
            ImageIcon imageIcon = fillStyle.getImageIcon();
            if (imageIcon == null || this.imageIconToTextureIndex.get(imageIcon) != null || (image = imageIcon.getImage()) == null) continue;
            Integer textureIndex = new Integer(bufferedImages.size());
            bufferedImages.add(BaseBar.convertImageToBufferedImage((Image)image));
            this.imageIconToTextureIndex.put(imageIcon, textureIndex);
        }
        this.textureImages = bufferedImages.toArray(new BufferedImage[0]);
    }

    private class BooleanFillStyleAccess
    extends FillStyleAccess
    implements BooleanPipe {
        public BooleanFillStyleAccess(int whichFillStyleProperty) {
            super(whichFillStyleProperty);
        }

        public boolean getValue(int index) throws MissingValueException {
            FillStyle fillStyle = this.getFillStyle(index);
            switch (this.getWhichFillStyleProperty()) {
                default: {
                    throw new RuntimeException("Internal error : Unrecognized fill type");
                }
                case 0: {
                    return fillStyle.isVisible();
                }
                case 1: {
                    return fillStyle.getFillType() == 20001 || fillStyle.getFillType() == 20004;
                }
                case 2: 
            }
            return fillStyle.getFillType() == 20002 || fillStyle.getFillType() == 20003 || fillStyle.getFillType() == 20004;
        }
    }

    private class FillStyleAccess
    implements Pipe {
        public static final int FILL_ON = 0;
        public static final int GRADIENT_ON = 1;
        public static final int TEXTURE_ON = 2;
        public static final int COLOR_1 = 3;
        public static final int COLOR_2 = 4;
        public static final int GRADIENT_DIRECTION = 5;
        public static final int TEXTURE_MODE = 6;
        public static final int TEXTURE_STYLE = 7;
        public static final int TEXTURE_INDEX = 8;
        private int whichFillStyleProperty;

        public FillStyleAccess(int whichFillStyleProperty) {
            this.whichFillStyleProperty = whichFillStyleProperty;
        }

        protected int getWhichFillStyleProperty() {
            return this.whichFillStyleProperty;
        }

        public Formatter getFormatter() {
            return StringToFillStyleToGTKValues.this.input.getFormatter();
        }

        public void init(AInitAction initAction) {
            StringToFillStyleToGTKValues.this.input.init(initAction);
            if (StringToFillStyleToGTKValues.this.stringToFillStyle == null) {
                throw new RuntimeException("");
            }
        }

        public void reset(AResetAction resetAction) {
        }

        protected FillStyle getFillStyle(int i) {
            FillStyle result = null;
            String string = null;
            try {
                string = StringToFillStyleToGTKValues.this.input.getValue(i);
                result = (FillStyle)StringToFillStyleToGTKValues.this.stringToFillStyle.get(string);
            }
            catch (MissingValueException e) {
                result = (FillStyle)StringToFillStyleToGTKValues.this.stringToFillStyle.get(e.getMissingValue());
            }
            if (result == null) {
                throw new RuntimeException("Internal lookup error: FillStyle for: " + string + " valueIndex=" + i + " is undefined.");
            }
            return result;
        }
    }

    private class ColorFillStyleAccess
    extends FillStyleAccess
    implements ColorPipe {
        public ColorFillStyleAccess(int whichFillStyleProperty) {
            super(whichFillStyleProperty);
        }

        public Color getValue(int index) throws MissingValueException {
            FillStyle fillStyle = this.getFillStyle(index);
            switch (this.getWhichFillStyleProperty()) {
                default: {
                    throw new RuntimeException("internal error");
                }
                case 3: {
                    switch (fillStyle.getFillType()) {
                        case 20001: {
                            return fillStyle.getGradientFillBeginColor();
                        }
                        case 20004: {
                            return fillStyle.getGradientBlendBeginColor();
                        }
                        case 20002: {
                            return fillStyle.getImageFillColor();
                        }
                        case 20003: {
                            return fillStyle.getSolidBlendColor();
                        }
                        case 20000: {
                            return fillStyle.getSolidFillColor();
                        }
                    }
                    throw new RuntimeException("Internal error : Unrecognized fill type.");
                }
                case 4: 
            }
            switch (fillStyle.getFillType()) {
                case 20001: {
                    return fillStyle.getGradientFillEndColor();
                }
                case 20004: {
                    return fillStyle.getGradientBlendEndColor();
                }
                case 20002: {
                    return fillStyle.getImageFillColor();
                }
                case 20003: {
                    return fillStyle.getSolidBlendColor();
                }
                case 20000: {
                    return fillStyle.getSolidFillColor();
                }
            }
            throw new RuntimeException("Internal error : Unrecognized fill type.");
        }
    }

    private class IntegerFillStyleAccess
    extends FillStyleAccess
    implements IntegerPipe {
        public IntegerFillStyleAccess(int whichFillStyleProperty) {
            super(whichFillStyleProperty);
        }

        public int getValue(int index) throws MissingValueException {
            FillStyle fillStyle = this.getFillStyle(index);
            switch (this.getWhichFillStyleProperty()) {
                default: {
                    throw new RuntimeException("internal error");
                }
                case 5: {
                    return fillStyle.getGradientFill();
                }
                case 6: {
                    switch (fillStyle.getFillType()) {
                        default: {
                            return 2;
                        }
                        case 20003: {
                            return 3;
                        }
                        case 20004: 
                    }
                    return 3;
                }
                case 7: {
                    switch (fillStyle.getImageFill()) {
                        default: {
                            return 5;
                        }
                        case 20200: 
                    }
                    return 4;
                }
                case 8: 
            }
            Integer bigI = (Integer)StringToFillStyleToGTKValues.this.imageIconToTextureIndex.get(fillStyle.getImageIcon());
            return bigI != null ? bigI : 0;
        }
    }
}

