/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class ShadowBorder
extends AbstractBorder {
    private static Border defaultShadow;
    protected int thickness;
    protected Color shadowColor;

    public static Border newDefaultShadowBorder() {
        if (defaultShadow == null) {
            defaultShadow = new ShadowBorder(new Color(128, 128, 128, 128), 3);
        }
        return defaultShadow;
    }

    public ShadowBorder(Color color) {
        this(color, 3);
    }

    public ShadowBorder(Color color, int thickness) {
        this.shadowColor = color;
        this.thickness = Math.max(0, thickness);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int actualThickness;
        Color prevColor = g.getColor();
        Dimension panelSize = new Dimension(Math.max(0, width - x - this.thickness), Math.max(0, height - y - this.thickness));
        int margin = actualThickness = Math.min(this.thickness, Math.min(panelSize.width / 2, panelSize.height / 2));
        g.setColor(this.shadowColor);
        for (int ii = 0; ii < actualThickness; ++ii) {
            int dx = x + panelSize.width + ii;
            g.drawLine(dx, y + margin, dx, y + panelSize.height + ii - 1);
            int dy = panelSize.height + ii;
            g.drawLine(x + margin, dy, x + panelSize.width + ii, dy);
        }
        g.setColor(prevColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.right = insets.bottom = this.thickness;
        return insets;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

