/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import java.awt.Color;

public class RangeInfo {
    private double startValue;
    private double endValue;
    private boolean isStartValueIncluded;
    private boolean isEndValueIncluded;
    private String formattedStartValue;
    private String formattedEndValue;
    private String formattedRangeValue;
    private Color color;
    private FillStyle fillStyle;
    private MarkerStyle markerStyle;
    private LineStyle lineStyle;

    public RangeInfo(double startValue, double endValue, boolean isStartValueIncluded, boolean isEndValueIncluded, String formattedStartValue, String formattedEndValue, String formattedRangeValue) {
        this._setStartValue(startValue);
        this._setEndValue(endValue);
        this._setFormattedStartValue(formattedStartValue);
        this._setFormattedEndValue(formattedEndValue);
        this._setFormattedRangeValue(formattedRangeValue);
        this._setStartValueIncluded(isStartValueIncluded);
        this._setEndValueIncluded(isEndValueIncluded);
    }

    private void _setStartValue(double newStartValue) {
        if (Double.isInfinite(newStartValue) || Double.isNaN(newStartValue)) {
            throw new IllegalArgumentException();
        }
        this.startValue = newStartValue;
    }

    public void setStartValue(double startValue) {
        this._setStartValue(startValue);
    }

    public double getStartValue() {
        return this.startValue;
    }

    private void _setEndValue(double newEndValue) {
        if (Double.isInfinite(newEndValue) || Double.isNaN(newEndValue)) {
            throw new IllegalArgumentException();
        }
        this.endValue = newEndValue;
    }

    public void setEndValue(double endValue) {
        this._setEndValue(endValue);
    }

    public double getEndValue() {
        return this.endValue;
    }

    private void _setFormattedStartValue(String newFormattedStartValue) {
        if (newFormattedStartValue == null) {
            throw new IllegalArgumentException();
        }
        this.formattedStartValue = newFormattedStartValue;
    }

    public void setFormattedStartValue(String formattedStartValue) {
        this._setFormattedStartValue(formattedStartValue);
    }

    public String getFormattedStartValue() {
        return this.formattedStartValue;
    }

    private void _setFormattedEndValue(String newFormattedEndValue) {
        if (newFormattedEndValue == null) {
            throw new IllegalArgumentException();
        }
        this.formattedEndValue = newFormattedEndValue;
    }

    public void setFormattedEndValue(String formattedEndValue) {
        this._setFormattedEndValue(formattedEndValue);
    }

    public String getFormattedEndValue() {
        return this.formattedEndValue;
    }

    private void _setFormattedRangeValue(String newFormattedRangeValue) {
        if (newFormattedRangeValue == null) {
            throw new IllegalArgumentException();
        }
        this.formattedRangeValue = newFormattedRangeValue;
    }

    public void setFormattedRangeValue(String formattedRangeValue) {
        this._setFormattedRangeValue(formattedRangeValue);
    }

    public String getFormattedRangeValue() {
        return this.formattedRangeValue;
    }

    public void setColor(Color colors) {
        this.color = colors;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setMarkerStyle(MarkerStyle markerStyle) {
        this.markerStyle = markerStyle;
    }

    public MarkerStyle getMarkerStyle() {
        return this.markerStyle;
    }

    public String toString() {
        return this.formattedRangeValue;
    }

    public final boolean isStartValueIncluded() {
        return this.isStartValueIncluded;
    }

    private final void _setStartValueIncluded(boolean newIsStartValueIncluded) {
        this.isStartValueIncluded = newIsStartValueIncluded;
    }

    public final void setStartValueIncluded(boolean isStartValueIncluded) {
        this._setStartValueIncluded(isStartValueIncluded);
    }

    public final boolean isEndValueIncluded() {
        return this.isEndValueIncluded;
    }

    private final void _setEndValueIncluded(boolean newIsEndValueIncluded) {
        this.isEndValueIncluded = newIsEndValueIncluded;
    }

    public final void setEndValueIncluded(boolean isEndValueIncluded) {
        this._setEndValueIncluded(isEndValueIncluded);
    }
}

