/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Locale;

public class OLAPVariableFactory
extends VariableFactory {
    public static final String RB_KEY = "OLAPVariableFactory.";
    OLAPDataSetInterface olapModel;
    com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPVariableFactory;

    public OLAPVariableFactory(OLAPDataSetInterface newOlapModel, com.sas.graphics.util.gtk.OLAPVariableFactory gtkVariableFactory) {
        this(newOlapModel, gtkVariableFactory, null, 10475);
    }

    public OLAPVariableFactory(OLAPDataSetInterface newOlapModel, com.sas.graphics.util.gtk.OLAPVariableFactory newGtkOLAPVariableFactory, Locale locale, int sortStrategy) {
        super(OLAPVariableFactory._determineFormatLocale(newOlapModel, locale), sortStrategy);
        this.olapModel = newOlapModel;
        this.gtkOLAPVariableFactory = newGtkOLAPVariableFactory;
    }

    @Override
    public boolean isOLAPData() {
        return true;
    }

    @Override
    public boolean isRelationalData() {
        return false;
    }

    private static Locale _determineFormatLocale(OLAPDataSetInterface olap, Locale locale) {
        Locale formatLocale = locale;
        try {
            if (olap != null && olap.getLocale() != null) {
                formatLocale = olap.getLocale();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return formatLocale;
    }

    @Override
    public Object getModel() {
        return this.olapModel;
    }

    @Override
    public Variable newVariable(VariableDefinition varDef) throws IllegalStateException {
        OLAPLevelVariable v = null;
        if (this.olapModel != null && varDef != null && varDef.getColumnName() != null) {
            if (varDef instanceof ClassificationVariableDefinition) {
                v = this.gtkOLAPVariableFactory.newLevelVariable(varDef.getColumnName());
            } else if (varDef instanceof AnalysisVariableDefinition) {
                OLAPMeasureVariable numericVariable = this.gtkOLAPVariableFactory.newMeasureVariable(varDef.getColumnName());
                numericVariable.setFormat(null);
                v = numericVariable;
            } else if (varDef instanceof SelectionVariableDefinition) {
                v = this.gtkOLAPVariableFactory.newListSelectionVariable(((SelectionVariableDefinition)varDef).getSelectionModel(), varDef.getColumnName());
            }
            OLAPVariableFactory.applyNewVariableDefaults((Variable)v);
            if (v != null) {
                VariableDefinition.ModelColumnInfo modelColumnInfo = new VariableDefinition.ModelColumnInfo();
                modelColumnInfo.setColumnName(v.getName());
                modelColumnInfo.setColumnLabel(v.getLabel());
                varDef.setColumnModelColumnInfo(modelColumnInfo);
                if (!(varDef instanceof SelectionVariableDefinition)) {
                    OLAPVariableFactory.applySortStrategy((Variable)v, this.getSortStrategy(), this.getLocale());
                    OLAPVariableFactory._applyFormat((Variable)v, varDef.getFormat(), this.getLocale());
                }
            }
        }
        return v;
    }

    @Override
    public NumericVariable newHighVariable(VariableDefinition varDef) throws IllegalStateException {
        return null;
    }

    @Override
    public NumericVariable newLowVariable(VariableDefinition varDef) throws IllegalStateException {
        return null;
    }

    @Override
    public NumericVariable newTargetVariable(VariableDefinition varDef) throws IllegalStateException {
        return null;
    }

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="this is legacy code and require major restructuring for this violation")
    public Object clone() {
        return new OLAPVariableFactory(this.olapModel, this.gtkOLAPVariableFactory, this.getLocale(), this.getSortStrategy());
    }

    public int getCellIndex(int i, String name) {
        return this.gtkOLAPVariableFactory.getCellIndex(i, name);
    }

    public com.sas.graphics.util.gtk.OLAPVariableFactory getGTKOLAPVariableFactory() {
        return this.gtkOLAPVariableFactory;
    }
}

