/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.PickInfo;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AlignableComponentInterface;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.gl.Annotation;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;

public abstract class NetworkComponent
extends JPanel
implements AlignableComponentInterface {
    private final transient boolean networkRootDrawEnabled;
    private final transient NetworkRoot networkRoot;
    private final transient Composite composite = new Composite();
    private transient NetworkRoot selectRoot;
    private transient NetworkRoot selectionNetworkRoot;
    private transient ListSelectionModel listSelectionModel;
    private transient Rectangle visibleBounds = null;
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private transient int doubleBufferPolicy = 10200;
    private transient BufferedImage image = null;
    private transient boolean createImageEnabled = false;
    private transient boolean imageDirty;
    private transient int skipNetworkDrawTime = 1;
    private transient int networkDrawCount = 0;
    private transient long networkDrawTime;
    private transient long[] networkDrawTimes = new long[3];
    private transient AlignableComponentConstraints alignableComponentConstraints;
    private static final boolean vmCrashWorkaroundAntialiasingDisabled = Boolean.valueOf((String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("com.sas.graphics.components.disableAntialiasing");
        }
    }));
    private transient boolean antiAliasingEnabled;

    public NetworkComponent(Channel channel) {
        this(2, channel);
    }

    public NetworkComponent(int displayMode, Channel channel) {
        this.setOpaque(false);
        if (channel == null) {
            channel = new Channel((Component)this, 2);
            Util.updateChannel(channel, 1, 1);
        }
        this.selectRoot = this.networkRoot = new NetworkRoot(channel);
        this.networkRoot.addElement((Element)this.composite);
        this.networkRootDrawEnabled = true;
        super.setBorder(new DelegationBorder());
    }

    @Override
    public void setBorder(Border b) {
        Border delegationBorder = this.getBorder();
        if (delegationBorder instanceof DelegationBorder) {
            ((DelegationBorder)delegationBorder).setDelegate(b);
        }
    }

    public void dispose() {
    }

    @Override
    public void setAlignableComponentConstraints(AlignableComponentConstraints constraints) {
        this.alignableComponentConstraints = constraints;
        if (this.alignableComponentConstraints != null && this.alignableComponentConstraints.getBounds() != null) {
            this.setBounds(this.alignableComponentConstraints.getBounds());
        }
    }

    @Override
    public AlignableComponentConstraints getPreferredAlignableComponentConstraints(Dimension size) {
        return new AlignableComponentConstraints();
    }

    @Override
    public AlignableComponentConstraints getAlignableComponentConstraints() {
        return this.alignableComponentConstraints;
    }

    public void constructNetwork() {
        this.composite.removeAllElements();
    }

    public void setDoubleBufferPolicy(int p) {
        switch (p) {
            case 10200: 
            case 10201: 
            case 10202: {
                this.doubleBufferPolicy = p;
                boolean bl = this.createImageEnabled = this.doubleBufferPolicy == 10201;
                if (this.doubleBufferPolicy != 10202 || this.image == null) break;
                this.image = null;
                this.imageDirty = true;
                this.networkDrawCount = 0;
                this.skipNetworkDrawTime = 1;
            }
        }
    }

    public int getDoubleBufferPolicy() {
        return this.doubleBufferPolicy;
    }

    public void invalidateBuffer() {
        this.imageDirty = true;
    }

    protected void updateChannel() {
        Channel channel = this.getChannel();
        int width = this.getWidth();
        int height = this.getHeight();
        Util.updateChannel(channel, width, height);
    }

    public void setVisibleBounds(Rectangle bounds) {
        this.visibleBounds = bounds != null ? new Rectangle(bounds) : null;
    }

    public Rectangle getVisibleBounds() {
        if (this.visibleBounds != null) {
            return new Rectangle(this.visibleBounds);
        }
        Rectangle defaultVisibleBounds = this.getBounds();
        defaultVisibleBounds.y = 0;
        defaultVisibleBounds.x = 0;
        return defaultVisibleBounds;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateChannel();
        if (this.image != null && (width != this.image.getWidth(null) || height != this.image.getHeight(null))) {
            this.image = null;
            this.imageDirty = true;
            this.networkDrawCount = 0;
            this.skipNetworkDrawTime = 1;
            this.createImageEnabled = this.doubleBufferPolicy == 10201;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (vmCrashWorkaroundAntialiasingDisabled) {
            this.setAntiAliasingEnabled(false);
        }
        if (this.networkRootDrawEnabled) {
            this.paintComponentImpl(g);
        } else if (this.isAntiAliasingEnabled()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    protected void paintComponentImpl(Graphics g) {
        Rectangle b = this.getBounds();
        if (this.image != null && !this.imageDirty) {
            g.drawImage(this.image, 0, 0, b.width, b.height, null);
        } else {
            Graphics gx = g;
            if (g instanceof Graphics2D) {
                if (this.createImageEnabled && b.width > 0 && b.height > 0 && !Util.isHeadless() && (this.image == null || b.width > this.image.getWidth(this) || b.height > this.image.getHeight(this))) {
                    this.image = null;
                    if ((long)b.width * (long)b.height < 0x400001L) {
                        try {
                            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            GraphicsDevice gs = ge.getDefaultScreenDevice();
                            GraphicsConfiguration gc = gs.getDefaultConfiguration();
                            this.image = gc.createCompatibleImage(b.width, b.height, 3);
                        }
                        catch (RuntimeException e) {
                            this.image = new BufferedImage(b.width, b.height, 6);
                        }
                    }
                }
                if (this.image != null) {
                    g = this.image.createGraphics();
                    g.setClip(0, 0, b.width, b.height);
                    g.setColor(TRANSPARENT_COLOR);
                    ((Graphics2D)g).setComposite(AlphaComposite.Src);
                    ((Graphics2D)g).fill(new Rectangle2D.Float(0.0f, 0.0f, b.width, b.height));
                    ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
                }
                if (this.isAntiAliasingEnabled()) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            }
            super.paintComponent(g);
            this.getChannel().setSingleBufferGraphics(g);
            this.updateChannel();
            long s = System.currentTimeMillis();
            this.networkRoot.draw();
            this.networkDrawTime = System.currentTimeMillis() - s;
            if (this.image != null) {
                gx.drawImage(this.image, 0, 0, b.width, b.height, null);
                g.dispose();
                this.imageDirty = false;
                g = gx;
            } else if (this.doubleBufferPolicy == 10200 && !this.createImageEnabled) {
                if (this.skipNetworkDrawTime < 1) {
                    boolean bl = this.createImageEnabled = this.networkDrawTime >= 200L;
                    if (!this.createImageEnabled) {
                        this.networkDrawTimes[this.networkDrawCount % this.networkDrawTimes.length] = this.networkDrawTime;
                        if (this.networkDrawCount >= this.networkDrawTimes.length) {
                            double sum = 0.0;
                            for (int ii = 0; ii < this.networkDrawTimes.length; ++ii) {
                                sum += (double)this.networkDrawTimes[ii];
                            }
                            this.createImageEnabled = sum / (double)this.networkDrawTimes.length > 55.0;
                        }
                        ++this.networkDrawCount;
                    }
                } else {
                    --this.skipNetworkDrawTime;
                }
            }
        }
        if (this.selectionNetworkRoot != null) {
            this.getChannel().setSingleBufferGraphics(g);
            this.updateChannel();
            this.selectionNetworkRoot.draw();
        }
    }

    public void setAntiAliasingEnabled(boolean b) {
        this.antiAliasingEnabled = b;
    }

    public boolean isAntiAliasingEnabled() {
        return this.antiAliasingEnabled;
    }

    public void setTextAntiAliasingEnabled(boolean b) {
        if (b) {
            this.getChannel().glEnable(14);
        } else {
            this.getChannel().glDisable(14);
        }
    }

    public final boolean isTextAntiAliasingEnabled() {
        return this.getChannel().glIsEnabled(14);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Channel getChannel() {
        return this.networkRoot.getChannel();
    }

    public final NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    public void setSelectionModel(ListSelectionModel lsm) {
        this.listSelectionModel = lsm;
    }

    public ListSelectionModel getSelectionModel() {
        return this.listSelectionModel;
    }

    public NetworkRoot createSelectionNetworkRoot(ListSelectionModel lsm) {
        if (this.selectionNetworkRoot == null) {
            this.setSelectionModel(lsm);
            this.setSelectionNetworkRoot(new NetworkRoot(this.getChannel()));
        }
        return this.selectionNetworkRoot;
    }

    public void setSelectionNetworkRoot(NetworkRoot newSelectionNetworkRoot) {
        this.selectionNetworkRoot = newSelectionNetworkRoot;
    }

    public NetworkRoot getSelectionNetworkRoot() {
        return this.selectionNetworkRoot;
    }

    public void setSelectRoot(NetworkRoot newSelectRoot) {
        this.selectRoot = newSelectRoot == null ? this.networkRoot : newSelectRoot;
    }

    public NetworkRoot getSelectRoot() {
        return this.selectRoot;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public PickInfo createPickInfo(int x, int y, SelectResult sr) {
        return sr != null ? this.createPickInfo(x, y, sr.getValueIndex()) : null;
    }

    public abstract PickInfo createPickInfo(int var1, int var2, int var3);

    public Vector computeImageMapInfoShapes() {
        this.updateChannel();
        Vector<SelectableShape> imageMapInfoShapes = null;
        Vector selectableShapes = this.selectRoot.computeSelectableShapes();
        if (selectableShapes != null) {
            imageMapInfoShapes = new Vector<SelectableShape>(selectableShapes.size());
            for (int ii = 0; ii < selectableShapes.size(); ++ii) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                if (!(element.getUserData() instanceof Util.SelectInfo) || (((Util.SelectInfo)element.getUserData()).variant & 4) <= 0) continue;
                imageMapInfoShapes.add(selectableShape);
            }
        }
        return imageMapInfoShapes;
    }

    protected Util.SelectInfo getSelectInfo(SelectResult sr) {
        Util.SelectInfo result = null;
        if (sr != null && sr.getElement() != null) {
            if (sr.getElement().getUserData() instanceof Util.SelectInfo) {
                result = (Util.SelectInfo)sr.getElement().getUserData();
            }
            return result;
        }
        return null;
    }

    public PickInfo pick(int x, int y) {
        if (this.selectRoot != null) {
            this.updateChannel();
            SelectResult sr = this.selectRoot.selectClosest(x, y, 1, 1);
            if (sr != null && !(sr.getElement() instanceof Annotation)) {
                Util.SelectInfo selectInfo = this.getSelectInfo(sr);
                if (selectInfo != null) {
                    if ((selectInfo.variant & 2) > 0) {
                        return this.createPickInfo(x, y, sr);
                    }
                } else {
                    return this.createPickInfo(x, y, sr);
                }
            }
        }
        return null;
    }

    public PickInfo[] pick(int x, int y, int w, int h) {
        if (this.selectRoot != null) {
            this.updateChannel();
            int ax = x + (w > 1 ? 1 : 0);
            int ay = y + (h > 1 ? 1 : 0);
            int aw = Math.max(1, w - 2);
            int ah = Math.max(1, h - 2);
            Vector selectResults = this.selectRoot.select(ax, ay, aw, ah, true, true);
            return this.selectResultsToPickInfoArray(selectResults, x, y);
        }
        return null;
    }

    public PickInfo select(int x, int y, boolean isControlDown) {
        PickInfo[] pickInfos = this.select(x, y, 1, 1, isControlDown, true, false);
        if (pickInfos != null && pickInfos.length > 0) {
            return pickInfos[0];
        }
        return null;
    }

    public PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isModified) {
        return this.select(x, y, w, h, isControlDown, false, isModified);
    }

    protected PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        PickInfo[] pickInfos = null;
        if (this.selectRoot != null && this.listSelectionModel != null && w > 0 && h > 0) {
            Vector v;
            this.updateChannel();
            int ax = x + (w > 1 ? 1 : 0);
            int ay = y + (h > 1 ? 1 : 0);
            int aw = Math.max(1, w - 2);
            int ah = Math.max(1, h - 2);
            if (isSelectClosest) {
                v = new Vector();
                v.add(this.selectRoot.selectClosest(ax, ay, aw, ah));
            } else {
                v = this.selectRoot.select(ax, ay, aw, ah, true, true);
            }
            if (v != null && v.size() > 0) {
                boolean isValueIsAdjustingTriggered;
                boolean bl = isValueIsAdjustingTriggered = v != null && v.size() > 1 && !this.listSelectionModel.getValueIsAdjusting();
                if (isValueIsAdjustingTriggered) {
                    this.listSelectionModel.setValueIsAdjusting(true);
                }
                for (int ii = 0; ii < v.size(); ++ii) {
                    SelectResult sr = (SelectResult)v.get(ii);
                    Util.SelectInfo selectInfo = this.getSelectInfo(sr);
                    if (selectInfo == null || (selectInfo.variant & 2) <= 0) continue;
                    if (selectInfo.overridenIndices != null && selectInfo.overridenIndices.size() > 0) {
                        for (int i = 0; i < selectInfo.overridenIndices.size(); ++i) {
                            if (!(selectInfo.overridenIndices.get(i) instanceof Integer)) continue;
                            int index = (Integer)selectInfo.overridenIndices.get(i);
                            isModified = this._select(index, selectInfo, isControlDown, isSelectClosest, isModified);
                        }
                        continue;
                    }
                    int index = sr.getValueIndex();
                    isModified = this._select(index, selectInfo, isControlDown, isSelectClosest, isModified);
                }
                if (!isControlDown && !isModified) {
                    this.listSelectionModel.clearSelection();
                }
                if (isValueIsAdjustingTriggered) {
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
                pickInfos = this.selectResultsToPickInfoArray(v, x, y);
            } else if (!isControlDown && !isModified) {
                this.listSelectionModel.clearSelection();
            }
            this.repaint();
        }
        return pickInfos;
    }

    private boolean _select(int index, Util.SelectInfo selectInfo, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        isModified = isControlDown ? (isSelectClosest ? (isModified |= this._toggleSelect(index, selectInfo)) : (isModified |= this._addSelect(index, selectInfo))) : (isModified ? (isModified |= this._addSelect(index, selectInfo)) : (isModified |= this._setSelect(index, selectInfo)));
        return isModified;
    }

    protected boolean select(int index, String variableName, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        isModified = isControlDown ? (isSelectClosest ? (isModified |= this.toggleSelect(index, variableName)) : (isModified |= this.addSelect(index, variableName))) : (isModified ? (isModified |= this.addSelect(index, variableName)) : (isModified |= this.setSelect(index, variableName)));
        return isModified;
    }

    protected boolean select(int index, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        isModified = isControlDown ? (isSelectClosest ? (isModified |= this.toggleSelect(index)) : (isModified |= this.addSelect(index))) : (isModified ? (isModified |= this.addSelect(index)) : (isModified |= this.setSelect(index)));
        return isModified;
    }

    protected PickInfo[] selectResultsToPickInfoArray(Vector selectResults, int x, int y) {
        if (selectResults != null) {
            Vector<PickInfo> pickInfos = new Vector<PickInfo>(selectResults.size());
            for (Object o : selectResults) {
                Util.SelectInfo selectInfo;
                if (!(o instanceof SelectResult) || (selectInfo = this.getSelectInfo((SelectResult)o)) == null || (selectInfo.variant & 2) <= 0) continue;
                pickInfos.add(this.createPickInfo(x, y, (SelectResult)o));
            }
            return pickInfos.size() > 0 ? pickInfos.toArray(new PickInfo[0]) : null;
        }
        return null;
    }

    private boolean _setSelect(int index, Util.SelectInfo selectInfo) {
        boolean isModified = false;
        if (this.listSelectionModel instanceof DataSource.DataSourceListSelectionModel) {
            if (selectInfo.variableName != null) {
                isModified = this.setSelect(index, selectInfo.variableName);
            } else if (selectInfo.variableNames != null) {
                if (selectInfo.variableNames.length > 0) {
                    isModified = this.setSelect(index, selectInfo.variableNames[0]);
                }
                for (int jj = 1; jj < selectInfo.variableNames.length; ++jj) {
                    isModified |= this.addSelect(index, selectInfo.variableNames[jj]);
                }
            } else {
                isModified = this.setSelect(index);
            }
        } else {
            isModified = this.setSelect(index);
        }
        return isModified;
    }

    private boolean _addSelect(int index, Util.SelectInfo selectInfo) {
        boolean isModified = false;
        if (this.listSelectionModel instanceof DataSource.DataSourceListSelectionModel) {
            if (selectInfo.variableName != null) {
                isModified = this.addSelect(index, selectInfo.variableName);
            } else if (selectInfo.variableNames != null) {
                for (int jj = 0; jj < selectInfo.variableNames.length; ++jj) {
                    isModified |= this.addSelect(index, selectInfo.variableNames[jj]);
                }
            } else {
                isModified = this.addSelect(index);
            }
        } else {
            isModified = this.addSelect(index);
        }
        return isModified;
    }

    private boolean _toggleSelect(int index, Util.SelectInfo selectInfo) {
        boolean isModified = false;
        if (this.listSelectionModel instanceof DataSource.DataSourceListSelectionModel) {
            if (selectInfo.variableName != null) {
                isModified = this.toggleSelect(index, selectInfo.variableName);
            } else if (selectInfo.variableNames != null) {
                for (int jj = 0; jj < selectInfo.variableNames.length; ++jj) {
                    isModified |= this.toggleSelect(index, selectInfo.variableNames[jj]);
                }
            } else {
                isModified = this.toggleSelect(index);
            }
        } else {
            isModified = this.toggleSelect(index);
        }
        return isModified;
    }

    protected boolean setSelect(int index) {
        this.listSelectionModel.setSelectionInterval(index, index);
        return true;
    }

    protected boolean addSelect(int index) {
        this.listSelectionModel.addSelectionInterval(index, index);
        return true;
    }

    protected boolean toggleSelect(int index) {
        if (this.listSelectionModel.isSelectedIndex(index)) {
            this.listSelectionModel.removeSelectionInterval(index, index);
        } else {
            this.listSelectionModel.addSelectionInterval(index, index);
        }
        return true;
    }

    protected boolean setSelect(int index, String variableName) {
        try {
            DataSource.DataSourceListSelectionModel dataSourceListSelectionModel = (DataSource.DataSourceListSelectionModel)this.listSelectionModel;
            dataSourceListSelectionModel.setSelectionInterval(index, index, variableName);
            return true;
        }
        catch (ClassCastException e) {
            return this.setSelect(index);
        }
    }

    protected boolean addSelect(int index, String variableName) {
        try {
            DataSource.DataSourceListSelectionModel dataSourceListSelectionModel = (DataSource.DataSourceListSelectionModel)this.listSelectionModel;
            dataSourceListSelectionModel.addSelectionInterval(index, index, variableName);
            return true;
        }
        catch (ClassCastException e) {
            return this.addSelect(index);
        }
    }

    protected boolean toggleSelect(int index, String variableName) {
        try {
            DataSource.DataSourceListSelectionModel dataSourceListSelectionModel = (DataSource.DataSourceListSelectionModel)this.listSelectionModel;
            if (dataSourceListSelectionModel.isSelectedIndex(index, variableName)) {
                dataSourceListSelectionModel.removeSelectionInterval(index, index, variableName);
            } else {
                dataSourceListSelectionModel.addSelectionInterval(index, index, variableName);
            }
            return true;
        }
        catch (ClassCastException e) {
            return this.toggleSelect(index);
        }
    }

    private static class DelegationBorder
    implements Border {
        private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
        Border delegateBorder = null;

        private DelegationBorder() {
        }

        public void setDelegate(Border delegate) {
            this.delegateBorder = delegate;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.delegateBorder != null) {
                return this.delegateBorder.getBorderInsets(c);
            }
            return NO_INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            if (this.delegateBorder != null) {
                return this.delegateBorder.isBorderOpaque();
            }
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.delegateBorder != null) {
                this.delegateBorder.paintBorder(c, g, x, y, width, height);
            }
        }
    }
}

