/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.ListSelectionModel;

public class MultiStyleStringComponent
extends StringComponent {
    private int markerSize;
    private int LINE_LENGTH;
    private final int MARGIN = 2;
    private final int LINE_THICKNESS = 1;
    private final MarkerStyle markerStyle;
    private final LineStyle lineStyle;
    private final TextStyle textStyle;
    private LineSegment line;
    private Marker marker;
    private Dimension preferredSize = null;
    private AbstractMarkerSkinFactory skinFactory;

    public MultiStyleStringComponent(String text, TextStyle textStyle, MarkerStyle markerStyle, LineStyle lineStyle, ListSelectionModel selectionModel, int[] selectionIndexes, ActionUIFactory actionUIFactory, ActionSupportFilter labelFilter, SwingActionProvider actionProvider, HashMap actionSupportFilterAttributes, OLAPDataSetInterface olapDataSet, StringComponent.CellNodeInfo cellNodeInfo, Channel channel, AbstractMarkerSkinFactory skinFactory) {
        super(text, textStyle, selectionModel, selectionIndexes, actionUIFactory, labelFilter, actionProvider, actionSupportFilterAttributes, olapDataSet, cellNodeInfo, channel);
        this.markerStyle = markerStyle;
        this.lineStyle = lineStyle;
        this.textStyle = textStyle;
        this.setAntiAliasingEnabled(channel.glIsEnabled(13));
        this.skinFactory = skinFactory;
        if (!(skinFactory == null || markerStyle != null && markerStyle.isVisible())) {
            this.skin = skinFactory.getSkinImage(3);
        }
        this.createNetwork();
        this.setLayout(null);
        if (this.skin != null) {
            this.setOpaque(false);
        }
    }

    private void createNetwork() {
        Channel channel = this.getChannel();
        Util.updateChannel(channel, 1, 1);
        channel.glSelect2DFont(this.textStyle.getFont());
        this.markerSize = (int)Math.ceil(channel.glGetTextHeight());
        int lineLength = (int)((double)this.markerSize * 5.0 / 3.0);
        if ((lineLength - this.markerSize) % 2 == 1) {
            ++lineLength;
        }
        int n = this.LINE_LENGTH = this.lineStyle == null ? this.markerSize : lineLength;
        if (this.markerStyle != null && this.markerStyle.isVisible()) {
            this.marker = new Marker();
            this.marker.setFast(true);
            this.marker.color.setValue(this.markerStyle.getColor());
            this.marker.type.setValue(this.markerStyle.getSymbol());
            this.marker.size.setValue(this.markerSize);
            this.marker.edgeColor.setValue(this.markerStyle.getColor());
            this.marker.setSkinFactory(this.skinFactory);
            this.getComposite().addElement((Element)this.marker);
        }
        if (this.lineStyle != null && this.lineStyle.getVisibilityPolicy() != 10202) {
            this.line = new LineSegment();
            this.line.color.setValue(this.lineStyle.getColor());
            this.line.lineWidth.setValue(1.0);
            if (this.lineStyle instanceof StrokeLineStyle) {
                GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes((StrokeLineStyle)this.lineStyle);
                this.line.setStipple(gla.stipplePattern, gla.stippleFactor);
            }
            this.getComposite().addElement((Element)this.line);
        }
    }

    @Override
    protected void updateNetwork() {
        Insets outerMargin;
        int stringBump = 0;
        if (this.lineStyle != null) {
            stringBump = 4 + this.LINE_LENGTH;
        } else if (this.markerStyle != null) {
            stringBump = 4 + this.markerSize;
        }
        Insets innerMargin = new Insets(0, stringBump, 0, 0);
        this.getAlignableComponentConstraints().setInnerMargin(innerMargin);
        super.updateNetwork();
        Rectangle b = this.getBounds();
        Rectangle bounds = new Rectangle(0, 0, b.width, b.height);
        if (this.getAlignableComponentConstraints() != null && (outerMargin = this.getAlignableComponentConstraints().getOuterMargin()) != null) {
            bounds.x += outerMargin.left;
            bounds.y += outerMargin.top;
            bounds.width -= outerMargin.left + outerMargin.right;
            bounds.height -= outerMargin.top + outerMargin.bottom;
        }
        if (this.markerStyle != null && this.markerStyle.isVisible()) {
            this.marker.coordX.setValue((double)(bounds.x + 2 + this.LINE_LENGTH / 2));
            this.marker.coordY.setValue((double)b.height - ((double)bounds.y + bounds.getHeight() / 2.0));
            this.marker.coordZ.setValue(0.0);
        }
        if (this.lineStyle != null && this.lineStyle.getVisibilityPolicy() != 10202) {
            this.line.beginX.setValue((double)(bounds.x + 2));
            this.line.beginY.setValue((double)b.height - ((double)bounds.y + bounds.getHeight() / 2.0));
            this.line.endX.setValue((double)(bounds.x + this.LINE_LENGTH + 2));
            this.line.endY.setValue((double)b.height - ((double)bounds.y + bounds.getHeight() / 2.0));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this._computePreferredSize();
        }
        return this.preferredSize;
    }

    public Dimension _computePreferredSize() {
        Dimension ps = super.getPreferredSize();
        int widthPlus = 0;
        if (this.markerStyle != null && this.markerStyle.isVisible()) {
            ps.height = Math.max(ps.height, this.markerSize + 4);
            widthPlus = this.markerSize + 4;
        }
        if (this.lineStyle != null && this.lineStyle.getVisibilityPolicy() != 10202) {
            widthPlus = Math.max(widthPlus, this.LINE_LENGTH + 4);
        }
        ps.width += widthPlus;
        return ps;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }
}

