/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ScrollModelInterface;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.HierarchicalGrid;
import com.sas.graphics.util.cell.HierarchicalLayout;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.MatrixLayout;
import com.sas.graphics.util.cell.NetworkComponent;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.storage.olap.TupleElementInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MatrixContainer
extends JPanel {
    public static final boolean bufferedLabelOrientationEnabled = false;
    private static final String VERTICAL_ORIENTATION = "vertical";
    private static final String HORIZONTAL_ORIENTATION = "horizontal";
    private static final String NEGATIVE_DIRECTION = "negative";
    private static final String POSITIVE_DIRECTION = "positive";
    private static final String AXIS_VALUE_COMPONENT = "axisValueComponent";
    private static final String CELL_INFO = "cellInfo";
    private static final String STRUCT = "struct";
    private static final String GRID_COUNT = "gridCount";
    public static final String SCROLL_MODEL_PROPERTY = "scrollModel";
    private transient JComponent rowAxisContainer;
    private transient JComponent columnAxisContainer;
    private transient JComponent matrixContainer;
    private transient JComponent primaryColumnTabletContainer;
    private transient JComponent secondaryColumnTabletContainer;
    private transient JComponent primaryRowTabletContainer;
    private transient JComponent secondaryRowTabletContainer;
    private transient JComponent primaryColumnDecoratorComponent;
    private transient JComponent secondaryColumnDecoratorComponent;
    private transient JComponent primaryRowDecoratorComponent;
    private transient JComponent secondaryRowDecoratorComponent;
    private transient JComponent mainContainer;
    private transient JScrollPane nScrollPane;
    private transient JScrollPane sScrollPane;
    private transient JScrollPane eScrollPane;
    private transient JScrollPane wScrollPane;
    private transient JPanel nPanel;
    private transient JPanel sPanel;
    private transient JPanel ePanel;
    private transient JPanel wPanel;
    private transient JScrollPane matrixScrollPane;
    private transient JPanel matrixPanel;
    private transient JScrollBar vScrollBar;
    private transient JScrollBar hScrollBar;
    private transient JComponent primaryColumnScrollContainer;
    private transient JComponent secondaryColumnScrollContainer;
    private transient JComponent primaryRowScrollContainer;
    private transient JComponent secondaryRowScrollContainer;
    private transient ValueTree columnValueTree;
    private transient ValueTree rowValueTree;
    private transient GridStruts matrixStruts;
    private transient GridStruts primaryColumnTabletStruts;
    private transient GridStruts secondaryColumnTabletStruts;
    private transient GridStruts primaryRowTabletStruts;
    private transient GridStruts secondaryRowTabletStruts;
    private transient boolean updateRowLayout;
    private transient boolean updateColumnLayout;
    private transient Hashtable rowAxisProperties;
    private transient Hashtable columnAxisProperties;
    private transient int paintGate;
    private transient boolean paintPending;
    private transient MyScrollModel scrollModel;
    private transient PropertyChangeListener scrollModelListener;
    private final transient GridBagConstraints gbConstraints = new GridBagConstraints();
    private transient boolean matrixCellOutlineVisible = false;
    private transient boolean tabletCellOutlineVisible = false;
    private static final TabletCellIdentifier DEFAULT_COLUMN_TABLET_CELL_IDENTIFIER = new TabletCellIdentifier();
    private static final MatrixCellIdentifier DEFAULT_COLUMN_TABLE_CELL_IDENTIFIER = new MatrixCellIdentifier();
    private static final CellInfo DEFAULT_CELL_INFO = new CellInfo(0, 0, 0, 0);
    private transient MatrixLayout matrixLayout = new MatrixLayout();
    private transient boolean fitToScreen = true;
    private transient boolean antialiasedTextEnabled = false;
    private Graph graph;
    private final Channel channel;
    JLabel margin = null;
    LineStyle matrixCellOutlineLineStyle = null;

    public MatrixContainer(Channel channel) {
        this.channel = channel;
        this.init();
        this.setOpaque(false);
        this.paintGate = 0;
        this.paintPending = false;
        this.scrollModelListener = new MyScrollModelListener();
        this.scrollModel = new MyScrollModel(this.hScrollBar, this.vScrollBar);
        this.scrollModel.addPropertyChangeListener(this.scrollModelListener);
        this._applyScrollModelScrollBarPolicies();
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    public void removeAll() {
        int i;
        super.removeAll();
        this.columnValueTree = null;
        this.rowValueTree = null;
        this.matrixStruts = null;
        this.primaryColumnTabletStruts = null;
        this.secondaryColumnTabletStruts = null;
        this.primaryRowTabletStruts = null;
        this.secondaryRowTabletStruts = null;
        this.updateRowLayout = false;
        this.updateColumnLayout = false;
        this.rowAxisProperties = null;
        this.columnAxisProperties = null;
        for (i = 0; i < this.matrixLayout.norths.length; ++i) {
            this.matrixLayout.norths[i] = null;
        }
        for (i = 0; i < this.matrixLayout.wests.length; ++i) {
            this.matrixLayout.wests[i] = null;
        }
        for (i = 0; i < this.matrixLayout.easts.length; ++i) {
            this.matrixLayout.easts[i] = null;
        }
        for (i = 0; i < this.matrixLayout.souths.length; ++i) {
            this.matrixLayout.souths[i] = null;
        }
        this.matrixLayout.center = null;
        this.init();
    }

    private void init() {
        this.rowAxisProperties = new Hashtable();
        this.columnAxisProperties = new Hashtable();
        this.vScrollBar = new JScrollBar(1);
        this.hScrollBar = new JScrollBar(0);
        this.nScrollPane = this._newJScrollPane(false);
        this.sScrollPane = this._newJScrollPane(false);
        this.eScrollPane = this._newJScrollPane(false);
        this.wScrollPane = this._newJScrollPane(false);
        this.nPanel = this._newJPanel(false);
        this.sPanel = this._newJPanel(false);
        this.ePanel = this._newJPanel(false);
        this.wPanel = this._newJPanel(false);
        this.mainContainer = this._newJPanel(this.matrixLayout);
        this.matrixContainer = this._newJPanel(new GridBagLayout());
        this.rowAxisContainer = this._newJPanel(new HierarchicalLayout());
        this.columnAxisContainer = this._newJPanel(new HierarchicalLayout());
        this.primaryColumnTabletContainer = this._newJPanel(new HierarchicalLayout());
        this.secondaryColumnTabletContainer = this._newJPanel(new HierarchicalLayout());
        this.primaryRowTabletContainer = this._newJPanel(new HierarchicalLayout());
        this.secondaryRowTabletContainer = this._newJPanel(new HierarchicalLayout());
        this.primaryColumnScrollContainer = this._newJPanel(new GridBagLayout());
        this.secondaryColumnScrollContainer = this._newJPanel(new GridBagLayout());
        this.primaryRowScrollContainer = this._newJPanel(new GridBagLayout());
        this.secondaryRowScrollContainer = this._newJPanel(new GridBagLayout());
        this.matrixScrollPane = this._newJScrollPane(true);
        this.matrixScrollPane.setHorizontalScrollBar(this.hScrollBar);
        this.matrixScrollPane.setVerticalScrollBar(this.vScrollBar);
        this.matrixPanel = this._newJPanel(true);
        this.matrixLayout.setScrollBarsEnabled(!this.fitToScreen);
        if (!this.fitToScreen) {
            this.matrixScrollPane.getViewport().add(this.matrixContainer);
        } else {
            this.matrixPanel.add((Component)this.matrixContainer, "Center");
        }
        if (!this.fitToScreen) {
            this.mainContainer.add((Component)this.matrixScrollPane, "Center");
        } else {
            this.mainContainer.add((Component)this.matrixPanel, "Center");
        }
        super.setLayout(new BorderLayout());
        this.add((Component)this.mainContainer, "Center");
    }

    public void ensureEastBufferHack() {
        if (this.margin == null) {
            this.margin = new JLabel(RB.getStringResource("fiveSpaces.txt"));
            this.margin.setFont(FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontHelvetica.lcl"), (int)1, (int)24));
        }
        this.setRowDecorator(this.margin, false);
    }

    public void setFitToScreen(boolean b) {
        this.fitToScreen = b;
        this.matrixLayout.setScrollBarsEnabled(!this.fitToScreen);
    }

    public boolean getFitToScreen() {
        return this.fitToScreen;
    }

    public void setAntialiasedTextEnabled(boolean b) {
        this.antialiasedTextEnabled = b;
    }

    public boolean isAntialiasedTextEnabled() {
        return this.antialiasedTextEnabled;
    }

    public void setMatrixCellOutlineVisible(boolean visible) {
        this.matrixCellOutlineVisible = visible;
    }

    public boolean isMatrixCellOutlineVisible() {
        return this.matrixCellOutlineVisible;
    }

    public void setMatrixCellOutlineLineStyle(LineStyle ls) {
        this.matrixCellOutlineLineStyle = ls;
    }

    public LineStyle getMatrixCellOutlineLineStyle() {
        return this.matrixCellOutlineLineStyle;
    }

    public void setTabletCellOutlineVisible(boolean visible) {
        this.tabletCellOutlineVisible = visible;
    }

    public boolean isTabletCellOutlineVisible() {
        return this.tabletCellOutlineVisible;
    }

    private void _setScrollAreaOutlinesVisible(boolean isVisible) {
        if (isVisible) {
            this.nScrollPane.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.sScrollPane.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.eScrollPane.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.wScrollPane.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.nPanel.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.sPanel.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.ePanel.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
            this.wPanel.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
        } else {
            this.nScrollPane.setBorder(null);
            this.sScrollPane.setBorder(null);
            this.eScrollPane.setBorder(null);
            this.wScrollPane.setBorder(null);
            this.nPanel.setBorder(null);
            this.sPanel.setBorder(null);
            this.ePanel.setBorder(null);
            this.wPanel.setBorder(null);
        }
    }

    public ScrollModelInterface getScrollModel() {
        return this.scrollModel;
    }

    private void _applyScrollModelScrollBarPolicies() {
        if (this.scrollModel.getVerticalScrollBarPolicy() == 0) {
            this.mainContainer.add((Component)this.vScrollBar, "East3");
        } else if (this.vScrollBar.getParent() != null) {
            this.vScrollBar.getParent().remove(this.vScrollBar);
        }
        if (this.scrollModel.getHorizontalScrollBarPolicy() == 0) {
            this.mainContainer.add((Component)this.hScrollBar, "South3");
        } else if (this.hScrollBar.getParent() != null) {
            this.hScrollBar.getParent().remove(this.hScrollBar);
        }
    }

    private static GridStruts _initGrid(JComponent gridContainer, ValueTree columnValueTree, ValueTree rowValueTree, Hashtable columnAxisProperties, Hashtable rowAxisProperties) {
        CellInfo cellInfo;
        Strut s;
        Hashtable properties;
        TreeNode child;
        GridStruts gridStruts = new GridStruts();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        gridContainer.removeAll();
        gridContainer.setLayout(new HierarchicalLayout());
        DefaultMutableTreeNode rowRoot = rowValueTree != null ? rowValueTree.getRoot() : null;
        DefaultMutableTreeNode columnRoot = columnValueTree != null ? columnValueTree.getRoot() : null;
        int columnCount = columnRoot == null ? 1 : (Integer)MatrixContainer._getProperty(columnAxisProperties, columnRoot, GRID_COUNT);
        int rowCount = rowRoot == null ? 1 : (Integer)MatrixContainer._getProperty(rowAxisProperties, rowRoot, GRID_COUNT);
        gridStruts.column = new Strut[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            gridStruts.column[i] = Strut.newHorizontalStrut();
            constraints.gridx = i;
            constraints.gridy = -1;
            gridContainer.add((Component)gridStruts.column[i], constraints);
        }
        gridStruts.row = new Strut[rowCount];
        for (int j = 0; j < rowCount; ++j) {
            gridStruts.row[j] = Strut.newVerticalStrut();
            constraints.gridx = -1;
            constraints.gridy = j;
            gridContainer.add((Component)gridStruts.row[j], constraints);
        }
        if (columnRoot instanceof DefaultMutableTreeNode) {
            Enumeration<TreeNode> columnEnum = columnRoot.depthFirstEnumeration();
            while (columnEnum.hasMoreElements()) {
                child = columnEnum.nextElement();
                if (!child.isLeaf()) continue;
                properties = MatrixContainer._getProperties(columnAxisProperties, child);
                s = (Strut)properties.get(STRUCT);
                cellInfo = (CellInfo)properties.get(CELL_INFO);
                if (s == null || cellInfo == null) continue;
                s.addLink(gridStruts.column[cellInfo.column]);
                gridStruts.column[cellInfo.column].addLink(s);
            }
        } else if (columnRoot != null) {
            // empty if block
        }
        if (rowRoot instanceof DefaultMutableTreeNode) {
            Enumeration<TreeNode> rowEnum = rowRoot.depthFirstEnumeration();
            while (rowEnum.hasMoreElements()) {
                child = rowEnum.nextElement();
                if (!child.isLeaf()) continue;
                properties = MatrixContainer._getProperties(rowAxisProperties, child);
                s = (Strut)properties.get(STRUCT);
                cellInfo = (CellInfo)properties.get(CELL_INFO);
                if (s == null || cellInfo == null) continue;
                s.addLink(gridStruts.row[cellInfo.row]);
                gridStruts.row[cellInfo.row].addLink(s);
            }
        } else if (rowRoot != null) {
            // empty if block
        }
        return gridStruts;
    }

    public void setRowValueTree(ValueTree valueTree, GraphMatrixAxisModel rowAxisModel) {
        if (this.rowValueTree != valueTree) {
            this.updateRowLayout = true;
            this.rowValueTree = valueTree;
            this.rowAxisProperties.clear();
            this.rowAxisContainer.removeAll();
            if (this.rowAxisContainer.getParent() != null) {
                this.rowAxisContainer.getParent().remove(this.rowAxisContainer);
            }
            if (this.rowValueTree != null) {
                MatrixContainer._recursiveGridCount(this.rowValueTree.getRoot(), this.rowAxisProperties);
                if (this.rowValueTree != null) {
                    int ii = this.rowValueTree.getDepthCount();
                    this._setScrollAreaOutlinesVisible(false);
                    int frameVisibilityPolicy = rowAxisModel.getValueCellStyle().getFrameLineStyle().getVisibilityPolicy();
                    boolean rowAxisFrameVisible = frameVisibilityPolicy == 10200 ? ii > 1 : frameVisibilityPolicy == 10201;
                    int backgroundColorVisibilityPolicy = rowAxisModel.getValueCellStyle().getBackgroundVisibilityPolicy();
                    boolean colorVisible = backgroundColorVisibilityPolicy == 10200 ? ii > 1 : backgroundColorVisibilityPolicy == 10201;
                    Color labelBackgroundColor = colorVisible ? rowAxisModel.getValueCellStyle().getBackgroundColors()[0] : null;
                    DefaultMutableTreeNode root = this.rowValueTree.getRoot();
                    this._recursiveCreateAxis(this.rowAxisContainer, rowAxisModel, root, this.rowAxisProperties, 0, 0, VERTICAL_ORIENTATION, POSITIVE_DIRECTION, rowAxisFrameVisible, this.antialiasedTextEnabled, labelBackgroundColor);
                    this.rowAxisContainer.removeAll();
                    this.rowAxisContainer.setLayout(new GridLayout(1, 1, 0, 0));
                    this.rowAxisContainer.add(new HierarchicalGrid(null, this.rowValueTree, this.findGraph().getActionProvider(), rowAxisModel.getValueTextStyle(), rowAxisModel.getLabelTextStyle(), null, false, true, true, false, 0, rowAxisFrameVisible, colorVisible, this.channel));
                }
            }
        }
    }

    public ValueTree getRowValueTree() {
        return this.rowValueTree;
    }

    public synchronized void setColumnValueTree(ValueTree valueTree, GraphMatrixAxisModel columnAxisModel) {
        if (valueTree != this.columnValueTree) {
            this.updateColumnLayout = true;
            this.columnValueTree = valueTree;
            this.columnAxisProperties.clear();
            this.columnAxisContainer.removeAll();
            if (this.columnAxisContainer.getParent() != null) {
                this.columnAxisContainer.getParent().remove(this.columnAxisContainer);
            }
            if (this.columnValueTree != null) {
                MatrixContainer._recursiveGridCount(this.columnValueTree.getRoot(), this.columnAxisProperties);
                if (this.columnValueTree != null) {
                    int ii = this.columnValueTree.getDepthCount() - 1;
                    int frameVisibilityPolicy = columnAxisModel.getValueCellStyle().getFrameLineStyle().getVisibilityPolicy();
                    boolean columnAxisFrameVisible = frameVisibilityPolicy == 10200 ? ii > 1 : frameVisibilityPolicy == 10201;
                    int backgroundColorVisibilityPolicy = columnAxisModel.getValueCellStyle().getBackgroundVisibilityPolicy();
                    boolean colorVisible = backgroundColorVisibilityPolicy == 10200 ? ii > 1 : backgroundColorVisibilityPolicy == 10201;
                    Color labelBackgroundColor = colorVisible ? columnAxisModel.getValueCellStyle().getBackgroundColors()[0] : null;
                    DefaultMutableTreeNode root = this.columnValueTree.getRoot();
                    this._recursiveCreateAxis(this.columnAxisContainer, columnAxisModel, root, this.columnAxisProperties, 0, ii, HORIZONTAL_ORIENTATION, NEGATIVE_DIRECTION, columnAxisFrameVisible, this.antialiasedTextEnabled, labelBackgroundColor);
                    this.columnAxisContainer.removeAll();
                    this.columnAxisContainer.setLayout(new GridLayout(1, 1, 0, 0));
                    this.columnAxisContainer.add(new HierarchicalGrid(null, this.columnValueTree, this.findGraph().getActionProvider(), columnAxisModel.getValueTextStyle(), columnAxisModel.getLabelTextStyle(), null, true, false, false, false, 0, columnAxisFrameVisible, colorVisible, this.channel));
                }
            }
        }
    }

    public ValueTree getColumnValueTree() {
        return this.columnValueTree;
    }

    private void validateTable() {
        if (this.updateColumnLayout || this.updateRowLayout) {
            this.updateRowLayout = false;
            this.updateColumnLayout = false;
            this.primaryRowTabletContainer.removeAll();
            this.secondaryRowTabletContainer.removeAll();
            this.primaryColumnTabletContainer.removeAll();
            this.secondaryColumnTabletContainer.removeAll();
            this.matrixStruts = MatrixContainer._initGrid(this.matrixContainer, this.columnValueTree, this.rowValueTree, this.columnAxisProperties, this.rowAxisProperties);
            if (this.rowAxisContainer.getComponentCount() > 0 && !this.rowValueTree.getRoot().isLeaf()) {
                this._resetGBConstranits();
                this.gbConstraints.gridx = 1;
                this.primaryRowScrollContainer.add((Component)this.rowAxisContainer, this.gbConstraints);
            }
            if (this.columnAxisContainer.getComponentCount() > 0 && !this.columnValueTree.getRoot().isLeaf()) {
                this._resetGBConstranits();
                this.gbConstraints.gridy = 2;
                this.primaryColumnScrollContainer.add((Component)this.columnAxisContainer, this.gbConstraints);
            }
            this.validateScrollPanes();
        }
    }

    private void validateScrollPanes() {
        if (this.primaryRowScrollContainer.getComponentCount() == 0 && this.primaryRowScrollContainer.getParent() != null) {
            this.primaryRowScrollContainer.getParent().remove(this.primaryRowScrollContainer);
        }
        if (this.secondaryRowScrollContainer.getComponentCount() == 0 && this.secondaryRowScrollContainer.getParent() != null) {
            this.secondaryRowScrollContainer.getParent().remove(this.secondaryRowScrollContainer);
        }
        if (this.primaryColumnScrollContainer.getComponentCount() == 0 && this.primaryColumnScrollContainer.getParent() != null) {
            this.primaryColumnScrollContainer.getParent().remove(this.primaryColumnScrollContainer);
        }
        if (this.secondaryColumnScrollContainer.getComponentCount() == 0 && this.secondaryColumnScrollContainer.getParent() != null) {
            this.secondaryColumnScrollContainer.getParent().remove(this.secondaryColumnScrollContainer);
        }
        this._resetGBConstranits();
        if (!this.fitToScreen) {
            this._addContentToVerticalScrollPanes(this.vScrollBar, this.wScrollPane, this.primaryRowScrollContainer, this.eScrollPane, this.secondaryRowScrollContainer);
            this._addContentToHorizontalScrollPanes(this.hScrollBar, this.sScrollPane, this.primaryColumnScrollContainer, this.nScrollPane, this.secondaryColumnScrollContainer);
            this._addScrollPane(this.mainContainer, this.nScrollPane, (Object)"North");
            this._addScrollPane(this.mainContainer, this.sScrollPane, (Object)"South");
            this._addScrollPane(this.mainContainer, this.eScrollPane, (Object)"East");
            this._addScrollPane(this.mainContainer, this.wScrollPane, (Object)"West");
        } else {
            this._addContentToVerticalScrollPanes(this.vScrollBar, this.wPanel, this.primaryRowScrollContainer, this.ePanel, this.secondaryRowScrollContainer);
            this._addContentToHorizontalScrollPanes(this.hScrollBar, this.sPanel, this.primaryColumnScrollContainer, this.nPanel, this.secondaryColumnScrollContainer);
            this._addScrollPane(this.mainContainer, this.nPanel, (Object)"North");
            this._addScrollPane(this.mainContainer, this.sPanel, (Object)"South");
            this._addScrollPane(this.mainContainer, this.ePanel, (Object)"East");
            this._addScrollPane(this.mainContainer, this.wPanel, (Object)"West");
        }
        this._applyScrollModelScrollBarPolicies();
    }

    private void _addScrollPane(JComponent container, JScrollPane scrollPane, Object constraints) {
        if (container != null) {
            if (scrollPane.getViewport().getComponentCount() > 0) {
                container.add((Component)scrollPane, constraints);
            } else {
                container.remove(scrollPane);
            }
        }
    }

    private void _addScrollPane(JComponent container, JPanel scrollPane, Object constraints) {
        if (container != null) {
            if (scrollPane.getComponentCount() > 0) {
                container.add((Component)scrollPane, constraints);
            } else {
                container.remove(scrollPane);
            }
        }
    }

    private void _addContentToVerticalScrollPanes(JScrollBar verticalScrollBar, JScrollPane primaryVericalScrollPane, JComponent primaryVerticalScrollContainer, JScrollPane secondaryVerticalScrollPane, JComponent secondaryVerticalScrollContainer) {
        JScrollBar dummy;
        if (primaryVericalScrollPane != null) {
            primaryVericalScrollPane.getViewport().removeAll();
            if (primaryVerticalScrollContainer.getComponentCount() > 0) {
                primaryVericalScrollPane.setVisible(true);
                primaryVericalScrollPane.setVerticalScrollBar(verticalScrollBar);
                primaryVericalScrollPane.getViewport().add(primaryVerticalScrollContainer);
            } else {
                primaryVericalScrollPane.setVisible(false);
                dummy = primaryVericalScrollPane.createVerticalScrollBar();
                primaryVericalScrollPane.setVerticalScrollBar(dummy);
            }
        }
        if (secondaryVerticalScrollPane != null) {
            secondaryVerticalScrollPane.getViewport().removeAll();
            if (secondaryVerticalScrollContainer.getComponentCount() > 0) {
                secondaryVerticalScrollPane.setVisible(true);
                secondaryVerticalScrollPane.setVerticalScrollBar(verticalScrollBar);
                secondaryVerticalScrollPane.getViewport().add(secondaryVerticalScrollContainer);
            } else {
                secondaryVerticalScrollPane.setVisible(false);
                dummy = secondaryVerticalScrollPane.createVerticalScrollBar();
                secondaryVerticalScrollPane.setVerticalScrollBar(dummy);
            }
        }
    }

    private void _addContentToHorizontalScrollPanes(JScrollBar verticalScrollBar, JScrollPane primaryHorizontalScrollPane, JComponent primaryHorizontalScrollContainer, JScrollPane secondaryHorizontalScrollPane, JComponent secondaryHorizontalScrollContainer) {
        JScrollBar dummy;
        if (primaryHorizontalScrollPane != null) {
            primaryHorizontalScrollPane.getViewport().removeAll();
            if (primaryHorizontalScrollContainer.getComponentCount() > 0) {
                primaryHorizontalScrollPane.setVisible(true);
                primaryHorizontalScrollPane.setHorizontalScrollBar(verticalScrollBar);
                primaryHorizontalScrollPane.getViewport().add(primaryHorizontalScrollContainer);
            } else {
                primaryHorizontalScrollPane.setVisible(false);
                dummy = primaryHorizontalScrollPane.createHorizontalScrollBar();
                primaryHorizontalScrollPane.setHorizontalScrollBar(dummy);
            }
        }
        if (secondaryHorizontalScrollPane != null) {
            secondaryHorizontalScrollPane.getViewport().removeAll();
            if (secondaryHorizontalScrollContainer.getComponentCount() > 0) {
                secondaryHorizontalScrollPane.setVisible(true);
                secondaryHorizontalScrollPane.getViewport().add(secondaryHorizontalScrollContainer);
                secondaryHorizontalScrollPane.setHorizontalScrollBar(verticalScrollBar);
            } else {
                secondaryHorizontalScrollPane.setVisible(false);
                dummy = secondaryHorizontalScrollPane.createHorizontalScrollBar();
                secondaryHorizontalScrollPane.setHorizontalScrollBar(dummy);
            }
        }
    }

    private void _addContentToVerticalScrollPanes(JScrollBar verticalScrollBar, JPanel primaryVericalScrollPane, JComponent primaryVerticalScrollContainer, JPanel secondaryVerticalScrollPane, JComponent secondaryVerticalScrollContainer) {
        if (primaryVericalScrollPane != null) {
            primaryVericalScrollPane.removeAll();
            if (primaryVerticalScrollContainer.getComponentCount() > 0) {
                primaryVericalScrollPane.setVisible(true);
                primaryVericalScrollPane.add((Component)primaryVerticalScrollContainer, "Center");
            } else {
                primaryVericalScrollPane.setVisible(false);
            }
        }
        if (secondaryVerticalScrollPane != null) {
            secondaryVerticalScrollPane.removeAll();
            if (secondaryVerticalScrollContainer.getComponentCount() > 0) {
                secondaryVerticalScrollPane.setVisible(true);
                secondaryVerticalScrollPane.add((Component)secondaryVerticalScrollContainer, "Center");
            } else {
                secondaryVerticalScrollPane.setVisible(false);
            }
        }
    }

    private void _addContentToHorizontalScrollPanes(JScrollBar verticalScrollBar, JPanel primaryHorizontalScrollPane, JComponent primaryHorizontalScrollContainer, JPanel secondaryHorizontalScrollPane, JComponent secondaryHorizontalScrollContainer) {
        if (primaryHorizontalScrollPane != null) {
            primaryHorizontalScrollPane.removeAll();
            if (primaryHorizontalScrollContainer.getComponentCount() > 0) {
                primaryHorizontalScrollPane.setVisible(true);
                primaryHorizontalScrollPane.add((Component)primaryHorizontalScrollContainer, "Center");
            } else {
                primaryHorizontalScrollPane.setVisible(false);
            }
        }
        if (secondaryHorizontalScrollPane != null) {
            secondaryHorizontalScrollPane.removeAll();
            if (secondaryHorizontalScrollContainer.getComponentCount() > 0) {
                secondaryHorizontalScrollPane.setVisible(true);
                secondaryHorizontalScrollPane.add((Component)secondaryHorizontalScrollContainer, "Center");
            } else {
                secondaryHorizontalScrollPane.setVisible(false);
            }
        }
    }

    public synchronized void setMatrixCell(JComponent matrixCell, MatrixCellIdentifier matrixCellIdentifier) {
        this.validateTable();
        if (matrixCell != null) {
            CellInfo rowCellInfo;
            if (matrixCellIdentifier == null) {
                matrixCellIdentifier = DEFAULT_COLUMN_TABLE_CELL_IDENTIFIER;
            }
            CellInfo columnCellInfo = this.columnValueTree != null ? (CellInfo)MatrixContainer._getProperty(this.columnAxisProperties, matrixCellIdentifier.columnOrdinal, CELL_INFO) : DEFAULT_CELL_INFO;
            CellInfo cellInfo = rowCellInfo = this.rowValueTree != null ? (CellInfo)MatrixContainer._getProperty(this.rowAxisProperties, matrixCellIdentifier.rowOrdinal, CELL_INFO) : DEFAULT_CELL_INFO;
            if (rowCellInfo != null && columnCellInfo != null) {
                this._resetGBConstranits();
                this.gbConstraints.gridx = columnCellInfo != null ? columnCellInfo.column : 1;
                int n = this.gbConstraints.gridy = rowCellInfo != null ? rowCellInfo.row : 1;
                if (matrixCell instanceof Cell) {
                    ((Cell)matrixCell).row = this.gbConstraints.gridy;
                    ((Cell)matrixCell).column = this.gbConstraints.gridx;
                }
                this.matrixContainer.add((Component)matrixCell, this.gbConstraints);
                this.matrixStruts.column[columnCellInfo.column].addDependent(matrixCell);
                this.matrixStruts.row[rowCellInfo.row].addDependent(matrixCell);
                if (this.matrixCellOutlineVisible) {
                    boolean columnTail;
                    boolean bl = columnCellInfo != null ? columnCellInfo.column == this.matrixStruts.column.length - 1 : (columnTail = true);
                    boolean rowTail = rowCellInfo != null ? rowCellInfo.row == this.matrixStruts.row.length - 1 : true;
                    LineStyle ls = this.getMatrixCellOutlineLineStyle();
                    if (ls != null) {
                        matrixCell.setBorder(new MatteBorder(1, 1, rowTail ? 1 : 0, columnTail ? 1 : 0, ls.getColor()));
                    } else {
                        matrixCell.setBorder(new MatteBorder(0, 0, rowTail ? 0 : 1, columnTail ? 0 : 1, Color.darkGray));
                    }
                }
            }
        }
    }

    protected void drawCellMatrixOutline() {
        this.matrixContainer.setBorder(new MatteBorder(1, 1, 1, 1, Color.darkGray));
    }

    public JComponent getRowMatrixCell(MatrixCellIdentifier cellIdentifier) {
        return null;
    }

    public void setColumnAxisCell(JComponent component, AxisCellIdentifier cellIdentifier) {
    }

    public JComponent getColumnAxisCell(AxisCellIdentifier cellIdentifier) {
        return null;
    }

    public void setRowAxisCell(JComponent component, AxisCellIdentifier cellIdentifier) {
    }

    public JComponent getRowAxisCell(AxisCellIdentifier cellIdentifier) {
        return null;
    }

    public void setColumnAxisLabelCell(JComponent component, AxisLabelCellIdentifier cellIdentifier) {
    }

    public JComponent getColumnAxisLabelCell(AxisLabelCellIdentifier cellIdentifier) {
        return null;
    }

    public void setRowAxisLabelCell(JComponent component, AxisLabelCellIdentifier cellIdentifier) {
    }

    public JComponent getRowAxisLabelCell(AxisLabelCellIdentifier cellIdentifier) {
        return null;
    }

    public void setColumnTabletCell(JComponent component, TabletCellIdentifier cellIdentifier, boolean isPrimary) {
        if (isPrimary) {
            this.setPrimaryColumnTabletCell(component, cellIdentifier);
        } else {
            this.setSecondaryColumnTabletCell(component, cellIdentifier);
        }
    }

    public JComponent getColumnTabletCell(TabletCellIdentifier cellIdentifier, boolean isPrimary) {
        if (isPrimary) {
            return this.getPrimaryColumnTabletCell(cellIdentifier);
        }
        return this.getSecondaryColumnTabletCell(cellIdentifier);
    }

    public void setPrimaryColumnTabletCell(JComponent component, TabletCellIdentifier tabletCellIdentifier) {
        if (component != null) {
            CellInfo cellInfo;
            this.validateTable();
            if (tabletCellIdentifier == null) {
                tabletCellIdentifier = DEFAULT_COLUMN_TABLET_CELL_IDENTIFIER;
            }
            CellInfo cellInfo2 = cellInfo = this.columnAxisProperties.isEmpty() ? new CellInfo() : (CellInfo)MatrixContainer._getProperty(this.columnAxisProperties, tabletCellIdentifier.ordinal, CELL_INFO);
            if (cellInfo != null) {
                if (this.primaryColumnTabletContainer.getComponentCount() == 0) {
                    this.primaryColumnTabletStruts = MatrixContainer._initGrid(this.primaryColumnTabletContainer, this.columnValueTree, null, this.columnAxisProperties, null);
                    if (this.matrixStruts != null && this.matrixStruts.column != null && this.primaryColumnTabletStruts != null && this.primaryColumnTabletStruts.column != null && this.matrixStruts.column.length == this.primaryColumnTabletStruts.column.length) {
                        for (int ii = 0; ii < this.matrixStruts.column.length; ++ii) {
                            this.matrixStruts.column[ii].addLink(this.primaryColumnTabletStruts.column[ii]);
                            this.primaryColumnTabletStruts.column[ii].addLink(this.matrixStruts.column[ii]);
                        }
                    }
                    this._resetGBConstranits();
                    this.gbConstraints.gridy = 1;
                    this.primaryColumnScrollContainer.add((Component)this.primaryColumnTabletContainer, this.gbConstraints);
                }
                this.primaryColumnTabletStruts.column[cellInfo.column].addDependent(component);
                this._resetGBConstranits();
                this.gbConstraints.gridy = tabletCellIdentifier.index;
                this.gbConstraints.gridx = cellInfo.column;
                this.primaryColumnTabletContainer.add((Component)component, this.gbConstraints);
                if (this.tabletCellOutlineVisible) {
                    if (this.columnValueTree != null && this.columnValueTree.getRoot() != null) {
                        component.setBorder(new MatteBorder(1, 1, 0, 0, Color.darkGray));
                    } else {
                        component.setBorder(null);
                    }
                }
                this.validateScrollPanes();
            }
        }
    }

    public JComponent getPrimaryColumnTabletCell(TabletCellIdentifier tabletCellIdentifier) {
        return null;
    }

    public void setSecondaryColumnTabletCell(JComponent component, TabletCellIdentifier tabletCellIdentifier) {
        if (component != null) {
            CellInfo cellInfo;
            this.validateTable();
            if (tabletCellIdentifier == null) {
                tabletCellIdentifier = DEFAULT_COLUMN_TABLET_CELL_IDENTIFIER;
            }
            CellInfo cellInfo2 = cellInfo = this.columnAxisProperties.isEmpty() ? new CellInfo() : (CellInfo)MatrixContainer._getProperty(this.columnAxisProperties, tabletCellIdentifier.ordinal, CELL_INFO);
            if (cellInfo != null) {
                if (this.secondaryColumnTabletContainer.getComponentCount() == 0) {
                    this.secondaryColumnTabletStruts = MatrixContainer._initGrid(this.secondaryColumnTabletContainer, this.columnValueTree, null, this.columnAxisProperties, null);
                    if (this.matrixStruts != null && this.matrixStruts.column != null && this.secondaryColumnTabletStruts != null && this.secondaryColumnTabletStruts.column != null && this.matrixStruts.column.length == this.secondaryColumnTabletStruts.column.length) {
                        for (int ii = 0; ii < this.matrixStruts.column.length; ++ii) {
                            this.matrixStruts.column[ii].addLink(this.secondaryColumnTabletStruts.column[ii]);
                            this.secondaryColumnTabletStruts.column[ii].addLink(this.matrixStruts.column[ii]);
                        }
                    }
                    this._resetGBConstranits();
                    this.gbConstraints.gridy = 2;
                    this.secondaryColumnScrollContainer.add((Component)this.secondaryColumnTabletContainer, this.gbConstraints);
                }
                this._resetGBConstranits();
                this.gbConstraints.gridy = tabletCellIdentifier.index;
                this.gbConstraints.gridx = cellInfo.column;
                this.secondaryColumnTabletContainer.add((Component)component, this.gbConstraints);
                this.secondaryColumnTabletStruts.column[cellInfo.column].addDependent(component);
                if (this.tabletCellOutlineVisible) {
                    if (this.columnValueTree != null && this.columnValueTree.getRoot() != null) {
                        component.setBorder(new MatteBorder(1, 1, 0, 0, Color.darkGray));
                    } else {
                        component.setBorder(null);
                    }
                }
                this.validateScrollPanes();
            }
        }
    }

    public JComponent getSecondaryColumnTabletCell(TabletCellIdentifier cellIdentifier) {
        return null;
    }

    public void setRowTabletCell(JComponent component, TabletCellIdentifier cellIdentifier, boolean isPrimary) {
        if (isPrimary) {
            this.setPrimaryRowTabletCell(component, cellIdentifier);
        } else {
            this.setSecondaryRowTabletCell(component, cellIdentifier);
        }
    }

    public JComponent getRowTabletCell(TabletCellIdentifier cellIdentifier, boolean isPrimary) {
        if (isPrimary) {
            return this.getPrimaryRowTabletCell(cellIdentifier);
        }
        return this.getSecondaryRowTabletCell(cellIdentifier);
    }

    public void setPrimaryRowTabletCell(JComponent component, TabletCellIdentifier tabletCellIdentifier) {
        if (component != null) {
            CellInfo cellInfo;
            this.validateTable();
            if (tabletCellIdentifier == null) {
                tabletCellIdentifier = DEFAULT_COLUMN_TABLET_CELL_IDENTIFIER;
            }
            CellInfo cellInfo2 = cellInfo = this.rowAxisProperties.isEmpty() ? new CellInfo() : (CellInfo)MatrixContainer._getProperty(this.rowAxisProperties, tabletCellIdentifier.ordinal, CELL_INFO);
            if (cellInfo != null) {
                if (this.primaryRowTabletContainer.getComponentCount() == 0) {
                    this.primaryRowTabletStruts = MatrixContainer._initGrid(this.primaryRowTabletContainer, null, this.rowValueTree, null, this.rowAxisProperties);
                    if (this.matrixStruts != null && this.matrixStruts.row != null && this.primaryRowTabletStruts != null && this.primaryRowTabletStruts.row != null && this.matrixStruts.row.length == this.primaryRowTabletStruts.row.length) {
                        for (int ii = 0; ii < this.matrixStruts.row.length; ++ii) {
                            this.matrixStruts.row[ii].addLink(this.primaryRowTabletStruts.row[ii]);
                            this.primaryRowTabletStruts.row[ii].addLink(this.matrixStruts.row[ii]);
                        }
                    }
                    this._resetGBConstranits();
                    this.gbConstraints.gridx = 2;
                    this.primaryRowScrollContainer.add((Component)this.primaryRowTabletContainer, this.gbConstraints);
                }
                this._resetGBConstranits();
                this.gbConstraints.gridx = tabletCellIdentifier.index;
                this.gbConstraints.gridy = cellInfo.row;
                this.primaryRowTabletContainer.add((Component)component, this.gbConstraints);
                this.primaryRowTabletStruts.row[cellInfo.row].addDependent(component);
                if (this.tabletCellOutlineVisible) {
                    if (this.rowValueTree != null && this.rowValueTree.getRoot() != null) {
                        component.setBorder(new MatteBorder(1, 1, 0, 0, Color.darkGray));
                    } else {
                        component.setBorder(null);
                    }
                }
                this.validateScrollPanes();
            }
        }
    }

    public JComponent getPrimaryRowTabletCell(TabletCellIdentifier cellIdentifier) {
        return null;
    }

    public void setSecondaryRowTabletCell(JComponent component, TabletCellIdentifier tabletCellIdentifier) {
        if (component != null && tabletCellIdentifier != null) {
            CellInfo cellInfo;
            this.validateTable();
            if (tabletCellIdentifier == null) {
                tabletCellIdentifier = DEFAULT_COLUMN_TABLET_CELL_IDENTIFIER;
            }
            CellInfo cellInfo2 = cellInfo = this.rowAxisProperties.isEmpty() ? new CellInfo() : (CellInfo)MatrixContainer._getProperty(this.rowAxisProperties, tabletCellIdentifier.ordinal, CELL_INFO);
            if (cellInfo != null) {
                if (this.secondaryRowTabletContainer.getComponentCount() == 0) {
                    this.secondaryRowTabletStruts = MatrixContainer._initGrid(this.secondaryRowTabletContainer, null, this.rowValueTree, null, this.rowAxisProperties);
                    if (this.matrixStruts != null && this.matrixStruts.row != null && this.secondaryRowTabletStruts != null && this.secondaryRowTabletStruts.row != null && this.matrixStruts.row.length == this.secondaryRowTabletStruts.row.length) {
                        for (int ii = 0; ii < this.matrixStruts.row.length; ++ii) {
                            this.matrixStruts.row[ii].addLink(this.secondaryRowTabletStruts.row[ii]);
                            this.secondaryRowTabletStruts.row[ii].addLink(this.matrixStruts.row[ii]);
                        }
                    }
                    this._resetGBConstranits();
                    this.secondaryRowScrollContainer.add((Component)this.secondaryRowTabletContainer, this.gbConstraints);
                }
                this._resetGBConstranits();
                this.gbConstraints.gridx = tabletCellIdentifier.index;
                this.gbConstraints.gridy = cellInfo.row;
                this.secondaryRowTabletContainer.add((Component)component, this.gbConstraints);
                this.secondaryRowTabletStruts.row[cellInfo.row].addDependent(component);
                if (this.tabletCellOutlineVisible) {
                    if (this.rowValueTree != null && this.rowValueTree.getRoot() != null) {
                        component.setBorder(new MatteBorder(1, 1, 0, 0, Color.darkGray));
                    } else {
                        component.setBorder(null);
                    }
                }
                this.validateScrollPanes();
            }
        }
    }

    public JComponent getSecondaryRowTabletCell(TabletCellIdentifier cellIdentifier) {
        return null;
    }

    public synchronized void setRowDecorator(JComponent component, boolean isPrimary) {
        if (isPrimary) {
            if (this.primaryRowDecoratorComponent != component) {
                if (this.primaryRowDecoratorComponent != null && this.primaryRowDecoratorComponent.getParent() != null) {
                    this.primaryRowDecoratorComponent.getParent().remove(this.primaryRowDecoratorComponent);
                }
                this.primaryRowDecoratorComponent = component;
            }
        } else if (this.secondaryRowDecoratorComponent != component) {
            if (this.secondaryRowDecoratorComponent != null && this.secondaryRowDecoratorComponent.getParent() != null) {
                this.secondaryRowDecoratorComponent.getParent().remove(this.secondaryRowDecoratorComponent);
            }
            this.secondaryRowDecoratorComponent = component;
        }
        this._addAsRowDecorator(component, isPrimary);
    }

    public JComponent getRowDecorator(boolean isPrimary) {
        return isPrimary ? this.primaryRowDecoratorComponent : this.secondaryRowDecoratorComponent;
    }

    public synchronized void setColumnDecorator(JComponent component, boolean isPrimary) {
        if (isPrimary) {
            if (this.primaryColumnDecoratorComponent != component) {
                if (this.primaryColumnDecoratorComponent != null && this.primaryRowDecoratorComponent.getParent() != null) {
                    this.primaryColumnDecoratorComponent.getParent().remove(this.primaryColumnDecoratorComponent);
                }
                this.primaryColumnDecoratorComponent = component;
            }
        } else if (this.secondaryColumnDecoratorComponent != component) {
            if (this.secondaryColumnDecoratorComponent != null && this.secondaryColumnDecoratorComponent.getParent() != null) {
                this.secondaryColumnDecoratorComponent.getParent().remove(this.secondaryColumnDecoratorComponent);
            }
            this.secondaryColumnDecoratorComponent = component;
        }
        this._addAsColumnDecorator(component, isPrimary);
    }

    public JComponent getColumnDecorator(boolean isPrimary) {
        return isPrimary ? this.primaryColumnDecoratorComponent : this.secondaryColumnDecoratorComponent;
    }

    private void _addAsRowDecorator(JComponent component, boolean isPrimary) {
        if (component != null) {
            String constraints = null;
            String string = constraints = isPrimary ? "West2" : "East2";
            if (component.getParent() != null) {
                component.getParent().remove(component);
            }
            this.mainContainer.add((Component)component, constraints);
        }
    }

    private void _addAsColumnDecorator(JComponent component, boolean isPrimary) {
        if (component != null) {
            String constraints = null;
            String string = constraints = isPrimary ? "South2" : "North2";
            if (component.getParent() != null) {
                component.getParent().remove(component);
            }
            this.mainContainer.add((Component)component, constraints);
        }
    }

    private void _recursiveCreateAxis(JComponent container, GraphMatrixAxisModel axisModel, TreeNode root, Hashtable propertiesTable, int x, int y, Object axisOrientation, Object direction, boolean frameVisible, boolean antialiasedText, Color backgroundColor) {
        if (root != null && container != null) {
            Enumeration<TreeNode> children = null;
            if (root.getParent() == null && root.isLeaf()) {
                Vector<TreeNode> v = new Vector<TreeNode>(1);
                v.addElement(root);
                children = v.elements();
            } else {
                children = root.children();
            }
            if (children != null) {
                int xChildAdjust;
                int yChildAdjust = axisOrientation == VERTICAL_ORIENTATION ? 0 : 1;
                int n = xChildAdjust = axisOrientation == VERTICAL_ORIENTATION ? 1 : 0;
                if (direction == NEGATIVE_DIRECTION) {
                    xChildAdjust = -xChildAdjust;
                    yChildAdjust = -yChildAdjust;
                }
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = x;
                constraints.gridy = y;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                while (children.hasMoreElements()) {
                    LabelComponent2 valueComponent;
                    TreeNode child = children.nextElement();
                    Hashtable properties = MatrixContainer._getProperties(propertiesTable, child);
                    String valueString = child instanceof DataTreeGroupNode ? ((DataTreeGroupNode)child).getFormattedValue() : (child != null ? child.toString() : null);
                    int cellSize = Integer.MAX_VALUE;
                    if (child.getChildCount() > 0) {
                        for (int i = 0; i < child.getChildCount(); ++i) {
                            cellSize = Math.min(cellSize, ((DataTreeGroupNode)child.getChildAt(i)).getLevelIndex() - ((DataTreeGroupNode)child).getLevelIndex());
                        }
                    } else {
                        DataTreeGroupNode topRoot = (DataTreeGroupNode)root;
                        while (topRoot.getParent() != null) {
                            topRoot = (DataTreeGroupNode)topRoot.getParent();
                        }
                        int maxLevelIndex = ((DataTreeInfo)topRoot.getValue()).getGroupVariableCount() - 1;
                        cellSize = maxLevelIndex - ((DataTreeGroupNode)child).getLevelIndex() + 1;
                    }
                    if (axisOrientation == VERTICAL_ORIENTATION) {
                        constraints.gridwidth = cellSize;
                    } else {
                        constraints.gridheight = cellSize;
                        constraints.gridy -= cellSize - 1;
                    }
                    Integer gridCount = (Integer)properties.get(GRID_COUNT);
                    int size = gridCount == null ? 1 : gridCount;
                    LabelComponent2 labelComponent2 = valueComponent = valueString == null || !axisModel.getValueTextStyle().isVisible() ? null : new LabelComponent2((DataTreeGroupNode)child, axisModel.getValueTextStyle(), this.channel);
                    if (valueComponent != null) {
                        if (constraints.gridheight > 1) {
                            if (axisOrientation == VERTICAL_ORIENTATION) {
                                valueComponent.setAlignmentX(1.0f);
                            } else {
                                valueComponent.setAlignmentY(1.0f);
                            }
                        }
                        if (backgroundColor != null) {
                            float[] hsb = new float[3];
                            Color.RGBtoHSB(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), hsb);
                            Color thisBackgroundColor = backgroundColor;
                            if (((DataTreeGroupNode)child).getValue() instanceof TupleElementInterface) {
                                thisBackgroundColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], (float)((double)hsb[2] - (double)((DataTreeGroupNode)child).getLevelIndex() * 0.1)));
                            }
                            ((DataTreeGroupNode)child).setUserObject((Object)thisBackgroundColor);
                            valueComponent.setOpaque(true);
                            valueComponent.setBackground(thisBackgroundColor);
                        }
                        valueComponent.setMargin(new Insets(2, 2, 3, 3));
                        if (axisOrientation == VERTICAL_ORIENTATION) {
                            valueComponent.setAngle(90.0);
                            if (frameVisible) {
                                ((NetworkComponent)valueComponent).setBorder(new MatteBorder(0, 0, 1, 1, axisModel.getValueCellStyle().getFrameLineStyle().getColor()));
                            }
                        } else if (frameVisible) {
                            ((NetworkComponent)valueComponent).setBorder(new MatteBorder(0, 1, 1, 0, axisModel.getValueCellStyle().getFrameLineStyle().getColor()));
                        }
                        valueComponent.setTextAntiAliasingEnabled(antialiasedText);
                    }
                    if (axisOrientation == VERTICAL_ORIENTATION) {
                        constraints.gridheight = size;
                    } else {
                        constraints.gridwidth = size;
                    }
                    if (valueComponent != null) {
                        container.add((Component)valueComponent, constraints);
                        properties.put(AXIS_VALUE_COMPONENT, valueComponent);
                    }
                    if (axisOrientation == VERTICAL_ORIENTATION) {
                        constraints.gridx = x;
                    } else {
                        constraints.gridy = y;
                    }
                    CellInfo position = new CellInfo(constraints.gridx, constraints.gridy, constraints.gridwidth, constraints.gridheight);
                    properties.put(CELL_INFO, position);
                    if (child.isLeaf()) {
                        Strut struct = null;
                        struct = axisOrientation == VERTICAL_ORIENTATION ? Strut.newVerticalStrut() : Strut.newHorizontalStrut();
                        if (valueComponent != null) {
                            struct.addDependent(valueComponent);
                        }
                        constraints.gridx += xChildAdjust;
                        constraints.gridy += yChildAdjust;
                        container.add((Component)struct, constraints);
                        properties.put(STRUCT, struct);
                        constraints.gridx -= xChildAdjust;
                        constraints.gridy -= yChildAdjust;
                    } else {
                        this._recursiveCreateAxis(container, axisModel, child, propertiesTable, constraints.gridx + xChildAdjust * constraints.gridwidth, constraints.gridy + yChildAdjust * constraints.gridheight, axisOrientation, direction, frameVisible, antialiasedText, backgroundColor);
                    }
                    if (axisOrientation == VERTICAL_ORIENTATION) {
                        constraints.gridy += constraints.gridheight;
                        continue;
                    }
                    constraints.gridx += constraints.gridwidth;
                }
            }
        }
    }

    private static int _recursiveGridCount(TreeNode root, Hashtable propertiesTable) {
        int count = 0;
        if (root != null) {
            if (root.isLeaf()) {
                count = 1;
            } else {
                Enumeration<? extends TreeNode> children = root.children();
                while (children.hasMoreElements()) {
                    TreeNode child = children.nextElement();
                    count += MatrixContainer._recursiveGridCount(child, propertiesTable);
                }
            }
            MatrixContainer._putProperty(propertiesTable, root, GRID_COUNT, new Integer(count));
        }
        return count;
    }

    private static Object _getProperty(Hashtable tableOfProperties, TreeNode node, Object id) {
        Hashtable t = MatrixContainer._getProperties(tableOfProperties, node);
        return t != null ? t.get(id) : null;
    }

    private static boolean _putProperty(Hashtable tableOfProperties, TreeNode node, Object id, Object value) {
        Hashtable t = MatrixContainer._getProperties(tableOfProperties, node);
        if (t != null) {
            t.put(id, value);
            return true;
        }
        return false;
    }

    private static Hashtable _getProperties(Hashtable tableOfProperties, TreeNode node) {
        Hashtable t = null;
        if (tableOfProperties != null && node != null && (t = (Hashtable)tableOfProperties.get(node)) == null) {
            t = new Hashtable();
            tableOfProperties.put(node, t);
        }
        return t;
    }

    @Override
    public final void setLayout(LayoutManager lm) {
    }

    @Override
    public void paint(Graphics g) {
        this.paintPending = true;
        if (this.isFullPaintEnabled()) {
            this.paintPending = false;
            super.paint(g);
        }
    }

    public boolean isFullPaintEnabled() {
        return this.paintGate == 0;
    }

    public void disableFullPaint() {
        ++this.paintGate;
    }

    public synchronized void enableFullPaint() {
        this._enableFullPaint(true);
    }

    public synchronized void enableFullPaint(boolean updateNow) {
        this._enableFullPaint(updateNow);
    }

    private void _enableFullPaint(boolean updateNow) {
        if (!this.isFullPaintEnabled()) {
            this.paintGate = Math.max(0, this.paintGate - 1);
            if (this.paintPending && this.isFullPaintEnabled()) {
                this.paintPending = false;
                if (updateNow) {
                    if (!this.isValid()) {
                        this.validate();
                    }
                    this.repaint();
                }
            }
        }
    }

    private void _resetGBConstranits() {
        this.gbConstraints.gridx = 1;
        this.gbConstraints.gridy = 1;
        this.gbConstraints.gridwidth = 1;
        this.gbConstraints.gridheight = 1;
        this.gbConstraints.weightx = 1.0;
        this.gbConstraints.weighty = 1.0;
        this.gbConstraints.fill = 1;
        this.gbConstraints.anchor = 11;
    }

    private JPanel _newJPanel(LayoutManager lm) {
        JPanel c = new JPanel();
        c.setLayout(lm);
        c.setOpaque(false);
        return c;
    }

    private JScrollPane _newJScrollPane(boolean isVisible) {
        JScrollPane sp = new JScrollPane(21, 31);
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        sp.setVisible(isVisible);
        sp.setBorder(null);
        return sp;
    }

    private JPanel _newJPanel(boolean isVisible) {
        JPanel sp = new JPanel();
        sp.setLayout(new BorderLayout());
        sp.setOpaque(false);
        sp.setBorder(null);
        return sp;
    }

    private Graph findGraph() {
        if (this.graph == null) {
            Container c = this;
            while ((c = c.getParent()) != null && !(c instanceof Graph)) {
            }
            if (c instanceof Graph) {
                this.graph = (Graph)c;
            }
        }
        return this.graph;
    }

    private final class MyScrollModelListener
    implements PropertyChangeListener {
        private MyScrollModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (propertyName == "verticalScrollBarPolicy" || propertyName == "horizontalScrollBarPolicy") {
                MatrixContainer.this._applyScrollModelScrollBarPolicies();
                MatrixContainer.this.revalidate();
                MatrixContainer.this.repaint();
            }
        }
    }

    private static final class MyScrollModel
    implements ScrollModelInterface {
        private transient int horizontalScrollBarPolicy = 0;
        private transient int verticalScrollBarPolicy = 0;
        private transient JScrollBar horizontalScrollBar;
        private transient JScrollBar verticalScrollBar;
        PropertyChangeSupport propertyChangeSupport;

        public MyScrollModel(JScrollBar hScrollBar, JScrollBar vScrollBar) {
            this.horizontalScrollBar = hScrollBar;
            this.verticalScrollBar = vScrollBar;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (listener != null) {
                if (this.propertyChangeSupport == null) {
                    this.propertyChangeSupport = new PropertyChangeSupport(this);
                }
                this.propertyChangeSupport.addPropertyChangeListener(listener);
            }
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (listener != null && this.propertyChangeSupport != null) {
                this.propertyChangeSupport.removePropertyChangeListener(listener);
            }
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void setVerticalScrollBarPolicy(int newPolicy) {
            if (this.verticalScrollBarPolicy != newPolicy) {
                switch (newPolicy) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case 0: 
                    case 1: 
                }
                int oldPolicy = this.verticalScrollBarPolicy;
                this.verticalScrollBarPolicy = newPolicy;
                this.firePropertyChange("verticalScrollBarPolicy", new Integer(oldPolicy), new Integer(newPolicy));
            }
        }

        @Override
        public int getVerticalScrollBarPolicy() {
            return this.verticalScrollBarPolicy;
        }

        @Override
        public void setHorizontalScrollBarPolicy(int newPolicy) {
            if (this.horizontalScrollBarPolicy != newPolicy) {
                switch (newPolicy) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case 0: 
                    case 1: 
                }
                int oldPolicy = this.horizontalScrollBarPolicy;
                this.horizontalScrollBarPolicy = newPolicy;
                this.firePropertyChange("horizontalScrollBarPolicy", new Integer(oldPolicy), new Integer(newPolicy));
            }
        }

        @Override
        public int getHorizontalScrollBarPolicy() {
            return this.horizontalScrollBarPolicy;
        }

        @Override
        public void setScrollPosition(Point newPosition) {
            if (newPosition != null) {
                Point oldPosition = this.getScrollPosition();
                if (this.horizontalScrollBar != null) {
                    this.horizontalScrollBar.setValue(newPosition.x);
                }
                if (this.verticalScrollBar != null && this.verticalScrollBar.getValue() != newPosition.y) {
                    this.verticalScrollBar.setValue(newPosition.y);
                }
                newPosition = this.getScrollPosition();
                this.firePropertyChange("position", oldPosition, newPosition);
            }
        }

        @Override
        public Point getScrollPosition() {
            return new Point(this.horizontalScrollBar != null ? this.horizontalScrollBar.getValue() : 0, this.verticalScrollBar != null ? this.verticalScrollBar.getValue() : 0);
        }

        @Override
        public void translateScrollPosition(Point deltaPosition) {
            if (deltaPosition != null) {
                Point position = this.getScrollPosition();
                this.setScrollPosition(new Point(position.x + deltaPosition.x, position.y + deltaPosition.y));
            }
        }
    }

    private static class GridStruts {
        public Strut[] column;
        public Strut[] row;

        private GridStruts() {
        }
    }

    public static abstract class Strut
    extends JComponent {
        Vector deps = new Vector();
        Vector links = new Vector();

        public static final Strut newVerticalStrut() {
            return new VerticalStrut();
        }

        public static final Strut newHorizontalStrut() {
            return new HorizontalStrut();
        }

        public void addDependent(Component c) {
            if (c != null) {
                this.deps.addElement(c);
            }
        }

        public void addLink(Strut c) {
            this.links.addElement(c);
        }

        public final Dimension getPreferredDependentSize() {
            return Strut.getComponentSize(true, this.deps);
        }

        public final Dimension getMinimumDependentSize() {
            return Strut.getComponentSize(false, this.deps);
        }

        public final Dimension getPreferredLinkSize() {
            return Strut.getLinkSize(true, this.links);
        }

        public final Dimension getMinimumLinkSize() {
            return Strut.getLinkSize(false, this.links);
        }

        public static Dimension getComponentSize(boolean preferred, Vector v) {
            int h = 0;
            int w = 0;
            if (v != null) {
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Component c = (Component)e.nextElement();
                    if (c == null) continue;
                    Dimension d = preferred ? c.getPreferredSize() : c.getMinimumSize();
                    if (d == null) {
                        d = new Dimension(10, 10);
                    }
                    w = Math.max(w, d.width);
                    h = Math.max(h, d.height);
                }
            }
            return new Dimension(w, h);
        }

        public static Dimension getLinkSize(boolean preferred, Vector v) {
            int h = 0;
            int w = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Strut c = (Strut)e.nextElement();
                Dimension d = preferred ? c.getPreferredDependentSize() : c.getMinimumDependentSize();
                w = Math.max(w, d.width);
                h = Math.max(h, d.height);
            }
            return new Dimension(w, h);
        }
    }

    private static class CellInfo {
        public int column;
        public int row;
        public int width;
        public int height;

        public CellInfo() {
        }

        public CellInfo(int c, int r, int w, int h) {
            this.column = c;
            this.row = r;
            this.width = w;
            this.height = h;
        }
    }

    public static class MatrixCellIdentifier {
        public TreeNode columnOrdinal;
        public TreeNode rowOrdinal;
    }

    public static class TabletCellIdentifier {
        public TreeNode ordinal;
        public int index;
    }

    private class LabelComponent2
    extends LabelComponent
    implements MouseListener {
        protected Border regularBorder;

        public LabelComponent2(Variable variable, DataTreeGroupNode root, TextStyle aStyle) {
            super(variable.getLabel(), new AdvancedTextStyle(), MatrixContainer.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(String text, DataTreeGroupNode root, TextStyle aStyle) {
            super(text, new AdvancedTextStyle(), MatrixContainer.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), MatrixContainer.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle, int displayMode) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), displayMode, MatrixContainer.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle, Channel channel) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension sps = super.getMinimumSize();
            if (this.getAngle() == 0.0) {
                return new Dimension(1, sps.height);
            }
            return new Dimension(sps.width, 1);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }

        protected synchronized void buildNetwork(Graphics g) {
            int glJust;
            Channel myChannel = this.getChannel();
            Rectangle r = this.getBounds();
            if (myChannel == null || r.width == 0 || r.height == 0) {
                return;
            }
            this.updateChannel();
            myChannel.setSingleBufferGraphics(g);
            this.getComposite().removeAllElements();
            int height = r.height;
            int width = r.width;
            int myMarginLeft = 0;
            int myMarginRight = 0;
            int myMarginTop = 0;
            int myMarginBottom = 0;
            Insets myMargin = this.getMargin();
            if (myMargin != null) {
                height -= myMargin.top + myMargin.bottom;
                width -= myMargin.left + myMargin.right;
                myMarginTop = myMargin.top;
                myMarginBottom = myMargin.bottom;
                myMarginLeft = myMargin.left;
                myMarginRight = myMargin.right;
            }
            TextStyle textStyle = this.getTextStyle();
            double angle = this.getAngle();
            if (textStyle instanceof AdvancedTextStyle) {
                angle = Math.round(Util.resolveBaselineAngle(textStyle) / 90.0) * 90L;
            }
            String label = this.getLabel();
            ShadowStyle shadow = textStyle.getShadowStyle();
            RasterLabel rl = new RasterLabel();
            if (shadow.isVisible()) {
                rl.shadowColor.setValue(shadow.getColor());
                rl.shadowOn.setValue(shadow.isVisible());
                rl.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                rl.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
            }
            rl.string.setValue(label);
            rl.setFont(textStyle.getFont());
            rl.color.setValue(textStyle.getColor());
            rl.angle.setValue(angle);
            rl.maxWidth.setValue((double)r.width);
            rl.maxHeight.setValue((double)r.height);
            int justification = textStyle.getJustification();
            switch (justification) {
                case 3: 
                case 4: 
                case 11: {
                    glJust = 2;
                    break;
                }
                default: {
                    glJust = 1;
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    glJust = 0;
                }
            }
            rl.horizontalJustification.setValue(glJust);
            double transX = 0.0;
            double transY = 0.0;
            BoundingBox box = new BoundingBox();
            RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)myChannel, (String)label, (double)angle, (int)0, (int)1, (boolean)false, (boolean)false, (double)width, (double)height, (Font)textStyle.getFont());
            int boxx = (int)box.getSize().x;
            int boxy = (int)box.getSize().y;
            int curExtent = 0;
            int availExtent = 0;
            if (angle == 0.0) {
                curExtent = boxx;
                availExtent = width;
            } else {
                curExtent = boxy;
                availExtent = height;
                glJust = 1;
                rl.verticalJustification.setValue(glJust);
                rl.horizontalJustification.setValue(glJust);
            }
            int startCount = label.length();
            int endCount = 0;
            while (curExtent > availExtent && startCount > 0) {
                String newLabel;
                if (label.length() <= --startCount + endCount) continue;
                label = newLabel = label.substring(0, startCount) + "..." + label.substring(label.length() - endCount, label.length());
                box.makeEmpty();
                RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)myChannel, (String)label, (double)angle, (int)0, (int)1, (boolean)false, (boolean)false, (double)width, (double)height, (Font)textStyle.getFont());
                curExtent = angle == 0.0 ? (int)box.getSize().x : (int)box.getSize().y;
            }
            rl.string.setValue(label);
            if (Math.sin((double)((int)angle) * (Math.PI / 180)) == 0.0) {
                rl.fit.setValue(false);
                rl.verticalJustification.setValue(1);
                transY = r.height / 2;
                transX = glJust == 1 ? (double)(myMarginLeft + width / 2) : (glJust == 2 ? (double)(r.width - myMarginRight) : (double)myMarginLeft);
            } else if (glJust == 1) {
                transX = width / 2 + myMarginLeft;
                transY = angle == 0.0 ? (double)(height / 2 + myMarginBottom - boxy / 2) : (double)(height / 2 + myMarginBottom);
            } else if (glJust == 2) {
                transX = r.width - myMarginRight;
                transY = r.height - myMarginTop - boxy;
            } else {
                transX = myMarginLeft;
                transY = myMarginBottom;
            }
            rl.transform.translateX.setValue(transX);
            rl.transform.translateY.setValue(transY);
            this.getComposite().addElement((Element)rl);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                // empty if block
            }
        }

        @Override
        public void setBorder(Border b) {
            super.setBorder(b);
            this.regularBorder = b;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    static class HorizontalStrut
    extends Strut {
        HorizontalStrut() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Math.max(this.getPreferredDependentSize().width, this.getPreferredLinkSize().width), 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(Math.max(this.getMinimumDependentSize().width, this.getMinimumLinkSize().width), 0);
        }
    }

    static class VerticalStrut
    extends Strut {
        VerticalStrut() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, Math.max(this.getPreferredDependentSize().height, this.getPreferredLinkSize().height));
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, Math.max(this.getMinimumDependentSize().height, this.getMinimumLinkSize().height));
        }
    }

    static class BufferedLabel
    extends JLabel {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private transient int o = 0;
        Dimension dim;

        public BufferedLabel(String s) {
            super(s);
            this.setOpaque(false);
        }

        public void setBuffer(Dimension d) {
            this.dim = d;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        public void setOrientation(int orientation) {
        }

        public int getOrientation() {
            return this.o;
        }
    }

    public static class TabletLabelCellIdentifier {
        public int index;
    }

    public static class AxisLabelCellIdentifier {
        public Object ordinal;
    }

    public static class AxisCellIdentifier {
        public TreeNode ordinal;
    }
}

