/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ScrollModelInterface;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ChartLayout;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.MatrixContainer;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.measures.BaseLength;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class Matrix
extends JComponent {
    private static final int MAX_ROW_OR_COLUMN_COUNT = 400;
    private static final int MAX_CELL_COUNT = 1500;
    public static final String RB_KEY = "Matrix.";
    static int dataAlpha = 180;
    static int wallAlpha = 90;
    public static final Color BACKGROUND_COLOR = new Color(255, 254, 189);
    public static final Color WALL_COLOR = new Color(230, 201, 112, wallAlpha);
    public static final Color FLOOR_COLOR = new Color(255, 254, 189);
    public static final Color LEGEND_COLOR = new Color(255, 254, 219);
    public static final Color AXIS_LINE_COLOR = new Color(0, 0, 0);
    public static final Color TEXT_LABEL_COLOR = new Color(0, 0, 0);
    public static final Color TEXT_VALUE_COLOR = new Color(0, 0, 0);
    public static final Color TEXT_TITLE_COLOR = new Color(0, 0, 0);
    public static final Color[] COLOR_SCHEME = new Color[]{new Color(139, 63, 137, dataAlpha), new Color(250, 188, 70, dataAlpha), new Color(97, 168, 53, dataAlpha), new Color(63, 118, 154, dataAlpha), new Color(204, 0, 103, dataAlpha), new Color(215, 113, 0, dataAlpha), new Color(238, 83, 238, dataAlpha), new Color(128, 128, 255, dataAlpha), new Color(0, 128, 64, dataAlpha), new Color(31, 190, 203, dataAlpha), new Color(176, 193, 244, dataAlpha), new Color(125, 255, 136, dataAlpha)};
    private transient boolean constructNeeded;
    private transient boolean refreshNeeded;
    private transient MatrixContainer matrixContainer;
    private transient JComponent borderContainer;
    private transient Boolean useBorderContainer;
    protected transient DataSource dataSource;
    protected transient GraphModel graphModel;
    private transient String dataErrorMessage = null;
    private transient String constructErrorMessage = null;
    private transient String layoutErrorMessage = null;
    private transient boolean autoRepaintEnabled = true;
    private transient boolean fitToScreen = true;
    private transient boolean antialiasedTextEnabled = true;
    private transient boolean matrixCellOutlineVisible = false;
    private transient LineStyle matrixCellOutlineLineStyle = null;
    private final Channel channel;
    private final ListSelectionListener matrixListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Matrix.this.selectionChanged(e);
        }
    };
    private MessageModel messageModel = null;
    private JComponent northLegend;
    private JComponent southLegend;
    private JComponent eastLegend;
    private JComponent westLegend;
    protected final transient Vector dataSourceTrashBin = new Vector();
    private DataSource selectionDataSource = null;
    private static final int DefaultMarginSize = (int)new BaseLength(8.0, "pt").getMagnitude((Object)"px");
    private final int minWidthForMarginAdjust;
    private final int minHeightForMarginAdjust = this.minWidthForMarginAdjust = DefaultMarginSize * 20;
    private final int maxWidthForMarginAdjust;
    private final int maxHeightForMarginAdjust = this.maxWidthForMarginAdjust = this.minWidthForMarginAdjust * 3;
    Runnable _constructOrRefreshRunnable = null;
    Runnable _constructRunnable = null;
    boolean reconstructionEnabled = false;
    private ValueTree columnValueTree;
    private ValueTree rowValueTree;

    public void selectionChanged(ListSelectionEvent e) {
        this.repaint();
    }

    public Matrix(Channel channel) {
        this.channel = channel;
        this.setLayout(new ChartLayout());
        this.constructNeeded = false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void updateChannel() {
        Util.updateChannel(this.channel, 1, 1);
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    protected String getErrorMessage() {
        if (this.dataErrorMessage != null) {
            return this.dataErrorMessage;
        }
        if (this.constructErrorMessage != null) {
            return this.constructErrorMessage;
        }
        if (this.layoutErrorMessage != null) {
            return this.layoutErrorMessage;
        }
        return null;
    }

    @Override
    public void paintChildren(Graphics g) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null) {
            super.paintChildren(g);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        String errorMessage;
        if (g != null && (errorMessage = this.getErrorMessage()) != null && errorMessage.length() > 0) {
            Rectangle displayArea = this.getBounds();
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            displayArea.x = insets.left;
            displayArea.y = insets.top;
            displayArea.width -= insets.left + insets.right;
            displayArea.height -= insets.top + insets.bottom;
            AttributedString attributedErrorMessage = new AttributedString(errorMessage);
            Font font = new Font(g.getFont().getFamily(), 1, g.getFont().getSize());
            attributedErrorMessage.addAttribute(TextAttribute.FONT, font);
            attributedErrorMessage.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
            Insets textMargin = new Insets(5, 5, 5, 5);
            Util.Text.renderAttributedString((Graphics2D)g, displayArea, attributedErrorMessage, 0, 0, textMargin);
        }
    }

    public void addLegend(JComponent legend, int placement) {
        String p = null;
        switch (placement) {
            case 5: 
            case 10200: {
                p = "South";
                this.southLegend = legend;
                break;
            }
            case 1: {
                p = "North";
                this.northLegend = legend;
                break;
            }
            case 3: {
                p = "East";
                this.eastLegend = legend;
                break;
            }
            case 7: {
                p = "West";
                this.westLegend = legend;
            }
        }
        if (p != null) {
            this.add((Component)legend, p);
        }
    }

    public JComponent getLegend(int placement) {
        switch (placement) {
            case 5: 
            case 10200: {
                return this.southLegend;
            }
            case 1: {
                return this.northLegend;
            }
            case 3: {
                return this.eastLegend;
            }
            case 7: {
                return this.westLegend;
            }
        }
        return null;
    }

    public JComponent removeLegend(int placement) {
        JComponent l = null;
        switch (placement) {
            case 5: 
            case 10200: {
                l = this.southLegend;
                this.southLegend = null;
                break;
            }
            case 1: {
                l = this.northLegend;
                this.northLegend = null;
                break;
            }
            case 3: {
                l = this.eastLegend;
                this.eastLegend = null;
                break;
            }
            case 7: {
                l = this.westLegend;
                this.westLegend = null;
            }
        }
        if (l != null) {
            this.remove(l);
        }
        return l;
    }

    public void removeAllLegends() {
        this.removeLegend(5);
        this.removeLegend(1);
        this.removeLegend(3);
        this.removeLegend(7);
    }

    protected DataSource resetDataSource(DataSource ds) {
        if (this.dataSource != ds) {
            this.dataSource = ds;
        }
        this.resetTrees();
        return ds;
    }

    public void setDataSource(DataSource ds) {
        this.setDataSource(ds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(DataSource ds, String em) {
        this.dataErrorMessage = em;
        if (this.dataSource != ds) {
            if (this.dataSource != null) {
                Vector vector = this.dataSourceTrashBin;
                synchronized (vector) {
                    this.dataSourceTrashBin.add(this.dataSource);
                }
            }
            this.dataSource = ds;
            this.resetTrees();
            this.reconstruct();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setSelectionDataSource(DataSource ds) {
        if (this.selectionDataSource != ds) {
            if (this.selectionDataSource != null && this.selectionDataSource.getSelectionModel() != null) {
                this.selectionDataSource.getSelectionModel().removeListSelectionListener(this.matrixListSelectionListener);
            }
            this.selectionDataSource = ds;
            if (this.selectionDataSource != null && this.selectionDataSource.getSelectionModel() != null) {
                this.selectionDataSource.getSelectionModel().addListSelectionListener(this.matrixListSelectionListener);
            }
            this.reconstruct();
            this.refresh();
        }
    }

    public DataSource getSelectionDataSource() {
        return this.selectionDataSource;
    }

    public void setGraphModel(GraphModel newGraphmodel) {
        this.graphModel = newGraphmodel;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public ScrollModelInterface getScrollModel() {
        return this.matrixContainer != null ? this.matrixContainer.getScrollModel() : null;
    }

    public void setFitToScreen(boolean b) {
        this.fitToScreen = b;
    }

    public boolean getFitToScreen() {
        return this.fitToScreen;
    }

    public void setAntialiasedTextEnabled(boolean b) {
        this.antialiasedTextEnabled = b;
        if (this.useBorderContainer != null && this.matrixContainer != null) {
            this.matrixContainer.setAntialiasedTextEnabled(this.antialiasedTextEnabled);
        }
    }

    public boolean isAntialiasedTextEnabled() {
        return this.antialiasedTextEnabled;
    }

    public void setMatrixCellOutlineVisible(boolean b) {
        this.matrixCellOutlineVisible = b;
        if (this.useBorderContainer != null && this.matrixContainer != null) {
            this.matrixContainer.setMatrixCellOutlineVisible(this.matrixCellOutlineVisible);
        }
    }

    public boolean isMatrixCellOutlineVisible() {
        return this.matrixCellOutlineVisible;
    }

    public void setMatrixCellOutlineLineStyle(LineStyle lineStyle) {
        this.matrixCellOutlineLineStyle = lineStyle;
        if (this.useBorderContainer != null && this.matrixContainer != null) {
            this.matrixContainer.setMatrixCellOutlineLineStyle(this.matrixCellOutlineLineStyle);
        }
    }

    public LineStyle getMatrixCellOutlineLineStyle() {
        return this.matrixCellOutlineLineStyle;
    }

    private Insets _newDefaultMarginInsets() {
        return new Insets(DefaultMarginSize, DefaultMarginSize, DefaultMarginSize, DefaultMarginSize);
    }

    private Insets _newNoMarginInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private Border _newNoMarginBorder() {
        return new EmptyBorder(this._newNoMarginInsets());
    }

    private void _applyMargin() {
        if (this.graphModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_DASHBOARD_MARGIN_ENABLED)) {
            this.setBorder(this._newNoMarginBorder());
            if (this.northLegend != null) {
                this.northLegend.setBorder(this._newNoMarginBorder());
            }
            if (this.southLegend != null) {
                this.southLegend.setBorder(this._newNoMarginBorder());
            }
            if (this.eastLegend != null) {
                this.eastLegend.setBorder(this._newNoMarginBorder());
            }
            if (this.westLegend != null) {
                this.westLegend.setBorder(this._newNoMarginBorder());
            }
        } else {
            Dimension d = super.getPreferredSize();
            Insets m = this.getPreferredMargin(d);
            if (m.left + m.right + m.top + m.bottom > 0) {
                m = this.getPreferredMargin(d.width + m.left + m.right, d.height + m.top + m.bottom);
            }
            this._applyMarginsOnGraphAndLegends(d.width + m.left + m.right, d.height + m.top + m.bottom);
        }
    }

    public Insets getPreferredMargin(Dimension d) {
        return this.getPreferredMargin(d.width, d.height);
    }

    public Insets getPreferredMargin(int w, int h) {
        int wm;
        if (this.graphModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_DASHBOARD_MARGIN_ENABLED)) {
            return this._newNoMarginInsets();
        }
        int n = w < this.minWidthForMarginAdjust ? 0 : (wm = w > this.maxWidthForMarginAdjust ? DefaultMarginSize : (int)((double)(w - this.minWidthForMarginAdjust) / (double)(this.maxWidthForMarginAdjust - this.minWidthForMarginAdjust) * (double)DefaultMarginSize));
        int hm = h < this.minHeightForMarginAdjust ? 0 : (h > this.maxHeightForMarginAdjust ? DefaultMarginSize : (int)((double)(h - this.minHeightForMarginAdjust) / (double)(this.maxHeightForMarginAdjust - this.minHeightForMarginAdjust) * (double)DefaultMarginSize));
        return wm == DefaultMarginSize && hm == DefaultMarginSize ? this._newDefaultMarginInsets() : new Insets(hm, wm, hm, wm);
    }

    public Insets getPreferredLegendMargin(Dimension d, int placement) {
        return this.getPreferredLegendMargin(d.width, d.height, placement);
    }

    public Insets getPreferredLegendMargin(int w, int h, int placement) {
        if (this.graphModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_DASHBOARD_MARGIN_ENABLED)) {
            return this._newNoMarginInsets();
        }
        Insets graphMargin = this.getPreferredMargin(w, h);
        switch (placement) {
            case 5: 
            case 10200: {
                return new Insets(graphMargin.bottom, 0, 0, 0);
            }
            case 1: {
                return new Insets(0, 0, graphMargin.top, 0);
            }
            case 3: {
                return new Insets(0, graphMargin.right, 0, 0);
            }
            case 7: {
                return new Insets(0, 0, 0, graphMargin.left);
            }
        }
        return this._newNoMarginInsets();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (!this.graphModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_DASHBOARD_MARGIN_ENABLED)) {
            this._applyMarginsOnGraphAndLegends(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    private void _applyMarginsOnGraphAndLegends(int w, int h) {
        Insets i = this.getInsets();
        Insets m = this.getPreferredMargin(w, h);
        if (i.top != m.top || i.left != m.left || i.bottom != m.bottom || i.right != m.right) {
            this.setBorder(new EmptyBorder(m));
        }
        if (this.northLegend != null) {
            i = this.northLegend.getInsets();
            m = this.getPreferredLegendMargin(w, h, 1);
            if (i.top != m.top || i.left != m.left || i.bottom != m.bottom || i.right != m.right) {
                this.northLegend.setBorder(new EmptyBorder(m));
            }
        }
        if (this.southLegend != null) {
            i = this.southLegend.getInsets();
            m = this.getPreferredLegendMargin(w, h, 5);
            if (i.top != m.top || i.left != m.left || i.bottom != m.bottom || i.right != m.right) {
                this.southLegend.setBorder(new EmptyBorder(m));
            }
        }
        if (this.eastLegend != null) {
            i = this.eastLegend.getInsets();
            m = this.getPreferredLegendMargin(w, h, 3);
            if (i.top != m.top || i.left != m.left || i.bottom != m.bottom || i.right != m.right) {
                this.eastLegend.setBorder(new EmptyBorder(m));
            }
        }
        if (this.westLegend != null) {
            i = this.westLegend.getInsets();
            m = this.getPreferredLegendMargin(w, h, 7);
            if (i.top != m.top || i.left != m.left || i.bottom != m.bottom || i.right != m.right) {
                this.westLegend.setBorder(new EmptyBorder(m));
            }
        }
    }

    public void setAutoRepaintEnabled(boolean b) {
        this.autoRepaintEnabled = b;
    }

    public boolean isAutoRepaintEnabled() {
        return this.autoRepaintEnabled;
    }

    private boolean isInvokeLaterAllowed() {
        return this.isAutoRepaintEnabled() && this.isShowing();
    }

    private Runnable _getConstructOrRefreshRunnable() {
        if (this._constructOrRefreshRunnable == null) {
            this._constructOrRefreshRunnable = new Runnable(){

                @Override
                public void run() {
                    if (Matrix.this.isInvokeLaterAllowed()) {
                        if (Matrix.this.constructNeeded) {
                            Matrix.this.doConstruct(true);
                        } else if (Matrix.this.refreshNeeded) {
                            Matrix.this.doRefresh(true);
                        }
                    }
                }
            };
        }
        return this._constructOrRefreshRunnable;
    }

    public void refresh() {
        this.refreshNeeded = true;
        if (this.isInvokeLaterAllowed() && this.reconstructionEnabled) {
            SwingUtilities.invokeLater(this._getConstructOrRefreshRunnable());
        }
    }

    private Runnable _getConstructRunnable() {
        if (this._constructRunnable == null) {
            this._constructRunnable = new Runnable(){

                @Override
                public void run() {
                    if (Matrix.this.isInvokeLaterAllowed() && Matrix.this.constructNeeded) {
                        Matrix.this.doConstruct(true);
                    }
                }
            };
        }
        return this._constructRunnable;
    }

    public void reconstruct() {
        this.constructNeeded = true;
        if (this.isInvokeLaterAllowed()) {
            if (this.reconstructionEnabled) {
                SwingUtilities.invokeLater(this._getConstructRunnable());
            } else {
                this.revalidate();
            }
        }
    }

    public void prepareToPaint() {
        if (this.constructNeeded) {
            this.doConstruct(false);
        } else if (this.refreshNeeded) {
            this.doRefresh(false);
        }
    }

    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doConstruct(boolean requestRepaint) {
        this.constructNeeded = false;
        this.refreshNeeded = false;
        this.useBorderContainer = null;
        this.resetTrees();
        this.layoutErrorMessage = null;
        this.constructErrorMessage = null;
        this.removeAllLegends();
        if (this.borderContainer != null) {
            this.borderContainer.removeAll();
        }
        this.cleanMatrixContainer();
        Vector vector = this.dataSourceTrashBin;
        synchronized (vector) {
            if (this.dataSourceTrashBin.size() > 0) {
                for (int ii = 0; ii < this.dataSourceTrashBin.size(); ++ii) {
                    Object d = this.dataSourceTrashBin.get(ii);
                    if (!(d instanceof DataSource)) continue;
                    ((DataSource)d).disposeRecursively();
                }
                this.dataSourceTrashBin.removeAllElements();
            }
        }
        try {
            int columnLeafCount;
            int rowLeafCount;
            if (this.constructErrorMessage == null && (Math.max(rowLeafCount = this.getRowLeafCount(), columnLeafCount = this.getColumnLeafCount()) > 400 || rowLeafCount * columnLeafCount > 1500)) {
                this.constructErrorMessage = RB.getStringResource(RB_KEY, "TooManyRowsOrColumns.txt", this.getLocale());
            }
            if (this.getErrorMessage() == null) {
                this.construct();
                this._applyMargin();
            }
            JComponent graph = this;
            do {
                Container parent;
                JComponent jComponent = graph = (parent = graph.getParent()) instanceof JComponent ? (JComponent)parent : null;
            } while (graph != null && !(graph instanceof Graph));
            if (graph == null) {
                graph = this;
            }
            this.invalidate();
            graph.invalidate();
            graph.validate();
            if (requestRepaint) {
                graph.repaint();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected abstract List getCells();

    public Component getBrushableComponent() {
        boolean isUseBorderContainer;
        boolean bl = isUseBorderContainer = this.useBorderContainer != null ? this.useBorderContainer : false;
        if (isUseBorderContainer && this.borderContainer != null) {
            return this.borderContainer;
        }
        if (this.matrixContainer != null) {
            return this.matrixContainer;
        }
        return this;
    }

    protected void doRefresh(boolean requestRepaint) {
        this.refreshNeeded = false;
        try {
            List cellArrayList = this.getCells();
            if (cellArrayList != null) {
                for (int ii = 0; ii < cellArrayList.size(); ++ii) {
                    Cell c = (Cell)cellArrayList.get(ii);
                    if (this.constructNeeded) {
                        c.construct();
                    }
                    c.invalidateBuffer();
                    if (!requestRepaint) continue;
                    c.repaint();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.reconstructionEnabled = true;
        if (this.constructNeeded) {
            this.doConstruct(false);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        this.reconstructionEnabled = true;
        if (this.constructNeeded) {
            this.doConstruct(false);
        }
        return super.getPreferredSize();
    }

    @Override
    public void validateTree() {
        this.layoutErrorMessage = null;
        try {
            super.validateTree();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MatrixLayoutErrorMessage) {
                String messageID = cause.getLocalizedMessage();
                this.layoutErrorMessage = RB.getStringResource(RB_KEY, messageID, this.getLocale());
            }
            throw e;
        }
        if (!this.reconstructionEnabled) {
            this.reconstructionEnabled = true;
            if (this.constructNeeded) {
                this.reconstruct();
            }
        }
    }

    protected abstract void construct();

    private int getMaxRowOrColumnCount() {
        int rowLeafCount;
        DefaultMutableTreeNode columnTree = this.getColumnValueTree().getRoot();
        DefaultMutableTreeNode rowTree = this.getRowValueTree().getRoot();
        int columnLeafCount = Matrix.getLeafCount(columnTree);
        int result = columnLeafCount > (rowLeafCount = Matrix.getLeafCount(rowTree)) ? columnLeafCount : rowLeafCount;
        return result;
    }

    private int getColumnLeafCount() {
        DefaultMutableTreeNode columnTree = this.getColumnValueTree().getRoot();
        return Matrix.getLeafCount(columnTree);
    }

    private int getRowLeafCount() {
        DefaultMutableTreeNode rowTree = this.getRowValueTree().getRoot();
        return Matrix.getLeafCount(rowTree);
    }

    private static int getLeafCount(DefaultMutableTreeNode node) {
        int leafCount = 0;
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!n.isLeaf()) continue;
            ++leafCount;
        }
        return leafCount;
    }

    protected abstract MatrixModel getMatrixModel();

    protected void resetTrees() {
        this.columnValueTree = null;
        this.rowValueTree = null;
    }

    protected ValueTree getColumnValueTree() {
        if (this.columnValueTree == null) {
            this.createTrees();
        }
        return this.columnValueTree;
    }

    protected ValueTree getRowValueTree() {
        if (this.rowValueTree == null) {
            this.createTrees();
        }
        return this.rowValueTree;
    }

    private void createTrees() {
        ValueTree[] trees = ValueTree.createTrees(this.dataSource, this.getMatrixModel().getColumnRole(), this.getMatrixModel().getRowRole());
        this.columnValueTree = trees[0];
        this.rowValueTree = trees[1];
    }

    protected ArrayList addMatrixCellComponents(CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        return this._addMatrixCellComponents(cellFactory, cellModel, dataSource);
    }

    private ArrayList _addMatrixCellComponents(CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        if (this.useBorderContainer == null) {
            boolean columnValid;
            DefaultMutableTreeNode[] columnOrdinals = this.getColumnValueTree() != null ? this.getColumnValueTree().getLeafNodes() : null;
            DefaultMutableTreeNode[] rowOrdinals = this.getRowValueTree() != null ? this.getRowValueTree().getLeafNodes() : null;
            boolean rowValid = rowOrdinals != null && rowOrdinals.length > 0 && rowOrdinals[0].getParent() != null;
            boolean bl = columnValid = columnOrdinals != null && columnOrdinals.length > 0 && columnOrdinals[0].getParent() != null;
            if (rowValid || columnValid || !this.fitToScreen) {
                this.useBorderContainer = Boolean.FALSE;
                if (this.matrixContainer == null) {
                    this.matrixContainer = new MatrixContainer(this.channel);
                }
                this.matrixContainer.setFitToScreen(this.fitToScreen);
                this.matrixContainer.setAntialiasedTextEnabled(this.antialiasedTextEnabled);
                this.matrixContainer.setMatrixCellOutlineVisible(this.matrixCellOutlineVisible);
                this.matrixContainer.setMatrixCellOutlineLineStyle(this.matrixCellOutlineLineStyle);
                this.add((Component)this.matrixContainer, "Center");
            } else {
                this.useBorderContainer = Boolean.TRUE;
                if (this.borderContainer == null) {
                    this.borderContainer = new JPanel();
                    this.borderContainer.setLayout(new BorderLayout());
                    this.borderContainer.setOpaque(false);
                }
                if (this.isMatrixCellOutlineVisible()) {
                    this.borderContainer.setBorder(new LineBorder(this.matrixCellOutlineLineStyle.getColor(), (int)this.matrixCellOutlineLineStyle.getThickness().getMagnitude((Object)"px")));
                }
                this.add((Component)this.borderContainer, "Center");
            }
        }
        if (this.useBorderContainer.booleanValue()) {
            JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.channel);
            this.borderContainer.add((Component)cellComponent, "Center");
            ArrayList<JComponent> cellList = new ArrayList<JComponent>();
            cellList.add(cellComponent);
            return cellList;
        }
        return this.addMatrixCellComponentsToMatrixContainer(cellFactory, cellModel, dataSource, this.channel);
    }

    private ArrayList addMatrixCellComponentsToMatrixContainer(CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
        int rowCount;
        ArrayList<JComponent> cellList = new ArrayList<JComponent>();
        if (cellFactory == null || cellModel == null || this.matrixContainer == null || dataSource == null || dataSource.length < 1) {
            return cellList;
        }
        this.matrixContainer.setColumnValueTree(this.getColumnValueTree(), this.getMatrixModel().getColumnModel());
        this.matrixContainer.setRowValueTree(this.getRowValueTree(), this.getMatrixModel().getRowModel());
        DefaultMutableTreeNode[] columnOrdinals = this.getColumnValueTree() != null ? this.getColumnValueTree().getLeafNodes() : null;
        DefaultMutableTreeNode[] rowOrdinals = this.getRowValueTree() != null ? this.getRowValueTree().getLeafNodes() : null;
        int columnCount = columnOrdinals == null ? 1 : columnOrdinals.length;
        int n = rowCount = rowOrdinals == null ? 1 : rowOrdinals.length;
        if (this.getRowValueTree().getLeafNodeCount() > 1) {
            this.matrixContainer.ensureEastBufferHack();
        }
        MatrixContainer.MatrixCellIdentifier matrixCellIdentifier = new MatrixContainer.MatrixCellIdentifier();
        DataSource[] tableCellDataSource = null;
        for (int ii = 0; ii < columnCount; ++ii) {
            matrixCellIdentifier.columnOrdinal = columnOrdinals == null ? null : columnOrdinals[ii];
            for (int jj = 0; jj < rowCount; ++jj) {
                matrixCellIdentifier.rowOrdinal = rowOrdinals == null ? null : rowOrdinals[jj];
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)matrixCellIdentifier.columnOrdinal), (DataTreeGroupNode)((DataTreeGroupNode)matrixCellIdentifier.rowOrdinal));
                if (dataSource != null) {
                    tableCellDataSource = new DataSource[dataSource.length];
                    for (int kk = 0; kk < dataSource.length; ++kk) {
                        if (dataSource[kk] == null) continue;
                        tableCellDataSource[kk] = dataSource[kk].newDataSourceWhere(whereClause);
                    }
                }
                JComponent cellComponent = null;
                if (cellFactory instanceof CellFactoryInterface2) {
                    MatrixInfo matrixInfo = new MatrixInfo(matrixCellIdentifier.columnOrdinal, matrixCellIdentifier.rowOrdinal);
                    cellComponent = ((CellFactoryInterface2)((Object)cellFactory)).newCellComponent(cellModel, tableCellDataSource, matrixInfo, channel);
                } else {
                    cellComponent = cellFactory.newCellComponent(cellModel, tableCellDataSource, channel);
                }
                this.matrixContainer.setMatrixCell(cellComponent, matrixCellIdentifier);
                cellList.add(cellComponent);
            }
        }
        if (this.matrixContainer.isMatrixCellOutlineVisible()) {
            this.matrixContainer.drawCellMatrixOutline();
        }
        return cellList;
    }

    protected ArrayList addRowTabletCellComponents(CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        if (this.useBorderContainer != null) {
            if (this.useBorderContainer.booleanValue()) {
                if (this.borderContainer != null) {
                    JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.channel);
                    this.borderContainer.add((Component)cellComponent, primary ? "West" : "East");
                    ArrayList<JComponent> cellList = new ArrayList<JComponent>();
                    cellList.add(cellComponent);
                    return cellList;
                }
            } else if (this.matrixContainer != null) {
                ArrayList<JComponent> cellList = new ArrayList<JComponent>();
                DefaultMutableTreeNode[] rowOrdinals = this.getRowValueTree() != null ? this.getRowValueTree().getLeafNodes() : null;
                int rowCount = rowOrdinals == null ? 1 : rowOrdinals.length;
                for (int jj = 0; jj < rowCount; ++jj) {
                    DefaultMutableTreeNode rowOrdinal = rowOrdinals == null ? null : rowOrdinals[jj];
                    JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.channel);
                    MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                    tabletCellIdentifier.ordinal = rowOrdinal;
                    this.matrixContainer.setRowTabletCell(cell, tabletCellIdentifier, primary);
                    cellList.add(cell);
                }
                this.matrixContainer.ensureEastBufferHack();
                return cellList;
            }
        }
        return null;
    }

    protected ArrayList addColumnTabletCellComponents(CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        if (this.useBorderContainer != null) {
            if (this.useBorderContainer.booleanValue()) {
                if (this.borderContainer != null) {
                    JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.channel);
                    this.borderContainer.add((Component)cellComponent, primary ? "South" : "North");
                    ArrayList<JComponent> cellList = new ArrayList<JComponent>();
                    cellList.add(cellComponent);
                    return cellList;
                }
            } else if (this.matrixContainer != null) {
                ArrayList<JComponent> cellList = new ArrayList<JComponent>();
                DefaultMutableTreeNode[] columnOrdinals = this.getColumnValueTree() != null ? this.getColumnValueTree().getLeafNodes() : null;
                int columnCount = columnOrdinals == null ? 1 : columnOrdinals.length;
                for (int jj = 0; jj < columnCount; ++jj) {
                    DefaultMutableTreeNode columnOrdinal = columnOrdinals == null ? null : columnOrdinals[jj];
                    JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.channel);
                    cellList.add(cell);
                    MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                    tabletCellIdentifier.ordinal = columnOrdinal;
                    this.matrixContainer.setColumnTabletCell(cell, tabletCellIdentifier, primary);
                }
                return cellList;
            }
        }
        return null;
    }

    public PickInfo pick(int x, int y) {
        List cells = this.getCells();
        if (cells == null) {
            return null;
        }
        for (Object o : cells) {
            Cell cell;
            Point p;
            if (!(o instanceof Cell) || (p = Util.toDescendent(x, y, this, cell = (Cell)o)) == null || !cell.contains(p.x, p.y)) continue;
            PickInfo pickInfo = cell.pick(p.x, p.y);
            if (pickInfo != null) {
                pickInfo = this.addMatrixPickInfo(pickInfo, cell.getDataSource());
                pickInfo.setX(x);
                pickInfo.setY(y);
            }
            return pickInfo;
        }
        return null;
    }

    public PickInfo[] pick(int x, int y, int w, int h) {
        List cells = this.getCells();
        if (cells == null) {
            return null;
        }
        Vector<PickInfo> v = new Vector<PickInfo>();
        for (Object o : cells) {
            PickInfo[] pia;
            Cell cell;
            Rectangle b;
            if (!(o instanceof Cell) || (b = (cell = (Cell)o).getBounds()) == null) continue;
            Rectangle ar = Util.toDescendent(x, y, w, h, this, cell);
            b.y = 0;
            b.x = 0;
            Rectangle2D ir = ar.createIntersection(b);
            if (!(ir.getWidth() > 0.0) || !(ir.getHeight() > 0.0) || (pia = cell.pick(ar.x, ar.y, ar.width, ar.height)) == null) continue;
            for (int ii = 0; ii < pia.length; ++ii) {
                PickInfo pickInfo = pia[ii];
                if (pia[ii] == null) continue;
                pickInfo = this.addMatrixPickInfo(pickInfo, cell.getDataSource());
                pickInfo.setX(x);
                pickInfo.setY(y);
                v.add(pickInfo);
            }
        }
        return v != null && v.size() > 0 ? v.toArray(new PickInfo[0]) : null;
    }

    public PickInfo select(int x, int y, boolean isControlDown) {
        List cells = this.getCells();
        if (cells == null) {
            return null;
        }
        for (Object o : cells) {
            Cell cell;
            Point p;
            if (!(o instanceof Cell) || (p = Util.toDescendent(x, y, this, cell = (Cell)o)) == null || !cell.contains(p.x, p.y)) continue;
            return cell.select(p.x, p.y, isControlDown);
        }
        return null;
    }

    public PickInfo[] select(int x, int y, int w, int h, boolean isControlDown) {
        List cells = this.getCells();
        if (cells == null) {
            return null;
        }
        boolean isModified = false;
        ArrayList<PickInfo> cumulativePickInfos = new ArrayList<PickInfo>();
        for (Object o : cells) {
            Cell cell;
            Rectangle b;
            if (!(o instanceof Cell) || (b = (cell = (Cell)o).getBounds()) == null) continue;
            Rectangle ar = Util.toDescendent(x, y, w, h, this, cell);
            b.y = 0;
            b.x = 0;
            Rectangle2D ir = ar.createIntersection(b);
            if (!(ir.getWidth() > 0.0) || !(ir.getHeight() > 0.0)) continue;
            PickInfo[] pickInfos = cell.select(ar.x, ar.y, ar.width, ar.height, isControlDown, isModified);
            if (pickInfos != null) {
                for (int ii = 0; ii < pickInfos.length; ++ii) {
                    if (pickInfos[ii] == null) continue;
                    cumulativePickInfos.add(pickInfos[ii]);
                }
            }
            isModified = true;
        }
        if (cumulativePickInfos.size() < 1) {
            return null;
        }
        return cumulativePickInfos.toArray(new PickInfo[0]);
    }

    public void clearSelection() {
        ListSelectionModel selectionModel;
        DataSource ds = this.getSelectionDataSource();
        if (ds == null) {
            ds = this.getDataSource();
        }
        if (ds != null && (selectionModel = ds.getRootSelectionModel()) != null) {
            selectionModel.clearSelection();
        }
    }

    public PickInfo[] pickSelected() {
        List cells = this.getCells();
        if (cells == null) {
            return null;
        }
        ArrayList<PickInfo> l = new ArrayList<PickInfo>();
        for (Object o : cells) {
            Cell cell;
            PickInfo[] pia;
            if (!(o instanceof Cell) || (pia = (cell = (Cell)o).pickSelected()) == null) continue;
            for (int jj = 0; jj < pia.length; ++jj) {
                this.addMatrixPickInfo(pia[jj], cell.getDataSource());
                l.add(pia[jj]);
            }
        }
        return l.size() > 0 ? l.toArray(new PickInfo[0]) : null;
    }

    private PickInfo addMatrixPickInfo(PickInfo pickInfo, DataSource pickInfoDataSource) {
        if (pickInfo != null && pickInfoDataSource != null) {
            Variable[] dataTipVariableArray = Util.getGTKVariableArray(pickInfoDataSource, this.getMatrixModel().getDataTipRole());
            boolean graphDataIsVisible = dataTipVariableArray == null || dataTipVariableArray.length <= 0 || dataTipVariableArray[0] == null || this.graphModel.getDataTipModel().getContent() != 11401;
            int obsIndex = pickInfo.getObservationIndex();
            Variable[] columnVariableArray = pickInfoDataSource.getVariable(this.getMatrixModel().getColumnRole());
            Variable[] rowVariableArray = pickInfoDataSource.getVariable(this.getMatrixModel().getRowRole());
            if (rowVariableArray != null && rowVariableArray.length > 0 || columnVariableArray != null && columnVariableArray.length > 0) {
                Vector[] labelValueCollection;
                Vector[] myLabelValueCollection = labelValueCollection = pickInfo.getLabelValueCollection();
                if (labelValueCollection != null) {
                    Vector rowColLabelValuePairs;
                    myLabelValueCollection = new Vector[labelValueCollection.length + 1];
                    for (int ii = 0; ii < labelValueCollection.length; ++ii) {
                        myLabelValueCollection[ii] = labelValueCollection[ii];
                    }
                    myLabelValueCollection[labelValueCollection.length] = rowColLabelValuePairs = new Vector();
                    if (obsIndex >= 0) {
                        GTKUtil.PickInfoAccess.addLabelValuePairs_ReverseOrder(rowColLabelValuePairs, this.getMatrixModel().getColumnRole(), columnVariableArray, obsIndex, graphDataIsVisible);
                        GTKUtil.PickInfoAccess.addLabelValuePairs_ReverseOrder(rowColLabelValuePairs, this.getMatrixModel().getRowRole(), rowVariableArray, obsIndex, graphDataIsVisible);
                    }
                }
                pickInfo.setLabelValueCollection(myLabelValueCollection);
            }
            if (pickInfoDataSource != null) {
                pickInfo.setObservationIndex(pickInfoDataSource.getIndexPriorToAllProcessing(pickInfo.getObservationIndex()));
            }
        }
        return pickInfo;
    }

    public static class MatrixLayoutErrorMessage
    extends Throwable {
        final String messageID;

        public MatrixLayoutErrorMessage(String messageID) {
            this.messageID = messageID;
        }

        @Override
        public String getMessage() {
            return this.messageID;
        }
    }

    protected static interface CellFactoryInterface {
        public JComponent newCellComponent(SimpleModelInterface var1, DataSource[] var2, Channel var3);
    }

    protected static interface CellFactoryInterface2 {
        public JComponent newCellComponent(SimpleModelInterface var1, DataSource[] var2, MatrixInfo var3, Channel var4);
    }

    public static class MatrixInfo {
        private Object columnOrdinal;
        private Object rowOrdinal;

        public MatrixInfo(Object columnOrdinal, Object rowOrdinal) {
            this.columnOrdinal = columnOrdinal;
            this.rowOrdinal = rowOrdinal;
        }

        public Object getColumnOrdinal() {
            return this.columnOrdinal;
        }

        public Object getRowOrdinal() {
            return this.rowOrdinal;
        }
    }
}

