/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ColorRampLegendCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.LegendDetail;
import com.sas.graphics.util.gtk.LegendStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.gl.ColorRampLegend;
import com.sas.graphics.util.gtk.gl.ColorRampLegendStyle;
import com.sas.graphics.util.gtk.gl.JLegend;
import com.sas.graphics.util.gtk.gl.Legend;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.measures.BaseLength;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.Format;
import java.util.ArrayList;
import java.util.Vector;

public class LegendCell
extends Cell {
    private final int MIN_COLORRAMP_SIZE_THRESHOLD = (int)new BaseLength(12.0, "pt").getMagnitude((Object)"px") * 15;
    private final ColorRampLegend colorRampLegend;
    private final Legend legend;
    private final JLegend jlegend;
    LabelZoneList labelZone;
    ValueZone[] valueZones;

    public LegendCell(LegendCellModel cellModel, Channel channel) {
        super(cellModel, channel);
        if (!(this instanceof HierarchicalLegendCell)) {
            ColorRampLegendStyle gtkLegendStyle;
            this.jlegend = new JLegend();
            if (cellModel == null) {
                this.legend = null;
                this.colorRampLegend = null;
                return;
            }
            if (cellModel instanceof ColorRampLegendCellModel) {
                this.legend = null;
                this.colorRampLegend = new ColorRampLegend();
                gtkLegendStyle = this.colorRampLegend.getStyle();
                this.jlegend.setColorRampLegend(this.colorRampLegend);
                this.setupColorRampLegend(cellModel);
            } else {
                this.colorRampLegend = null;
                this.legend = new Legend();
                gtkLegendStyle = this.legend.getStyle();
                this.jlegend.setLegend(this.legend);
                this.setupLegend(cellModel);
            }
            this.setupLegendStyle(cellModel, (LegendStyle)gtkLegendStyle);
            this.setLayout(new BorderLayout());
            this.add((Component)this.jlegend, "Center");
        } else {
            this.legend = null;
            this.jlegend = null;
            this.colorRampLegend = null;
        }
        if (cellModel != null) {
            if (cellModel.getAntialiasedGraphics() != null) {
                this.setAntiAliasingEnabled(cellModel.getAntialiasedGraphics());
            }
            if (cellModel.getAntialiasedText() != null) {
                this.setTextAntiAliasingEnabled(cellModel.getAntialiasedText());
            }
        }
    }

    @Override
    protected void updateChannel() {
        if (this.jlegend == null) {
            super.updateChannel();
        }
    }

    private void setupLegend(LegendCellModel cellModel) {
        LineStyle markerOutlineLineStyle;
        LegendStyle gtkLegendStyle = this.legend.getStyle();
        LegendModel legendModel = cellModel.getLegendModel();
        ColorMapper mapper = cellModel.getColorMapper();
        boolean verticalOrientation = cellModel.getOrientation() != null && cellModel.getOrientation() == 1;
        this.legend.getStyle().setShapePolicy(verticalOrientation ? 2 : 1);
        this.legend.setLayoutByRow(!verticalOrientation);
        if (mapper == null) {
            StringVector sv = cellModel.getStringVector();
            ColorVector cv = cellModel.getColorVector();
            if (sv != null && cv != null) {
                this.legend.labels.connectFrom((StringPipe)sv);
                this.legend.colors.connectFrom((ColorPipe)cv);
            } else if (cellModel.getMarkerColor() != null) {
                this.legend.colors.setValue(cellModel.getMarkerColor());
                if (sv != null) {
                    this.legend.labels.connectFrom((StringPipe)sv);
                }
            }
        } else {
            if (mapper instanceof ContinuousRangeToColorMapper) {
                this.legend.setContinuous(true);
            } else {
                this.legend.setContinuous(false);
            }
            this.legend.labels.connectFrom(mapper.label);
            this.legend.colors.connectFrom(mapper.uniqueValue);
        }
        TextStyle labelTextStyle = legendModel.getLabelTextStyle();
        if (labelTextStyle.isVisible()) {
            this.legend.title.setValue(legendModel.getLabel() != null ? legendModel.getLabel() : cellModel.getDefaultLabel());
        }
        int vj = 3;
        int hj = 1;
        int tp = 2;
        switch (legendModel.getLabelPlacement()) {
            case 11304: {
                vj = 3;
                hj = 0;
                tp = 2;
                break;
            }
            case 11305: {
                vj = 3;
                hj = 2;
                tp = 2;
                break;
            }
            case 11301: {
                vj = 3;
                hj = 1;
                tp = 0;
                break;
            }
            case 11302: {
                vj = 0;
                hj = 1;
                tp = 0;
                break;
            }
            case 11303: {
                vj = 1;
                hj = 0;
                tp = 0;
                break;
            }
            case 11311: {
                vj = 3;
                hj = 0;
                tp = 0;
                break;
            }
            case 11312: {
                vj = 3;
                hj = 1;
                tp = 0;
                break;
            }
            case 11313: {
                vj = 3;
                hj = 2;
                tp = 0;
                break;
            }
            case 11314: {
                vj = 1;
                hj = 0;
                tp = 0;
                break;
            }
            case 11315: {
                vj = 1;
                hj = 1;
                tp = 0;
                break;
            }
            case 11316: {
                vj = 1;
                hj = 2;
                tp = 0;
                break;
            }
            case 11317: {
                vj = 0;
                hj = 0;
                tp = 0;
                break;
            }
            case 11318: {
                vj = 0;
                hj = 1;
                tp = 0;
                break;
            }
            case 11319: {
                vj = 0;
                hj = 2;
                tp = 0;
            }
        }
        com.sas.graphics.util.gtk.TextStyle gtkLabelStyle = gtkLegendStyle.getTitleStyle();
        gtkLabelStyle.setVerticalJustification(vj);
        gtkLabelStyle.setHorizontalJustification(hj);
        gtkLegendStyle.setTitlePosition(tp);
        if (cellModel.getMarkerMapper() != null) {
            this.legend.markerTypes.connectFrom(cellModel.getMarkerMapper().uniqueValue);
            if (!this.legend.labels.isConnected()) {
                this.legend.labels.connectFrom(cellModel.getMarkerMapper().label);
            }
        } else if (cellModel.getMarkerVector() != null) {
            this.legend.markerTypes.connectFrom((IntegerPipe)cellModel.getMarkerVector());
        } else if (cellModel.getMarkerType() != null) {
            this.legend.markerTypes.setValue(cellModel.getMarkerType().intValue());
        }
        if ((markerOutlineLineStyle = cellModel.getMarkerOutlineLineStyle()) != null) {
            gtkLegendStyle.setMarkerEdgeColor(markerOutlineLineStyle.getColor());
        }
        this.legend.setSkinFactory(cellModel.getSkinFactory());
    }

    private void setupColorRampLegend(LegendCellModel cellModel) {
        int i;
        TextStyle labelTextStyle;
        LegendModel legendModel = cellModel.getLegendModel();
        this.colorRampLegend.getStyle().setFitAlgoritm(new String[]{"thin_end_to_beginning"});
        LineStyle markerOutlineLineStyle = cellModel.getMarkerOutlineLineStyle();
        this.colorRampLegend.getStyle().setContinuousEdgeColorLinkedToLabelColor(true);
        if (markerOutlineLineStyle != null) {
            this.colorRampLegend.getStyle().setContinuousEdgeColorLinkedToLabelColor(false);
            this.colorRampLegend.getStyle().getContinuousEdgeStyle().setColor(markerOutlineLineStyle.getColor());
        }
        if ((labelTextStyle = legendModel.getLabelTextStyle()).isVisible()) {
            String crLabel = legendModel.getLabel() != null ? legendModel.getLabel() : cellModel.getDefaultLabel();
            this.colorRampLegend.title.setValue(crLabel);
        }
        ColorRampLegendCellModel colorRampLegendCellModel = (ColorRampLegendCellModel)cellModel;
        this.colorRampLegend.getStyle().setSmoothShading(true);
        int place = colorRampLegendCellModel.getPlacement();
        if (place == 3 || place == 7) {
            this.colorRampLegend.getStyle().setOrientation(2);
            if (place == 3) {
                this.colorRampLegend.getStyle().setPrimary(true);
                this.colorRampLegend.getStyle().setTitleAngle(270.0);
            } else {
                this.colorRampLegend.getStyle().setPrimary(false);
                this.colorRampLegend.getStyle().setTitleAngle(90.0);
            }
        } else {
            this.colorRampLegend.getStyle().setOrientation(1);
            this.colorRampLegend.getStyle().setPrimary(place == 5);
        }
        ColorProperty cp = new ColorProperty();
        ColorVector cv = new ColorVector();
        Color[] col = colorRampLegendCellModel.getColors();
        if (col != null && col.length > 0) {
            for (int i2 = 0; i2 < col.length; ++i2) {
                cv.addValue(col[i2]);
            }
        }
        cp.connectFrom((ColorPipe)cv);
        this.colorRampLegend.colors.connectFrom((ColorPipe)cp);
        NumericVector nv = new NumericVector();
        Double[] num = colorRampLegendCellModel.getColorValues();
        if (num != null && num.length > 0) {
            for (i = 0; i < num.length; ++i) {
                nv.addValue(num[i].doubleValue());
            }
        } else {
            for (i = 0; i < col.length; ++i) {
                nv.addValue((double)i / ((double)col.length - 1.0));
            }
        }
        this.colorRampLegend.colorPlacementPercentage.connectFrom((NumericPipe)nv);
        StringVector sv = new StringVector();
        String[] lab = colorRampLegendCellModel.getLabels();
        if (lab != null && lab.length > 0) {
            for (int i3 = 0; i3 < lab.length; ++i3) {
                sv.addValue(lab[i3]);
            }
        } else {
            double low = colorRampLegendCellModel.getLowValue();
            double high = colorRampLegendCellModel.getHighValue();
            double range = high - low;
            GTKFormat colorFmt = colorRampLegendCellModel.getValueFormat();
            if (colorFmt == null) {
                colorFmt = new GTKFormat((Format)SASFormat.getInstance((String)"12.2"));
            }
            for (int i4 = 0; i4 < col.length; ++i4) {
                try {
                    sv.addValue("" + colorFmt.format((Object)new Double(low + nv.getValue(i4) * range)));
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
        }
        this.colorRampLegend.labels.connectFrom((StringPipe)sv);
        NumericVector nv2 = new NumericVector();
        Double[] num2 = colorRampLegendCellModel.getLabelValues();
        if (num2 != null && num2.length > 0) {
            for (int i5 = 0; i5 < num2.length; ++i5) {
                nv2.addValue(num2[i5].doubleValue());
            }
            this.colorRampLegend.labelPlacementPercentage.connectFrom((NumericPipe)nv2);
        } else if (nv.getValueCount() == sv.getValueCount()) {
            this.colorRampLegend.labelPlacementPercentage.connectFrom((NumericPipe)nv);
        } else {
            nv2.addValue(0.0);
            nv2.addValue(1.0);
            this.colorRampLegend.labelPlacementPercentage.connectFrom((NumericPipe)nv2);
        }
        Dimension prefSize = this.getPreferredSize();
        if (place == 3 || place == 7) {
            this.colorRampLegend.setLength(prefSize.getWidth());
        } else {
            this.colorRampLegend.setLength(prefSize.getHeight());
        }
        ColorMapper mapper = cellModel.getColorMapper();
        this.colorRampLegend.getStyle().setMissingItemsVisible(false);
        if (mapper != null && mapper.getMissingReplacement() != null) {
            this.colorRampLegend.missingColors.connectFrom(mapper.missingColor);
            this.colorRampLegend.missingLabels.connectFrom(mapper.missingLabel);
            this.colorRampLegend.getStyle().setMissingItemsVisible(true);
        }
    }

    private void setupLegendStyle(LegendCellModel cellModel, LegendStyle gtkLegendStyle) {
        FillStyle backgroundFillStyle;
        ShadowStyle shadowStyle;
        com.sas.graphics.util.gtk.TextStyle gtkValueStyle = gtkLegendStyle.getLabelStyle();
        com.sas.graphics.util.gtk.TextStyle gtkLabelStyle = gtkLegendStyle.getTitleStyle();
        LegendModel legendModel = cellModel.getLegendModel();
        TextStyle valueTextStyle = legendModel.getValueTextStyle();
        TextStyle labelTextStyle = legendModel.getLabelTextStyle();
        LineStyle frameStyle = legendModel.getFrameLineStyle();
        if (labelTextStyle != null) {
            gtkLabelStyle.setFont(labelTextStyle.getFont());
            gtkLabelStyle.setColor(labelTextStyle.getColor());
            shadowStyle = labelTextStyle.getShadowStyle();
            if (shadowStyle.isVisible()) {
                gtkLabelStyle.setShadowOn(true);
                gtkLabelStyle.setShadowColor(shadowStyle.getColor());
                gtkLabelStyle.setShadowOffsetX((int)shadowStyle.getOffsetX().getMagnitude((Object)"px"));
                gtkLabelStyle.setShadowOffsetY((int)shadowStyle.getOffsetY().getMagnitude((Object)"px"));
                gtkLabelStyle.setShadowSoftness((float)shadowStyle.getSoftness());
            }
            gtkLabelStyle.setBackgroundColor(null);
        }
        if (valueTextStyle != null) {
            gtkValueStyle.setFont(valueTextStyle.getFont());
            gtkValueStyle.setColor(valueTextStyle.getColor());
            shadowStyle = valueTextStyle.getShadowStyle();
            if (shadowStyle.isVisible()) {
                gtkValueStyle.setShadowOn(true);
                gtkValueStyle.setShadowColor(shadowStyle.getColor());
                gtkValueStyle.setShadowOffsetX((int)shadowStyle.getOffsetX().getMagnitude((Object)"px"));
                gtkValueStyle.setShadowOffsetY((int)shadowStyle.getOffsetY().getMagnitude((Object)"px"));
                gtkValueStyle.setShadowSoftness((float)shadowStyle.getSoftness());
            }
            gtkValueStyle.setBackgroundColor(null);
        }
        if (legendModel.isDrillIconVisible()) {
            gtkLegendStyle.setTitleMarkerVisible(true);
            Channel jlegendChannel = this.jlegend.getNetworkRoot().getChannel();
            int titleMarkerID = jlegendChannel.addCustomMarker((CustomMarkerInterface)cellModel.getTitleMarker());
            gtkLegendStyle.setTitleMarkerId(titleMarkerID);
            gtkLegendStyle.setTitleMarkerSize(cellModel.getTitleMarker().getSize());
        }
        if (cellModel.getBackgroundVisible() != Boolean.FALSE && (backgroundFillStyle = legendModel.getBackgroundFillStyle()) != null) {
            gtkLegendStyle.setBackgroundOn(backgroundFillStyle.isVisible());
            gtkLegendStyle.setBackgroundColor(backgroundFillStyle.getSolidFillColor());
        }
        shadowStyle = legendModel.getShadowStyle();
        gtkLegendStyle.setBorderOn(false);
        if (shadowStyle != null && shadowStyle.isVisible()) {
            gtkLegendStyle.setBorderOn(true);
            gtkLegendStyle.setBorderStyle(2);
            gtkLegendStyle.setBorderColor(shadowStyle.getColor());
            gtkLegendStyle.setShadowOffsetX((int)shadowStyle.getOffsetX().getMagnitude((Object)"px"));
            gtkLegendStyle.setShadowOffsetY((int)shadowStyle.getOffsetY().getMagnitude((Object)"px"));
            gtkLegendStyle.setShadowSoftness((float)shadowStyle.getSoftness());
            gtkLegendStyle.setBorderLineWidth((float)frameStyle.getThickness().getMagnitude((Object)"px"));
            if (legendModel.getFrameLineStyle().getVisibilityPolicy() != 10202) {
                gtkLegendStyle.setBorderLineColor(frameStyle.getColor());
            } else {
                gtkLegendStyle.setBorderLineColor(new Color(0, true));
            }
        } else if (frameStyle.getVisibilityPolicy() != 10202) {
            boolean lineOn = true;
            if (frameStyle.getVisibilityPolicy() == 10202) {
                lineOn = false;
            } else if (frameStyle.getVisibilityPolicy() == 10200 && cellModel.getFrameLineStyleVisibilityPolicyForAutomatic() == Boolean.FALSE) {
                lineOn = false;
            }
            if (lineOn) {
                gtkLegendStyle.setBorderOn(true);
                gtkLegendStyle.setBorderLineColor(frameStyle.getColor());
                gtkLegendStyle.setBorderLineWidth((float)frameStyle.getThickness().getMagnitude((Object)"px"));
            }
        }
    }

    public boolean setMarkerMapper(StringToNumberMapper markers) {
        if (this.legend != null) {
            LegendCellModel cellModel = (LegendCellModel)this.getModel();
            cellModel.setMarkerMapper(markers);
            this.legend.markerTypes.connectFrom(markers.uniqueValue);
            if (cellModel.getColorMapper() == null && cellModel.getStringVector() == null) {
                this.legend.labels.connectFrom(markers.label);
            }
        }
        return this.legend != null;
    }

    public boolean setMarkerVector(IntegerVector markers) {
        if (this.legend != null) {
            LegendCellModel cellModel = (LegendCellModel)this.getModel();
            cellModel.setMarkerVector(markers);
            this.legend.markerTypes.connectFrom((IntegerPipe)markers);
        }
        return this.legend != null;
    }

    @Override
    protected synchronized void construct() {
    }

    @Override
    public boolean isVisible() {
        if (this instanceof HierarchicalLegendCell) {
            return super.isVisible();
        }
        if (this.colorRampLegend == null && this.legend == null) {
            return false;
        }
        LegendCellModel cellModel = (LegendCellModel)this.getModel();
        if (cellModel == null) {
            return false;
        }
        LegendModel legendModel = cellModel.getLegendModel();
        return legendModel != null && legendModel.isVisible();
    }

    public Dimension getPreferredSize(Dimension maxSize) {
        Dimension d = null;
        if (this.jlegend != null && this.isVisible()) {
            Insets m = this.getInsets();
            if (maxSize != null) {
                this.jlegend.setMaximumSize(new Dimension(maxSize.width - (m.left + m.right), maxSize.height - (m.top + m.bottom)));
            } else {
                this.jlegend.setMaximumSize(null);
            }
            d = this.jlegend.getPreferredSize();
            this.jlegend.setMaximumSize(null);
            d.width += m.left + m.right;
            d.height += m.top + m.bottom;
            if (maxSize != null) {
                if (this.colorRampLegend != null) {
                    int place = ((ColorRampLegendCellModel)this.getModel()).getPlacement();
                    if (place == 3 || place == 7) {
                        int height = maxSize.height;
                        if (height > this.MIN_COLORRAMP_SIZE_THRESHOLD) {
                            height = Math.max(this.MIN_COLORRAMP_SIZE_THRESHOLD, (int)((double)maxSize.height * 0.7));
                        }
                        d.height = height;
                        if (d.width > maxSize.width) {
                            d.height = 0;
                            d.width = 0;
                        }
                    } else {
                        int width = maxSize.width;
                        if (width > this.MIN_COLORRAMP_SIZE_THRESHOLD) {
                            width = Math.max(this.MIN_COLORRAMP_SIZE_THRESHOLD, (int)((double)maxSize.width * 0.7));
                        }
                        d.width = width;
                        if (d.height > maxSize.height) {
                            d.width = 0;
                            d.height = 0;
                        }
                    }
                } else if (d.width > maxSize.width || d.height > maxSize.height) {
                    d.height = 0;
                    d.width = 0;
                }
            }
        }
        return d != null ? d : new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    public Util.LabelAndValueZones getLabelAndValueZones() {
        this._computeSelectableShapes();
        return new Util.LabelAndValueZones(this.labelZone, this.valueZones);
    }

    private void _computeSelectableShapes() {
        Vector selectableShapes;
        NetworkRoot root;
        if (this.jlegend != null && (root = this.jlegend.getNetworkRoot()) != null && (selectableShapes = root.computeSelectableShapes()) != null) {
            int count = selectableShapes.size();
            Shape labelMarkerShape = null;
            Shape labelTitleShape = null;
            ArrayList<ValueZone> valueZonesAL = new ArrayList<ValueZone>(count);
            for (int ii = 0; ii < count; ++ii) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                if (!(element instanceof Legend)) continue;
                LegendDetail ld = (LegendDetail)sr.getDetail();
                if (ld != null) {
                    switch (ld.getType()) {
                        case 0: {
                            try {
                                ValueList valueList = new ValueList(((Legend)element).labels.getValue(ld.getLabelIndex()), ((Legend)element).labels.getValue(ld.getLabelIndex()), null);
                                Shape shape = this._getTranslatedShape(selectableShape);
                                valueZonesAL.add(new ValueZone(shape, valueList));
                            }
                            catch (MissingValueException valueList) {}
                            break;
                        }
                        case 2: {
                            labelMarkerShape = this._getTranslatedShape(selectableShape);
                            break;
                        }
                        case 1: {
                            labelTitleShape = this._getTranslatedShape(selectableShape);
                            break;
                        }
                    }
                }
                if (labelTitleShape != null) {
                    LegendCellModel cellModel = (LegendCellModel)this.getModel();
                    this.labelZone = new LabelZoneList(labelTitleShape, cellModel.getDefaultLabel(), cellModel.getDefaultLabel(), new DataZone(labelMarkerShape), null);
                }
                this.valueZones = valueZonesAL.toArray(new ValueZone[0]);
            }
        }
    }

    private Shape _getTranslatedShape(SelectableShape selectableShape) {
        Shape shape = selectableShape.getShape();
        if (shape != null) {
            Insets i = this.getInsets();
            if (shape instanceof Polygon) {
                Polygon p = (Polygon)shape;
                p.translate(i.left, i.top);
            } else if (shape instanceof Rectangle) {
                Rectangle r = (Rectangle)shape;
                r.translate(i.left, i.top);
            }
        }
        return shape;
    }

    public Channel getJLegendChannel() {
        Channel result = this.jlegend == null ? this.getChannel() : this.jlegend.getNetworkRoot().getChannel();
        return result;
    }

    @Override
    public void setAntiAliasingEnabled(boolean b) {
        if (this.jlegend != null) {
            this.jlegend.setAntiAliasingEnabled(b);
        }
    }

    @Override
    public void setTextAntiAliasingEnabled(boolean b) {
        if (this.jlegend != null) {
            this.jlegend.setTextAntiAliasingEnabled(b);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (w == 0) {
            w = 1;
        }
        if (h == 0) {
            h = 1;
        }
        super.setBounds(x, y, w, h);
    }
}

