/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.cell.NetworkComponent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.util.Util;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class LabelComponent
extends NetworkComponent {
    private transient String text;
    private transient TextStyle textStyle;
    private transient int textAngle = 0;
    private transient Insets margin = new Insets(0, 0, 0, 0);
    private transient boolean isValidNetwork = false;

    public LabelComponent(String label, TextStyle style) {
        this(label, style, 2, null);
    }

    public LabelComponent(String label, TextStyle style, Channel channel) {
        this(label, style, 2, channel);
    }

    public LabelComponent(String label, TextStyle style, int displayMode, Channel channel) {
        super(displayMode, channel);
        this._setTextStyle(style);
        this.text = label;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    private void _setTextStyle(TextStyle aTextStyle) {
        if (!Util.equal((Object)this.textStyle, (Object)aTextStyle)) {
            this.invalidateNetwork();
            this.textStyle = aTextStyle;
            if (this.textStyle instanceof AdvancedTextStyle) {
                this._applyTextAngle(((AdvancedTextStyle)this.textStyle).getBaselineAngle());
            }
        }
    }

    public void setTextStyle(TextStyle aTextStyle) {
        this._setTextStyle(aTextStyle);
    }

    public void apply(TextStyle aTextStyle) {
        this._setTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(aTextStyle, this.textStyle));
    }

    public String getLabel() {
        return this.text;
    }

    public void setLabel(String newLabel) {
        if (!Util.equal((Object)this.text, (Object)newLabel)) {
            this.invalidateNetwork();
            this.text = newLabel;
        }
    }

    public void setMargin(Insets aMargin) {
        if (!Util.equal((Object)this.margin, (Object)aMargin) && aMargin != null) {
            this.invalidateNetwork();
            this.margin = aMargin;
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    private void _applyTextAngle(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            angle = 0.0;
        }
        int adustedAngle = (int)(Math.round(angle / 90.0) * 90L);
        if ((double)this.textAngle != angle) {
            this.invalidateNetwork();
            this.textAngle = adustedAngle;
        }
    }

    public void setAngle(double angle) {
        this._applyTextAngle(angle);
    }

    public double getAngle() {
        return this.textAngle;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle b = this.getBounds();
        if (b.x != x || b.y != y || b.width != w || b.height != h) {
            this.invalidateNetwork();
            super.setBounds(x, y, w, h);
        }
    }

    @Override
    public void layout() {
        super.layout();
        this.validateNetwork();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.validateNetwork();
        Channel channel = this.getChannel();
        if (channel != null) {
            channel.setSingleBufferGraphics(g);
        }
        super.paintComponent(g);
    }

    public void invalidateNetwork() {
        this.isValidNetwork = false;
    }

    protected synchronized void validateNetwork() {
        if (!this.isValidNetwork) {
            this.updateNetwork();
        }
    }

    protected synchronized void updateNetwork() {
        Channel channel = this.getChannel();
        Rectangle b = this.getBounds();
        if (channel == null || b.width < 1 || b.height < 1) {
            return;
        }
        this.updateChannel();
        this.getComposite().removeAllElements();
        Rectangle r = new Rectangle(0, 0, b.width, b.height);
        Insets insets = this.getInsets();
        r.x = insets.left;
        r.y = insets.top;
        r.width -= insets.left + insets.right;
        r.height -= insets.top + insets.bottom;
        if (this.margin != null) {
            r.x += this.margin.left;
            r.y += this.margin.top;
            r.width -= this.margin.left + this.margin.right;
            r.height -= this.margin.top + this.margin.bottom;
        }
        RasterLabel rasterLabel = new RasterLabel();
        rasterLabel.string.setValue(this.text);
        rasterLabel.setFont(this.textStyle.getFont());
        rasterLabel.color.setValue(this.textStyle.getColor());
        rasterLabel.angle.setValue((double)this.textAngle);
        rasterLabel.maxWidth.setValue((double)r.width);
        rasterLabel.maxHeight.setValue((double)r.height);
        rasterLabel.fit.setValue(true);
        rasterLabel.truncate.setValue(false);
        ShadowStyle shadow = this.textStyle.getShadowStyle();
        if (shadow.isVisible()) {
            rasterLabel.shadowColor.setValue(shadow.getColor());
            rasterLabel.shadowOn.setValue(shadow.isVisible());
            rasterLabel.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
            rasterLabel.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
        }
        rasterLabel.verticalJustification.setValue(1);
        rasterLabel.horizontalJustification.setValue(1);
        BoundingBox box = new BoundingBox();
        RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)channel, (String)rasterLabel.string.getValue(), (double)rasterLabel.angle.getValue(), (int)rasterLabel.horizontalJustification.getValue(), (int)rasterLabel.verticalJustification.getValue(), (boolean)rasterLabel.fit.getValue(), (boolean)rasterLabel.truncate.getValue(), (double)rasterLabel.maxWidth.getValue(), (double)rasterLabel.maxHeight.getValue(), (Font)rasterLabel.getFont());
        double halfBoxX = box.getSize().x / 2.0;
        double transX = 0.0;
        switch (this.textStyle.getJustification()) {
            default: {
                transX = (double)r.x + (double)r.width / 2.0;
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                transX = (double)(r.x + r.width) - halfBoxX;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                transX = (double)r.x + halfBoxX;
            }
        }
        double transY = (double)r.y + (double)r.height / 2.0;
        transY = (double)b.height - transY;
        if (this.textAngle == 0) {
            transY += 1.0;
        } else if (this.textAngle == 90) {
            transX -= 1.0;
        }
        rasterLabel.transform.translateX.setValue(transX);
        rasterLabel.transform.translateY.setValue(transY);
        this.getComposite().addElement((Element)rasterLabel);
        this.isValidNetwork = true;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.textStyle.isVisible() && this.text != null && this.text.length() > 0) {
            Channel channel = this.getChannel();
            if (channel == null) {
                return new Dimension(1, 1);
            }
            this.updateChannel();
            int hm = 0;
            int vm = 0;
            if (this.margin != null) {
                hm += this.margin.left + this.margin.right;
                vm += this.margin.bottom + this.margin.top;
            }
            int hs = 0;
            int vs = 0;
            if (this.textStyle.getShadowStyle().isVisible()) {
                hs = (int)Math.abs(this.textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
                vs = (int)Math.abs(this.textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            }
            BoundingBox box = new BoundingBox();
            Font font = this.textStyle.getFont();
            RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)this.getChannel(), (String)this.text, (double)this.textAngle, (int)1, (int)1, (boolean)false, (boolean)false, (double)-1.0, (double)-1.0, (Font)font);
            int x = (int)box.getSize().x;
            int y = (int)box.getSize().y;
            int w = x + hm + hs;
            w += w % 2;
            int h = y + vm + vs;
            h += h % 2;
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }
}

