/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;

public class HierarchyPane
extends HierarchicalPane {
    private final HierarchyComponentFactory hierarchyComponentFactory;

    public HierarchyPane(ValueTree tree, TextStyle textStyle, Channel channel) {
        this(tree, new DefaultHierarchyComponentFactory(textStyle, channel), channel);
    }

    public HierarchyPane(ValueTree tree, HierarchyComponentFactory hierarchyComponentFactory, Channel channel) {
        super(tree);
        this.hierarchyComponentFactory = hierarchyComponentFactory != null ? hierarchyComponentFactory : new DefaultHierarchyComponentFactory(null, channel);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo info = (DataTreeInfo)root.getValue();
        int variableCount = info.getGroupVariableCount();
        Object prevHierarchyName = null;
        for (int ii = 0; ii < variableCount; ++ii) {
            JComponent hierarchyComponent;
            String hierarchyName;
            Variable variable = info.getGroupVariableAt(ii);
            if (!(variable instanceof OLAPLevelVariable) || (hierarchyName = ((OLAPLevelVariable)variable).getHierachyName()) == null || hierarchyName.equals(prevHierarchyName) || (hierarchyComponent = this.hierarchyComponentFactory.newHierarchyComponent(hierarchyName)) == null) continue;
            this.contentPanel.add(hierarchyComponent);
            this.componentMap.put(hierarchyName, hierarchyComponent);
        }
    }

    public JComponent getHierarchyComponent(String hierarchyName) {
        return (JComponent)this.componentMap.get(hierarchyName);
    }

    public static class DefaultHierarchyComponentFactory
    implements HierarchyComponentFactory {
        private final Channel channel;
        private final TextStyle textStyle;

        public DefaultHierarchyComponentFactory(TextStyle textStyle, Channel channel) {
            AdvancedTextStyle ts = new AdvancedTextStyle();
            Util.Conveyer.applyTextStyle(textStyle, ts);
            ts.setJustification(2);
            this.textStyle = ts;
            this.channel = channel;
        }

        @Override
        public JComponent newHierarchyComponent(String hierarchyName) {
            OLAPDataSetInterface olapDataSet = null;
            Map actionSupportFilterAttributes = null;
            SwingActionProvider actionProvider = null;
            ActionUIFactory actionUIFactory = null;
            ActionSupportFilter actionSupportFilter = null;
            Color backgroundColor = null;
            ListSelectionModel selectionModel = null;
            int[] selectionIndexes = null;
            return new StringComponent(hierarchyName, this.textStyle, selectionModel, selectionIndexes, actionUIFactory, actionSupportFilter, actionProvider, actionSupportFilterAttributes, olapDataSet, new StringComponent.CellNodeInfo(backgroundColor, false, false), this.channel);
        }
    }

    public static interface HierarchyComponentFactory {
        public JComponent newHierarchyComponent(String var1);
    }
}

