/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.NetworkComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class HierarchicalPane
extends JComponent {
    protected final JPanel contentPanel = new View();
    protected ValueTree tree;
    protected final HashMap componentMap = new HashMap();
    private boolean scrollXEnabled = true;
    private boolean scrollYEnabled = true;

    public static void flipY(HierarchicalPane pane) {
        Rectangle contentPanelBounds = pane.contentPanel.getBounds();
        int componentCount = pane.contentPanel.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            JComponent component = (JComponent)pane.contentPanel.getComponent(i);
            Rectangle componentBounds = component.getBounds();
            componentBounds.y = contentPanelBounds.height - (componentBounds.y + componentBounds.height);
            component.setBounds(componentBounds);
        }
    }

    public static void applyAntialiasing(HierarchicalPane hierarchicalPane, boolean isGraphicalAntiAliasingEnabled, boolean isTextAntiAliasingEnabled) {
        if (hierarchicalPane != null) {
            Component[] components = hierarchicalPane.getContentPanelComponents();
            for (int ii = 0; ii < components.length; ++ii) {
                if (!(components[ii] instanceof NetworkComponent)) continue;
                NetworkComponent networkComponent = (NetworkComponent)components[ii];
                networkComponent.setAntiAliasingEnabled(isGraphicalAntiAliasingEnabled);
                networkComponent.setTextAntiAliasingEnabled(isTextAntiAliasingEnabled);
            }
        }
    }

    public void applyAntialiasing(boolean isGraphicalAntiAliasingEnabled, boolean isTextAntiAliasingEnabled) {
        HierarchicalPane.applyAntialiasing(this, isGraphicalAntiAliasingEnabled, isTextAntiAliasingEnabled);
    }

    public static void flipX(HierarchicalPane pane) {
        Rectangle contentPanelBounds = pane.contentPanel.getBounds();
        int componentCount = pane.contentPanel.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            JComponent component = (JComponent)pane.contentPanel.getComponent(i);
            Rectangle componentBounds = component.getBounds();
            componentBounds.x = contentPanelBounds.width - (componentBounds.x + componentBounds.width);
            component.setBounds(componentBounds);
        }
    }

    public void dump() {
        if ((Util.Debug.DEBUG_ENABLED & Util.Debug.DEBUG_FLAG_HIERARCHICAL_PANE_DUMP) > 0L) {
            Rectangle b = this.getBounds();
            System.out.println(">>>>>>>>>>> START DUMPING >>>>>>>>>>>>>");
            System.out.println("======= Pane:" + this.getName() + ":========");
            System.out.println("======= Pane Bounds ========");
            System.out.println("x: " + b.x);
            System.out.println("y: " + b.y);
            System.out.println("w: " + b.width);
            System.out.println("h: " + b.height);
            b = this.contentPanel.getBounds();
            System.out.println("======= contentPanel Bounds ========");
            System.out.println("x: " + b.x);
            System.out.println("y: " + b.y);
            System.out.println("w: " + b.width);
            System.out.println("h: " + b.height);
            Component[] components = this.getContentPanelComponents();
            for (int ii = 0; ii < components.length; ++ii) {
                b = components[ii].getBounds();
                System.out.println("======= Component:" + components[ii].getName() + " ========");
                System.out.println("x: " + b.x);
                System.out.println("y: " + b.y);
                System.out.println("w: " + b.width);
                System.out.println("h: " + b.height);
            }
            System.out.println("======= Pane:" + this.getName() + ":========");
            System.out.println("<<<<<<<<<<<< END DUMPING <<<<<<<<<<<<<<");
        }
    }

    public HierarchicalPane(ValueTree tree) {
        this.tree = tree;
        this.setOpaque(false);
        super.setLayout(null);
        this.contentPanel.setOpaque(false);
        super.add(this.contentPanel);
    }

    public ValueTree getTree() {
        return this.tree;
    }

    public void setContentPanelBounds(int x, int y, int w, int h) {
        this.contentPanel.setBounds(x, y, w, h);
    }

    public Component[] getContentPanelComponents() {
        return this.contentPanel.getComponents();
    }

    public int getContentPanelComponentCount() {
        return this.contentPanel.getComponentCount();
    }

    public static Dimension getMaxContentPanelComponentPreferredSize(HierarchicalPane hierarchicalPane) {
        if (hierarchicalPane != null) {
            Dimension preferredSize = new Dimension(0, 0);
            Component[] components = hierarchicalPane.getContentPanelComponents();
            if (components != null) {
                for (int ii = 0; ii < components.length; ++ii) {
                    Dimension ps = components[ii].getPreferredSize();
                    if (ps.width > preferredSize.width) {
                        preferredSize.width = ps.width;
                    }
                    if (ps.height <= preferredSize.height) continue;
                    preferredSize.height = ps.height;
                }
                return preferredSize;
            }
        }
        return new Dimension(0, 0);
    }

    public static Dimension getMaxContentPanelComponentMinimumSize(HierarchicalPane hierarchicalPane) {
        if (hierarchicalPane != null) {
            Dimension minimumSize = new Dimension(0, 0);
            Component[] components = hierarchicalPane.getContentPanelComponents();
            if (components != null) {
                for (int ii = 0; ii < components.length; ++ii) {
                    Dimension ps = components[ii].getMinimumSize();
                    if (ps.width > minimumSize.width) {
                        minimumSize.width = ps.width;
                    }
                    if (ps.height <= minimumSize.height) continue;
                    minimumSize.height = ps.height;
                }
                return minimumSize;
            }
        }
        return new Dimension(0, 0);
    }

    public void setScrollYEnabled(boolean horizontalScrollEnabled) {
        this.scrollYEnabled = horizontalScrollEnabled;
    }

    public boolean isScrollYEnabled() {
        return this.scrollYEnabled;
    }

    public void setScrollXEnabled(boolean verticalScrollEnabled) {
        this.scrollXEnabled = verticalScrollEnabled;
    }

    public boolean isScrollXEnabled() {
        return this.scrollXEnabled;
    }

    public boolean scroll(int x, int y) {
        Rectangle pb = this.contentPanel.getBounds();
        return this.scrollTo(pb.x + x, pb.y + y);
    }

    public boolean scrollTo(int x, int y) {
        if (this.scrollXEnabled || this.scrollXEnabled) {
            Rectangle b = this.getBounds();
            Rectangle pb = this.contentPanel.getBounds();
            if (!this.scrollXEnabled) {
                y = pb.y;
            }
            if (!this.scrollYEnabled) {
                x = pb.x;
            }
            if (x <= 0 && y <= 0 && x + pb.width >= b.width && y + pb.height >= b.height) {
                this.setContentPanelBounds(x, y, pb.width, pb.height);
                return true;
            }
            return false;
        }
        return true;
    }

    public void flipY() {
        HierarchicalPane.flipY(this);
    }

    public void flipX() {
        HierarchicalPane.flipX(this);
    }

    @Override
    public void setLayout(LayoutManager layout) {
        throw new IllegalStateException("Layout assignment not supported for this class.");
    }

    @Override
    public Component add(Component comp) {
        throw new IllegalStateException("Add assignment not supported for this class.");
    }

    @Override
    public Component add(String name, Component comp) {
        throw new IllegalStateException("Add assignment not supported for this class.");
    }

    @Override
    public Component add(Component comp, int index) {
        throw new IllegalStateException("Add assignment not supported for this class.");
    }

    private static class View
    extends JPanel {
        public View() {
            super(null);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            Container viewport = this.getParent();
            if (viewport != null) {
                Rectangle viewportBounds = viewport.getBounds();
                viewportBounds.x = -x;
                viewportBounds.y = -y;
                Rectangle viewBounds = new Rectangle(0, 0, w, h);
                Rectangle viewVisibleBounds = viewBounds.intersection(viewportBounds);
                Component[] cells = this.getComponents();
                if (cells != null) {
                    for (int ii = 0; ii < cells.length; ++ii) {
                        if (!(cells[ii] instanceof NetworkComponent)) continue;
                        Rectangle cellBounds = cells[ii].getBounds();
                        cellBounds.y = 0;
                        cellBounds.x = 0;
                        ((NetworkComponent)cells[ii]).setVisibleBounds(cellBounds.intersection(viewVisibleBounds));
                    }
                }
            }
        }
    }
}

