/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.HierarchyPane;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class HierarchicalLegendCell
extends LegendCell {
    private static final int MARGIN = 5;
    private static final double MAX_LABEL_CONSUMPTION = 0.5;
    private LegendCellModel legendCellModel;
    private ValuePane valuePane;
    private LabelPane labelPane;
    private HierarchyPane hierarchyPane;
    private StringComponent otherStringComponent;
    private int role;
    private boolean isVertical;
    private boolean otherVisible;
    private DataTreeGroupNode root;
    private ValueTree tree;
    private Dimension hierarchyPanePreferredSize;
    private Dimension labelPanePreferredSize;
    private Dimension valuePanePreferredSize;
    private Dimension otherPreferredSize;
    private final int leafGrowthDirection;
    public static final int CATEGORY_ROLE = 2;
    public static final int SUBGROUP_ROLE = 3;
    public static final int GROUP_ROLE = 4;
    private Dimension cachedPreferredSize;
    private Dimension cachedMinimumSize;

    public HierarchicalLegendCell(ValueTree tree, LegendCellModel legendCellModel, ValuePane.ValueComponentFactory valueComponentFactory, SwingActionProvider actionProvider, int role, Channel channel) {
        this(tree, legendCellModel, valueComponentFactory, actionProvider, role, null, null, channel);
    }

    public HierarchicalLegendCell(ValueTree tree, LegendCellModel legendCellModel, ValuePane.ValueComponentFactory valueComponentFactory, SwingActionProvider actionProvider, int role, String otherLabel, Color otherColor, Channel channel) {
        super(legendCellModel, channel);
        this.legendCellModel = legendCellModel;
        this.role = role;
        this.tree = tree;
        this.root = (DataTreeGroupNode)this.tree.getRoot();
        Util.sortOLAPChildrenForLegend(this.root);
        Util.moveTotalsChildToEnd(this.root);
        this.leafGrowthDirection = legendCellModel.getPlacement();
        this.isVertical = this.leafGrowthDirection == 7 || this.leafGrowthDirection == 3;
        this.setLayout(null);
        Channel ch = this.getChannel();
        if (legendCellModel.getAntialiasedGraphics().booleanValue()) {
            ch.glEnable(13);
        } else {
            ch.glDisable(13);
        }
        this.valuePane = new ValuePane(tree, legendCellModel.getLegendModel().getFrameLineStyle(), valueComponentFactory, channel);
        this.labelPane = new LabelPane(tree, legendCellModel.getLegendModel().getLabelTextStyle(), actionProvider, channel);
        this.hierarchyPane = new HierarchyPane(tree, legendCellModel.getLegendModel().getLabelTextStyle(), channel);
        this.add(this.valuePane);
        this.add(this.labelPane);
        this.add(this.hierarchyPane);
        if (otherLabel != null) {
            this.otherVisible = true;
            Image img = null;
            if (legendCellModel.getSkinFactory() != null) {
                img = legendCellModel.getSkinFactory().getSkinImage(3);
            }
            this.otherStringComponent = new StringComponent(otherLabel, legendCellModel.getLegendModel().getValueTextStyle(), new StringComponent.CellNodeInfo(otherColor, true, false), channel, img);
            this.add(this.otherStringComponent);
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        ChartImageMapInfo2 imageMapInfo = new ChartImageMapInfo2(null, null, this.role == 2 ? this.valuePane.toChartValueZones(this, this.role) : null, this.role == 3 ? this.valuePane.toChartValueZones(this, this.role) : null, null, null, null, this.role == 2 ? this.labelPane.toLabelZoneList(this) : null, this.role == 3 ? this.labelPane.toLabelZoneList(this) : null, null, null);
        imageMapInfo.source = this;
        return imageMapInfo;
    }

    public PlotImageMapInfo2 getPlotImageMapInfo() {
        PlotImageMapInfo2 imageMapInfo = new PlotImageMapInfo2(null, null, null, null, null, null, this.role == 4 ? this.valuePane.toPlotValueZones(this, this.role) : null, null, null, null, null, null, null, null, this.role == 4 ? this.labelPane.toLabelZoneList(this) : null);
        imageMapInfo.source = this;
        return imageMapInfo;
    }

    @Override
    public void layout() {
        int componentHeight;
        int componentWidth;
        Component firstComponent;
        boolean hierarchyPaneVisible;
        boolean labelPaneVisible;
        Rectangle bounds = this.getBounds();
        Insets insets = this.getInsets();
        int w = bounds.width - insets.left - insets.right;
        int h = bounds.height - insets.top - insets.bottom;
        DataTreeInfo info = (DataTreeInfo)this.root.getValue();
        int componentX = insets.left;
        int componentY = insets.top;
        this.labelPane.setVisible(true);
        this.valuePane.setVisible(true);
        if (this.labelPanePreferredSize == null) {
            labelPaneVisible = false;
            hierarchyPaneVisible = false;
        } else if (this.isVertical) {
            labelPaneVisible = (double)this.labelPanePreferredSize.height <= (double)h * 0.5;
            hierarchyPaneVisible = false;
        } else {
            labelPaneVisible = (double)this.labelPanePreferredSize.width <= (double)w * 0.5;
            hierarchyPaneVisible = false;
        }
        if (labelPaneVisible) {
            int labelComponentWidth;
            int labelComponentHeight;
            int labelPaneHeight;
            int labelPaneWidth;
            this.labelPane.setVisible(true);
            int labelPaneY = componentY;
            int labelPaneX = componentX;
            if (this.isVertical) {
                labelPaneWidth = w;
                labelPaneHeight = this.labelPanePreferredSize.height;
                if (hierarchyPaneVisible) {
                    labelPaneWidth -= this.hierarchyPanePreferredSize.width;
                    labelPaneX += this.hierarchyPanePreferredSize.width;
                }
                labelComponentHeight = labelPaneHeight;
                labelComponentWidth = labelPaneWidth / info.getGroupVariableCount();
                componentY += labelPaneHeight;
                h -= labelPaneHeight;
            } else {
                labelPaneHeight = h;
                labelPaneWidth = this.labelPanePreferredSize.width;
                if (hierarchyPaneVisible) {
                    labelPaneHeight -= this.hierarchyPanePreferredSize.height;
                    labelPaneY += this.hierarchyPanePreferredSize.height;
                }
                labelComponentWidth = labelPaneWidth;
                labelComponentHeight = labelPaneHeight / info.getGroupVariableCount();
                componentX += labelPaneWidth;
                w -= labelPaneWidth;
            }
            LabelPane.doLayout(this.labelPane, this.leafGrowthDirection, labelComponentWidth, labelComponentHeight);
            this.labelPane.setBounds(labelPaneX, labelPaneY, labelPaneWidth, labelPaneHeight);
        } else {
            this.labelPane.setVisible(false);
        }
        if (hierarchyPaneVisible) {
            int hierarchyPaneHeight;
            int hierarchyPaneWidth;
            this.hierarchyPane.setVisible(true);
            String hierarchyName = ((OLAPLevelVariable)info.getGroupVariableAt(0)).getHierachyName();
            AlignableComponentConstraints constraints = new AlignableComponentConstraints();
            StringComponent hierarchyComponent = (StringComponent)this.hierarchyPane.getHierarchyComponent(hierarchyName);
            if (this.isVertical) {
                hierarchyPaneWidth = this.hierarchyPanePreferredSize.width;
                hierarchyPaneHeight = h;
            } else {
                hierarchyPaneWidth = w;
                hierarchyPaneHeight = this.hierarchyPanePreferredSize.height;
            }
            constraints.setBounds(new Rectangle(0, 0, hierarchyPaneWidth, hierarchyPaneHeight));
            hierarchyComponent.setAlignableComponentConstraints(constraints);
            this.hierarchyPane.setBounds(componentX, componentY, hierarchyPaneWidth, hierarchyPaneHeight);
            this.hierarchyPane.setContentPanelBounds(0, 0, hierarchyPaneWidth, hierarchyPaneHeight);
            if (this.isVertical) {
                componentX += hierarchyPaneWidth;
                w -= hierarchyPaneWidth;
            } else {
                componentY += hierarchyPaneHeight;
                h -= hierarchyPaneHeight;
            }
        } else {
            this.hierarchyPane.setVisible(false);
        }
        int minComponentSize = 1;
        if (this.valuePane.getContentPanelComponentCount() > 0 && (firstComponent = this.valuePane.getContentPanelComponents()[0]) instanceof StringComponent && !((StringComponent)firstComponent).canFrameBeTurnedOff()) {
            minComponentSize = 3;
        }
        if (this.isVertical) {
            componentWidth = (int)((double)w / (double)info.getGroupVariableCount());
            componentHeight = (int)((double)h / (double)(this.root.getLeafCount() + (this.otherVisible ? 1 : 0)));
            h = this.root.getLeafCount() * componentHeight;
        } else {
            componentWidth = (int)((double)w / (double)(this.root.getLeafCount() + (this.otherVisible ? 1 : 0)));
            componentHeight = (int)((double)h / (double)info.getGroupVariableCount());
            w = this.root.getLeafCount() * componentWidth;
        }
        if (componentWidth < minComponentSize || componentHeight < minComponentSize) {
            this.labelPane.setVisible(false);
            this.valuePane.setVisible(false);
            this.hierarchyPane.setVisible(false);
            if (this.otherStringComponent != null) {
                this.otherStringComponent.setVisible(false);
            }
        } else {
            ValuePane.doLayout(this.valuePane, this.leafGrowthDirection, componentWidth, componentHeight, 0, 0, 0, 0);
            this.valuePane.setBounds(componentX, componentY, w, h);
            if (this.otherVisible) {
                if (this.isVertical) {
                    this.otherStringComponent.setBounds(componentX, componentY + h, w, componentHeight);
                } else {
                    this.otherStringComponent.setBounds(componentX + w, componentY, componentWidth, h);
                }
                if (this.legendCellModel.getLegendModel().getFrameLineStyle().getVisibilityPolicy() != 10202 && this.otherStringComponent.getSize().getWidth() >= 3.0 && this.otherStringComponent.getSize().getHeight() >= 3.0) {
                    this.otherStringComponent.setBorder(new MatteBorder(this.isVertical ? 0 : 1, this.isVertical ? 1 : 0, 1, 1, this.legendCellModel.getLegendModel().getFrameLineStyle().getColor()));
                } else {
                    this.otherStringComponent.setBorder(null);
                }
                this.otherStringComponent.setVisible(true);
            }
        }
        Rectangle labelBounds = this.labelPane.getBounds();
        Rectangle valueBounds = this.valuePane.getBounds();
        Rectangle otherBounds = null;
        Rectangle testBounds = valueBounds;
        if (this.otherStringComponent != null) {
            testBounds = otherBounds = this.otherStringComponent.getBounds();
        }
        int addToY = 0;
        int addToX = 0;
        if (this.isVertical) {
            addToY = (int)(this.getBounds().getHeight() - (double)insets.bottom - testBounds.getBounds().getMaxY()) / 2;
        } else {
            addToX = (int)(this.getBounds().getWidth() - (double)insets.right - testBounds.getBounds().getMaxX()) / 2;
        }
        this.labelPane.setBounds(labelBounds.x + addToX, labelBounds.y + addToY, labelBounds.width, labelBounds.height);
        this.valuePane.setBounds(valueBounds.x + addToX, valueBounds.y + addToY, valueBounds.width, valueBounds.height);
        if (otherBounds != null) {
            this.otherStringComponent.setBounds(otherBounds.x + addToX, otherBounds.y + addToY, otherBounds.width, otherBounds.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        LegendModel legendModel;
        if (this.cachedPreferredSize != null) {
            return new Dimension(this.cachedPreferredSize.width, this.cachedPreferredSize.height);
        }
        LegendCellModel cellModel = (LegendCellModel)this.getModel();
        if (cellModel != null && (legendModel = cellModel.getLegendModel()) != null && legendModel.isVisible()) {
            DataTreeInfo info = (DataTreeInfo)this.root.getValue();
            this.labelPanePreferredSize = LabelPane.getPreferredSize(this.labelPane, this.leafGrowthDirection);
            this.valuePanePreferredSize = ValuePane.getPreferredSize(this.valuePane, this.leafGrowthDirection);
            Dimension maxValueSize = ValuePane.getMaxContentPanelComponentPreferredSize(this.valuePane);
            this.otherPreferredSize = new Dimension(0, 0);
            if (this.otherVisible) {
                this.otherPreferredSize = this.otherStringComponent.getPreferredSize();
                this.otherPreferredSize.width = Math.max(this.otherPreferredSize.width, maxValueSize.width);
                this.otherPreferredSize.height = Math.max(this.otherPreferredSize.height, maxValueSize.height);
            }
            this.hierarchyPanePreferredSize = new Dimension(0, 0);
            int vw = this.valuePanePreferredSize.width;
            int lw = this.labelPanePreferredSize.width;
            int hw = this.hierarchyPanePreferredSize.width;
            int ow = this.otherPreferredSize.width;
            int vh = this.valuePanePreferredSize.height;
            int lh = this.labelPanePreferredSize.height;
            int hh = this.hierarchyPanePreferredSize.height;
            int oh = this.otherPreferredSize.height;
            int w = 10;
            int h = 10;
            if (this.isVertical) {
                w += Math.max(Math.max(Math.max(vw, ow), lw) + hw, (int)((double)hw / 0.5));
                h += Math.max(Math.max(vh + lh + oh, hh), (int)((double)lh / 0.5));
            } else {
                h += Math.max(Math.max(Math.max(vh, oh), lh) + hh, (int)((double)hh / 0.5));
                w += Math.max(Math.max(vw + lw + ow, hw), (int)((double)lw / 0.5));
            }
            this.cachedPreferredSize = new Dimension(w, h);
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.cachedMinimumSize != null) {
            return new Dimension(this.cachedMinimumSize.width, this.cachedMinimumSize.height);
        }
        Dimension ps = this.getPreferredSize();
        int minWidth = 0;
        if (this.valuePane != null) {
            Component firstComponent;
            minWidth = this.valuePane.getContentPanelComponents().length;
            if (this.valuePane.getContentPanelComponentCount() > 0 && (firstComponent = this.valuePane.getContentPanelComponents()[0]) instanceof StringComponent && !((StringComponent)firstComponent).canFrameBeTurnedOff()) {
                minWidth *= 3;
            }
        }
        this.cachedMinimumSize = new Dimension(minWidth, ps.height);
        return new Dimension(minWidth, ps.height);
    }

    @Override
    public Dimension getPreferredSize(Dimension constraints) {
        Dimension cps = new Dimension();
        Dimension ps = this.getPreferredSize();
        cps.width = Math.min(ps.width, constraints.width);
        cps.height = Math.min(ps.height, constraints.height);
        Dimension ms = this.getMinimumSize();
        if (cps.width < ms.width || cps.height < ms.height) {
            cps.width = 0;
            cps.height = 0;
        }
        return cps;
    }
}

