/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Set;

class HierarchicalLayout
implements LayoutManager2 {
    private HashMap constraintMap = new HashMap();
    private boolean valid = false;
    private double widestCell;
    private double tallestCell;
    private int totalCellWidth;
    private int totalCellHeight;

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof GridBagConstraints)) {
            throw new IllegalArgumentException(" Second argument must be an instance of GridBagConstraints");
        }
        GridBagConstraints myConstraints = new GridBagConstraints();
        myConstraints.gridx = ((GridBagConstraints)constraints).gridx;
        myConstraints.gridy = ((GridBagConstraints)constraints).gridy;
        myConstraints.gridwidth = ((GridBagConstraints)constraints).gridwidth;
        myConstraints.gridheight = ((GridBagConstraints)constraints).gridheight;
        this.constraintMap.put(comp, myConstraints);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.valid = false;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalStateException("Don't call this method.");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraintMap.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (!this.valid) {
            this.calculateSizes(parent);
        }
        return new Dimension((int)(this.widestCell * (double)this.totalCellWidth + (double)this.totalCellWidth + 1.0), (int)(this.tallestCell * (double)this.totalCellHeight + (double)this.totalCellHeight + 1.0));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        Rectangle bounds = parent.getBounds();
        Insets insets = parent.getInsets();
        int width = bounds.width - insets.left - insets.right;
        int height = bounds.height - insets.top - insets.bottom;
        int myX = 0;
        int myY = 0;
        int myWidth = 0;
        int myHeight = 0;
        if (!this.valid) {
            GridBagConstraints constraints;
            this.calculateSizes(parent);
            int widthPerCell = width / this.totalCellWidth;
            int heightPerCell = height / this.totalCellHeight;
            int extraWidth = width - this.totalCellWidth * widthPerCell;
            int extraHeight = height - this.totalCellHeight * heightPerCell;
            int[] lastX = new int[this.totalCellHeight];
            int[] lastY = new int[this.totalCellWidth];
            Set keySet = this.constraintMap.keySet();
            for (Component component : keySet) {
                constraints = (GridBagConstraints)this.constraintMap.get(component);
                if (constraints.gridy >= 0) {
                    lastX[constraints.gridy] = Math.max(constraints.gridx, lastX[constraints.gridy]);
                }
                if (constraints.gridx < 0) continue;
                lastY[constraints.gridx] = Math.max(constraints.gridy, lastY[constraints.gridx]);
            }
            for (Component component : keySet) {
                constraints = (GridBagConstraints)this.constraintMap.get(component);
                myX = insets.left + constraints.gridx * widthPerCell;
                myY = insets.top + constraints.gridy * heightPerCell;
                myWidth = constraints.gridwidth * widthPerCell;
                myHeight = constraints.gridheight * heightPerCell;
                if (constraints.gridy >= 0) {
                    if (constraints.gridx == 0) {
                        myWidth += extraWidth / 2;
                    }
                    if (constraints.gridx == lastX[constraints.gridy]) {
                        myWidth += extraWidth - extraWidth / 2;
                    }
                    if (constraints.gridx != 0) {
                        myX += extraWidth / 2;
                    }
                }
                if (constraints.gridx >= 0) {
                    if (constraints.gridy == 0) {
                        myHeight += extraHeight / 2;
                    }
                    if (constraints.gridy == lastY[constraints.gridx]) {
                        myHeight += extraHeight - extraHeight / 2;
                    }
                    if (constraints.gridy != 0) {
                        myY += extraHeight / 2;
                    }
                }
                component.setBounds(myX, myY, myWidth, myHeight);
            }
        }
    }

    private void calculateSizes(Container parent) {
        Set keySet = this.constraintMap.keySet();
        for (Component component : keySet) {
            Dimension cps = component.getPreferredSize();
            GridBagConstraints constraints = (GridBagConstraints)this.constraintMap.get(component);
            this.widestCell = Math.max(this.widestCell, (double)cps.width);
            this.tallestCell = Math.max(this.tallestCell, (double)cps.height);
            this.totalCellWidth = Math.max(this.totalCellWidth, constraints.gridwidth + constraints.gridx);
            this.totalCellHeight = Math.max(this.totalCellHeight, constraints.gridheight + constraints.gridy);
        }
        this.valid = true;
    }
}

