/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.Message;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class ConstantVariableFactory
extends VariableFactory {
    public static final String RB_KEY = "ConstantVariableFactory.";

    public ConstantVariableFactory() {
        this(null, 10475);
    }

    public ConstantVariableFactory(Locale locale, int sortStrategy) {
        super(locale, sortStrategy);
    }

    @Override
    public boolean isOLAPData() {
        return false;
    }

    @Override
    public boolean isRelationalData() {
        return true;
    }

    @Override
    public Object getModel() {
        return null;
    }

    @Override
    public Variable newVariable(VariableDefinition varDef) throws IllegalStateException {
        Object value;
        if (varDef != null && ((value = varDef.getValue()) instanceof String || value instanceof Number)) {
            String label = varDef.getLabel();
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "value.txt");
            }
            return ConstantVariableFactory._newVariable(this.getLocale(), this.getSortStrategy(), varDef.getValue(), varDef.getFormat(), varDef.getInformat(), label, varDef.getVariant());
        }
        throw new IllegalStateException();
    }

    @Override
    public NumericVariable newHighVariable(VariableDefinition varDef) throws IllegalStateException {
        Object value;
        if (varDef != null && ((value = varDef.getHighValue()) instanceof String || value instanceof Number)) {
            Variable highVariable;
            String label = varDef.getLabel();
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "highValue.txt");
            }
            return (highVariable = ConstantVariableFactory._newVariable(this.getLocale(), this.getSortStrategy(), value, varDef.getFormat(), varDef.getInformat(), label, varDef.getVariant())) instanceof NumericVariable ? (NumericVariable)highVariable : null;
        }
        return null;
    }

    @Override
    public NumericVariable newLowVariable(VariableDefinition varDef) throws IllegalStateException {
        Object value;
        if (varDef != null && ((value = varDef.getLowValue()) instanceof String || value instanceof Number)) {
            Variable lowVariable;
            String label = varDef.getLabel();
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "lowValue.txt");
            }
            return (lowVariable = ConstantVariableFactory._newVariable(this.getLocale(), this.getSortStrategy(), value, varDef.getFormat(), varDef.getInformat(), label, varDef.getVariant())) instanceof NumericVariable ? (NumericVariable)lowVariable : null;
        }
        return null;
    }

    @Override
    public NumericVariable newTargetVariable(VariableDefinition varDef) throws IllegalStateException {
        Object value;
        if (varDef != null && ((value = varDef.getTargetValue()) instanceof String || value instanceof Number)) {
            Variable targetVariable;
            String label = varDef.getLabel();
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "targetValue.txt");
            }
            return (targetVariable = ConstantVariableFactory._newVariable(this.getLocale(), this.getSortStrategy(), value, varDef.getFormat(), varDef.getInformat(), label, varDef.getVariant())) instanceof NumericVariable ? (NumericVariable)targetVariable : null;
        }
        return null;
    }

    private static Variable _newVariable(Locale locale, int sortStrategy, Object dataValue, String formatName, String informatName, String label, int variant) throws IllegalStateException {
        boolean isNumericData;
        NumericVectorVariable v = null;
        Vector<Object> vec = new Vector<Object>(1);
        vec.add(dataValue);
        Class dataType = Util.resolveDataType(dataValue.getClass());
        boolean bl = isNumericData = dataType == Date.class || dataType == Time.class || dataType == Timestamp.class || dataType == Number.class;
        if (isNumericData || (variant & 1) != 0 || informatName != null && !"discrete".equals(informatName)) {
            NumericVectorVariable numericVariable = new NumericVectorVariable();
            ConstantVariableFactory.applySortStrategy((Variable)numericVariable, sortStrategy, locale);
            if (informatName != null) {
                try {
                    numericVariable.setInformat(informatName);
                }
                catch (IllegalArgumentException e) {
                    String message = Message.format((String)RB.getStringResource("inFormatNotSupported.fmt.txt"), (Object)informatName.trim());
                    throw new IllegalStateException(message);
                }
            }
            numericVariable.connectFrom(vec);
            v = numericVariable;
        } else {
            StringVectorVariable stringVariable = new StringVectorVariable();
            ConstantVariableFactory.applySortStrategy((Variable)stringVariable, sortStrategy, locale);
            stringVariable.connectFrom(vec);
            v = stringVariable;
        }
        if (v != null) {
            v.setLabel(label != null ? label : RB.getStringResource(RB_KEY, "value.txt"));
            GTKFormat appliedFormat = ConstantVariableFactory._applyFormat((Variable)v, formatName, locale);
            if (appliedFormat == null) {
                String defaultFormat = null;
                if (dataType == Number.class) {
                    defaultFormat = "Best";
                } else if (dataType == Date.class) {
                    defaultFormat = "Date9";
                } else if (dataType == Time.class || dataType == Timestamp.class) {
                    defaultFormat = "DateTime18";
                }
                if (defaultFormat != null && (appliedFormat = ConstantVariableFactory._applyFormat((Variable)v, defaultFormat, locale)) != null && formatName != null && formatName.trim().length() > 0) {
                    String message = Message.format((String)RB.getStringResource(RB_KEY, "formatNotSupportedRevertToDefaultFormat.fmt.txt"), (Object)formatName.trim(), (Object)defaultFormat.trim());
                    System.err.println(message);
                }
            }
        }
        return v;
    }

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="this is legacy code and require major restructuring for this violation")
    public Object clone() {
        return new ConstantVariableFactory(this.getLocale(), this.getSortStrategy());
    }
}

