/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TimeLength;
import com.sas.graphics.components.TimePeriodModel;
import com.sas.graphics.util.DateTimeTickSpacer;
import com.sas.graphics.util.TickSpacingPreference;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.cell.SimpleModel;
import com.sas.graphics.util.cell.SimplePropertyBag;
import com.sas.graphics.util.cell.SimplePropertyBagInterface;
import com.sas.graphics.util.cell.TimeAxisCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Point2D;

public class CompoundTimeAxisCellModel
extends TimeAxisCellModel {
    private static final double[] doubleArray = new double[]{0.0, 1.0};
    public static final String RB_KEY = "CompoundTimeAxisCellModel.";
    public static final Object VALUES_1 = "values1";
    public static final Object VALUES_1_ARRAY = "values1Array";
    public static final Object VALUE_1_LABELS = "value1Labels";
    public static final Object SIZE_1 = "size1";
    public static final Object PREFERRED_SIZE_1 = "preferredSize1";
    public static final Object VALUE_1_COUNT = "value1Count";
    public static final Object TEXT_1_SCALE = "text1Scale";
    public static final Object VALUES_2 = "values2";
    public static final Object VALUES_2_ARRAY = "values2Array";
    public static final Object VALUE_2_LABELS = "value2Labels";
    public static final Object SIZE_2 = "size2";
    public static final Object PREFERRED_SIZE_2 = "preferredSize2";
    public static final Object VALUE_2_COUNT = "value2Count";
    public static final Object TEXT_2_SCALE = "text2Scale";
    public static final Object VALUES_3 = "values3";
    public static final Object VALUES_3_ARRAY = "values3Array";
    public static final Object VALUE_3_LABELS = "value3Labels";
    public static final Object SIZE_3 = "size3";
    public static final Object PREFERRED_SIZE_3 = "preferredSize3";
    public static final Object VALUE_3_COUNT = "value3Count";
    public static final Object TEXT_3_SCALE = "text3Scale";
    public static final Object BACKGROUND_COLOR = "backgroundColor";
    public static final Object TIME_AXIS_MODEL = "timeAxisModel";
    double viewFactor = 1.0;

    public void setTimeAxisModel(CompoundTimeAxisModel v) {
        this.properties.set(TIME_AXIS_MODEL, v);
    }

    public CompoundTimeAxisModel getTimeAxisModel() {
        return (CompoundTimeAxisModel)SimplePropertyBag.Util.getObject(this.properties, TIME_AXIS_MODEL, this.propertyDefaults, CompoundTimeAxisModel.class);
    }

    public void setValues1(NumericPipe values) {
        this.properties.set(VALUES_1, values);
    }

    public NumericPipe getValues1() {
        return (NumericPipe)SimplePropertyBag.Util.getObject(this.properties, VALUES_1, this.propertyDefaults, NumericPipe.class);
    }

    public void setValues1Array(double[] values) {
        this.properties.set(VALUES_1_ARRAY, values);
    }

    public double[] getValues1Array() {
        return (double[])SimplePropertyBag.Util.getObject(this.properties, VALUES_1_ARRAY, this.propertyDefaults, doubleArray.getClass());
    }

    public void setValue1Labels(StringPipe values) {
        this.properties.set(VALUE_1_LABELS, values);
    }

    public StringPipe getValue1Labels() {
        return (StringPipe)SimplePropertyBag.Util.getObject(this.properties, VALUE_1_LABELS, this.propertyDefaults, StringPipe.class);
    }

    private void setSize1(Dimension v) {
        this.properties.set(SIZE_1, v);
    }

    public Dimension getSize1() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, SIZE_1, this.propertyDefaults, Dimension.class);
    }

    private void setPreferredSize1(Dimension v) {
        this.properties.set(PREFERRED_SIZE_1, v);
    }

    public Dimension getPreferredSize1() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, PREFERRED_SIZE_1, this.propertyDefaults, Dimension.class);
    }

    public void setValue1Count(Integer v) {
        this.properties.set(VALUE_1_COUNT, v);
    }

    public Integer getValue1Count() {
        return SimplePropertyBag.Util.getInteger(this.properties, VALUE_1_COUNT, this.propertyDefaults);
    }

    public void setText1Scale(Double v) {
        this.properties.set(TEXT_1_SCALE, v);
    }

    public Double getText1Scale() {
        return SimplePropertyBag.Util.getDouble(this.properties, TEXT_1_SCALE, this.propertyDefaults);
    }

    public void setValues2(NumericPipe values) {
        this.properties.set(VALUES_2, values);
    }

    public NumericPipe getValues2() {
        return (NumericPipe)SimplePropertyBag.Util.getObject(this.properties, VALUES_2, this.propertyDefaults, NumericPipe.class);
    }

    public void setValues2Array(double[] values) {
        this.properties.set(VALUES_2_ARRAY, values);
    }

    public double[] getValues2Array() {
        return (double[])SimplePropertyBag.Util.getObject(this.properties, VALUES_2_ARRAY, this.propertyDefaults, doubleArray.getClass());
    }

    public void setValue2Labels(StringPipe values) {
        this.properties.set(VALUE_2_LABELS, values);
    }

    public StringPipe getValue2Labels() {
        return (StringPipe)SimplePropertyBag.Util.getObject(this.properties, VALUE_2_LABELS, this.propertyDefaults, StringPipe.class);
    }

    private void setSize2(Dimension v) {
        this.properties.set(SIZE_2, v);
    }

    public Dimension getSize2() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, SIZE_2, this.propertyDefaults, Dimension.class);
    }

    private void setPreferredSize2(Dimension v) {
        this.properties.set(PREFERRED_SIZE_2, v);
    }

    public Dimension getPreferredSize2() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, PREFERRED_SIZE_2, this.propertyDefaults, Dimension.class);
    }

    public void setValue2Count(Integer v) {
        this.properties.set(VALUE_2_COUNT, v);
    }

    public Integer getValue2Count() {
        return SimplePropertyBag.Util.getInteger(this.properties, VALUE_2_COUNT, this.propertyDefaults);
    }

    public void setText2Scale(Double v) {
        this.properties.set(TEXT_2_SCALE, v);
    }

    public Double getText2Scale() {
        return SimplePropertyBag.Util.getDouble(this.properties, TEXT_2_SCALE, this.propertyDefaults);
    }

    public void setValues3(NumericPipe values) {
        this.properties.set(VALUES_3, values);
    }

    public NumericPipe getValues3() {
        return (NumericPipe)SimplePropertyBag.Util.getObject(this.properties, VALUES_3, this.propertyDefaults, NumericPipe.class);
    }

    public void setValues3Array(double[] values) {
        this.properties.set(VALUES_3_ARRAY, values);
    }

    public double[] getValues3Array() {
        return (double[])SimplePropertyBag.Util.getObject(this.properties, VALUES_3_ARRAY, this.propertyDefaults, doubleArray.getClass());
    }

    public void setValue3Labels(StringPipe values) {
        this.properties.set(VALUE_3_LABELS, values);
    }

    public StringPipe getValue3Labels() {
        return (StringPipe)SimplePropertyBag.Util.getObject(this.properties, VALUE_3_LABELS, this.propertyDefaults, StringPipe.class);
    }

    private void setSize3(Dimension v) {
        this.properties.set(SIZE_3, v);
    }

    public Dimension getSize3() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, SIZE_3, this.propertyDefaults, Dimension.class);
    }

    private void setPreferredSize3(Dimension v) {
        this.properties.set(PREFERRED_SIZE_3, v);
    }

    public Dimension getPreferredSize3() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, PREFERRED_SIZE_3, this.propertyDefaults, Dimension.class);
    }

    public void setValue3Count(Integer v) {
        this.properties.set(VALUE_3_COUNT, v);
    }

    public Integer getValue3Count() {
        return SimplePropertyBag.Util.getInteger(this.properties, VALUE_3_COUNT, this.propertyDefaults);
    }

    public void setText3Scale(Double v) {
        this.properties.set(TEXT_3_SCALE, v);
    }

    public Double getText3Scale() {
        return SimplePropertyBag.Util.getDouble(this.properties, TEXT_3_SCALE, this.propertyDefaults);
    }

    public void setBackgroundColor(Color color) {
        this.properties.set(BACKGROUND_COLOR, color);
    }

    public Color getBackgroundColor() {
        return SimplePropertyBag.Util.getColor(this.properties, BACKGROUND_COLOR, this.propertyDefaults);
    }

    public CompoundTimeAxisCellModel() {
    }

    public CompoundTimeAxisCellModel(SimplePropertyBagInterface delegate, SimpleModel ancestor) {
        super(delegate, ancestor);
    }

    public double getViewFactor() {
        return this.viewFactor;
    }

    private AxisModel createAxisModel(CompoundTimeAxisModel timeModel) {
        AxisModel axisModel = new AxisModel();
        TimePeriodModel period = timeModel.getTimePeriodModel1();
        axisModel.setValueTextStyle(period.getTextStyle());
        axisModel.getAxisLineStyle().apply(timeModel.getValueCellStyle().getFrameLineStyle());
        axisModel.setMinimum(axisModel.getMinimum());
        axisModel.setMaximum(axisModel.getMaximum());
        axisModel.setGridInFront(timeModel.isGridInFront());
        axisModel.setGridLineStyle(timeModel.getGridLineStyle());
        axisModel.setReferenceLineModels(timeModel.getReferenceLineModels());
        axisModel.setVisible(timeModel.isVisible());
        return axisModel;
    }

    @Override
    public void computeParameters(Channel channel) {
        int ii;
        double userMax;
        int ii2;
        double[] userValues3;
        CompoundTimeAxisModel axisModel = this.getTimeAxisModel();
        NumericMapper mapper = this.getMapper();
        if (mapper == null) {
            return;
        }
        if (!(mapper instanceof ContinuousRangeToNumericMapper)) {
            AxisModel model = this.createAxisModel(axisModel);
            this.setAxisModel(model);
            this.setTitleOn(Boolean.FALSE);
            super.computeParameters(channel);
            return;
        }
        TimePeriodModel period1 = axisModel.getTimePeriodModel1();
        TimePeriodModel period2 = axisModel.getTimePeriodModel2();
        TimePeriodModel period3 = axisModel.getTimePeriodModel3();
        boolean secondaryVisible = period2.isVisible();
        boolean tertiaryVisible = period3.isVisible();
        ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)mapper;
        this.min = cm.getInputMin();
        this.max = cm.getInputMax();
        double[] values = null;
        double[] values2 = null;
        double[] values3 = null;
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        double[] userValues = period1.getTimeLength() == null ? null : period1.getTimeLength().getValues();
        double[] userValues2 = period2.getTimeLength() == null ? null : period2.getTimeLength().getValues();
        double[] dArray = userValues3 = period3.getTimeLength() == null ? null : period3.getTimeLength().getValues();
        if (userValues != null) {
            maxValue = Math.max(maxValue, userValues[userValues.length - 1]);
            minValue = Math.min(minValue, userValues[0]);
        }
        if (userValues2 != null) {
            maxValue = Math.max(maxValue, userValues2[userValues2.length - 1]);
            minValue = Math.min(minValue, userValues2[0]);
        }
        if (userValues3 != null) {
            maxValue = Math.max(maxValue, userValues3[userValues3.length - 1]);
            minValue = Math.min(minValue, userValues2[0]);
        }
        if (userValues != null && maxValue > userValues[userValues.length - 1]) {
            values = new double[userValues.length + 1];
            for (ii2 = 0; ii2 < userValues.length; ++ii2) {
                values[ii2] = userValues[ii2];
            }
            values[userValues.length] = maxValue;
        } else {
            values = userValues;
        }
        if (userValues2 != null && maxValue > userValues2[userValues2.length - 1]) {
            values2 = new double[userValues2.length + 1];
            for (ii2 = 0; ii2 < userValues2.length; ++ii2) {
                values2[ii2] = userValues2[ii2];
            }
            values2[userValues2.length] = maxValue;
        } else {
            values2 = userValues2;
        }
        if (userValues3 != null && maxValue > userValues3[userValues3.length - 1]) {
            values3 = new double[userValues3.length + 1];
            for (ii2 = 0; ii2 < userValues3.length; ++ii2) {
                values3[ii2] = userValues3[ii2];
            }
            values3[userValues3.length] = maxValue;
        } else {
            values3 = userValues3;
        }
        this.adjustedMin = Math.min(this.min, minValue);
        this.adjustedMax = Math.max(this.max, maxValue);
        String format1 = period1.getFormat();
        GTKFormat gtkFormat1 = null;
        gtkFormat1 = format1 != null ? this.newGTKFormat(format1) : cm.getFormat();
        SASFormat sasFormat = null;
        if (gtkFormat1 != null && gtkFormat1.getFormats()[0] instanceof SASDateTimeFormat) {
            sasFormat = (SASFormat)gtkFormat1.getFormats()[0];
        } else if (cm.getFormat() != null && cm.getFormat().getFormats()[0] instanceof SASDateTimeFormat) {
            sasFormat = (SASFormat)cm.getFormat().getFormats()[0];
        } else {
            AxisModel model = this.createAxisModel(axisModel);
            this.setAxisModel(model);
            this.setTitleOn(Boolean.FALSE);
            super.computeParameters(channel);
            return;
        }
        this.day = this._isDateFormat(sasFormat);
        if (this.day) {
            this.week = this._isWeekFormat(sasFormat);
        }
        boolean datetimeData = !this.day && (this.max > 86400.0 || this.min < 0.0);
        int count1 = 0;
        double interval = 0.0;
        this.tickSpacer = new DateTimeTickSpacer();
        this.tickSpacer.getTickSpacingInfo().setFormat(sasFormat);
        this.tickSpacer.setDataMin(this.min);
        this.tickSpacer.setDataMax(this.max);
        this.tickSpacer.getTickSpacingInfo().setMaxTicks(Integer.MAX_VALUE);
        DataInfo dataInfo = this._determineMinMax(period1, period2, period3, gtkFormat1, sasFormat);
        this.tickSpacer.setDataMin(dataInfo.adjustedMin);
        this.tickSpacer.setDataMax(dataInfo.adjustedMax);
        this.tickSpacer.setUserMax(this.tickSpacer.getDataMin());
        this.tickSpacer.setUserMax(this.tickSpacer.getDataMax());
        TickSpacingPreference tsPref = null;
        double userMin = axisModel.getMinimum();
        if (!Double.isNaN(userMin)) {
            this.tickSpacer.setUserMin(userMin);
            tsPref = new TickSpacingPreference();
            tsPref.setMinCalc(1);
        }
        if (!Double.isNaN(userMax = axisModel.getMaximum())) {
            this.tickSpacer.setUserMax(userMax);
            if (tsPref == null) {
                tsPref = new TickSpacingPreference();
            }
            tsPref.setMaxCalc(1);
        }
        if (tsPref != null) {
            this.tickSpacer.setPreference(tsPref);
        }
        if (values != null && values.length > 0) {
            count1 = values.length - 1;
        } else {
            int labelCount = 0;
            interval = this._setInterval(period1.getTimeLength(), 6, false);
            if (this.max - this.min < interval) {
                this.tickSpacer.getTickSpacingInfo().setMaxTicks(6);
                this.tickSpacer.getPreference().setAutoInterval(true);
                this.tickSpacer.doTickSpacing();
                this.adjustedMin = this.tickSpacer.getTickMin();
                this.adjustedMax = this.tickSpacer.getTickMax();
                labelCount = Math.max(2, (int)Math.ceil((this.adjustedMax - this.adjustedMin) / interval));
                values = new double[labelCount];
                for (int ii3 = 0; ii3 < labelCount; ++ii3) {
                    values[ii3] = this.adjustedMin + (double)ii3 * interval;
                }
            } else {
                this.tickSpacer.doTickSpacing();
                labelCount = this.tickSpacer.getNumTicks();
                this.adjustedMin = this.tickSpacer.getTickMin();
                this.adjustedMax = this.tickSpacer.getTickMax();
                values = this.tickSpacer.getTickValues();
            }
            count1 = labelCount - 1;
        }
        cm.setInputMin(this.adjustedMin);
        cm.setInputMax(this.adjustedMax);
        double offset = this.adjustedMin - values[0];
        double totalSize = 0.0;
        StringVector labels1 = new StringVector();
        if (datetimeData && this._isTimeFormat(sasFormat)) {
            for (ii = 0; ii < count1; ++ii) {
                labels1.addValue(gtkFormat1.format((Object)CompoundTimeAxisCellModel.tod(values[ii])));
            }
        } else {
            if (this.day && this.week != null) {
                values[0] = values[0] + offset;
            }
            for (ii = 0; ii < count1; ++ii) {
                if (this.day && this.week != null && (this.week.equalsIgnoreCase("WEEKV") || this.week.equalsIgnoreCase("WEEKW")) && (ii != 0 || ii == 0 && offset == 0.0)) {
                    int n = ii;
                    values[n] = values[n] + 1.0;
                }
                if (gtkFormat1 != null) {
                    labels1.addValue(gtkFormat1.format((Object)new Double(values[ii])));
                    continue;
                }
                labels1.addValue(new Double(values[ii]).toString());
            }
        }
        TextStyle tsv = period1.getTextStyle();
        Point2D primary2D = RasterLabel.getMaxWidthAndHeight((Channel)channel, (Font)tsv.getFont(), (StringPipe)labels1);
        Dimension size1 = new Dimension((int)primary2D.getX() + 4, (int)primary2D.getY() + 4);
        if (period1.isVisible()) {
            totalSize = size1.height;
        }
        this.setValue1Count(new Integer(count1));
        this.setValue1Labels((StringPipe)labels1);
        this.setPreferredSize1(size1);
        this.setValues1Array(values);
        this.setSize1(new Dimension());
        this.setText1Scale(new Double(1.0));
        Dimension size2 = null;
        int count2 = 0;
        if (secondaryVisible) {
            int ii4;
            String format2 = period2.getFormat();
            GTKFormat gtkFormat2 = format2 == null ? gtkFormat1 : this.newGTKFormat(format2);
            SASFormat secondarySASFormat = gtkFormat2 != null && gtkFormat2.getFormats()[0] instanceof SASDateTimeFormat ? (SASFormat)gtkFormat2.getFormats()[0] : sasFormat;
            this.day = this._isDateFormat(secondarySASFormat);
            if (this.day) {
                this.week = this._isWeekFormat(secondarySASFormat);
            }
            if (values2 != null && values2.length > 0) {
                count2 = values2.length - 1;
            } else {
                interval = this._setInterval(period2.getTimeLength(), Math.max(10, 10 * count1), true);
                if (this.adjustedMax - this.adjustedMin < interval) {
                    values2 = new double[]{this.adjustedMin, this.adjustedMax};
                    count2 = 1;
                    if (format2 == null) {
                        gtkFormat2 = cm.getFormat();
                    }
                } else {
                    this.tickSpacer.getTickSpacingInfo().setFormat(secondarySASFormat);
                    this.tickSpacer.setDataMax(this.adjustedMax);
                    this.tickSpacer.setDataMin(this.adjustedMin);
                    this.tickSpacer.doTickSpacing();
                    values2 = this.tickSpacer.getTickValues();
                    count2 = values2.length - 1;
                    if (format2 == null) {
                        gtkFormat2 = this.newGTKFormat(this.tickSpacer.getFormatName(true));
                    }
                }
            }
            offset = this.adjustedMin - values2[0];
            StringVector labels2 = new StringVector();
            if (datetimeData && this._isTimeFormat(secondarySASFormat)) {
                for (ii4 = 0; ii4 < count2; ++ii4) {
                    int n = ii4;
                    values2[n] = values2[n] + offset;
                    labels2.addValue(gtkFormat2.format((Object)CompoundTimeAxisCellModel.tod(values2[ii4])));
                }
            } else {
                if (this.day && this.week != null) {
                    values2[0] = values2[0] + offset;
                }
                for (ii4 = 0; ii4 < count2; ++ii4) {
                    if (this.day && this.week != null) {
                        if ((this.week.equalsIgnoreCase("WEEKV") || this.week.equalsIgnoreCase("WEEKW")) && (ii4 != 0 || ii4 == 0 && offset == 0.0)) {
                            int n = ii4;
                            values2[n] = values2[n] + 1.0;
                        }
                    } else {
                        int n = ii4;
                        values2[n] = values2[n] + offset;
                    }
                    if (gtkFormat2 != null) {
                        labels2.addValue(gtkFormat2.format((Object)new Double(values2[ii4])));
                        continue;
                    }
                    labels2.addValue(new Double(values2[ii4]).toString());
                }
            }
            tsv = period2.getTextStyle();
            Point2D ss = RasterLabel.getMaxWidthAndHeight((Channel)channel, (Font)tsv.getFont(), (StringPipe)labels2);
            size2 = new Dimension((int)ss.getX() + 4, (int)ss.getY() + 4);
            totalSize += (double)size2.height;
            this.setValue2Labels((StringPipe)labels2);
            this.setPreferredSize2(size2);
            this.setSize2(new Dimension());
            this.setText2Scale(new Double(1.0));
            this.setValues2Array(values2);
        }
        this.setValue2Count(new Integer(count2));
        int count3 = 0;
        Dimension size3 = null;
        if (tertiaryVisible) {
            int ii5;
            String format3 = period3.getFormat();
            GTKFormat gtkFormat3 = format3 == null ? gtkFormat1 : this.newGTKFormat(format3);
            SASFormat tertiarySASFormat = gtkFormat3 != null && gtkFormat3.getFormats()[0] instanceof SASDateTimeFormat ? (SASFormat)gtkFormat3.getFormats()[0] : sasFormat;
            this.day = this._isDateFormat(tertiarySASFormat);
            if (this.day) {
                this.week = this._isWeekFormat(tertiarySASFormat);
            }
            if (values3 != null && values3.length > 0) {
                count3 = values3.length - 1;
            } else {
                interval = this._setInterval(period3.getTimeLength(), Math.max(100, 10 * Math.max(count1, count2)), true);
                if (this.adjustedMax - this.adjustedMin < interval) {
                    values3 = new double[]{this.adjustedMin, this.adjustedMax};
                    count3 = 1;
                    if (format3 == null) {
                        gtkFormat3 = cm.getFormat();
                    }
                } else {
                    this.tickSpacer.getTickSpacingInfo().setFormat(tertiarySASFormat);
                    this.tickSpacer.setDataMax(this.adjustedMax);
                    this.tickSpacer.setDataMin(this.adjustedMin);
                    this.tickSpacer.doTickSpacing();
                    values3 = this.tickSpacer.getTickValues();
                    count3 = values3.length - 1;
                    if (format3 == null) {
                        gtkFormat3 = this.newGTKFormat(this.tickSpacer.getFormatName(false));
                    }
                }
            }
            offset = this.adjustedMin - values3[0];
            StringVector labels3 = new StringVector();
            if (datetimeData && this._isTimeFormat(tertiarySASFormat)) {
                for (ii5 = 0; ii5 < count3; ++ii5) {
                    int n = ii5;
                    values3[n] = values3[n] + offset;
                    labels3.addValue(gtkFormat3.format((Object)CompoundTimeAxisCellModel.tod(values3[ii5])));
                }
            } else {
                if (this.day && this.week != null) {
                    values3[0] = values3[0] + offset;
                }
                for (ii5 = 0; ii5 < count3; ++ii5) {
                    if (this.day && this.week != null) {
                        if ((this.week.equalsIgnoreCase("WEEKV") || this.week.equalsIgnoreCase("WEEKW")) && (ii5 != 0 || ii5 == 0 && offset == 0.0)) {
                            int n = ii5;
                            values3[n] = values3[n] + 1.0;
                        }
                    } else {
                        int n = ii5;
                        values3[n] = values3[n] + offset;
                    }
                    if (gtkFormat3 != null) {
                        labels3.addValue(gtkFormat3.format((Object)new Double(values3[ii5])));
                        continue;
                    }
                    labels3.addValue(new Double(values3[ii5]).toString());
                }
            }
            tsv = period3.getTextStyle();
            Point2D ss = RasterLabel.getMaxWidthAndHeight((Channel)channel, (Font)tsv.getFont(), (StringPipe)labels3);
            size3 = new Dimension((int)ss.getX() + 4, (int)ss.getY() + 4);
            totalSize += (double)size3.height;
            this.setValue3Labels((StringPipe)labels3);
            this.setPreferredSize3(size3);
            this.setSize3(new Dimension());
            this.setText3Scale(new Double(1.0));
            this.setValues3Array(values3);
        }
        this.setValue3Count(new Integer(count3));
        Dimension depth = this.getDepth();
        if (depth == null) {
            depth = new Dimension(0, 0);
            this.setDepth(depth);
        }
        String orient = this.getAxisOrientation();
        double minLength = 0.0;
        double length = 0.0;
        if (orient == "East" || orient == "West") {
            TimeLength tl;
            int viewUnits;
            minLength = count1 * size1.width;
            if (size2 != null) {
                minLength = Math.max(minLength, (double)(count2 * size2.width));
            }
            if (size3 != null) {
                minLength = Math.max(minLength, (double)(count3 * size3.width));
            }
            int n = viewUnits = (tl = axisModel.getPreferredVisibleTimeLength()) == null ? -1 : tl.getUnit();
            if (tl == null || viewUnits == 10820 || viewUnits == 10895) {
                this.viewFactor = 1.0;
            } else {
                interval = this._determineInterval(tl);
                if (interval > this.adjustedMax - this.adjustedMin) {
                    this.viewFactor = 1.0;
                } else {
                    ZxAxis.Interval intvl = this.computeInterval(viewUnits);
                    intvl.intper = (short)tl.getMagnitude();
                    this.tickSpacer.getTickSpacingInfo().setInterval(intvl);
                    this.tickSpacer.getPreference().setAutoInterval(false);
                    this.tickSpacer.getTickSpacingInfo().setFormat(sasFormat);
                    this.tickSpacer.doTickSpacing();
                    double[] beginValues = this.tickSpacer.getTickValues();
                    length = beginValues[1] - beginValues[0];
                    this.viewFactor = Math.max(1.0, (this.adjustedMax - this.adjustedMin) / length);
                }
            }
            length = minLength / this.viewFactor;
            cm.setOutputMax(cm.getOutputMin() + minLength);
            NumericVector valuesVector = new NumericVector();
            for (int ii6 = 0; ii6 < count1; ++ii6) {
                double aValue = cm.getValue(values[ii6]);
                valuesVector.addValue(aValue);
            }
            this.setValues1((NumericPipe)valuesVector);
            NumericVector values2Vector = new NumericVector();
            for (int ii7 = 0; ii7 < count2; ++ii7) {
                double aValue = cm.getValue(values2[ii7]);
                values2Vector.addValue(aValue);
            }
            this.setValues2((NumericPipe)values2Vector);
            NumericVector values3Vector = new NumericVector();
            for (int ii8 = 0; ii8 < count3; ++ii8) {
                double aValue = cm.getValue(values3[ii8]);
                values3Vector.addValue(aValue);
            }
            this.setValues3((NumericPipe)values3Vector);
            this.setPreferredLength(new Double(minLength));
            this.setIdealPreferredLength(new Double(minLength));
            this.setLength(new Double(length));
            this.setCatAxisAdj(new Double(totalSize));
            this.setResAxisAdj(new Double(0.0));
        }
    }

    @Override
    public void computeParameters(Channel channel, double newLength) {
        boolean horzAxis;
        String axisOrientation = this.getAxisOrientation();
        boolean bl = horzAxis = axisOrientation == "East" || axisOrientation == "West";
        if (horzAxis) {
            this.computeParameters(channel, newLength, Double.POSITIVE_INFINITY);
        } else {
            this.computeParameters(channel, Double.POSITIVE_INFINITY, newLength);
        }
    }

    @Override
    public void computeParameters(Channel channel, double width, double height) {
        if (width == 0.0 || height == 0.0) {
            return;
        }
        NumericMapper mapper = this.getMapper();
        if (mapper == null) {
            return;
        }
        if (!(mapper instanceof ContinuousRangeToNumericMapper)) {
            super.computeParameters(channel, width, height);
            return;
        }
        ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)mapper;
        GTKFormat format = cm.getFormat();
        if (format == null || !(format.getFormats()[0] instanceof SASDateTimeFormat)) {
            super.computeParameters(channel, width, height);
            return;
        }
        String orient = this.getAxisOrientation();
        Dimension margin = this.getMargin();
        CompoundTimeAxisModel axisModel = this.getTimeAxisModel();
        if (orient == "East" || orient == "West") {
            double length = width - (double)(2 * margin.width);
            cm.setOutputMax(cm.getOutputMin() + length);
            this.setLength(new Double(length));
            this._setSizesAndScales(axisModel, cm);
        }
    }

    public void setVisibleLength(int length) {
        if (length == 0) {
            return;
        }
        CompoundTimeAxisModel axisModel = this.getTimeAxisModel();
        NumericMapper mapper = this.getMapper();
        if (mapper == null || !(mapper instanceof ContinuousRangeToNumericMapper)) {
            return;
        }
        double minLength = this.getIdealPreferredLength();
        String orient = this.getAxisOrientation();
        ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)mapper;
        GTKFormat format = cm.getFormat();
        SASFormat sasFormat = null;
        if (format != null && format.getFormats()[0] instanceof SASDateTimeFormat) {
            sasFormat = (SASFormat)format.getFormats()[0];
        }
        if (orient == "East" || orient == "West") {
            TimeLength tl = axisModel.getPreferredVisibleTimeLength();
            int viewUnits = tl == null ? -1 : tl.getUnit();
            double newPrefLength = length;
            if (viewUnits == 10820 || viewUnits == 10895) {
                this.viewFactor = 1.0;
            } else if (tl == null) {
                double zoomFactor = axisModel.getZoomFactor();
                newPrefLength = zoomFactor > 2.0 ? Math.max((double)length, minLength + minLength * ((zoomFactor - 2.0) / 2.0)) : ((double)length > minLength ? (double)length : (double)length + zoomFactor * (minLength - (double)length) / 2.0);
                this.viewFactor = 1.0;
            } else {
                double interval = this._determineInterval(tl);
                if (interval < this.adjustedMax - this.adjustedMin) {
                    ZxAxis.Interval intvl = this.computeInterval(viewUnits);
                    intvl.intper = (short)tl.getMagnitude();
                    this.tickSpacer.getPreference().setAutoInterval(false);
                    this.tickSpacer.getTickSpacingInfo().setInterval(intvl);
                    this.tickSpacer.getTickSpacingInfo().setFormat(sasFormat);
                    this.tickSpacer.doTickSpacing();
                    double[] beginValues = this.tickSpacer.getTickValues();
                    double len = beginValues[1] - beginValues[0];
                    this.viewFactor = Math.max(1.0, (cm.getInputMax() - cm.getInputMin()) / len);
                    newPrefLength *= this.viewFactor;
                } else {
                    this.viewFactor = minLength / newPrefLength;
                }
            }
            cm.setOutputMax(cm.getOutputMin() + newPrefLength);
            this.setPreferredLength(new Double(newPrefLength));
            this.setLength(new Double(length));
            this._setSizesAndScales(axisModel, cm);
        }
    }

    private boolean _isDateFormat(SASFormat fmt) {
        return fmt != null && fmt.isDateFormat();
    }

    private String _isWeekFormat(SASFormat fmt) {
        String week = null;
        if (fmt != null && (fmt.getBaseFormatName().equalsIgnoreCase("WEEKU") || fmt.getBaseFormatName().equalsIgnoreCase("WEEKV") || fmt.getBaseFormatName().equalsIgnoreCase("WEEKW"))) {
            week = fmt.getBaseFormatName();
        }
        return week;
    }

    private boolean _isTimeFormat(SASFormat fmt) {
        return fmt != null && fmt.isTimeFormat();
    }

    private double _setInterval(TimeLength timelen, int maxTicks, boolean secondOrThird) {
        double interval = 0.0;
        if (timelen == null || timelen.getUnit() == 10820 || timelen.getUnit() == 10895) {
            this.tickSpacer.getPreference().setAutoInterval(true);
            this.tickSpacer.getTickSpacingInfo().setMaxTicks(maxTicks);
            if (this.tickSpacer.getInterval() != null && secondOrThird) {
                this.tickSpacer.getTickSpacingInfo().setInterval(this._getInnerInterval(this.tickSpacer.getInterval()));
            }
        } else {
            this.tickSpacer.getPreference().setAutoInterval(false);
            ZxAxis.Interval intvl = this.computeInterval(timelen.getUnit());
            intvl.intper = (short)timelen.getMagnitude();
            this.tickSpacer.getTickSpacingInfo().setInterval(intvl);
            if (secondOrThird) {
                this.tickSpacer.getTickSpacingInfo().setMaxTicks(Integer.MAX_VALUE);
            }
            interval = this._determineInterval(timelen);
        }
        return interval;
    }

    private double _determineInterval(TimeLength timelen) {
        double interval = 0.0;
        interval = this.isDateValue() ? CompoundTimeAxisCellModel._convertToDays(timelen) : CompoundTimeAxisCellModel._convertToSeconds(timelen);
        return interval;
    }

    private DataInfo _determineMinMax(TimePeriodModel p1, TimePeriodModel p2, TimePeriodModel p3, GTKFormat gtkFmt1, SASFormat sasFmt) {
        int labelCount;
        DataInfo ti = new DataInfo();
        double interval = this._setInterval(p1.getTimeLength(), 6, false);
        if (this.max - this.min < interval) {
            this.tickSpacer.getTickSpacingInfo().setMaxTicks(6);
            this.tickSpacer.getPreference().setAutoInterval(true);
            this.tickSpacer.doTickSpacing();
            ti.adjustedMin = Math.min(ti.adjustedMin, this.tickSpacer.getTickMin());
            ti.adjustedMax = Math.max(ti.adjustedMax, this.tickSpacer.getTickMax());
            labelCount = Math.max(2, (int)Math.ceil((ti.adjustedMax - ti.adjustedMin) / interval));
        } else {
            this.tickSpacer.doTickSpacing();
            labelCount = this.tickSpacer.getNumTicks();
            ti.adjustedMin = Math.min(ti.adjustedMin, this.tickSpacer.getTickMin());
            ti.adjustedMax = Math.max(ti.adjustedMax, this.tickSpacer.getTickMax());
        }
        int count1 = labelCount - 1;
        double[] values2 = null;
        int count2 = 0;
        if (p2.isVisible()) {
            String format2 = p2.getFormat();
            GTKFormat gtkFormat2 = format2 == null ? gtkFmt1 : this.newGTKFormat(format2);
            SASFormat secondarySASFormat = gtkFormat2 != null && gtkFormat2.getFormats()[0] instanceof SASDateTimeFormat ? (SASFormat)gtkFormat2.getFormats()[0] : sasFmt;
            this.day = this._isDateFormat(secondarySASFormat);
            interval = this._setInterval(p2.getTimeLength(), Math.max(10, 10 * count1), true);
            if (this.max - this.min >= interval) {
                this.tickSpacer.getTickSpacingInfo().setFormat(secondarySASFormat);
                this.tickSpacer.setDataMax(this.max);
                this.tickSpacer.setDataMin(this.min);
                this.tickSpacer.doTickSpacing();
                ti.adjustedMin = Math.min(ti.adjustedMin, this.tickSpacer.getTickMin());
                ti.adjustedMax = Math.max(ti.adjustedMax, this.tickSpacer.getTickMax());
                values2 = this.tickSpacer.getTickValues();
                count2 = values2.length - 1;
            }
        }
        if (p3.isVisible()) {
            String format3 = p3.getFormat();
            GTKFormat gtkFormat3 = format3 == null ? gtkFmt1 : this.newGTKFormat(format3);
            SASFormat tertiarySASFormat = gtkFormat3 != null && gtkFormat3.getFormats()[0] instanceof SASDateTimeFormat ? (SASFormat)gtkFormat3.getFormats()[0] : sasFmt;
            this.day = this._isDateFormat(tertiarySASFormat);
            interval = this._setInterval(p3.getTimeLength(), Math.max(100, 10 * Math.max(count1, count2)), true);
            if (this.max - this.min >= interval) {
                this.tickSpacer.getTickSpacingInfo().setFormat(tertiarySASFormat);
                this.tickSpacer.setDataMax(this.max);
                this.tickSpacer.setDataMin(this.min);
                this.tickSpacer.doTickSpacing();
                ti.adjustedMin = Math.min(ti.adjustedMin, this.tickSpacer.getTickMin());
                ti.adjustedMax = Math.max(ti.adjustedMax, this.tickSpacer.getTickMax());
            }
        }
        return ti;
    }

    private void _setSizesAndScales(CompoundTimeAxisModel axisModel, ContinuousRangeToNumericMapper cm) {
        TimePeriodModel tpm = axisModel.getTimePeriodModel1();
        double firstValue = 0.0;
        double secondValue = 0.0;
        if (tpm.isVisible()) {
            NumericVector valuesVector = (NumericVector)this.getValues1();
            double[] valuesArray = this.getValues1Array();
            if (valuesArray != null && valuesArray.length > 0) {
                int count1 = valuesArray.length - 1;
                for (int ii = 0; ii < count1; ++ii) {
                    double aValue = cm.getValue(valuesArray[ii]);
                    valuesVector.setValueAt(aValue, ii);
                    if (ii > 1) continue;
                    if (ii == 0) {
                        firstValue = aValue;
                        continue;
                    }
                    secondValue = aValue;
                }
                Dimension prefSize1 = this.getPreferredSize1();
                Dimension size1 = this.getSize1();
                size1.width = count1 > 1 ? (int)(secondValue - firstValue) : prefSize1.width;
                size1.height = prefSize1.height;
                double text1Scale = Math.min(1.0, (double)size1.width / (double)prefSize1.width);
                this.setText1Scale(new Double(text1Scale));
            }
        }
        if ((tpm = axisModel.getTimePeriodModel2()).isVisible()) {
            NumericVector values2Vector = (NumericVector)this.getValues2();
            double[] values2Array = this.getValues2Array();
            if (values2Array != null && values2Array.length > 0) {
                int count2 = values2Array.length - 1;
                for (int ii = 0; ii < count2; ++ii) {
                    double aValue = cm.getValue(values2Array[ii]);
                    values2Vector.setValueAt(aValue, ii);
                    if (ii > 1) continue;
                    if (ii == 0) {
                        firstValue = aValue;
                        continue;
                    }
                    secondValue = aValue;
                }
                Dimension prefSize2 = this.getPreferredSize2();
                Dimension size2 = this.getSize2();
                size2.width = count2 > 1 ? (int)(secondValue - firstValue) : prefSize2.width;
                size2.height = prefSize2.height;
                double text2Scale = Math.min(1.0, (double)size2.width / (double)prefSize2.width);
                this.setText2Scale(new Double(text2Scale));
            }
        }
        if ((tpm = axisModel.getTimePeriodModel3()).isVisible()) {
            NumericVector values3Vector = (NumericVector)this.getValues3();
            double[] values3Array = this.getValues3Array();
            if (values3Array != null && values3Array.length > 0) {
                int count3 = values3Array.length - 1;
                for (int ii = 0; ii < count3; ++ii) {
                    double aValue = cm.getValue(values3Array[ii]);
                    values3Vector.setValueAt(aValue, ii);
                    if (ii > 1) continue;
                    if (ii == 0) {
                        firstValue = aValue;
                        continue;
                    }
                    secondValue = aValue;
                }
                Dimension prefSize3 = this.getPreferredSize3();
                Dimension size3 = this.getSize3();
                size3.width = count3 > 1 ? (int)(secondValue - firstValue) : prefSize3.width;
                size3.height = prefSize3.height;
                double text3Scale = Math.min(1.0, (double)size3.width / (double)prefSize3.width);
                this.setText3Scale(new Double(text3Scale));
            }
        }
    }

    private ZxAxis.Interval _getInnerInterval(ZxAxis.Interval intvl) {
        ZxAxis.Interval newIntvl = new ZxAxis.Interval();
        newIntvl.units = intvl.units;
        newIntvl.intper = intvl.intper;
        switch (intvl.intcode) {
            default: {
                newIntvl.intcode = intvl.intcode;
                newIntvl.intper = 1;
                break;
            }
            case 10: {
                newIntvl.intcode = intvl.intcode;
                newIntvl.intper = 1;
                break;
            }
            case 15: {
                newIntvl.intcode = 10;
                break;
            }
            case 20: {
                newIntvl.intcode = 15;
                break;
            }
            case 25: {
                if (this.day) {
                    newIntvl.intcode = 25;
                    break;
                }
                newIntvl.intcode = 20;
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 40: {
                newIntvl.intcode = 25;
                break;
            }
            case 29: 
            case 38: {
                newIntvl.intcode = 28;
                break;
            }
            case 45: {
                newIntvl.intcode = 30;
                break;
            }
            case 43: {
                newIntvl.intcode = 29;
                break;
            }
            case 50: {
                newIntvl.intcode = 45;
                break;
            }
            case 49: 
            case 54: {
                newIntvl.intcode = 43;
                break;
            }
            case 60: {
                newIntvl.intcode = 50;
                break;
            }
            case 58: {
                newIntvl.intcode = 49;
            }
        }
        return newIntvl;
    }

    static final double _convertToDays(TimeLength tl) {
        double magnitude = tl.getMagnitude();
        switch (tl.getUnit()) {
            default: {
                break;
            }
            case 10820: {
                magnitude = Double.NaN;
                break;
            }
            case 10830: {
                magnitude /= 86400.0;
                break;
            }
            case 10835: {
                magnitude /= 1440.0;
                break;
            }
            case 10840: {
                magnitude /= 24.0;
                break;
            }
            case 10865: {
                magnitude *= 10.0;
                break;
            }
            case 10860: {
                magnitude *= 7.0;
                break;
            }
            case 10875: {
                magnitude *= 30.0;
                break;
            }
            case 10880: {
                magnitude *= 91.25;
                break;
            }
            case 10890: {
                magnitude *= 365.0;
            }
        }
        return magnitude;
    }

    static final double _convertToSeconds(TimeLength tl) {
        double magnitude = tl.getMagnitude();
        switch (tl.getUnit()) {
            case 10855: {
                magnitude *= 86400.0;
                break;
            }
            case 10820: {
                magnitude = Double.NaN;
                break;
            }
            default: {
                break;
            }
            case 10835: {
                magnitude *= 60.0;
                break;
            }
            case 10840: {
                magnitude *= 3600.0;
                break;
            }
            case 10865: {
                magnitude *= 864000.0;
                break;
            }
            case 10860: {
                magnitude *= 604800.0;
                break;
            }
            case 10875: {
                magnitude *= 2592000.0;
                break;
            }
            case 10880: {
                magnitude *= 7884000.0;
                break;
            }
            case 10890: {
                magnitude *= 3.1536E7;
            }
        }
        return magnitude;
    }

    private static Double tod(double datetime) {
        double p = datetime % 86400.0;
        if (p < 0.0) {
            p += 86400.0;
        }
        return new Double(p);
    }

    private static class DataInfo {
        double adjustedMin = Double.MAX_VALUE;
        double adjustedMax = Double.MIN_VALUE;

        private DataInfo() {
        }
    }
}

