/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TimePeriodModel;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.CompoundTimeAxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class CompoundTimeAxisCell
extends Cell {
    Dimension cachedPreferredSize = null;
    private int maxUnitIncrement = 1;

    public CompoundTimeAxisCell(CompoundTimeAxisCellModel cellModel, Channel channel) {
        super(cellModel, channel);
    }

    @Override
    protected synchronized void construct() {
        Font font;
        LineSegment eSegment;
        GridStyle gridStyle;
        LineStyle lineStyle;
        Calculator c3;
        Calculator c2;
        Calculator c1;
        double scale;
        RasterLabel label;
        boolean level3Visible;
        boolean level2Visible;
        CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.getModel();
        CompoundTimeAxisModel axisModel = cellModel.getTimeAxisModel();
        if (!axisModel.isVisible()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        int length = (int)cellModel.getLength().doubleValue();
        TimePeriodModel tpm = axisModel.getTimePeriodModel1();
        TimePeriodModel tpm2 = axisModel.getTimePeriodModel2();
        TimePeriodModel tpm3 = axisModel.getTimePeriodModel3();
        Dimension size1 = cellModel.getSize1();
        Dimension size2 = cellModel.getSize2();
        Dimension size3 = cellModel.getSize3();
        int actualHeight = bounds.height;
        boolean level1Visible = tpm.isVisible() && tpm.getTextStyle().isVisible() && cellModel.getText1Scale() != null;
        int minHeight = (level1Visible ? size1.height : 0) + ((level2Visible = tpm2.isVisible() && tpm2.getTextStyle().isVisible() && cellModel.getText2Scale() != null) ? size2.height : 0) + ((level3Visible = tpm3.isVisible() && tpm3.getTextStyle().isVisible() && cellModel.getText3Scale() != null) ? size3.height : 0);
        int extraHeight = actualHeight - minHeight;
        if (extraHeight < 0) {
            extraHeight = 0;
        }
        int numVisibleLevels = (level1Visible ? 1 : 0) + (level2Visible ? 1 : 0) + (level3Visible ? 1 : 0);
        int verticalPadding = numVisibleLevels > 0 ? extraHeight / numVisibleLevels / 2 : 0;
        int yoffset = 0;
        TextStyle ts = tpm3.getTextStyle();
        if (level3Visible) {
            label = new RasterLabel();
            scale = cellModel.getText3Scale();
            Font font2 = ts.getFont();
            label.fontName.setValue(font2.getName());
            label.fontSize.setValue((int)((double)font2.getSize() * scale));
            label.fontStyle.setValue(font2.getStyle());
            label.color.setValue(ts.getColor());
            label.shadowColor.setValue(ts.getShadowStyle().getColor());
            label.shadowOn.setValue(ts.getShadowStyle().isVisible());
            label.shadowOffsetX.setValue((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label.shadowOffsetY.setValue((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            label.trimOn.setValue(true);
            double xOffset = 4.0 * scale;
            switch (ts.getJustification()) {
                default: {
                    label.horizontalJustification.setValue(1);
                    c1 = new Calculator("inA + inB");
                    c1.inA.connectFrom(cellModel.getValues3());
                    c1.inB.setValue((double)(size3.width / 2));
                    label.transform.translateX.connectFrom((NumericPipe)c1);
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    label.horizontalJustification.setValue(0);
                    c2 = new Calculator("inA + inB");
                    c2.inA.connectFrom(cellModel.getValues3());
                    c2.inB.setValue(xOffset);
                    label.transform.translateX.connectFrom((NumericPipe)c2);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    label.horizontalJustification.setValue(2);
                    c3 = new Calculator("inA + inB");
                    c3.inA.connectFrom(cellModel.getValues3());
                    c3.inB.setValue((double)size3.width - xOffset);
                    label.transform.translateX.connectFrom((NumericPipe)c3);
                }
            }
            label.verticalJustification.setValue(1);
            label.string.connectFrom(cellModel.getValue3Labels());
            label.transform.translateY.setValue((double)(yoffset + verticalPadding + size3.height / 2));
            this.getComposite().addElement((Element)label);
            lineStyle = axisModel.getValueCellStyle().getFrameLineStyle();
            if (lineStyle.getVisibilityPolicy() != 10202) {
                double width = lineStyle.getThickness().getMagnitude((Object)"px");
                Grid grid3 = new Grid();
                grid3.verticalLineOffset.connectFrom(cellModel.getValues3());
                gridStyle = grid3.getStyle();
                gridStyle.setBorderOn(false);
                gridStyle.setLineWidth((int)width);
                gridStyle.setMajorLineColor(lineStyle.getColor());
                gridStyle.setBackgroundOn(false);
                grid3.selectEnabled.setValue(false);
                grid3.setVerticalOrigin((double)yoffset);
                grid3.setWidth((double)bounds.width);
                grid3.setHeight(level2Visible || level1Visible ? (double)(size3.height + 2 * verticalPadding) : (double)(actualHeight - yoffset));
                this.getComposite().addElement((Element)grid3);
                yoffset = (int)((double)yoffset + grid3.getHeight());
                if (level2Visible || level1Visible) {
                    eSegment = new LineSegment();
                    eSegment.lineWidth.setValue(width);
                    eSegment.beginX.setValue(0.0);
                    eSegment.endX.setValue((double)length);
                    eSegment.beginY.setValue((double)yoffset);
                    eSegment.endY.setValue((double)yoffset);
                    eSegment.color.setValue(lineStyle.getColor());
                    this.getComposite().addElement((Element)eSegment);
                }
            }
        }
        ts = tpm2.getTextStyle();
        if (level2Visible) {
            label = new RasterLabel();
            scale = cellModel.getText2Scale();
            double xOffset = 4.0 * scale;
            font = ts.getFont();
            label.fontName.setValue(font.getName());
            label.fontSize.setValue((int)((double)font.getSize() * scale));
            label.fontStyle.setValue(font.getStyle());
            label.color.setValue(ts.getColor());
            label.shadowColor.setValue(ts.getShadowStyle().getColor());
            label.shadowOn.setValue(ts.getShadowStyle().isVisible());
            label.shadowOffsetX.setValue((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label.shadowOffsetY.setValue((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            label.trimOn.setValue(true);
            switch (ts.getJustification()) {
                default: {
                    label.horizontalJustification.setValue(1);
                    c1 = new Calculator("inA + inB");
                    c1.inA.connectFrom(cellModel.getValues2());
                    c1.inB.setValue((double)(size2.width / 2));
                    label.transform.translateX.connectFrom((NumericPipe)c1);
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    label.horizontalJustification.setValue(0);
                    c2 = new Calculator("inA + inB");
                    c2.inA.connectFrom(cellModel.getValues2());
                    c2.inB.setValue(xOffset);
                    label.transform.translateX.connectFrom((NumericPipe)c2);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    label.horizontalJustification.setValue(2);
                    c3 = new Calculator("inA + inB");
                    c3.inA.connectFrom(cellModel.getValues2());
                    c3.inB.setValue((double)size2.width - xOffset);
                    label.transform.translateX.connectFrom((NumericPipe)c3);
                }
            }
            label.verticalJustification.setValue(1);
            label.string.connectFrom(cellModel.getValue2Labels());
            label.transform.translateY.setValue((double)(yoffset + verticalPadding + size2.height / 2));
            this.getComposite().addElement((Element)label);
            lineStyle = axisModel.getValueCellStyle().getFrameLineStyle();
            if (lineStyle.getVisibilityPolicy() != 10202) {
                double width = lineStyle.getThickness().getMagnitude((Object)"px");
                Grid grid2 = new Grid();
                grid2.verticalLineOffset.connectFrom(cellModel.getValues2());
                gridStyle = grid2.getStyle();
                gridStyle.setBorderOn(false);
                gridStyle.setLineWidth((int)width);
                gridStyle.setMajorLineColor(lineStyle.getColor());
                gridStyle.setBackgroundOn(false);
                grid2.selectEnabled.setValue(false);
                grid2.setVerticalOrigin((double)yoffset);
                grid2.setWidth((double)bounds.width);
                grid2.setHeight(level1Visible ? (double)(size2.height + 2 * verticalPadding) : (double)(actualHeight - yoffset));
                this.getComposite().addElement((Element)grid2);
                yoffset = (int)((double)yoffset + grid2.getHeight());
                if (level1Visible) {
                    eSegment = new LineSegment();
                    eSegment.lineWidth.setValue(width);
                    eSegment.beginX.setValue(0.0);
                    eSegment.endX.setValue((double)length);
                    eSegment.beginY.setValue((double)yoffset);
                    eSegment.endY.setValue((double)yoffset);
                    eSegment.color.setValue(lineStyle.getColor());
                    this.getComposite().addElement((Element)eSegment);
                }
            }
        }
        ts = tpm.getTextStyle();
        if (level1Visible) {
            double scale2 = cellModel.getText1Scale();
            double xOffset = 4.0 * scale2;
            RasterLabel label2 = new RasterLabel();
            font = ts.getFont();
            label2.fontName.setValue(font.getName());
            label2.fontSize.setValue((int)((double)font.getSize() * scale2));
            label2.fontStyle.setValue(font.getStyle());
            label2.color.setValue(ts.getColor());
            label2.shadowColor.setValue(ts.getShadowStyle().getColor());
            label2.shadowOn.setValue(ts.getShadowStyle().isVisible());
            label2.shadowOffsetX.setValue((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            label2.shadowOffsetY.setValue((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            label2.trimOn.setValue(true);
            switch (ts.getJustification()) {
                default: {
                    label2.horizontalJustification.setValue(1);
                    c1 = new Calculator("inA + inB");
                    c1.inA.connectFrom(cellModel.getValues1());
                    c1.inB.setValue((double)(size1.width / 2));
                    label2.transform.translateX.connectFrom((NumericPipe)c1);
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    label2.horizontalJustification.setValue(0);
                    Calculator c22 = new Calculator("inA + inB");
                    c22.inA.connectFrom(cellModel.getValues1());
                    c22.inB.setValue(xOffset);
                    label2.transform.translateX.connectFrom((NumericPipe)c22);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    label2.horizontalJustification.setValue(2);
                    c3 = new Calculator("inA + inB");
                    c3.inA.connectFrom(cellModel.getValues1());
                    c3.inB.setValue((double)size1.width - xOffset);
                    label2.transform.translateX.connectFrom((NumericPipe)c3);
                }
            }
            label2.verticalJustification.setValue(1);
            label2.string.connectFrom(cellModel.getValue1Labels());
            label2.transform.translateY.setValue((double)(yoffset + verticalPadding + size1.height / 2));
            this.getComposite().addElement((Element)label2);
            lineStyle = axisModel.getValueCellStyle().getFrameLineStyle();
            if (lineStyle.getVisibilityPolicy() != 10202) {
                double width = lineStyle.getThickness().getMagnitude((Object)"px");
                Grid grid1 = new Grid();
                grid1.verticalLineOffset.connectFrom(cellModel.getValues1());
                gridStyle = grid1.getStyle();
                gridStyle.setBorderOn(false);
                gridStyle.setLineWidth((int)width);
                gridStyle.setMajorLineColor(lineStyle.getColor());
                gridStyle.setBackgroundOn(false);
                grid1.selectEnabled.setValue(false);
                grid1.setVerticalOrigin((double)yoffset);
                grid1.setWidth((double)length);
                grid1.setHeight((double)(actualHeight - yoffset));
                this.getComposite().addElement((Element)grid1);
            }
        }
        Dimension margin = cellModel.getMargin();
        this.getComposite().transform.translateX.setValue((double)(margin.width + bounds.x));
        this.getComposite().transform.translateY.setValue((double)bounds.y);
    }

    public void doConstruct() {
        this.getComposite().removeAllElements();
        this.construct();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize != null && this.isCacheValid()) {
            return this.cachedPreferredSize;
        }
        this.cachedPreferredSize = this._getPreferredSize(false);
        return this.cachedPreferredSize == null ? super.getPreferredSize() : this.cachedPreferredSize;
    }

    public void invalidatePreferredSizeCache() {
        this.cachedPreferredSize = null;
    }

    private boolean isCacheValid() {
        CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.getModel();
        return cellModel == null || cellModel.getPreferredLength().intValue() == this.cachedPreferredSize.width;
    }

    @Override
    public Dimension getMinimumSize() {
        return this._getPreferredSize(true);
    }

    private Dimension _getPreferredSize(boolean min) {
        Dimension d;
        int numMargins;
        CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.getModel();
        CompoundTimeAxisModel axisModel = cellModel.getTimeAxisModel();
        NumericMapper mapper = cellModel.getMapper();
        if (!axisModel.isVisible() || mapper == null) {
            return new Dimension(1, 1);
        }
        String orient = cellModel.getAxisOrientation();
        int catAxisAdj = cellModel.getCatAxisAdj().intValue();
        int resAxisAdj = cellModel.getResAxisAdj().intValue();
        if (!cellModel.getAxisVisible().booleanValue() && (mapper instanceof StringToNumericMapper || cellModel.getAxisModel().getReferenceLineModels() == null)) {
            Dimension margin = cellModel.getMargin();
            catAxisAdj = Math.min(4, margin.height);
            resAxisAdj = Math.min(4, margin.width);
        }
        int len = cellModel.getPreferredLength().intValue();
        Dimension margin = cellModel.getMargin();
        Dimension depth = cellModel.getDepth();
        int n = numMargins = cellModel.getExtendToMargin() != false ? 2 : 1;
        if (orient == "North" || orient == "South") {
            if (resAxisAdj < 2) {
                resAxisAdj = 2;
            }
            d = new Dimension(resAxisAdj, len + numMargins * margin.height + catAxisAdj + depth.height);
        } else {
            if (catAxisAdj < 2) {
                catAxisAdj = 2;
            }
            d = new Dimension(len + numMargins * margin.width + resAxisAdj + depth.width, catAxisAdj);
        }
        return d;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.getModel();
        cellModel.setVisibleLength(width);
        cellModel.computeParameters(this.getChannel(), width, height);
        Dimension preferredSize = this.getPreferredSize();
        this.setPreferredSize(preferredSize);
        super.setBounds(x, y, width, height);
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    public AxisCellModel getAxisModel() {
        return (AxisCellModel)super.getModel();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension d;
        int numMargins;
        if (this.getChannel().getGraphics() == null) {
            return new Dimension(1, 1);
        }
        CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.getModel();
        AxisModel axisModel = cellModel.getAxisModel();
        NumericMapper mapper = cellModel.getMapper();
        if (!axisModel.isVisible() || mapper == null) {
            return new Dimension(1, 1);
        }
        String orient = cellModel.getAxisOrientation();
        int catAxisAdj = cellModel.getCatAxisAdj().intValue();
        int resAxisAdj = cellModel.getResAxisAdj().intValue();
        if (!cellModel.getAxisVisible().booleanValue() && (mapper instanceof StringToNumericMapper || cellModel.getAxisModel().getReferenceLineModels() == null)) {
            Dimension margin = cellModel.getMargin();
            catAxisAdj = Math.min(4, margin.height);
            resAxisAdj = Math.min(4, margin.width);
        }
        int len = (int)(cellModel.getPreferredLength() / cellModel.getViewFactor());
        Dimension margin = cellModel.getMargin();
        Dimension depth = cellModel.getDepth();
        int n = numMargins = cellModel.getExtendToMargin() != false ? 2 : 1;
        if (orient == "North" || orient == "South") {
            if (resAxisAdj < 2) {
                resAxisAdj = 2;
            }
            d = new Dimension(resAxisAdj, len + numMargins * margin.height + catAxisAdj + depth.height);
        } else {
            if (catAxisAdj < 2) {
                catAxisAdj = 2;
            }
            d = new Dimension(len + numMargins * margin.width + resAxisAdj + depth.width, catAxisAdj);
        }
        return d;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    public static class CompoundTimeAxisCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final CompoundTimeAxisCellModel cellModel;
        private final Channel channel;

        public CompoundTimeAxisCellComponentFactory(CompoundTimeAxisCellModel cellModel, Channel channel) {
            this.cellModel = cellModel;
            this.channel = channel;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode && this.cellModel != null) {
                CompoundTimeAxisCell cell = new CompoundTimeAxisCell(this.cellModel, this.channel);
                cell.setOpaque(true);
                cell.setBackground(this.cellModel.getBackgroundColor());
                return cell;
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            throw new IllegalStateException("Not Supported");
        }
    }
}

