/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.SimplePropertyBag;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import java.awt.Color;

public class ColorRampLegendCellModel
extends LegendCellModel {
    public static final Object COLORS = "colors";
    public static final Object LABELS = "labels";
    public static final Object COLOR_VALUES = "colorValues";
    public static final Object LABEL_VALUES = "labelValues";
    public static final Object LOW_VALUE = "lowValue";
    public static final Object HIGH_VALUE = "highValue";
    public static final Object VALUE_FORMAT = "valueFormat";
    public static final Object COLOR_RAMP_LEGEND_MODEL = "colorRampLegendModel";

    public void setColors(Color[] colors) {
        this.properties.set(COLORS, colors);
    }

    public Color[] getColors() {
        return (Color[])SimplePropertyBag.Util.getObject(this.properties, COLORS, this.propertyDefaults, Color[].class);
    }

    public void setLabels(String[] labels) {
        this.properties.set(LABELS, labels);
    }

    public String[] getLabels() {
        return (String[])SimplePropertyBag.Util.getObject(this.properties, LABELS, this.propertyDefaults, String[].class);
    }

    public void setColorValues(Double[] values) {
        this.properties.set(COLOR_VALUES, values);
    }

    public Double[] getColorValues() {
        return (Double[])SimplePropertyBag.Util.getObject(this.properties, COLOR_VALUES, this.propertyDefaults, Double[].class);
    }

    public void setLabelValues(Double[] values) {
        this.properties.set(LABEL_VALUES, values);
    }

    public Double[] getLabelValues() {
        return (Double[])SimplePropertyBag.Util.getObject(this.properties, LABEL_VALUES, this.propertyDefaults, Double[].class);
    }

    public void setLowValue(Double value) {
        this.properties.set(LOW_VALUE, value);
    }

    public Double getLowValue() {
        return (Double)SimplePropertyBag.Util.getObject(this.properties, LOW_VALUE, this.propertyDefaults, Double.class);
    }

    public void setHighValue(Double value) {
        this.properties.set(HIGH_VALUE, value);
    }

    public Double getHighValue() {
        return (Double)SimplePropertyBag.Util.getObject(this.properties, HIGH_VALUE, this.propertyDefaults, Double.class);
    }

    public void setValueFormat(GTKFormat value) {
        this.properties.set(VALUE_FORMAT, value);
    }

    public GTKFormat getValueFormat() {
        return (GTKFormat)SimplePropertyBag.Util.getObject(this.properties, VALUE_FORMAT, this.propertyDefaults, GTKFormat.class);
    }

    @Override
    public void setColorMapper(ColorMapper colorMapper) {
        super.setColorMapper(colorMapper);
        if (!(colorMapper instanceof ContinuousRangeToColorMapper)) {
            return;
        }
        ContinuousRangeToColorMapper crtcm = (ContinuousRangeToColorMapper)colorMapper;
        try {
            if (this.getColors() == null) {
                Color[] colors = crtcm.getColorSpectrumColors();
                if (colors == null || colors.length == 0) {
                    colors = new Color[]{crtcm.getOutputMin(), crtcm.getOutputMax()};
                }
                this.setColors(colors);
            }
            if (this.getColorValues() == null && crtcm.getColorSpectrumValues() != null && crtcm.getColorSpectrumValues().length > 0) {
                double[] dvec = crtcm.getColorSpectrumValues();
                double low = crtcm.getInputMin();
                double range = crtcm.getInputMax() - low;
                Double[] dvals = new Double[dvec.length];
                for (int i = 0; i < dvec.length; ++i) {
                    dvals[i] = new Double((dvec[i] - low) / range);
                }
                this.setColorValues(dvals);
            }
            if (this.getLowValue() == null) {
                this.setLowValue(new Double(crtcm.getInputMin()));
            }
            if (this.getHighValue() == null) {
                this.setHighValue(new Double(crtcm.getInputMax()));
            }
            if (this.getValueFormat() == null) {
                this.setValueFormat(crtcm.getFormat());
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

