/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.RB;
import com.sas.measures.BaseLength;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;

public class ChartLayout
implements LayoutManager2 {
    public static final String RB_KEY = "ChartLayout.";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    Vector norths = new Vector();
    Vector wests = new Vector();
    Vector easts = new Vector();
    Vector souths = new Vector();
    Component center = null;
    private static final int FONT_SIZE_12PT_PX = (int)new BaseLength(12.0, "pt").getMagnitude((Object)"px");
    private static final int MIN_PREFERRED_LEGEND_THRESHOLD = FONT_SIZE_12PT_PX * 20;
    double constraintPercentage = 0.4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException(RB.getStringResource("notAStringConstraint.ex.txt"));
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (CENTER.equals(name)) {
                this.center = comp;
            } else if (NORTH.equals(name)) {
                this.norths.add(comp);
            } else if (SOUTH.equals(name)) {
                this.souths.add(comp);
            } else if (EAST.equals(name)) {
                this.easts.add(comp);
            } else if (WEST.equals(name)) {
                this.wests.add(comp);
            } else {
                throw new IllegalArgumentException(RB.getStringResource("unknownConstraint.ex.txt") + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (this.center == comp) {
                this.center = null;
            } else {
                this.norths.remove(comp);
                this.souths.remove(comp);
                this.easts.remove(comp);
                this.wests.remove(comp);
            }
        }
    }

    private boolean _containsHierarchicalLegendCell(Vector cv) {
        if (cv != null) {
            int size = cv.size();
            for (int ii = 0; ii < size; ++ii) {
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible() || !(c instanceof HierarchicalLegendCell)) continue;
                return true;
            }
        }
        return false;
    }

    private Dimension _sumSize(Vector cv, Dimension constraints, boolean isPreferredSize, boolean isVerticalSum) {
        int w = 0;
        int h = 0;
        if (cv != null) {
            int size = cv.size();
            for (int ii = 0; ii < size; ++ii) {
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible()) continue;
                Dimension dim = null;
                if (constraints != null && c instanceof LegendCell) {
                    dim = isPreferredSize ? ((LegendCell)c).getPreferredSize(constraints) : ((LegendCell)c).getPreferredSize(constraints);
                } else {
                    Dimension dimension = dim = isPreferredSize ? c.getPreferredSize() : c.getMinimumSize();
                }
                if (isVerticalSum) {
                    h += dim.height;
                    w = Math.max(dim.width, w);
                    continue;
                }
                w += dim.width;
                h = Math.max(dim.height, h);
            }
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this._layoutSize(target, false);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this._layoutSize(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension _layoutSize(Container target, boolean isPreferredSize) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension centerPre = this.center != null && this.center.isVisible() ? this.center.getPreferredSize() : new Dimension(0, 0);
            int factor = 2;
            int cw = centerPre.width == 0 ? MIN_PREFERRED_LEGEND_THRESHOLD : centerPre.width * factor;
            Dimension phc = this._containsHierarchicalLegendCell(this.norths) || this._containsHierarchicalLegendCell(this.souths) ? null : new Dimension(Math.max(centerPre.width, Math.min(MIN_PREFERRED_LEGEND_THRESHOLD, cw)), Integer.MAX_VALUE);
            Dimension northSum = this._sumSize(this.norths, phc, isPreferredSize, true);
            Dimension southSum = this._sumSize(this.souths, phc, isPreferredSize, true);
            int ch = centerPre.height == 0 ? MIN_PREFERRED_LEGEND_THRESHOLD : centerPre.height * factor;
            Dimension pvc = this._containsHierarchicalLegendCell(this.easts) || this._containsHierarchicalLegendCell(this.wests) ? null : new Dimension(Integer.MAX_VALUE, Math.max(centerPre.height, Math.min(MIN_PREFERRED_LEGEND_THRESHOLD, ch)));
            Dimension eastSum = this._sumSize(this.easts, pvc, isPreferredSize, false);
            Dimension westSum = this._sumSize(this.wests, pvc, isPreferredSize, false);
            Dimension d = new Dimension();
            d.width = westSum.width + eastSum.width + Math.max(Math.max(northSum.width, southSum.width), centerPre.width);
            d.height = northSum.height + southSum.height + Math.max(Math.max(eastSum.height, westSum.height), centerPre.height);
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void _setNorthBounds(Vector cv, Dimension constraints, int x, int y, int w, int h) {
        if (cv != null) {
            int size = cv.size();
            for (int ii = size - 1; ii >= 0; --ii) {
                Dimension p;
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible()) continue;
                Dimension dimension = p = constraints != null && c instanceof LegendCell ? ((LegendCell)c).getPreferredSize(constraints) : c.getPreferredSize();
                if (h >= p.height) {
                    c.setSize(w, p.height);
                    c.setBounds(x + (w - p.width) / 2, y, p.width, p.height);
                    h -= p.height;
                    y += p.height;
                    continue;
                }
                c.setSize(0, 0);
                c.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setSouthBounds(Vector cv, Dimension constraints, int x, int y, int w, int h) {
        if (cv != null) {
            int size = cv.size();
            for (int ii = 0; ii < size; ++ii) {
                Dimension p;
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible()) continue;
                Dimension dimension = p = constraints != null && c instanceof LegendCell ? ((LegendCell)c).getPreferredSize(constraints) : c.getPreferredSize();
                if (h >= p.height) {
                    c.setSize(p.width, p.height);
                    c.setBounds(x + (w - p.width) / 2, y, p.width, p.height);
                    h -= p.height;
                    y += p.height;
                    continue;
                }
                c.setSize(0, 0);
                c.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setEastBounds(Vector cv, Dimension constraints, int x, int y, int w, int h) {
        if (cv != null) {
            int size = cv.size();
            for (int ii = 0; ii < size; ++ii) {
                Dimension p;
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible()) continue;
                Dimension dimension = p = constraints != null && c instanceof LegendCell ? ((LegendCell)c).getPreferredSize(constraints) : c.getPreferredSize();
                if (w >= p.width) {
                    c.setSize(p.width, h);
                    c.setBounds(x, y + (h - p.height) / 2, p.width, p.height);
                    w -= p.width;
                    x += p.width;
                    continue;
                }
                c.setSize(0, 0);
                c.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setWestBounds(Vector cv, Dimension constraints, int x, int y, int w, int h) {
        if (cv != null) {
            int size = cv.size();
            for (int ii = size - 1; ii >= 0; --ii) {
                Dimension p;
                Component c = (Component)cv.elementAt(ii);
                if (c == null || !c.isVisible()) continue;
                Dimension dimension = p = constraints != null && c instanceof LegendCell ? ((LegendCell)c).getPreferredSize(constraints) : c.getPreferredSize();
                if (w >= p.width) {
                    c.setSize(p.width, h);
                    c.setBounds(x, y + (h - p.height) / 2, p.width, p.height);
                    w -= p.width;
                    x += p.width;
                    continue;
                }
                c.setSize(0, 0);
                c.setBounds(0, 0, 0, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this._layoutContainer(target);
        }
    }

    public void setConstraintPercentage(double d) {
        this.constraintPercentage = Math.min(Math.max(0.0, d), 1.0);
    }

    public double getConstraintPercentage() {
        return this.constraintPercentage;
    }

    private Dimension _layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension targetSize = target.getSize();
        int top = insets.top;
        int bottom = targetSize.height - insets.bottom;
        int left = insets.left;
        int right = targetSize.width - insets.right;
        Dimension NSconstraints = new Dimension(targetSize.width, (int)((double)targetSize.height * this.constraintPercentage));
        Dimension EWconstraints = new Dimension((int)((double)targetSize.width * this.constraintPercentage), targetSize.height);
        Dimension northSum = this._sumSize(this.norths, NSconstraints, true, true);
        Dimension southSum = this._sumSize(this.souths, NSconstraints, true, true);
        Dimension eastSum = this._sumSize(this.easts, EWconstraints, true, false);
        Dimension westSum = this._sumSize(this.wests, EWconstraints, true, false);
        int availCenterWidth = Math.max(0, right - left - westSum.width - eastSum.width);
        int availCenterHeight = Math.max(0, bottom - top - northSum.height - southSum.height);
        int centerWidth = availCenterWidth;
        int centerHeight = availCenterHeight;
        int adjustX = Math.max(0, (right - left - (centerWidth + westSum.width + eastSum.width)) / 2);
        int adjustY = Math.max(0, (bottom - top - (centerHeight + northSum.height + southSum.height)) / 2);
        top += adjustY;
        left += adjustX;
        Dimension northDim = new Dimension(centerWidth, northSum.height);
        Dimension southDim = new Dimension(centerWidth, southSum.height);
        Dimension eastDim = new Dimension(eastSum.width, centerHeight);
        Dimension westDim = new Dimension(westSum.width, centerHeight);
        Dimension centerDim = new Dimension(centerWidth, centerHeight);
        this._setNorthBounds(this.norths, NSconstraints, left + westDim.width, top, northDim.width, northDim.height);
        this._setSouthBounds(this.souths, NSconstraints, left + westDim.width, top + northDim.height + centerDim.height, southDim.width, southDim.height);
        this._setWestBounds(this.wests, EWconstraints, left, top + northDim.height, westDim.width, westDim.height);
        this._setEastBounds(this.easts, EWconstraints, left + westDim.width + centerDim.width, top + northDim.height, eastDim.width, eastDim.height);
        if (this.center != null) {
            this.center.setSize(centerDim.width, centerDim.height);
            this.center.setBounds(left + westDim.width, top + northDim.height, centerDim.width, centerDim.height);
        }
        return centerDim;
    }
}

