/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class ChartContainer
extends JPanel {
    private static final String TITLE_PROPERTY = "title";
    private static final String FOOTNOTE_PROPERTY = "footnote";
    private static final String CHART_PROPERTY = "chart";
    private static final String TITLE_BACKGROUND_PROPERTY = "titleBackground";
    private static final String FOOTNOTE_BACKGROUND_PROPERTY = "footnoteBackground";
    private static final String CHART_BACKGROUND_PROPERTY = "chartBackground";
    private static final String BRUSH_PROPERTY = "brush";
    private static final String DATA_TIP_PROPERTY = "dataTip";
    private transient JPanel graphContainer;
    private transient JPanel titleContainer;
    private transient JPanel chartContainer;
    private transient JPanel footnoteContainer;
    private transient JPanel graphBackgroundContainer;
    private transient JPanel titleBackgroundContainer;
    private transient JPanel chartBackgroundContainer;
    private transient JPanel footnoteBackgroundContainer;
    private transient JPanel graphBackAnnotationContainer;
    private transient JPanel graphFrontAnnotationContainer;
    private transient JPanel dataTipContainer;
    private transient JPanel brushContainer;
    private transient JPanel chartBackAnnotationContainer;
    private transient JPanel chartFrontAnnotationContainer;
    private transient JLayeredPane graphLayeredPane;
    private transient JLayeredPane chartLayeredPane;
    private transient JLayeredPane titleLayeredPane;
    private transient JLayeredPane footnoteLayeredPane;
    private transient JComponent title;
    private transient JComponent chart;
    private transient JComponent footnote;
    private transient JComponent graphBackground;
    private transient JComponent titleBackground;
    private transient JComponent chartBackground;
    private transient JComponent footnoteBackground;
    private transient int paintGate;
    private transient boolean paintPending;
    static int DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    static Integer BACKGROUND_LAYER = new Integer(DEFAULT_LAYER + 0);
    static Integer BACK_ANNOTATION_LAYER = new Integer(DEFAULT_LAYER + 1);
    static Integer CONTENT_LAYER = new Integer(DEFAULT_LAYER + 2);
    static Integer FRONT_ANNOTATION_LAYER = new Integer(DEFAULT_LAYER + 3);
    static Integer BRUSH_ANNOTATION_LAYER = new Integer(DEFAULT_LAYER + 4);
    static Integer DATA_TIP_ANNOTATION_LAYER = new Integer(DEFAULT_LAYER + 5);
    static Integer POP_UP_MENU_ANNOTATION_LAYER = new Integer(DEFAULT_LAYER + 6);
    private transient JComponent dataTip;
    private transient JComponent brush;

    public ChartContainer() {
        this.init();
    }

    private void init() {
        this.paintGate = 0;
        this.paintPending = false;
        this.setOpaque(false);
        this.graphContainer = new JPanel();
        this.graphContainer.setLayout(new BorderLayout());
        this.graphContainer.setOpaque(false);
        this.titleContainer = new JPanel();
        this.titleContainer.setLayout(new BorderLayout());
        this.titleContainer.setOpaque(false);
        this.chartContainer = new JPanel();
        this.chartContainer.setLayout(new BorderLayout());
        this.chartContainer.setOpaque(false);
        this.footnoteContainer = new JPanel();
        this.footnoteContainer.setLayout(new BorderLayout());
        this.footnoteContainer.setOpaque(false);
        this.graphBackgroundContainer = new JPanel();
        this.graphBackgroundContainer.setLayout(new BorderLayout());
        this.graphBackgroundContainer.setOpaque(false);
        this.titleBackgroundContainer = new JPanel();
        this.titleBackgroundContainer.setLayout(new BorderLayout());
        this.titleBackgroundContainer.setOpaque(false);
        this.chartBackgroundContainer = new JPanel();
        this.chartBackgroundContainer.setLayout(new BorderLayout());
        this.chartBackgroundContainer.setOpaque(false);
        this.footnoteBackgroundContainer = new JPanel();
        this.footnoteBackgroundContainer.setLayout(new BorderLayout());
        this.footnoteBackgroundContainer.setOpaque(false);
        this.graphLayeredPane = new JLayeredPane();
        this.graphLayeredPane.setLayout(new MyCardLayeredLayout());
        this.graphLayeredPane.setOpaque(false);
        this.titleLayeredPane = new JLayeredPane();
        this.titleLayeredPane.setLayout(new MyCardLayeredLayout());
        this.titleLayeredPane.setOpaque(false);
        this.chartLayeredPane = new JLayeredPane();
        this.chartLayeredPane.setLayout(new MyCardLayeredLayout());
        this.chartLayeredPane.setOpaque(false);
        this.footnoteLayeredPane = new JLayeredPane();
        this.footnoteLayeredPane.setLayout(new MyCardLayeredLayout());
        this.footnoteLayeredPane.setOpaque(false);
        this.graphLayeredPane.add((Component)this.graphBackgroundContainer, BACKGROUND_LAYER);
        if (this.graphBackAnnotationContainer != null) {
            this.graphLayeredPane.add((Component)this.graphBackAnnotationContainer, BACK_ANNOTATION_LAYER);
        }
        this.graphLayeredPane.add((Component)this.graphContainer, CONTENT_LAYER);
        if (this.graphFrontAnnotationContainer != null) {
            this.graphLayeredPane.add((Component)this.graphFrontAnnotationContainer, FRONT_ANNOTATION_LAYER);
        }
        if (this.dataTipContainer != null) {
            this.graphLayeredPane.add((Component)this.dataTipContainer, DATA_TIP_ANNOTATION_LAYER);
        }
        this.titleLayeredPane.add((Component)this.titleBackgroundContainer, BACKGROUND_LAYER);
        this.titleLayeredPane.add((Component)this.titleContainer, CONTENT_LAYER);
        this.chartLayeredPane.add((Component)this.chartBackgroundContainer, BACKGROUND_LAYER);
        if (this.chartBackAnnotationContainer != null) {
            this.chartLayeredPane.add((Component)this.chartBackAnnotationContainer, BACK_ANNOTATION_LAYER);
        }
        this.chartLayeredPane.add((Component)this.chartContainer, CONTENT_LAYER);
        if (this.chartFrontAnnotationContainer != null) {
            this.chartLayeredPane.add((Component)this.chartFrontAnnotationContainer, BACK_ANNOTATION_LAYER);
        }
        this.footnoteLayeredPane.add((Component)this.footnoteBackgroundContainer, BACKGROUND_LAYER);
        this.footnoteLayeredPane.add((Component)this.footnoteContainer, CONTENT_LAYER);
        this.graphContainer.add((Component)this.titleLayeredPane, "North");
        this.graphContainer.add((Component)this.chartLayeredPane, "Center");
        this.graphContainer.add((Component)this.footnoteLayeredPane, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.graphLayeredPane, "Center");
    }

    @Override
    public void paint(Graphics g) {
        this.paintPending = true;
        if (this.isFullPaintEnabled()) {
            this.paintPending = false;
            super.paint(g);
        }
    }

    public boolean isFullPaintEnabled() {
        return this.paintGate == 0;
    }

    public void disableFullPaint() {
        ++this.paintGate;
    }

    public void enableFullPaint() {
        this._enableFullPaint(true);
    }

    public void enableFullPaint(boolean updateNow) {
        this._enableFullPaint(updateNow);
    }

    private void _enableFullPaint(boolean updateNow) {
        if (!this.isFullPaintEnabled()) {
            this.paintGate = Math.max(0, this.paintGate - 1);
            if (this.paintPending && this.isFullPaintEnabled()) {
                this.paintPending = false;
                if (updateNow) {
                    if (!this.isValid()) {
                        this.validate();
                    }
                    this.repaint();
                }
            }
        }
    }

    public void setGraphBackground(JComponent newGraphBackground) {
        if (newGraphBackground != this.graphBackground) {
            if (this.graphBackground != null) {
                this.graphBackgroundContainer.remove(this.graphBackground);
            }
            this.graphBackground = newGraphBackground;
            if (this.graphBackground != null) {
                this.graphBackgroundContainer.add((Component)this.graphBackground, "Center");
            }
        }
        newGraphBackground = this.getGraphBackground();
    }

    public JComponent getGraphBackground() {
        return this.graphBackground;
    }

    public void setTitleBackground(JComponent newTitleBackground) {
        JComponent oldTitleBackground = this.getTitleBackground();
        if (newTitleBackground != this.titleBackground) {
            if (this.titleBackground != null) {
                this.titleBackgroundContainer.remove(this.titleBackground);
            }
            this.titleBackground = newTitleBackground;
            if (this.titleBackground != null) {
                this.titleBackgroundContainer.add((Component)this.titleBackground, "Center");
            }
        }
        if (oldTitleBackground != (newTitleBackground = this.getTitleBackground())) {
            this.firePropertyChange(TITLE_BACKGROUND_PROPERTY, oldTitleBackground, newTitleBackground);
        }
    }

    public JComponent getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitle(JComponent newTitle) {
        JComponent oldTitle = this.getTitle();
        if (newTitle != this.title) {
            if (this.title != null) {
                this.titleContainer.remove(this.title);
                this.titleContainer.revalidate();
                this.titleContainer.repaint();
            }
            this.title = newTitle;
            if (this.title != null) {
                this.titleContainer.add((Component)this.title, "Center");
                this.titleContainer.revalidate();
                this.titleContainer.repaint();
            }
        }
        if (oldTitle != (newTitle = this.getTitle())) {
            this.firePropertyChange(TITLE_PROPERTY, oldTitle, newTitle);
        }
    }

    public JComponent getTitle() {
        return this.title;
    }

    public void setFootnoteBackground(JComponent newFootnoteBackground) {
        JComponent oldFootnoteBackground = this.getFootnoteBackground();
        if (newFootnoteBackground != this.footnoteBackground) {
            if (this.footnoteBackground != null) {
                this.footnoteBackgroundContainer.remove(this.footnoteBackground);
            }
            this.footnoteBackground = newFootnoteBackground;
            if (this.footnoteBackground != null) {
                this.footnoteBackgroundContainer.add((Component)this.footnoteBackground, "Center");
            }
        }
        if (oldFootnoteBackground != (newFootnoteBackground = this.getFootnoteBackground())) {
            this.firePropertyChange(FOOTNOTE_BACKGROUND_PROPERTY, oldFootnoteBackground, newFootnoteBackground);
        }
    }

    public JComponent getFootnoteBackground() {
        return this.footnoteBackground;
    }

    public void setFootnote(JComponent newFootnote) {
        JComponent oldFootnote = this.getFootnote();
        if (newFootnote != this.footnote) {
            if (this.footnote != null) {
                this.footnoteContainer.remove(this.footnote);
            }
            this.footnote = newFootnote;
            if (this.footnote != null) {
                this.footnoteContainer.add((Component)this.footnote, "Center");
            }
        }
        if (oldFootnote != (newFootnote = this.getFootnote())) {
            this.firePropertyChange(FOOTNOTE_PROPERTY, oldFootnote, newFootnote);
        }
    }

    public JComponent getFootnote() {
        return this.footnote;
    }

    public void setChartBackground(JComponent newChartBackground) {
        JComponent oldChartBackground = this.getChartBackground();
        if (newChartBackground != this.chartBackground) {
            if (this.chartBackground != null) {
                this.chartBackgroundContainer.remove(this.chartBackground);
            }
            this.chartBackground = newChartBackground;
            if (this.chartBackground != null) {
                this.chartBackgroundContainer.add((Component)this.chartBackground, "Center");
            }
        }
        if (oldChartBackground != (newChartBackground = this.getChartBackground())) {
            this.firePropertyChange(CHART_BACKGROUND_PROPERTY, oldChartBackground, newChartBackground);
        }
    }

    public JComponent getChartBackground() {
        return this.chartBackground;
    }

    public void setChart(JComponent newChart) {
        JComponent oldChart = this.getChart();
        if (newChart != this.chart) {
            if (this.chart != null) {
                this.chartContainer.remove(this.chart);
            }
            this.chart = newChart;
            if (this.chart != null) {
                this.chartContainer.add((Component)this.chart, "Center");
            }
        }
        if (oldChart != (newChart = this.getChart())) {
            this.firePropertyChange(CHART_PROPERTY, oldChart, newChart);
        }
    }

    public JComponent getChart() {
        return this.chart;
    }

    public void setDataTip(JComponent newDataTip) {
        if (newDataTip != this.dataTip) {
            if (this.dataTip != null) {
                if (this.dataTipContainer != null) {
                    this.dataTipContainer.remove(this.dataTip);
                } else {
                    this.graphLayeredPane.remove(this.dataTip);
                }
            }
            JComponent oldDataTip = this.getDataTip();
            this.dataTip = newDataTip;
            if (this.dataTip != null) {
                if (this.dataTipContainer != null) {
                    this.dataTipContainer.add(this.dataTip);
                } else {
                    this.graphLayeredPane.add((Component)this.dataTip, DATA_TIP_ANNOTATION_LAYER);
                }
            }
            this.firePropertyChange(DATA_TIP_PROPERTY, oldDataTip, this.dataTip);
        }
    }

    public JComponent getDataTip() {
        return this.dataTip;
    }

    public void setBrush(JComponent newBrush) {
        if (newBrush != this.brush) {
            if (this.brush != null) {
                if (this.brushContainer != null) {
                    this.brushContainer.remove(this.brush);
                } else {
                    this.graphLayeredPane.remove(this.brush);
                }
            }
            JComponent oldBrush = this.getBrush();
            this.brush = newBrush;
            if (this.brush != null) {
                if (this.brushContainer != null) {
                    this.brushContainer.add(this.brush);
                } else {
                    this.graphLayeredPane.add((Component)this.brush, BRUSH_ANNOTATION_LAYER);
                }
            }
            this.firePropertyChange(BRUSH_PROPERTY, oldBrush, this.brush);
        }
    }

    public JComponent getBrush() {
        return this.brush;
    }

    private static class MyCardLayeredLayout
    implements LayoutManager2 {
        ArrayList dataTips = null;

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.dataTips != null && this.dataTips.contains(comp)) {
                this.dataTips.add(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent, false);
        }

        protected Dimension getLayoutSize(Container parent, boolean isPreferred) {
            Dimension largestSize = this.getLargestComponentSize(parent, isPreferred);
            Insets insets = parent.getInsets();
            largestSize.width = largestSize.width + insets.left + insets.right;
            largestSize.height = largestSize.height + insets.top + insets.bottom;
            return largestSize;
        }

        protected Dimension getLargestComponentSize(Container parent, boolean isPreferred) {
            int ncomponents = parent.getComponentCount();
            Dimension maxCellSize = new Dimension(0, 0);
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (c == null) continue;
                Dimension componentSize = isPreferred ? c.getPreferredSize() : c.getMinimumSize();
                maxCellSize.width = Math.max(maxCellSize.width, componentSize.width);
                maxCellSize.height = Math.max(maxCellSize.height, componentSize.height);
            }
            return maxCellSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                if (ncomponents == 0) {
                    return;
                }
                Dimension size = parent.getSize();
                int totalW = size.width - (insets.left + insets.right);
                int totalH = size.height - (insets.top + insets.bottom);
                for (int i = 0; i < ncomponents; ++i) {
                    Component c = parent.getComponent(i);
                    if (c != null && this.dataTips != null && this.dataTips.contains(c)) {
                        c = null;
                    }
                    if (c == null) continue;
                    int x = insets.left;
                    int y = insets.top;
                    int w = totalW;
                    int h = totalH;
                    c.setBounds(x, y, w, h);
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints == DATA_TIP_ANNOTATION_LAYER) {
                if (this.dataTips == null) {
                    this.dataTips = new ArrayList();
                }
                this.dataTips.add(comp);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

