/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.LineStyle;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeNode;

public class CellPane
extends HierarchicalPane {
    private final LineStyle frameLineStyle;
    private final CellComponentFactory cellComponentFactory;
    protected ValueTree rowTree;
    protected final HashMap rowToColMap;

    public CellPane(ValueTree colTree, ValueTree rowTree, Channel channel) {
        this(colTree, rowTree, null, null, channel);
    }

    public CellPane(ValueTree colTree, ValueTree rowTree, LineStyle frameLineStyle, Channel channel) {
        this(colTree, rowTree, null, frameLineStyle, channel);
    }

    public CellPane(ValueTree colTree, ValueTree rowTree, CellComponentFactory cellComponentFactory, Channel channel) {
        this(colTree, rowTree, cellComponentFactory, null, channel);
    }

    public CellPane(ValueTree colTree, ValueTree rowTree, CellComponentFactory cellComponentFactory, LineStyle frameLineStyle, Channel channel) {
        super(colTree);
        this.rowTree = rowTree;
        this.cellComponentFactory = cellComponentFactory != null ? cellComponentFactory : new DefaultCellComponentFactory(channel);
        this.frameLineStyle = frameLineStyle;
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(colTree);
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(rowTree);
        if (colTreeLeaves != null && rowTreeLeaves != null) {
            this.rowToColMap = new HashMap();
            this.createCellComponents(colTreeLeaves, rowTreeLeaves);
        } else if (colTreeLeaves != null) {
            this.rowToColMap = null;
            this.createCellComponents(colTreeLeaves);
        } else if (rowTreeLeaves != null) {
            this.rowToColMap = null;
            this.createCellComponents(rowTreeLeaves);
        } else {
            this.rowToColMap = null;
        }
        this._applyFrame();
    }

    public ValueTree getColumnTree() {
        return this.getTree();
    }

    public ValueTree getRowTree() {
        return this.rowTree;
    }

    public JComponent getCellComponent(TreeNode node) {
        return (JComponent)this.componentMap.get(node);
    }

    public JComponent getCellComponent(TreeNode colNode, TreeNode rowNode) {
        HashMap colComponentMap;
        JComponent cellComponent = null;
        if (this.rowToColMap != null && (colComponentMap = (HashMap)this.rowToColMap.get(rowNode)) != null) {
            cellComponent = (JComponent)colComponentMap.get(colNode);
        }
        return cellComponent;
    }

    public JComponent[] getAllCellComponents() {
        JComponent[] cellComponents = new JComponent[]{};
        if (this.rowToColMap != null) {
            ArrayList cellComponents_list = new ArrayList();
            Collection colComponentMapCollection = this.rowToColMap.values();
            for (HashMap cellCollection : colComponentMapCollection) {
                for (Object cell : cellCollection.values()) {
                    if (!(cell instanceof Cell)) continue;
                    cellComponents_list.add(cell);
                }
            }
            if (cellComponents_list.size() > 0) {
                cellComponents = cellComponents_list.toArray(cellComponents);
            }
        } else {
            cellComponents = this.componentMap.values().toArray(cellComponents);
        }
        return cellComponents;
    }

    public void dispose() {
        JComponent[] cellComponents = this.getAllCellComponents();
        if (cellComponents != null) {
            for (int ii = 0; ii < cellComponents.length; ++ii) {
                if (!(cellComponents[ii] instanceof Cell)) continue;
                ((Cell)cellComponents[ii]).dispose();
            }
        }
    }

    private void createCellComponents(DataTreeGroupNode[] leafNodes) {
        for (int ii = 0; ii < leafNodes.length; ++ii) {
            DataTreeGroupNode node = leafNodes[ii];
            JComponent cellComponent = this.cellComponentFactory.newCellComponent((TreeNode)node);
            if (cellComponent == null) continue;
            this.contentPanel.add(cellComponent);
            this.componentMap.put(node, cellComponent);
        }
    }

    private void createCellComponents(DataTreeGroupNode[] colLeafNodes, DataTreeGroupNode[] rowLeafNodes) {
        for (int jj = 0; jj < rowLeafNodes.length; ++jj) {
            HashMap<DataTreeGroupNode, JComponent> colComponentMap = new HashMap<DataTreeGroupNode, JComponent>();
            this.rowToColMap.put(rowLeafNodes[jj], colComponentMap);
            for (int ii = 0; ii < colLeafNodes.length; ++ii) {
                JComponent cellComponent = this.cellComponentFactory.newCellComponent((TreeNode)colLeafNodes[ii], (TreeNode)rowLeafNodes[jj]);
                if (cellComponent instanceof Cell) {
                    ((Cell)cellComponent).row = jj;
                    ((Cell)cellComponent).column = ii;
                }
                if (cellComponent == null) continue;
                this.contentPanel.add(cellComponent);
                colComponentMap.put(colLeafNodes[ii], cellComponent);
            }
        }
    }

    public static Map getRowToPreferredHeight(CellPane cellPane) {
        if (cellPane == null) {
            return null;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return null;
        }
        HashMap<DataTreeGroupNode, Integer> rowToPreferredHeight = new HashMap<DataTreeGroupNode, Integer>(rowTreeLeaves == null ? 1 : rowTreeLeaves.length);
        if (colTreeLeaves == null) {
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)rowTreeLeaves[ii]);
                if (cell == null) continue;
                rowToPreferredHeight.put(rowTreeLeaves[ii], new Integer(((Component)cell).getPreferredSize().height));
            }
        } else if (rowTreeLeaves == null) {
            int height = 0;
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                if (cell == null || height >= ((Component)cell).getPreferredSize().height) continue;
                height = ((Component)cell).getPreferredSize().height;
            }
            rowToPreferredHeight.put(null, new Integer(height));
        } else {
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                int height = 0;
                for (int jj = 0; jj < colTreeLeaves.length; ++jj) {
                    JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[jj], (TreeNode)rowTreeLeaves[ii]);
                    if (cell == null || height >= ((Component)cell).getPreferredSize().height) continue;
                    height = ((Component)cell).getPreferredSize().height;
                }
                rowToPreferredHeight.put(rowTreeLeaves[ii], new Integer(height));
            }
        }
        return rowToPreferredHeight;
    }

    public static Map getColumnToPreferredWidth(CellPane cellPane) {
        if (cellPane == null) {
            return null;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return null;
        }
        HashMap<DataTreeGroupNode, Integer> columnToPreferredWidth = new HashMap<DataTreeGroupNode, Integer>(colTreeLeaves == null ? 1 : colTreeLeaves.length);
        if (rowTreeLeaves == null) {
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                if (cell == null) continue;
                columnToPreferredWidth.put(colTreeLeaves[ii], new Integer(((Component)cell).getPreferredSize().width));
            }
        } else if (colTreeLeaves == null) {
            int width = 0;
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)rowTreeLeaves[ii]);
                if (cell == null || width >= ((Component)cell).getPreferredSize().width) continue;
                width = ((Component)cell).getPreferredSize().width;
            }
            columnToPreferredWidth.put(null, new Integer(width));
        } else {
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                int width = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                    if (cell == null || width >= ((Component)cell).getPreferredSize().width) continue;
                    width = ((Component)cell).getPreferredSize().width;
                }
                columnToPreferredWidth.put(colTreeLeaves[ii], new Integer(width));
            }
        }
        return columnToPreferredWidth;
    }

    public static Dimension getPreferredSize(CellPane cellPane) {
        int ii;
        Dimension preferredSize = new Dimension(0, 0);
        if (cellPane == null) {
            return preferredSize;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return preferredSize;
        }
        Map columnToPreferredWidth = CellPane.getColumnToPreferredWidth(cellPane);
        Map rowToPreferredHeight = CellPane.getRowToPreferredHeight(cellPane);
        if (columnToPreferredWidth == null || rowToPreferredHeight == null) {
            return preferredSize;
        }
        if (colTreeLeaves != null) {
            for (ii = 0; ii < colTreeLeaves.length; ++ii) {
                Integer width = (Integer)columnToPreferredWidth.get(colTreeLeaves[ii]);
                if (width == null) continue;
                preferredSize.width += width.intValue();
            }
        } else {
            Integer width = (Integer)columnToPreferredWidth.get(null);
            if (width != null) {
                preferredSize.width += width.intValue();
            }
        }
        if (rowTreeLeaves != null) {
            for (ii = 0; ii < rowTreeLeaves.length; ++ii) {
                Integer height = (Integer)rowToPreferredHeight.get(rowTreeLeaves[ii]);
                if (height == null) continue;
                preferredSize.height += height.intValue();
            }
        } else {
            Integer height = (Integer)rowToPreferredHeight.get(null);
            if (height != null) {
                preferredSize.height += height.intValue();
            }
        }
        return preferredSize;
    }

    public static Map getRowToMinimumHeight(CellPane cellPane) {
        if (cellPane == null) {
            return null;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return null;
        }
        HashMap<DataTreeGroupNode, Integer> rowToMinimumHeight = new HashMap<DataTreeGroupNode, Integer>(rowTreeLeaves == null ? 1 : rowTreeLeaves.length);
        if (colTreeLeaves == null) {
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)rowTreeLeaves[ii]);
                if (cell == null) continue;
                rowToMinimumHeight.put(rowTreeLeaves[ii], new Integer(((Component)cell).getMinimumSize().height));
            }
        } else if (rowTreeLeaves == null) {
            int height = 0;
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                if (cell == null || height >= ((Component)cell).getMinimumSize().height) continue;
                height = ((Component)cell).getMinimumSize().height;
            }
            rowToMinimumHeight.put(null, new Integer(height));
        } else {
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                int height = 0;
                for (int jj = 0; jj < colTreeLeaves.length; ++jj) {
                    JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[jj], (TreeNode)rowTreeLeaves[ii]);
                    if (cell == null || height >= ((Component)cell).getMinimumSize().height) continue;
                    height = ((Component)cell).getMinimumSize().height;
                }
                rowToMinimumHeight.put(rowTreeLeaves[ii], new Integer(height));
            }
        }
        return rowToMinimumHeight;
    }

    public static Map getColumnToMinimumWidth(CellPane cellPane) {
        if (cellPane == null) {
            return null;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return null;
        }
        HashMap<DataTreeGroupNode, Integer> columnToMinimumWidth = new HashMap<DataTreeGroupNode, Integer>(colTreeLeaves == null ? 1 : colTreeLeaves.length);
        if (rowTreeLeaves == null) {
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                if (cell == null) continue;
                columnToMinimumWidth.put(colTreeLeaves[ii], new Integer(((Component)cell).getMinimumSize().width));
            }
        } else if (colTreeLeaves == null) {
            int width = 0;
            for (int ii = 0; ii < rowTreeLeaves.length; ++ii) {
                JComponent cell = cellPane.getCellComponent((TreeNode)rowTreeLeaves[ii]);
                if (cell == null || width >= ((Component)cell).getMinimumSize().width) continue;
                width = ((Component)cell).getMinimumSize().width;
            }
            columnToMinimumWidth.put(null, new Integer(width));
        } else {
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                int width = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent cell = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                    if (cell == null || width >= ((Component)cell).getMinimumSize().width) continue;
                    width = ((Component)cell).getMinimumSize().width;
                }
                columnToMinimumWidth.put(colTreeLeaves[ii], new Integer(width));
            }
        }
        return columnToMinimumWidth;
    }

    public static Dimension getMinimumSize(CellPane cellPane) {
        int ii;
        Dimension minimumSize = new Dimension(0, 0);
        if (cellPane == null) {
            return minimumSize;
        }
        DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
        DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
        if (rowTreeLeaves == null && colTreeLeaves == null) {
            return minimumSize;
        }
        Map columnToMinimumWidth = CellPane.getColumnToMinimumWidth(cellPane);
        Map rowToMinimumHeight = CellPane.getRowToMinimumHeight(cellPane);
        if (columnToMinimumWidth == null || rowToMinimumHeight == null) {
            return minimumSize;
        }
        if (colTreeLeaves != null) {
            for (ii = 0; ii < colTreeLeaves.length; ++ii) {
                Integer width = (Integer)columnToMinimumWidth.get(colTreeLeaves[ii]);
                if (width == null) continue;
                minimumSize.width += width.intValue();
            }
        } else {
            Integer width = (Integer)columnToMinimumWidth.get(null);
            if (width != null) {
                minimumSize.width += width.intValue();
            }
        }
        if (rowTreeLeaves != null) {
            for (ii = 0; ii < rowTreeLeaves.length; ++ii) {
                Integer height = (Integer)rowToMinimumHeight.get(rowTreeLeaves[ii]);
                if (height == null) continue;
                minimumSize.height += height.intValue();
            }
        } else {
            Integer height = (Integer)rowToMinimumHeight.get(null);
            if (height != null) {
                minimumSize.height += height.intValue();
            }
        }
        return minimumSize;
    }

    public static Dimension getUniformPreferredSize(CellPane cellPane) {
        if (cellPane != null) {
            DataTreeGroupNode root;
            Dimension preferredSize = HierarchicalPane.getMaxContentPanelComponentPreferredSize(cellPane);
            int columnLeafCount = 1;
            int rowLeafCount = 1;
            ValueTree columnTree = cellPane.getColumnTree();
            ValueTree rowTree = cellPane.getRowTree();
            if (columnTree != null) {
                root = (DataTreeGroupNode)columnTree.getRoot();
                columnLeafCount = root.getLeafCount();
            }
            if (rowTree != null) {
                root = (DataTreeGroupNode)rowTree.getRoot();
                rowLeafCount = root.getLeafCount();
            }
            return new Dimension(columnLeafCount * preferredSize.width, rowLeafCount * preferredSize.height);
        }
        return new Dimension(0, 0);
    }

    public static void doLayout(CellPane cellPane, AlignableComponentConstraints constraints, int transX, int transY) {
        if (cellPane != null && constraints != null && constraints.getBounds() != null) {
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
            Rectangle constraintBounds = constraints.getBounds();
            int width = constraintBounds.width;
            int height = constraintBounds.height;
            if (colTreeLeaves != null && rowTreeLeaves != null) {
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                        JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                        if (cellComponent == null) continue;
                        constraintBounds.x = ii * width;
                        constraintBounds.y = jj * height;
                        AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(constraints));
                    }
                }
                cellPane.setContentPanelBounds(transX, transY, colTreeLeaves.length * width, rowTreeLeaves.length * height);
            } else if (colTreeLeaves != null) {
                constraintBounds.y = 0;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                    if (cellComponent == null) continue;
                    constraintBounds.x = ii * width;
                    AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(constraints));
                }
                cellPane.setContentPanelBounds(transX, transY, colTreeLeaves.length * width, height);
            } else if (rowTreeLeaves != null) {
                constraintBounds.x = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent cellComponent = cellPane.getCellComponent((TreeNode)rowTreeLeaves[jj]);
                    if (cellComponent == null) continue;
                    constraintBounds.y = jj * height;
                    AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(constraints));
                }
                cellPane.setContentPanelBounds(transX, transY, width, rowTreeLeaves.length * height);
            }
            cellPane._applyFrame();
        }
    }

    public static void doLayoutByColumn(CellPane cellPane, AlignableComponentConstraints constraints, Map columnToColumnWidth, int transX, int transY) {
        if (cellPane != null && constraints != null && constraints.getBounds() != null && columnToColumnWidth != null) {
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
            int height = constraints.getBounds().height;
            if (colTreeLeaves != null && rowTreeLeaves != null) {
                int x = 0;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    Integer width = (Integer)columnToColumnWidth.get(colTreeLeaves[ii]);
                    if (width == null) continue;
                    AlignableComponentConstraints columnConstraints = new AlignableComponentConstraints(constraints);
                    Rectangle constraintBounds = columnConstraints.getBounds();
                    constraintBounds.width = width;
                    for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                        JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                        if (cellComponent == null) continue;
                        constraintBounds.x = x;
                        constraintBounds.y = jj * height;
                        AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(columnConstraints));
                    }
                    x += constraintBounds.width;
                }
                cellPane.setContentPanelBounds(transX, transY, x, rowTreeLeaves.length * height);
            } else if (colTreeLeaves != null) {
                int x = 0;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    Integer width = (Integer)columnToColumnWidth.get(colTreeLeaves[ii]);
                    if (width == null) continue;
                    AlignableComponentConstraints columnConstraints = new AlignableComponentConstraints(constraints);
                    Rectangle constraintBounds = columnConstraints.getBounds();
                    constraintBounds.width = width;
                    JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii]);
                    if (cellComponent != null) {
                        constraintBounds.x = x;
                        constraintBounds.y = 0;
                        AlignableComponentConstraints.setConstraints(cellComponent, columnConstraints);
                    }
                    x += constraintBounds.width;
                }
                cellPane.setContentPanelBounds(transX, transY, x, height);
            }
            cellPane._applyFrame();
        }
    }

    public static void doLayoutByRow(CellPane cellPane, AlignableComponentConstraints constraints, Map rowToRowHeight, int transX, int transY) {
        if (cellPane != null && constraints != null && constraints.getBounds() != null && rowToRowHeight != null) {
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
            int width = constraints.getBounds().width;
            if (colTreeLeaves != null && rowTreeLeaves != null) {
                int y = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    Integer height = (Integer)rowToRowHeight.get(rowTreeLeaves[jj]);
                    if (height == null) continue;
                    AlignableComponentConstraints columnConstraints = new AlignableComponentConstraints(constraints);
                    Rectangle constraintBounds = columnConstraints.getBounds();
                    constraintBounds.height = height;
                    for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                        JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                        if (cellComponent == null) continue;
                        constraintBounds.x = ii * width;
                        constraintBounds.y = y;
                        AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(columnConstraints));
                    }
                    y += constraintBounds.height;
                }
                cellPane.setContentPanelBounds(transX, transY, colTreeLeaves.length * width, y);
            } else if (rowTreeLeaves != null) {
                int y = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    Integer height = (Integer)rowToRowHeight.get(rowTreeLeaves[jj]);
                    if (height == null) continue;
                    AlignableComponentConstraints columnConstraints = new AlignableComponentConstraints(constraints);
                    Rectangle constraintBounds = columnConstraints.getBounds();
                    constraintBounds.height = height;
                    JComponent cellComponent = cellPane.getCellComponent((TreeNode)rowTreeLeaves[jj]);
                    if (cellComponent != null) {
                        constraintBounds.y = y;
                        constraintBounds.x = 0;
                        AlignableComponentConstraints.setConstraints(cellComponent, columnConstraints);
                    }
                    y += constraintBounds.height;
                }
                cellPane.setContentPanelBounds(transX, transY, width, y);
            }
            cellPane._applyFrame();
        }
    }

    public static void doLayoutByColumnAndRow(CellPane cellPane, AlignableComponentConstraints constraints, Map columnToColumnWidth, Map rowToRowHeight, int transX, int transY) {
        if (cellPane != null && constraints != null && constraints.getBounds() != null && columnToColumnWidth != null && rowToRowHeight != null) {
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree());
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(cellPane.getRowTree());
            if (colTreeLeaves == null) {
                colTreeLeaves = new DataTreeGroupNode[]{null};
            }
            if (rowTreeLeaves == null) {
                rowTreeLeaves = new DataTreeGroupNode[]{null};
            }
            Dimension contentPanelBounds = new Dimension(0, 0);
            int y = 0;
            for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                Integer height = (Integer)rowToRowHeight.get(rowTreeLeaves[jj]);
                if (height == null) continue;
                int x = 0;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    Integer width = (Integer)columnToColumnWidth.get(colTreeLeaves[ii]);
                    if (width == null) continue;
                    JComponent cellComponent = cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                    if (cellComponent != null) {
                        AlignableComponentConstraints columnConstraints = new AlignableComponentConstraints(constraints);
                        Rectangle constraintBounds = columnConstraints.getBounds();
                        constraintBounds.height = height;
                        constraintBounds.width = width;
                        constraintBounds.x = x;
                        constraintBounds.y = y;
                        AlignableComponentConstraints.setConstraints(cellComponent, new AlignableComponentConstraints(columnConstraints));
                    }
                    if (contentPanelBounds.width >= (x += width.intValue())) continue;
                    contentPanelBounds.width = x;
                }
                if (contentPanelBounds.height >= (y += height.intValue())) continue;
                contentPanelBounds.height = y;
            }
            cellPane.setContentPanelBounds(transX, transY, contentPanelBounds.width, contentPanelBounds.height);
            cellPane._applyFrame();
        }
    }

    private void _applyFrame() {
        block7: {
            DataTreeGroupNode[] rowTreeLeaves;
            int frameThicknessYDiv2R;
            int frameThicknessYDiv2;
            int frameThicknessY;
            int frameThicknessX;
            block8: {
                DataTreeGroupNode[] colTreeLeaves;
                int frameThicknessXDiv2R;
                int frameThicknessXDiv2;
                block6: {
                    if (this.frameLineStyle == null || this.frameLineStyle.getVisibilityPolicy() == 10202) {
                        return;
                    }
                    frameThicknessX = (int)this.frameLineStyle.getThickness().getMagnitude((Object)"px");
                    frameThicknessY = (int)this.frameLineStyle.getThickness().getMagnitude((Object)"py");
                    frameThicknessXDiv2 = frameThicknessX / 2;
                    frameThicknessYDiv2 = frameThicknessY / 2;
                    frameThicknessXDiv2R = frameThicknessX - frameThicknessXDiv2;
                    frameThicknessYDiv2R = frameThicknessY - frameThicknessYDiv2;
                    colTreeLeaves = GTKUtil.getLeafNodes(this.getColumnTree());
                    rowTreeLeaves = GTKUtil.getLeafNodes(this.getRowTree());
                    if (colTreeLeaves == null || rowTreeLeaves == null) break block6;
                    if (this.frameLineStyle.getVisibilityPolicy() != 10201 && colTreeLeaves.length * rowTreeLeaves.length <= 1) break block7;
                    for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                        for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                            JComponent cellComponent = this.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                            if (cellComponent == null) continue;
                            int t = jj == 0 ? frameThicknessY : frameThicknessYDiv2;
                            int b = jj == rowTreeLeaves.length - 1 ? frameThicknessY : frameThicknessYDiv2R;
                            int l = ii == 0 ? frameThicknessX : frameThicknessXDiv2;
                            int r = ii == colTreeLeaves.length - 1 ? frameThicknessX : frameThicknessXDiv2R;
                            MatteBorder border = new MatteBorder(t, l, b, r, this.frameLineStyle.getColor());
                            cellComponent.setBorder(border);
                        }
                    }
                    break block7;
                }
                if (colTreeLeaves == null) break block8;
                if (this.frameLineStyle.getVisibilityPolicy() != 10201 && colTreeLeaves.length <= 1) break block7;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    JComponent cellComponent = this.getCellComponent((TreeNode)colTreeLeaves[ii]);
                    if (cellComponent == null) continue;
                    int t = frameThicknessY;
                    int b = frameThicknessY;
                    int l = ii == 0 ? frameThicknessX : frameThicknessXDiv2;
                    int r = ii == colTreeLeaves.length - 1 ? frameThicknessX : frameThicknessXDiv2R;
                    MatteBorder border = new MatteBorder(t, l, b, r, this.frameLineStyle.getColor());
                    cellComponent.setBorder(border);
                }
                break block7;
            }
            if (rowTreeLeaves != null && (this.frameLineStyle.getVisibilityPolicy() == 10201 || rowTreeLeaves.length > 1)) {
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent cellComponent = this.getCellComponent((TreeNode)rowTreeLeaves[jj]);
                    if (cellComponent == null) continue;
                    int t = jj == 0 ? frameThicknessY : frameThicknessYDiv2;
                    int b = jj == rowTreeLeaves.length - 1 ? frameThicknessY : frameThicknessYDiv2R;
                    int l = frameThicknessX;
                    int r = frameThicknessX;
                    MatteBorder border = new MatteBorder(t, l, b, r, this.frameLineStyle.getColor());
                    cellComponent.setBorder(border);
                }
            }
        }
    }

    public static interface CellComponentFactory {
        public JComponent newCellComponent(TreeNode var1);

        public JComponent newCellComponent(TreeNode var1, TreeNode var2);
    }

    public static class DefaultCellComponentFactory
    implements CellComponentFactory {
        private Channel channel;

        public DefaultCellComponentFactory(Channel channel) {
            this.channel = channel;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode) {
                return new StringComponent(this.stringValue(node), this.channel);
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(TreeNode colNode, TreeNode rowNode) {
            if (colNode != null && rowNode != null) {
                return new StringComponent(this.stringValue(colNode) + ", " + this.stringValue(rowNode), this.channel);
            }
            if (colNode != null) {
                return this.newCellComponent(colNode);
            }
            if (rowNode != null) {
                return this.newCellComponent(rowNode);
            }
            return null;
        }

        private String stringValue(TreeNode node) {
            if (node instanceof DataTreeGroupNode) {
                String displayValue = ((DataTreeGroupNode)node).getFormattedValue();
                if (displayValue == null) {
                    displayValue = ((DataTreeGroupNode)node).getValue().toString();
                }
                return displayValue;
            }
            return "node";
        }
    }

    public static interface CellConstraintsFactory {
        public AlignableComponentConstraints newCellConstraints(TreeNode var1);
    }
}

