/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.PickInfo;
import com.sas.graphics.util.cell.CellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.NetworkComponent;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.gl.Channel;
import java.awt.Graphics;
import java.util.ArrayList;

public abstract class Cell
extends NetworkComponent {
    private transient CellModel cellModel;
    private transient boolean constructionNeeded;
    transient int row = -1;
    transient int column = -1;

    public Cell(CellModel newModel, Channel channel) {
        this(newModel, 2, channel);
    }

    public Cell(CellModel newModel, int displayMode, Channel channel) {
        super(displayMode, channel);
        this.cellModel = newModel;
        this.init();
    }

    private void init() {
        if (this.cellModel != null) {
            if (this.cellModel.getAntialiasedGraphics() != null) {
                this.setAntiAliasingEnabled(this.cellModel.getAntialiasedGraphics());
            }
            if (this.cellModel.getAntialiasedText() != null) {
                this.setTextAntiAliasingEnabled(this.cellModel.getAntialiasedText());
            }
        }
        this.constructionNeeded = true;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    protected SimpleModelInterface getModel() {
        return this.cellModel;
    }

    public void reconstruct() {
        this.constructionNeeded = true;
        this.invalidateBuffer();
    }

    @Override
    public void paint(Graphics g) {
        if (this.constructionNeeded) {
            this.getComposite().removeAllElements();
            this.construct();
            this.constructionNeeded = false;
        }
        super.paint(g);
    }

    public abstract DataSource getDataSource();

    @Override
    public void dispose() {
        DataSource ds = this.getDataSource();
        if (ds != null) {
            ds.dispose();
        }
        super.dispose();
    }

    public int[] getSelectedIndexes() {
        DataSource sds = this.getDataSource();
        return sds != null ? sds.getSelectedIndexes() : null;
    }

    public PickInfo[] pickSelected() {
        int[] selectedIndexes = this.getSelectedIndexes();
        if (selectedIndexes == null || selectedIndexes.length < 1) {
            return null;
        }
        ArrayList<PickInfo> al = new ArrayList<PickInfo>(selectedIndexes.length);
        for (int ii = 0; ii < selectedIndexes.length; ++ii) {
            al.add(this.createPickInfo(0, 0, selectedIndexes[ii]));
        }
        return al.toArray(new PickInfo[0]);
    }

    protected abstract void construct();

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.reconstruct();
    }
}

