/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TickStyle;
import com.sas.graphics.util.ContinuousTickSpacer;
import com.sas.graphics.util.DateTimeTickSpacer;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.CellModel;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModel;
import com.sas.graphics.util.cell.SimplePropertyBag;
import com.sas.graphics.util.cell.SimplePropertyBagInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.measures.BaseLength;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;

public class AxisCellModel
extends CellModel {
    public static final String RB_KEY = "AxisCellModel.";
    public static final Object ADJUSTMENT_FACTOR = "adjustValueMagnitudeFactor";
    public static final Object MIN_VALUE = "minValue";
    public static final Object MAX_VALUE = "maxValue";
    public static final Object ORIGIN = "origin";
    public static final Object LENGTH = "length";
    public static final Object VISIBLE = "visible";
    public static final Object AXIS_COLOR = "axisColor";
    public static final Object AXIS_ORIENTATION = "axisOrientation";
    public static final Object MAJOR_TICK_INTERVAL = "majorTickInterval";
    public static final Object MINOR_TICK_COUNT = "minorTickCount";
    public static final Object VALUE_COUNT = "valueCount";
    public static final Object MAX_VALUE_COUNT = "maxValueCount";
    public static final Object VALUE_COLOR = "valueColor";
    public static final Object VALUES = "values";
    public static final Object VALUE_LABELS = "valueLabels";
    public static final Object TITLE_COLOR = "titleColor";
    public static final Object REFERENCE_LINES_VISIBLE = "referenceLinesVisible";
    public static final Object MAJOR_TICK_VISIBLE = "majorTickVisible";
    public static final Object MINOR_TICK_VISIBLE = "minorTickVisible";
    public static final Object ZOOMSCROLLBARS_VISIBLE = "zoomscrollbarsVisible";
    public static final Object MAPPER = "mapper";
    public static final Object CAT_AXIS_ADJ = "catAxisAdj";
    public static final Object RES_AXIS_ADJ = "resAxisAdj";
    public static final Object MARGIN = "margin";
    public static final Object PREFERRED_MARGIN = "prefMargin";
    public static final Object PREFERRED_LENGTH = "prefLength";
    public static final Object IDEAL_PREFERRED_LENGTH = "minPrefLength";
    public static final Object MINIMUM_MARGIN = "minMargin";
    public static final Object TITLE_ON = "titleOn";
    public static final Object TITLE_ANGLE = "titleAngle";
    public static final Object TITLE = "title";
    public static final Object TITLE_ADDITION = "titleAddition";
    public static final Object PRIMARY = "primary";
    public static final Object EXTEND_TO_MARGIN = "extendToMargin";
    public static final Object EXTEND_TO_END_MARGIN = "extendToEndMargin";
    public static final Object EXTEND_TO_START_MARGIN = "extendToStartMargin";
    public static final Object MAXIMIZE_SPACE = "maximizeSpace";
    public static final Object FIT_ALGORITHM = "fitAlgorithm";
    public static final Object FIT_ALGORITHM_USED = "fitAlgorithmUsed";
    public static final Object FIT_ALGORITHM_FORCED = "fitAlgorithmForced";
    public static final Object DEPTH = "depth";
    public static final Object TITLE_WIDTH = "titleWdith";
    public static final Object TITLE_HEIGHT = "titleHeight";
    public static final Object TITLE_BREAK = "titleBreak";
    public static final Object REUSE_PREFERRED_SIZE = "reusePrefSize";
    public static final Object DRILLDOWN_MARKER = "drilldownMarker";
    public static final Object MAXIMUM_SIZE = "maximumSIze";
    public static final Object FORMAT_STATE = "formatState";
    public static final Object CELL_COUNT = "cellCount";
    public static final Object LOCALE = "locale";
    public static final Object REVERSE = "reverse";
    public static final Object USE_RISK_MAP_DEFAULTS = "useRiskMapDefaults";
    public static final Object RANGE_VALUES = "rangeValues";
    private static final Object DATETIME_VALUES = "datetimeValues";
    public static final Object SMALLEST_VALUE_FONT_USED = "smallestValueFontUsed";
    public static final Object VALUE_FONT_FORCED = "valueFontForced";
    public static final Object AXIS_MODEL = "axisModel";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    static final String[] HORZ_FIT_BEST_ALG = new String[]{"split", "stagger", "angle90truncateshrink", "nolabels"};
    static final String[] HORZ_FIT_FAST_ALG = new String[]{"stagger", "nolabels"};
    static final String[] HORZ_FIT_ROTATE_ALG = new String[]{"angle315", "angle90", "nolabels"};
    static final String[] HORZ_FIT_BEST_NO_THIN_ALG = new String[]{"split", "stagger", "angle90truncateshrink", "nolabels"};
    static final String[] HORZ_FIT_DASHBOARD_ALG = new String[]{"split", "stagger", "staggertruncateshrink"};
    static final String[] VERT_FIT_BEST_ALG = new String[]{"shrinktruncate", "nolabels"};
    static final String[] VERT_FIT_FAST_ALG = new String[]{"shrink", "nolabels"};
    static final String[] VERT_FIT_ROTATE_ALG = VERT_FIT_BEST_ALG;
    static final String[] VERT_FIT_BEST_NO_THIN_ALG = new String[]{"shrinktruncate", "nolabels"};
    static final String[] VERT_FIT_DASHBOARD_ALG = new String[]{"shrinktruncate"};
    static final String[] CONT_FIT_BEST_ALG = new String[]{"thinkeependshrink"};
    static final String[] CONT_FIT_FAST_ALG = new String[]{"thinkeepend", "nolabels"};
    static final String[] CONT_FIT_ROTATE_ALG = new String[]{"angle315", "angle90", "thinkeependshrink"};
    static final String[] CONT_FIT_BEST_NO_THIN_ALG = CONT_FIT_BEST_ALG;
    static final String[] CONT_FIT_DASHBOARD_ALG = new String[]{"thinkeependshrink"};
    static final String[] CONT2_FIT_BEST_ALG = new String[]{"shrinkthinkeepend"};
    static final String[] CONT2_FIT_FAST_ALG = new String[]{"shrink", "nolabels"};
    static final String[] CONT2_FIT_ROTATE_ALG = CONT2_FIT_BEST_ALG;
    static final String[] CONT2_FIT_BEST_NO_THIN_ALG = CONT2_FIT_BEST_ALG;
    static final String[] CONT2_FIT_DASHBOARD_ALG = CONT_FIT_DASHBOARD_ALG;
    private int titlePlacement = 11306;
    private boolean computeTitleHeight = true;
    private boolean computeTitleWidth = true;
    private double embeddedEndMargin = 0.0;
    private boolean invalidRange = false;
    private HashMap axes = new HashMap();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int _labelCount = 0;
    private static final long MAXLongForIntergerTicks = 0xCCCCCCCCCCCCCCCL;
    private static final long MINLongForIntergerTicks = -922337203685477580L;

    private AxisCellModel(SimplePropertyBagInterface delegate) {
        super(delegate);
    }

    public AxisCellModel() {
        this.propertyDefaults = new SimplePropertyBag();
        AxisCellModel defaultsModel = new AxisCellModel(this.propertyDefaults);
        defaultsModel.setAxisVisible(Boolean.TRUE);
        defaultsModel.setAxisColor(Color.black);
        defaultsModel.setAxisOrientation(NORTH);
        defaultsModel.setReferenceLinesVisible(Boolean.TRUE);
        defaultsModel.setValueColor(Color.black);
        defaultsModel.setTitleColor(Color.black);
        defaultsModel.setCatAxisAdj(new Double(0.0));
        defaultsModel.setResAxisAdj(new Double(0.0));
        defaultsModel.setMargin(new Dimension(5, 8));
        defaultsModel.setMinimumMargin(new Dimension(1, 1));
        defaultsModel.setPreferredMargin(new Dimension(5, 8));
        defaultsModel.setReusePreferredSize(Boolean.FALSE);
        defaultsModel.setPreferredLength(new Double(0.0));
        defaultsModel.setIdealPreferredLength(new Double(0.0));
        defaultsModel.setMajorTickInterval(new Double(0.0));
        defaultsModel.setMinorTickCount(new Integer(0));
        defaultsModel.setTitleOn(Boolean.FALSE);
        defaultsModel.setTitleAngle(new Double(0.0));
        defaultsModel.setValueCount(new Integer(0));
        defaultsModel.setLength(new Double(0.0));
        defaultsModel.setOrigin(new Double(0.0));
        defaultsModel.setPrimary(Boolean.TRUE);
        defaultsModel.setExtendToMargin(Boolean.TRUE);
        defaultsModel.setExtendToEndMargin(Boolean.FALSE);
        defaultsModel.setExtendToStartMargin(Boolean.FALSE);
        defaultsModel.setMaximizeSpace(Boolean.TRUE);
        defaultsModel.setTitleWidth(new Double(0.0));
        defaultsModel.setTitleHeight(new Double(0.0));
        defaultsModel.setMaximumSize(new Vec3d(1.0, 1.0, 0.0));
        defaultsModel.setLocale(Locale.getDefault());
        defaultsModel.setUseRiskMapDefaults(new Boolean(false));
        defaultsModel.setAdjustValueMagnitudeFactor(new Double(Double.NaN));
        defaultsModel.setForceFitAlgorithm(null);
        defaultsModel.setValueFontForced(null);
        defaultsModel.setDateTimeValues(null);
        defaultsModel = null;
    }

    public AxisCellModel(SimplePropertyBagInterface delegate, SimpleModel ancestor) {
        super(delegate, ancestor);
        this.propertyDefaults = ancestor.propertyDefaults;
    }

    public void setReverse(Boolean v) {
        this.properties.set(REVERSE, v);
    }

    public Boolean getReverse() {
        return SimplePropertyBag.Util.getBoolean(this.properties, REVERSE, this.propertyDefaults);
    }

    private boolean isReverse() {
        Boolean reverseObj = this.getReverse();
        boolean reverse = reverseObj != null ? reverseObj : false;
        return reverse != this.getAxisModel().isReverseDirection();
    }

    public void setAxisVisible(Boolean v) {
        this.properties.set(VISIBLE, v);
    }

    public Boolean getAxisVisible() {
        return SimplePropertyBag.Util.getBoolean(this.properties, VISIBLE, this.propertyDefaults);
    }

    public void setAxisColor(Color v) {
        this.properties.set(AXIS_COLOR, v);
    }

    public Color getAxisColor() {
        return SimplePropertyBag.Util.getColor(this.properties, AXIS_COLOR, this.propertyDefaults);
    }

    public void setAxisOrientation(String v) {
        this.properties.set(AXIS_ORIENTATION, v);
    }

    public String getAxisOrientation() {
        return SimplePropertyBag.Util.getString(this.properties, AXIS_ORIENTATION, this.propertyDefaults);
    }

    public void setReferenceLinesVisible(Boolean v) {
        this.properties.set(REFERENCE_LINES_VISIBLE, v);
    }

    public Boolean getReferenceLinesVisible() {
        return SimplePropertyBag.Util.getBoolean(this.properties, REFERENCE_LINES_VISIBLE, this.propertyDefaults);
    }

    public void setMajorTickVisible(Boolean v) {
        this.properties.set(MAJOR_TICK_VISIBLE, v);
    }

    public Boolean getMajorTickVisible() {
        return SimplePropertyBag.Util.getBoolean(this.properties, MAJOR_TICK_VISIBLE, this.propertyDefaults);
    }

    public void setMinorTickVisible(Boolean v) {
        this.properties.set(MINOR_TICK_VISIBLE, v);
    }

    public Boolean getMinorTickVisible() {
        return SimplePropertyBag.Util.getBoolean(this.properties, MINOR_TICK_VISIBLE, this.propertyDefaults);
    }

    public void setZoomScrollBarsVisible(Boolean v) {
        this.properties.set(ZOOMSCROLLBARS_VISIBLE, v);
    }

    public Boolean getZoomScrollBarsVisible() {
        return SimplePropertyBag.Util.getBoolean(this.properties, ZOOMSCROLLBARS_VISIBLE, this.propertyDefaults);
    }

    public void setOrigin(Double v) {
        this.properties.set(ORIGIN, v);
    }

    public Double getOrigin() {
        return SimplePropertyBag.Util.getDouble(this.properties, ORIGIN, this.propertyDefaults);
    }

    public void setLength(Double v) {
        this.properties.set(LENGTH, v);
    }

    public Double getLength() {
        return SimplePropertyBag.Util.getDouble(this.properties, LENGTH, this.propertyDefaults);
    }

    public void setMinimumValue(Double v) {
        this.properties.set(MIN_VALUE, v);
    }

    public Double getMinimumValue() {
        return SimplePropertyBag.Util.getDouble(this.properties, MIN_VALUE, this.propertyDefaults);
    }

    public void setMaximumValue(Double v) {
        this.properties.set(MAX_VALUE, v);
    }

    public Double getMaximumValue() {
        return SimplePropertyBag.Util.getDouble(this.properties, MAX_VALUE, this.propertyDefaults);
    }

    public void setAdjustValueMagnitudeFactor(Double v) {
        this.properties.set(ADJUSTMENT_FACTOR, v);
    }

    public Double getAdjustValueMagnitudeFactor() {
        return SimplePropertyBag.Util.getDouble(this.properties, ADJUSTMENT_FACTOR, this.propertyDefaults);
    }

    public void setMajorTickInterval(Double v) {
        this.properties.set(MAJOR_TICK_INTERVAL, v);
    }

    public Double getMajorTickInterval() {
        return SimplePropertyBag.Util.getDouble(this.properties, MAJOR_TICK_INTERVAL, this.propertyDefaults);
    }

    public void setMinorTickCount(Integer v) {
        this.properties.set(MINOR_TICK_COUNT, v);
    }

    public Integer getMinorTickCount() {
        return SimplePropertyBag.Util.getInteger(this.properties, MINOR_TICK_COUNT, this.propertyDefaults);
    }

    public void setValueCount(Integer v) {
        this.properties.set(VALUE_COUNT, v);
    }

    public Integer getValueCount() {
        return SimplePropertyBag.Util.getInteger(this.properties, VALUE_COUNT, this.propertyDefaults);
    }

    public void setMaximumValueCount(Integer v) {
        this.properties.set(MAX_VALUE_COUNT, v);
    }

    public Integer getMaximumValueCount() {
        return SimplePropertyBag.Util.getInteger(this.properties, MAX_VALUE_COUNT, this.propertyDefaults);
    }

    public void setValueColor(Color v) {
        this.properties.set(VALUE_COLOR, v);
    }

    public Color getValueColor() {
        return SimplePropertyBag.Util.getColor(this.properties, VALUE_COLOR, this.propertyDefaults);
    }

    public void setValues(NumericPipe values) {
        this.properties.set(VALUES, values);
    }

    public NumericPipe getValues() {
        return (NumericPipe)SimplePropertyBag.Util.getObject(this.properties, VALUES, this.propertyDefaults, NumericPipe.class);
    }

    public void setValueLabels(StringPipe values) {
        this.properties.set(VALUE_LABELS, values);
    }

    public StringPipe getValueLabels() {
        return (StringPipe)SimplePropertyBag.Util.getObject(this.properties, VALUE_LABELS, this.propertyDefaults, StringPipe.class);
    }

    public void setTitleColor(Color v) {
        this.properties.set(TITLE_COLOR, v);
    }

    public Color getTitleColor() {
        return SimplePropertyBag.Util.getColor(this.properties, TITLE_COLOR, this.propertyDefaults);
    }

    public void setMapper(NumericMapper numericMapper) {
        this.properties.set(MAPPER, numericMapper);
    }

    public NumericMapper getMapper() {
        return (NumericMapper)SimplePropertyBag.Util.getObject(this.properties, MAPPER, this.propertyDefaults, NumericMapper.class);
    }

    public void setUseRiskMapDefaults(Boolean v) {
        this.properties.set(USE_RISK_MAP_DEFAULTS, v);
    }

    public Boolean getUseRiskMapDefaults() {
        return SimplePropertyBag.Util.getBoolean(this.properties, USE_RISK_MAP_DEFAULTS, this.propertyDefaults);
    }

    public void setRangeValues(Object v) {
        this.properties.set(RANGE_VALUES, v);
    }

    public Object getRangeValues() {
        return SimplePropertyBag.Util.getObject(this.properties, RANGE_VALUES, this.propertyDefaults);
    }

    private void setDateTimeValues(Object v) {
        this.properties.set(DATETIME_VALUES, v);
    }

    private Object getDateTimeValues() {
        return SimplePropertyBag.Util.getObject(this.properties, DATETIME_VALUES, this.propertyDefaults);
    }

    public void setResAxisAdj(Double v) {
        Double old = (Double)this.properties.get(RES_AXIS_ADJ);
        if (v != null && !v.equals(old)) {
            this.properties.set(RES_AXIS_ADJ, v);
            this.propertyChangeSupport.firePropertyChange("ResAxisAdj", old, v);
        }
    }

    public Double getResAxisAdj() {
        return SimplePropertyBag.Util.getDouble(this.properties, RES_AXIS_ADJ, this.propertyDefaults);
    }

    public void setCatAxisAdj(Double v) {
        Double old = (Double)this.properties.get(CAT_AXIS_ADJ);
        if (v != null && !v.equals(old)) {
            this.properties.set(CAT_AXIS_ADJ, v);
            this.propertyChangeSupport.firePropertyChange("CatAxisAdj", old, v);
        }
    }

    public Double getCatAxisAdj() {
        return SimplePropertyBag.Util.getDouble(this.properties, CAT_AXIS_ADJ, this.propertyDefaults);
    }

    public void setMargin(Dimension v) {
        this.properties.set(MARGIN, v);
    }

    public Dimension getMargin() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, MARGIN, this.propertyDefaults, Dimension.class);
    }

    public void setPreferredMargin(Dimension v) {
        this.properties.set(PREFERRED_MARGIN, v);
    }

    public Dimension getPreferredMargin() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, PREFERRED_MARGIN, this.propertyDefaults, Dimension.class);
    }

    public void setMinimumMargin(Dimension v) {
        this.properties.set(MINIMUM_MARGIN, v);
    }

    public Dimension getMinimumMargin() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, MINIMUM_MARGIN, this.propertyDefaults, Dimension.class);
    }

    public void setTitleOn(Boolean v) {
        this.properties.set(TITLE_ON, v);
    }

    public Boolean getTitleOn() {
        return SimplePropertyBag.Util.getBoolean(this.properties, TITLE_ON, this.propertyDefaults);
    }

    public void setTitleAngle(Double v) {
        this.properties.set(TITLE_ANGLE, v);
    }

    public Double getTitleAngle() {
        return SimplePropertyBag.Util.getDouble(this.properties, TITLE_ANGLE, this.propertyDefaults);
    }

    public void setTitle(String v) {
        this.properties.set(TITLE, v);
    }

    public String getTitle() {
        return SimplePropertyBag.Util.getString(this.properties, TITLE, this.propertyDefaults);
    }

    public void setTitleAddition(String v) {
        this.properties.set(TITLE_ADDITION, v);
    }

    public String getTitleAddition() {
        return SimplePropertyBag.Util.getString(this.properties, TITLE_ADDITION, this.propertyDefaults);
    }

    public void setPrimary(Boolean v) {
        this.properties.set(PRIMARY, v);
    }

    public Boolean getPrimary() {
        return SimplePropertyBag.Util.getBoolean(this.properties, PRIMARY, this.propertyDefaults);
    }

    public void setExtendToMargin(Boolean v) {
        this.properties.set(EXTEND_TO_MARGIN, v);
    }

    public Boolean getExtendToMargin() {
        return SimplePropertyBag.Util.getBoolean(this.properties, EXTEND_TO_MARGIN, this.propertyDefaults);
    }

    public void setExtendToEndMargin(Boolean v) {
        this.properties.set(EXTEND_TO_END_MARGIN, v);
    }

    public Boolean getExtendToEndMargin() {
        return SimplePropertyBag.Util.getBoolean(this.properties, EXTEND_TO_END_MARGIN, this.propertyDefaults);
    }

    public void setExtendToStartMargin(Boolean v) {
        this.properties.set(EXTEND_TO_START_MARGIN, v);
    }

    public Boolean getExtendToStartMargin() {
        return SimplePropertyBag.Util.getBoolean(this.properties, EXTEND_TO_START_MARGIN, this.propertyDefaults);
    }

    public void setMaximizeSpace(Boolean v) {
        this.properties.set(MAXIMIZE_SPACE, v);
    }

    public Boolean getMaximizeSpace() {
        return SimplePropertyBag.Util.getBoolean(this.properties, MAXIMIZE_SPACE, this.propertyDefaults);
    }

    public void setFitAlgorithm(String[] v) {
        this.properties.set(FIT_ALGORITHM, v);
    }

    public String[] getFitAlgorithm() {
        return (String[])SimplePropertyBag.Util.getObject(this.properties, FIT_ALGORITHM, this.propertyDefaults, String[].class);
    }

    public void setFitAlgorithmUsed(String v) {
        this.properties.set(FIT_ALGORITHM_USED, v);
    }

    public String getFitAlgorithmUsed() {
        return (String)SimplePropertyBag.Util.getObject(this.properties, FIT_ALGORITHM_USED, this.propertyDefaults, String.class);
    }

    public void setForceFitAlgorithm(String v) {
        this.properties.set(FIT_ALGORITHM_FORCED, v);
    }

    public String getForceFitAlgorithm() {
        return (String)SimplePropertyBag.Util.getObject(this.properties, FIT_ALGORITHM_FORCED, this.propertyDefaults, String.class);
    }

    public void setDepth(Dimension v) {
        this.properties.set(DEPTH, v);
    }

    public Dimension getDepth() {
        return (Dimension)SimplePropertyBag.Util.getObject(this.properties, DEPTH, this.propertyDefaults, Dimension.class);
    }

    public void setPreferredLength(Double v) {
        this.properties.set(PREFERRED_LENGTH, v);
    }

    public Double getPreferredLength() {
        return SimplePropertyBag.Util.getDouble(this.properties, PREFERRED_LENGTH, this.propertyDefaults);
    }

    public void setIdealPreferredLength(Double v) {
        this.properties.set(IDEAL_PREFERRED_LENGTH, v);
    }

    public Double getIdealPreferredLength() {
        return SimplePropertyBag.Util.getDouble(this.properties, IDEAL_PREFERRED_LENGTH, this.propertyDefaults);
    }

    public void setCellCount(Integer v) {
        this.properties.set(CELL_COUNT, v);
    }

    public Integer getCellCount() {
        return SimplePropertyBag.Util.getInteger(this.properties, CELL_COUNT, this.propertyDefaults);
    }

    public void setAxisModel(AxisModel v) {
        this.properties.set(AXIS_MODEL, v);
    }

    public AxisModel getAxisModel() {
        return (AxisModel)SimplePropertyBag.Util.getObject(this.properties, AXIS_MODEL, this.propertyDefaults, AxisModel.class);
    }

    public void setTitleWidth(Double v) {
        this.properties.set(TITLE_WIDTH, v);
    }

    public Double getTitleWidth() {
        return SimplePropertyBag.Util.getDouble(this.properties, TITLE_WIDTH, this.propertyDefaults);
    }

    public void setTitleHeight(Double v) {
        this.properties.set(TITLE_HEIGHT, v);
    }

    public Double getTitleHeight() {
        return SimplePropertyBag.Util.getDouble(this.properties, TITLE_HEIGHT, this.propertyDefaults);
    }

    public void setReusePreferredSize(Boolean v) {
        this.properties.set(REUSE_PREFERRED_SIZE, v);
    }

    public Boolean getReusePreferredSize() {
        return SimplePropertyBag.Util.getBoolean(this.properties, REUSE_PREFERRED_SIZE, this.propertyDefaults);
    }

    public void setMaximumSize(Vec3d v) {
        this.properties.set(MAXIMUM_SIZE, v);
    }

    public Vec3d getMaximumSize() {
        return (Vec3d)SimplePropertyBag.Util.getObject(this.properties, MAXIMUM_SIZE, this.propertyDefaults, Vec3d.class);
    }

    public void setTitleBreak(Integer v) {
        this.properties.set(TITLE_BREAK, v);
    }

    public Integer getTitleBreak() {
        return SimplePropertyBag.Util.getInteger(this.properties, TITLE_BREAK, this.propertyDefaults);
    }

    public void setFormatState(Integer v) {
        this.properties.set(FORMAT_STATE, v);
    }

    public Integer getFormatState() {
        return SimplePropertyBag.Util.getInteger(this.properties, FORMAT_STATE, this.propertyDefaults);
    }

    public void setLocale(Locale locale) {
        this.properties.set(LOCALE, locale);
    }

    public Locale getLocale() {
        return (Locale)SimplePropertyBag.Util.getObject(this.properties, LOCALE, this.propertyDefaults, Locale.class);
    }

    public void setValueFontUsed(Font v) {
        this.properties.set(SMALLEST_VALUE_FONT_USED, v);
    }

    public Font getValueFontUsed() {
        return (Font)SimplePropertyBag.Util.getObject(this.properties, SMALLEST_VALUE_FONT_USED, this.propertyDefaults, Font.class);
    }

    public Font getValueFontForced() {
        return (Font)SimplePropertyBag.Util.getObject(this.properties, VALUE_FONT_FORCED, this.propertyDefaults, Font.class);
    }

    public void setTitleMarker(DrilldownMarker dm) {
        this.properties.set(DRILLDOWN_MARKER, dm);
    }

    public DrilldownMarker getTitleMarker() {
        return (DrilldownMarker)SimplePropertyBag.Util.getObject(this.properties, DRILLDOWN_MARKER, this.propertyDefaults, DrilldownMarker.class);
    }

    public void setValueFontForced(Font v) {
        RectangularAxis axis;
        this.properties.set(VALUE_FONT_FORCED, v);
        NumericMapper mapper = this.getMapper();
        if (mapper != null && (axis = this.getGTKAxis(mapper)) != null) {
            axis.getStyle().getLabelStyle().setFont(v);
        }
    }

    public SASFormat newSASFormat(String formatName) {
        return Util.newSASFormat(formatName, this.getLocale());
    }

    public GTKFormat newGTKFormat(String formatName) {
        return GTKUtil.newGTKFormat(formatName, this.getLocale());
    }

    public int getTitlePlacementType() {
        return this.titlePlacement;
    }

    public void setTitlePlacementType(int newType) {
        this.titlePlacement = newType;
    }

    public void setComputeTitleHeightEnabled(boolean enable) {
        this.computeTitleHeight = enable;
    }

    public void setComputeTitleWidthEnabled(boolean enable) {
        this.computeTitleWidth = enable;
    }

    private static boolean _isDigit(double min, double max, boolean isPercentFormat, boolean isRomanFormat) {
        if (isPercentFormat) {
            return false;
        }
        if (isRomanFormat) {
            return true;
        }
        return max < 10.0 && max == (double)((int)max) && (min >= 0.0 || min > -10.0 && min == (double)((int)min));
    }

    private static boolean _isInteger(double min, double max) {
        boolean integer;
        boolean bl = integer = max - min > 5.0 && (min >= 0.0 || min == (double)((int)min));
        if (integer) {
            double range = max - min;
            integer = max < 9.223372036854776E17 && min > -9.223372036854776E17 && range < 9.223372036854776E17 && range > -9.223372036854776E17;
        }
        return integer;
    }

    private double calculateMin(ContinuousRangeToNumericMapper cm) {
        boolean useRiskMapAxisSetup = this.getUseRiskMapDefaults();
        double min = cm.getInputMin();
        if (this.getRangeValues() instanceof double[] && useRiskMapAxisSetup) {
            double[] values = (double[])this.getRangeValues();
            min = values[values.length - 1] < values[0] ? Math.min(min, values[values.length - 1]) : Math.min(min, values[0]);
        }
        return min;
    }

    private double calculateMax(ContinuousRangeToNumericMapper cm) {
        boolean useRiskMapAxisSetup = this.getUseRiskMapDefaults();
        double max = cm.getInputMax();
        if (this.getRangeValues() instanceof double[] && useRiskMapAxisSetup) {
            double[] values = (double[])this.getRangeValues();
            max = values[values.length - 1] < values[0] ? Math.max(max, values[0]) : Math.max(max, values[values.length - 1]);
        }
        return max;
    }

    public void computeParameters(Channel channel) {
        boolean endMargin;
        double stride;
        BaseLength bl;
        double minLength;
        StringPipe valueLabels;
        RectangularAxis axis;
        String fmt;
        GTKFormat gtkFormat;
        AxisModel axisModel = this.getAxisModel();
        NumericMapper mapper = this.getMapper();
        Util.updateChannel(channel, 1, 1);
        String orient = this.getAxisOrientation();
        boolean horzAxis = orient == EAST || orient == WEST;
        boolean useRiskMapAxisSetup = this.getUseRiskMapDefaults();
        if (mapper == null) {
            int titleSize;
            int fnsize;
            TextStyle tsv = axisModel.getValueTextStyle();
            Font font = tsv.getFont();
            if (font == null) {
                font = FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
            }
            int tickSize = fnsize = font.getSize();
            int labelHeight = font.getSize();
            TextStyle tsl = axisModel.getLabelTextStyle();
            Font tf = tsl.getFont();
            int n = titleSize = this.getTitleOn() != false ? tf.getSize() + labelHeight / 2 : labelHeight / 2;
            if (horzAxis) {
                this.setCatAxisAdj(new Double(2.5 * (double)labelHeight + (double)titleSize + (double)tickSize));
            }
            return;
        }
        int labelCount = 5;
        int labelCountMinus1 = 4;
        int maxLabelCount = this.getMaximumValueCount() == null ? Integer.MAX_VALUE : this.getMaximumValueCount();
        int cellCount = this.getCellCount() == null ? 1 : this.getCellCount();
        ContinuousRangeToNumericMapper cm = null;
        StringToNumericMapper sm = null;
        boolean continuousMapper = mapper instanceof ContinuousRangeToNumericMapper;
        boolean noLabel = false;
        boolean visible = axisModel.isVisible();
        double origin = this.getOrigin();
        Dimension margin = this.getPreferredMargin();
        Dimension margin2 = this.getMargin();
        Dimension minMargin = this.getMinimumMargin();
        if (continuousMapper) {
            block130: {
                double interval;
                boolean userMax;
                cm = (ContinuousRangeToNumericMapper)mapper;
                gtkFormat = null;
                fmt = axisModel.getFormat();
                if (fmt != null) {
                    gtkFormat = this.newGTKFormat(fmt);
                    cm.setFormat(gtkFormat);
                } else {
                    gtkFormat = cm.getFormat();
                }
                double min = axisModel.getMinimum();
                double max = axisModel.getMaximum();
                boolean datetime = false;
                boolean userMin = !Double.isNaN(min);
                boolean bl2 = userMax = !Double.isNaN(max);
                if (!userMin) {
                    min = this.calculateMin(cm);
                }
                if (!userMax) {
                    max = this.calculateMax(cm);
                }
                int placeType = axisModel.getContinuousMajorTickPositionPolicy();
                if (userMax && userMin) {
                    if (min > max || min == max) {
                        System.err.println(RB.getStringResource(RB_KEY, "minGreaterThanMax.ex.txt"));
                        min = this.calculateMin(cm);
                        max = this.calculateMax(cm);
                        userMin = false;
                        userMax = false;
                    }
                } else if (userMax && min >= max) {
                    System.err.println(RB.getStringResource(RB_KEY, "maxLowerThanValues.ex.txt"));
                    max = this.calculateMax(cm);
                    userMax = false;
                } else if (userMin && min >= max) {
                    System.err.println(RB.getStringResource(RB_KEY, "minHigherThanValues.ex.txt"));
                    min = this.calculateMin(cm);
                    userMin = false;
                } else if (min > max) {
                    max = 0.0;
                    min = 0.0;
                    noLabel = true;
                } else if ((placeType == 10703 || placeType == 10702) && Double.MAX_VALUE == (interval = axisModel.getContinuousMajorTickInterval())) {
                    this.invalidRange = true;
                }
                if (this.invalidRange) {
                    labelCount = 0;
                    labelCountMinus1 = 1;
                    cm.setInputMin(Double.NEGATIVE_INFINITY);
                    cm.setInputMax(Double.POSITIVE_INFINITY);
                    cm.setOutputMin(Double.NaN);
                    cm.setOutputMax(Double.NaN);
                    cm.setLabelCount(labelCount);
                } else {
                    try {
                        ContinuousTickSpacer tickSpacer = new ContinuousTickSpacer();
                        boolean zeroflag = min <= 0.0;
                        GTKFormat format = cm.getFormat();
                        SASFormat sasFormat = null;
                        if ((placeType == 10700 || placeType == 10200 && !useRiskMapAxisSetup) && format != null && format.getFormats()[0] instanceof SASDateTimeFormat) {
                            sasFormat = (SASFormat)format.getFormats()[0];
                            tickSpacer = new DateTimeTickSpacer();
                            ((DateTimeTickSpacer)tickSpacer).getTickSpacingInfo().setFormat(sasFormat);
                            ((DateTimeTickSpacer)tickSpacer).getTickSpacingInfo().setMaxTicks(12);
                            tickSpacer.getPreference().setAutoInterval(true);
                            datetime = true;
                        } else {
                            tickSpacer = new ContinuousTickSpacer();
                            tickSpacer.getTickSpacingInfo().setZeroMark(zeroflag);
                            tickSpacer.getTickSpacingInfo().setMaxTicks(9);
                        }
                        double offset = 0.0;
                        switch (placeType) {
                            default: {
                                if (useRiskMapAxisSetup) break;
                            }
                            case 10700: {
                                break;
                            }
                            case 10701: {
                                tickSpacer.setTickCount(axisModel.getContinuousMajorTickCount());
                                tickSpacer.getPreference().setAutoInterval(false);
                                break;
                            }
                            case 10703: {
                                offset = axisModel.getContinuousMajorTickAnchor();
                                if (offset > 0.0) {
                                    min -= offset;
                                    max -= offset;
                                } else {
                                    min += offset;
                                    max += offset;
                                }
                                tickSpacer.getTickSpacingInfo().setZeroMark(true);
                            }
                            case 10702: {
                                tickSpacer.getPreference().setAutoInterval(false);
                                tickSpacer.getPreference().setCoverageCoeff(1.0);
                                tickSpacer.setInterval(Math.abs(axisModel.getContinuousMajorTickInterval()));
                            }
                            case 10704: 
                        }
                        boolean isPercentFormatSpecified = this._isPercentFormatSpecified(gtkFormat);
                        boolean isPercentFormatComputed = this._isDataSourceFormatStateComputedPercent(this.getFormatState());
                        boolean isPercentFormat = isPercentFormatSpecified || isPercentFormatComputed;
                        boolean isRomanFormat = this._isRomanFormatSpecified(gtkFormat);
                        boolean digit = AxisCellModel._isDigit(min, max, isPercentFormat, isRomanFormat);
                        boolean integer = AxisCellModel._isInteger(min, max);
                        if (tickSpacer instanceof ContinuousTickSpacer) {
                            tickSpacer.getTickSpacingInfo().setInteger(integer || digit);
                        }
                        if (integer || digit) {
                            if (!userMin) {
                                min = Math.floor(min);
                            }
                            if (!userMax) {
                                max = Math.ceil(max);
                            }
                        }
                        tickSpacer.setDataMin(min);
                        tickSpacer.setDataMax(max);
                        tickSpacer.setUserMin(min);
                        tickSpacer.setUserMax(max);
                        if (userMin) {
                            tickSpacer.getPreference().setMinCalc(1);
                        } else {
                            tickSpacer.getPreference().setMinCalc(0);
                        }
                        if (userMax) {
                            tickSpacer.getPreference().setMaxCalc(1);
                        } else {
                            tickSpacer.getPreference().setMaxCalc(0);
                        }
                        if (userMin && userMax && placeType == 10702) {
                            tickSpacer.getPreference().setMaxCalc(0);
                        }
                        boolean fullCoverage = userMin ^ userMax && placeType == 10702 || !userMin && !userMax;
                        tickSpacer.getPreference().setFullCoverage(fullCoverage);
                        double adjustedMin = min;
                        double adjustedMax = max;
                        double[] values = null;
                        if (visible) {
                            if (placeType == 10704) {
                                int valueSize;
                                NumericVector tickValues = new NumericVector();
                                StringVector tickLabels = new StringVector();
                                double[] dArray = values = placeType == 10704 ? axisModel.getContinuousMajorTickValues() : (double[])this.getRangeValues();
                                if (format == null) {
                                    String pattern = this._decideFormatPattern(this.getFormatState(), values, isPercentFormatComputed);
                                    cm.setFormat(this.newGTKFormat(pattern));
                                    format = cm.getFormat();
                                }
                                int n = valueSize = values == null ? 0 : values.length;
                                if (useRiskMapAxisSetup) {
                                    --valueSize;
                                }
                                labelCount = 0;
                                for (int ii = 0; ii < valueSize; ++ii) {
                                    if (!(values[ii] >= adjustedMin) || !(values[ii] <= adjustedMax)) continue;
                                    double aValue = cm.getValue(values[ii]);
                                    tickValues.addValue(aValue);
                                    tickLabels.addValue(format.format((Object)new Double(values[ii])));
                                    ++labelCount;
                                }
                                labelCountMinus1 = labelCount > 1 ? labelCount - 1 : 1;
                                this.setValues((NumericPipe)tickValues);
                                if (!useRiskMapAxisSetup) {
                                    this.setValueLabels((StringPipe)tickLabels);
                                }
                                if (labelCount == 0) {
                                    System.err.println(RB.getStringResource(RB_KEY, "noUserDefinedValues.ex.txt"));
                                }
                            } else {
                                if (!datetime) {
                                    if (digit) {
                                        int numTicks = (int)Math.ceil(max) - (int)Math.floor(min) + 1;
                                        tickSpacer.getTickSpacingInfo().setMaxTicks(numTicks);
                                    } else if (placeType != 10702 && (userMax || userMin)) {
                                        tickSpacer.getTickSpacingInfo().setMaxTicks(9);
                                    }
                                }
                                tickSpacer.doTickSpacing();
                                values = tickSpacer.getTickValues();
                                if (values != null && values.length > 1 && !datetime) {
                                    values = NumericFormat.processValues((double[])values, (double)(values[0] - values[1]));
                                }
                                if (values != null && values.length > 0) {
                                    if (userMin && userMax) {
                                        adjustedMin = values[0];
                                        adjustedMax = values[values.length - 1];
                                    } else {
                                        adjustedMin = Math.min(tickSpacer.getTickMin(), values[0]);
                                        adjustedMax = Math.max(tickSpacer.getTickMax(), values[values.length - 1]);
                                    }
                                } else {
                                    adjustedMin = tickSpacer.getTickMin();
                                    adjustedMax = tickSpacer.getTickMax();
                                }
                                if (placeType == 10703) {
                                    int ii;
                                    offset = axisModel.getContinuousMajorTickAnchor();
                                    if (offset > 0.0) {
                                        adjustedMin += offset;
                                        adjustedMax += offset;
                                        ii = 0;
                                        while (ii < values.length) {
                                            int n = ii++;
                                            values[n] = values[n] + offset;
                                        }
                                    } else {
                                        adjustedMin -= offset;
                                        adjustedMax -= offset;
                                        ii = 0;
                                        while (ii < values.length) {
                                            int n = ii++;
                                            values[n] = values[n] - offset;
                                        }
                                    }
                                }
                                this._labelCount = labelCount = tickSpacer.getNumTicks();
                                labelCountMinus1 = Math.max(labelCount - 1, 1);
                            }
                            if (adjustedMin == adjustedMax) {
                                labelCount = 1;
                                labelCountMinus1 = 1;
                            }
                            if (format == null) {
                                String pattern = NumericFormat.getFormatName((double[])values, (int)-1, (boolean)isPercentFormatComputed);
                                cm.setFormat(this.newGTKFormat(pattern));
                                format = cm.getFormat();
                            }
                            if (values != null && values.length > 0 && !noLabel && !useRiskMapAxisSetup) {
                                if (labelCount == 1) {
                                    values = new double[]{values[0]};
                                }
                                if (datetime) {
                                    labelCount = this.createValueLabels(horzAxis, (Format)sasFormat, adjustedMin, adjustedMax, values, cm);
                                    this.setMinorTickVisible(Boolean.FALSE);
                                    if (userMin || userMax) {
                                        this.setDateTimeValues(values);
                                    }
                                } else if (axisModel.isAdjustValueMagnitudeEnabled()) {
                                    labelCount = this.createValueLabelsWithAdjustedMagnitude(horzAxis, values, format, cm);
                                } else if (format != null && !userMin && !userMax) {
                                    labelCount = this.createValueLabels(horzAxis, format.getFormats()[0], adjustedMin, adjustedMax, values, cm);
                                }
                            }
                            if (noLabel) {
                                labelCount = 0;
                            }
                            cm.setLabelCount(labelCount);
                            if (this.isReverse() && horzAxis) {
                                cm.setInputMin(adjustedMax);
                                cm.setInputMax(adjustedMin);
                            } else {
                                cm.setInputMin(adjustedMin);
                                cm.setInputMax(adjustedMax);
                            }
                            break block130;
                        }
                        margin.width = minMargin.width;
                        margin.height = minMargin.height;
                        margin2.width = minMargin.width;
                        margin2.height = minMargin.height;
                        double len = Math.max((double)(400 / cellCount), this.getLength());
                        this.setMapperOutput(axisModel, cm, null, origin, len, horzAxis);
                        if (this.isReverse() && horzAxis) {
                            cm.setInputMin(adjustedMax);
                            cm.setInputMax(adjustedMin);
                        } else {
                            cm.setInputMin(adjustedMin);
                            cm.setInputMax(adjustedMax);
                        }
                        this.setValueCount(new Integer(labelCount));
                        return;
                    }
                    catch (RuntimeException tickSpacer) {
                        // empty catch block
                    }
                }
            }
            this.resetFitAlgorithm(horzAxis, true);
            axis = horzAxis ? RectangularAxis.getXAxis((NumericMapper)mapper, (double)0.0) : RectangularAxis.getYAxis((NumericMapper)mapper, (double)0.0);
        } else {
            sm = (StringToNumericMapper)mapper;
            gtkFormat = null;
            fmt = axisModel.getFormat();
            if (fmt != null) {
                gtkFormat = this.newGTKFormat(fmt);
                sm.setFormat(gtkFormat);
            } else {
                gtkFormat = sm.getFormat();
            }
            String[] categories = axisModel.getCategories();
            sm = (StringToNumericMapper)mapper;
            if (categories != null) {
                StringVectorVariable svv = new StringVectorVariable();
                svv.connectFrom(categories);
                StringToNumericMap m = new StringToNumericMap();
                m.addStringPipe(svv.value);
                sm.setMap(m);
            }
            int n = labelCountMinus1 = (labelCount = sm.getUniqueValueCount()) < 2 ? 1 : labelCount - 1;
            if (!visible) {
                margin.width = minMargin.width;
                margin.height = minMargin.height;
                margin2.width = minMargin.width;
                margin2.height = minMargin.height;
                double len = Math.max(50.0, this.getLength());
                this.setMapperOutput(axisModel, null, sm, origin, len, horzAxis);
                this.setValueCount(new Integer(labelCount));
                return;
            }
            this.resetFitAlgorithm(horzAxis, false);
            axis = horzAxis ? RectangularAxis.getXAxis((NumericMapper)mapper, (double)0.0) : RectangularAxis.getYAxis((NumericMapper)mapper, (double)0.0);
        }
        boolean titleOn = this.getTitleOn();
        if (titleOn) {
            boolean bl3 = titleOn = this.getAxisVisible() != false && axisModel.getLabelTextStyle().isVisible();
            if (!titleOn) {
                this.setTitleOn(Boolean.FALSE);
            }
        }
        boolean primary = this.getPrimary();
        axis.setFitAlgorithm(this.getFitAlgorithm());
        axis.setTruncateStartCount(10);
        axis.setTruncateEndCount(10);
        axis.setStaggerThreshold(20);
        axis.setPrimary(primary);
        this.axes.put(mapper, axis);
        NumericPipe values = this.getValues();
        if (values != null) {
            axis.labelOffset.connectFrom(values);
        }
        if ((valueLabels = this.getValueLabels()) != null) {
            axis.labels.connectFrom(valueLabels);
        }
        Font labelFont = axisModel.getLabelTextStyle().getFont();
        channel.glSelect2DFont(labelFont);
        double titleWidth = 0.0;
        double titleHeight = 0.0;
        String title = this.getTitle();
        String titleAddition = this.getTitleAddition();
        if (titleOn) {
            int lpp;
            if (titleAddition != null) {
                title = title + " " + titleAddition;
            }
            this.titlePlacement = (lpp = axisModel.getLabelPlacementPolicy()) == 10200 ? (horzAxis || title == null ? 11306 : 11303) : lpp;
            if (this.titlePlacement == 11306) {
                if (!horzAxis) {
                    this.setTitleAngle(new Double(90.0));
                }
            } else {
                titleHeight = channel.glGetTextHeight(title) + 4.0;
                if (horzAxis) {
                    if (this.titlePlacement == 11301) {
                        titleHeight = 0.0;
                    }
                    titleWidth = channel.glGetTextWidth(title) + 4.0;
                } else {
                    if (this.titlePlacement == 11303 && titleHeight > channel.glGetTextHeight() + 4.0) {
                        this.titlePlacement = 11302;
                    }
                    titleWidth = this.titlePlacement == 11302 ? channel.glGetTextWidth(title) + 4.0 : 0.0;
                }
            }
            this.setTitleHeight(new Double(titleHeight));
            this.setTitleWidth(new Double(titleWidth));
            if (this.titlePlacement == 11306) {
                axis.title.setValue(title);
            }
        }
        AxisStyle axisStyle = axis.getStyle();
        this.setStyleProperties(axisStyle);
        AxisMetrics metrics = axis.getPreferredMetrics(channel);
        double length = minLength = metrics.getLineLength();
        double high = metrics.getHighExtender();
        double low = metrics.getLowExtender();
        Dimension depth = this.getDepth();
        if (depth == null) {
            depth = new Dimension(0, 0);
            this.setDepth(depth);
        }
        boolean startOffset = (bl = axisModel.getStartOffset()) != null;
        double start = startOffset ? bl.getMagnitude((Object)"px") : 0.0;
        bl = axisModel.getEndOffset();
        boolean endOffset = bl != null;
        double end = endOffset ? bl.getMagnitude((Object)"px") : 0.0;
        boolean extendToMargins = this.getExtendToMargin();
        boolean extendToEndMargin = !endOffset && (extendToMargins || this.getExtendToEndMargin() != false);
        double offset = Math.max(low, high) + 0.5;
        if (labelCount < 2) {
            length = minLength = Math.max(10.0, start + end);
        }
        Font valueFont = axisModel.getValueTextStyle().getFont();
        if (horzAxis) {
            high -= (double)depth.width;
            channel.glSelect2DFont(valueFont);
            String twoSpaces = "  ";
            stride = Math.ceil(length / (double)labelCountMinus1 + channel.glGetTextWidth(twoSpaces));
            if (continuousMapper) {
                length = (double)Math.min(labelCountMinus1, maxLabelCount - 1) * stride;
            } else if (cellCount > 2) {
                length = (double)labelCountMinus1 * (stride *= Math.max(0.5, (7.0 - (double)cellCount) / 5.0));
            } else {
                if (stride < (double)margin.width) {
                    stride = margin.width;
                }
                length = (double)labelCountMinus1 * stride;
            }
            if (!useRiskMapAxisSetup) {
                offset = Math.max(offset, stride / 2.0);
                offset = Math.max(offset, (double)margin.width);
                margin.width = (int)Math.max((double)minMargin.width, offset);
                if (minLength > length) {
                    minLength = length;
                }
            }
        } else {
            high -= (double)depth.height;
            stride = Math.ceil(2.0 * length / (double)labelCountMinus1);
            if (cm != null) {
                length = (double)Math.min(labelCountMinus1, maxLabelCount - 1) * stride;
            } else if (cellCount > 2) {
                length = (double)labelCountMinus1 * (stride *= Math.max(0.5, (7.0 - (double)cellCount) / 5.0));
            } else {
                if (stride < (double)margin.height) {
                    stride = margin.height;
                }
                length = (double)labelCountMinus1 * stride;
            }
            if (minLength > length) {
                minLength = length;
            }
            if (!useRiskMapAxisSetup) {
                offset = Math.max(offset, stride / 2.0);
                offset = Math.max(offset, (double)margin.height);
                margin.height = (int)Math.max((double)minMargin.height, offset);
            }
        }
        if (stride < 0.0) {
            stride = 0.0;
            length = 0.0;
        }
        if (horzAxis) {
            if (continuousMapper) {
                cm.setOutputMin(origin);
                cm.setOutputMax(origin + length);
            } else {
                sm.setStartValue(origin);
                sm.setStrideValue(stride);
            }
            this.setCatAxisAdj(new Double(Math.max(metrics.getOutsideLength() + (double)valueFont.getSize() * 0.2, titleHeight)));
            margin2.width = margin.width;
        } else {
            double resAxisAdj = Math.max(metrics.getOutsideLength() + 6.0 + 1.0, titleWidth);
            margin2.height = margin.height;
            if (continuousMapper) {
                if (this.isReverse() && !horzAxis) {
                    cm.setOutputMin(origin + length);
                    cm.setOutputMax(origin);
                } else {
                    cm.setOutputMax(origin + length);
                }
                cm.setLabelCount(labelCount);
                resAxisAdj = this._considerRefLineLabels(resAxisAdj, axisModel, channel, cm);
            } else if (this.isReverse()) {
                sm.setStrideValue(-stride);
                sm.setStartValue(origin + length);
            } else {
                sm.setStrideValue(stride);
            }
            this.setResAxisAdj(new Double(resAxisAdj));
            if (this.titlePlacement == 11303) {
                this.computeTitleBreak(channel, title, labelFont, resAxisAdj, primary);
            }
        }
        boolean bl4 = endMargin = endOffset || extendToEndMargin;
        if (!endMargin) {
            this.embeddedEndMargin = high;
            length += this.embeddedEndMargin;
        }
        this.setLength(new Double(length));
        this.setValueCount(new Integer(labelCount));
        this.setPreferredLength(new Double(minLength));
        this.setIdealPreferredLength(new Double(length));
        if (continuousMapper) {
            axis.majorTickOffset.connectFrom(cm.majorTickOffset);
        }
    }

    private int createValueLabels(boolean horzAxis, Format format, double adjustedMin, double adjustedMax, double[] values, ContinuousRangeToNumericMapper cm) {
        int labelCount = 0;
        boolean rangeLabelling = cm != null && cm.isLabelRanges();
        StringVector tickLabels = new StringVector();
        Double dvalue = null;
        Double prev_dvalue = null;
        String fvalue = null;
        String prev_fvalue = null;
        String pairFormat = null;
        MessageFormat rangeFormat = null;
        if (rangeLabelling) {
            pairFormat = rangeLabelling ? com.sas.graphics.util.gtk.RB.getStringResource((String)"numericLowToHighRangeFormat.fmt.txt") : null;
            rangeFormat = cm.getRangeFormat();
            if (rangeFormat == null) {
                rangeFormat = new MessageFormat("{4}");
            }
        }
        for (int ii = 0; ii < values.length; ++ii) {
            double d;
            int index = ii;
            if (this.isReverse() && horzAxis) {
                index = values.length - 1 - ii;
            }
            if ((d = values[index]) < adjustedMin || d > adjustedMax) continue;
            dvalue = new Double(d);
            fvalue = format != null ? format.format(dvalue) : dvalue.toString();
            String label = null;
            if (rangeLabelling) {
                if (prev_dvalue != null) {
                    Object[] rangeFormatArgs = new Object[]{prev_dvalue, dvalue, prev_fvalue, fvalue, Message.format((String)pairFormat, (Object)prev_fvalue.trim(), (Object)fvalue.trim())};
                    label = rangeFormat.format(rangeFormatArgs, new StringBuffer(), (FieldPosition)null).toString();
                }
                prev_dvalue = dvalue;
                prev_fvalue = fvalue;
            } else {
                label = fvalue;
            }
            if (ii <= 0 && rangeLabelling) continue;
            tickLabels.addValue(label);
            ++labelCount;
        }
        if (rangeLabelling) {
            ++labelCount;
        }
        this.setValueCount(new Integer(labelCount));
        this.setValueLabels((StringPipe)tickLabels);
        return labelCount;
    }

    private String _decideFormatPattern(Integer formatState, double[] values, boolean isPercentFormatComputed) {
        String pattern = "Best";
        if (formatState != null) {
            switch (formatState) {
                case 1: 
                case 2: {
                    pattern = NumericFormat.getFormatName((double[])values, (int)-1, (boolean)isPercentFormatComputed);
                    break;
                }
            }
        }
        return pattern;
    }

    private Format _getJavaFormat(GTKFormat format) {
        Format[] f;
        Format result = null;
        if (format != null && (f = format.getFormats()) != null && f.length > 0) {
            result = f[0];
        }
        return result;
    }

    private String _getSASFormatBaseName(GTKFormat format) {
        String result = null;
        Format f = this._getJavaFormat(format);
        if (f != null && f instanceof SASFormat) {
            SASFormat sf = (SASFormat)f;
            result = sf.getBaseFormatName();
        }
        return result;
    }

    private boolean _isPercentFormatSpecified(GTKFormat format) {
        String sasFormatName = this._getSASFormatBaseName(format);
        if (sasFormatName != null) {
            return sasFormatName.equalsIgnoreCase("NLPCT") || sasFormatName.equalsIgnoreCase("NLPCTN") || sasFormatName.equalsIgnoreCase("PERCENT") || sasFormatName.equalsIgnoreCase("PERCENTN");
        }
        return false;
    }

    private boolean _isRomanFormatSpecified(GTKFormat format) {
        String sasFormatName = this._getSASFormatBaseName(format);
        if (sasFormatName != null) {
            return sasFormatName.equalsIgnoreCase("ROMAN");
        }
        return false;
    }

    private boolean _isDataSourceFormatStateComputedPercent(Integer formatState) {
        return formatState != null && formatState == 2;
    }

    private double _considerRefLineLabels(double adj, AxisModel axisModel, Channel channel, ContinuousRangeToNumericMapper cm) {
        double resAxisAdj = adj;
        ReferenceLineModel[] models = axisModel.getReferenceLineModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                Util.LabelWithPosition result;
                String labelText;
                if ((models[i] == null || !models[i].isVisible() || models[i].getLabelPlacement() != 11302) && models[i].getLabelPlacement() != 10200 || (labelText = (result = Util.LabelWithPosition.getRefLineLabel(models[i], cm)).getLabelText()) == null) continue;
                TextStyle valueTextStyle = axisModel.getValueTextStyle();
                int tickSize = valueTextStyle.getFont().getSize() / 2;
                TextStyle textStyle = models[i].getTextStyle();
                if (textStyle == null) {
                    textStyle = valueTextStyle;
                }
                if (!textStyle.isVisible()) continue;
                Font font = textStyle.getFont();
                channel.glSelect2DFont(font);
                resAxisAdj = (int)Math.max(resAxisAdj, channel.glGetTextWidth(labelText) + (double)tickSize);
            }
        }
        return resAxisAdj;
    }

    public void computeSecondaryParameters(Channel channel) {
        GTKFormat format;
        int numMargins;
        boolean userMax;
        boolean userMin;
        AxisModel axisModel = this.getAxisModel();
        NumericMapper mapper = this.getMapper();
        Util.updateChannel(channel, 1, 1);
        String orient = this.getAxisOrientation();
        boolean horzAxis = orient == EAST || orient == WEST;
        boolean useRiskMapAxisSetup = this.getUseRiskMapDefaults();
        if (mapper == null) {
            return;
        }
        int placeType = axisModel.getContinuousMajorTickPositionPolicy();
        if (placeType != 10700 && (useRiskMapAxisSetup || placeType != 10200) || mapper instanceof StringToNumericMapper) {
            this.computeParameters(channel);
            if (horzAxis) {
                this.computeTitleWidth = false;
            } else {
                this.computeTitleHeight = false;
            }
            return;
        }
        ContinuousRangeToNumericMapper cm = null;
        boolean titleOn = this.getTitleOn();
        if (titleOn) {
            boolean bl = titleOn = this.getAxisVisible() != false && axisModel.getLabelTextStyle().isVisible();
            if (!titleOn) {
                this.setTitleOn(Boolean.FALSE);
            }
        }
        double length = this.getLength();
        Dimension margin = this.getMargin();
        int labelCount = this.getValueCount();
        cm = (ContinuousRangeToNumericMapper)mapper;
        double min = axisModel.getMinimum();
        double max = axisModel.getMaximum();
        if (Double.isNaN(min)) {
            min = cm.getInputMin();
            userMin = false;
        } else {
            userMin = true;
        }
        if (Double.isNaN(max)) {
            max = cm.getInputMax();
            userMax = false;
        } else {
            userMax = true;
        }
        GTKFormat gtkFormat = null;
        String fmt = axisModel.getFormat();
        if (fmt != null) {
            gtkFormat = this.newGTKFormat(fmt);
            cm.setFormat(gtkFormat);
        } else {
            gtkFormat = cm.getFormat();
        }
        boolean isPercentFormatSpecified = this._isPercentFormatSpecified(gtkFormat);
        boolean isPercentFormatComputed = this._isDataSourceFormatStateComputedPercent(this.getFormatState());
        boolean isPercentFormat = isPercentFormatSpecified || isPercentFormatComputed;
        boolean zeroflag = min <= 0.0;
        boolean isRomanFormat = this._isRomanFormatSpecified(gtkFormat);
        boolean digit = AxisCellModel._isDigit(min, max, isPercentFormat, isRomanFormat);
        boolean integer = AxisCellModel._isInteger(min, max);
        ContinuousTickSpacer tickSpacer = new ContinuousTickSpacer();
        tickSpacer.getTickSpacingInfo().setZeroMark(zeroflag);
        tickSpacer.getTickSpacingInfo().setInteger(integer || digit);
        if (userMin) {
            tickSpacer.getPreference().setMinCalc(1);
            tickSpacer.setUserMin(min);
        } else {
            if (integer || digit) {
                min = Math.floor(min);
            }
            tickSpacer.setDataMin(min);
        }
        if (userMax) {
            tickSpacer.getPreference().setMaxCalc(1);
            tickSpacer.setUserMax(max);
        } else {
            if (integer || digit) {
                max = Math.ceil(max);
            }
            tickSpacer.setDataMax(max);
        }
        double[] values = null;
        if (labelCount > 0) {
            tickSpacer.getTickSpacingInfo().setMaxTicks(labelCount);
            tickSpacer.doTickSpacing();
            if (labelCount != tickSpacer.getNumTicks()) {
                tickSpacer.getPreference().setAutoInterval(false);
                tickSpacer.setTickCount(labelCount);
                tickSpacer.doTickSpacing();
            }
            if (this.getValueLabels() != null) {
                this.setValueLabels(null);
            }
            if ((values = tickSpacer.getTickValues()) != null && values.length > 1) {
                values = NumericFormat.processValues((double[])values, (double)(values[0] - values[1]));
            }
        }
        double adjustedMin = tickSpacer.getTickMin();
        double adjustedMax = tickSpacer.getTickMax();
        if (this.isReverse() && horzAxis) {
            cm.setInputMin(adjustedMin);
            cm.setInputMax(adjustedMax);
        } else {
            cm.setInputMin(adjustedMin);
            cm.setInputMax(adjustedMax);
        }
        cm.setLabelCount(labelCount);
        this.resetFitAlgorithm(horzAxis, true);
        this.setLength(new Double(0.0));
        if (horzAxis) {
            this.computeTitleWidth = false;
        } else {
            this.computeTitleHeight = false;
        }
        Font font = axisModel.getLabelTextStyle().getFont();
        channel.glSelect2DFont(font);
        double titleWidth = this.getTitleWidth().intValue();
        double titleHeight = this.getTitleHeight().intValue();
        String title = this.getTitle();
        if (titleOn) {
            int lpp = axisModel.getLabelPlacementPolicy();
            this.titlePlacement = lpp == 10200 ? (horzAxis || title == null ? 11306 : 11303) : lpp;
            if (this.titlePlacement == 11306) {
                if (!horzAxis) {
                    this.setTitleAngle(new Double(90.0));
                }
            } else {
                titleHeight = channel.glGetTextHeight(title) + 4.0;
                if (horzAxis) {
                    if (this.titlePlacement == 11301 && this.computeTitleHeight) {
                        titleHeight = 0.0;
                    }
                    titleWidth = channel.glGetTextWidth(title) + 4.0;
                } else {
                    if (this.titlePlacement == 11303 && titleHeight > channel.glGetTextHeight() + 4.0) {
                        this.titlePlacement = 11302;
                    }
                    if (this.titlePlacement == 11303) {
                        title = title.substring(title.length() / 2);
                        titleWidth = channel.glGetTextWidth(title) + 4.0;
                    } else {
                        titleWidth = this.titlePlacement == 11301 ? 0.0 : channel.glGetTextWidth(title) + 4.0;
                    }
                }
                this.setTitleHeight(new Double(titleHeight));
                this.setTitleWidth(new Double(titleWidth));
            }
        } else {
            this.titlePlacement = 11306;
        }
        BaseLength bl = axisModel.getStartOffset();
        boolean startOffset = bl != null;
        double start = startOffset ? bl.getMagnitude((Object)"px") : 0.0;
        bl = axisModel.getEndOffset();
        boolean endOffset = bl != null;
        double end = endOffset ? bl.getMagnitude((Object)"px") : 0.0;
        boolean extendToMargins = this.getExtendToMargin();
        boolean extendToStartMargin = !startOffset && (extendToMargins || this.getExtendToStartMargin() != false);
        boolean extendToEndMargin = !endOffset && (extendToMargins || this.getExtendToEndMargin() != false);
        int n = numMargins = extendToStartMargin ? 1 : 0;
        if (extendToEndMargin) {
            ++numMargins;
        }
        if ((format = gtkFormat) == null) {
            String pattern = this._decideFormatPattern(this.getFormatState(), values, isPercentFormatComputed);
            cm.setFormat(this.newGTKFormat(pattern));
            format = cm.getFormat();
        }
        if (axisModel.isAdjustValueMagnitudeEnabled() && values != null && values.length > 0) {
            if (labelCount == 1) {
                values = new double[]{values[0]};
            }
            labelCount = this.createValueLabelsWithAdjustedMagnitude(horzAxis, values, format, cm);
        }
        if (horzAxis) {
            this.computeParameters(channel, length + (double)(numMargins * margin.width) + start + end + this.getResAxisAdj() + titleWidth);
        } else {
            this.computeParameters(channel, length + (double)(numMargins * margin.height) + start + end + this.getCatAxisAdj() + titleHeight);
        }
    }

    public void computeParameters(Channel channel, double newLength) {
        boolean horzAxis;
        String axisOrientation = this.getAxisOrientation();
        boolean bl = horzAxis = axisOrientation == EAST || axisOrientation == WEST;
        if (horzAxis) {
            this.computeParameters(channel, newLength, Double.POSITIVE_INFINITY);
        } else {
            this.computeParameters(channel, Double.POSITIVE_INFINITY, newLength);
        }
    }

    private int createValueLabelsWithAdjustedMagnitude(boolean horzAxis, double[] values, GTKFormat format, ContinuousRangeToNumericMapper cm) {
        int labelCount = values.length;
        double product = values.length == 1 ? Math.abs(values[0]) : Math.abs(values[1] - values[0]);
        Double factor = this.getAdjustValueMagnitudeFactor();
        if (factor.isNaN() && (factor = new Double(Util.findFactor(product))).isNaN()) {
            factor = new Double(1.0);
        }
        if (!factor.isNaN()) {
            Format fmt;
            this.setTitleAddition(Util.getFactorLabel(factor));
            this.setAdjustValueMagnitudeFactor(factor);
            double f = factor;
            if (f != 1.0) {
                int ii = 0;
                while (ii < values.length) {
                    int n = ii++;
                    values[n] = values[n] / f;
                }
            }
            Format format2 = fmt = format.getFormats().length > 0 ? format.getFormats()[0] : null;
            if (!(fmt instanceof SASNumericFormat) && !(fmt instanceof NumberFormat)) {
                fmt = null;
            }
            return this.createValueLabels(horzAxis, fmt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, values, cm);
        }
        return labelCount;
    }

    private void setMapperOutput(AxisModel axisModel, ContinuousRangeToNumericMapper cm, StringToNumericMapper sm, double origin, double length, boolean horzAxis) {
        double outputMax = origin + length - 1.0;
        if (cm != null) {
            if (this.isReverse() && !horzAxis) {
                cm.setOutputMin(outputMax);
                cm.setOutputMax(origin);
            } else {
                cm.setOutputMin(origin);
                cm.setOutputMax(outputMax);
            }
        } else {
            int count = sm.getUniqueValueCount();
            if (count == 1) {
                sm.setStrideValue(0.0);
                sm.setStartValue(origin + length / 2.0);
            } else {
                double stride = length / (double)(count - 1);
                if (this.isReverse()) {
                    sm.setStrideValue(-stride);
                    sm.setStartValue(outputMax);
                } else {
                    sm.setStrideValue(stride);
                    sm.setStartValue(origin);
                }
            }
        }
    }

    public void computeParameters(Channel channel, double width, double height) {
        boolean etm;
        StringPipe valueLabels;
        AxisStyle axisStyle;
        Boolean zoom;
        int len;
        int offset;
        int axisLength;
        int numMargins;
        StringToNumericMapper sm;
        AxisModel axisModel = this.getAxisModel();
        NumericMapper mapper = this.getMapper();
        Dimension minMargin = this.getMinimumMargin();
        Dimension margin = this.getMargin();
        Util.updateChannel(channel, (int)width, (int)height);
        ContinuousRangeToNumericMapper cm = mapper instanceof ContinuousRangeToNumericMapper ? (ContinuousRangeToNumericMapper)mapper : null;
        StringToNumericMapper stringToNumericMapper = sm = mapper instanceof StringToNumericMapper ? (StringToNumericMapper)mapper : null;
        if (mapper == null || width == 0.0 || height == 0.0) {
            margin.width = minMargin.width;
            margin.height = minMargin.height;
            return;
        }
        boolean useRiskMapAxisSetup = this.getUseRiskMapDefaults();
        if (useRiskMapAxisSetup && cm != null) {
            cm.setLabelCount(this._labelCount);
        }
        double length = this.getLength();
        double origin = this.getOrigin();
        String axisOrientation = this.getAxisOrientation();
        boolean horzAxis = axisOrientation == EAST || axisOrientation == WEST;
        Dimension prefMargin = this.getPreferredMargin();
        int catAxisAdj = this.getCatAxisAdj().intValue();
        int resAxisAdj = this.getResAxisAdj().intValue();
        Dimension depth = this.getDepth();
        BaseLength bl = axisModel.getStartOffset();
        boolean startOffset = bl != null;
        double start = startOffset ? bl.getMagnitude((Object)"px") : 0.0;
        bl = axisModel.getEndOffset();
        boolean endOffset = bl != null;
        double end = endOffset ? bl.getMagnitude((Object)"px") : 0.0;
        boolean extendToMargins = this.getExtendToMargin();
        boolean extendToStartMargin = !startOffset && (extendToMargins || this.getExtendToStartMargin() != false);
        boolean extendToEndMargin = !endOffset && (extendToMargins || this.getExtendToEndMargin() != false);
        int n = numMargins = extendToEndMargin ? 1 : 0;
        if (extendToStartMargin) {
            ++numMargins;
        }
        int count = this.getValueCount();
        if (!axisModel.isVisible()) {
            int axisLength2;
            if (horzAxis) {
                this.setCatAxisAdj(new Double(1.0));
                axisLength2 = (int)(width - (double)resAxisAdj - (double)depth.width - start - end);
            } else {
                this.setResAxisAdj(new Double(1.0));
                axisLength2 = (int)(height - (double)catAxisAdj - (double)depth.height - start - end);
            }
            if (cm != null) {
                margin.width = minMargin.width;
                margin.height = minMargin.height;
            } else {
                count = sm.getUniqueValueCount();
                double stride = axisLength2 / count;
                if (horzAxis) {
                    margin.width = (int)stride / 2;
                } else {
                    margin.height = (int)stride / 2;
                }
            }
            axisLength2 = horzAxis ? (axisLength2 -= numMargins * margin.width) : (axisLength2 -= numMargins * margin.height);
            this.setLength(new Double(axisLength2));
            this.setMapperOutput(axisModel, cm, sm, origin, axisLength2, horzAxis);
            return;
        }
        Font labelFont = axisModel.getLabelTextStyle().getFont();
        channel.glSelect2DFont(labelFont);
        int titleWidth = this.getTitleWidth().intValue();
        int titleHeight = this.getTitleHeight().intValue();
        String title = this.getTitle();
        boolean titleOn = this.getTitleOn();
        String titleAddition = this.getTitleAddition();
        if (titleOn && titleAddition != null) {
            title = title + " " + titleAddition;
        }
        Bbox box = new Bbox();
        if (titleOn && this.titlePlacement != 11306) {
            if (this.computeTitleHeight) {
                ShadowStyle ss = axisModel.getLabelTextStyle().getShadowStyle();
                if (ss.isVisible()) {
                    int xo = (int)ss.getOffsetX().getMagnitude((Object)"px");
                    int yo = (int)ss.getOffsetY().getMagnitude((Object)"px");
                    channel.glEnable(11);
                    channel.setShadowOffset(xo, yo);
                }
                channel.glGetText2DBbox(title, 0.0, 0.0, 0.0, 0, box);
                titleHeight = (int)box.getSizeY();
            }
            if (horzAxis) {
                if (this.titlePlacement == 11301 && this.computeTitleHeight) {
                    titleHeight = 0;
                }
                if (this.computeTitleWidth) {
                    titleWidth = (int)channel.glGetTextWidth(title) + 4;
                }
            } else if (this.computeTitleWidth) {
                titleWidth = this.titlePlacement == 11303 ? 0 : (this.titlePlacement == 11301 ? 0 : (int)channel.glGetTextWidth(title) + 4);
            }
            this.setTitleHeight(new Double(titleHeight));
            this.setTitleWidth(new Double(titleWidth));
        }
        double newLength = horzAxis ? width : height;
        if (this.invalidRange) {
            int axisLength3 = horzAxis ? (int)(newLength - (double)resAxisAdj - (double)depth.width - (double)titleWidth - (double)(numMargins * margin.width) - start - end) : (int)(newLength - (double)catAxisAdj - (double)depth.height - (double)titleHeight - (double)(numMargins * margin.height) - start - end);
            this.setLength(new Double(axisLength3));
            return;
        }
        RectangularAxis axis = (RectangularAxis)this.axes.get(mapper);
        if (axis == null) {
            axis = this.createGTKAxis(channel);
        }
        if (horzAxis) {
            axisLength = (int)(newLength - (double)resAxisAdj - (double)depth.width - (double)titleWidth);
            if (margin.width != 0 && (double)((int)length) == (double)(axisLength - numMargins * margin.width) - start - end - this.embeddedEndMargin) {
                return;
            }
            offset = this._determineOffset(minMargin.width, margin.width, sm, prefMargin.width, numMargins, axisLength, count);
            len = (int)((double)axisLength - this.embeddedEndMargin - start - end - (double)(numMargins * offset));
            if (axis == null || (double)len > length) {
                axis = RectangularAxis.getXAxis((NumericMapper)mapper, (double)len);
                this.axes.put(mapper, axis);
            } else {
                axis.setLength((double)len);
                axis.setLineOffset(0.0);
            }
            zoom = this.getZoomScrollBarsVisible();
            if (zoom != null && zoom.booleanValue()) {
                axisStyle = axis.getStyle();
                axisStyle.setLengthUnits(4);
                if (!(mapper instanceof StringToNumericMapper) && axisModel.getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10200 || axisModel.getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10201) {
                    axisStyle.getMajorTickStyle().setLength(9.0);
                    axisStyle.getMinorTickStyle().setLength(4.0);
                    axisStyle.setVerticalLabelSpace(2.0);
                } else {
                    axisStyle.setVerticalLabelSpace(11.0);
                    axisStyle.setHorizontalLabelSpace(11.0);
                }
            }
        } else {
            axisLength = (int)(newLength - (double)catAxisAdj - (double)depth.height - (double)titleHeight);
            if (margin.height != 0 && (double)((int)length) == (double)(axisLength - numMargins * margin.height) - start - end - this.embeddedEndMargin) {
                return;
            }
            offset = this._determineOffset(minMargin.height, margin.height, sm, prefMargin.height, numMargins, axisLength, count);
            len = (int)((double)axisLength - this.embeddedEndMargin - start - end - (double)(numMargins * offset));
            if (axis == null || (double)len > length) {
                axis = RectangularAxis.getYAxis((NumericMapper)mapper, (double)len);
                this.axes.put(mapper, axis);
            } else {
                axis.setLength((double)len);
                axis.setLineOffset(0.0);
            }
            zoom = this.getZoomScrollBarsVisible();
            if (zoom != null && zoom.booleanValue()) {
                axisStyle = axis.getStyle();
                axisStyle.setLengthUnits(4);
                if (!(mapper instanceof StringToNumericMapper) && axisModel.getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10200 || axisModel.getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10201) {
                    axisStyle.getMajorTickStyle().setLength(9.0);
                    axisStyle.getMinorTickStyle().setLength(4.0);
                    axisStyle.setHorizontalLabelSpace(5.0);
                } else {
                    axisStyle.setHorizontalLabelSpace(14.0);
                    axisStyle.setVerticalLabelSpace(14.0);
                }
            }
        }
        if (len < 0) {
            len = 0;
        }
        if (mapper instanceof ContinuousRangeToNumericMapper) {
            if (len >= this.getPreferredLength().intValue()) {
                switch (axisModel.getValueFitPolicy()) {
                    default: {
                        if (useRiskMapAxisSetup) {
                            this.setFitAlgorithm(new String[]{"shrink", "nolabels"});
                            break;
                        }
                        this.setFitAlgorithm(CONT2_FIT_BEST_ALG);
                        break;
                    }
                    case 11602: {
                        this.setFitAlgorithm(CONT2_FIT_FAST_ALG);
                        break;
                    }
                    case 11603: {
                        this.setFitAlgorithm(CONT2_FIT_BEST_NO_THIN_ALG);
                        break;
                    }
                    case 11604: {
                        this.setFitAlgorithm(CONT2_FIT_ROTATE_ALG);
                        break;
                    }
                    case 11605: {
                        if (useRiskMapAxisSetup) {
                            this.setFitAlgorithm(new String[]{"shrink", "nolabels"});
                            break;
                        }
                        this.setFitAlgorithm(CONT2_FIT_DASHBOARD_ALG);
                        break;
                    }
                }
            } else {
                switch (axisModel.getValueFitPolicy()) {
                    default: {
                        if (useRiskMapAxisSetup) {
                            this.setFitAlgorithm(new String[]{"shrink", "nolabels"});
                            break;
                        }
                        this.setFitAlgorithm(CONT_FIT_BEST_ALG);
                        break;
                    }
                    case 11602: {
                        this.setFitAlgorithm(CONT_FIT_FAST_ALG);
                        break;
                    }
                    case 11603: {
                        this.setFitAlgorithm(CONT_FIT_BEST_NO_THIN_ALG);
                        break;
                    }
                    case 11604: {
                        this.setFitAlgorithm(CONT_FIT_ROTATE_ALG);
                        break;
                    }
                    case 11605: {
                        if (useRiskMapAxisSetup) {
                            this.setFitAlgorithm(new String[]{"shrink", "nolabels"});
                            break;
                        }
                        this.setFitAlgorithm(CONT_FIT_DASHBOARD_ALG);
                    }
                }
            }
            if (this.isReverse() && !horzAxis) {
                cm.setOutputMin(origin + (double)len);
                cm.setOutputMax(origin);
            } else {
                cm.setOutputMax(origin + (double)len);
            }
            if (axisModel.getContinuousMajorTickPositionPolicy() == 10704 || this.getDateTimeValues() != null) {
                this.setUserTickValues(axisModel, cm);
            }
            axis.majorTickOffset.connectFrom(cm.majorTickOffset);
        } else {
            double stride;
            double d = stride = count < 2 ? 0.0 : (double)len / (double)(count - 1);
            if (this.isReverse()) {
                sm.setStrideValue(-stride);
                sm.setStartValue(origin + (double)len);
            } else {
                sm.setStartValue(origin);
                sm.setStrideValue(stride);
            }
        }
        Vec3d maxSize = new Vec3d(width, height, 0.0);
        this.setMaximumSize(maxSize);
        axis.setMaximumSize(maxSize);
        axisStyle = axis.getStyle();
        this.setStyleProperties(axisStyle);
        boolean primary = this.getPrimary();
        axis.setPrimary(primary);
        if (axisStyle.isTitleOn() && this.titlePlacement == 11306) {
            axis.title.setValue(title);
        }
        axis.setFitAlgorithm(this.getFitAlgorithm());
        if (!useRiskMapAxisSetup) {
            axis.setForceFitAlgorithm(this.getForceFitAlgorithm());
        }
        axis.setTruncateStartCount(10);
        axis.setTruncateEndCount(10);
        axis.setStaggerThreshold(20);
        axis.labelColor.setValue(axisStyle.getLabelStyle().getColor());
        NumericPipe values = this.getValues();
        if (values != null) {
            axis.labelOffset.connectFrom(values);
        }
        if ((valueLabels = this.getValueLabels()) != null) {
            axis.labels.connectFrom(valueLabels);
        }
        if (this.getValueFontForced() != null) {
            axisStyle.getLabelStyle().setFont(this.getValueFontForced());
        }
        AxisMetrics metrics = axis.getMetrics(channel);
        this.setFitAlgorithmUsed(metrics.getFittingAlgorithm());
        if (metrics.getLabelFont() != null) {
            this.setValueFontUsed(metrics.getLabelFont());
        }
        length = (int)metrics.getLineLength();
        double d = this.embeddedEndMargin = extendToEndMargin || endOffset ? 0.0 : metrics.getHighExtender();
        if (extendToStartMargin || extendToEndMargin && !useRiskMapAxisSetup) {
            int largestExtender = (int)Math.ceil(Math.max(metrics.getHighExtender(), metrics.getLowExtender()));
            int newOffset = offset;
            int maxIterations = 3;
            for (int i = 0; i < maxIterations && newOffset - largestExtender < 0; ++i) {
                newOffset = Math.max(newOffset + 2, Math.min(largestExtender, axisLength / 3));
                length += (double)(numMargins * (offset - newOffset));
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    if (this.isReverse() && !horzAxis) {
                        cm.setOutputMin(origin + length);
                    } else {
                        cm.setOutputMax(origin + length);
                    }
                    if (axisModel.getContinuousMajorTickPositionPolicy() == 10704 || this.getDateTimeValues() != null) {
                        this.setUserTickValues(axisModel, cm);
                    }
                } else {
                    double stride = length / (double)(count - 1);
                    if (this.isReverse()) {
                        sm.setStrideValue(-stride);
                        sm.setStartValue(origin + length);
                    } else {
                        sm.setStrideValue(stride);
                    }
                }
                axis.setLength(length);
                metrics = axis.getMetrics(channel);
                largestExtender = (int)Math.ceil(Math.max(metrics.getHighExtender(), metrics.getLowExtender()));
                this.embeddedEndMargin = extendToEndMargin || endOffset ? 0.0 : metrics.getHighExtender();
            }
            offset = Math.max(offset, newOffset);
        }
        if (useRiskMapAxisSetup) {
            while (metrics.getFittingAlgorithm().equals("nolabels") && cm.getLabelCount() > 2) {
                cm.setLabelCount(cm.getLabelCount() - 1);
                metrics = axis.getMetrics(channel);
            }
        }
        if (count == 0) {
            if (horzAxis) {
                margin.width = offset;
                axisLength = (int)(newLength - (double)resAxisAdj - (double)depth.width - (double)titleWidth - (double)(margin.width * numMargins) - start - end - this.embeddedEndMargin);
                catAxisAdj = (int)Math.max(metrics.getOutsideLength() + (double)((int)((double)labelFont.getSize() * 0.2)), (double)titleHeight);
                this.setCatAxisAdj(new Double(catAxisAdj));
                if (axisLength < 0) {
                    axisLength = 0;
                    if (newLength < (double)(resAxisAdj + depth.width + titleWidth) + start) {
                        origin = Double.NaN;
                    }
                }
            } else {
                margin.height = offset;
                axisLength = (int)Math.max(0.0, newLength - (double)catAxisAdj - (double)depth.height - (double)titleHeight - (double)(margin.height * numMargins) - start - end - this.embeddedEndMargin);
                resAxisAdj = (int)Math.ceil(Math.max(metrics.getOutsideLength() + 6.0, (double)titleWidth));
                this.setResAxisAdj(new Double(resAxisAdj));
                this.computeTitleBreak(channel, title, labelFont, resAxisAdj, primary);
                if (axisLength < 0) {
                    axisLength = 0;
                    if (newLength < (double)(catAxisAdj + depth.height + titleHeight) + start) {
                        origin = Double.NaN;
                    }
                }
            }
            if (cm != null) {
                cm.setOutputMin(origin);
                cm.setOutputMax((double)axisLength);
            } else {
                sm.setStartValue(origin + (double)(axisLength / 2));
            }
            this.setLength(new Double(axisLength));
            return;
        }
        if (count == 1 && horzAxis) {
            offset = (int)(width / 2.0);
            axisLength = (int)width;
        }
        if (horzAxis) {
            if (count > 1) {
                offset = this.getMaximizeSpace() != false ? Math.min(prefMargin.width, offset) : offset;
                margin.width = Math.max(margin.width, offset);
            }
            length = (double)(axisLength - numMargins * Math.min(margin.width, offset)) - this.embeddedEndMargin - start - end;
            catAxisAdj = (int)Math.max(metrics.getOutsideLength() + (double)((int)((double)labelFont.getSize() * 0.2)), (double)titleHeight);
            this.setCatAxisAdj(new Double(catAxisAdj));
        } else {
            offset = this.getMaximizeSpace() != false ? Math.min(prefMargin.height, offset) : offset;
            margin.height = Math.max(margin.height, offset);
            resAxisAdj = (int)Math.ceil(Math.max(metrics.getOutsideLength() + 6.0, (double)titleWidth));
            if (mapper instanceof ContinuousRangeToNumericMapper) {
                resAxisAdj = (int)this._considerRefLineLabels(resAxisAdj, axisModel, channel, (ContinuousRangeToNumericMapper)mapper);
            }
            this.setResAxisAdj(new Double(resAxisAdj));
            this.computeTitleBreak(channel, title, labelFont, resAxisAdj, primary);
            length = (double)(axisLength - numMargins * margin.height) - this.embeddedEndMargin - start - end;
        }
        if (length < 0.0) {
            length = 0.0;
            if ((double)axisLength < start) {
                origin = 0.0;
            }
        }
        boolean bl2 = etm = this.getExtendToMargin() != null ? this.getExtendToMargin() : false;
        if (cm != null && count == 1 && etm) {
            this.setMapperOutput(axisModel, cm, sm, length / 2.0, length / 2.0, horzAxis);
        } else {
            this.setMapperOutput(axisModel, cm, sm, origin, length, horzAxis);
        }
        if (cm != null && axisModel.getContinuousMajorTickPositionPolicy() == 10704 || this.getDateTimeValues() != null) {
            this.setUserTickValues(axisModel, cm);
        }
        if (!extendToEndMargin && !endOffset && length != 0.0) {
            length += this.embeddedEndMargin;
        }
        this.setLength(new Double(length));
    }

    private int _determineOffset(int minMargin, int margin, StringToNumericMapper sm, int prefMargin, int numMargins, int axisLength, int valueCount) {
        int offset = sm != null ? (int)Math.max((double)minMargin, Math.ceil((double)(valueCount == 0 ? 0 : axisLength / valueCount) / 2.0)) : (int)Math.max((double)minMargin, Math.ceil((double)(axisLength / 2) / 2.0));
        if (this.getMaximizeSpace().booleanValue()) {
            offset = Math.min(prefMargin, offset);
        }
        if (offset > axisLength / (numMargins + 1)) {
            offset = axisLength / (numMargins + 1);
        }
        if ((offset = Math.max(2, Math.min(offset, axisLength - 2 * valueCount))) < margin) {
            offset = margin;
        }
        return offset;
    }

    private void resetFitAlgorithm(boolean horz, boolean cont) {
        AxisModel axisModel = this.getAxisModel();
        int fit = axisModel != null ? axisModel.getValueFitPolicy() : 11601;
        switch (fit) {
            default: {
                if (cont) {
                    this.setFitAlgorithm(CONT_FIT_BEST_ALG);
                    break;
                }
                if (horz) {
                    this.setFitAlgorithm(HORZ_FIT_BEST_ALG);
                    break;
                }
                this.setFitAlgorithm(VERT_FIT_BEST_ALG);
                break;
            }
            case 11602: {
                if (cont) {
                    this.setFitAlgorithm(CONT_FIT_FAST_ALG);
                    break;
                }
                if (horz) {
                    this.setFitAlgorithm(HORZ_FIT_FAST_ALG);
                    break;
                }
                this.setFitAlgorithm(VERT_FIT_FAST_ALG);
                break;
            }
            case 11603: {
                if (cont) {
                    this.setFitAlgorithm(CONT_FIT_BEST_NO_THIN_ALG);
                    break;
                }
                if (horz) {
                    this.setFitAlgorithm(HORZ_FIT_BEST_NO_THIN_ALG);
                    break;
                }
                this.setFitAlgorithm(VERT_FIT_BEST_NO_THIN_ALG);
                break;
            }
            case 11604: {
                if (cont) {
                    this.setFitAlgorithm(CONT_FIT_ROTATE_ALG);
                    break;
                }
                if (horz) {
                    this.setFitAlgorithm(HORZ_FIT_ROTATE_ALG);
                    break;
                }
                this.setFitAlgorithm(VERT_FIT_ROTATE_ALG);
                break;
            }
            case 11605: {
                if (cont) {
                    this.setFitAlgorithm(CONT_FIT_DASHBOARD_ALG);
                    break;
                }
                if (horz) {
                    this.setFitAlgorithm(HORZ_FIT_DASHBOARD_ALG);
                    break;
                }
                this.setFitAlgorithm(VERT_FIT_DASHBOARD_ALG);
            }
        }
    }

    private void setUserTickValues(AxisModel axisModel, ContinuousRangeToNumericMapper cm) {
        NumericVector tickValues = new NumericVector();
        double[] values = (double[])(this.getDateTimeValues() != null ? this.getDateTimeValues() : (Object)axisModel.getContinuousMajorTickValues());
        if (values == null) {
            return;
        }
        int vlen = values.length;
        double adjustedMin = cm.getInputMin();
        double adjustedMax = cm.getInputMax();
        for (int ii = 0; ii < vlen; ++ii) {
            if (!(values[ii] >= adjustedMin) || !(values[ii] <= adjustedMax)) continue;
            double aValue = cm.getValue(values[ii]);
            tickValues.addValue(aValue);
        }
        this.setValues((NumericPipe)tickValues);
    }

    public RectangularAxis getGTKAxis(Object mapper) {
        return (RectangularAxis)this.axes.get(mapper);
    }

    public void setStyleProperties(AxisStyle gtkAxisStyle) {
        this.setStyleProperties(this.getAxisModel(), gtkAxisStyle);
        String axisOrientation = this.getAxisOrientation();
        boolean horz = axisOrientation == EAST || axisOrientation == WEST;
        com.sas.graphics.util.gtk.TextStyle gtkTitleTextStyle = gtkAxisStyle.getTitleStyle();
        if (!this.getTitleOn().booleanValue() || this.titlePlacement != 11306) {
            gtkAxisStyle.setTitleOn(false);
        } else {
            gtkTitleTextStyle.setAngle(this.getTitleAngle().doubleValue());
            boolean primary = this.getPrimary();
            if (horz) {
                gtkTitleTextStyle.setHorizontalJustification(1);
                if (primary) {
                    gtkTitleTextStyle.setVerticalJustification(0);
                } else {
                    gtkTitleTextStyle.setVerticalJustification(3);
                }
            } else {
                gtkTitleTextStyle.setVerticalJustification(1);
                if (primary) {
                    gtkTitleTextStyle.setHorizontalJustification(2);
                } else {
                    gtkTitleTextStyle.setHorizontalJustification(0);
                }
                gtkAxisStyle.setTitleSpace(1.5);
            }
        }
        TextStyle compValueTextStyle = this.getAxisModel().getValueTextStyle();
        com.sas.graphics.util.gtk.TextStyle gtkLabelTextStyle = gtkAxisStyle.getLabelStyle();
        if (horz) {
            gtkAxisStyle.getLabelStyle().setStagger(true);
            switch (compValueTextStyle.getJustification()) {
                case 2: {
                    gtkLabelTextStyle.setHorizontalJustification(0);
                    break;
                }
                default: {
                    gtkLabelTextStyle.setHorizontalJustification(1);
                    break;
                }
                case 4: {
                    gtkLabelTextStyle.setHorizontalJustification(2);
                    break;
                }
            }
        } else {
            switch (compValueTextStyle.getJustification()) {
                case 1: {
                    gtkLabelTextStyle.setVerticalJustification(0);
                    break;
                }
                default: {
                    gtkLabelTextStyle.setVerticalJustification(1);
                    break;
                }
                case 3: {
                    gtkLabelTextStyle.setVerticalJustification(3);
                }
            }
        }
        gtkLabelTextStyle.setAngle(Util.resolveBaselineAngle(compValueTextStyle));
        gtkLabelTextStyle.setFit(true);
        NumericMapper mapper = this.getMapper();
        if (mapper instanceof StringToNumericMapper) {
            AxisModel axisModel = this.getAxisModel();
            boolean tickMarksVisible = this.getMajorTickVisible() == null ? axisModel.getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10201 : this.getMajorTickVisible() == Boolean.TRUE;
            gtkAxisStyle.setMajorTickMarksOn(tickMarksVisible);
            tickMarksVisible = this.getMinorTickVisible() == null ? axisModel.getMinorTickStyle().getLineStyle().getVisibilityPolicy() == 10201 : this.getMinorTickVisible() == Boolean.TRUE;
            gtkAxisStyle.setMinorTickMarksOn(tickMarksVisible);
        } else {
            gtkAxisStyle.setShowThinnedTicks(false);
        }
    }

    private void setStyleProperties(AxisModel axisModel, AxisStyle gtkAxisStyle) {
        TextStyle compLabelTextStyle = axisModel.getLabelTextStyle();
        com.sas.graphics.util.gtk.TextStyle gtkTitleTextStyle = gtkAxisStyle.getTitleStyle();
        gtkAxisStyle.setTitleOn(compLabelTextStyle.isVisible());
        gtkTitleTextStyle.setFont(compLabelTextStyle.getFont());
        gtkTitleTextStyle.setColor(compLabelTextStyle.getColor());
        if (compLabelTextStyle.getShadowStyle().isVisible()) {
            gtkTitleTextStyle.setShadowOn(true);
            gtkTitleTextStyle.setShadowColor(compLabelTextStyle.getShadowStyle().getColor());
            gtkTitleTextStyle.setShadowOffsetX((int)compLabelTextStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            gtkTitleTextStyle.setShadowOffsetY((int)compLabelTextStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            gtkTitleTextStyle.setShadowSoftness((float)compLabelTextStyle.getShadowStyle().getSoftness());
        }
        switch (compLabelTextStyle.getJustification()) {
            case 2: {
                gtkTitleTextStyle.setHorizontalJustification(0);
                break;
            }
            default: {
                gtkTitleTextStyle.setHorizontalJustification(1);
                break;
            }
            case 4: {
                gtkTitleTextStyle.setHorizontalJustification(2);
            }
        }
        gtkTitleTextStyle.setBackgroundColor(null);
        TextStyle compValueTextStyle = axisModel.getValueTextStyle();
        com.sas.graphics.util.gtk.TextStyle gtkLabelTextStyle = gtkAxisStyle.getLabelStyle();
        gtkAxisStyle.setLabelsOn(compValueTextStyle.isVisible());
        gtkLabelTextStyle.setFont(compValueTextStyle.getFont());
        gtkLabelTextStyle.setColor(compValueTextStyle.getColor());
        if (compValueTextStyle.getShadowStyle().isVisible()) {
            gtkLabelTextStyle.setShadowOn(true);
            gtkLabelTextStyle.setShadowColor(compValueTextStyle.getShadowStyle().getColor());
            gtkLabelTextStyle.setShadowOffsetX((int)compValueTextStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            gtkLabelTextStyle.setShadowOffsetY((int)compValueTextStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            gtkLabelTextStyle.setShadowSoftness((float)compValueTextStyle.getShadowStyle().getSoftness());
        }
        gtkLabelTextStyle.setAngle(Util.resolveBaselineAngle(compValueTextStyle));
        gtkLabelTextStyle.setFit(true);
        gtkLabelTextStyle.setBackgroundColor(null);
        StrokeLineStyle compAxisLineStyle = axisModel.getAxisLineStyle();
        gtkAxisStyle.setAxisLineColor(compAxisLineStyle.getColor());
        gtkAxisStyle.setAxisLineOn(axisModel.getAxisLineStyle().getVisibilityPolicy() != 10202);
        GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(compAxisLineStyle);
        gtkAxisStyle.setLineWidth(gla.lineWidth);
        if (gla.stipplePattern != 0) {
            gtkAxisStyle.setLineStipple(gla.stipplePattern, gla.stippleFactor);
        }
        TickMarkStyle gtkMajorTickStyle = gtkAxisStyle.getMajorTickStyle();
        TickStyle compMajorTickStyle = axisModel.getMajorTickStyle();
        boolean tickMarksVisible = this.getMajorTickVisible() == null ? compMajorTickStyle.getLineStyle().getVisibilityPolicy() != 10202 : this.getMajorTickVisible() != Boolean.FALSE;
        gtkAxisStyle.setMajorTickMarksOn(tickMarksVisible);
        gtkMajorTickStyle.setColor(compMajorTickStyle.getLineStyle().getColor());
        gtkMajorTickStyle.setLineWidth((int)compMajorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"py"));
        switch (compMajorTickStyle.getPlacement()) {
            default: {
                gtkMajorTickStyle.setTickMarkJustification(1);
                break;
            }
            case 50001: {
                gtkMajorTickStyle.setTickMarkJustification(2);
                break;
            }
            case 50000: {
                gtkMajorTickStyle.setTickMarkJustification(0);
            }
        }
        TickMarkStyle gtkMinorTickStyle = gtkAxisStyle.getMinorTickStyle();
        TickStyle compMinorTickStyle = axisModel.getMinorTickStyle();
        boolean labelRanges = false;
        if (this.getMapper() instanceof ContinuousRangeToNumericMapper) {
            labelRanges = ((ContinuousRangeToNumericMapper)this.getMapper()).isLabelRanges();
        }
        boolean tickMarksVisible2 = this.getMinorTickVisible() == null ? compMinorTickStyle.getLineStyle().getVisibilityPolicy() == 10201 || compMinorTickStyle.getLineStyle().getVisibilityPolicy() == 10200 && !labelRanges : this.getMinorTickVisible() != Boolean.FALSE;
        gtkAxisStyle.setMinorTickMarksOn(tickMarksVisible2);
        gtkMinorTickStyle.setColor(compMinorTickStyle.getLineStyle().getColor());
        gtkMinorTickStyle.setLineWidth((int)compMinorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"py"));
        gtkMinorTickStyle.setMinorTickCount(axisModel.getContinuousMinorTickCount());
        switch (compMinorTickStyle.getPlacement()) {
            default: {
                gtkMinorTickStyle.setTickMarkJustification(1);
                break;
            }
            case 50001: {
                gtkMinorTickStyle.setTickMarkJustification(2);
                break;
            }
            case 50000: {
                gtkMinorTickStyle.setTickMarkJustification(0);
            }
        }
    }

    public static boolean isInvalidState(AxisModel axisModel, Variable[] variableArray, String role) {
        double interval;
        boolean usermax;
        double umin = axisModel.getMinimum();
        double umax = axisModel.getMaximum();
        boolean usermin = !Double.isNaN(umin);
        boolean bl = usermax = !Double.isNaN(umax);
        if (usermax && usermin && umin > umax) {
            String message = Message.format((String)RB.getStringResource(RB_KEY, "minHigherThanMax.ex.fmt.txt"), (Object)role);
            System.err.println(message);
            return true;
        }
        double min = Double.NaN;
        double max = Double.NaN;
        if (variableArray != null) {
            for (int ii = 0; ii < variableArray.length; ++ii) {
                NumericVariable nv = (NumericVariable)variableArray[ii];
                if (nv == null) continue;
                min = Double.isNaN(min) ? nv.getMin() : Math.min(min, nv.getMin());
                max = Double.isNaN(max) ? nv.getMax() : Math.max(max, nv.getMax());
            }
        }
        if (!Double.isNaN(min) && usermax && min > umax) {
            String message = Message.format((String)RB.getStringResource(RB_KEY, "allValuesHigherThanMax.ex.fmt.txt"), (Object)role);
            System.err.println(message);
            return true;
        }
        if (!Double.isNaN(max) && usermin && umin > max) {
            String message = Message.format((String)RB.getStringResource(RB_KEY, "minHigherThanAllValues.ex.fmt.txt"), (Object)role);
            System.err.println(message);
            return true;
        }
        int placeType = axisModel.getContinuousMajorTickPositionPolicy();
        if ((placeType == 10703 || placeType == 10702) && Double.MAX_VALUE == (interval = axisModel.getContinuousMajorTickInterval())) {
            String message = Message.format((String)RB.getStringResource(RB_KEY, "invalidInterval.ex.fmt.txt"), (Object)role);
            System.err.println(message);
            return true;
        }
        return false;
    }

    private int computeTitleBreak(Channel channel, String title, Font titleFont, double maxSize, boolean primary) {
        channel.glSelect2DFont(titleFont);
        double titleWidth = channel.glGetTextWidth(title) + 4.0;
        int breakLength = -1;
        if (title == null || titleWidth <= maxSize) {
            this.setTitleBreak(null);
        } else {
            breakLength = (int)(maxSize * (double)title.length() / titleWidth);
            if (primary) {
                for (breakLength = Math.min(breakLength + 2, title.length() - 1); breakLength > 0 && channel.glGetTextWidth(title.substring(0, breakLength)) + 4.0 > maxSize; --breakLength) {
                }
            } else {
                for (breakLength = Math.min(breakLength - 2, 1); breakLength > 0 && channel.glGetTextWidth(title.substring(breakLength)) + 4.0 > maxSize; ++breakLength) {
                }
            }
            this.setTitleBreak(new Integer(breakLength));
        }
        if (breakLength < 0) {
            this.setTitleBreak(null);
            breakLength = 1;
        }
        return breakLength;
    }

    public RectangularAxis createGTKAxis(Channel channel) {
        StringPipe valueLabels;
        RectangularAxis axis;
        boolean horzAxis;
        AxisModel axisModel = this.getAxisModel();
        NumericMapper mapper = this.getMapper();
        String orient = this.getAxisOrientation();
        boolean bl = horzAxis = orient == EAST || orient == WEST;
        if (mapper == null) {
            int titleSize;
            int fnsize;
            TextStyle tsv = axisModel.getValueTextStyle();
            Font font = tsv.getFont();
            if (font == null) {
                font = FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
            }
            int tickSize = fnsize = font.getSize();
            int labelHeight = font.getSize();
            TextStyle tsl = axisModel.getLabelTextStyle();
            Font tf = tsl.getFont();
            int n = titleSize = this.getTitleOn() != false ? tf.getSize() + labelHeight / 2 : labelHeight / 2;
            if (horzAxis) {
                this.setCatAxisAdj(new Double(2.5 * (double)labelHeight + (double)titleSize + (double)tickSize));
            }
            return null;
        }
        ContinuousRangeToNumericMapper cm = null;
        boolean continuousMapper = mapper instanceof ContinuousRangeToNumericMapper;
        if (continuousMapper) {
            cm = (ContinuousRangeToNumericMapper)mapper;
            this.resetFitAlgorithm(horzAxis, true);
            axis = horzAxis ? RectangularAxis.getXAxis((NumericMapper)mapper, (double)0.0) : RectangularAxis.getYAxis((NumericMapper)mapper, (double)0.0);
            axis.majorTickOffset.connectFrom(cm.majorTickOffset);
        } else {
            this.resetFitAlgorithm(horzAxis, false);
            axis = horzAxis ? RectangularAxis.getXAxis((NumericMapper)mapper, (double)0.0) : RectangularAxis.getYAxis((NumericMapper)mapper, (double)0.0);
        }
        boolean titleOn = this.getTitleOn();
        if (titleOn) {
            boolean bl2 = titleOn = this.getAxisVisible() != false && axisModel.getLabelTextStyle().isVisible();
            if (!titleOn) {
                this.setTitleOn(Boolean.FALSE);
            }
        }
        boolean primary = this.getPrimary();
        axis.setFitAlgorithm(this.getFitAlgorithm());
        axis.setTruncateStartCount(10);
        axis.setTruncateEndCount(10);
        axis.setStaggerThreshold(20);
        axis.setPrimary(primary);
        this.axes.put(mapper, axis);
        NumericPipe values = this.getValues();
        if (values != null) {
            axis.labelOffset.connectFrom(values);
        }
        if ((valueLabels = this.getValueLabels()) != null) {
            axis.labels.connectFrom(valueLabels);
        }
        Font labelFont = axisModel.getLabelTextStyle().getFont();
        channel.glSelect2DFont(labelFont);
        String title = this.getTitle();
        if (titleOn && this.titlePlacement == 11306) {
            axis.title.setValue(title);
        }
        AxisStyle axisStyle = axis.getStyle();
        this.setStyleProperties(axisStyle);
        this.axes.put(mapper, axis);
        return axis;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            PropertyChangeListener[] pcl = this.propertyChangeSupport.getPropertyChangeListeners();
            int i = 0;
            for (i = 0; i < pcl.length && pcl[i] != listener; ++i) {
            }
            if (i == pcl.length) {
                this.propertyChangeSupport.addPropertyChangeListener(listener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }
}

