/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.AlignableComponentInterface;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;

public class AlignableComponentConstraints {
    private Insets outerMargin = null;
    private Insets innerMargin = null;
    private Double size = null;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);

    public static void setConstraints(Component cellComponent, AlignableComponentConstraints constraints) {
        if (constraints != null) {
            if (cellComponent instanceof AlignableComponentInterface) {
                ((AlignableComponentInterface)((Object)cellComponent)).setAlignableComponentConstraints(constraints);
            } else if (cellComponent != null) {
                cellComponent.setBounds(constraints.getBounds());
            }
        }
    }

    public AlignableComponentConstraints() {
    }

    public AlignableComponentConstraints(AlignableComponentConstraints from) {
        this.apply(from);
    }

    public void apply(AlignableComponentConstraints from) {
        if (from != null) {
            if (from.outerMargin != null) {
                if (this.outerMargin == null) {
                    this.outerMargin = new Insets(from.outerMargin.top, from.outerMargin.left, from.outerMargin.bottom, from.outerMargin.right);
                } else {
                    this.outerMargin.top = from.outerMargin.top;
                    this.outerMargin.left = from.outerMargin.left;
                    this.outerMargin.bottom = from.outerMargin.bottom;
                    this.outerMargin.right = from.outerMargin.right;
                }
            } else {
                this.outerMargin = null;
            }
            if (from.innerMargin != null) {
                if (this.innerMargin == null) {
                    this.innerMargin = new Insets(from.innerMargin.top, from.innerMargin.left, from.innerMargin.bottom, from.innerMargin.right);
                } else {
                    this.innerMargin.top = from.innerMargin.top;
                    this.innerMargin.left = from.innerMargin.left;
                    this.innerMargin.bottom = from.innerMargin.bottom;
                    this.innerMargin.right = from.innerMargin.right;
                }
            } else {
                this.innerMargin = null;
            }
            this.size = from.size;
            if (from.bounds != null) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle(from.bounds.x, from.bounds.y, from.bounds.width, from.bounds.height);
                } else {
                    this.bounds.x = from.bounds.x;
                    this.bounds.y = from.bounds.y;
                    this.bounds.width = from.bounds.width;
                    this.bounds.height = from.bounds.height;
                }
            } else {
                this.bounds = null;
            }
        }
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public final Insets getInnerMargin() {
        return this.innerMargin;
    }

    public final void setInnerMargin(Insets innerMargin) {
        this.innerMargin = innerMargin;
    }

    public final Insets getOuterMargin() {
        return this.outerMargin;
    }

    public final void setOuterMargin(Insets outterMargin) {
        this.outerMargin = outterMargin;
    }

    public final Double getSize() {
        return this.size;
    }

    public final void setSize(Double size) {
        this.size = size;
    }
}

