/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.barlinechart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;

public class BarLineChartModel {
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private AxisModel responseAxisModel = new AxisModel();
    private AxisModel response2AxisModel = new AxisModel();
    private AxisModel categoryAxisModel = new AxisModel();
    private AxisWallModel axisWallModel = new AxisWallModel();
    private LegendModel legendModel = new LegendModel();
    private int insideBarLabelContent = 10200;
    private int outsideBarLabelContent = 10200;
    private int outsideMarkerLabelContent = 10200;
    private AdvancedTextStyle insideBarLabelTextStyle = new AdvancedTextStyle();
    private AdvancedTextStyle outsideBarLabelTextStyle = new AdvancedTextStyle();
    private AdvancedTextStyle outsideMarkerLabelTextStyle = new AdvancedTextStyle();
    private int orientation = 1;
    private int dimension = 10100;
    private BaseLength barWidth = new BaseLength(1.0, "cm");
    private BaseLength barWidthSpace = new BaseLength(0.25, "cm");
    private BaseLength barDepth = new BaseLength(1.0, "cm");
    private BaseLength barDepthSpace = new BaseLength(0.25, "cm");
    private int barShape = 10300;
    private boolean growBarWidthEnabled = true;
    private int stackBarPolicy = 10200;
    private int stackLinePolicy = 10200;
    private boolean fillAreaEnabled = false;
    private boolean zeroHeightBarsVisible = true;
    private boolean uniformEnabled = false;
    private boolean markerEnabled = true;
    private boolean interpolationEnabled = true;
    private boolean skipMissing = false;
    private int missingPolicy = 10200;
    private boolean missingResponseEnabled = false;
    private boolean confidenceLimitEnabled = false;
    private int uniformPolicy = 10200;
    private int trendlineType = 11900;
    private boolean waterfallEnabled = false;
    private boolean waterfallFinalBarEnabled = true;
    private String waterfallFinalBarID = null;
    private double waterfallInitialBarHeight = Double.NaN;
    private String waterfallInitialBarID = null;
    private int colorPaletteType = 11803;
    private int skin = 10200;
    private ReferenceLineModel responseAxisBaselineModel = new ReferenceLineModel(0.0);
    private ReferenceLineModel response2AxisBaselineModel = new ReferenceLineModel(0.0);
    private double responseAxisUpperThreshold = Double.POSITIVE_INFINITY;
    private double responseAxisLowerThreshold = Double.NEGATIVE_INFINITY;
    private double response2AxisUpperThreshold = Double.POSITIVE_INFINITY;
    private double response2AxisLowerThreshold = Double.NEGATIVE_INFINITY;

    public void apply(BarLineChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.responseAxisModel.apply(theOtherModel.responseAxisModel);
        this.responseAxisBaselineModel.apply(theOtherModel.responseAxisBaselineModel);
        this.response2AxisModel.apply(theOtherModel.response2AxisModel);
        this.response2AxisBaselineModel.apply(theOtherModel.response2AxisBaselineModel);
        this.categoryAxisModel.apply(theOtherModel.categoryAxisModel);
        this.axisWallModel.apply(theOtherModel.axisWallModel);
        this.legendModel.apply(theOtherModel.legendModel);
        this.insideBarLabelTextStyle.apply(theOtherModel.insideBarLabelTextStyle);
        this.outsideBarLabelTextStyle.apply(theOtherModel.outsideBarLabelTextStyle);
        this.outsideMarkerLabelTextStyle.apply(theOtherModel.outsideMarkerLabelTextStyle);
        this.orientation = theOtherModel.orientation;
        this.dimension = theOtherModel.dimension;
        this.skin = theOtherModel.skin;
        this.barWidth = theOtherModel.barWidth;
        this.barWidthSpace = theOtherModel.barWidthSpace;
        this.barDepth = theOtherModel.barDepth;
        this.barDepthSpace = theOtherModel.barDepthSpace;
        this.barShape = theOtherModel.barShape;
        this.growBarWidthEnabled = theOtherModel.growBarWidthEnabled;
        this.stackBarPolicy = theOtherModel.stackBarPolicy;
        this.stackLinePolicy = theOtherModel.stackLinePolicy;
        this.fillAreaEnabled = theOtherModel.fillAreaEnabled;
        this.markerEnabled = theOtherModel.markerEnabled;
        this.missingPolicy = theOtherModel.missingPolicy;
        this.uniformPolicy = theOtherModel.uniformPolicy;
        this.colorPaletteType = theOtherModel.colorPaletteType;
        this.skipMissing = theOtherModel.skipMissing;
        this.missingResponseEnabled = theOtherModel.missingResponseEnabled;
        this.confidenceLimitEnabled = theOtherModel.confidenceLimitEnabled;
        this.interpolationEnabled = theOtherModel.interpolationEnabled;
        this.zeroHeightBarsVisible = theOtherModel.zeroHeightBarsVisible;
        this.uniformEnabled = theOtherModel.uniformEnabled;
        this.waterfallEnabled = theOtherModel.waterfallEnabled;
        this.waterfallFinalBarEnabled = theOtherModel.waterfallFinalBarEnabled;
        this.waterfallInitialBarHeight = theOtherModel.waterfallInitialBarHeight;
        this.waterfallFinalBarID = theOtherModel.waterfallFinalBarID;
        this.waterfallInitialBarID = theOtherModel.waterfallInitialBarID;
        this.trendlineType = theOtherModel.trendlineType;
        this.responseAxisUpperThreshold = theOtherModel.responseAxisUpperThreshold;
        this.responseAxisLowerThreshold = theOtherModel.responseAxisLowerThreshold;
        this.response2AxisUpperThreshold = theOtherModel.response2AxisUpperThreshold;
        this.response2AxisLowerThreshold = theOtherModel.response2AxisLowerThreshold;
        this.insideBarLabelContent = theOtherModel.insideBarLabelContent;
        this.outsideBarLabelContent = theOtherModel.outsideBarLabelContent;
        this.outsideMarkerLabelContent = theOtherModel.outsideMarkerLabelContent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BarLineChartModel arg = (BarLineChartModel)obj;
        return Util.Evaluate.isEqual(this.barShape, arg.barShape) && Util.Evaluate.isEqual(this.growBarWidthEnabled, arg.growBarWidthEnabled) && Util.Evaluate.isEqual(this.orientation, arg.orientation) && Util.Evaluate.isEqual(this.dimension, arg.dimension) && Util.Evaluate.isEqual(this.stackBarPolicy, arg.stackBarPolicy) && Util.Evaluate.isEqual(this.stackLinePolicy, arg.stackLinePolicy) && Util.Evaluate.isEqual(this.responseAxisUpperThreshold, arg.responseAxisUpperThreshold) && Util.Evaluate.isEqual(this.responseAxisLowerThreshold, arg.responseAxisLowerThreshold) && Util.Evaluate.isEqual(this.response2AxisUpperThreshold, arg.response2AxisUpperThreshold) && Util.Evaluate.isEqual(this.response2AxisLowerThreshold, arg.response2AxisLowerThreshold) && Util.Evaluate.isEqual(this.insideBarLabelContent, arg.insideBarLabelContent) && Util.Evaluate.isEqual(this.outsideBarLabelContent, arg.outsideBarLabelContent) && Util.Evaluate.isEqual(this.outsideMarkerLabelContent, arg.outsideMarkerLabelContent) && Util.Evaluate.isEqual(this.fillAreaEnabled, arg.fillAreaEnabled) && Util.Evaluate.isEqual(this.markerEnabled, arg.markerEnabled) && Util.Evaluate.isEqual(this.trendlineType, arg.trendlineType) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.uniformPolicy, arg.uniformPolicy) && Util.Evaluate.isEqual(this.colorPaletteType, arg.colorPaletteType) && Util.Evaluate.isEqual(this.skipMissing, arg.skipMissing) && Util.Evaluate.isEqual(this.missingResponseEnabled, arg.missingResponseEnabled) && Util.Evaluate.isEqual(this.interpolationEnabled, arg.interpolationEnabled) && Util.Evaluate.isEqual(this.zeroHeightBarsVisible, arg.zeroHeightBarsVisible) && Util.Evaluate.isEqual(this.uniformEnabled, arg.uniformEnabled) && Util.Evaluate.isEqual(this.waterfallEnabled, arg.waterfallEnabled) && Util.Evaluate.isEqual(this.waterfallFinalBarEnabled, arg.waterfallFinalBarEnabled) && Util.Evaluate.isEqual(this.waterfallFinalBarID, arg.waterfallFinalBarID) && Util.Evaluate.isEqual(this.waterfallInitialBarHeight, arg.waterfallInitialBarHeight) && Util.Evaluate.isEqual(this.waterfallInitialBarID, arg.waterfallInitialBarID) && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual((BaseDistance)this.barWidth, (BaseDistance)arg.barWidth) && Util.Evaluate.isEqual((BaseDistance)this.barWidthSpace, (BaseDistance)arg.barWidthSpace) && Util.Evaluate.isEqual((BaseDistance)this.barDepth, (BaseDistance)arg.barDepth) && Util.Evaluate.isEqual((BaseDistance)this.barDepthSpace, (BaseDistance)arg.barDepthSpace) && Util.Evaluate.isEqual(this.insideBarLabelTextStyle, arg.insideBarLabelTextStyle) && Util.Evaluate.isEqual(this.outsideBarLabelTextStyle, arg.outsideBarLabelTextStyle) && Util.Evaluate.isEqual(this.outsideMarkerLabelTextStyle, arg.outsideMarkerLabelTextStyle) && Util.Evaluate.isEqual(this.responseAxisModel, arg.responseAxisModel) && Util.Evaluate.isEqual(this.responseAxisBaselineModel, arg.responseAxisBaselineModel) && Util.Evaluate.isEqual(this.response2AxisModel, arg.response2AxisModel) && Util.Evaluate.isEqual(this.response2AxisBaselineModel, arg.response2AxisBaselineModel) && Util.Evaluate.isEqual(this.categoryAxisModel, arg.categoryAxisModel) && Util.Evaluate.isEqual(this.axisWallModel, arg.axisWallModel) && Util.Evaluate.isEqual(this.legendModel, arg.legendModel) && Util.Evaluate.isEqual(this.skin, arg.skin) && Util.Evaluate.isEqual(this.confidenceLimitEnabled, arg.confidenceLimitEnabled);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.rowAxisModel = newAxisModel;
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.columnAxisModel = newAxisModel;
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public void setResponseAxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.responseAxisModel = newAxisModel;
    }

    public AxisModel getResponseAxisModel() {
        return this.responseAxisModel;
    }

    public void setResponse2AxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.response2AxisModel = newAxisModel;
    }

    public AxisModel getResponse2AxisModel() {
        return this.response2AxisModel;
    }

    public void setCategoryAxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.categoryAxisModel = newAxisModel;
    }

    public AxisModel getCategoryAxisModel() {
        return this.categoryAxisModel;
    }

    public void setAxisWallModel(AxisWallModel newAxisWallModel) throws IllegalArgumentException {
        if (newAxisWallModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.axisWallModel = newAxisWallModel;
    }

    public AxisWallModel getAxisWallModel() {
        return this.axisWallModel;
    }

    public void setLegendModel(LegendModel newLegendModel) throws IllegalArgumentException {
        if (newLegendModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.legendModel = newLegendModel;
    }

    public LegendModel getLegendModel() {
        return this.legendModel;
    }

    public void setResponseAxisUpperThreshold(double newResponseAxisUpperThreshold) {
        this.responseAxisUpperThreshold = newResponseAxisUpperThreshold;
    }

    public double getResponseAxisUpperThreshold() {
        return this.responseAxisUpperThreshold;
    }

    public void setResponseAxisLowerThreshold(double newResponseAxisLowerThreshold) {
        this.responseAxisLowerThreshold = newResponseAxisLowerThreshold;
    }

    public double getResponseAxisLowerThreshold() {
        return this.responseAxisLowerThreshold;
    }

    public void setResponse2AxisUpperThreshold(double newResponse2AxisUpperThreshold) {
        this.response2AxisUpperThreshold = newResponse2AxisUpperThreshold;
    }

    public double getResponse2AxisUpperThreshold() {
        return this.response2AxisUpperThreshold;
    }

    public void setResponse2AxisLowerThreshold(double newResponse2AxisLowerThreshold) {
        this.response2AxisLowerThreshold = newResponse2AxisLowerThreshold;
    }

    public double getResponse2AxisLowerThreshold() {
        return this.response2AxisLowerThreshold;
    }

    public void setResponseAxisBaselineModel(ReferenceLineModel newResponseAxisBaselineModel) throws IllegalArgumentException {
        if (newResponseAxisBaselineModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.responseAxisBaselineModel = newResponseAxisBaselineModel;
    }

    public ReferenceLineModel getResponseAxisBaselineModel() {
        return this.responseAxisBaselineModel;
    }

    public void setResponse2AxisBaselineModel(ReferenceLineModel newResponse2AxisBaselineModel) throws IllegalArgumentException {
        if (newResponse2AxisBaselineModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.response2AxisBaselineModel = newResponse2AxisBaselineModel;
    }

    public ReferenceLineModel getResponse2AxisBaselineModel() {
        return this.response2AxisBaselineModel;
    }

    public void setOrientation(int newBarOrientation) throws IllegalArgumentException {
        switch (newBarOrientation) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 0: 
            case 1: 
        }
        this.orientation = newBarOrientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setDimension(int newDimension) throws IllegalArgumentException {
        switch (newDimension) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10100: 
            case 10101: 
        }
        this.dimension = newDimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setBarWidth(BaseLength newBarWidth) throws IllegalArgumentException {
        if (newBarWidth == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.barWidth = newBarWidth;
    }

    public BaseLength getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidthSpace(BaseLength newBarWidthSpace) throws IllegalArgumentException {
        if (newBarWidthSpace == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.barWidthSpace = newBarWidthSpace;
    }

    public BaseLength getBarWidthSpace() {
        return this.barWidthSpace;
    }

    public void setBarDepth(BaseLength newBarDepth) throws IllegalArgumentException {
        if (newBarDepth == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.barDepth = newBarDepth;
    }

    public BaseLength getBarDepth() {
        return this.barDepth;
    }

    public void setBarDepthSpace(BaseLength newBarDepthSpace) throws IllegalArgumentException {
        if (newBarDepthSpace == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.barDepthSpace = newBarDepthSpace;
    }

    public BaseLength getBarDepthSpace() {
        return this.barDepthSpace;
    }

    public void setGrowBarWidthEnabled(boolean newGrowBarWidthEnabled) {
        this.growBarWidthEnabled = newGrowBarWidthEnabled;
    }

    public boolean isGrowBarWidthEnabled() {
        return this.growBarWidthEnabled;
    }

    public void setFillAreaEnabled(boolean newFillLineArea) {
        this.fillAreaEnabled = newFillLineArea;
    }

    public boolean isFillAreaEnabled() {
        return this.fillAreaEnabled;
    }

    public void setZeroHeightBarsVisible(boolean newZeroHeightBarsVisible) {
        this.zeroHeightBarsVisible = newZeroHeightBarsVisible;
    }

    public boolean isZeroHeightBarsVisible() {
        return this.zeroHeightBarsVisible;
    }

    public void setStackBarPolicy(int newStackBarPolicy) {
        switch (newStackBarPolicy) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 10201: 
            case 10202: 
        }
        this.stackBarPolicy = newStackBarPolicy;
    }

    public int getStackBarPolicy() {
        return this.stackBarPolicy;
    }

    public void setStackLinePolicy(int newStackLinePolicy) {
        switch (newStackLinePolicy) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 10201: 
            case 10202: 
        }
        this.stackLinePolicy = newStackLinePolicy;
    }

    public int getStackLinePolicy() {
        return this.stackLinePolicy;
    }

    public void setBarShape(int newBarShape) throws IllegalArgumentException {
        switch (newBarShape) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10300: 
            case 10301: 
        }
        this.barShape = newBarShape;
    }

    public int getBarShape() {
        return this.barShape;
    }

    public void setInsideBarLabelContent(int newBarInsideDisplayValue) {
        switch (newBarInsideDisplayValue) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 10601: 
            case 10602: 
            case 10603: 
            case 10608: 
            case 10613: 
            case 10614: 
            case 10615: 
        }
        this.insideBarLabelContent = newBarInsideDisplayValue;
    }

    public int getInsideBarLabelContent() {
        return this.insideBarLabelContent;
    }

    public void setInsideBarLabelTextStyle(AdvancedTextStyle newBarInsideDisplayValueTextStyle) throws IllegalArgumentException {
        if (newBarInsideDisplayValueTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.insideBarLabelTextStyle = newBarInsideDisplayValueTextStyle;
    }

    public AdvancedTextStyle getInsideBarLabelTextStyle() {
        return this.insideBarLabelTextStyle;
    }

    public void setOutsideBarLabelContent(int newOutsideLabelType) {
        switch (newOutsideLabelType) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 10601: 
            case 10602: 
            case 10603: 
            case 10608: 
            case 10614: 
            case 10615: 
        }
        this.outsideBarLabelContent = newOutsideLabelType;
    }

    public int getOutsideBarLabelContent() {
        return this.outsideBarLabelContent;
    }

    public void setOutsideBarLabelTextStyle(AdvancedTextStyle newBarOutsideDisplayValueTextStyle) throws IllegalArgumentException {
        if (newBarOutsideDisplayValueTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.outsideBarLabelTextStyle = newBarOutsideDisplayValueTextStyle;
    }

    public AdvancedTextStyle getOutsideBarLabelTextStyle() {
        return this.outsideBarLabelTextStyle;
    }

    public void setOutsideMarkerLabelContent(int newOutsideLabelType) {
        switch (newOutsideLabelType) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 10601: 
            case 10602: 
            case 10603: 
            case 10608: 
            case 10614: 
            case 10615: 
        }
        this.outsideMarkerLabelContent = newOutsideLabelType;
    }

    public int getOutsideMarkerLabelContent() {
        return this.outsideMarkerLabelContent;
    }

    public void setOutsideMarkerLabelTextStyle(AdvancedTextStyle newLineTopDisplayValueTextStyle) throws IllegalArgumentException {
        if (newLineTopDisplayValueTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.outsideMarkerLabelTextStyle = newLineTopDisplayValueTextStyle;
    }

    public AdvancedTextStyle getOutsideMarkerLabelTextStyle() {
        return this.outsideMarkerLabelTextStyle;
    }

    public void setUniformEnabled(boolean newUniformEnabled) {
        this.setUniformPolicy(newUniformEnabled ? 10201 : 10202);
    }

    public boolean isUniformEnabled() {
        return this.uniformPolicy == 10201;
    }

    public void setUniformPolicy(int newUniformPolicy) throws IllegalArgumentException {
        GraphConstants.TRI.validate(newUniformPolicy);
        this.uniformPolicy = newUniformPolicy;
    }

    public int getUniformPolicy() {
        return this.uniformPolicy;
    }

    public void setColorPaletteType(int newColorPaletteType) throws IllegalArgumentException {
        GraphConstants.COLOR_PALETTE.validate(newColorPaletteType);
        this.colorPaletteType = newColorPaletteType;
    }

    public int getColorPaletteType() {
        return this.colorPaletteType;
    }

    public void setMarkerEnabled(boolean enabledFlag) {
        this.markerEnabled = enabledFlag;
    }

    public boolean isMarkerEnabled() {
        return this.markerEnabled;
    }

    public void setInterpolationEnabled(boolean enabledFlag) {
        this.interpolationEnabled = enabledFlag;
    }

    public boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public void setMissingPolicy(int newMissingPolicy) {
        GraphConstants.TRI.validate(newMissingPolicy);
        this.missingPolicy = newMissingPolicy;
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setMissingResponseEnabled(boolean newMissingEnabled) {
        this.missingResponseEnabled = newMissingEnabled;
    }

    public boolean isMissingResponseEnabled() {
        return this.missingResponseEnabled;
    }

    public void setSkipMissing(boolean newSkipMissing) {
        this.skipMissing = newSkipMissing;
    }

    public boolean isSkipMissing() {
        return this.skipMissing;
    }

    public void setWaterfallEnabled(boolean enabledFlag) {
        this.waterfallEnabled = enabledFlag;
    }

    public boolean isWaterfallEnabled() {
        return this.waterfallEnabled;
    }

    public void setWaterfallFinalBarEnabled(boolean enabledFlag) {
        this.waterfallFinalBarEnabled = enabledFlag;
    }

    public boolean isWaterfallFinalBarEnabled() {
        return this.waterfallFinalBarEnabled;
    }

    public void setWaterfallFinalBarID(String finalBarID) {
        this.waterfallFinalBarID = finalBarID;
    }

    public String getWaterfallFinalBarID() {
        return this.waterfallFinalBarID;
    }

    public void setWaterfallInitialBarHeight(double initialBarHeight) {
        this.waterfallInitialBarHeight = initialBarHeight;
    }

    public double getWaterfallInitialBarHeight() {
        return this.waterfallInitialBarHeight;
    }

    public void setWaterfallInitialBarID(String initialBarId) {
        this.waterfallInitialBarID = initialBarId;
    }

    public String getWaterfallInitialBarID() {
        return this.waterfallInitialBarID;
    }

    public void setTrendlineType(int newTrendlineType) {
        GraphConstants.TRENDLINE.validate(newTrendlineType);
        this.trendlineType = newTrendlineType;
    }

    public int getTrendlineType() {
        return this.trendlineType;
    }

    public void setSkin(int newSkin) throws IllegalArgumentException {
        GraphConstants.SKIN.validate(newSkin);
        this.skin = newSkin;
    }

    public int getSkin() {
        return this.skin;
    }

    public void setConfidenceLimitEnabled(boolean newConfidenceLimitEnabled) {
        this.confidenceLimitEnabled = newConfidenceLimitEnabled;
    }

    public boolean isConfidenceLimitEnabled() {
        return this.confidenceLimitEnabled;
    }
}

