/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.DataTipModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.NoteModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TimeLength;
import com.sas.graphics.components.TimePeriodModel;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationEvent;
import com.sas.graphics.components.animation.AnimationListener;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.measures.BaseDistance;
import com.sas.rpf.Context;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.text.Message;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class Util {
    public static Color newCycledColor(Color[] colors, int pos) {
        if (colors == null || colors.length < 1) {
            return null;
        }
        Color color = colors[pos % colors.length];
        int cycle = pos / colors.length;
        if (cycle > 0) {
            int alpha = color.getAlpha();
            float[] hsbVals = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbVals);
            if (cycle < 5) {
                float cycleFactor = (float)Math.pow(0.8, cycle);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2] * cycleFactor);
            } else if (cycle < 10) {
                float cycleFactor = (float)Math.pow(0.8, cycle - 4);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2]);
            } else if (cycle < 15) {
                float cycleFactor = (float)Math.pow(0.8, cycle - 9);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2] * cycleFactor);
            }
            if (alpha < 255) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
        }
        return color;
    }

    public static abstract class Validator {
        public static void validateSegmentedRange(double[] segmentedRange) throws IllegalArgumentException {
            Validator.validateSegmentedRange(segmentedRange, "");
        }

        public static void validateSegmentedRange(double[] segmentedRange, String rangeName) throws IllegalArgumentException {
            if (rangeName != null && rangeName.trim().length() > 0) {
                rangeName = rangeName.trim() + " ";
            }
            if (segmentedRange == null) {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeNullRangeNotAllowed.ex.fmt.txt"), (Object)rangeName));
            }
            if (segmentedRange.length < 2) {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeSizeLessThanTwo.ex.fmt.txt"), (Object)rangeName));
            }
            double last = Double.NaN;
            boolean ascending = false;
            for (int ii = 0; ii < segmentedRange.length; ++ii) {
                double value = segmentedRange[ii];
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeNaNValueNotAllowed.ex.fmt.txt"), (Object)rangeName));
                }
                if (Double.isInfinite(value)) {
                    throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeInfinityValueNotAllowed.ex.fmt.txt"), (Object)rangeName));
                }
                if (!Double.isNaN(last)) {
                    if (last == value) {
                        throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeDuplicateValueNotAllowed.ex.fmt.txt"), (Object)rangeName));
                    }
                    if (ii == 1 && value > last) {
                        ascending = true;
                    }
                    if (last > value && ascending || last < value && !ascending) {
                        throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeValueOrder.ex.fmt.txt"), (Object)rangeName));
                    }
                }
                last = value;
            }
        }
    }

    public static abstract class Conveyer {
        public static void applyTextStyle(TextStyle from, AdvancedTextStyle to) {
            if (from instanceof AdvancedTextStyle) {
                to.apply((AdvancedTextStyle)from);
            } else {
                to.setBaselineAngle(Double.NaN);
                to.apply(from);
            }
        }

        public static TextStyle applyTextStyle_ReplaceAsNeeded(TextStyle from, TextStyle to) {
            if (to != null && from != null) {
                boolean toIsAdvanced = to instanceof AdvancedTextStyle;
                boolean fromIsAdvanced = from instanceof AdvancedTextStyle;
                if (toIsAdvanced != fromIsAdvanced) {
                    to = fromIsAdvanced ? new AdvancedTextStyle() : new TextStyle();
                    toIsAdvanced = fromIsAdvanced;
                }
                if (toIsAdvanced) {
                    ((AdvancedTextStyle)to).apply((AdvancedTextStyle)from);
                } else {
                    to.apply(from);
                }
            }
            return to;
        }

        public static void applyTextStyle(TextStyle from, NoteModel to) {
            to.setTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(from, to.getTextStyle()));
        }

        public static void applyTextStyle(TextStyle from, DataTipModel to) {
            to.setTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(from, to.getTextStyle()));
        }

        public static void applyGraphStyle(GraphStyle graphStyle, ContentsModel toContentsModel) {
            toContentsModel.setValueTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getValueTextStyle(), toContentsModel.getValueTextStyle()));
            toContentsModel.setLabelTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getLabelTextStyle(), toContentsModel.getLabelTextStyle()));
        }

        public static void applyGraphStyle(GraphStyle graphStyle, AxisModel toAxisModel) {
            Conveyer.applyGraphStyle(graphStyle, (ContentsModel)toAxisModel);
            toAxisModel.getAxisLineStyle().apply(graphStyle.getAxisLineStyle());
            toAxisModel.getGridLineStyle().apply(graphStyle.getGridLineStyle());
            toAxisModel.getMajorTickStyle().apply(graphStyle.getMajorTickStyle());
            toAxisModel.getMinorTickStyle().apply(graphStyle.getMinorTickStyle());
        }

        public static void applyGraphStyle(GraphStyle graphStyle, AxisWallModel toAxisWallModel) {
            toAxisWallModel.getWallFillStyle().apply(graphStyle.getWallFillStyle());
            toAxisWallModel.getFloorFillStyle().apply(graphStyle.getFloorFillStyle());
        }

        public static void applyGraphStyle(GraphStyle graphStyle, LegendModel toLegendModel) {
            Conveyer.applyGraphStyle(graphStyle, (ContentsModel)toLegendModel);
            toLegendModel.getBackgroundFillStyle().apply(graphStyle.getLegendBackgroundFillStyle());
            toLegendModel.getFrameLineStyle().apply(graphStyle.getFrameLineStyle());
            toLegendModel.getShadowStyle().apply(graphStyle.getLegendShadowStyle());
        }

        public static void applyGraphStyle(GraphStyle graphStyle, TableAxisModel totableAxisModel) {
            Color valueCellBackgroundColor;
            FillStyle fs;
            Color labelCellBackgroundColor;
            totableAxisModel.setValueTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getValueTextStyle(), totableAxisModel.getValueTextStyle()));
            totableAxisModel.setLabelTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getLabelTextStyle(), totableAxisModel.getLabelTextStyle()));
            int policy = totableAxisModel.getGridLineStyle().getVisibilityPolicy();
            totableAxisModel.getGridLineStyle().apply(graphStyle.getGridLineStyle());
            totableAxisModel.getGridLineStyle().setVisibilityPolicy(policy);
            LineStyle lineStyle = graphStyle.getColumnRowAxisValueCellFrameLineStyle();
            if (lineStyle == null) {
                lineStyle = graphStyle.getFrameLineStyle();
            }
            if (lineStyle != null) {
                Color lineColor = lineStyle.getColor();
                totableAxisModel.getLabelCellStyle().getFrameLineStyle().setColor(lineColor);
                totableAxisModel.getValueCellStyle().getFrameLineStyle().setColor(lineColor);
            }
            if ((labelCellBackgroundColor = graphStyle.getRowAxisLabelCellBackgroundColor()) == null && (fs = graphStyle.getLegendBackgroundFillStyle()) != null) {
                labelCellBackgroundColor = fs.getSolidFillColor();
            }
            if (labelCellBackgroundColor != null) {
                totableAxisModel.getLabelCellStyle().setBackgroundColors(new Color[]{labelCellBackgroundColor});
            }
            if ((valueCellBackgroundColor = graphStyle.getRowAxisValueCellBackgroundColor()) == null && (fs = graphStyle.getLegendBackgroundFillStyle()) != null) {
                valueCellBackgroundColor = fs.getSolidFillColor();
            }
            if (valueCellBackgroundColor == null && (fs = graphStyle.getWallFillStyle()) != null) {
                valueCellBackgroundColor = fs.getSolidFillColor();
            }
            if (valueCellBackgroundColor != null) {
                totableAxisModel.getValueCellStyle().setBackgroundColors(new Color[]{valueCellBackgroundColor});
            }
        }

        public static void applyGraphStyle(GraphStyle graphStyle, TimePeriodModel timePeriodModel) {
            int justification = timePeriodModel.getTextStyle().getJustification();
            timePeriodModel.setTextStyle(Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getValueTextStyle(), timePeriodModel.getTextStyle()));
            timePeriodModel.getTextStyle().setJustification(justification);
        }

        public static void applyGraphStyle(GraphStyle graphStyle, CompoundTimeAxisModel compoundTimeAxisModel) {
            FillStyle fs;
            Conveyer.applyGraphStyle(graphStyle, compoundTimeAxisModel.getTimePeriodModel1());
            Conveyer.applyGraphStyle(graphStyle, compoundTimeAxisModel.getTimePeriodModel2());
            Conveyer.applyGraphStyle(graphStyle, compoundTimeAxisModel.getTimePeriodModel3());
            int policy = compoundTimeAxisModel.getGridLineStyle().getVisibilityPolicy();
            compoundTimeAxisModel.getGridLineStyle().apply(graphStyle.getGridLineStyle());
            compoundTimeAxisModel.getGridLineStyle().setVisibilityPolicy(policy);
            LineStyle lineStyle = graphStyle.getColumnRowAxisValueCellFrameLineStyle();
            if (lineStyle == null) {
                lineStyle = graphStyle.getFrameLineStyle();
            }
            compoundTimeAxisModel.getValueCellStyle().getFrameLineStyle().apply(lineStyle);
            Color valueCellBackgroundColor = graphStyle.getRowAxisValueCellBackgroundColor();
            if (valueCellBackgroundColor == null && (fs = graphStyle.getLegendBackgroundFillStyle()) != null) {
                valueCellBackgroundColor = fs.getSolidFillColor();
            }
            if (valueCellBackgroundColor == null && (fs = graphStyle.getWallFillStyle()) != null) {
                valueCellBackgroundColor = fs.getSolidFillColor();
            }
            if (valueCellBackgroundColor == null) {
                valueCellBackgroundColor = graphStyle.getRowAxisLabelCellBackgroundColor();
            }
            if (valueCellBackgroundColor != null) {
                compoundTimeAxisModel.getValueCellStyle().setBackgroundColors(new Color[]{valueCellBackgroundColor});
            }
        }

        public static void applyGraphStyle(GraphStyle graphStyle, GraphMatrixAxisModel columnMatrixAxisModel, GraphMatrixAxisModel rowMatrixAxisModel) {
            Conveyer.applyGraphStyle(graphStyle, columnMatrixAxisModel, false);
            Conveyer.applyGraphStyle(graphStyle, rowMatrixAxisModel, true);
        }

        private static void applyGraphStyle(GraphStyle graphStyle, GraphMatrixAxisModel matrixAxisModel, boolean isRowAxisModel) {
            if (graphStyle != null && matrixAxisModel != null) {
                LineStyle valueFrameLineStyle;
                Color valueBackgroundColor = null;
                if (graphStyle.getLegendBackgroundFillStyle() != null) {
                    valueBackgroundColor = graphStyle.getLegendBackgroundFillStyle().getSolidFillColor();
                }
                if ((valueFrameLineStyle = graphStyle.getColumnRowAxisValueCellFrameLineStyle()) == null && graphStyle.getFrameLineStyle() != null) {
                    valueFrameLineStyle = new LineStyle();
                    valueFrameLineStyle.apply(graphStyle.getFrameLineStyle());
                    valueFrameLineStyle.setVisibilityPolicy(10200);
                }
                if (matrixAxisModel != null) {
                    Color c;
                    Conveyer.applyGraphStyle(graphStyle, matrixAxisModel);
                    Color color = c = isRowAxisModel ? graphStyle.getRowAxisValueCellBackgroundColor() : graphStyle.getColumnAxisValueCellBackgroundColor();
                    if (c == null) {
                        c = valueBackgroundColor;
                    }
                    if (c != null) {
                        matrixAxisModel.getValueCellStyle().setBackgroundColors(new Color[]{c});
                    }
                    if (valueFrameLineStyle != null) {
                        matrixAxisModel.getValueCellStyle().getFrameLineStyle().apply(valueFrameLineStyle);
                    }
                    matrixAxisModel.getValueCellStyle().setShadingPolicy(graphStyle.getColumnRowAxisValueShadingPolicy());
                }
            }
        }

        public static final void applyColorScheme(ColorScheme scheme, AxisModel axisModel) {
            Color vc = scheme.getValueColor();
            Color lc = scheme.getLabelColor();
            Color sc = scheme.getShadowColor();
            Color ac = scheme.getAxisLineColor();
            Color gc = scheme.getGridLineColor();
            TextStyle ts = axisModel.getValueTextStyle();
            if (vc != null) {
                ts.setColor(vc);
            }
            if (sc != null) {
                ts.getShadowStyle().setColor(sc);
            }
            ts = axisModel.getLabelTextStyle();
            if (lc != null) {
                ts.setColor(lc);
            }
            if (sc != null) {
                ts.getShadowStyle().setColor(sc);
            }
            if (gc != null) {
                axisModel.getGridLineStyle().setColor(gc);
            }
            if (ac != null) {
                axisModel.getAxisLineStyle().setColor(ac);
            }
            if (scheme.getMajorTickColor() != null) {
                axisModel.getMajorTickStyle().getLineStyle().setColor(scheme.getMajorTickColor());
            }
            if (scheme.getMinorTickColor() != null) {
                axisModel.getMinorTickStyle().getLineStyle().setColor(scheme.getMinorTickColor());
            }
        }

        public static final void applyColorScheme(ColorScheme scheme, LegendModel legendModel) {
            Color vc = scheme.getValueColor();
            Color lc = scheme.getLabelColor();
            Color fc = scheme.getFrameColor();
            Color sc = scheme.getShadowColor();
            TextStyle ts = legendModel.getValueTextStyle();
            if (vc != null) {
                ts.setColor(vc);
            }
            if (sc != null) {
                ts.getShadowStyle().setColor(sc);
            }
            ts = legendModel.getLabelTextStyle();
            if (lc != null) {
                ts.setColor(lc);
            }
            if (sc != null) {
                ts.getShadowStyle().setColor(sc);
            }
            if (fc != null) {
                legendModel.getFrameLineStyle().setColor(fc);
            }
            if (sc != null) {
                legendModel.getShadowStyle().setColor(sc);
            }
            if (scheme.getLegendBackgroundColor() != null) {
                legendModel.getBackgroundFillStyle().setSolidFillColor(scheme.getLegendBackgroundColor());
            }
        }

        public static final void applyColorScheme(ColorScheme scheme, AxisWallModel axisWallModel) {
            if (scheme.getWallColor() != null) {
                axisWallModel.getWallFillStyle().setSolidFillColor(scheme.getWallColor());
            }
            if (scheme.getFloorColor() != null) {
                axisWallModel.getFloorFillStyle().setSolidFillColor(scheme.getFloorColor());
            }
        }

        public static final void applyColorSchemeToValueText(ColorScheme scheme, TextStyle textStyle) {
            Color vc = scheme.getValueColor();
            Color sc = scheme.getShadowColor();
            if (vc != null) {
                textStyle.setColor(vc);
            }
            if (sc != null) {
                textStyle.getShadowStyle().setColor(sc);
            }
        }

        public static final void applyColorSchemeToLabelText(ColorScheme scheme, TextStyle textStyle) {
            Color lc = scheme.getLabelColor();
            Color sc = scheme.getShadowColor();
            if (lc != null) {
                textStyle.setColor(lc);
            }
            if (sc != null) {
                textStyle.getShadowStyle().setColor(sc);
            }
        }

        public static final void applyColorScheme(ColorScheme scheme, GraphMatrixAxisModel columnAxisModel, GraphMatrixAxisModel rowAxisModel) {
            if (scheme != null) {
                Color cfc = scheme.getFrameColor();
                Color cbc = scheme.getLegendBackgroundColor();
                if (rowAxisModel != null) {
                    rowAxisModel.getValueCellStyle().getFrameLineStyle().setColor(cfc);
                    Color rvcbc = scheme.getRowAxisValueCellBackgroundColor();
                    if (rvcbc == null) {
                        rvcbc = cbc;
                    }
                    if (rvcbc != null) {
                        rowAxisModel.getValueCellStyle().setBackgroundColors(new Color[]{rvcbc});
                    }
                    Conveyer.applyColorSchemeToValueText(scheme, rowAxisModel.getValueTextStyle());
                    Conveyer.applyColorSchemeToLabelText(scheme, rowAxisModel.getLabelTextStyle());
                }
                if (columnAxisModel != null) {
                    columnAxisModel.getValueCellStyle().getFrameLineStyle().setColor(cfc);
                    Color cvcbc = scheme.getColumnAxisValueCellBackgroundColor();
                    if (cvcbc == null) {
                        cvcbc = cbc;
                    }
                    if (cvcbc != null) {
                        columnAxisModel.getValueCellStyle().setBackgroundColors(new Color[]{cvcbc});
                    }
                    Conveyer.applyColorSchemeToValueText(scheme, columnAxisModel.getValueTextStyle());
                    Conveyer.applyColorSchemeToLabelText(scheme, columnAxisModel.getLabelTextStyle());
                }
            }
        }
    }

    public static abstract class Copier {
        public static FillStyle copyOf(FillStyle fillStyle) {
            if (fillStyle == null) {
                return null;
            }
            FillStyle copyOfFillStyle = new FillStyle();
            copyOfFillStyle.apply(fillStyle);
            return copyOfFillStyle;
        }

        public static LineStyle copyOf(LineStyle lineStyle) {
            if (lineStyle == null) {
                return null;
            }
            LineStyle copyOfLineStyle = new LineStyle();
            copyOfLineStyle.apply(lineStyle);
            return copyOfLineStyle;
        }

        public static MarkerStyle copyOf(MarkerStyle markerStyle) {
            if (markerStyle == null) {
                return null;
            }
            MarkerStyle copyOfMarkerStyle = new MarkerStyle();
            copyOfMarkerStyle.apply(markerStyle);
            return copyOfMarkerStyle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Color[] copyOf(Color[] colors) {
            if (colors == null) {
                return null;
            }
            Color[] colorArray = colors;
            synchronized (colors) {
                Color[] copyOfColors = new Color[colors.length];
                System.arraycopy(colors, 0, copyOfColors, 0, copyOfColors.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfColors;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static double[] copyOf(double[] doubles) {
            if (doubles == null) {
                return null;
            }
            double[] dArray = doubles;
            synchronized (doubles) {
                double[] copyOfDoubles = new double[doubles.length];
                System.arraycopy(doubles, 0, copyOfDoubles, 0, copyOfDoubles.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfDoubles;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static float[] copyOf(float[] floats) {
            if (floats == null) {
                return null;
            }
            float[] fArray = floats;
            synchronized (floats) {
                float[] copyOfFloats = new float[floats.length];
                System.arraycopy(floats, 0, copyOfFloats, 0, copyOfFloats.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfFloats;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int[] copyOf(int[] ints) {
            if (ints == null) {
                return null;
            }
            int[] nArray = ints;
            synchronized (ints) {
                int[] copyOfInts = new int[ints.length];
                System.arraycopy(ints, 0, copyOfInts, 0, copyOfInts.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfInts;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String[] copyOf(String[] strings) {
            if (strings == null) {
                return null;
            }
            String[] stringArray = strings;
            synchronized (strings) {
                String[] copyOfStrings = new String[strings.length];
                System.arraycopy(strings, 0, copyOfStrings, 0, copyOfStrings.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfStrings;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ColorPosition[] copyOf(ColorPosition[] colorPositions) {
            if (colorPositions == null) {
                return null;
            }
            ColorPosition[] colorPositionArray = colorPositions;
            synchronized (colorPositions) {
                ColorPosition[] copyOfColorPositions = new ColorPosition[colorPositions.length];
                System.arraycopy(colorPositions, 0, copyOfColorPositions, 0, copyOfColorPositions.length);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyOfColorPositions;
            }
        }

        public static CategorizationModel copyOf(CategorizationModel categorizationModel) {
            if (categorizationModel != null) {
                CategorizationModel newCategorizationModel = new CategorizationModel();
                newCategorizationModel.apply(categorizationModel);
                return newCategorizationModel;
            }
            return null;
        }

        public static SegmentedRangeStyle copyOf(SegmentedRangeStyle segmentedRangeStyle) {
            if (segmentedRangeStyle != null) {
                SegmentedRangeStyle newSegmentedRangeStyle = new SegmentedRangeStyle();
                newSegmentedRangeStyle.apply(segmentedRangeStyle);
                return newSegmentedRangeStyle;
            }
            return null;
        }

        public static SegmentedRangeModel copyOf(SegmentedRangeModel segmentedRangeModel) {
            if (segmentedRangeModel != null) {
                SegmentedRangeModel newSegmentedRangeModel = new SegmentedRangeModel();
                newSegmentedRangeModel.apply(segmentedRangeModel);
                return newSegmentedRangeModel;
            }
            return null;
        }

        public static MessageFormat copyOf(MessageFormat messageFormat) {
            return messageFormat != null ? (MessageFormat)messageFormat.clone() : null;
        }
    }

    public static abstract class Evaluate {
        public static boolean isSameObject(Object v1, Object v2) {
            return v1 == v2;
        }

        public static boolean isEqual(Object v1, Object v2) {
            if (v1 instanceof TableModel && v2 instanceof TableModel || v1 instanceof OLAPDataSetInterface && v2 instanceof OLAPDataSetInterface || v1 instanceof ListSelectionModel && v2 instanceof ListSelectionModel || v1 instanceof Context && v2 instanceof Context || v1 instanceof Icon && v2 instanceof Icon) {
                return v1 == v2;
            }
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(OLAPDataSetInterface v1, OLAPDataSetInterface v2) {
            return v1 == v2;
        }

        public static boolean isEqual(TableModel v1, TableModel v2) {
            return v1 == v2;
        }

        public static boolean isEqual(ListSelectionModel v1, ListSelectionModel v2) {
            return v1 == v2;
        }

        public static boolean isEqual(Context v1, Context v2) {
            return v1 == v2;
        }

        public static boolean isEqual(Icon v1, Icon v2) {
            return v1 == v2;
        }

        public static boolean isEqual(ModelBase v1, ModelBase v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(ModelBase[] v1, ModelBase[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(ColorPosition[] v1, ColorPosition[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Font v1, Font v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Locale v1, Locale v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(String[] v1, String[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(String v1, String v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Color[] v1, Color[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Color v1, Color v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(ArrayList v1, ArrayList v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(BaseDistance v1, BaseDistance v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(HashMap v1, HashMap v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(TimeLength v1, TimeLength v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(BasicStroke v1, BasicStroke v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Vector[] v1, Vector[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(Vector v1, Vector v2) {
            return com.sas.util.Util.equal((Vector)v1, (Vector)v2);
        }

        public static boolean isEqual(MessageFormat v1, MessageFormat v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(double[] v1, double[] v2) {
            if (v1 == v2) {
                return true;
            }
            if (v1 == null && v2 == null) {
                return true;
            }
            if (v1 != null && v2 != null && v1.length == v2.length) {
                for (int ii = 0; ii < v1.length; ++ii) {
                    if (Evaluate.isEqual(v1[ii], v2[ii])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static boolean isEqual(double v1, double v2) {
            return Double.compare(v1, v2) == 0;
        }

        public static boolean isEqual(float[] v1, float[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(float v1, float v2) {
            return v1 == v2;
        }

        public static boolean isEqual(int[] v1, int[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(int v1, int v2) {
            return v1 == v2;
        }

        public static boolean isEqual(long[] v1, long[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(long v1, long v2) {
            return v1 == v2;
        }

        public static boolean isEqual(char[] v1, char[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(char v1, char v2) {
            return v1 == v2;
        }

        public static boolean isEqual(boolean[] v1, boolean[] v2) {
            return com.sas.util.Util.equal((Object)v1, (Object)v2);
        }

        public static boolean isEqual(boolean v1, boolean v2) {
            return v1 == v2;
        }
    }

    public static abstract class AnimationDirectorListener
    implements AnimationListener {
        private AnimationDirector animationDirector = null;
        private boolean connected = false;
        private boolean listeningEnabled = true;

        public void setEventSource(AnimationDirector animationDirector) {
            this._disconnect();
            this.animationDirector = animationDirector;
            this._connect();
        }

        public AnimationDirector getEventSource() {
            return this.animationDirector;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setListeningEnabled(boolean enabled) {
            if (this.listeningEnabled != enabled) {
                this.listeningEnabled = enabled;
                if (this.listeningEnabled) {
                    this._connect();
                } else {
                    this._disconnect();
                }
            }
        }

        public boolean isListeningEnabled() {
            return this.listeningEnabled;
        }

        private void _disconnect() {
            if (this.connected && this.animationDirector != null) {
                this.connected = false;
                this.animationDirector.removeAnimationListener(this);
            }
        }

        private void _connect() {
            if (this.listeningEnabled && !this.connected && this.animationDirector != null) {
                this.connected = true;
                this.animationDirector.addAnimationListener(this);
            }
        }

        @Override
        public void animationChanged(final AnimationEvent ae) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.doSetAnimationFrame(ae.getAnimationPosition());
                }
            });
        }

        public abstract void doSetAnimationFrame(AnimationPosition var1);
    }
}

