/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.sparkline;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.sparkline.RB;
import com.sas.graphics.components.sparkline.SparklineDataModel;
import com.sas.graphics.components.sparkline.SparklineModel;
import com.sas.graphics.components.sparkline.SparklineTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.sparkline.SparklineMatrix;
import com.sas.graphics.util.cell.sparkline.SparklineMatrixModel;
import com.sas.rpf.ContextInterface;
import java.util.Locale;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class Sparkline
extends Graph {
    public static final String RB_KEY = "Sparkline.";
    private transient SparklineModel sparklineModel;
    private transient SparklineDataModel dataModel;
    private final transient SparklineMatrix matrix;
    private final transient SparklineMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    private static final String RESPONSE = "responseVariable";

    public Sparkline() {
        this(null, null);
    }

    public Sparkline(SparklineDataModel sparklineDataModel) {
        this(sparklineDataModel, null);
    }

    public Sparkline(SparklineDataModel sparklineDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new SparklineMatrixModel();
        this.matrixModel.setResponseRole(RESPONSE);
        this.matrix = new SparklineMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new SparklineModel());
        GraphStyle thisStyle = defaultGraphStyle != null ? defaultGraphStyle : this.getDefaultGraphStyle();
        this.applyGraphStyle(thisStyle);
        this.dataModelMomento.apply(this.sparklineModel);
        if (sparklineDataModel != null) {
            this.setDataModel(sparklineDataModel);
        }
        this.setGraph(this.matrix);
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(SparklineModel newSparklineModel) throws IllegalArgumentException {
        super.setGraphModel(newSparklineModel);
        SparklineModel oldSparklineModel = this.sparklineModel;
        this.sparklineModel = newSparklineModel;
        this.matrixModel.setGraphModel(this.sparklineModel);
        this.firePropertyChange("graphModel", oldSparklineModel, this.sparklineModel);
    }

    public SparklineModel getGraphModel() {
        return this.sparklineModel;
    }

    public void setDataModel(SparklineDataModel newDataModel) {
        SparklineDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public SparklineDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        DataSource dataSource = null;
        this.dataModelMomento.apply(this.sparklineModel);
        try {
            dataSource = Sparkline._newDataSource(this.dataModel, this.sparklineModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
            }
            this.matrix.setDataSource(dataSource);
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, SparklineDataModel dataModel, SparklineModel sparklineModel) {
        if (dataSource != null) {
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(RESPONSE, 0) instanceof FreqVariableDefinition)) {
                removeIfAllMissing = new Object[]{RESPONSE};
            }
            if (removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(SparklineDataModel dataModel, SparklineModel sparklineModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (sparklineModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof SparklineTableDataModel) {
                dataSource = Sparkline._newDataSource((SparklineTableDataModel)dataModel, sparklineModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(SparklineTableDataModel tableDataModel, SparklineModel sparklineModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (sparklineModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (sparklineModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, false);
            boolean missingDataColumnMessageEnabled = !sparklineModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResponseVariable(), 1), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(RESPONSE) == null) {
                int index = Util.seekNumberColumn(tableModel);
                if (index < 0) {
                    throw new Util.ComponentsMessageException("RequiredResponseDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, RESPONSE, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 1), missingDataColumnMessageEnabled);
            }
            dataSource = Sparkline._applyDataSourceWhereProcessing(dataSource, tableDataModel, sparklineModel);
            return dataSource;
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.sparklineModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        TextStyle labelTextStyle = graphStyle.getLabelTextStyle();
        this.sparklineModel.setResponseLabelTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(labelTextStyle, this.sparklineModel.getResponseLabelTextStyle()));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        Object selectionModel = null;
        if (this.dataModel instanceof SparklineTableDataModel) {
            SparklineTableDataModel tm = (SparklineTableDataModel)this.dataModel;
            model = tm.getModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(SparklineModel sparklineModel) {
            this.apply(sparklineModel);
        }

        public void apply(SparklineModel sparklineModel) {
            this.customOptions = sparklineModel.getCustomOptions() & dataOptions;
        }

        public boolean isApplyDataModel(SparklineModel sparklineModel, DataSource dataSource) {
            if (dataSource != null) {
                return true;
            }
            return this.customOptions != (sparklineModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && super.equals(arg);
        }
    }
}

