/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.scatterplot;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.scatterplot.ScatterPlotDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.storage.olap.OLAPDataSetInterface;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

@SASScope(value="ALL")
public class ScatterPlotOLAPDataModel
extends ScatterPlotDataModel {
    private OLAPDataSetInterface model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean groupEnabled = true;
    private boolean pairingEnabled = false;
    private Variable xVariable;
    private Variable yVariable;
    private Variable y2Variable;
    private Variable sizeVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(ScatterPlotOLAPDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(ScatterPlotOLAPDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.groupEnabled = theOtherModel.groupEnabled;
        this.pairingEnabled = theOtherModel.pairingEnabled;
        this.xVariable = theOtherModel.xVariable;
        this.yVariable = theOtherModel.yVariable;
        this.y2Variable = theOtherModel.y2Variable;
        this.sizeVariable = theOtherModel.sizeVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScatterPlotOLAPDataModel arg = (ScatterPlotOLAPDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.groupEnabled, arg.groupEnabled) && Util.Evaluate.isEqual(this.pairingEnabled, arg.pairingEnabled) && Util.Evaluate.isEqual(this.xVariable, arg.xVariable) && Util.Evaluate.isEqual(this.yVariable, arg.yVariable) && Util.Evaluate.isEqual(this.y2Variable, arg.y2Variable) && Util.Evaluate.isEqual(this.sizeVariable, arg.sizeVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public ScatterPlotOLAPDataModel() {
    }

    public ScatterPlotOLAPDataModel(OLAPDataSetInterface newModel) {
        this();
        this.model = newModel;
    }

    public ScatterPlotOLAPDataModel(OLAPDataSetInterface newModel, boolean newGroupEnabled) {
        this(newModel);
        this.groupEnabled = newGroupEnabled;
    }

    public void setGroupEnabled(boolean newGroupEnabled) {
        boolean oldGroupEnabled = this.groupEnabled;
        this.groupEnabled = newGroupEnabled;
        this.firePropertyChange("groupEnabled", oldGroupEnabled, this.groupEnabled);
    }

    public boolean isGroupEnabled() {
        return this.groupEnabled;
    }

    public void setPairingEnabled(boolean newPairingEnabled) {
        boolean oldPairingEnabled = this.pairingEnabled;
        this.pairingEnabled = newPairingEnabled;
        this.firePropertyChange("pairingEnabled", oldPairingEnabled, this.pairingEnabled);
    }

    public boolean isPairingEnabled() {
        return this.pairingEnabled;
    }

    public void setModel(OLAPDataSetInterface newModel) {
        OLAPDataSetInterface oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setXVariable(Variable newVariable) {
        Variable oldVariable = this.xVariable;
        this.xVariable = newVariable;
        this.firePropertyChange("xVariable", oldVariable, this.xVariable);
    }

    public Variable getXVariable() {
        return this.xVariable;
    }

    public void setYVariable(Variable newVariable) {
        Variable oldVariable = this.yVariable;
        this.yVariable = newVariable;
        this.firePropertyChange("yVariable", oldVariable, this.yVariable);
    }

    public Variable getYVariable() {
        return this.yVariable;
    }

    public void setY2Variable(Variable newVariable) {
        Variable oldVariable = this.y2Variable;
        this.y2Variable = newVariable;
        this.firePropertyChange("y2Variable", oldVariable, this.y2Variable);
    }

    public Variable getY2Variable() {
        return this.y2Variable;
    }

    public void setSizeVariable(Variable newVariable) {
        Variable oldVariable = this.sizeVariable;
        this.sizeVariable = newVariable;
        this.firePropertyChange("sizeVariable", oldVariable, this.sizeVariable);
    }

    public Variable getSizeVariable() {
        return this.sizeVariable;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }
}

