/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.riskmapplot;

import com.sas.graphics.components.RB;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.riskmapplot.AbstractRiskMap;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.SplineConnector;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;

public class SplineRiskMap
extends AbstractRiskMap {
    public List curves;
    public Color[] col;
    private Channel channel;
    private NetworkRoot networkRoot;
    private ContinuousRangeToNumericMap xMap;
    private ContinuousRangeToNumericMap yMap;
    private SegmentedRangeModel xMinMax;
    private SegmentedRangeModel yMinMax;
    private double xDataBegin;
    private double yDataBegin;
    private double xDataEnd;
    private double yDataEnd;
    private List curveList;
    private Color splineColor = Color.BLACK;

    public SplineRiskMap(List lists, Color[] col) {
        int i;
        this.curves = lists;
        this.col = col;
        if (lists == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (col == null) {
            throw new IllegalArgumentException(RB.getStringResource("invalidColorArrayNullNotAllowed.ex.txt"));
        }
        for (i = 0; i < col.length; ++i) {
            if (col[i] != null) continue;
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidArrayNullValueNotAllowed.ex.fmt.txt"), (Object)"color "));
        }
        if (col.length - 1 != lists.size()) {
            throw new IllegalArgumentException(RB.getStringResource("invalidColorArrayLengthOneGreaterThanListOfLines.ex.txt"));
        }
        this.channel = new Channel((Component)new JPanel(), 2);
        this.channel.glDisable(3);
        this.channel.glDisable(4);
        this.curveList = new ArrayList();
        for (i = 0; i < this.curves.size(); ++i) {
            this.curveList.add(new Curve((List)this.curves.get(i), col[i]));
        }
        this.findMinMax(this.curveList);
    }

    @Override
    public Image createImage(int imageWidth, int imageHeight, double xDataBegin, double xDataEnd, double yDataBegin, double yDataEnd) {
        if (xDataBegin == Double.POSITIVE_INFINITY || xDataEnd == Double.POSITIVE_INFINITY || yDataBegin == Double.POSITIVE_INFINITY || yDataEnd == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (xDataBegin == Double.NEGATIVE_INFINITY || xDataEnd == Double.NEGATIVE_INFINITY || yDataBegin == Double.NEGATIVE_INFINITY || yDataEnd == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        if (imageWidth < 1 || imageHeight < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (Double.isNaN(xDataBegin) || Double.isNaN(yDataBegin) || Double.isNaN(xDataEnd) || Double.isNaN(yDataEnd)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        this.xDataBegin = xDataBegin;
        this.yDataBegin = yDataBegin;
        this.xDataEnd = xDataEnd;
        this.yDataEnd = yDataEnd;
        this.createNetwork();
        this.channel.glViewport(0, 0, imageWidth, imageHeight);
        this.channel.glOrtho(0.0, (double)imageWidth, 0.0, (double)imageHeight, -1.0, 1.0);
        this.xMap.setOutputMin(0.0);
        this.xMap.setOutputMax((double)imageWidth);
        this.yMap.setOutputMin(0.0);
        this.yMap.setOutputMax((double)imageHeight);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.channel.setSingleBufferGraphics((Graphics)g2);
        this.channel.glClearColor(this.col[this.col.length - 1]);
        this.channel.glClear(1);
        this.networkRoot.draw();
        return image;
    }

    private void createNetwork() {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                double y2;
                Curve c1 = (Curve)o1;
                Curve c2 = (Curve)o2;
                double y1 = c1.getYControlPoints()[0];
                int result = Double.compare(y1, y2 = c2.getYControlPoints()[0]);
                if (result > 0) {
                    result = -1;
                } else if (result < 0) {
                    result = 1;
                }
                return result;
            }
        };
        Collections.sort(this.curveList, comparator);
        this.xMap = new ContinuousRangeToNumericMap();
        this.xMap.setInputMin(this.xDataBegin);
        this.xMap.setInputMax(this.xDataEnd);
        this.yMap = new ContinuousRangeToNumericMap();
        this.yMap.setInputMin(this.yDataBegin);
        this.yMap.setInputMax(this.yDataEnd);
        this.networkRoot = new NetworkRoot(this.channel);
        for (int i = 0; i < this.curveList.size(); ++i) {
            Curve c = (Curve)this.curveList.get(i);
            NumericVectorVariable x = new NumericVectorVariable();
            x.connectFrom(c.getXControlPoints());
            NumericVectorVariable y = new NumericVectorVariable();
            y.connectFrom(c.getYControlPoints());
            ContinuousRangeToNumericMapper xMapper = new ContinuousRangeToNumericMapper();
            xMapper.setMap(this.xMap);
            xMapper.input.connectFrom(x.value);
            ContinuousRangeToNumericMapper yMapper = new ContinuousRangeToNumericMapper();
            yMapper.setMap(this.yMap);
            yMapper.input.connectFrom(y.value);
            SplineConnector spline = new SplineConnector();
            spline.pointX.connectFrom(xMapper.value);
            spline.pointY.connectFrom(yMapper.value);
            spline.fillOn.setValue(true);
            spline.color.setValue(this.getSplineColor());
            spline.fillColor.setValue(c.getFillColor());
            this.networkRoot.addElement((Element)spline);
        }
    }

    private void findMinMax(List curveList) {
        double tempMinX = Double.MAX_VALUE;
        double tempMaxX = Double.MIN_VALUE;
        double tempMinY = Double.MAX_VALUE;
        double tempMaxY = Double.MIN_VALUE;
        double[] tempArrayX = null;
        double[] tempArrayY = null;
        for (int i = curveList.size() - 1; i >= 0; --i) {
            Curve TempList = (Curve)curveList.get(i);
            tempArrayX = TempList.getXControlPoints();
            tempArrayY = TempList.getYControlPoints();
            for (int j = 0; j < tempArrayX.length; ++j) {
                if (tempArrayX[j] < tempMinX) {
                    tempMinX = Math.min(tempMinX, tempArrayX[j]);
                }
                if (tempArrayX[j] > tempMaxX) {
                    tempMaxX = Math.max(tempMaxX, tempArrayX[j]);
                }
                if (tempArrayY[j] < tempMinY) {
                    tempMinY = Math.min(tempMinY, tempArrayY[j]);
                }
                if (!(tempArrayY[j] > tempMaxY)) continue;
                tempMaxY = Math.max(tempMaxY, tempArrayY[j]);
            }
        }
        this.xMinMax = SegmentedRangeModel.newSegmentedRangeModel(new double[]{tempMinX, tempMaxX});
        this.yMinMax = SegmentedRangeModel.newSegmentedRangeModel(new double[]{tempMinY, tempMaxY});
    }

    @Override
    public double[] getXSegmentedRange() {
        return this.xMinMax.getSegmentedRange();
    }

    @Override
    public double[] getYSegmentedRange() {
        return this.yMinMax.getSegmentedRange();
    }

    public void setSplineColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("invalidSplineBoundaryColor.ex.txt"));
        }
        this.splineColor = newColor;
    }

    public Color getSplineColor() {
        return this.splineColor;
    }

    class Curve {
        private double[] xControlPoints;
        private double[] yControlPoints;
        private Color color;

        public Curve(List l, Color color) {
            int n = l.size();
            this.xControlPoints = new double[n];
            this.yControlPoints = new double[n];
            for (int i = 0; i < n; ++i) {
                Point2D.Double p = (Point2D.Double)l.get(i);
                this.xControlPoints[i] = p.x;
                this.yControlPoints[i] = p.y;
            }
            this.color = color;
        }

        private double[] getXControlPoints() {
            return this.xControlPoints;
        }

        private double[] getYControlPoints() {
            return this.yControlPoints;
        }

        private Color getFillColor() {
            return this.color;
        }
    }
}

