/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.riskmapplot;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.riskmapplot.RiskMapPlotDataModel;
import com.sas.graphics.components.riskmapplot.RiskMapPlotModel;
import com.sas.graphics.components.riskmapplot.RiskMapPlotTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrix;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixModel;
import com.sas.rpf.ContextInterface;
import java.awt.Color;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class RiskMapPlot
extends Graph {
    public static final String RB_KEY = "RiskMapPlot.";
    private transient RiskMapPlotDataModel dataModel;
    private transient RiskMapPlotModel riskMapPlotModel;
    private final transient ScatterPlotMatrix matrix;
    private final transient ScatterPlotMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String X = "xVariable";
    private static final String Y = "yVariable";
    private static final String COLOR = "colorVariable";
    private static final String SHAPE = "shapeVariable";
    private static final String SIZE = "sizeVariable";
    private static final String GROUP = "groupVariable";
    private static final String TOP_MARKER_LABEL = "topMarkerLabelVariable";
    private static final String BOTTOM_MARKER_LABEL = "belowValueVariable";
    private static final String SORT = "sortVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String X_SELECTION = "xselectionVariable";
    private static final String Y_SELECTION = "yselectionVariable";
    private static final String SIZE_SELECTION = "sizeselectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public RiskMapPlot() {
        this(null, null);
    }

    public RiskMapPlot(RiskMapPlotDataModel riskMapPlotDataModel) {
        this(riskMapPlotDataModel, null);
    }

    public RiskMapPlot(RiskMapPlotDataModel riskMapPlotDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new ScatterPlotMatrixModel();
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setXRole(X);
        this.matrixModel.setYRole(Y);
        this.matrixModel.setColorRole(COLOR);
        this.matrixModel.setShapeRole(SHAPE);
        this.matrixModel.setSizeRole(SIZE);
        this.matrixModel.setGroupRole(GROUP);
        this.matrixModel.setAboveValueRole(TOP_MARKER_LABEL);
        this.matrixModel.setBelowValueRole(BOTTOM_MARKER_LABEL);
        this.matrixModel.setSortRole(SORT);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setXSelectionRole(X_SELECTION);
        this.matrixModel.setYSelectionRole(Y_SELECTION);
        this.matrixModel.setSizeSelectionRole(SIZE_SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrixModel.setLabelRanges(new Boolean(true));
        this.matrix = new ScatterPlotMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new RiskMapPlotModel());
        this.applyGraphStyle(defaultGraphStyle != null ? defaultGraphStyle : this.getDefaultGraphStyle());
        this.dataModelMomento.apply(this.riskMapPlotModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimePlotTableData(), Util.getLocale(this), 10475), true, false);
                dataSource.setVariableDefinition(X, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("X")));
                dataSource.setVariableDefinition(Y, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Y")));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (riskMapPlotDataModel != null) {
            this.setDataModel(riskMapPlotDataModel);
        }
        this.setGraph(this.matrix);
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(RiskMapPlotModel newRiskMapPlotModel) throws IllegalArgumentException {
        super.setGraphModel(newRiskMapPlotModel);
        RiskMapPlotModel oldRiskMapPlotModel = this.riskMapPlotModel;
        this.riskMapPlotModel = newRiskMapPlotModel;
        this.matrixModel.setGraphModel(this.riskMapPlotModel);
        this.matrixModel.setScatterPlotModel(this.riskMapPlotModel.getRiskMapPlotModel());
        this.firePropertyChange("graphModel", oldRiskMapPlotModel, newRiskMapPlotModel);
    }

    public RiskMapPlotModel getGraphModel() {
        return this.riskMapPlotModel;
    }

    public void setDataModel(RiskMapPlotDataModel newDataModel) {
        RiskMapPlotDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public RiskMapPlotDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel xAxisModel = this.riskMapPlotModel.getXAxisModel();
        AxisModel yAxisModel = this.riskMapPlotModel.getYAxisModel();
        AxisWallModel axisWallModel = this.riskMapPlotModel.getAxisWallModel();
        LegendModel colorLegendModel = this.riskMapPlotModel.getColorLegendModel();
        LegendModel shapeLegendModel = this.riskMapPlotModel.getShapeLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, xAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, yAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, colorLegendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, shapeLegendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.riskMapPlotModel.getColumnAxisModel(), this.riskMapPlotModel.getRowAxisModel());
        StrokeLineStyle axisLineStyle = graphStyle.getAxisLineStyle();
        this.riskMapPlotModel.getNeedleLineStyle().apply(axisLineStyle);
        TextStyle dataLabelTextStyle = graphStyle.getDataLabelTextStyle();
        Util.Conveyer.applyTextStyle(dataLabelTextStyle, this.riskMapPlotModel.getBottomMarkerLabelTextStyle());
        Util.Conveyer.applyTextStyle(dataLabelTextStyle, this.riskMapPlotModel.getTopMarkerLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getColumnAxisModel(), this.riskMapPlotModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getColorLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getShapeLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getXAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getYAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.riskMapPlotModel.getAxisWallModel());
        if (scheme.getAxisLineColor() != null) {
            this.riskMapPlotModel.getNeedleLineStyle().setColor(scheme.getAxisLineColor());
        }
        Color vc = scheme.getDataLabelColor();
        Color sc = scheme.getShadowColor();
        AdvancedTextStyle bottomLabel = this.riskMapPlotModel.getBottomMarkerLabelTextStyle();
        AdvancedTextStyle topLabel = this.riskMapPlotModel.getTopMarkerLabelTextStyle();
        if (vc != null) {
            bottomLabel.setColor(vc);
            topLabel.setColor(vc);
        }
        if (sc != null) {
            topLabel.getShadowStyle().setColor(sc);
            bottomLabel.getShadowStyle().setColor(sc);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public PlotImageMapInfo getImageMapInfo() {
        PlotImageMapInfo2 plotImageMapInfo = null;
        PlotImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (plotImageMapInfo == null) {
                    plotImageMapInfo = new PlotImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                plotImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return plotImageMapInfo;
    }

    @Override
    protected void applyDataModel() {
        DataSource ds;
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.riskMapPlotModel);
        DataSource sds = this.matrix.getSelectionDataSource();
        if (sds != null) {
            this.matrix.setSelectionDataSource(null);
            sds.setSelectionModel(null);
        }
        if ((ds = this.matrix.getDataSource()) != null) {
            ds.setSelectionModel(null);
        }
        try {
            DataSource dataSource = RiskMapPlot._newDataSource(this.dataModel, this.riskMapPlotModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (dataSource != null && this.dataModel != null) {
                RiskMapPlotTableDataModel tableDataModel;
                if (this.dataModel instanceof RiskMapPlotTableDataModel && (tableDataModel = (RiskMapPlotTableDataModel)this.dataModel).getSelectionModel() != null) {
                    DataSource selectionDataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getModel(), Util.getFormatLocale(this, tableDataModel), tableDataModel.getSortStrategy()), true, false);
                    selectionDataSource.setSelectionModel(tableDataModel.getSelectionModel(), true);
                    dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                    this.setSelectionVarDef(dataSource, selectionDataSource, COLUMN);
                    this.setSelectionVarDef(dataSource, selectionDataSource, ROW);
                    this.setSelectionVarDef(dataSource, selectionDataSource, X);
                    this.setSelectionVarDef(dataSource, selectionDataSource, Y);
                    this.setSelectionVarDef(dataSource, selectionDataSource, GROUP);
                    this.setSelectionVarDef(dataSource, selectionDataSource, COLOR);
                    this.setSelectionVarDef(dataSource, selectionDataSource, SIZE);
                    this.setSelectionVarDef(dataSource, selectionDataSource, SHAPE);
                    this.setSelectionVarDef(dataSource, selectionDataSource, TOP_MARKER_LABEL);
                    this.setSelectionVarDef(dataSource, selectionDataSource, BOTTOM_MARKER_LABEL);
                    this.matrix.setSelectionDataSource(selectionDataSource);
                }
                if (this.dataModel.getRulesContext() != null) {
                    String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                    String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{X, Y}, ruleTargetVariableNameID);
                    this.matrixModel.setRuleTargetIdentifier(columnName);
                }
            }
            this.matrix.setDataSource(dataSource);
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, RiskMapPlotDataModel dataModel, RiskMapPlotModel riskMapPlotModel) {
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (riskMapPlotModel.getMissingPolicy()) {
                default: {
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{COLUMN, ROW, GROUP};
                }
                case 10201: 
            }
            if (removeIfAnyMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
            }
        }
        return dataSource;
    }

    private void setSelectionVarDef(DataSource fromDataSource, DataSource toDataSource, Object role) {
        VariableDefinition vd = fromDataSource.getVariableDefinition(role, 0);
        if (vd != null) {
            try {
                toDataSource.setVariableDefinition(role, vd);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static DataSource _newDataSource(RiskMapPlotDataModel dataModel, RiskMapPlotModel riskMapPlotModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (riskMapPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof RiskMapPlotTableDataModel) {
                dataSource = RiskMapPlot._newDataSource((RiskMapPlotTableDataModel)dataModel, riskMapPlotModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(RiskMapPlotTableDataModel tableDataModel, RiskMapPlotModel riskMapPlotModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (riskMapPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (riskMapPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            Variable sv;
            boolean autoY;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getModel(), formatLocale, tableDataModel.getSortStrategy()), true, false);
            boolean missingDataColumnMessageEnabled = !riskMapPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, X, "xRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getXVariable(), 16), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, Y, "yRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getYVariable(), 16), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SORT, "sortRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSortVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, GROUP, "groupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getGroupVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, COLOR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SIZE, "sizeRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSizeVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SHAPE, "shapeRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getShapeVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, TOP_MARKER_LABEL, "topMarkerLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getTopMarkerLabelVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, BOTTOM_MARKER_LABEL, "bottomMarkerLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBottomMarkerLabelVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            boolean autoX = dataSource.getVariableDefinition(X) == null;
            boolean bl = autoY = dataSource.getVariableDefinition(Y) == null;
            if (autoX || autoY) {
                int[] avoidY;
                int xIndex = autoX ? -1 : tableModel.getColumnCount();
                int yIndex = autoY ? -1 : tableModel.getColumnCount();
                int[] avoidX = autoX ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(X));
                int[] nArray = avoidY = autoY ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(Y));
                if (xIndex < 0) {
                    int[] nArray2;
                    String xName = RB.getStringResource("Graph.", "xRole.txt");
                    xIndex = Util.seekNamedColumn(tableModel, xName, avoidY);
                    if (xIndex >= 0) {
                        int[] nArray3 = new int[1];
                        nArray2 = nArray3;
                        nArray3[0] = xIndex;
                    } else {
                        nArray2 = avoidX = null;
                    }
                }
                if (yIndex < 0) {
                    int[] nArray4;
                    String yName = RB.getStringResource("Graph.", "yRole.txt");
                    yIndex = Util.seekNamedColumn(tableModel, yName, avoidX);
                    if (yIndex >= 0) {
                        int[] nArray5 = new int[1];
                        nArray4 = nArray5;
                        nArray5[0] = yIndex;
                    } else {
                        nArray4 = avoidY = null;
                    }
                }
                if (xIndex < 0 && yIndex < 0) {
                    yIndex = Util.seekNumberColumn(tableModel);
                    if (yIndex >= 0) {
                        xIndex = Util.seekNumberColumn(tableModel, new int[]{yIndex});
                        if (xIndex >= 0) {
                            int tmp = yIndex;
                            yIndex = xIndex;
                            xIndex = tmp;
                        } else {
                            int[] nArray6;
                            if (yIndex >= 0) {
                                int[] nArray7 = new int[1];
                                nArray6 = nArray7;
                                nArray7[0] = yIndex;
                            } else {
                                nArray6 = null;
                            }
                            avoidY = nArray6;
                        }
                    }
                } else if (yIndex < 0) {
                    int[] nArray8;
                    yIndex = Util.seekNumberColumn(tableModel, avoidX);
                    if (yIndex >= 0) {
                        int[] nArray9 = new int[1];
                        nArray8 = nArray9;
                        nArray9[0] = yIndex;
                    } else {
                        nArray8 = null;
                    }
                    avoidY = nArray8;
                } else if (xIndex < 0) {
                    int[] nArray10;
                    xIndex = Util.seekNumberColumn(tableModel, avoidY);
                    if (xIndex >= 0) {
                        int[] nArray11 = new int[1];
                        nArray10 = nArray11;
                        nArray11[0] = xIndex;
                    } else {
                        nArray10 = avoidX = null;
                    }
                }
                if (xIndex < 0) {
                    int[] nArray12;
                    xIndex = Util.seekDateColumn(tableModel, avoidY);
                    if (xIndex < 0) {
                        xIndex = Util.seekStringColumn(tableModel, avoidY);
                    }
                    if (xIndex < 0) {
                        xIndex = Util.seekNonNullColumn(tableModel, avoidY);
                    }
                    if (xIndex < 0) {
                        xIndex = Util.seekNonNullColumn(tableModel, null);
                    }
                    if (xIndex < 0) {
                        xIndex = 0;
                    }
                    if (xIndex >= 0) {
                        int[] nArray13 = new int[1];
                        nArray12 = nArray13;
                        nArray13[0] = xIndex;
                    } else {
                        nArray12 = avoidX = null;
                    }
                }
                if (yIndex < 0) {
                    yIndex = Util.seekDateColumn(tableModel, avoidX);
                    if (yIndex < 0) {
                        yIndex = Util.seekStringColumn(tableModel, avoidX);
                    }
                    if (yIndex < 0) {
                        yIndex = Util.seekNonNullColumn(tableModel, avoidX);
                    }
                    if (yIndex < 0) {
                        yIndex = Util.seekNonNullColumn(tableModel);
                    }
                    if (yIndex < 0) {
                        yIndex = 0;
                    }
                }
                if (autoX) {
                    dataSource.setVariableDefinition(X, new VariableDefinition(new Integer(xIndex), null, null, 0));
                }
                if (autoY) {
                    dataSource.setVariableDefinition(Y, new VariableDefinition(new Integer(yIndex), null, null, 0));
                }
            }
            if ((sv = tableDataModel.getSortVariable()) != null) {
                Integer sort = sv instanceof ClassificationVariable ? new Integer(((ClassificationVariable)sv).getSort()) : new Integer(10401);
                VariableDefinition catSortVarDef = sv.getColumnName() != null ? new VariableDefinition(sv.getColumnName(), sv.getFormat(), sv.getInformat(), sv.getLabel(), sort, null, null, null, null, null, null, null, 0) : new VariableDefinition(new Integer(sv.getColumnIndex()), sv.getFormat(), sv.getInformat(), sv.getLabel(), sort, null, null, null, null, null, null, null, 0);
                dataSource.setVariableDefinition(SORT, catSortVarDef);
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("isSelected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = RiskMapPlot._applyDataSourceWhereProcessing(dataSource, tableDataModel, riskMapPlotModel);
            return dataSource;
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.riskMapPlotModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof RiskMapPlotTableDataModel) {
            RiskMapPlotTableDataModel tm = (RiskMapPlotTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(RiskMapPlotModel riskMapPlotModel) {
            this.apply(riskMapPlotModel);
        }

        public void apply(RiskMapPlotModel riskMapPlotModel) {
            this.customOptions = riskMapPlotModel.getCustomOptions() & dataOptions;
            this.missingPolicy = riskMapPlotModel.getMissingPolicy();
        }

        public boolean isApplyDataModel(RiskMapPlotModel riskMapPlotModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != riskMapPlotModel.getMissingPolicy();
            }
            return this.customOptions != (riskMapPlotModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && super.equals(arg);
        }
    }
}

