/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.radarchart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.radarchart.RadarChartDataModel;
import com.sas.graphics.components.radarchart.RadarChartModel;
import com.sas.graphics.components.radarchart.RadarChartOLAPDataModel;
import com.sas.graphics.components.radarchart.RadarChartTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.radarchart.RadarChartMatrix;
import com.sas.graphics.util.cell.radarchart.RadarChartMatrixModel;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class RadarChart
extends Graph {
    private transient RadarChartModel radarChartModel;
    private transient RadarChartDataModel dataModel;
    private transient RadarChartMatrix matrix;
    private transient RadarChartMatrixModel matrixModel;
    final DataModelMomento dataModelMomento = new DataModelMomento();
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String CATEGORY = "categoryVariable";
    private static final String SUBGROUP = "subgroupVariable";
    private static final String RESPONSE = "responseVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public RadarChart() {
        this(null, null);
    }

    public RadarChart(RadarChartDataModel radarChartDataModel) {
        this(radarChartDataModel, null);
    }

    public RadarChart(RadarChartDataModel radarChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new RadarChartMatrixModel();
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setCategoryRole(CATEGORY);
        this.matrixModel.setSubgroupRole(SUBGROUP);
        this.matrixModel.setResponseRole(RESPONSE);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new RadarChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new RadarChartModel());
        this.applyGraphStyle(defaultGraphStyle == null ? this.getDefaultGraphStyle() : defaultGraphStyle);
        this.dataModelMomento.apply(this.radarChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category")));
                dataSource.setVariableDefinition(RESPONSE, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response")));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (radarChartDataModel != null) {
            this.setDataModel(radarChartDataModel);
        }
        this.setGraph(this.matrix);
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public void setGraphModel(RadarChartModel newRadarChartModel) throws IllegalArgumentException {
        super.setGraphModel(newRadarChartModel);
        RadarChartModel oldRadarChartModel = this.radarChartModel;
        this.radarChartModel = newRadarChartModel;
        this.matrixModel.setRadarChartModel(this.radarChartModel);
        this.firePropertyChange("graphModel", oldRadarChartModel, newRadarChartModel);
    }

    public RadarChartModel getGraphModel() {
        return this.radarChartModel;
    }

    public void setDataModel(RadarChartDataModel newDataModel) {
        RadarChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public RadarChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.radarChartModel);
        try {
            DataSource dataSource = RadarChart._newDataSource(this.dataModel, this.radarChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            this.matrix.setDataSource(dataSource);
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, RadarChartDataModel dataModel, RadarChartModel radarChartModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (radarChartModel.getMissingPolicy()) {
                default: {
                    removeIfAnyMissing = new Object[]{CATEGORY};
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{COLUMN, ROW, CATEGORY, SUBGROUP};
                }
                case 10201: 
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(RESPONSE, 0) instanceof FreqVariableDefinition)) {
                // empty if block
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(RadarChartDataModel dataModel, RadarChartModel radarChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof RadarChartTableDataModel) {
                dataSource = RadarChart._newDataSource((RadarChartTableDataModel)dataModel, radarChartModel, locale, formatLocale, listSelectionListener);
            } else if (dataModel instanceof RadarChartOLAPDataModel) {
                dataSource = RadarChart._newDataSource((RadarChartOLAPDataModel)dataModel, radarChartModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(RadarChartTableDataModel tableDataModel, RadarChartModel radarChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, true);
            boolean missingDataColumnMessageEnabled = !radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCategoryVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(CATEGORY) == null) {
                int index = -1;
                index = Util.seekStringColumn(tableModel);
                if (index < 0) {
                    index = Util.seekDateColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNumberColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNonNullColumn(tableModel);
                }
                if (index < 0) {
                    index = 0;
                }
                Util.setVariableDefinition(dataSource, CATEGORY, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSubgroupVariable(), 10), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResponseVariable(), 1), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(RESPONSE) == null) {
                Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = RadarChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, radarChartModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(RadarChartOLAPDataModel olapDataModel, RadarChartModel radarChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                OLAPVariableFactory gtkOLAPFactory = (OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    String levelName;
                    int i;
                    DataSource dataSource = new DataSource(new com.sas.graphics.util.cell.OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    String categoryName = null;
                    String subgroupName = null;
                    String mostDetailed = null;
                    String secondMostDetailed = null;
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    if (columnHierarchyNames.size() > 0) {
                        mostDetailed = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        if (columnHierarchyNames.size() > 0) {
                            secondMostDetailed = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        }
                    }
                    if (rowHierarchyNames.size() > 0) {
                        if (mostDetailed == null) {
                            mostDetailed = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                        if (rowHierarchyNames.size() > 0 && secondMostDetailed == null) {
                            secondMostDetailed = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                    }
                    if (olapDataModel.isSubgroupEnabled() && mostDetailed != null && secondMostDetailed != null) {
                        subgroupName = mostDetailed;
                        categoryName = secondMostDetailed;
                    } else if (mostDetailed != null) {
                        categoryName = mostDetailed;
                    }
                    if (categoryName == null) {
                        throw new Util.ComponentsMessageException("RequiredCategoryDataNotFound.txt", locale);
                    }
                    ClassificationVariableDefinition category = new ClassificationVariableDefinition(categoryName, null, null, 0);
                    Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, category, missingDataColumnMessageEnabled);
                    if (subgroupName != null) {
                        ClassificationVariableDefinition subgroup = new ClassificationVariableDefinition(subgroupName, null, null, 0);
                        Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, subgroup, missingDataColumnMessageEnabled);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            levelName = (String)columnHierarchyNames.get(i);
                            columns = new ClassificationVariableDefinition(levelName, null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            levelName = (String)rowHierarchyNames.get(i);
                            rows = new ClassificationVariableDefinition(levelName, null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    if (measureNames.size() > 0) {
                        AnalysisVariableDefinition measures = null;
                        for (i = 0; i < 1; ++i) {
                            String measureName = (String)measureNames.get(i);
                            measures = new AnalysisVariableDefinition(measureName, gtkOLAPFactory.getFormat(measureName), measures, 0);
                        }
                        Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, measures, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, SELECTION, measureNames, missingDataColumnMessageEnabled);
                        }
                    }
                    List allMeasureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (int ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], allMeasureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (int ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], allMeasureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = RadarChart._applyDataSourceWhereProcessing(dataSource, olapDataModel, radarChartModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (radarChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.radarChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    public synchronized void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel axisModel = this.radarChartModel.getAxisModel();
        LegendModel colorLegendModel = this.radarChartModel.getColorLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, axisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, colorLegendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.radarChartModel.getColumnAxisModel(), this.radarChartModel.getRowAxisModel());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.radarChartModel.getColumnAxisModel(), this.radarChartModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.radarChartModel.getColorLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.radarChartModel.getAxisModel());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof RadarChartTableDataModel) {
            RadarChartTableDataModel tm = (RadarChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof RadarChartOLAPDataModel) {
            RadarChartOLAPDataModel om = (RadarChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    @SASScope
    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(RadarChartModel radarChartModel) {
            this.apply(radarChartModel);
        }

        public void apply(RadarChartModel radarChartModel) {
            this.customOptions = radarChartModel.getCustomOptions() & dataOptions;
            this.missingPolicy = radarChartModel.getMissingPolicy();
        }

        public boolean isApplyDataModel(RadarChartModel radarChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != radarChartModel.getMissingPolicy();
            }
            return this.customOptions != (radarChartModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && super.equals(arg);
        }
    }
}

