/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.piechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class PieChartSubgroupModel
extends ContentsModel {
    private int placement = 3;
    private boolean drillIconVisible = false;

    public void apply(PieChartSubgroupModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        super.apply(theOtherObject);
        this.placement = theOtherObject.placement;
        this.drillIconVisible = theOtherObject.drillIconVisible;
        this.firePropertyChange("", null, this);
    }

    public void setPlacement(int newPlacement) {
        switch (newPlacement) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 3: 
            case 7: 
            case 10601: 
        }
        int oldPlacement = this.placement;
        this.placement = newPlacement;
        this.firePropertyChange("placement", oldPlacement, newPlacement);
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setDrillIconVisible(boolean newVis) {
        boolean oldVis = this.drillIconVisible;
        this.drillIconVisible = newVis;
        this.firePropertyChange("drillIconVisible", oldVis, newVis);
    }

    public boolean isDrillIconVisible() {
        return this.drillIconVisible;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PieChartSubgroupModel arg = (PieChartSubgroupModel)obj;
        return Util.Evaluate.isEqual(this.placement, arg.placement) && Util.Evaluate.isEqual(this.drillIconVisible, arg.drillIconVisible) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

