/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.piechart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.piechart.PieChartDataModel;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.graphics.components.piechart.PieChartOLAPDataModel;
import com.sas.graphics.components.piechart.PieChartSubgroupModel;
import com.sas.graphics.components.piechart.PieChartTableDataModel;
import com.sas.graphics.components.piechart.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.piechart.PieChartMatrix;
import com.sas.graphics.util.cell.piechart.PieChartMatrixModel;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class PieChart
extends Graph {
    public static final String RB_KEY = "PieChart.";
    private transient PieChartModel pieChartModel;
    private transient PieChartDataModel dataModel;
    private final transient PieChartMatrix matrix;
    private final transient PieChartMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            PieChart.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String CATEGORY = "categoryVariable";
    private static final String STYLE_BY = "styleByVariable";
    private static final String SUBGROUP = "subgroupVariable";
    private static final String RESPONSE = "responseVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public PieChart() {
        this(null, null);
    }

    public PieChart(PieChartDataModel pieChartDataModel) {
        this(pieChartDataModel, null);
    }

    public PieChart(PieChartDataModel pieChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new PieChartMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setStyleByRole(STYLE_BY);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setCategoryRole(CATEGORY);
        this.matrixModel.setSubgroupRole(SUBGROUP);
        this.matrixModel.setResponseRole(RESPONSE);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new PieChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new PieChartModel());
        this.applyGraphStyle(defaultGraphStyle == null ? this.getDefaultGraphStyle() : defaultGraphStyle);
        this.dataModelMomento.apply(this.pieChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category"), 2));
                dataSource.setVariableDefinition(RESPONSE, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response"), 1));
                dataSource.setVariableDefinition(STYLE_BY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category", null, null, null, 10401), 2));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (pieChartDataModel != null) {
            this.setDataModel(pieChartDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(PieChartModel newPieChartModel) throws IllegalArgumentException {
        super.setGraphModel(newPieChartModel);
        PieChartModel oldPieChartModel = this.pieChartModel;
        this.pieChartModel = newPieChartModel;
        this.matrixModel.setPieChartModel(this.pieChartModel);
        this.firePropertyChange("graphModel", oldPieChartModel, newPieChartModel);
    }

    public PieChartModel getGraphModel() {
        return this.pieChartModel;
    }

    public void setDataModel(PieChartDataModel newDataModel) {
        PieChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public PieChartDataModel getDataModel() {
        return this.dataModel;
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    protected void applyDataModel() {
        DataSource dataSource = null;
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.pieChartModel);
        this.animationListener.setEventSource(null);
        try {
            TableModel tableModel;
            dataSource = PieChart._newDataSource(this.dataModel, this.pieChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{RESPONSE}, ruleTargetVariableNameID);
                this.matrixModel.setRuleTargetIdentifier(columnName);
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof PieChartTableDataModel && (tableModel = ((PieChartTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
            return;
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, PieChartDataModel dataModel, PieChartModel pieChartModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (pieChartModel.getMissingPolicy()) {
                default: {
                    removeIfAnyMissing = new Object[]{CATEGORY};
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{ANIMATION_KEY_FRAME, COLUMN, ROW, CATEGORY, SUBGROUP};
                }
                case 10201: 
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(RESPONSE, 0) instanceof FreqVariableDefinition)) {
                removeIfAllMissing = new Object[]{RESPONSE};
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(PieChartDataModel dataModel, PieChartModel pieChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof PieChartTableDataModel) {
                dataSource = PieChart._newDataSource((PieChartTableDataModel)dataModel, pieChartModel, locale, formatLocale, listSelectionListener);
            } else if (dataModel instanceof PieChartOLAPDataModel) {
                dataSource = PieChart._newDataSource((PieChartOLAPDataModel)dataModel, pieChartModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(PieChartTableDataModel tableDataModel, PieChartModel pieChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            boolean missingDataColumnMessageEnabled;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, tableDataModel.isStatisticEnabled());
            boolean bl = missingDataColumnMessageEnabled = !pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            if (tableModel instanceof AnimationDirector) {
                AnimationDirector atm = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getKeyFrameVariable()), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSubgroupVariable(), 10), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCategoryVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResponseVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(CATEGORY) == null && tableModel instanceof AnimationDirector) {
                AnimationDirector animationDirector = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(animationDirector.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(CATEGORY) == null) {
                int index = -1;
                index = Util.seekStringColumn(tableModel);
                if (index < 0) {
                    index = Util.seekDateColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNumberColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNonNullColumn(tableModel);
                }
                if (index < 0) {
                    index = 0;
                }
                Util.setVariableDefinition(dataSource, CATEGORY, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(RESPONSE) == null) {
                if (!tableDataModel.isStatisticEnabled()) {
                    throw new Util.ComponentsMessageException("RequiredResponseDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, RESPONSE, "responseRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
            }
            Util.setLegendVariable(dataSource, STYLE_BY, CATEGORY);
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = PieChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, pieChartModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(PieChartOLAPDataModel olapDataModel, PieChartModel pieChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    int ii;
                    int i;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getResponseVariable() != null) {
                        List names = measureNames;
                        measureNames = Util.newValidatedList(olapDataModel.getResponseVariable(), names, gtkOLAPFactory, "responseRole.txt", locale);
                    }
                    int measureCount = measureNames != null ? measureNames.size() : 0;
                    String categoryHierarchyName = null;
                    String subgroupHierarchyName = null;
                    if (columnHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                    } else if (rowHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                    }
                    if (olapDataModel.isSubgroupEnabled() && measureCount == 1) {
                        if (columnHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        } else if (rowHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                        if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLAP_PIE_CHART_ASSIGN_SUBGROUP_HIERARCHY_FIRST) && subgroupHierarchyName != null) {
                            String swap = subgroupHierarchyName;
                            subgroupHierarchyName = categoryHierarchyName;
                            categoryHierarchyName = swap;
                        }
                    }
                    if (categoryHierarchyName == null) {
                        throw new Util.ComponentsMessageException("RequiredCategoryDataNotFound.txt", locale);
                    }
                    ClassificationVariableDefinition category = new ClassificationVariableDefinition(categoryHierarchyName, null, null, 0);
                    Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, category, missingDataColumnMessageEnabled);
                    Util.setLegendVariable(dataSource, STYLE_BY, CATEGORY);
                    if (subgroupHierarchyName != null) {
                        ClassificationVariableDefinition subgroup = new ClassificationVariableDefinition(subgroupHierarchyName, null, null, 0);
                        Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, subgroup, missingDataColumnMessageEnabled);
                        Util.setLegendVariable(dataSource, STYLE_BY, SUBGROUP);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            columns = new ClassificationVariableDefinition((String)columnHierarchyNames.get(i), null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            rows = new ClassificationVariableDefinition((String)rowHierarchyNames.get(i), null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    if (measureCount > 0) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, RESPONSE, measureNames, "responseRole.txt", locale, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, SELECTION, measureNames, missingDataColumnMessageEnabled);
                        }
                    }
                    List allMeasureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], allMeasureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], allMeasureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = PieChart._applyDataSourceWhereProcessing(dataSource, olapDataModel, pieChartModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (pieChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.pieChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        PieChartSubgroupModel subgroupLabelModel = this.pieChartModel.getSubgroupLabelModel();
        LegendModel legendModel = this.pieChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, subgroupLabelModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.pieChartModel.getColumnAxisModel(), this.pieChartModel.getRowAxisModel());
        Util.Conveyer.applyTextStyle(graphStyle.getLabelTextStyle(), this.pieChartModel.getResponseLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getLabelTextStyle(), this.pieChartModel.getDonutHoleLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.pieChartModel.getInsideSliceLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.pieChartModel.getOutsideSliceLabelTextStyle());
        subgroupLabelModel.setValueTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getDataLabelTextStyle(), subgroupLabelModel.getValueTextStyle()));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.pieChartModel.getColumnAxisModel(), this.pieChartModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.pieChartModel.getLegendModel());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.pieChartModel.getInsideSliceLabelTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.pieChartModel.getSubgroupLabelModel().getValueTextStyle());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.pieChartModel.getSubgroupLabelModel().getLabelTextStyle());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.pieChartModel.getDonutHoleLabelTextStyle());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.pieChartModel.getOutsideSliceLabelTextStyle());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.pieChartModel.getResponseLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof PieChartTableDataModel) {
            PieChartTableDataModel tm = (PieChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof PieChartOLAPDataModel) {
            PieChartOLAPDataModel om = (PieChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    @SASScope
    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_OLAP_PIE_CHART_ASSIGN_SUBGROUP_HIERARCHY_FIRST;
        private int missingPolicy;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(PieChartModel pieChartModel) {
            this.apply(pieChartModel);
        }

        public void apply(PieChartModel pieChartModel) {
            this.customOptions = pieChartModel.getCustomOptions() & dataOptions;
            this.missingPolicy = pieChartModel.getMissingPolicy();
        }

        public boolean isApplyDataModel(PieChartModel pieChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != pieChartModel.getMissingPolicy();
            }
            return this.customOptions != (pieChartModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && super.equals(arg);
        }
    }
}

