/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pathanalysischart;

import com.sas.graphics.components.DataModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.text.Message;
import javax.swing.table.TableModel;

public class VolumeTableDataModel
extends DataModel {
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private TableModel dataTable;
    private Variable sourceNodeVar;
    private Variable sourceTypeVar;
    private Variable destinationNodeVar;
    private Variable destinationTypeVar;
    private Variable volumeVar;
    private Variable[] tipVars;
    private Variable[] auxVars;

    public void setModel(TableModel newM) {
        this._checkVariables(newM);
        TableModel oldM = this.dataTable;
        this.dataTable = newM;
        this.firePropertyChange("model", oldM, newM);
    }

    public TableModel getModel() {
        return this.dataTable;
    }

    public void setSourceNodeVariable(Variable newVar) {
        VolumeTableDataModel._checkVarExists(newVar, this.dataTable);
        VolumeTableDataModel._checkStringVar(newVar, this.dataTable);
        Variable oldVar = this.sourceNodeVar;
        this.sourceNodeVar = newVar;
        this.firePropertyChange("sourceNodeVariable", oldVar, newVar);
    }

    public Variable getSourceNodeVariable() {
        return this.sourceNodeVar;
    }

    public void setSourceTypeVariable(Variable newVar) {
        VolumeTableDataModel._checkVarExists(newVar, this.dataTable);
        VolumeTableDataModel._checkStringVar(newVar, this.dataTable);
        Variable oldVar = this.sourceTypeVar;
        this.sourceTypeVar = newVar;
        this.firePropertyChange("sourceTypeVariable", oldVar, newVar);
    }

    public Variable getSourceTypeVariable() {
        return this.sourceTypeVar;
    }

    public void setDestinationNodeVariable(Variable newVar) {
        VolumeTableDataModel._checkVarExists(newVar, this.dataTable);
        VolumeTableDataModel._checkStringVar(newVar, this.dataTable);
        Variable oldVar = this.destinationNodeVar;
        this.destinationNodeVar = newVar;
        this.firePropertyChange("destinationNodeVariable", oldVar, newVar);
    }

    public Variable getDestinationNodeVariable() {
        return this.destinationNodeVar;
    }

    public void setDestinationTypeVariable(Variable newVar) {
        VolumeTableDataModel._checkVarExists(newVar, this.dataTable);
        VolumeTableDataModel._checkStringVar(newVar, this.dataTable);
        Variable oldVar = this.destinationTypeVar;
        this.destinationTypeVar = newVar;
        this.firePropertyChange("destinationTypeVariable", oldVar, newVar);
    }

    public Variable getDestinationTypeVariable() {
        return this.destinationTypeVar != null ? this.destinationTypeVar : this.sourceTypeVar;
    }

    public void setVolumeVariable(Variable newVar) {
        VolumeTableDataModel._checkVarExists(newVar, this.dataTable);
        VolumeTableDataModel._checkNumericVar(newVar, this.dataTable);
        Variable oldVar = this.volumeVar;
        this.volumeVar = newVar;
        this.firePropertyChange("volumeVariable", oldVar, newVar);
    }

    public Variable getVolumeVariable() {
        return this.volumeVar;
    }

    public void setDataTipVariable(Variable[] newVars) {
        if (newVars != null && newVars.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] oldVars = this.tipVars;
        this.tipVars = newVars;
        this.firePropertyChange("dataTipVariable", oldVars, newVars);
    }

    public Variable[] getDataTipVariable() {
        return this.tipVars;
    }

    public void setAuxilliaryVariable(Variable[] newVars) {
        if (newVars != null && newVars.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] oldVars = this.auxVars;
        this.auxVars = newVars;
        this.firePropertyChange("auxilliaryVariables", oldVars, newVars);
    }

    public Variable[] getAuxilliaryVariable() {
        return this.auxVars;
    }

    private void _checkVariables(TableModel tm) throws IllegalArgumentException {
        if (tm == null) {
            return;
        }
        VolumeTableDataModel._checkVarExists(this.sourceNodeVar, tm);
        VolumeTableDataModel._checkVarExists(this.sourceTypeVar, tm);
        VolumeTableDataModel._checkVarExists(this.destinationNodeVar, tm);
        VolumeTableDataModel._checkVarExists(this.destinationTypeVar, tm);
        VolumeTableDataModel._checkVarExists(this.volumeVar, tm);
        VolumeTableDataModel._checkStringVar(this.sourceNodeVar, tm);
        VolumeTableDataModel._checkStringVar(this.sourceTypeVar, tm);
        VolumeTableDataModel._checkStringVar(this.destinationNodeVar, tm);
        VolumeTableDataModel._checkStringVar(this.destinationTypeVar, tm);
        VolumeTableDataModel._checkNumericVar(this.volumeVar, tm);
    }

    private static void _checkVarExists(Variable var, TableModel tm) {
        if (var == null || tm == null) {
            return;
        }
        int ncols = tm.getColumnCount();
        int colnum = var.getColumnIndex();
        if (colnum != -1) {
            if (colnum >= ncols) {
                throw new IllegalArgumentException(VolumeTableDataModel.nls("badColumnIndex", colnum, ncols - 1));
            }
            return;
        }
        String colname = var.getColumnName();
        for (int i = 0; i < ncols; ++i) {
            if (!tm.getColumnName(i).equals(colname)) continue;
            return;
        }
        throw new IllegalArgumentException(VolumeTableDataModel.nls("badColumnName", colname));
    }

    private static void _checkNumericVar(Variable var, TableModel tm) {
        if (var == null || tm == null) {
            return;
        }
        int colnum = VolumeTableDataModel.findColumnIndex(var, tm);
        Class<?> colclass = tm.getColumnClass(colnum);
        if (!colclass.equals(Integer.class) && !colclass.equals(Double.class)) {
            throw new IllegalArgumentException(VolumeTableDataModel.nls("nonNumericVar", var.getColumnName(), colnum));
        }
    }

    private static void _checkStringVar(Variable var, TableModel tm) {
        if (var == null || tm == null) {
            return;
        }
        int colnum = VolumeTableDataModel.findColumnIndex(var, tm);
        Class<?> colclass = tm.getColumnClass(colnum);
        if (!colclass.equals(String.class)) {
            throw new IllegalArgumentException(VolumeTableDataModel.nls("nonStringVar", var.getColumnName(), colnum));
        }
    }

    private static int findColumnIndex(Variable var, TableModel tm) {
        if (var == null) {
            return -1;
        }
        int colnum = var.getColumnIndex();
        return colnum != -1 ? colnum : VolumeTableDataModel.findColumnIndex(var.getColumnName(), tm);
    }

    private static int findColumnIndex(String colname, TableModel tm) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            if (!tm.getColumnName(i).equals(colname)) continue;
            return i;
        }
        return -1;
    }

    private static String nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    private static String nls(String key, String p0) {
        return Message.format((String)VolumeTableDataModel.nls(key), (Object)p0);
    }

    private static String nls(String key, int p0, int p1) {
        return VolumeTableDataModel.nls(key, "" + p0, "" + p1);
    }

    private static String nls(String key, String p0, String p1) {
        return Message.format((String)VolumeTableDataModel.nls(key), (Object)p0, (Object)p1);
    }

    private static String nls(String key, String p0, int p1) {
        return Message.format((String)VolumeTableDataModel.nls(key), (Object)p0, (Object)("" + p1));
    }
}

