/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pathanalysischart;

import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartDataModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartModel;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.pathanalysischart.PathAnalysisChartCell;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.SwingUtilities;

public class PathAnalysisChart
extends Graph {
    public static final String OUTSIDE_NODE_NAME = "_OUTSIDE_";
    private PathAnalysisChartModel displayModel;
    private PathAnalysisChartDataModel dataModel;
    private PathAnalysisChartCell cell;
    private boolean autoRepaint;

    public PathAnalysisChart() {
        this(null, null, null);
    }

    public PathAnalysisChart(PathAnalysisChartDataModel m) {
        this(m, null, null);
    }

    public PathAnalysisChart(PathAnalysisChartDataModel m, GraphStyle s) {
        this(m, s, null);
    }

    public PathAnalysisChart(PathAnalysisChartDataModel m, Locale c) {
        this(m, null, c);
    }

    public PathAnalysisChart(PathAnalysisChartDataModel m, GraphStyle s, Locale c) {
        if (c != null) {
            this.setLocale(c);
        }
        this.setGraphModel(new PathAnalysisChartModel());
        this.applyGraphStyle(s);
        this.cell = new PathAnalysisChartCell(null, this.displayModel);
        this.setGraph(this.cell);
        if (m != null) {
            this.setDataModel(m);
        }
    }

    public void setGraphModel(PathAnalysisChartModel newM) throws IllegalArgumentException {
        super.setGraphModel(newM);
        if (this.cell != null) {
            this.cell.setDisplayModel(newM);
        }
        PathAnalysisChartModel oldM = this.displayModel;
        this.displayModel = newM;
        this.firePropertyChange("graphModel", oldM, newM);
    }

    public PathAnalysisChartModel getGraphModel() {
        return this.displayModel;
    }

    public void setDataModel(PathAnalysisChartDataModel newM) {
        if (this.cell != null) {
            this.cell.setDataModel(newM);
        }
        PathAnalysisChartDataModel oldM = this.dataModel;
        this.dataModel = newM;
        this.firePropertyChange("dataModel", oldM, newM);
    }

    public PathAnalysisChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void paint(Graphics g) {
        this.paintBackground(g, this.getBounds(), this.getInsets());
        super.paint(g);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle b = this.getBounds();
        if (x != b.x || y != b.y || w != b.width || h != b.height) {
            super.setBounds(x, y, w, h);
        }
    }

    @Override
    public void invalidate() {
        if (this.cell != null) {
            this.cell.invalidate();
        }
        super.invalidate();
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            graphStyle = this._getMyDefaultGraphStyle();
        }
        super.applyGraphStyle(graphStyle);
        TextStyle s = this.displayModel.getNodeTextStyle();
        if (s == null) {
            s = new TextStyle();
            this.displayModel.setNodeTextStyle(s);
        }
        s.apply(graphStyle.getDataLabelTextStyle());
    }

    @Override
    public PickInfo pick(int x, int y) {
        Point cellXY = SwingUtilities.convertPoint(this, x, y, this.cell);
        return this.cell != null ? this.cell.pick(cellXY.x, cellXY.y) : null;
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        this.validateTree();
        ChartImageMapInfo2 m = this.cell.getImageMapInfo();
        m.translate(this);
        return m;
    }

    private GraphStyle _getMyDefaultGraphStyle() {
        GraphStyle s = this.getDefaultGraphStyle();
        DataElementStyles ds = s.getDataElementStyles();
        Color[] cs = ds.getDiscreteFillColors();
        cs[0] = new Color(100, 140, 255);
        cs[1] = new Color(255, 100, 70);
        ds.setDiscreteFillColors(cs);
        s.getBackgroundFillStyle().setSolidFillColor(Color.white);
        return s;
    }

    @Override
    public void prepareToPaint() {
        if (this.cell != null) {
            this.cell.invalidateData();
            this.revalidate();
        }
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.autoRepaint = b;
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.autoRepaint;
    }

    @Override
    protected void applyDataModel() {
    }

    @Override
    protected void selectionChanged() {
    }

    @Override
    protected void updateDataModelListeners() {
    }
}

