/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.mapchart;

import com.sas.graphics.components.Variable;
import com.sas.graphics.components.mapchart.MapChartDataModel;
import com.sas.graphics.components.mapchart.RB;
import com.sas.graphics.components.mapchart.SpatialDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.storage.olap.OLAPDataSetInterface;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public class MapChartOLAPDataModel
extends MapChartDataModel {
    private OLAPDataSetInterface model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private Variable colorVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(MapChartOLAPDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(MapChartOLAPDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.colorVariable = theOtherModel.colorVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MapChartOLAPDataModel arg = (MapChartOLAPDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.colorVariable, arg.colorVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public MapChartOLAPDataModel() {
    }

    public MapChartOLAPDataModel(OLAPDataSetInterface newModel) {
        this();
        this.model = newModel;
    }

    public MapChartOLAPDataModel(OLAPDataSetInterface newModel, SpatialDataModel spatialDataModel) {
        this(newModel);
        this.setSpatialDataModel(spatialDataModel);
    }

    public void setModel(OLAPDataSetInterface newModel) {
        OLAPDataSetInterface oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColorVariable(Variable newVariable) {
        Variable oldVariable = this.colorVariable;
        this.colorVariable = newVariable;
        this.firePropertyChange("colorVariable", oldVariable, newVariable);
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }
}

