/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.mapchart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.mapchart.MapChartDataModel;
import com.sas.graphics.components.mapchart.MapChartModel;
import com.sas.graphics.components.mapchart.MapChartOLAPDataModel;
import com.sas.graphics.components.mapchart.MapChartTableDataModel;
import com.sas.graphics.components.mapchart.RB;
import com.sas.graphics.components.mapchart.SpatialDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.mapchart.MapChartMatrix;
import com.sas.graphics.util.cell.mapchart.MapChartMatrixModel;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class MapChart
extends Graph {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "MapChart.";
    private MapChartModel mapChartModel;
    private MapChartDataModel dataModel;
    private final MapChartMatrix matrix;
    private final MapChartMatrixModel matrixModel;
    private final DataModelMemento dataModelMemento = new DataModelMemento();
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            MapChart.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String ID = "IDVariable";
    private static final String COLOR = "colorVariable";
    private static final String EXTRUSION = "extrusionVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String X = "XVariable";
    private static final String Y = "YVariable";
    private static final String SEGMENT = "segmentVariable";
    private static final String SPATIAL = "spatialIDVariable";
    private static final String WKB = "WKBVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public MapChart() {
        this(null, null);
    }

    public MapChart(MapChartDataModel mapChartDataModel) {
        this(mapChartDataModel, null);
    }

    public MapChart(MapChartDataModel mapChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new MapChartMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setIDRole(ID);
        this.matrixModel.setColorRole(COLOR);
        this.matrixModel.setExtrusionRole(EXTRUSION);
        this.matrixModel.setSpatialRole(SPATIAL);
        this.matrixModel.setXRole(X);
        this.matrixModel.setYRole(Y);
        this.matrixModel.setSegmentRole(SEGMENT);
        this.matrixModel.setWKBRole(WKB);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new MapChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new MapChartModel());
        this.applyGraphStyle(defaultGraphStyle == null ? this.getDefaultGraphStyle() : defaultGraphStyle);
        this.dataModelMemento.apply(this.mapChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(ID, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("ID"), 2));
                dataSource.setVariableDefinition(COLOR, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Color"), 1));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (mapChartDataModel != null) {
            this.setDataModel(mapChartDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(MapChartModel newMapChartModel) throws IllegalArgumentException {
        super.setGraphModel(newMapChartModel);
        MapChartModel oldMapChartModel = this.mapChartModel;
        this.mapChartModel = newMapChartModel;
        this.matrixModel.setMapChartModel(this.mapChartModel);
        this.firePropertyChange("graphModel", oldMapChartModel, newMapChartModel);
    }

    public MapChartModel getGraphModel() {
        return this.mapChartModel;
    }

    public void setDataModel(MapChartDataModel newDataModel) {
        MapChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        SpatialDataModel oldSpatialDataModel = null;
        SpatialDataModel spatialDataModel = null;
        if (oldDataModel != null) {
            oldSpatialDataModel = oldDataModel.getSpatialDataModel();
        }
        if (this.dataModel != null) {
            spatialDataModel = this.dataModel.getSpatialDataModel();
        }
        if (oldSpatialDataModel != spatialDataModel) {
            this.matrix.setSpatialDataDirty(true);
        }
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public MapChartDataModel getDataModel() {
        return this.dataModel;
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    protected void applyDataModel() {
        DataSource dataSource = null;
        if (this.matrix == null) {
            return;
        }
        this.dataModelMemento.apply(this.mapChartModel);
        this.animationListener.setEventSource(null);
        try {
            TableModel tableModel;
            dataSource = MapChart._newDataSource(this.dataModel, this.mapChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{COLOR, EXTRUSION}, ruleTargetVariableNameID);
                this.matrixModel.setRuleTargetIdentifier(columnName);
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof MapChartTableDataModel && (tableModel = ((MapChartTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
        if (this.dataModel != null && this.matrix.isSpatialDataDirty()) {
            this.matrix.setSpatialDataSource(MapChart._newSpatialDataSource(this.mapChartModel, this.dataModel.getSpatialDataModel(), Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.dataModel.getSortStrategy()));
        }
        if (this.dataModel != null) {
            this.matrix.setAnnotationDataModel(this.dataModel.getAnnotationModel());
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, MapChartDataModel dataModel, MapChartModel mapChartModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(COLOR, 0) instanceof FreqVariableDefinition)) {
                switch (mapChartModel.getMissingPolicy()) {
                    default: {
                        removeIfAllMissing = new Object[]{COLOR};
                    }
                    case 10201: 
                }
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(MapChartDataModel dataModel, MapChartModel mapChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof MapChartTableDataModel) {
                dataSource = MapChart._newDataSource((MapChartTableDataModel)dataModel, mapChartModel, locale, formatLocale, listSelectionListener);
            } else if (dataModel instanceof MapChartOLAPDataModel) {
                dataSource = MapChart._newDataSource((MapChartOLAPDataModel)dataModel, mapChartModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newSpatialDataSource(MapChartModel mapChartModel, SpatialDataModel dataModel, Locale locale, Locale formatLocale, int sortStrategy) {
        int index;
        DataSource dataSource = null;
        TableModel tableModel = dataModel.getModel();
        if (dataModel == null || tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            throw new Util.ComponentsMessageException("zeroSpatialValues.txt", locale);
        }
        dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, sortStrategy), true, false);
        boolean missingDataColumnMessageEnabled = !mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
        Util.setVariableDefinition(dataSource, X, "xRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataModel.getXVariable(), 1), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, Y, "yRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataModel.getYVariable(), 1), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, SPATIAL, "idRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataModel.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(dataSource, SEGMENT, "segmentRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataModel.getSegmentVariable(), 1), false);
        Util.setVariableDefinition(dataSource, WKB, "WKBRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataModel.getWellKnownBinaryVariable(), 2), false);
        if (dataSource.getVariableDefinition(SPATIAL) == null) {
            index = -1;
            index = Util.seekNamedColumn(tableModel, new String("id"));
            if (index < 0) {
                index = Util.seekNamedColumn(tableModel, new String("state"));
            }
            if (index < 0) {
                index = Util.seekNamedColumn(tableModel, new String("province"));
            }
            Util.setVariableDefinition(dataSource, SPATIAL, null, null, VariableDefinition.Factory.newVariableDefinition(new Variable(index), 2), false);
        }
        if (dataSource.getVariableDefinition(WKB) != null) {
            return dataSource;
        }
        if (dataSource.getVariableDefinition(X) == null && (index = Util.seekNamedColumn(tableModel, new String("X"))) >= 0) {
            Util.setVariableDefinition(dataSource, X, null, null, VariableDefinition.Factory.newVariableDefinition(new Variable(index), 1), false);
        }
        if (dataSource.getVariableDefinition(Y) == null && (index = Util.seekNamedColumn(tableModel, new String("Y"))) >= 0) {
            Util.setVariableDefinition(dataSource, Y, null, null, VariableDefinition.Factory.newVariableDefinition(new Variable(index), 1), false);
        }
        if (dataSource.getVariableDefinition(SEGMENT) == null && (index = Util.seekNamedColumn(tableModel, new String("SEGMENT"))) >= 0) {
            Util.setVariableDefinition(dataSource, SEGMENT, null, null, VariableDefinition.Factory.newVariableDefinition(new Variable(index), 1), false);
        }
        if (dataSource.getVariableDefinition(X) == null || dataSource.getVariableDefinition(Y) == null) {
            throw new Util.ComponentsMessageException("RequiredMapDataNotFound.txt", locale);
        }
        return dataSource;
    }

    private static DataSource _newDataSource(MapChartTableDataModel tableDataModel, MapChartModel mapChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0 && mapChartModel.getEmptyPolicy() == 10202) {
            if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            boolean missingDataColumnMessageEnabled;
            String PSEUDO_COLOR = "pseudoColorVariable";
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, tableDataModel.isStatisticEnabled());
            boolean bl = missingDataColumnMessageEnabled = !mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            if (tableModel instanceof AnimationDirector) {
                AnimationDirector atm = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getKeyFrameVariable()), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ID, "idRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, PSEUDO_COLOR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable(), 0), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(ID) == null && tableModel instanceof AnimationDirector) {
                AnimationDirector animationDirector = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ID, "idRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(animationDirector.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            }
            if (tableDataModel.getSpatialDataModel() == null) {
                throw new Util.ComponentsMessageException("nullSpatialDataModel.txt", locale);
            }
            if (dataSource.getVariableDefinition(ID) == null) {
                int index = -1;
                index = Util.seekNamedColumn(tableModel, new String("id"));
                if (index < 0) {
                    index = Util.seekNamedColumn(tableModel, new String("state"));
                }
                if (index < 0) {
                    index = Util.seekNamedColumn(tableModel, new String("province"));
                }
                Util.setVariableDefinition(dataSource, ID, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(PSEUDO_COLOR) == null && dataSource.getVariableDefinition(EXTRUSION) == null) {
                if (!tableDataModel.isStatisticEnabled()) {
                    throw new Util.ComponentsMessageException("RequiredMapResponseDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, PSEUDO_COLOR, "colorRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
            }
            Util.setLegendVariable(dataSource, COLOR, PSEUDO_COLOR);
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = MapChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, mapChartModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(MapChartOLAPDataModel olapDataModel, MapChartModel mapChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (olapDataModel.getSpatialDataModel() == null) {
            throw new Util.ComponentsMessageException("nullSpatialDataModel.txt", locale);
        }
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    int ii;
                    int i;
                    int measureCount;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    String idHierarchyName = null;
                    dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getColorVariable() != null) {
                        List names = measureNames;
                        measureNames = Util.newValidatedList(olapDataModel.getColorVariable(), names, gtkOLAPFactory, "colorRole.txt", locale);
                    }
                    int n = measureCount = measureNames != null ? measureNames.size() : 0;
                    if (columnHierarchyNames.size() > 0) {
                        idHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                    } else if (rowHierarchyNames.size() > 0) {
                        idHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                    }
                    if (idHierarchyName == null) {
                        throw new Util.ComponentsMessageException("RequiredCategoryDataNotFound.txt", locale);
                    }
                    ClassificationVariableDefinition id = new ClassificationVariableDefinition(idHierarchyName, null, null, 0);
                    Util.setVariableDefinition(dataSource, ID, "idRole.txt", locale, id, missingDataColumnMessageEnabled);
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            columns = new ClassificationVariableDefinition((String)columnHierarchyNames.get(i), null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            rows = new ClassificationVariableDefinition((String)rowHierarchyNames.get(i), null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    if (measureCount > 0) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, COLOR, measureNames, "colorRole.txt", locale, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, SELECTION, measureNames, missingDataColumnMessageEnabled);
                        }
                    }
                    List allMeasureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], allMeasureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], allMeasureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = MapChart._applyDataSourceWhereProcessing(dataSource, olapDataModel, mapChartModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (mapChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMemento.isApplyDataModel(this.mapChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        Util.Conveyer.applyGraphStyle(graphStyle, this.mapChartModel.getColumnAxisModel(), this.mapChartModel.getRowAxisModel());
        LegendModel legendModel = this.mapChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        this.mapChartModel.getEmptyOutlineLineStyle().apply(graphStyle.getDataElementStyles().getOutlineLineStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.mapChartModel.getColumnAxisModel(), this.mapChartModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.mapChartModel.getLegendModel());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof MapChartTableDataModel) {
            MapChartTableDataModel tm = (MapChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof MapChartOLAPDataModel) {
            MapChartOLAPDataModel om = (MapChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private static class DataModelMemento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private int emptyPolicy;
        private long customOptions;

        public DataModelMemento() {
        }

        public DataModelMemento(MapChartModel mapChartModel) {
            this.apply(mapChartModel);
        }

        public void apply(MapChartModel mapChartModel) {
            this.customOptions = mapChartModel.getCustomOptions() & dataOptions;
            this.missingPolicy = mapChartModel.getMissingPolicy();
            this.emptyPolicy = mapChartModel.getEmptyPolicy();
        }

        public boolean isApplyDataModel(MapChartModel mapChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != mapChartModel.getMissingPolicy() || this.emptyPolicy != mapChartModel.getEmptyPolicy();
            }
            return this.customOptions != (mapChartModel.getCustomOptions() & dataOptions) || this.emptyPolicy == 10202 && mapChartModel.getEmptyPolicy() != 10202;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMemento arg = (DataModelMemento)obj;
            return this.customOptions == arg.customOptions && this.missingPolicy == arg.missingPolicy && this.emptyPolicy == arg.emptyPolicy && super.equals(arg);
        }
    }
}

