/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.lineplot;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.PlotVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.lineplot.LinePlotDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class LinePlotTableDataModel
extends LinePlotDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private ClassificationVariable styleVariable;
    private ClassificationVariable groupVariable;
    private PlotVariable xVariable;
    private PlotVariable yVariable;
    private PlotVariable y2Variable;
    private Variable colorVariable;
    private Variable topMarkerLabelVariable;
    private Variable bottomMarkerLabelVariable;
    private Variable sortVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(LinePlotTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(LinePlotTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.sortVariable = theOtherModel.sortVariable;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.xVariable = theOtherModel.xVariable;
        this.yVariable = theOtherModel.yVariable;
        this.y2Variable = theOtherModel.y2Variable;
        this.colorVariable = theOtherModel.colorVariable;
        this.styleVariable = theOtherModel.styleVariable;
        this.groupVariable = theOtherModel.groupVariable;
        this.topMarkerLabelVariable = theOtherModel.topMarkerLabelVariable;
        this.bottomMarkerLabelVariable = theOtherModel.bottomMarkerLabelVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public LinePlotTableDataModel() {
    }

    public LinePlotTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSortVariable(Variable newSortVariable) {
        Variable oldVariable = this.sortVariable;
        this.sortVariable = newSortVariable;
        this.firePropertyChange("sortVariable", oldVariable, newSortVariable);
    }

    public Variable getSortVariable() {
        return this.sortVariable;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.getColumnVariable();
        this.columnVariable = newVariable;
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.getRowVariable();
        this.rowVariable = newVariable;
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setXVariable(PlotVariable newVariable) {
        PlotVariable oldVariable = this.getXVariable();
        this.xVariable = newVariable;
        this.firePropertyChange("xVariable", oldVariable, newVariable);
    }

    public PlotVariable getXVariable() {
        return this.xVariable;
    }

    public void setYVariable(PlotVariable newVariable) {
        PlotVariable oldVariable = this.getYVariable();
        this.yVariable = newVariable;
        this.firePropertyChange("yVariable", oldVariable, newVariable);
    }

    public PlotVariable getYVariable() {
        return this.yVariable;
    }

    public void setY2Variable(PlotVariable newVariable) {
        PlotVariable oldVariable = this.getY2Variable();
        this.y2Variable = newVariable;
        this.firePropertyChange("y2Variable", oldVariable, newVariable);
    }

    public PlotVariable getY2Variable() {
        return this.y2Variable;
    }

    public void setColorVariable(Variable newVariable) {
        Variable oldVariable = this.getColorVariable();
        this.colorVariable = newVariable;
        this.firePropertyChange("colorVariable", oldVariable, newVariable);
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setStyleVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.getStyleVariable();
        this.styleVariable = newVariable;
        this.firePropertyChange("styleVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getStyleVariable() {
        return this.styleVariable;
    }

    public void setGroupVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.getGroupVariable();
        this.groupVariable = newVariable;
        this.firePropertyChange("groupVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setTopMarkerLabelVariable(Variable newVariable) {
        Variable oldVariable = this.getTopMarkerLabelVariable();
        this.topMarkerLabelVariable = newVariable;
        newVariable = this.getTopMarkerLabelVariable();
        this.firePropertyChange("topMarkerLabelVariable", oldVariable, newVariable);
    }

    public Variable getTopMarkerLabelVariable() {
        return this.topMarkerLabelVariable;
    }

    public void setBottomMarkerLabelVariable(Variable newVariable) {
        Variable oldVariable = this.getBottomMarkerLabelVariable();
        this.bottomMarkerLabelVariable = newVariable;
        newVariable = this.getBottomMarkerLabelVariable();
        this.firePropertyChange("bottomMarkerLabelVariable", oldVariable, newVariable);
    }

    public Variable getBottomMarkerLabelVariable() {
        return this.bottomMarkerLabelVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LinePlotTableDataModel arg = (LinePlotTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.sortVariable, arg.sortVariable) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.xVariable, arg.xVariable) && Util.Evaluate.isEqual(this.yVariable, arg.yVariable) && Util.Evaluate.isEqual(this.y2Variable, arg.y2Variable) && Util.Evaluate.isEqual(this.groupVariable, arg.groupVariable) && Util.Evaluate.isEqual(this.styleVariable, arg.styleVariable) && Util.Evaluate.isEqual(this.colorVariable, arg.colorVariable) && Util.Evaluate.isEqual(this.topMarkerLabelVariable, arg.topMarkerLabelVariable) && Util.Evaluate.isEqual(this.bottomMarkerLabelVariable, arg.bottomMarkerLabelVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

