/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.lineplot;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.components.util.scatterplot.ScatterPlotModel;

@SASScope(value="ALL")
public class LinePlotModel
extends GraphModel {
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private boolean interpolationEnabled = true;
    private boolean fillAreaEnabled = false;
    private boolean markerEnabled = true;
    private boolean skipMissing = false;
    private boolean uniformEnabled = false;
    private double xAxisBaseline = Double.NEGATIVE_INFINITY;
    private double yAxisBaseline = Double.NEGATIVE_INFINITY;
    private double y2AxisBaseline = Double.NEGATIVE_INFINITY;
    private boolean matchNeedleColor = false;
    private LineStyle needleLineStyle = new LineStyle();
    private boolean matchErrorColor = false;
    private boolean matchMarkerLabelColor = false;
    private AxisModel xAxisModel = new AxisModel();
    private AxisModel yAxisModel = new AxisModel();
    private AxisModel y2AxisModel = new AxisModel();
    private AxisWallModel axisWallModel = new AxisWallModel();
    private LegendModel colorLegendModel = new LegendModel();
    private LegendModel lineLegendModel = new LegendModel();
    private AdvancedTextStyle topMarkerLabelTextStyle = new AdvancedTextStyle();
    private AdvancedTextStyle bottomMarkerLabelTextStyle = new AdvancedTextStyle();
    private int topMarkerLabelContent = 10200;
    private int bottomMarkerLabelContent = 10200;
    private int missingPolicy = 10200;
    private int skin = 10200;
    private ScatterPlotModel plotModel = null;

    public LinePlotModel() {
        this.y2AxisModel.getGridLineStyle().setVisibilityPolicy(10202);
        this.setContainedModel("rowAxisModel", this.rowAxisModel);
        this.setContainedModel("columnAxisModel", this.columnAxisModel);
        this.setContainedModel("needleLineStyle", this.needleLineStyle);
        this.setContainedModel("xAxisModel", this.xAxisModel);
        this.setContainedModel("yAxisModel", this.yAxisModel);
        this.setContainedModel("y2AxisModel", this.y2AxisModel);
        this.setContainedModel("axisWallModel", this.axisWallModel);
        this.setContainedModel("topMarkerLabelTextStyle", this.topMarkerLabelTextStyle);
        this.setContainedModel("bottomMarkerLabelTextStyle", this.bottomMarkerLabelTextStyle);
        this.setContainedModel("colorLegendModel", this.colorLegendModel);
        this.setContainedModel("lineLegendModel", this.lineLegendModel);
        this.plotModel = new ScatterPlotModel();
        this._setPlotProperties();
    }

    public void apply(LinePlotModel theOtherModel) throws IllegalArgumentException {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.interpolationEnabled = theOtherModel.interpolationEnabled;
        this.markerEnabled = theOtherModel.markerEnabled;
        this.fillAreaEnabled = theOtherModel.fillAreaEnabled;
        this.matchErrorColor = theOtherModel.matchErrorColor;
        this.matchMarkerLabelColor = theOtherModel.matchMarkerLabelColor;
        this.matchNeedleColor = theOtherModel.matchNeedleColor;
        this.skipMissing = theOtherModel.skipMissing;
        this.missingPolicy = theOtherModel.missingPolicy;
        this.xAxisBaseline = theOtherModel.xAxisBaseline;
        this.yAxisBaseline = theOtherModel.yAxisBaseline;
        this.y2AxisBaseline = theOtherModel.y2AxisBaseline;
        this.uniformEnabled = theOtherModel.uniformEnabled;
        this.topMarkerLabelContent = theOtherModel.topMarkerLabelContent;
        this.bottomMarkerLabelContent = theOtherModel.bottomMarkerLabelContent;
        this.skin = theOtherModel.skin;
        this.yAxisModel.apply(theOtherModel.yAxisModel);
        this.xAxisModel.apply(theOtherModel.xAxisModel);
        this.y2AxisModel.apply(theOtherModel.y2AxisModel);
        this.axisWallModel.apply(theOtherModel.axisWallModel);
        this.needleLineStyle.apply(theOtherModel.needleLineStyle);
        this.colorLegendModel.apply(theOtherModel.colorLegendModel);
        this.lineLegendModel.apply(theOtherModel.lineLegendModel);
        this.topMarkerLabelTextStyle.apply(theOtherModel.topMarkerLabelTextStyle);
        this.bottomMarkerLabelTextStyle.apply(theOtherModel.bottomMarkerLabelTextStyle);
        this._setPlotProperties();
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.rowAxisModel;
        this.rowAxisModel = newAxisModel;
        this.plotModel.setRowAxisModel(this.rowAxisModel);
        this.firePropertyChange("rowAxisModel", oldValue, this.rowAxisModel);
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.columnAxisModel;
        this.columnAxisModel = newAxisModel;
        this.plotModel.setColumnAxisModel(this.columnAxisModel);
        this.firePropertyChange("columnAxisModel", oldValue, this.columnAxisModel);
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public void setYAxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AxisModel oldAxisModel = this.yAxisModel;
        this.yAxisModel = newAxisModel;
        this.plotModel.setYAxisModel(this.yAxisModel);
        this.firePropertyChange("yAxisModel", oldAxisModel, newAxisModel);
    }

    public AxisModel getYAxisModel() {
        return this.yAxisModel;
    }

    public void setXAxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AxisModel oldAxisModel = this.xAxisModel;
        this.xAxisModel = newAxisModel;
        this.plotModel.setXAxisModel(this.xAxisModel);
        this.firePropertyChange("xAxisModel", oldAxisModel, newAxisModel);
    }

    public AxisModel getXAxisModel() {
        return this.xAxisModel;
    }

    public void setY2AxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AxisModel oldAxisModel = this.y2AxisModel;
        this.y2AxisModel = newAxisModel;
        this.plotModel.setY2AxisModel(this.y2AxisModel);
        this.firePropertyChange("y2AxisModel", oldAxisModel, newAxisModel);
    }

    public AxisModel getY2AxisModel() {
        return this.y2AxisModel;
    }

    public void setAxisWallModel(AxisWallModel newAxisWallModel) throws IllegalArgumentException {
        if (newAxisWallModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AxisWallModel oldAxisWallModel = this.axisWallModel;
        this.axisWallModel = newAxisWallModel;
        this.plotModel.setAxisWallModel(this.axisWallModel);
        this.firePropertyChange("axisWallModel", oldAxisWallModel, newAxisWallModel);
    }

    public AxisWallModel getAxisWallModel() {
        return this.axisWallModel;
    }

    public void setColorLegendModel(LegendModel newLegendModel) throws IllegalArgumentException {
        if (newLegendModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LegendModel oldLegendModel = this.colorLegendModel;
        this.colorLegendModel = newLegendModel;
        this.plotModel.setColorLegendModel(this.colorLegendModel);
        this.firePropertyChange("colorLegendModel", oldLegendModel, newLegendModel);
    }

    public LegendModel getColorLegendModel() {
        return this.colorLegendModel;
    }

    public void setLineLegendModel(LegendModel newLegendModel) throws IllegalArgumentException {
        if (newLegendModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LegendModel oldLegendModel = this.lineLegendModel;
        this.lineLegendModel = newLegendModel;
        this.plotModel.setElementLegendModel(this.lineLegendModel);
        this.firePropertyChange("lineLegendModel", oldLegendModel, newLegendModel);
    }

    public LegendModel getLineLegendModel() {
        return this.lineLegendModel;
    }

    public void setInterpolationEnabled(boolean enabledFlag) {
        if (this.interpolationEnabled == enabledFlag) {
            return;
        }
        boolean oldInterpolation = this.interpolationEnabled;
        this.interpolationEnabled = enabledFlag;
        this.plotModel.setInterpolationEnabled(new Boolean(this.interpolationEnabled));
        this.firePropertyChange("interpolationEnabled", oldInterpolation, enabledFlag);
    }

    public boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public void setXAxisBaseline(double location) {
        double oldValue = this.xAxisBaseline;
        this.xAxisBaseline = location;
        this.plotModel.setXAxisBaseline(new Double(location));
        this.firePropertyChange("xAxisBaseline", oldValue, location);
    }

    public double getXAxisBaseline() {
        return this.xAxisBaseline;
    }

    public void setYAxisBaseline(double location) {
        double oldValue = this.yAxisBaseline;
        this.yAxisBaseline = location;
        this.plotModel.setYAxisBaseline(new Double(location));
        this.firePropertyChange("yAxisBaseline", oldValue, location);
    }

    public double getYAxisBaseline() {
        return this.yAxisBaseline;
    }

    public void setY2AxisBaseline(double location) {
        double oldValue = this.y2AxisBaseline;
        this.y2AxisBaseline = location;
        this.plotModel.setY2AxisBaseline(new Double(location));
        this.firePropertyChange("y2AxisBaseline", oldValue, location);
    }

    public double getY2AxisBaseline() {
        return this.y2AxisBaseline;
    }

    public void setMarkerEnabled(boolean enabledFlag) {
        if (this.markerEnabled == enabledFlag) {
            return;
        }
        boolean oldMarker = this.markerEnabled;
        this.markerEnabled = enabledFlag;
        this.plotModel.setMarkerEnabled(new Boolean(this.markerEnabled));
        this.firePropertyChange("markerEnabled", oldMarker, enabledFlag);
    }

    public boolean isMarkerEnabled() {
        return this.markerEnabled;
    }

    public void setFillAreaEnabled(boolean enabledFlag) {
        if (this.fillAreaEnabled == enabledFlag) {
            return;
        }
        boolean oldFill = this.fillAreaEnabled;
        this.fillAreaEnabled = enabledFlag;
        this.plotModel.setFillAreaEnabled(new Boolean(this.fillAreaEnabled));
        this.firePropertyChange("fillAreaEnabled", oldFill, enabledFlag);
    }

    public boolean isFillAreaEnabled() {
        return this.fillAreaEnabled;
    }

    public void setMatchNeedleColor(boolean newMatchNeedleColor) {
        boolean oldNeedle = this.matchNeedleColor;
        this.matchNeedleColor = newMatchNeedleColor;
        this.plotModel.setUseNeedleColor(new Boolean(!this.matchNeedleColor));
        this.firePropertyChange("matchNeedleColor", oldNeedle, newMatchNeedleColor);
    }

    public boolean isMatchNeedleColor() {
        return this.matchNeedleColor;
    }

    public void setNeedleLineStyle(LineStyle newNeedleLineStyle) throws IllegalArgumentException {
        if (newNeedleLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldValue = this.needleLineStyle;
        this.needleLineStyle = newNeedleLineStyle;
        this.plotModel.setNeedleLineStyle(this.needleLineStyle);
        this.firePropertyChange("needleLineStyle", oldValue, newNeedleLineStyle);
    }

    public LineStyle getNeedleLineStyle() {
        return this.needleLineStyle;
    }

    public void setMatchErrorColor(boolean newMatchColor) {
        boolean oldValue = this.matchErrorColor;
        this.matchErrorColor = newMatchColor;
        this.plotModel.setUseErrorColor(new Boolean(!this.matchErrorColor));
        this.firePropertyChange("matchErrorColor", oldValue, newMatchColor);
    }

    public boolean getMatchErrorColor() {
        return this.matchErrorColor;
    }

    public boolean isMatchErrorColor() {
        return this.matchErrorColor;
    }

    public void setTopMarkerLabelTextStyle(AdvancedTextStyle textStyle) throws IllegalArgumentException {
        if (textStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldValue = this.topMarkerLabelTextStyle;
        this.topMarkerLabelTextStyle = textStyle;
        this.plotModel.setAboveValueTextStyle(textStyle);
        this.firePropertyChange("topMarkerLabelTextStyle", oldValue, textStyle);
    }

    public AdvancedTextStyle getTopMarkerLabelTextStyle() {
        return this.topMarkerLabelTextStyle;
    }

    public void setTopMarkerLabelContent(int newContent) {
        switch (newContent) {
            case 10200: 
            case 10601: 
            case 10604: 
            case 10605: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
        }
        int oldValue = this.topMarkerLabelContent;
        this.plotModel.setAboveContentType(new Integer(newContent));
        this.topMarkerLabelContent = this.plotModel.getAboveContentType();
        this.firePropertyChange("topMarkerLabelContent", oldValue, this.topMarkerLabelContent);
    }

    public int getTopMarkerLabelContent() {
        return this.topMarkerLabelContent;
    }

    public void setBottomMarkerLabelTextStyle(AdvancedTextStyle textStyle) throws IllegalArgumentException {
        if (textStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldValue = this.bottomMarkerLabelTextStyle;
        this.bottomMarkerLabelTextStyle = textStyle;
        this.plotModel.setBelowValueTextStyle(textStyle);
        this.firePropertyChange("bottomMarkerLabelTextStyle", oldValue, textStyle);
    }

    public AdvancedTextStyle getBottomMarkerLabelTextStyle() {
        return this.bottomMarkerLabelTextStyle;
    }

    public void setBottomMarkerLabelContent(int newContent) {
        switch (newContent) {
            case 10200: 
            case 10601: 
            case 10604: 
            case 10605: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
        }
        int oldValue = this.bottomMarkerLabelContent;
        this.plotModel.setBelowContentType(new Integer(newContent));
        this.bottomMarkerLabelContent = this.plotModel.getBelowContentType();
        this.firePropertyChange("bottomMarkerLabelContent", oldValue, this.bottomMarkerLabelContent);
    }

    public int getBottomMarkerLabelContent() {
        return this.bottomMarkerLabelContent;
    }

    public void setMatchMarkerLabelColor(boolean newMatchMarkerLabelColor) {
        boolean oldValue = this.matchMarkerLabelColor;
        this.matchMarkerLabelColor = newMatchMarkerLabelColor;
        this.plotModel.setUseValueColor(new Boolean(!this.matchMarkerLabelColor));
        this.firePropertyChange("matchMarkerLabelColor", oldValue, newMatchMarkerLabelColor);
    }

    public boolean getMatchMarkerLabelColor() {
        return this.matchMarkerLabelColor;
    }

    public boolean isMatchMarkerLabelColor() {
        return this.matchMarkerLabelColor;
    }

    public void setSkipMissing(boolean skipMissingFlag) {
        boolean oldValue = this.skipMissing;
        this.skipMissing = skipMissingFlag;
        this.plotModel.setSkipMissing(new Boolean(skipMissingFlag));
        this.firePropertyChange("skipMissing", oldValue, skipMissingFlag);
    }

    public boolean isSkipMissing() {
        return this.skipMissing;
    }

    public void setUniformEnabled(boolean newUniformEnabled) {
        boolean oldValue = this.uniformEnabled;
        this.uniformEnabled = newUniformEnabled;
        this.plotModel.setUniformEnabled(new Boolean(newUniformEnabled));
        this.firePropertyChange("unifromEnabled", oldValue, newUniformEnabled);
    }

    public boolean isUniformEnabled() {
        return this.uniformEnabled;
    }

    public void setMissingPolicy(int newMissingPolicy) throws IllegalArgumentException {
        GraphConstants.TRI.validate(newMissingPolicy);
        int oldValue = this.missingPolicy;
        this.missingPolicy = newMissingPolicy;
        this.plotModel.setMissingPolicy(new Integer(this.missingPolicy));
        this.firePropertyChange("missingPolicy", oldValue, this.missingPolicy);
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setSkin(int newSkin) throws IllegalArgumentException {
        GraphConstants.SKIN.validate(newSkin);
        int oldValue = this.skin;
        this.skin = newSkin;
        this.plotModel.setSkin(new Integer(this.skin));
        this.firePropertyChange("skin", oldValue, newSkin);
    }

    public int getSkin() {
        return this.skin;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LinePlotModel arg = (LinePlotModel)obj;
        return Util.Evaluate.isEqual(this.interpolationEnabled, arg.interpolationEnabled) && Util.Evaluate.isEqual(this.fillAreaEnabled, arg.fillAreaEnabled) && Util.Evaluate.isEqual(this.markerEnabled, arg.markerEnabled) && Util.Evaluate.isEqual(this.topMarkerLabelContent, arg.topMarkerLabelContent) && Util.Evaluate.isEqual(this.bottomMarkerLabelContent, arg.bottomMarkerLabelContent) && Util.Evaluate.isEqual(this.matchErrorColor, arg.matchErrorColor) && Util.Evaluate.isEqual(this.matchMarkerLabelColor, arg.matchMarkerLabelColor) && Util.Evaluate.isEqual(this.matchNeedleColor, arg.matchNeedleColor) && Util.Evaluate.isEqual(this.skipMissing, arg.skipMissing) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.xAxisBaseline, arg.xAxisBaseline) && Util.Evaluate.isEqual(this.yAxisBaseline, arg.yAxisBaseline) && Util.Evaluate.isEqual(this.y2AxisBaseline, arg.y2AxisBaseline) && Util.Evaluate.isEqual(this.uniformEnabled, arg.uniformEnabled) && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual(this.xAxisModel, arg.xAxisModel) && Util.Evaluate.isEqual(this.yAxisModel, arg.yAxisModel) && Util.Evaluate.isEqual(this.y2AxisModel, arg.y2AxisModel) && Util.Evaluate.isEqual(this.axisWallModel, arg.axisWallModel) && Util.Evaluate.isEqual(this.colorLegendModel, arg.colorLegendModel) && Util.Evaluate.isEqual(this.lineLegendModel, arg.lineLegendModel) && Util.Evaluate.isEqual(this.needleLineStyle, arg.needleLineStyle) && Util.Evaluate.isEqual(this.topMarkerLabelTextStyle, arg.topMarkerLabelTextStyle) && Util.Evaluate.isEqual(this.bottomMarkerLabelTextStyle, arg.bottomMarkerLabelTextStyle) && Util.Evaluate.isEqual(this.skin, arg.skin) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    ScatterPlotModel getScatterPlotModel() {
        return this.plotModel;
    }

    private void _setPlotProperties() {
        this.plotModel.setRowAxisModel(this.rowAxisModel);
        this.plotModel.setColumnAxisModel(this.columnAxisModel);
        this.plotModel.setXAxisModel(this.xAxisModel);
        this.plotModel.setYAxisModel(this.yAxisModel);
        this.plotModel.setY2AxisModel(this.y2AxisModel);
        this.plotModel.setAxisWallModel(this.axisWallModel);
        this.plotModel.setAboveContentType(new Integer(this.topMarkerLabelContent));
        this.plotModel.setBelowContentType(new Integer(this.bottomMarkerLabelContent));
        this.plotModel.setInterpolationEnabled(new Boolean(this.interpolationEnabled));
        this.plotModel.setXAxisBaseline(new Double(this.xAxisBaseline));
        this.plotModel.setYAxisBaseline(new Double(this.yAxisBaseline));
        this.plotModel.setY2AxisBaseline(new Double(this.y2AxisBaseline));
        this.plotModel.setUniformEnabled(new Boolean(this.uniformEnabled));
        this.plotModel.setFillAreaEnabled(new Boolean(this.fillAreaEnabled));
        this.plotModel.setMarkerEnabled(new Boolean(this.markerEnabled));
        this.plotModel.setNeedleLineStyle(this.needleLineStyle);
        this.plotModel.setAboveValueTextStyle(this.topMarkerLabelTextStyle);
        this.plotModel.setBelowValueTextStyle(this.bottomMarkerLabelTextStyle);
        this.plotModel.setSkipMissing(new Boolean(this.skipMissing));
        this.plotModel.setMissingPolicy(new Integer(this.missingPolicy));
        this.plotModel.setUseValueColor(new Boolean(!this.matchMarkerLabelColor));
        this.plotModel.setUseErrorColor(new Boolean(!this.matchErrorColor));
        this.plotModel.setUseNeedleColor(new Boolean(!this.matchNeedleColor));
        this.plotModel.setColorLegendModel(this.colorLegendModel);
        this.plotModel.setElementLegendModel(this.lineLegendModel);
    }
}

