/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.kpichart;

import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.kpichart.KPIChartCustomSkinModel;
import com.sas.graphics.components.kpichart.KPIChartSegmentedRangeColorModel;
import com.sas.graphics.components.kpichart.RB;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

public class KPIChartModel
extends GraphModel {
    public static final String RB_KEY = "KPIChartModel.";
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private KPIChartCustomSkinModel customSkinModel = null;
    private KPIChartSegmentedRangeColorModel segmentedRangeColorModel = null;
    private TextStyle actualLabelTextStyle = new TextStyle();
    private TextStyle actualValueTextStyle = new TextStyle();
    private TextStyle rangeValueTextStyle = new TextStyle();
    private boolean adjustValueMagnitudeEnabled = false;
    private int orientation = 10200;
    private int missingPolicy = 10200;
    private int kpiChartType = 21000;
    private int skin = 10200;
    private static final int _KPICHART_TYPE_ = 21000;
    private static final int _KPICHART_APPEARANCE_ = 21100;
    public static final int KPICHART_TYPE_DIAL = 21000;
    public static final int KPICHART_TYPE_TRAFFIC_LIGHT = 21001;
    public static final int KPICHART_TYPE_BULLET = 21002;
    public static final int KPICHART_TYPE_SLIDER = 21003;
    public static final int KPICHART_TYPE_SPEEDOMETER_FULL = 21004;
    public static final int KPICHART_TYPE_SPEEDOMETER_HALF = 21005;
    public static final int KPICHART_TYPE_SPEEDOMETER_QUARTER = 21006;
    public static final ConstantCollection KPICHART_TYPE = new ConstantCollection(RB.class, "KPIChartModel.", new ConstantCollection.Element[]{new ConstantCollection.Element(21000, "KPICHART_TYPE_DIAL", "Dial"), new ConstantCollection.Element(21001, "KPICHART_TYPE_TRAFFIC_LIGHT", "TrafficLight"), new ConstantCollection.Element(21002, "KPICHART_TYPE_BULLET", "Bullet"), new ConstantCollection.Element(21003, "KPICHART_TYPE_SLIDER", "Slider"), new ConstantCollection.Element(21004, "KPICHART_TYPE_SPEEDOMETER_FULL", "SpeedometerFull"), new ConstantCollection.Element(21005, "KPICHART_TYPE_SPEEDOMETER_HALF", "SpeedometerHalf"), new ConstantCollection.Element(21006, "KPICHART_TYPE_SPEEDOMETER_QUARTER", "SpeedometerQuarter")});
    public static final int KPICHART_APPEARANCE_BASIC = 21100;
    public static final int KPICHART_APPEARANCE_ENHANCED = 21101;
    public static final ConstantCollection KPICHART_APPEARANCE = new ConstantCollection(RB.class, "KPIChartModel.", new ConstantCollection.Element[]{new ConstantCollection.Element(21100, "KPICHART_APPEARANCE_BASIC", "Basic"), new ConstantCollection.Element(21101, "KPICHART_APPEARANCE_ENHANCED", "Enhanced")});

    public void apply(KPIChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.missingPolicy = theOtherModel.missingPolicy;
        this.orientation = theOtherModel.orientation;
        this.kpiChartType = theOtherModel.kpiChartType;
        this.skin = theOtherModel.skin;
        this.actualLabelTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherModel.actualLabelTextStyle, this.actualLabelTextStyle);
        this.actualValueTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherModel.actualValueTextStyle, this.actualValueTextStyle);
        this.rangeValueTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherModel.rangeValueTextStyle, this.rangeValueTextStyle);
        if (theOtherModel.segmentedRangeColorModel == null) {
            this.segmentedRangeColorModel = null;
        } else if (this.segmentedRangeColorModel != null) {
            this.segmentedRangeColorModel.apply(theOtherModel.segmentedRangeColorModel);
        } else {
            SegmentedRangeModel segmentRangeModel = theOtherModel.segmentedRangeColorModel.getSegmentedRangeModel();
            Color[] segmentColors = theOtherModel.segmentedRangeColorModel.getSegmentColors();
            Color[] activeSegmentColors = theOtherModel.segmentedRangeColorModel.getActiveSegmentColors();
            this.segmentedRangeColorModel = new KPIChartSegmentedRangeColorModel(segmentRangeModel, segmentColors, activeSegmentColors);
            this.setContainedModel("segmentedRangeColorModel", this.segmentedRangeColorModel);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.rowAxisModel;
        this.rowAxisModel = newAxis;
        this.firePropertyChange("rowAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.columnAxisModel;
        this.columnAxisModel = newAxis;
        this.firePropertyChange("columnAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public KPIChartModel() {
        this.setAntialiasedGraphics(true);
        this.setContainedModel("rowAxisModel", this.rowAxisModel);
        this.setContainedModel("columnAxisModel", this.columnAxisModel);
        this.setContainedModel("actualLabelTextStyle", this.actualLabelTextStyle);
        this.setContainedModel("actualValueTextStyle", this.actualValueTextStyle);
        this.setContainedModel("rangeValueTextStyle", this.rangeValueTextStyle);
    }

    public void setActualLabelTextStyle(TextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldStyle = this.actualLabelTextStyle;
        this.actualLabelTextStyle = newStyle;
        this.firePropertyChange("actualLabelTextStyle", oldStyle, newStyle);
    }

    public TextStyle getActualLabelTextStyle() {
        return this.actualLabelTextStyle;
    }

    public void setActualValueTextStyle(TextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldStyle = this.actualValueTextStyle;
        this.actualValueTextStyle = newStyle;
        this.firePropertyChange("actualValueTextStyle", oldStyle, newStyle);
    }

    public TextStyle getActualValueTextStyle() {
        return this.actualValueTextStyle;
    }

    public void setRangeValueTextStyle(TextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldStyle = this.rangeValueTextStyle;
        this.rangeValueTextStyle = newStyle;
        this.firePropertyChange("rangeValueTextStyle", oldStyle, newStyle);
    }

    public TextStyle getRangeValueTextStyle() {
        return this.rangeValueTextStyle;
    }

    public void setMissingPolicy(int newMissingPolicy) {
        GraphConstants.TRI.validate(newMissingPolicy);
        int oldValue = this.missingPolicy;
        this.missingPolicy = newMissingPolicy;
        this.firePropertyChange("missingPolicy", oldValue, this.missingPolicy);
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setKPIChartType(int newKPIChartType) throws IllegalArgumentException {
        KPICHART_TYPE.validate(newKPIChartType);
        int oldValue = this.kpiChartType;
        this.kpiChartType = newKPIChartType;
        this.firePropertyChange("KPIChartType", oldValue, this.kpiChartType);
    }

    public int getKPIChartType() {
        return this.kpiChartType;
    }

    public void setKPIChartAppearance(int newKPIChartAppearance) throws IllegalArgumentException {
        if (newKPIChartAppearance == 21100) {
            newKPIChartAppearance = 12300;
        } else if (newKPIChartAppearance == 21101) {
            newKPIChartAppearance = 12301;
        }
        this.setSkin(newKPIChartAppearance);
    }

    public int getKPIChartAppearance() {
        return this.getSkin();
    }

    public void setSkin(int newSkin) throws IllegalArgumentException {
        GraphConstants.SKIN.validate(newSkin);
        int oldValue = this.skin;
        this.skin = newSkin;
        this.firePropertyChange("skin", oldValue, newSkin);
    }

    public int getSkin() {
        return this.skin;
    }

    public void setOrientation(int newOrientation) throws IllegalArgumentException {
        switch (newOrientation) {
            default: {
                throw new IllegalArgumentException(com.sas.graphics.components.RB.getStringResource("unRecognized.ex.txt"));
            }
            case 0: 
            case 1: 
            case 10200: 
        }
        int oldValue = this.orientation;
        this.orientation = newOrientation;
        this.firePropertyChange("orientation", oldValue, newOrientation);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isAdjustValueMagnitudeEnabled() {
        return this.adjustValueMagnitudeEnabled;
    }

    public void setAdjustValueMagnitudeEnabled(boolean adjustValueMagnitudeEnabled) {
        boolean oldValue = this.adjustValueMagnitudeEnabled;
        this.adjustValueMagnitudeEnabled = adjustValueMagnitudeEnabled;
        this.firePropertyChange("adjustValueMagnitudeEnabled", oldValue, adjustValueMagnitudeEnabled);
    }

    public void setSegmentedRangeColorModel(KPIChartSegmentedRangeColorModel kpiChartSegmentedRangeModel) {
        KPIChartSegmentedRangeColorModel oldKPIChartSegmentedRangeColorModel = this.segmentedRangeColorModel;
        this.segmentedRangeColorModel = kpiChartSegmentedRangeModel;
        this.firePropertyChange("kpiChartSegmentedRangeColorModel", oldKPIChartSegmentedRangeColorModel, this.segmentedRangeColorModel);
    }

    public KPIChartSegmentedRangeColorModel getSegmentedRangeColorModel() {
        return this.segmentedRangeColorModel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        KPIChartModel arg = (KPIChartModel)obj;
        return this.missingPolicy == arg.missingPolicy && this.kpiChartType == arg.kpiChartType && this.skin == arg.skin && this.orientation == arg.orientation && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual(this.actualLabelTextStyle, arg.actualLabelTextStyle) && Util.Evaluate.isEqual(this.actualValueTextStyle, arg.actualValueTextStyle) && Util.Evaluate.isEqual(this.rangeValueTextStyle, arg.rangeValueTextStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public KPIChartCustomSkinModel getCustomSkinModel() {
        return this.customSkinModel;
    }

    public void setCustomSkinModel(KPIChartCustomSkinModel newCustomSkinModel) {
        KPIChartCustomSkinModel oldValue = this.customSkinModel;
        this.customSkinModel = newCustomSkinModel;
        this.firePropertyChange("customSkinModel", oldValue, newCustomSkinModel);
    }
}

